/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzdn;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzcx;
import com.google.android.gms.measurement.internal.zzcy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class zzea {
    private static volatile zzea zzadk;
    private final String zzadh;
    protected final Clock zzrz;
    private final ExecutorService zzadl;
    private final AppMeasurementSdk zzadm;
    private Map<zzcy, zzd> zzadn;
    private int zzado;
    private boolean zzadp;
    private String zzadq;
    private zzdn zzadr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzea zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzadk != null) return zzadk;
        Class<zzea> clazz = zzea.class;
        synchronized (zzea.class) {
            if (zzadk != null) return zzadk;
            zzadk = new zzea(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzadk;
        }
    }

    public final AppMeasurementSdk zzga() {
        return this.zzadm;
    }

    private zzea(Context context, String string, String string2, String string3, Bundle bundle) {
        this.zzadh = string == null || !zzea.zze(string2, string3) ? "FA" : string;
        this.zzrz = DefaultClock.getInstance();
        this.zzadl = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        Application application = (Application)context.getApplicationContext();
        zzea zzea2 = this;
        if (application == null) {
            Log.w((String)zzea2.zzadh, (String)"Unable to register lifecycle notifications. Application null.");
        } else {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzea2.new zze());
        }
        this.zzadm = new AppMeasurementSdk(this);
        application = context;
        if (!(!zzea.zzf((Context)application) || zzea.zzgb())) {
            this.zzadq = null;
            this.zzadp = true;
            Log.w((String)this.zzadh, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!zzea.zze(string2, string3)) {
            this.zzadq = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzadh, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
                this.zzadp = true;
                return;
            }
            if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzadh, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzadq = string2;
        }
        this.zza(new zzeb(this, context, string2, string3, bundle));
    }

    private static boolean zzf(Context context) {
        try {
            GoogleServices.initialize((Context)context);
            return GoogleServices.getGoogleAppId() != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static boolean zze(String string, String string2) {
        return string2 != null && string != null && !zzea.zzgb();
    }

    private final void zza(zzb zzb2) {
        this.zzadl.execute(zzb2);
    }

    protected final zzdn zzg(Context context) {
        try {
            return zzdo.asInterface(DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    private static int zzh(Context context) {
        return DynamiteModule.getRemoteVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private static int zzi(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzadp |= bl;
        if (bl) {
            Log.w((String)this.zzadh, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzc(5, string, exception, null, null);
        }
        Log.w((String)this.zzadh, (String)string, (Throwable)exception);
    }

    private static boolean zzgb() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final void zza(zzcx zzcx2) {
        this.zza(new zzei(this, zzcx2));
    }

    public final void zza(zzcy zzcy2) {
        this.zza(new zzes(this, zzcy2));
    }

    public final void zzb(zzcy zzcy2) {
        this.zza(new zzet(this, zzcy2));
    }

    public final void logEventInternal(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        this.zza(new zzeu(this, l, string, string2, bundle, true, bl2));
    }

    public final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(new zzev(this, string, string2, object, true));
    }

    public final void setConditionalUserProperty(Bundle bundle) {
        this.zza(new zzew(this, bundle));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(new zzec(this, string, string2, bundle));
    }

    public final List<Bundle> getConditionalUserProperties(String string, String string2) {
        zza zza2 = new zza();
        this.zza(new zzed(this, string, string2, zza2));
        zza zza3 = zza2;
        List list = zza3.zza(zza3.zzl(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void setCurrentScreen(Activity activity, String string, String string2) {
        this.zza(new zzee(this, activity, string, string2));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zza(new zzef(this, bl));
    }

    public final void beginAdUnitExposure(String string) {
        this.zza(new zzeg(this, string));
    }

    public final void endAdUnitExposure(String string) {
        this.zza(new zzeh(this, string));
    }

    public final String getGmpAppId() {
        zza zza2 = new zza();
        this.zza(new zzej(this, zza2));
        return zza2.zzk(500L);
    }

    public final String zzgc() {
        zza zza2 = new zza();
        this.zza(new zzek(this, zza2));
        return zza2.zzk(50L);
    }

    public final long generateEventId() {
        zza zza2 = new zza();
        this.zza(new zzel(this, zza2));
        Object object = zza2;
        Long l = object.zza(object.zzl(500L), Long.class);
        if (l == null) {
            object = this;
            return new Random(System.nanoTime() ^ ((zzea)object).zzrz.currentTimeMillis()).nextLong() + (long)(++((zzea)object).zzado);
        }
        return l;
    }

    public final String getCurrentScreenName() {
        zza zza2 = new zza();
        this.zza(new zzem(this, zza2));
        return zza2.zzk(500L);
    }

    public final String getCurrentScreenClass() {
        zza zza2 = new zza();
        this.zza(new zzen(this, zza2));
        return zza2.zzk(500L);
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        zza zza2 = new zza();
        this.zza(new zzeo(this, string, string2, bl, zza2));
        Bundle bundle = zza2.zzl(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    public final void zzc(int n, String string, Object object, Object object2, Object object3) {
        this.zza(new zzep(this, false, 5, string, object, object2, object3));
    }

    public final Bundle zza(Bundle bundle, boolean bl) {
        zza zza2 = new zza();
        this.zza(new zzeq(this, bundle, zza2));
        if (bl) {
            return zza2.zzl(5000L);
        }
        return null;
    }

    public final int getMaxUserProperties(String string) {
        zza zza2 = new zza();
        this.zza(new zzer(this, string, zza2));
        zza zza3 = zza2;
        Integer n = zza3.zza(zza3.zzl(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final String getAppIdOrigin() {
        return this.zzadq;
    }

    static /* synthetic */ Map zza(zzea zzea2, Map map) {
        zzea2.zzadn = map;
        return zzea2.zzadn;
    }

    static /* synthetic */ zzdn zza(zzea zzea2, zzdn zzdn2) {
        zzea2.zzadr = zzdn2;
        return zzea2.zzadr;
    }

    static /* synthetic */ zzdn zzb(zzea zzea2) {
        return zzea2.zzadr;
    }

    static /* synthetic */ boolean zza(zzea zzea2, String string, String string2) {
        return zzea.zze(string, string2);
    }

    static /* synthetic */ int zzj(Context context) {
        return zzea.zzi(context);
    }

    static /* synthetic */ int zzk(Context context) {
        return zzea.zzh(context);
    }

    static /* synthetic */ Map zzd(zzea zzea2) {
        return zzea2.zzadn;
    }

    final class zze
    implements Application.ActivityLifecycleCallbacks {
        zze() {
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
            zzea.this.zza(new zzex(this, activity, bundle));
        }

        public final void onActivityStarted(Activity activity) {
            zzea.this.zza(new zzey(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzea.this.zza(new zzez(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzea.this.zza(new zzfa(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzea.this.zza(new zzfb(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zza zza2 = new zza();
            zzea.this.zza(new zzfc(this, activity, zza2));
            Bundle bundle2 = zza2.zzl(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityDestroyed(Activity activity) {
            zzea.this.zza(new zzfd(this, activity));
        }
    }

    static final class zzc
    extends zzdu {
        private final zzcx zzaex;

        zzc(zzcx zzcx2) {
            this.zzaex = zzcx2;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzaex.interceptEvent(string, string2, bundle, l);
        }

        @Override
        public final int id() {
            return this.zzaex.hashCode();
        }
    }

    static final class zzd
    extends zzdu {
        private final zzcy zzaey;

        zzd(zzcy zzcy2) {
            this.zzaey = zzcy2;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzaey.onEvent(string, string2, bundle, l);
        }

        @Override
        public final int id() {
            return this.zzaey.hashCode();
        }
    }

    final class zza
    extends zzdr {
        private final AtomicReference<Bundle> zzaet = new AtomicReference();
        private boolean zzaeu;

        zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzb(Bundle bundle) {
            AtomicReference<Bundle> atomicReference = this.zzaet;
            synchronized (atomicReference) {
                try {
                    this.zzaet.set(bundle);
                    this.zzaeu = true;
                }
                finally {
                    this.zzaet.notify();
                }
                return;
            }
        }

        final String zzk(long l) {
            return this.zza(this.zzl(l), String.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Bundle zzl(long l) {
            AtomicReference<Bundle> atomicReference = this.zzaet;
            synchronized (atomicReference) {
                if (!this.zzaeu) {
                    try {
                        this.zzaet.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return this.zzaet.get();
            }
        }

        final <T> T zza(Bundle bundle, Class<T> clazz) {
            if (bundle != null) {
                Object object = bundle.get("r");
                try {
                    if (object != null) {
                        return clazz.cast(object);
                    }
                    return null;
                }
                catch (ClassCastException classCastException) {
                    String string = "Unexpected object type. Expected, Received";
                    String string2 = clazz.getCanonicalName();
                    String string3 = object.getClass().getCanonicalName();
                    zzea.this.zzc(5, string, string2, string3, classCastException);
                    Log.w((String)zzea.this.zzadh, (String)String.format(String.valueOf(string).concat(": %s, %s"), string2, string3), (Throwable)classCastException);
                    throw classCastException;
                }
            }
            return null;
        }
    }

    abstract class zzb
    implements Runnable {
        final long timestamp;
        final long zzaev;
        private final boolean zzaew;

        zzb() {
            this(true);
        }

        zzb(boolean bl) {
            this.timestamp = zzea.this.zzrz.currentTimeMillis();
            this.zzaev = zzea.this.zzrz.elapsedRealtime();
            this.zzaew = bl;
        }

        @Override
        public void run() {
            if (zzea.this.zzadp) {
                this.zzge();
                return;
            }
            try {
                this.zzgd();
                return;
            }
            catch (Exception exception) {
                zzea.this.zza(exception, false, this.zzaew);
                this.zzge();
                return;
            }
        }

        protected void zzge() {
        }

        abstract void zzgd() throws RemoteException;
    }
}

