/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzbc;
import com.google.android.gms.internal.measurement.zzbd;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzbf;
import com.google.android.gms.internal.measurement.zzbg;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzbi;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzbl;
import com.google.android.gms.internal.measurement.zzbm;
import com.google.android.gms.internal.measurement.zzbn;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.internal.measurement.zzq;
import com.google.android.gms.internal.measurement.zzr;
import com.google.android.gms.internal.measurement.zzw;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzha;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class zzac {
    private static volatile zzac zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    private List<Pair<zzha, zzb>> zzf;
    private int zzg;
    private static Boolean zzh;
    private static Boolean zzi;
    private static boolean zzj;
    private static Boolean zzk;
    @VisibleForTesting
    private static String zzl;
    @VisibleForTesting
    private static String zzm;
    private static boolean zzn;
    private static boolean zzo;
    private boolean zzp;
    private String zzq;
    private zzr zzr;

    public static zzac zza(@NonNull Context context) {
        return zzac.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzac zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzac> clazz = zzac.class;
        synchronized (zzac.class) {
            if (zzb != null) return zzb;
            zzb = new zzac(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    public final AppMeasurementSdk zza() {
        return this.zze;
    }

    private zzac(Context context, String string, String string2, String string3, Bundle bundle) {
        this.zzc = string == null || !zzac.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        this.zzd = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.zze = new AppMeasurementSdk(this);
        Context context2 = context;
        if (!(!zzac.zzf(context2) || zzac.zzk())) {
            this.zzq = null;
            this.zzp = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!zzac.zzc(string2, string3)) {
            this.zzq = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzq = string2;
        }
        this.zza(new zzaf(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzac zzac2 = this;
        if (context2 == null) {
            Log.w((String)zzac2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzac2.new zzd());
    }

    private static boolean zzf(Context context) {
        try {
            String string = "google_app_id";
            Context context2 = context;
            return new StringResourceValueReader(context2).getString(string) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static boolean zzc(String string, String string2) {
        return string2 != null && string != null && !zzac.zzk();
    }

    private final void zza(zza zza2) {
        this.zzd.execute(zza2);
    }

    protected final zzr zza(Context context, boolean bl) {
        try {
            return com.google.android.gms.internal.measurement.zzq.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)(bl ? DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION : DynamiteModule.PREFER_LOCAL), (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    private static int zzg(Context context) {
        return DynamiteModule.getRemoteVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private static int zzh(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzp |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    private static boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final void zza(zzgx zzgx2) {
        this.zza(new zzao(this, zzgx2));
    }

    public final void zza(zzha zzha2) {
        Preconditions.checkNotNull((Object)zzha2);
        this.zza(new zzbb(this, zzha2));
    }

    public final void zzb(zzha zzha2) {
        Preconditions.checkNotNull((Object)zzha2);
        this.zza(new zzbc(this, zzha2));
    }

    public final void zza(@NonNull String string, Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zza(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        this.zza(new zzbf(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(String string, String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(String string, String string2, Object object) {
        this.zza(string, string2, object, true);
    }

    private final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(new zzbe(this, string, string2, object, bl));
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzbg(this, bundle));
    }

    public final void zzb(String string, String string2, Bundle bundle) {
        this.zza(new zzae(this, string, string2, bundle));
    }

    public final List<Bundle> zzb(String string, String string2) {
        zzp zzp2 = new zzp();
        this.zza(new zzah(this, string, string2, zzp2));
        List list = (List)com.google.android.gms.internal.measurement.zzp.zza((Bundle)zzp2.zzb(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void zza(String string) {
        this.zza(new zzag(this, string));
    }

    public final void zza(Activity activity, String string, String string2) {
        this.zza(new zzaj(this, activity, string, string2));
    }

    public final void zza(boolean bl) {
        this.zza(new zzai(this, bl));
    }

    public final void zzb() {
        this.zza(new zzal(this));
    }

    public final void zza(long l) {
        this.zza(new zzak(this, l));
    }

    public final void zzb(long l) {
        this.zza(new zzan(this, l));
    }

    public final void zzb(String string) {
        this.zza(new zzam(this, string));
    }

    public final void zzc(String string) {
        this.zza(new zzap(this, string));
    }

    public final String zzc() {
        zzp zzp2 = new zzp();
        this.zza(new zzar(this, zzp2));
        return zzp2.zza(500L);
    }

    public final String zzd() {
        zzp zzp2 = new zzp();
        this.zza(new zzaq(this, zzp2));
        return zzp2.zza(50L);
    }

    public final long zze() {
        zzp zzp2 = new zzp();
        this.zza(new zzat(this, zzp2));
        Long l = (Long)com.google.android.gms.internal.measurement.zzp.zza((Bundle)zzp2.zzb(500L), Long.class);
        if (l == null) {
            zzac zzac2 = this;
            return new Random(System.nanoTime() ^ zzac2.zza.currentTimeMillis()).nextLong() + (long)(++zzac2.zzg);
        }
        return l;
    }

    public final String zzf() {
        zzp zzp2 = new zzp();
        this.zza(new zzas(this, zzp2));
        return zzp2.zza(500L);
    }

    public final String zzg() {
        zzp zzp2 = new zzp();
        this.zza(new zzav(this, zzp2));
        return zzp2.zza(500L);
    }

    public final Map<String, Object> zza(String string, String string2, boolean bl) {
        zzp zzp2 = new zzp();
        this.zza(new zzau(this, string, string2, bl, zzp2));
        Bundle bundle = zzp2.zzb(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    public final void zza(int n, String string, Object object, Object object2, Object object3) {
        this.zza(new zzax(this, false, 5, string, object, null, null));
    }

    public final Bundle zza(Bundle bundle, boolean bl) {
        zzp zzp2 = new zzp();
        this.zza(new zzaw(this, bundle, zzp2));
        if (bl) {
            return zzp2.zzb(5000L);
        }
        return null;
    }

    public final int zzd(String string) {
        zzp zzp2 = new zzp();
        this.zza(new zzaz(this, string, zzp2));
        Integer n = (Integer)com.google.android.gms.internal.measurement.zzp.zza((Bundle)zzp2.zzb(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    @WorkerThread
    public final String zzh() {
        zzp zzp2 = new zzp();
        this.zza(new zzay(this, zzp2));
        return zzp2.zza(120000L);
    }

    public final String zzi() {
        return this.zzq;
    }

    public final Object zza(int n) {
        zzp zzp2 = new zzp();
        this.zza(new zzba(this, zzp2, n));
        return com.google.android.gms.internal.measurement.zzp.zza((Bundle)zzp2.zzb(15000L), Object.class);
    }

    public final void zzb(boolean bl) {
        this.zza(new zzbd(this, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzi(Context context) {
        Class<zzac> clazz = zzac.class;
        synchronized (zzac.class) {
            try {
                if (zzh != null && zzi != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (zzac.zza(context, "app_measurement_internal_disable_startup_flags")) {
                    zzh = zzn;
                    zzi = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
                zzh = sharedPreferences.getBoolean(zzl, zzn);
                zzi = sharedPreferences.getBoolean(zzm, false);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.remove(zzl);
                editor.remove(zzm);
                editor.apply();
            }
            catch (Exception exception) {
                Log.e((String)"FA", (String)"Exception reading flag from SharedPreferences.", (Throwable)exception);
                zzh = zzn;
                zzi = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzb(Context context) {
        zzac.zzi(context);
        Class<zzac> clazz = zzac.class;
        synchronized (zzac.class) {
            block9: {
                if (zzj) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    break block9;
                }
                try {
                    String string = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "measurement.dynamite.enabled", "");
                    zzk = "true".equals(string) ? Boolean.valueOf(true) : ("false".equals(string) ? Boolean.valueOf(false) : null);
                }
                catch (Exception exception) {
                    Log.e((String)"FA", (String)"Unable to call SystemProperties.get()", (Throwable)exception);
                    zzk = null;
                }
                finally {
                    zzj = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            return zzk == null ? zzh : zzk;
        }
    }

    private static boolean zza(Context context, @Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)context).getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo == null || applicationInfo.metaData == null) {
                return false;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ List zza(zzac zzac2, List list) {
        zzac2.zzf = list;
        return zzac2.zzf;
    }

    static /* synthetic */ boolean zza(zzac zzac2, String string, String string2) {
        return zzac.zzc(string, string2);
    }

    static /* synthetic */ String zzb(zzac zzac2) {
        return zzac2.zzc;
    }

    static /* synthetic */ void zzc(Context context) {
        zzac.zzi(context);
    }

    static /* synthetic */ Boolean zzj() {
        return zzi;
    }

    static /* synthetic */ zzr zza(zzac zzac2, zzr zzr2) {
        zzac2.zzr = zzr2;
        return zzac2.zzr;
    }

    static /* synthetic */ zzr zzc(zzac zzac2) {
        return zzac2.zzr;
    }

    static /* synthetic */ int zzd(Context context) {
        return zzac.zzh(context);
    }

    static /* synthetic */ int zze(Context context) {
        return zzac.zzg(context);
    }

    static /* synthetic */ List zzd(zzac zzac2) {
        return zzac2.zzf;
    }

    static {
        zzh = null;
        zzi = null;
        zzj = false;
        zzk = null;
        zzl = "use_dynamite_api";
        zzm = "allow_remote_dynamite";
        zzn = true;
        zzo = false;
    }

    final class zzd
    implements Application.ActivityLifecycleCallbacks {
        zzd() {
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
            zzac.this.zza(new zzbh(this, activity, bundle));
        }

        public final void onActivityStarted(Activity activity) {
            zzac.this.zza(new zzbj(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzac.this.zza(new zzbi(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzac.this.zza(new zzbl(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzac.this.zza(new zzbk(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzp zzp2 = new zzp();
            zzac.this.zza(new zzbn(this, activity, zzp2));
            Bundle bundle2 = zzp2.zzb(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityDestroyed(Activity activity) {
            zzac.this.zza(new zzbm(this, activity));
        }
    }

    static final class zzc
    extends zzw {
        private final zzgx zza;

        zzc(zzgx zzgx2) {
            this.zza = zzgx2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }

        public final int zza() {
            return System.identityHashCode(this.zza);
        }
    }

    static final class zzb
    extends zzw {
        private final zzha zza;

        zzb(zzha zzha2) {
            this.zza = zzha2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }

        public final int zza() {
            return System.identityHashCode(this.zza);
        }
    }

    abstract class zza
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zza() {
            this(true);
        }

        zza(boolean bl) {
            this.zza = zzac.this.zza.currentTimeMillis();
            this.zzb = zzac.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        @Override
        public void run() {
            if (zzac.this.zzp) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzac.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        protected void zzb() {
        }

        abstract void zza() throws RemoteException;
    }
}

