/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzbc;
import com.google.android.gms.internal.measurement.zzbd;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzbf;
import com.google.android.gms.internal.measurement.zzbg;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzbi;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzbl;
import com.google.android.gms.internal.measurement.zzbm;
import com.google.android.gms.internal.measurement.zzbn;
import com.google.android.gms.internal.measurement.zzbo;
import com.google.android.gms.internal.measurement.zzbp;
import com.google.android.gms.internal.measurement.zzbq;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzi;
import com.google.android.gms.internal.measurement.zzr;
import com.google.android.gms.internal.measurement.zzt;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;

public class zzag {
    private static volatile zzag zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    private List<Pair<zzha, zzd>> zzf;
    private int zzg;
    private static Boolean zzh;
    @VisibleForTesting
    private static String zzi;
    private static boolean zzj;
    private boolean zzk;
    private String zzl;
    private zzv zzm;

    public static zzag zza(@NonNull Context context) {
        return zzag.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzag zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzag> clazz = zzag.class;
        synchronized (zzag.class) {
            if (zzb != null) return zzb;
            zzb = new zzag(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    public final AppMeasurementSdk zza() {
        return this.zze;
    }

    private zzag(Context context, String string, String string2, String string3, Bundle bundle) {
        this.zzc = string == null || !zzag.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        zzag zzag2 = this;
        this.zzd = com.google.android.gms.internal.measurement.zzi.zza().zza(new zzas(zzag2), zzr.zza);
        this.zze = new AppMeasurementSdk(this);
        Context context2 = context;
        if (!(!zzag.zze(context2) || zzag.zzk())) {
            this.zzl = null;
            this.zzk = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!zzag.zzc(string2, string3)) {
            this.zzl = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzl = string2;
        }
        this.zza(new zzaj(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzag2 = this;
        if (context2 == null) {
            Log.w((String)zzag2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzag2.new zzc());
    }

    private static boolean zze(Context context) {
        try {
            String string = "google_app_id";
            Context context2 = context;
            return new StringResourceValueReader(context2).getString(string) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static boolean zzc(String string, String string2) {
        return string2 != null && string != null && !zzag.zzk();
    }

    private final void zza(zzb zzb2) {
        this.zzd.execute(zzb2);
    }

    protected final zzv zza(Context context, boolean bl) {
        try {
            return zzu.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)(bl ? DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION : DynamiteModule.PREFER_LOCAL), (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    private static int zzf(Context context) {
        return DynamiteModule.getRemoteVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private static int zzg(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzk |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    private static boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final void zza(zzhb zzhb2) {
        this.zza(new zzbf(this, zzhb2));
    }

    public final void zza(zzha zzha2) {
        Preconditions.checkNotNull((Object)zzha2);
        this.zza(new zzbj(this, zzha2));
    }

    public final void zzb(zzha zzha2) {
        Preconditions.checkNotNull((Object)zzha2);
        this.zza(new zzbi(this, zzha2));
    }

    public final void zza(@NonNull String string, Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zza(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        this.zza(new zzbl(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(String string, String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(String string, String string2, Object object) {
        this.zza(string, string2, object, true);
    }

    private final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(new zzbk(this, string, string2, object, bl));
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzai(this, bundle));
    }

    public final void zzb(String string, String string2, Bundle bundle) {
        this.zza(new zzal(this, string, string2, bundle));
    }

    public final List<Bundle> zzb(String string, String string2) {
        zzt zzt2 = new zzt();
        this.zza(new zzak(this, string, string2, zzt2));
        List list = (List)zzt.zza((Bundle)zzt2.zzb(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void zza(String string) {
        this.zza(new zzan(this, string));
    }

    public final void zza(Activity activity, String string, String string2) {
        this.zza(new zzam(this, activity, string, string2));
    }

    public final void zza(boolean bl) {
        this.zza(new zzap(this, bl));
    }

    public final void zzb() {
        this.zza(new zzao(this));
    }

    public final void zza(long l) {
        this.zza(new zzar(this, l));
    }

    public final void zzb(long l) {
        this.zza(new zzaq(this, l));
    }

    public final void zzb(String string) {
        this.zza(new zzat(this, string));
    }

    public final void zzc(String string) {
        this.zza(new zzav(this, string));
    }

    public final String zzc() {
        zzt zzt2 = new zzt();
        this.zza(new zzau(this, zzt2));
        return zzt2.zza(500L);
    }

    public final String zzd() {
        zzt zzt2 = new zzt();
        this.zza(new zzax(this, zzt2));
        return zzt2.zza(50L);
    }

    public final long zze() {
        zzt zzt2 = new zzt();
        this.zza(new zzaw(this, zzt2));
        Long l = (Long)zzt.zza((Bundle)zzt2.zzb(500L), Long.class);
        if (l == null) {
            zzag zzag2 = this;
            return new Random(System.nanoTime() ^ zzag2.zza.currentTimeMillis()).nextLong() + (long)(++zzag2.zzg);
        }
        return l;
    }

    public final String zzf() {
        zzt zzt2 = new zzt();
        this.zza(new zzaz(this, zzt2));
        return zzt2.zza(500L);
    }

    public final String zzg() {
        zzt zzt2 = new zzt();
        this.zza(new zzay(this, zzt2));
        return zzt2.zza(500L);
    }

    public final Map<String, Object> zza(String string, String string2, boolean bl) {
        zzt zzt2 = new zzt();
        this.zza(new zzbb(this, string, string2, bl, zzt2));
        Bundle bundle = zzt2.zzb(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    public final void zza(int n, String string, Object object, Object object2, Object object3) {
        this.zza(new zzba(this, false, 5, string, object, null, null));
    }

    public final Bundle zza(Bundle bundle, boolean bl) {
        zzt zzt2 = new zzt();
        this.zza(new zzbd(this, bundle, zzt2));
        if (bl) {
            return zzt2.zzb(5000L);
        }
        return null;
    }

    public final int zzd(String string) {
        zzt zzt2 = new zzt();
        this.zza(new zzbc(this, string, zzt2));
        Integer n = (Integer)zzt.zza((Bundle)zzt2.zzb(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    @WorkerThread
    public final String zzh() {
        zzt zzt2 = new zzt();
        this.zza(new zzbe(this, zzt2));
        return zzt2.zza(120000L);
    }

    public final String zzi() {
        return this.zzl;
    }

    public final Object zza(int n) {
        zzt zzt2 = new zzt();
        this.zza(new zzbh(this, zzt2, n));
        return zzt.zza((Bundle)zzt2.zzb(15000L), Object.class);
    }

    public final void zzb(boolean bl) {
        this.zza(new zzbg(this, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzh(Context context) {
        Class<zzag> clazz = zzag.class;
        synchronized (zzag.class) {
            try {
                if (zzh != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (zzag.zza(context, "app_measurement_internal_disable_startup_flags")) {
                    zzh = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
                zzh = sharedPreferences.getBoolean(zzi, false);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.remove(zzi);
                editor.apply();
            }
            catch (Exception exception) {
                Log.e((String)"FA", (String)"Exception reading flag from SharedPreferences.", (Throwable)exception);
                zzh = false;
            }
            return;
        }
    }

    private static boolean zza(Context context, @Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)context).getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo == null || applicationInfo.metaData == null) {
                return false;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ List zza(zzag zzag2, List list) {
        zzag2.zzf = list;
        return zzag2.zzf;
    }

    static /* synthetic */ boolean zza(zzag zzag2, String string, String string2) {
        return zzag.zzc(string, string2);
    }

    static /* synthetic */ String zzb(zzag zzag2) {
        return zzag2.zzc;
    }

    static /* synthetic */ void zzb(Context context) {
        zzag.zzh(context);
    }

    static /* synthetic */ Boolean zzj() {
        return zzh;
    }

    static /* synthetic */ zzv zza(zzag zzag2, zzv zzv2) {
        zzag2.zzm = zzv2;
        return zzag2.zzm;
    }

    static /* synthetic */ zzv zzc(zzag zzag2) {
        return zzag2.zzm;
    }

    static /* synthetic */ int zzc(Context context) {
        return zzag.zzg(context);
    }

    static /* synthetic */ int zzd(Context context) {
        return zzag.zzf(context);
    }

    static /* synthetic */ List zzd(zzag zzag2) {
        return zzag2.zzf;
    }

    static {
        zzh = null;
        zzi = "allow_remote_dynamite";
        zzj = false;
    }

    final class zzc
    implements Application.ActivityLifecycleCallbacks {
        zzc() {
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
            zzag.this.zza(new zzbn(this, activity, bundle));
        }

        public final void onActivityStarted(Activity activity) {
            zzag.this.zza(new zzbm(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzag.this.zza(new zzbp(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzag.this.zza(new zzbo(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzag.this.zza(new zzbr(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzt zzt2 = new zzt();
            zzag.this.zza(new zzbq(this, activity, zzt2));
            Bundle bundle2 = zzt2.zzb(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityDestroyed(Activity activity) {
            zzag.this.zza(new zzbs(this, activity));
        }
    }

    static final class zza
    extends zzaa {
        private final zzhb zza;

        zza(zzhb zzhb2) {
            this.zza = zzhb2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }

        public final int zza() {
            return System.identityHashCode(this.zza);
        }
    }

    static final class zzd
    extends zzaa {
        private final zzha zza;

        zzd(zzha zzha2) {
            this.zza = zzha2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }

        public final int zza() {
            return System.identityHashCode(this.zza);
        }
    }

    abstract class zzb
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zzb() {
            this(true);
        }

        zzb(boolean bl) {
            this.zza = zzag.this.zza.currentTimeMillis();
            this.zzb = zzag.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        @Override
        public void run() {
            if (zzag.this.zzk) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzag.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        protected void zzb() {
        }

        abstract void zza() throws RemoteException;
    }
}

