/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzbc;
import com.google.android.gms.internal.measurement.zzbd;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzbf;
import com.google.android.gms.internal.measurement.zzbg;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzbi;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzl;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.internal.measurement.zzq;
import com.google.android.gms.internal.measurement.zzw;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;

public final class zzbs {
    private static volatile zzbs zzc;
    private final String zzd;
    protected final Clock zza;
    protected final ExecutorService zzb;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zzgq, zzbj>> zzf;
    private int zzg;
    private boolean zzh;
    private final String zzi;
    private volatile zzq zzj;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzbs zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzc != null) return zzc;
        Class<zzbs> clazz = zzbs.class;
        synchronized (clazz) {
            zzbs zzbs2 = zzc;
            if (zzbs2 != null) return zzc;
            zzc = zzbs2 = new zzbs(context, string, string2, string3, bundle);
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected zzbs(Context context, String object, String string, String string2, Bundle bundle) {
        block8: {
            block7: {
                this.zzd = object == null || !zzbs.zzV(string, string2) ? "FA" : object;
                this.zza = DefaultClock.getInstance();
                object = zzl.zza();
                zzaw zzaw2 = new zzaw(this);
                this.zzb = object.zzb(zzaw2, 1);
                this.zze = object = new AppMeasurementSdk(this);
                object = new ArrayList();
                this.zzf = object;
                try {
                    object = zzfh.zza((Context)context);
                    object = zzhx.zza((Context)context, (String)"google_app_id", (String)object);
                }
                catch (IllegalStateException illegalStateException) {}
                if (object != null && !zzbs.zzR()) {
                    this.zzi = null;
                    this.zzh = true;
                    Log.w((String)this.zzd, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
                    return;
                }
                if (zzbs.zzV(string, string2)) break block7;
                this.zzi = "fa";
                if (string != null && string2 != null) {
                    Log.v((String)this.zzd, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
                    break block8;
                } else {
                    boolean bl;
                    boolean bl2 = string == null;
                    if (bl2 ^ (bl = string2 == null)) {
                        Log.w((String)this.zzd, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
                    }
                }
                break block8;
            }
            this.zzi = string;
        }
        Object object2 = new zzal(this, string, string2, context, bundle);
        this.zzS((zzbh)object2);
        context = (Application)context.getApplicationContext();
        if (context == null) {
            Log.w((String)this.zzd, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        object2 = new zzbr(this);
        context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)object2);
    }

    private final void zzS(zzbh zzbh2) {
        this.zzb.execute(zzbh2);
    }

    protected final zzq zzc(Context context, boolean bl) {
        try {
            context = DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService");
            context = zzp.asInterface((IBinder)context);
            return context;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zzT((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    private final void zzT(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzd, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzC(5, string, exception, null, null);
        }
        Log.w((String)this.zzd, (String)string, (Throwable)exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzd(zzgp object) {
        zzbi zzbi2 = new zzbi((zzgp)object);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzw)zzbi2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzbc zzbc2 = new zzbc(this, zzbi2);
        this.zzS(zzbc2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zze(zzgq object) {
        int n;
        Preconditions.checkNotNull((Object)object);
        List<Pair<zzgq, zzbj>> list = this.zzf;
        // MONITORENTER : list
        for (int i = 0; i < (n = this.zzf.size()); ++i) {
            n = object.equals(this.zzf.get((int)i).first) ? 1 : 0;
            if (n == 0) continue;
            Log.w((String)this.zzd, (String)"OnEventListener already registered.");
            // MONITOREXIT : list
            return;
        }
        zzbj zzbj2 = new zzbj((zzgq)object);
        List<Pair<zzgq, zzbj>> list2 = this.zzf;
        Pair pair = new Pair(object, (Object)zzbj2);
        list2.add((Pair<zzgq, zzbj>)pair);
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzw)zzbj2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        object = new zzbd(this, zzbj2);
        this.zzS((zzbh)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzf(zzgq object) {
        block8: {
            int n;
            Preconditions.checkNotNull(object);
            List<Pair<zzgq, zzbj>> list = this.zzf;
            // MONITORENTER : list
            for (int i = 0; i < (n = this.zzf.size()); ++i) {
                n = object.equals(this.zzf.get((int)i).first) ? 1 : 0;
                if (n == 0) continue;
                object = this.zzf.get(i);
                break block8;
            }
            object = null;
        }
        if (object == null) {
            Log.w((String)this.zzd, (String)"OnEventListener had not been registered.");
            // MONITOREXIT : list
            return;
        }
        this.zzf.remove(object);
        object = (zzbj)((Object)object.second);
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener(object);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzbe zzbe2 = new zzbe(this, (zzbj)((Object)object));
        this.zzS(zzbe2);
    }

    public final void zzg(@NonNull String string, Bundle bundle) {
        this.zzU(null, string, bundle, false, true, null);
    }

    public final void zzh(String string, String string2, Bundle bundle) {
        this.zzU(string, string2, bundle, true, true, null);
    }

    public final void zzi(String string, String string2, Bundle bundle, long l) {
        this.zzU(string, string2, bundle, true, false, l);
    }

    private final void zzU(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        zzbf zzbf2 = new zzbf(this, l, string, string2, bundle, bl, bl2);
        this.zzS(zzbf2);
    }

    public final void zzj(String string, String string2, Object object, boolean bl) {
        zzbg zzbg2 = new zzbg(this, string, string2, object, bl);
        this.zzS(zzbg2);
    }

    public final void zzk(Bundle bundle) {
        zzab zzab2 = new zzab(this, bundle);
        this.zzS(zzab2);
    }

    public final void zzl(String string, String string2, Bundle bundle) {
        zzac zzac2 = new zzac(this, string, string2, bundle);
        this.zzS(zzac2);
    }

    public final List<Bundle> zzm(String string, String string2) {
        zzn zzn2 = new zzn();
        zzad zzad2 = new zzad((zzbs)((Object)list), string, string2, zzn2);
        ((zzbs)((Object)list)).zzS(zzad2);
        List list = (List)zzn.zze((Bundle)zzn2.zzd(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void zzn(String string) {
        zzae zzae2 = new zzae(this, string);
        this.zzS(zzae2);
    }

    public final void zzo(Activity activity, String string, String string2) {
        zzaf zzaf2 = new zzaf(this, activity, string, string2);
        this.zzS(zzaf2);
    }

    public final void zzp(Boolean bl) {
        zzag zzag2 = new zzag(this, bl);
        this.zzS(zzag2);
    }

    public final void zzq(Bundle bundle) {
        zzah zzah2 = new zzah(this, bundle);
        this.zzS(zzah2);
    }

    public final void zzr(Bundle bundle) {
        zzai zzai2 = new zzai(this, bundle);
        this.zzS(zzai2);
    }

    public final void zzs() {
        zzaj zzaj2 = new zzaj(this);
        this.zzS(zzaj2);
    }

    public final void zzt(long l) {
        zzak zzak2 = new zzak(this, l);
        this.zzS(zzak2);
    }

    public final void zzu(String string) {
        zzam zzam2 = new zzam(this, string);
        this.zzS(zzam2);
    }

    public final void zzv(String string) {
        zzan zzan2 = new zzan(this, string);
        this.zzS(zzan2);
    }

    public final String zzw() {
        zzn zzn2 = new zzn();
        zzao zzao2 = new zzao(this, zzn2);
        this.zzS(zzao2);
        return zzn2.zzc(500L);
    }

    public final String zzx() {
        zzn zzn2 = new zzn();
        zzap zzap2 = new zzap(this, zzn2);
        this.zzS(zzap2);
        return zzn2.zzc(50L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long zzy() {
        int n;
        Object object = new zzn();
        zzaq zzaq2 = new zzaq(this, (zzn)object);
        this.zzS(zzaq2);
        object = (Long)zzn.zze((Bundle)object.zzd(500L), Long.class);
        long l = (Long)object;
        if (object != null) return l;
        object = new Random(System.nanoTime() ^ this.zza.currentTimeMillis());
        long l2 = ((Random)object).nextLong();
        this.zzg = n = this.zzg + 1;
        return l2 += (long)n;
    }

    public final String zzz() {
        zzn zzn2 = new zzn();
        zzar zzar2 = new zzar(this, zzn2);
        this.zzS(zzar2);
        return zzn2.zzc(500L);
    }

    public final String zzA() {
        zzn zzn2 = new zzn();
        zzas zzas2 = new zzas(this, zzn2);
        this.zzS(zzas2);
        return zzn2.zzc(500L);
    }

    public final Map<String, Object> zzB(String hashMap, String object, boolean bl) {
        Object object2 = new zzn();
        zzat zzat2 = new zzat(zzbs2, (String)((Object)hashMap), (String)object, bl, (zzn)object2);
        zzbs2.zzS(zzat2);
        zzbs zzbs2 = object2.zzd(5000L);
        if (zzbs2 == null || zzbs2.size() == 0) {
            return Collections.emptyMap();
        }
        hashMap = new HashMap<String, Object>(zzbs2.size());
        for (String string : zzbs2.keySet()) {
            object2 = zzbs2.get(string);
            if (!(object2 instanceof Double) && !(object2 instanceof Long) && !(object2 instanceof String)) continue;
            hashMap.put(string, object2);
        }
        return hashMap;
    }

    public final void zzC(int n, String string, Object object, Object object2, Object object3) {
        zzau zzau2 = new zzau(this, false, 5, string, object, null, null);
        this.zzS(zzau2);
    }

    public final Bundle zzD(Bundle bundle, boolean bl) {
        zzn zzn2 = new zzn();
        zzav zzav2 = new zzav(this, bundle, zzn2);
        this.zzS(zzav2);
        if (bl) {
            return zzn2.zzd(5000L);
        }
        return null;
    }

    public final int zzE(String string) {
        zzn zzn2 = new zzn();
        zzax zzax2 = new zzax((zzbs)((Object)n), string, zzn2);
        ((zzbs)((Object)n)).zzS(zzax2);
        Integer n = (Integer)zzn.zze((Bundle)zzn2.zzd(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    @WorkerThread
    public final String zzF() {
        zzn zzn2 = new zzn();
        zzay zzay2 = new zzay(this, zzn2);
        this.zzS(zzay2);
        return zzn2.zzc(120000L);
    }

    public final String zzG() {
        return this.zzi;
    }

    public final Object zzH(int n) {
        zzn zzn2 = new zzn();
        zzaz zzaz2 = new zzaz(this, zzn2, n);
        this.zzS(zzaz2);
        return zzn.zze((Bundle)zzn2.zzd(15000L), Object.class);
    }

    public final void zzI(boolean bl) {
        zzba zzba2 = new zzba(this, bl);
        this.zzS(zzba2);
    }

    public final void zzJ(Bundle bundle) {
        zzbb zzbb2 = new zzbb(this, bundle);
        this.zzS(zzbb2);
    }

    static /* synthetic */ boolean zzK(zzbs zzbs2) {
        return zzbs2.zzh;
    }

    static /* synthetic */ void zzL(zzbs zzbs2, Exception exception, boolean bl, boolean bl2) {
        zzbs2.zzT(exception, bl, bl2);
    }

    static /* synthetic */ boolean zzM(zzbs zzbs2, String string, String string2) {
        return zzbs.zzV(string, string2);
    }

    static /* synthetic */ String zzN(zzbs zzbs2) {
        return zzbs2.zzd;
    }

    static /* synthetic */ zzq zzO(zzbs zzbs2, zzq zzq2) {
        zzbs2.zzj = zzq2;
        return zzq2;
    }

    static /* synthetic */ zzq zzP(zzbs zzbs2) {
        return zzbs2.zzj;
    }

    static /* synthetic */ void zzQ(zzbs zzbs2, zzbh zzbh2) {
        zzbs2.zzS(zzbh2);
    }

    protected static final boolean zzR() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static final boolean zzV(String string, String string2) {
        return string2 != null && string != null && !zzbs.zzR();
    }
}

