/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.api;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import java.util.List;
import java.util.Map;

@KeepForSdk
@ShowFirstParty
public class AppMeasurementSdk {
    private final zzbs zza;

    @ShowFirstParty
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @RecentlyNonNull
    public static AppMeasurementSdk getInstance(@RecentlyNonNull Context context) {
        return zzbs.zza(context, null, null, null, null).zzb();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @RecentlyNonNull
    public static AppMeasurementSdk getInstance(@RecentlyNonNull Context context, @RecentlyNonNull String logTag, @RecentlyNonNull String origin, @Nullable String customAppId, @RecentlyNonNull Bundle extraParameters) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return zzbs.zza(context, (String)var1_1, (String)var2_2, (String)var3_3, (Bundle)var4_4).zzb();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setMeasurementEnabled(boolean enabled) {
        void var1_1;
        this.zza.zzp((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setMeasurementEnabled(@Nullable Boolean enabled) {
        void var1_1;
        this.zza.zzp((Boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setConsent(@RecentlyNonNull Bundle consentMap) {
        void var1_1;
        this.zza.zzq((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void logEvent(@RecentlyNonNull String origin, @RecentlyNonNull String name, @RecentlyNonNull Bundle params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzh((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void logEventNoInterceptor(@RecentlyNonNull String origin, @RecentlyNonNull String name, @RecentlyNonNull Bundle params, long timestampInMillis) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzi((String)var1_1, (String)var2_2, (Bundle)var3_3, (long)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setUserProperty(@RecentlyNonNull String origin, @RecentlyNonNull String name, @RecentlyNonNull Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzj((String)var1_1, (String)var2_2, var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @WorkerThread
    @RecentlyNonNull
    public Map<String, Object> getUserProperties(@Nullable String origin, @Nullable @Size(min=1L, max=24L) String propertyNamePrefix, boolean includeInternal) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.zza.zzB((String)var1_1, (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setConditionalUserProperty(@RecentlyNonNull Bundle conditionalUserProperty) {
        void var1_1;
        this.zza.zzk((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void clearConditionalUserProperty(@RecentlyNonNull @Size(min=1L, max=24L) String userPropertyName, @Nullable String clearEventName, @Nullable Bundle clearEventParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzl((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @WorkerThread
    @RecentlyNonNull
    public List<Bundle> getConditionalUserProperties(@Nullable String origin, @Nullable @Size(min=1L, max=23L) String propertyNamePrefix) {
        void var2_2;
        void var1_1;
        return this.zza.zzm((String)var1_1, (String)var2_2);
    }

    @RecentlyNullable
    @KeepForSdk
    public String getCurrentScreenName() {
        return this.zza.zzz();
    }

    @RecentlyNullable
    @KeepForSdk
    public String getCurrentScreenClass() {
        return this.zza.zzA();
    }

    @RecentlyNullable
    @KeepForSdk
    public String getAppInstanceId() {
        return this.zza.zzx();
    }

    @RecentlyNullable
    @KeepForSdk
    public String getGmpAppId() {
        return this.zza.zzw();
    }

    @KeepForSdk
    public long generateEventId() {
        return this.zza.zzy();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void beginAdUnitExposure(@RecentlyNonNull @Size(min=1L) String adUnitId) {
        void var1_1;
        this.zza.zzu((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void endAdUnitExposure(@RecentlyNonNull @Size(min=1L) String adUnitId) {
        void var1_1;
        this.zza.zzv((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(@RecentlyNonNull EventInterceptor interceptor) {
        void var1_1;
        this.zza.zzd((zzgp)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(@RecentlyNonNull OnEventListener listener) {
        void var1_1;
        this.zza.zze((zzgq)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(@RecentlyNonNull OnEventListener listener) {
        void var1_1;
        this.zza.zzf((zzgq)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @RecentlyNullable
    public Bundle performActionWithResponse(@RecentlyNonNull Bundle bundle) {
        void var1_1;
        return this.zza.zzD((Bundle)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @RecentlyNullable
    public void performAction(@RecentlyNonNull Bundle bundle) {
        void var1_1;
        this.zza.zzD((Bundle)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@RecentlyNonNull @Size(min=1L) String origin) {
        void var1_1;
        return this.zza.zzE((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setCurrentScreen(@RecentlyNonNull Activity activity, @Size(min=1L, max=36L) @Nullable String screenName, @Size(min=1L, max=36L) @Nullable String screenClassOverride) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzo((Activity)var1_1, (String)var2_2, (String)var3_3);
    }

    @KeepForSdk
    @RecentlyNullable
    public String getAppIdOrigin() {
        return this.zza.zzG();
    }

    public AppMeasurementSdk(zzbs zzbs2) {
        this.zza = zzbs2;
    }

    public final void zza(boolean bl) {
        this.zza.zzI(bl);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzgq {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(@RecentlyNonNull String var1, @RecentlyNonNull String var2, @RecentlyNonNull Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzgp {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(@RecentlyNonNull String var1, @RecentlyNonNull String var2, @RecentlyNonNull Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class ConditionalUserProperty {
        @KeepForSdk
        @RecentlyNonNull
        public static final String ORIGIN = "origin";
        @KeepForSdk
        @RecentlyNonNull
        public static final String NAME = "name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String VALUE = "value";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGER_EVENT_NAME = "trigger_event_name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGER_TIMEOUT = "trigger_timeout";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TIMED_OUT_EVENT_NAME = "timed_out_event_name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TIMED_OUT_EVENT_PARAMS = "timed_out_event_params";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGERED_EVENT_NAME = "triggered_event_name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGERED_EVENT_PARAMS = "triggered_event_params";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TIME_TO_LIVE = "time_to_live";
        @KeepForSdk
        @RecentlyNonNull
        public static final String EXPIRED_EVENT_NAME = "expired_event_name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String EXPIRED_EVENT_PARAMS = "expired_event_params";
        @KeepForSdk
        @RecentlyNonNull
        public static final String CREATION_TIMESTAMP = "creation_timestamp";
        @KeepForSdk
        @RecentlyNonNull
        public static final String ACTIVE = "active";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGERED_TIMESTAMP = "triggered_timestamp";

        private ConditionalUserProperty() {
        }
    }
}

