/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzci;
import com.google.android.gms.internal.measurement.zzcn;
import com.google.android.gms.internal.measurement.zzco;
import com.google.android.gms.internal.measurement.zzcp;
import com.google.android.gms.internal.measurement.zzcq;
import com.google.android.gms.internal.measurement.zzcr;
import com.google.android.gms.internal.measurement.zzcs;
import com.google.android.gms.internal.measurement.zzct;
import com.google.android.gms.internal.measurement.zzcu;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.internal.measurement.zzcx;
import com.google.android.gms.internal.measurement.zzcy;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.internal.measurement.zzdb;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzde;
import com.google.android.gms.internal.measurement.zzdf;
import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdk;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdn;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzds;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;

public final class zzee {
    private static volatile zzee zzc;
    private final String zzd;
    protected final Clock zza;
    protected final ExecutorService zzb;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zzgw, zzdv>> zzf;
    private int zzg;
    private boolean zzh;
    private final String zzi;
    private volatile zzcc zzj;

    public final int zza(String string) {
        zzbz zzbz2 = new zzbz();
        zzdj zzdj2 = new zzdj((zzee)((Object)n), string, zzbz2);
        ((zzee)((Object)n)).zzU(zzdj2);
        Integer n = (Integer)zzbz.zze((Bundle)zzbz2.zzb(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long zzb() {
        int n;
        Object object = new zzbz();
        zzdc zzdc2 = new zzdc(this, (zzbz)object);
        this.zzU(zzdc2);
        object = (Long)zzbz.zze((Bundle)object.zzb(500L), Long.class);
        long l = (Long)object;
        if (object != null) return l;
        object = new Random(System.nanoTime() ^ this.zza.currentTimeMillis());
        long l2 = ((Random)object).nextLong();
        this.zzg = n = this.zzg + 1;
        return l2 += (long)n;
    }

    public final Bundle zzc(Bundle bundle, boolean bl) {
        zzbz zzbz2 = new zzbz();
        zzdh zzdh2 = new zzdh(this, bundle, zzbz2);
        this.zzU(zzdh2);
        if (bl) {
            return zzbz2.zzb(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzd() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzcc zze(zzee zzee2) {
        return zzee2.zzj;
    }

    protected final zzcc zzf(Context context, boolean bl) {
        try {
            context = DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService");
            context = zzcb.asInterface((IBinder)context);
            return context;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zzS((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzee zzg(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzc != null) return zzc;
        Class<zzee> clazz = zzee.class;
        synchronized (clazz) {
            zzee zzee2 = zzc;
            if (zzee2 != null) return zzc;
            zzc = zzee2 = new zzee(context, string, string2, string3, bundle);
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final Object zzh(int n) {
        zzbz zzbz2 = new zzbz();
        zzdl zzdl2 = new zzdl(this, zzbz2, n);
        this.zzU(zzdl2);
        return zzbz.zze((Bundle)zzbz2.zzb(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzi(zzee zzee2) {
        return zzee2.zzd;
    }

    public final String zzj() {
        return this.zzi;
    }

    @WorkerThread
    public final String zzk() {
        zzbz zzbz2 = new zzbz();
        zzdk zzdk2 = new zzdk(this, zzbz2);
        this.zzU(zzdk2);
        return zzbz2.zzc(120000L);
    }

    public final String zzl() {
        zzbz zzbz2 = new zzbz();
        zzdb zzdb2 = new zzdb(this, zzbz2);
        this.zzU(zzdb2);
        return zzbz2.zzc(50L);
    }

    public final String zzm() {
        zzbz zzbz2 = new zzbz();
        zzde zzde2 = new zzde(this, zzbz2);
        this.zzU(zzde2);
        return zzbz2.zzc(500L);
    }

    public final String zzn() {
        zzbz zzbz2 = new zzbz();
        zzdd zzdd2 = new zzdd(this, zzbz2);
        this.zzU(zzdd2);
        return zzbz2.zzc(500L);
    }

    public final String zzo() {
        zzbz zzbz2 = new zzbz();
        zzda zzda2 = new zzda(this, zzbz2);
        this.zzU(zzda2);
        return zzbz2.zzc(500L);
    }

    public final List<Bundle> zzp(String string, String string2) {
        zzbz zzbz2 = new zzbz();
        zzcp zzcp2 = new zzcp((zzee)((Object)list), string, string2, zzbz2);
        ((zzee)((Object)list)).zzU(zzcp2);
        List list = (List)zzbz.zze((Bundle)zzbz2.zzb(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map<String, Object> zzq(String hashMap, String object, boolean bl) {
        Object object2 = new zzbz();
        zzdf zzdf2 = new zzdf(zzee2, (String)((Object)hashMap), (String)object, bl, (zzbz)object2);
        zzee2.zzU(zzdf2);
        zzee zzee2 = object2.zzb(5000L);
        if (zzee2 == null || zzee2.size() == 0) {
            return Collections.emptyMap();
        }
        hashMap = new HashMap<String, Object>(zzee2.size());
        for (String string : zzee2.keySet()) {
            object2 = zzee2.get(string);
            if (!(object2 instanceof Double) && !(object2 instanceof Long) && !(object2 instanceof String)) continue;
            hashMap.put(string, object2);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zzr(zzee zzee2, zzcc zzcc2) {
        zzee2.zzj = zzcc2;
    }

    static /* bridge */ /* synthetic */ void zzs(zzee zzee2, Exception exception, boolean bl, boolean bl2) {
        zzee2.zzS(exception, bl, bl2);
    }

    static /* bridge */ /* synthetic */ void zzt(zzee zzee2, zzdt zzdt2) {
        zzee2.zzU(zzdt2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected zzee(Context context, String object, String string, String string2, Bundle bundle) {
        block8: {
            block7: {
                this.zzd = object == null || !zzee.zzV(string, string2) ? "FA" : object;
                this.zza = DefaultClock.getInstance();
                object = zzbx.zza();
                zzdi zzdi2 = new zzdi(this);
                this.zzb = object.zzb(zzdi2, 1);
                this.zze = object = new AppMeasurementSdk(this);
                object = new ArrayList();
                this.zzf = object;
                try {
                    object = zzfn.zza((Context)context);
                    object = zzig.zzc((Context)context, (String)"google_app_id", (String)object);
                }
                catch (IllegalStateException illegalStateException) {}
                if (object != null && !zzee.zzR()) {
                    this.zzi = null;
                    this.zzh = true;
                    Log.w((String)this.zzd, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
                    return;
                }
                if (zzee.zzV(string, string2)) break block7;
                this.zzi = "fa";
                if (string != null && string2 != null) {
                    Log.v((String)this.zzd, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
                    break block8;
                } else {
                    boolean bl;
                    boolean bl2 = string == null;
                    if (bl2 ^ (bl = string2 == null)) {
                        Log.w((String)this.zzd, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
                    }
                }
                break block8;
            }
            this.zzi = string;
        }
        Object object2 = new zzcx(this, string, string2, context, bundle);
        this.zzU((zzdt)object2);
        context = (Application)context.getApplicationContext();
        if (context == null) {
            Log.w((String)this.zzd, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        object2 = new zzed(this);
        context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)object2);
    }

    private final void zzS(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzd, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzA(5, string, exception, null, null);
        }
        Log.w((String)this.zzd, (String)string, (Throwable)exception);
    }

    public final void zzu(String string) {
        zzcy zzcy2 = new zzcy(this, string);
        this.zzU(zzcy2);
    }

    public final void zzv(String string, String string2, Bundle bundle) {
        zzco zzco2 = new zzco(this, string, string2, bundle);
        this.zzU(zzco2);
    }

    public final void zzw(String string) {
        zzcz zzcz2 = new zzcz(this, string);
        this.zzU(zzcz2);
    }

    public final void zzx(@NonNull String string, Bundle bundle) {
        this.zzT(null, string, bundle, false, true, null);
    }

    public final void zzy(String string, String string2, Bundle bundle) {
        this.zzT(string, string2, bundle, true, true, null);
    }

    public final void zzz(String string, String string2, Bundle bundle, long l) {
        this.zzT(string, string2, bundle, true, false, l);
    }

    private final void zzT(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        zzdr zzdr2 = new zzdr(this, l, string, string2, bundle, bl, bl2);
        this.zzU(zzdr2);
    }

    public final void zzA(int n, String string, Object object, Object object2, Object object3) {
        zzdg zzdg2 = new zzdg(this, false, 5, string, object, null, null);
        this.zzU(zzdg2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzB(zzgw object) {
        int n;
        Preconditions.checkNotNull((Object)object);
        List<Pair<zzgw, zzdv>> list = this.zzf;
        // MONITORENTER : list
        for (int i = 0; i < (n = this.zzf.size()); ++i) {
            n = object.equals(this.zzf.get((int)i).first) ? 1 : 0;
            if (n == 0) continue;
            Log.w((String)this.zzd, (String)"OnEventListener already registered.");
            // MONITOREXIT : list
            return;
        }
        zzdv zzdv2 = new zzdv((zzgw)object);
        List<Pair<zzgw, zzdv>> list2 = this.zzf;
        Pair pair = new Pair(object, (Object)zzdv2);
        list2.add((Pair<zzgw, zzdv>)pair);
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzci)zzdv2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        object = new zzdp(this, zzdv2);
        this.zzU((zzdt)object);
    }

    public final void zzC() {
        zzcv zzcv2 = new zzcv(this);
        this.zzU(zzcv2);
    }

    private final void zzU(zzdt zzdt2) {
        this.zzb.execute(zzdt2);
    }

    public final void zzD(Bundle bundle) {
        zzcn zzcn2 = new zzcn(this, bundle);
        this.zzU(zzcn2);
    }

    public final void zzE(Bundle bundle) {
        zzct zzct2 = new zzct(this, bundle);
        this.zzU(zzct2);
    }

    public final void zzF(Bundle bundle) {
        zzcu zzcu2 = new zzcu(this, bundle);
        this.zzU(zzcu2);
    }

    public final void zzG(Activity activity, String string, String string2) {
        zzcr zzcr2 = new zzcr(this, activity, string, string2);
        this.zzU(zzcr2);
    }

    public final void zzH(boolean bl) {
        zzdm zzdm2 = new zzdm(this, bl);
        this.zzU(zzdm2);
    }

    public final void zzI(Bundle bundle) {
        zzdn zzdn2 = new zzdn(this, bundle);
        this.zzU(zzdn2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzJ(zzgv object) {
        zzdu zzdu2 = new zzdu((zzgv)object);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzci)zzdu2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzdo zzdo2 = new zzdo(this, zzdu2);
        this.zzU(zzdo2);
    }

    public final void zzK(Boolean bl) {
        zzcs zzcs2 = new zzcs(this, bl);
        this.zzU(zzcs2);
    }

    public final void zzL(long l) {
        zzcw zzcw2 = new zzcw(this, l);
        this.zzU(zzcw2);
    }

    public final void zzM(String string) {
        zzcq zzcq2 = new zzcq(this, string);
        this.zzU(zzcq2);
    }

    public final void zzN(String string, String string2, Object object, boolean bl) {
        zzds zzds2 = new zzds(this, string, string2, object, bl);
        this.zzU(zzds2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzO(zzgw object) {
        block8: {
            int n;
            Preconditions.checkNotNull(object);
            List<Pair<zzgw, zzdv>> list = this.zzf;
            // MONITORENTER : list
            for (int i = 0; i < (n = this.zzf.size()); ++i) {
                n = object.equals(this.zzf.get((int)i).first) ? 1 : 0;
                if (n == 0) continue;
                object = this.zzf.get(i);
                break block8;
            }
            object = null;
        }
        if (object == null) {
            Log.w((String)this.zzd, (String)"OnEventListener had not been registered.");
            // MONITOREXIT : list
            return;
        }
        this.zzf.remove(object);
        object = (zzdv)((Object)object.second);
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener(object);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzdq zzdq2 = new zzdq(this, (zzdv)((Object)object));
        this.zzU(zzdq2);
    }

    static /* bridge */ /* synthetic */ boolean zzP(zzee zzee2) {
        return zzee2.zzh;
    }

    static /* bridge */ /* synthetic */ boolean zzQ(zzee zzee2, String string, String string2) {
        return zzee.zzV(string, string2);
    }

    protected static final boolean zzR() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static final boolean zzV(String string, String string2) {
        return string2 != null && string != null && !zzee.zzR();
    }
}

