/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.api;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import java.util.List;
import java.util.Map;

@KeepForSdk
@ShowFirstParty
public class AppMeasurementSdk {
    private final zzee zza;

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String origin) {
        void var1_1;
        return this.zza.zza((String)var1_1);
    }

    @KeepForSdk
    public long generateEventId() {
        return this.zza.zzb();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @Nullable
    public Bundle performActionWithResponse(@NonNull Bundle bundle) {
        void var1_1;
        return this.zza.zzc((Bundle)var1_1, true);
    }

    @ShowFirstParty
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @NonNull
    public static AppMeasurementSdk getInstance(@NonNull Context context) {
        return zzee.zzg(context, null, null, null, null).zzd();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @NonNull
    public static AppMeasurementSdk getInstance(@NonNull Context context, @NonNull String logTag, @NonNull String origin, @Nullable String customAppId, @NonNull Bundle extraParameters) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return zzee.zzg(context, (String)var1_1, (String)var2_2, (String)var3_3, (Bundle)var4_4).zzd();
    }

    @KeepForSdk
    @Nullable
    public String getAppIdOrigin() {
        return this.zza.zzj();
    }

    @Nullable
    @KeepForSdk
    public String getAppInstanceId() {
        return this.zza.zzl();
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenClass() {
        return this.zza.zzm();
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenName() {
        return this.zza.zzn();
    }

    @Nullable
    @KeepForSdk
    public String getGmpAppId() {
        return this.zza.zzo();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @WorkerThread
    @NonNull
    public List<Bundle> getConditionalUserProperties(@Nullable String origin, @Nullable @Size(min=1L, max=23L) String propertyNamePrefix) {
        void var2_2;
        void var1_1;
        return this.zza.zzp((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @WorkerThread
    @NonNull
    public Map<String, Object> getUserProperties(@Nullable String origin, @Nullable @Size(min=1L, max=24L) String propertyNamePrefix, boolean includeInternal) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.zza.zzq((String)var1_1, (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String adUnitId) {
        void var1_1;
        this.zza.zzu((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String userPropertyName, @Nullable String clearEventName, @Nullable Bundle clearEventParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzv((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void endAdUnitExposure(@NonNull @Size(min=1L) String adUnitId) {
        void var1_1;
        this.zza.zzw((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void logEvent(@NonNull String origin, @NonNull String name, @NonNull Bundle params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzy((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void logEventNoInterceptor(@NonNull String origin, @NonNull String name, @NonNull Bundle params, long timestampInMillis) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzz((String)var1_1, (String)var2_2, (Bundle)var3_3, (long)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @Nullable
    public void performAction(@NonNull Bundle bundle) {
        void var1_1;
        this.zza.zzc((Bundle)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(@NonNull OnEventListener listener) {
        void var1_1;
        this.zza.zzB((zzhf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull Bundle conditionalUserProperty) {
        void var1_1;
        this.zza.zzD((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setConsent(@NonNull Bundle consentMap) {
        void var1_1;
        this.zza.zzE((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String screenName, @Size(min=1L, max=36L) @Nullable String screenClassOverride) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzG((Activity)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(@NonNull EventInterceptor interceptor) {
        void var1_1;
        this.zza.zzJ((zzhe)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setMeasurementEnabled(@Nullable Boolean enabled) {
        void var1_1;
        this.zza.zzK((Boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setMeasurementEnabled(boolean enabled) {
        void var1_1;
        this.zza.zzK((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setUserProperty(@NonNull String origin, @NonNull String name, @NonNull Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza.zzN((String)var1_1, (String)var2_2, var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(@NonNull OnEventListener listener) {
        void var1_1;
        this.zza.zzO((zzhf)var1_1);
    }

    public AppMeasurementSdk(zzee zzee2) {
        this.zza = zzee2;
    }

    public final void zza(boolean bl) {
        this.zza.zzH(bl);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzhf {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(@NonNull String var1, @NonNull String var2, @NonNull Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzhe {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(@NonNull String var1, @NonNull String var2, @NonNull Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class ConditionalUserProperty {
        @KeepForSdk
        @NonNull
        public static final String ORIGIN = "origin";
        @KeepForSdk
        @NonNull
        public static final String NAME = "name";
        @KeepForSdk
        @NonNull
        public static final String VALUE = "value";
        @KeepForSdk
        @NonNull
        public static final String TRIGGER_EVENT_NAME = "trigger_event_name";
        @KeepForSdk
        @NonNull
        public static final String TRIGGER_TIMEOUT = "trigger_timeout";
        @KeepForSdk
        @NonNull
        public static final String TIMED_OUT_EVENT_NAME = "timed_out_event_name";
        @KeepForSdk
        @NonNull
        public static final String TIMED_OUT_EVENT_PARAMS = "timed_out_event_params";
        @KeepForSdk
        @NonNull
        public static final String TRIGGERED_EVENT_NAME = "triggered_event_name";
        @KeepForSdk
        @NonNull
        public static final String TRIGGERED_EVENT_PARAMS = "triggered_event_params";
        @KeepForSdk
        @NonNull
        public static final String TIME_TO_LIVE = "time_to_live";
        @KeepForSdk
        @NonNull
        public static final String EXPIRED_EVENT_NAME = "expired_event_name";
        @KeepForSdk
        @NonNull
        public static final String EXPIRED_EVENT_PARAMS = "expired_event_params";
        @KeepForSdk
        @NonNull
        public static final String CREATION_TIMESTAMP = "creation_timestamp";
        @KeepForSdk
        @NonNull
        public static final String ACTIVE = "active";
        @KeepForSdk
        @NonNull
        public static final String TRIGGERED_TIMESTAMP = "triggered_timestamp";

        private ConditionalUserProperty() {
        }
    }
}

