/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzcq;
import com.google.android.gms.internal.measurement.zzcs;
import com.google.android.gms.internal.measurement.zzct;
import com.google.android.gms.internal.measurement.zzcu;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdk;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdn;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzds;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzdf {
    private static volatile zzdf zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zzij, zzb>> zzf;
    private int zzg;
    private boolean zzh;
    private @Nullable String zzi;
    private volatile @Nullable zzcu zzj;

    public final int zza(String string) {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzed(this, string, zzcs2));
        Integer n = (Integer)zzcs.zza((Bundle)zzcs2.zza(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final long zza() {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzdy(this, zzcs2));
        Long l = zzcs2.zzb(500L);
        if (l == null) {
            zzdf zzdf2 = this;
            return new Random(System.nanoTime() ^ zzdf2.zza.currentTimeMillis()).nextLong() + (long)(++zzdf2.zzg);
        }
        return l;
    }

    public final @Nullable Bundle zza(Bundle bundle, boolean bl) {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzeb(this, bundle, zzcs2));
        if (bl) {
            return zzcs2.zza(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzcu zza(zzdf zzdf2) {
        return zzdf2.zzj;
    }

    protected final @Nullable zzcu zza(Context context, boolean bl) {
        try {
            return zzct.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    public static zzdf zza(@NonNull Context context) {
        return zzdf.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzdf zza(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzdf> clazz = zzdf.class;
        synchronized (zzdf.class) {
            if (zzb != null) return zzb;
            zzb = new zzdf(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    @WorkerThread
    public final @Nullable Long zzc() {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzef(this, zzcs2));
        return zzcs2.zzb(120000L);
    }

    public final @Nullable Object zza(int n) {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzei(this, zzcs2, n));
        return zzcs.zza((Bundle)zzcs2.zza(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzb(zzdf zzdf2) {
        return zzdf2.zzc;
    }

    public final @Nullable String zzd() {
        return this.zzi;
    }

    @WorkerThread
    public final @Nullable String zze() {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzeg(this, zzcs2));
        return zzcs2.zzc(120000L);
    }

    public final @Nullable String zzf() {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzdv(this, zzcs2));
        return zzcs2.zzc(50L);
    }

    public final @Nullable String zzg() {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzea(this, zzcs2));
        return zzcs2.zzc(500L);
    }

    public final @Nullable String zzh() {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzdx(this, zzcs2));
        return zzcs2.zzc(500L);
    }

    public final @Nullable String zzi() {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzdw(this, zzcs2));
        return zzcs2.zzc(500L);
    }

    public final List<Bundle> zza(@Nullable String string, @Nullable String string2) {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzdj(this, string, string2, zzcs2));
        List list = (List)zzcs.zza((Bundle)zzcs2.zza(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map<String, Object> zza(@Nullable String string, @Nullable String string2, boolean bl) {
        zzcs zzcs2 = new zzcs();
        this.zza(new zzdz(this, string, string2, bl, zzcs2));
        Bundle bundle = zzcs2.zza(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zza(zzdf zzdf2, zzcu zzcu2) {
        zzdf2.zzj = zzcu2;
    }

    private zzdf(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzc = string == null || !this.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        zzdf zzdf2 = this;
        this.zzd = zzch.zza().zza(new zzdr(zzdf2), zzcq.zza);
        this.zze = new AppMeasurementSdk(this);
        this.zzf = new ArrayList<Pair<zzij, zzb>>();
        Context context2 = context;
        zzdf2 = this;
        if (!(!zzdf.zzb(context2) || zzdf2.zzk())) {
            this.zzi = null;
            this.zzh = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!this.zzc(string2, string3)) {
            this.zzi = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzi = string2;
        }
        this.zza(new zzdi(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzdf2 = this;
        if (context2 == null) {
            Log.w((String)zzdf2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdf2.new zzd());
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    public final void zzb(String string) {
        this.zza(new zzdu(this, string));
    }

    public final void zza(String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza(new zzdk(this, string, string2, bundle));
    }

    public final void zzc(String string) {
        this.zza(new zzdt(this, string));
    }

    public final void zza(@NonNull String string, @Nullable Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zzb(String string, String string2, @Nullable Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, @Nullable Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(@Nullable String string, String string2, @Nullable Bundle bundle, boolean bl, boolean bl2, @Nullable Long l) {
        this.zza(new zzel(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(int n, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        this.zza(new zzec(this, false, 5, string, object, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzij zzij2) {
        zzb zzb2;
        Preconditions.checkNotNull((Object)zzij2);
        List<Pair<zzij, zzb>> list = this.zzf;
        synchronized (list) {
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzij2.equals(this.zzf.get((int)i).first)) continue;
                Log.w((String)this.zzc, (String)"OnEventListener already registered.");
                return;
            }
            zzb2 = new zzb(zzij2);
            this.zzf.add((Pair<zzij, zzb>)new Pair((Object)zzij2, (Object)zzb2));
        }
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzda)zzb2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzej(this, zzb2));
    }

    public final void zzj() {
        this.zza(new zzdp(this));
    }

    private final void zza(zza zza2) {
        this.zzd.execute(zza2);
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzdh(this, bundle));
    }

    public final void zzb(Bundle bundle) {
        this.zza(new zzdn(this, bundle));
    }

    public final void zzc(Bundle bundle) {
        this.zza(new zzdq(this, bundle));
    }

    public final void zza(Activity activity, @Nullable String string, @Nullable String string2) {
        this.zza(new zzdl(this, activity, string, string2));
    }

    public final void zza(boolean bl) {
        this.zza(new zzeh(this, bl));
    }

    public final void zzd(@Nullable Bundle bundle) {
        this.zza(new zzek(this, bundle));
    }

    public final void zza(zzik zzik2) {
        zzc zzc2 = new zzc(zzik2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzda)zzc2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzee(this, zzc2));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zza(new zzdo(this, bl));
    }

    public final void zza(long l) {
        this.zza(new zzds(this, l));
    }

    public final void zzd(@Nullable String string) {
        this.zza(new zzdm(this, string));
    }

    public final void zzb(String string, @Nullable String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(@Nullable String string, String string2, @Nullable Object object, boolean bl) {
        this.zza(new zzen(this, string, string2, object, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzij zzij2) {
        zzb zzb2;
        Preconditions.checkNotNull((Object)zzij2);
        List<Pair<zzij, zzb>> list = this.zzf;
        synchronized (list) {
            Pair<zzij, zzb> pair = null;
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzij2.equals(this.zzf.get((int)i).first)) continue;
                pair = this.zzf.get(i);
                break;
            }
            if (pair == null) {
                Log.w((String)this.zzc, (String)"OnEventListener had not been registered.");
                return;
            }
            this.zzf.remove(pair);
            zzb2 = (zzb)((Object)pair.second);
        }
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzda)zzb2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzem(this, zzb2));
    }

    static /* synthetic */ boolean zza(zzdf zzdf2, String string, String string2) {
        return zzdf2.zzc(string, string2);
    }

    private final boolean zzc(@Nullable String string, @Nullable String string2) {
        return string2 != null && string != null && !this.zzk();
    }

    private final boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean zzb(Context context) {
        try {
            String string;
            String string2 = string = zzgx.zza((Context)context);
            String string3 = "google_app_id";
            Context context2 = context;
            return new zzgx(context2, string2).zza(string3) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    abstract class zza
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zza() {
            this(true);
        }

        zza(boolean bl) {
            this.zza = zzdf.this.zza.currentTimeMillis();
            this.zzb = zzdf.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        protected void zzb() {
        }

        @Override
        public void run() {
            if (zzdf.this.zzh) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzdf.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        abstract void zza() throws RemoteException;
    }

    static final class zzc
    extends zzcz {
        private final zzik zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzc(zzik zzik2) {
            this.zza = zzik2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }
    }

    static final class zzb
    extends zzcz {
        private final zzij zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzb(zzij zzij2) {
            this.zza = zzij2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }
    }

    final class zzd
    implements Application.ActivityLifecycleCallbacks {
        zzd() {
        }

        public final void onActivityCreated(Activity activity, @Nullable Bundle bundle) {
            zzdf.this.zza(new zzeo(this, bundle, activity));
        }

        public final void onActivityDestroyed(Activity activity) {
            zzdf.this.zza(new zzet(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzdf.this.zza(new zzes(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzdf.this.zza(new zzep(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzcs zzcs2 = new zzcs();
            zzdf.this.zza(new zzeu(this, activity, zzcs2));
            Bundle bundle2 = zzcs2.zza(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityStarted(Activity activity) {
            zzdf.this.zza(new zzeq(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzdf.this.zza(new zzer(this, activity));
        }
    }
}

