/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzcu;
import com.google.android.gms.internal.measurement.zzdb;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzde;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzdk;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzds;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zziu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzdq {
    private static volatile zzdq zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zziu, zzb>> zzf;
    private int zzg;
    private boolean zzh;
    private @Nullable String zzi;
    private volatile @Nullable zzdb zzj;

    public final int zza(String string) {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzen(this, string, zzdc2));
        Integer n = (Integer)zzdc.zza((Bundle)zzdc2.zza(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final long zza() {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzei(this, zzdc2));
        Long l = zzdc2.zzb(500L);
        if (l == null) {
            zzdq zzdq2 = this;
            return new Random(System.nanoTime() ^ zzdq2.zza.currentTimeMillis()).nextLong() + (long)(++zzdq2.zzg);
        }
        return l;
    }

    public final @Nullable Bundle zza(Bundle bundle, boolean bl) {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzeo(this, bundle, zzdc2));
        if (bl) {
            return zzdc2.zza(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzdb zza(zzdq zzdq2) {
        return zzdq2.zzj;
    }

    protected final @Nullable zzdb zza(Context context, boolean bl) {
        try {
            return zzde.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    public static zzdq zza(@NonNull Context context) {
        return zzdq.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzdq zza(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzdq> clazz = zzdq.class;
        synchronized (zzdq.class) {
            if (zzb != null) return zzb;
            zzb = new zzdq(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    @WorkerThread
    public final @Nullable Long zzc() {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzep(this, zzdc2));
        return zzdc2.zzb(120000L);
    }

    public final @Nullable Object zza(int n) {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzes(this, zzdc2, n));
        return zzdc.zza((Bundle)zzdc2.zza(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzb(zzdq zzdq2) {
        return zzdq2.zzc;
    }

    public final @Nullable String zzd() {
        return this.zzi;
    }

    @WorkerThread
    public final @Nullable String zze() {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzeq(this, zzdc2));
        return zzdc2.zzc(120000L);
    }

    public final @Nullable String zzf() {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzef(this, zzdc2));
        return zzdc2.zzc(50L);
    }

    public final @Nullable String zzg() {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzek(this, zzdc2));
        return zzdc2.zzc(500L);
    }

    public final @Nullable String zzh() {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzeh(this, zzdc2));
        return zzdc2.zzc(500L);
    }

    public final @Nullable String zzi() {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzeg(this, zzdc2));
        return zzdc2.zzc(500L);
    }

    public final List<Bundle> zza(@Nullable String string, @Nullable String string2) {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzdt(this, string, string2, zzdc2));
        List list = (List)zzdc.zza((Bundle)zzdc2.zza(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map<String, Object> zza(@Nullable String string, @Nullable String string2, boolean bl) {
        zzdc zzdc2 = new zzdc();
        this.zza(new zzej(this, string, string2, bl, zzdc2));
        Bundle bundle = zzdc2.zza(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zza(zzdq zzdq2, zzdb zzdb2) {
        zzdq2.zzj = zzdb2;
    }

    private zzdq(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzc = string == null || !this.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        zzdq zzdq2 = this;
        this.zzd = zzcu.zza().zza(new zzec(zzdq2), 1);
        this.zze = new AppMeasurementSdk(this);
        this.zzf = new ArrayList<Pair<zziu, zzb>>();
        Context context2 = context;
        zzdq2 = this;
        if (!(!zzdq.zzb(context2) || zzdq2.zzk())) {
            this.zzi = null;
            this.zzh = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!this.zzc(string2, string3)) {
            this.zzi = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzi = string2;
        }
        this.zza(new zzdp(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzdq2 = this;
        if (context2 == null) {
            Log.w((String)zzdq2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdq2.new zzd());
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    public final void zzb(String string) {
        this.zza(new zzee(this, string));
    }

    public final void zza(String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza(new zzdu(this, string, string2, bundle));
    }

    public final void zzc(String string) {
        this.zza(new zzed(this, string));
    }

    public final void zza(@NonNull String string, @Nullable Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zzb(String string, String string2, @Nullable Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, @Nullable Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(@Nullable String string, String string2, @Nullable Bundle bundle, boolean bl, boolean bl2, @Nullable Long l) {
        this.zza(new zzex(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(int n, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        this.zza(new zzem(this, false, 5, string, object, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zziu zziu2) {
        zzb zzb2;
        Preconditions.checkNotNull((Object)zziu2);
        List<Pair<zziu, zzb>> list = this.zzf;
        synchronized (list) {
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zziu2.equals(this.zzf.get((int)i).first)) continue;
                Log.w((String)this.zzc, (String)"OnEventListener already registered.");
                return;
            }
            zzb2 = new zzb(zziu2);
            this.zzf.add((Pair<zziu, zzb>)new Pair((Object)zziu2, (Object)zzb2));
        }
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzdh)zzb2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzew(this, zzb2));
    }

    public final void zzj() {
        this.zza(new zzdz(this));
    }

    private final void zza(zza zza2) {
        this.zzd.execute(zza2);
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzdr(this, bundle));
    }

    public final void zzb(Bundle bundle) {
        this.zza(new zzdx(this, bundle));
    }

    public final void zzc(Bundle bundle) {
        this.zza(new zzea(this, bundle));
    }

    public final void zza(Activity activity, @Nullable String string, @Nullable String string2) {
        this.zza(new zzdv(this, activity, string, string2));
    }

    public final void zza(boolean bl) {
        this.zza(new zzer(this, bl));
    }

    public final void zzd(@Nullable Bundle bundle) {
        this.zza(new zzeu(this, bundle));
    }

    public final void zza(zzir zzir2) {
        zzc zzc2 = new zzc(zzir2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzdh)zzc2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzel(this, zzc2));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zza(new zzdy(this, bl));
    }

    public final void zza(long l) {
        this.zza(new zzeb(this, l));
    }

    public final void zza(Intent intent) {
        this.zza(new zzet(this, intent));
    }

    public final void zzd(@Nullable String string) {
        this.zza(new zzdw(this, string));
    }

    public final void zzb(String string, @Nullable String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(@Nullable String string, String string2, @Nullable Object object, boolean bl) {
        this.zza(new zzds(this, string, string2, object, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zziu zziu2) {
        zzb zzb2;
        Preconditions.checkNotNull((Object)zziu2);
        List<Pair<zziu, zzb>> list = this.zzf;
        synchronized (list) {
            Pair<zziu, zzb> pair = null;
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zziu2.equals(this.zzf.get((int)i).first)) continue;
                pair = this.zzf.get(i);
                break;
            }
            if (pair == null) {
                Log.w((String)this.zzc, (String)"OnEventListener had not been registered.");
                return;
            }
            this.zzf.remove(pair);
            zzb2 = (zzb)((Object)pair.second);
        }
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzdh)zzb2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzev(this, zzb2));
    }

    static /* synthetic */ boolean zza(zzdq zzdq2, String string, String string2) {
        return zzdq2.zzc(string, string2);
    }

    private final boolean zzc(@Nullable String string, @Nullable String string2) {
        return string2 != null && string != null && !this.zzk();
    }

    private final boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean zzb(Context context) {
        try {
            String string;
            String string2 = string = zzhd.zza((Context)context);
            String string3 = "google_app_id";
            Context context2 = context;
            return new zzhd(context2, string2).zza(string3) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    abstract class zza
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zza() {
            this(true);
        }

        zza(boolean bl) {
            this.zza = zzdq.this.zza.currentTimeMillis();
            this.zzb = zzdq.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        protected void zzb() {
        }

        @Override
        public void run() {
            if (zzdq.this.zzh) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzdq.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        abstract void zza() throws RemoteException;
    }

    static final class zzc
    extends zzdk {
        private final zzir zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzc(zzir zzir2) {
            this.zza = zzir2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }
    }

    static final class zzb
    extends zzdk {
        private final zziu zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzb(zziu zziu2) {
            this.zza = zziu2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }
    }

    final class zzd
    implements Application.ActivityLifecycleCallbacks {
        zzd() {
        }

        public final void onActivityCreated(Activity activity, @Nullable Bundle bundle) {
            zzdq.this.zza(new zzey(this, bundle, activity));
        }

        public final void onActivityDestroyed(Activity activity) {
            zzdq.this.zza(new zzfd(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzdq.this.zza(new zzfc(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzdq.this.zza(new zzez(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzdc zzdc2 = new zzdc();
            zzdq.this.zza(new zzfe(this, activity, zzdc2));
            Bundle bundle2 = zzdc2.zza(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityStarted(Activity activity) {
            zzdq.this.zza(new zzfa(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzdq.this.zza(new zzfb(this, activity));
        }
    }
}

