/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzde;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfq;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzed {
    private static volatile zzed zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zzke, zzb>> zzf;
    private int zzg;
    private boolean zzh;
    private @Nullable String zzi;
    private volatile @Nullable zzdl zzj;

    public final int zza(String string) {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzfd(this, string, zzdm2));
        Integer n = (Integer)zzdm.zza((Bundle)zzdm2.zza(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final long zza() {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzey(this, zzdm2));
        Long l = zzdm2.zzb(500L);
        if (l == null) {
            zzed zzed2 = this;
            return new Random(System.nanoTime() ^ zzed2.zza.currentTimeMillis()).nextLong() + (long)(++zzed2.zzg);
        }
        return l;
    }

    public final @Nullable Bundle zza(Bundle bundle, boolean bl) {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzfe(this, bundle, zzdm2));
        if (bl) {
            return zzdm2.zza(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzdl zza(zzed zzed2) {
        return zzed2.zzj;
    }

    protected final @Nullable zzdl zza(Context context, boolean bl) {
        try {
            return zzdo.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    public static zzed zza(@NonNull Context context) {
        return zzed.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzed zza(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzed> clazz = zzed.class;
        synchronized (zzed.class) {
            if (zzb != null) return zzb;
            zzb = new zzed(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    @WorkerThread
    public final @Nullable Long zzc() {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzff(this, zzdm2));
        return zzdm2.zzb(120000L);
    }

    public final @Nullable Object zza(int n) {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzfi(this, zzdm2, n));
        return zzdm.zza((Bundle)zzdm2.zza(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzb(zzed zzed2) {
        return zzed2.zzc;
    }

    public final @Nullable String zzd() {
        return this.zzi;
    }

    @WorkerThread
    public final @Nullable String zze() {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzfg(this, zzdm2));
        return zzdm2.zzc(120000L);
    }

    public final @Nullable String zzf() {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzev(this, zzdm2));
        return zzdm2.zzc(50L);
    }

    public final @Nullable String zzg() {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzfa(this, zzdm2));
        return zzdm2.zzc(500L);
    }

    public final @Nullable String zzh() {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzex(this, zzdm2));
        return zzdm2.zzc(500L);
    }

    public final @Nullable String zzi() {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzew(this, zzdm2));
        return zzdm2.zzc(500L);
    }

    public final List<Bundle> zza(@Nullable String string, @Nullable String string2) {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzek(this, string, string2, zzdm2));
        List list = (List)zzdm.zza((Bundle)zzdm2.zza(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map<String, Object> zza(@Nullable String string, @Nullable String string2, boolean bl) {
        zzdm zzdm2 = new zzdm();
        this.zza(new zzez(this, string, string2, bl, zzdm2));
        Bundle bundle = zzdm2.zza(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zza(zzed zzed2, zzdl zzdl2) {
        zzed2.zzj = zzdl2;
    }

    private zzed(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzc = string == null || !this.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        zzed zzed2 = this;
        this.zzd = zzde.zza().zza(new zzeq(zzed2), 1);
        this.zze = new AppMeasurementSdk(this);
        this.zzf = new ArrayList<Pair<zzke, zzb>>();
        Context context2 = context;
        zzed2 = this;
        if (!(!zzed.zzb(context2) || zzed2.zzk())) {
            this.zzi = null;
            this.zzh = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!this.zzc(string2, string3)) {
            this.zzi = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzi = string2;
        }
        this.zza(new zzeg(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzed2 = this;
        if (context2 == null) {
            Log.w((String)zzed2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzed2.new zzd());
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    public final void zzb(String string) {
        this.zza(new zzes(this, string));
    }

    public final void zza(String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza(new zzeh(this, string, string2, bundle));
    }

    public final void zzc(String string) {
        this.zza(new zzer(this, string));
    }

    public final void zza(@NonNull String string, @Nullable Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zzb(String string, String string2, @Nullable Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, @Nullable Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(@Nullable String string, String string2, @Nullable Bundle bundle, boolean bl, boolean bl2, @Nullable Long l) {
        this.zza(new zzfn(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(int n, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        this.zza(new zzfb(this, false, 5, string, object, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzke zzke2) {
        zzb zzb2;
        Preconditions.checkNotNull((Object)zzke2);
        List<Pair<zzke, zzb>> list = this.zzf;
        synchronized (list) {
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzke2.equals(this.zzf.get((int)i).first)) continue;
                Log.w((String)this.zzc, (String)"OnEventListener already registered.");
                return;
            }
            zzb2 = new zzb(zzke2);
            this.zzf.add((Pair<zzke, zzb>)new Pair((Object)zzke2, (Object)zzb2));
        }
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzdw)zzb2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzfm(this, zzb2));
    }

    public final void zzj() {
        this.zza(new zzen(this));
    }

    public final void zza(Runnable runnable) {
        this.zza(new zzeu(this, runnable));
    }

    private final void zza(zza zza2) {
        this.zzd.execute(zza2);
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzei(this, bundle));
    }

    public final void zzb(Bundle bundle) {
        this.zza(new zzeo(this, bundle));
    }

    public final void zza(Activity activity, @Nullable String string, @Nullable String string2) {
        String string3 = string2;
        String string4 = string;
        zzeb zzeb2 = zzeb.zza((Activity)activity);
        zzed zzed2 = this;
        zzed2.zza(new zzem(zzed2, zzeb2, string4, string3));
    }

    public final void zza(boolean bl) {
        this.zza(new zzfh(this, bl));
    }

    public final void zzc(@Nullable Bundle bundle) {
        this.zza(new zzfk(this, bundle));
    }

    public final void zza(zzkb zzkb2) {
        zzc zzc2 = new zzc(zzkb2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzdw)zzc2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzfc(this, zzc2));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zza(new zzel(this, bl));
    }

    public final void zza(long l) {
        this.zza(new zzep(this, l));
    }

    public final void zza(Intent intent) {
        this.zza(new zzfj(this, intent));
    }

    public final void zzd(@Nullable String string) {
        this.zza(new zzej(this, string));
    }

    public final void zzb(String string, @Nullable String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(@Nullable String string, String string2, @Nullable Object object, boolean bl) {
        this.zza(new zzef(this, string, string2, object, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzke zzke2) {
        zzb zzb2;
        Preconditions.checkNotNull((Object)zzke2);
        List<Pair<zzke, zzb>> list = this.zzf;
        synchronized (list) {
            Pair<zzke, zzb> pair = null;
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzke2.equals(this.zzf.get((int)i).first)) continue;
                pair = this.zzf.get(i);
                break;
            }
            if (pair == null) {
                Log.w((String)this.zzc, (String)"OnEventListener had not been registered.");
                return;
            }
            this.zzf.remove(pair);
            zzb2 = (zzb)((Object)pair.second);
        }
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzdw)zzb2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzfl(this, zzb2));
    }

    static /* synthetic */ boolean zza(zzed zzed2, String string, String string2) {
        return zzed2.zzc(string, string2);
    }

    private final boolean zzc(@Nullable String string, @Nullable String string2) {
        return string2 != null && string != null && !this.zzk();
    }

    private final boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean zzb(Context context) {
        try {
            String string;
            String string2 = string = zzig.zza((Context)context);
            String string3 = "google_app_id";
            Context context2 = context;
            return new zzig(context2, string2).zza(string3) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    abstract class zza
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zza() {
            this(true);
        }

        zza(boolean bl) {
            this.zza = zzed.this.zza.currentTimeMillis();
            this.zzb = zzed.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        protected void zzb() {
        }

        @Override
        public void run() {
            if (zzed.this.zzh) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzed.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        abstract void zza() throws RemoteException;
    }

    static final class zzc
    extends zzdv {
        private final zzkb zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzc(zzkb zzkb2) {
            this.zza = zzkb2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }
    }

    static final class zzb
    extends zzdv {
        private final zzke zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzb(zzke zzke2) {
            this.zza = zzke2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }
    }

    final class zzd
    implements Application.ActivityLifecycleCallbacks {
        zzd() {
        }

        public final void onActivityCreated(Activity activity, @Nullable Bundle bundle) {
            zzed.this.zza(new zzfo(this, bundle, activity));
        }

        public final void onActivityDestroyed(Activity activity) {
            zzed.this.zza(new zzft(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzed.this.zza(new zzfs(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzed.this.zza(new zzfp(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzdm zzdm2 = new zzdm();
            zzed.this.zza(new zzfu(this, activity, zzdm2));
            Bundle bundle2 = zzdm2.zza(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityStarted(Activity activity) {
            zzed.this.zza(new zzfq(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzed.this.zza(new zzfr(this, activity));
        }
    }
}

