/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzcq;
import com.google.android.gms.internal.measurement.zzcs;
import com.google.android.gms.internal.measurement.zzcu;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.internal.measurement.zzde;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdn;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzds;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzmg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class zzff {
    private static volatile zzff zzc;
    private final String zzd;
    protected final Clock zza;
    protected final ExecutorService zzb;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List zzf;
    private int zzg;
    private boolean zzh;
    private final String zzi;
    private volatile zzcv zzj;

    public final int zza(String string) {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = n;
        zzff2.zzW(new zzej(zzff2, string, zzcs2));
        Integer n = (Integer)zzcs.zzf((Bundle)zzcs2.zzb(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long zzb() {
        Object object = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzec(zzff2, (zzcs)object));
        object = object.zzc(500L);
        if (object != null) return (Long)object;
        object = this.zza;
        return new Random(System.nanoTime() ^ object.currentTimeMillis()).nextLong() + (long)(++this.zzg);
    }

    public final Bundle zzc(Bundle bundle, boolean bl) {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzei(zzff2, bundle, zzcs2));
        if (bl) {
            return zzcs2.zzb(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzd() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzcv zze(zzff zzff2) {
        return zzff2.zzj;
    }

    protected final zzcv zzf(Context context, boolean bl) {
        try {
            context = DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService");
            zzff zzff2 = zzcu.asInterface((IBinder)context);
            return zzff2;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            zzff2.zzU((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzff zzg(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzc != null) return zzc;
        Class<zzff> clazz = zzff.class;
        synchronized (clazz) {
            zzff zzff2 = zzc;
            if (zzff2 != null) return zzc;
            zzc = new zzff(context, string, string2, string3, bundle);
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final Long zzh() {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzel(zzff2, zzcs2));
        return zzcs2.zzc(120000L);
    }

    public final Object zzi(int n) {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzem(zzff2, zzcs2, n));
        return zzcs.zzf((Bundle)zzcs2.zzb(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzj(zzff zzff2) {
        return zzff2.zzd;
    }

    public final String zzk() {
        return this.zzi;
    }

    @WorkerThread
    public final String zzl() {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzek(zzff2, zzcs2));
        return zzcs2.zzd(120000L);
    }

    public final String zzm() {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzeb(zzff2, zzcs2));
        return zzcs2.zzd(50L);
    }

    public final String zzn() {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzee(zzff2, zzcs2));
        return zzcs2.zzd(500L);
    }

    public final String zzo() {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzed(zzff2, zzcs2));
        return zzcs2.zzd(500L);
    }

    public final String zzp() {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = this;
        zzff2.zzW(new zzea(zzff2, zzcs2));
        return zzcs2.zzd(500L);
    }

    public final List zzq(String string, String string2) {
        zzcs zzcs2 = new zzcs();
        zzff zzff2 = list;
        zzff2.zzW(new zzdo(zzff2, string, string2, zzcs2));
        List list = (List)zzcs.zzf((Bundle)zzcs2.zzb(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map zzr(String hashMap, String object, boolean bl) {
        Object object2 = new zzcs();
        zzff zzff2 = zzff3;
        zzff2.zzW(new zzef(zzff2, (String)((Object)hashMap), (String)object, bl, (zzcs)object2));
        zzff zzff3 = object2.zzb(5000L);
        if (zzff3 == null || zzff3.size() == 0) {
            return Collections.emptyMap();
        }
        hashMap = new HashMap<String, zzcs>(zzff3.size());
        for (String string : zzff3.keySet()) {
            object2 = zzff3.get(string);
            if (!(object2 instanceof Double) && !(object2 instanceof Long) && !(object2 instanceof String)) continue;
            hashMap.put(string, (zzcs)object2);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zzs(zzff zzff2, zzcv zzcv2) {
        zzff2.zzj = zzcv2;
    }

    static /* bridge */ /* synthetic */ void zzt(zzff zzff2, Exception exception, boolean bl, boolean bl2) {
        zzff2.zzU(exception, bl, bl2);
    }

    static /* bridge */ /* synthetic */ void zzu(zzff zzff2, zzeu zzeu2) {
        zzff2.zzW(zzeu2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected zzff(Context context, String object, String string, String string2, Bundle bundle) {
        block8: {
            block7: {
                this.zzd = object == null || !this.zzX(string, string2) ? "FA" : object;
                this.zza = DefaultClock.getInstance();
                zzcq.zza();
                object = new zzeg(this);
                ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)object);
                threadPoolExecutor.allowCoreThreadTimeOut(true);
                this.zzb = Executors.unconfigurableExecutorService(threadPoolExecutor);
                this.zze = new AppMeasurementSdk(this);
                this.zzf = new ArrayList();
                try {
                    object = zzig.zza((Context)context);
                    object = zzmg.zzc((Context)context, (String)"google_app_id", (String)object);
                }
                catch (IllegalStateException illegalStateException) {}
                if (object != null && !this.zzT()) {
                    this.zzi = null;
                    this.zzh = true;
                    Log.w((String)this.zzd, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
                    return;
                }
                if (this.zzX(string, string2)) break block7;
                this.zzi = "fa";
                if (string != null && string2 != null) {
                    Log.v((String)this.zzd, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
                    break block8;
                } else {
                    boolean bl;
                    boolean bl2 = string == null;
                    if (bl2 ^ (bl = string2 == null)) {
                        Log.w((String)this.zzd, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
                    }
                }
                break block8;
            }
            this.zzi = string;
        }
        zzff zzff2 = this;
        zzff2.zzW(new zzdu(zzff2, string, string2, context, bundle));
        context = (Application)context.getApplicationContext();
        if (context == null) {
            Log.w((String)this.zzd, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzfe(this));
    }

    private final void zzU(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzd, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzB(5, string, exception, null, null);
        }
        Log.w((String)this.zzd, (String)string, (Throwable)exception);
    }

    public final void zzv(String string) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdw(zzff2, string));
    }

    public final void zzw(String string, String string2, Bundle bundle) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdn(zzff2, string, string2, bundle));
    }

    public final void zzx(String string) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdx(zzff2, string));
    }

    public final void zzy(@NonNull String string, Bundle bundle) {
        this.zzV(null, string, bundle, false, true, null);
    }

    public final void zzz(String string, String string2, Bundle bundle) {
        this.zzV(string, string2, bundle, true, true, null);
    }

    public final void zzA(String string, String string2, Bundle bundle, long l) {
        this.zzV(string, string2, bundle, true, false, l);
    }

    private final void zzV(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        zzff zzff2 = this;
        zzff2.zzW(new zzet(zzff2, l, string, string2, bundle, bl, bl2));
    }

    public final void zzB(int n, String string, Object object, Object object2, Object object3) {
        zzff zzff2 = this;
        zzff2.zzW(new zzeh(zzff2, false, 5, string, object, null, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzC(zzkc zzkc2) {
        int n;
        Preconditions.checkNotNull((Object)zzkc2);
        List list = this.zzf;
        // MONITORENTER : list
        for (int i = 0; i < (n = list.size()); ++i) {
            n = zzkc2.equals(((Pair)list.get((int)i)).first) ? 1 : 0;
            if (n == 0) continue;
            Log.w((String)this.zzd, (String)"OnEventListener already registered.");
            // MONITOREXIT : list
            return;
        }
        zzew zzew2 = new zzew(zzkc2);
        list.add(new Pair((Object)zzkc2, (Object)zzew2));
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzde)zzew2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzff zzff2 = this;
        zzff2.zzW(new zzer(zzff2, zzew2));
    }

    public final void zzD() {
        zzff zzff2 = this;
        zzff2.zzW(new zzdt(zzff2));
    }

    public final void zzE(Runnable runnable) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdz(zzff2, runnable));
    }

    private final void zzW(zzeu zzeu2) {
        this.zzb.execute(zzeu2);
    }

    public final void zzF(Bundle bundle) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdm(zzff2, bundle));
    }

    public final void zzG(Bundle bundle) {
        zzff zzff2 = this;
        zzff2.zzW(new zzds(zzff2, bundle));
    }

    public final void zzH(zzdj zzdj2, String string, String string2) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdq(zzff2, zzdj2, string, string2));
    }

    public final void zzI(boolean bl) {
        zzff zzff2 = this;
        zzff2.zzW(new zzen(zzff2, bl));
    }

    public final void zzJ(Bundle bundle) {
        zzff zzff2 = this;
        zzff2.zzW(new zzeo(zzff2, bundle));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzK(zzkb zzkb2) {
        zzev zzev2 = new zzev(zzkb2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzde)zzev2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzff zzff2 = this;
        zzff2.zzW(new zzep(zzff2, zzev2));
    }

    public final void zzL(Boolean bl) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdr(zzff2, bl));
    }

    public final void zzM(long l) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdv(zzff2, l));
    }

    public final void zzN(Intent intent) {
        zzff zzff2 = this;
        zzff2.zzW(new zzeq(zzff2, intent));
    }

    public final void zzO(String string) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdp(zzff2, string));
    }

    public final void zzP(String string, String string2, Object object, boolean bl) {
        zzff zzff2 = this;
        zzff2.zzW(new zzdl(zzff2, string, string2, object, bl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzQ(zzkc object) {
        List list;
        block8: {
            int n;
            Preconditions.checkNotNull((Object)object);
            list = this.zzf;
            // MONITORENTER : list
            for (int i = 0; i < (n = list.size()); ++i) {
                n = object.equals(((Pair)list.get((int)i)).first) ? 1 : 0;
                if (n == 0) continue;
                object = (Pair)list.get(i);
                break block8;
            }
            object = null;
        }
        if (object == null) {
            Log.w((String)this.zzd, (String)"OnEventListener had not been registered.");
            // MONITOREXIT : list
            return;
        }
        list.remove(object);
        object = (zzew)((Object)object.second);
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzde)object);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzff zzff2 = this;
        zzff2.zzW(new zzes(zzff2, (zzew)((Object)object)));
    }

    static /* bridge */ /* synthetic */ boolean zzR(zzff zzff2) {
        return zzff2.zzh;
    }

    static /* bridge */ /* synthetic */ boolean zzS(zzff zzff2, String string, String string2) {
        return zzff2.zzX(string, string2);
    }

    private final boolean zzX(String string, String string2) {
        return string2 != null && string != null && !this.zzT();
    }

    protected final boolean zzT() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

