/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzqw;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zznw;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzdg {
    @VisibleForTesting
    @MonotonicNonNull zzho zza = null;
    @GuardedBy(value="listenerMap")
    private final Map<Integer, zziz> zzb = new ArrayMap();

    public void beginAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zza(string, l);
    }

    @EnsuresNonNull(value={"scion"})
    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void clearConditionalUserProperty(@NonNull String string, @NonNull @Nullable String string2, @NonNull @Nullable Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle);
    }

    public void clearMeasurementEnabled(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(null);
    }

    public void endAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zzb(string, l);
    }

    public void generateEventId(zzdi zzdi2) throws RemoteException {
        this.zza();
        long l = this.zza.zzt().zzm();
        zzdi zzdi3 = zzdi2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzt().zza(zzdi3, l);
    }

    public void getAppInstanceId(zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzh(this, zzdi2));
    }

    public void getCachedAppInstanceId(zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza(zzdi2, this.zza.zzp().zzae());
    }

    public void getConditionalUserProperties(@Nullable String string, @Nullable String string2, zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzk(this, zzdi2, string, string2));
    }

    public void getCurrentScreenClass(zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza(zzdi2, this.zza.zzp().zzaf());
    }

    public void getCurrentScreenName(zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza(zzdi2, this.zza.zzp().zzag());
    }

    public void getGmpAppId(zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza(zzdi2, this.zza.zzp().zzah());
    }

    public void getMaxUserProperties(String string, zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza.zzp();
        Preconditions.checkNotEmpty((String)string);
        zzdi zzdi3 = zzdi2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzt().zza(zzdi3, 25);
    }

    public void getSessionId(zzdi zzdi2) throws RemoteException {
        this.zza();
        zzdi zzdi3 = zzdi2;
        zzja zzja2 = this.zza.zzp();
        zzja2.zzl().zzb((Runnable)new zzkf(zzja2, zzdi3));
    }

    public void getTestFlag(zzdi zzdi2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzt().zza(zzdi2, this.zza.zzp().zzai());
                return;
            }
            case 1: {
                this.zza.zzt().zza(zzdi2, this.zza.zzp().zzad().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzp().zzab();
                zzdi zzdi3 = zzdi2;
                zznw zznw2 = this.zza.zzt();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzdi3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zznw2.zzu.zzj().zzu().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzt().zza(zzdi2, this.zza.zzp().zzac().intValue());
                return;
            }
            case 4: {
                this.zza.zzt().zza(zzdi2, this.zza.zzp().zzaa().booleanValue());
            }
        }
    }

    public void getUserProperties(@Nullable String string, @Nullable String string2, boolean bl, zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzi(this, zzdi2, string, string2, bl));
    }

    public void initForTests(@NonNull Map map) throws RemoteException {
        this.zza();
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzdq zzdq2, long l) throws RemoteException {
        if (this.zza == null) {
            this.zza = zzho.zza((Context)((Context)Preconditions.checkNotNull((Object)((Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)))), (zzdq)zzdq2, (Long)l);
            return;
        }
        this.zza.zzj().zzu().zza("Attempting to initialize multiple times");
    }

    public void isDataCollectionEnabled(zzdi zzdi2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzm(this, zzdi2));
    }

    public void logEvent(@NonNull @Nullable String string, @NonNull String string2, @NonNull @Nullable Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle, bl, bl2, l);
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzdi zzdi2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzbf zzbf2 = new zzbf(string2, new zzba(bundle), string3, l);
        this.zza.zzl().zzb((Runnable)new zzj(this, zzdi2, zzbf2, string));
    }

    public void logHealthData(int n, @NonNull String string, @NonNull IObjectWrapper iObjectWrapper, @NonNull IObjectWrapper iObjectWrapper2, @NonNull IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzj().zza(n, true, false, string, object, object2, object3);
    }

    public void onActivityCreated(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable Bundle bundle, long l) throws RemoteException {
        this.zza();
        zzkm zzkm2 = this.zza.zzp().zza;
        if (zzkm2 != null) {
            this.zza.zzp().zzal();
            zzkm2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzkm zzkm2 = this.zza.zzp().zza;
        if (zzkm2 != null) {
            this.zza.zzp().zzal();
            zzkm2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzkm zzkm2 = this.zza.zzp().zza;
        if (zzkm2 != null) {
            this.zza.zzp().zzal();
            zzkm2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzkm zzkm2 = this.zza.zzp().zza;
        if (zzkm2 != null) {
            this.zza.zzp().zzal();
            zzkm2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzdi zzdi2, long l) throws RemoteException {
        this.zza();
        zzkm zzkm2 = this.zza.zzp().zza;
        Bundle bundle = new Bundle();
        if (zzkm2 != null) {
            this.zza.zzp().zzal();
            zzkm2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzdi2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzj().zzu().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void onActivityStarted(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzkm zzkm2 = this.zza.zzp().zza;
        if (zzkm2 != null) {
            this.zza.zzp().zzal();
            zzkm2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzkm zzkm2 = this.zza.zzp().zza;
        if (zzkm2 != null) {
            this.zza.zzp().zzal();
            zzkm2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void performAction(Bundle bundle, zzdi zzdi2, long l) throws RemoteException {
        this.zza();
        zzdi2.zza(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnMeasurementEventListener(zzdj zzdj2) throws RemoteException {
        zziz zziz2;
        this.zza();
        Map<Integer, zziz> map = this.zzb;
        synchronized (map) {
            zziz2 = this.zzb.get(zzdj2.zza());
            if (zziz2 == null) {
                zziz2 = new zzb(zzdj2);
                this.zzb.put(zzdj2.zza(), zziz2);
            }
        }
        this.zza.zzp().zza(zziz2);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        zzja zzja2 = this.zza.zzp();
        zzja2.zza(null);
        zzja2.zzl().zzb((Runnable)new zzjy(zzja2, l));
    }

    private final void zza(zzdi zzdi2, @Nullable String string) {
        this.zza();
        this.zza.zzt().zza(zzdi2, string);
    }

    public void setConditionalUserProperty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzj().zzg().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzp().zza(bundle, l);
    }

    public void setConsent(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        Bundle bundle2 = bundle;
        zzja zzja2 = this.zza.zzp();
        Bundle bundle3 = bundle2;
        zzja zzja3 = zzja2;
        zzja2.zzl().zzc((Runnable)new zzjg(zzja3, bundle3, l));
    }

    public void setConsentThirdParty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(bundle, -20, l);
    }

    public void setCurrentScreen(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable String string, @NonNull @Nullable String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        zzja zzja2 = this.zza.zzp();
        zzja2.zzu();
        zzja2.zzl().zzb((Runnable)new zzjr(zzja2, bl));
    }

    public void setDefaultEventParameters(@NonNull @Nullable Bundle bundle) {
        Bundle bundle2;
        this.zza();
        Bundle bundle3 = bundle;
        zzja zzja2 = this.zza.zzp();
        Bundle bundle4 = bundle2 = bundle3 == null ? null : new Bundle(bundle3);
        zzja zzja3 = zzja2;
        zzja2.zzl().zzb((Runnable)new zzjh(zzja3, bundle4));
    }

    public void setEventInterceptor(zzdj zzdj2) throws RemoteException {
        this.zza();
        zza zza2 = new zza(zzdj2);
        if (this.zza.zzl().zzg()) {
            this.zza.zzp().zza((zziw)zza2);
            return;
        }
        this.zza.zzl().zzb((Runnable)new zzl(this, zza2));
    }

    public void setInstanceIdProvider(zzdo zzdo2) throws RemoteException {
        this.zza();
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(Boolean.valueOf(bl));
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        zzja zzja2 = this.zza.zzp();
        zzja2.zzl().zzb((Runnable)new zzjt(zzja2, l));
    }

    public void setSgtmDebugInfo(@NonNull Intent intent) throws RemoteException {
        this.zza();
        Intent intent2 = intent;
        zzja zzja2 = this.zza.zzp();
        if (zzqw.zza()) {
            zzfo zzfo2 = zzbh.zzbu;
            if (zzja2.zze().zzf(null, zzfo2)) {
                Uri uri = intent2.getData();
                if (uri == null) {
                    zzja2.zzj().zzn().zza("Activity intent has no data. Preview Mode was not enabled.");
                    return;
                }
                String string = uri.getQueryParameter("sgtm_debug_enable");
                if (string == null || !string.equals("1")) {
                    zzja2.zzj().zzn().zza("Preview Mode was not enabled.");
                    zzja2.zze().zzi(null);
                    return;
                }
                String string2 = uri.getQueryParameter("sgtm_preview_key");
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzja2.zzj().zzn().zza("Preview Mode was enabled. Using the sgtmPreviewKey: ", (Object)string2);
                    zzja2.zze().zzi(string2);
                }
            }
        }
    }

    public void setUserId(@NonNull @Nullable String string, long l) throws RemoteException {
        this.zza();
        String string2 = string;
        zzja zzja2 = this.zza.zzp();
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2)) {
            zzja2.zzu.zzj().zzu().zza("User ID must be non-empty or null");
            return;
        }
        String string3 = string2;
        zzja zzja3 = zzja2;
        zzja2.zzl().zzb((Runnable)new zzjl(zzja3, string3));
        zzja2.zza(null, "_id", (Object)string2, true, l);
    }

    public void setUserProperty(@NonNull @Nullable String string, @NonNull String string2, @NonNull IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzp().zza(string, string2, object, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnMeasurementEventListener(zzdj zzdj2) throws RemoteException {
        zziz zziz2;
        this.zza();
        Map<Integer, zziz> map = this.zzb;
        synchronized (map) {
            zziz2 = this.zzb.remove(zzdj2.zza());
        }
        if (zziz2 == null) {
            zziz2 = new zzb(zzdj2);
        }
        this.zza.zzp().zzb(zziz2);
    }

    final class zza
    implements zziw {
        private zzdj zza;

        zza(zzdj zzdj2) {
            this.zza = zzdj2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzu().zza("Event interceptor threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }

    final class zzb
    implements zziz {
        private zzdj zza;

        zzb(zzdj zzdj2) {
            this.zza = zzdj2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzu().zza("Event listener threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }
}

