/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzqd;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzdo {
    @VisibleForTesting
    @MonotonicNonNull zzim zza = null;
    @GuardedBy(value="listenerMap")
    private final Map<Integer, zzke> zzb = new ArrayMap();

    public static /* synthetic */ void $r8$lambda$W3cgi1t5N0SU6fYxM9Fsh5qQfPc(AppMeasurementDynamiteService appMeasurementDynamiteService, zzdr zzdr2) {
        zzdr zzdr3 = zzdr2;
        AppMeasurementDynamiteService appMeasurementDynamiteService2 = appMeasurementDynamiteService;
        try {
            zzdr3.a_();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzim)Preconditions.checkNotNull((Object)appMeasurementDynamiteService2.zza)).zzj().zzr().zza("Failed to call IDynamiteUploadBatchesCallback", (Object)remoteException);
            return;
        }
    }

    public void beginAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zza(string, l);
    }

    @EnsuresNonNull(value={"scion"})
    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void clearConditionalUserProperty(@NonNull String string, @NonNull @Nullable String string2, @NonNull @Nullable Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle);
    }

    public void clearMeasurementEnabled(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(null);
    }

    public void endAdUnitExposure(@NonNull String string, long l) throws RemoteException {
        this.zza();
        this.zza.zze().zzb(string, l);
    }

    public void generateEventId(zzdq zzdq2) throws RemoteException {
        this.zza();
        long l = this.zza.zzv().zzo();
        zzdq zzdq3 = zzdq2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzv().zza(zzdq3, l);
    }

    public void getAppInstanceId(zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzk(this, zzdq2));
    }

    public void getCachedAppInstanceId(zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza(zzdq2, this.zza.zzp().zzai());
    }

    public void getConditionalUserProperties(@Nullable String string, @Nullable String string2, zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzo(this, zzdq2, string, string2));
    }

    public void getCurrentScreenClass(zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza(zzdq2, this.zza.zzp().zzaj());
    }

    public void getCurrentScreenName(zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza(zzdq2, this.zza.zzp().zzak());
    }

    public void getGmpAppId(zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza(zzdq2, this.zza.zzp().zzal());
    }

    public void getMaxUserProperties(String string, zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza.zzp();
        zzkf.zza((String)string);
        zzdq zzdq3 = zzdq2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        appMeasurementDynamiteService.zza();
        appMeasurementDynamiteService.zza.zzv().zza(zzdq3, 25);
    }

    public void getSessionId(zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(zzdq2);
    }

    public void getTestFlag(zzdq zzdq2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzv().zza(zzdq2, this.zza.zzp().zzam());
                return;
            }
            case 1: {
                this.zza.zzv().zza(zzdq2, this.zza.zzp().zzah().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzp().zzaf();
                zzdq zzdq3 = zzdq2;
                zzqd zzqd2 = this.zza.zzv();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzdq3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzqd2.zzu.zzj().zzr().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzv().zza(zzdq2, this.zza.zzp().zzag().intValue());
                return;
            }
            case 4: {
                this.zza.zzv().zza(zzdq2, this.zza.zzp().zzae().booleanValue());
            }
        }
    }

    public void getUserProperties(@Nullable String string, @Nullable String string2, boolean bl, zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzm(this, zzdq2, string, string2, bl));
    }

    public void initForTests(@NonNull Map map) throws RemoteException {
        this.zza();
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzdz zzdz2, long l) throws RemoteException {
        if (this.zza == null) {
            this.zza = zzim.zza((Context)((Context)Preconditions.checkNotNull((Object)((Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)))), (zzdz)zzdz2, (Long)l);
            return;
        }
        this.zza.zzj().zzr().zza("Attempting to initialize multiple times");
    }

    public void isDataCollectionEnabled(zzdq zzdq2) throws RemoteException {
        this.zza();
        this.zza.zzl().zzb((Runnable)new zzn(this, zzdq2));
    }

    public void logEvent(@NonNull @Nullable String string, @NonNull String string2, @NonNull @Nullable Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, string2, bundle, bl, bl2, l);
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzdq zzdq2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzbj zzbj2 = new zzbj(string2, new zzbi(bundle), string3, l);
        this.zza.zzl().zzb((Runnable)new zzj(this, zzdq2, zzbj2, string));
    }

    public void logHealthData(int n, @NonNull String string, @NonNull IObjectWrapper iObjectWrapper, @NonNull IObjectWrapper iObjectWrapper2, @NonNull IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzj().zza(n, true, false, string, object, object2, object3);
    }

    public void onActivityCreated(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable Bundle bundle, long l) throws RemoteException {
        this.zza();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)));
        this.onActivityCreatedByScionActivityInfo(zzeb.zza((Activity)activity), bundle, l);
    }

    public void onActivityCreatedByScionActivityInfo(zzeb zzeb2, @Nullable Bundle bundle, long l) {
        this.zza();
        zzlw zzlw2 = this.zza.zzp().zzad();
        if (zzlw2 != null) {
            this.zza.zzp().zzar();
            zzlw2.zza(zzeb2, bundle);
        }
    }

    public void onActivityDestroyed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)));
        this.onActivityDestroyedByScionActivityInfo(zzeb.zza((Activity)activity), l);
    }

    public void onActivityDestroyedByScionActivityInfo(zzeb zzeb2, long l) throws RemoteException {
        this.zza();
        zzlw zzlw2 = this.zza.zzp().zzad();
        if (zzlw2 != null) {
            this.zza.zzp().zzar();
            zzlw2.zza(zzeb2);
        }
    }

    public void onActivityPaused(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)));
        this.onActivityPausedByScionActivityInfo(zzeb.zza((Activity)activity), l);
    }

    public void onActivityPausedByScionActivityInfo(zzeb zzeb2, long l) throws RemoteException {
        this.zza();
        zzlw zzlw2 = this.zza.zzp().zzad();
        if (zzlw2 != null) {
            this.zza.zzp().zzar();
            zzlw2.zzb(zzeb2);
        }
    }

    public void onActivityResumed(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)));
        this.onActivityResumedByScionActivityInfo(zzeb.zza((Activity)activity), l);
    }

    public void onActivityResumedByScionActivityInfo(zzeb zzeb2, long l) throws RemoteException {
        this.zza();
        zzlw zzlw2 = this.zza.zzp().zzad();
        if (zzlw2 != null) {
            this.zza.zzp().zzar();
            zzlw2.zzc(zzeb2);
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzdq zzdq2, long l) throws RemoteException {
        this.zza();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)));
        this.onActivitySaveInstanceStateByScionActivityInfo(zzeb.zza((Activity)activity), zzdq2, l);
    }

    public void onActivitySaveInstanceStateByScionActivityInfo(zzeb zzeb2, zzdq zzdq2, long l) throws RemoteException {
        this.zza();
        zzlw zzlw2 = this.zza.zzp().zzad();
        Bundle bundle = new Bundle();
        if (zzlw2 != null) {
            this.zza.zzp().zzar();
            zzlw2.zzb(zzeb2, bundle);
        }
        try {
            zzdq2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzj().zzr().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void onActivityStarted(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)));
        this.onActivityStartedByScionActivityInfo(zzeb.zza((Activity)activity), l);
    }

    public void onActivityStartedByScionActivityInfo(zzeb zzeb2, long l) throws RemoteException {
        this.zza();
        if (this.zza.zzp().zzad() != null) {
            this.zza.zzp().zzar();
        }
    }

    public void onActivityStopped(@NonNull IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)));
        this.onActivityStoppedByScionActivityInfo(zzeb.zza((Activity)activity), l);
    }

    public void onActivityStoppedByScionActivityInfo(zzeb zzeb2, long l) throws RemoteException {
        this.zza();
        if (this.zza.zzp().zzad() != null) {
            this.zza.zzp().zzar();
        }
    }

    public void performAction(Bundle bundle, zzdq zzdq2, long l) throws RemoteException {
        this.zza();
        zzdq2.zza(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnMeasurementEventListener(zzdw zzdw2) throws RemoteException {
        zzke zzke2;
        this.zza();
        Map<Integer, zzke> map = this.zzb;
        synchronized (map) {
            zzke2 = this.zzb.get(zzdw2.zza());
            if (zzke2 == null) {
                zzke2 = new zza(zzdw2);
                this.zzb.put(zzdw2.zza(), zzke2);
            }
        }
        this.zza.zzp().zza(zzke2);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(l);
    }

    public void retrieveAndUploadBatches(zzdr zzdr2) {
        this.zza();
        zzgi zzgi2 = zzbl.zzcq;
        if (!this.zza.zzf().zzf(null, zzgi2)) {
            return;
        }
        zzdr zzdr3 = zzdr2;
        AppMeasurementDynamiteService appMeasurementDynamiteService = this;
        this.zza.zzp().zza((Runnable)new zzi(appMeasurementDynamiteService, zzdr3));
    }

    private final void zza(zzdq zzdq2, @Nullable String string) {
        this.zza();
        this.zza.zzv().zza(zzdq2, string);
    }

    public void setConditionalUserProperty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzj().zzg().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzp().zza(bundle, l);
    }

    public void setConsent(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzb(bundle, l);
    }

    public void setConsentThirdParty(@NonNull Bundle bundle, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzc(bundle, l);
    }

    public void setCurrentScreen(@NonNull IObjectWrapper iObjectWrapper, @NonNull @Nullable String string, @NonNull @Nullable String string2, long l) throws RemoteException {
        this.zza();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)));
        this.setCurrentScreenByScionActivityInfo(zzeb.zza((Activity)activity), string, string2, l);
    }

    public void setCurrentScreenByScionActivityInfo(zzeb zzeb2, @Nullable String string, @Nullable String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzs().zza(zzeb2, string, string2);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        this.zza.zzp().zzc(bl);
    }

    public void setDefaultEventParameters(@NonNull @Nullable Bundle bundle) {
        this.zza();
        this.zza.zzp().zzb(bundle);
    }

    public void setEventInterceptor(zzdw zzdw2) throws RemoteException {
        this.zza();
        zzb zzb2 = new zzb(zzdw2);
        if (this.zza.zzl().zzm()) {
            this.zza.zzp().zza((zzkb)zzb2);
            return;
        }
        this.zza.zzl().zzb((Runnable)new zzl(this, zzb2));
    }

    public void setInstanceIdProvider(zzdx zzdx2) throws RemoteException {
        this.zza();
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(Boolean.valueOf(bl));
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zzd(l);
    }

    public void setSgtmDebugInfo(@NonNull Intent intent) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(intent);
    }

    public void setUserId(@NonNull @Nullable String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzp().zza(string, l);
    }

    public void setUserProperty(@NonNull @Nullable String string, @NonNull String string2, @NonNull IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzp().zza(string, string2, object, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnMeasurementEventListener(zzdw zzdw2) throws RemoteException {
        zzke zzke2;
        this.zza();
        Map<Integer, zzke> map = this.zzb;
        synchronized (map) {
            zzke2 = this.zzb.remove(zzdw2.zza());
        }
        if (zzke2 == null) {
            zzke2 = new zza(zzdw2);
        }
        this.zza.zzp().zzb(zzke2);
    }

    final class zzb
    implements zzkb {
        private zzdw zza;

        zzb(zzdw zzdw2) {
            this.zza = zzdw2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzr().zza("Event interceptor threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }

    final class zza
    implements zzke {
        private zzdw zza;

        zza(zzdw zzdw2) {
            this.zza = zzdw2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                if (AppMeasurementDynamiteService.this.zza != null) {
                    AppMeasurementDynamiteService.this.zza.zzj().zzr().zza("Event listener threw exception", (Object)remoteException);
                }
                return;
            }
        }
    }
}

