/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcd;
import com.google.android.gms.internal.measurement.zzce;
import com.google.android.gms.internal.measurement.zzim;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.internal.measurement.zzip;
import com.google.android.gms.internal.measurement.zziv;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzcx;
import com.google.android.gms.measurement.internal.zzcy;
import com.google.android.gms.measurement.internal.zzcz;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import java.io.IOException;
import java.util.Map;

public final class zzbs
extends zzfs
implements zzv {
    @VisibleForTesting
    private static int zzmp = 65535;
    @VisibleForTesting
    private static int zzmq = 2;
    private final Map<String, Map<String, String>> zzmr = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzms = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzmt = new ArrayMap();
    private final Map<String, zzce> zzmu = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzmv;
    private final Map<String, String> zzmw = new ArrayMap();

    zzbs(zzft zzft2) {
        super(zzft2);
        this.zzmv = new ArrayMap();
    }

    @WorkerThread
    private final void zzax(String string) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzmu.get(string) == null) {
            byte[] byArray = ((zzfr)this).zzdo().zzag(string);
            if (byArray == null) {
                this.zzmr.put(string, null);
                this.zzms.put(string, null);
                this.zzmt.put(string, null);
                this.zzmu.put(string, null);
                this.zzmw.put(string, null);
                this.zzmv.put(string, null);
                return;
            }
            zzce zzce2 = this.zza(string, byArray);
            this.zzmr.put(string, zzbs.zza(zzce2));
            this.zza(string, zzce2);
            this.zzmu.put(string, zzce2);
            this.zzmw.put(string, null);
        }
    }

    @WorkerThread
    protected final zzce zzay(String string) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        this.zzax(string);
        return this.zzmu.get(string);
    }

    @WorkerThread
    protected final String zzaz(String string) {
        this.zzq();
        return this.zzmw.get(string);
    }

    @WorkerThread
    protected final void zzba(String string) {
        this.zzq();
        this.zzmw.put(string, null);
    }

    @WorkerThread
    final void zzbb(String string) {
        this.zzq();
        this.zzmu.remove(string);
    }

    @WorkerThread
    final boolean zzbc(String string) {
        this.zzq();
        Boolean bl = this.zzay((String)string).zzxg;
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @WorkerThread
    public final String zzb(String string, String string2) {
        this.zzq();
        this.zzax(string);
        Map<String, String> map = this.zzmr.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzce zzce2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzce2 != null && zzce2.zzxc != null) {
            zzbr.zza[] zzaArray = zzce2.zzxc;
            int n = zzce2.zzxc.length;
            for (int i = 0; i < n; ++i) {
                zzbr.zza zza2 = zzaArray[i];
                if (zza2 == null) continue;
                arrayMap.put(zza2.getKey(), zza2.getValue());
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzce zzce2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzce2 != null && zzce2.zzxd != null) {
            zzcd[] zzcdArray = zzce2.zzxd;
            int n = zzce2.zzxd.length;
            for (int i = 0; i < n; ++i) {
                zzcd zzcd2 = zzcdArray[i];
                if (TextUtils.isEmpty((CharSequence)zzcd2.name)) {
                    this.zzad().zzdd().zzaq("EventConfig contained null event name");
                    continue;
                }
                String string2 = zzcx.zzbh((String)zzcd2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzcd2.name = string2;
                }
                arrayMap.put(zzcd2.name, zzcd2.zzwx);
                arrayMap2.put(zzcd2.name, zzcd2.zzwy);
                if (zzcd2.zzwz == null) continue;
                if (zzcd2.zzwz < zzmq || zzcd2.zzwz > zzmp) {
                    this.zzad().zzdd().zza("Invalid sampling rate. Event name, sample rate", (Object)zzcd2.name, (Object)zzcd2.zzwz);
                    continue;
                }
                arrayMap3.put(zzcd2.name, zzcd2.zzwz);
            }
        }
        this.zzms.put(string, (Map<String, Boolean>)arrayMap);
        this.zzmt.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzmv.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        zzce zzce2 = this.zza(string, byArray);
        if (zzce2 == null) {
            return false;
        }
        this.zza(string, zzce2);
        this.zzmu.put(string, zzce2);
        this.zzmw.put(string, string2);
        this.zzmr.put(string, zzbs.zza(zzce2));
        Object object = zzce2.zzxe;
        String string3 = string;
        Object object2 = ((zzfr)this).zzdn();
        Preconditions.checkNotNull((Object)object);
        for (zzbx zzbx2 : object) {
            String string4;
            zzip zzip2;
            int n;
            zzip[] zzipArray = zzbx2.zzvw;
            int n2 = zzbx2.zzvw.length;
            for (n = 0; n < n2; ++n) {
                zzip2 = zzipArray[n];
                string4 = zzcx.zzbh((String)zzip2.zzwb);
                if (string4 != null) {
                    zzip2.zzwb = string4;
                }
                zzbz[] zzbzArray = zzip2.zzwc;
                int n3 = zzip2.zzwc.length;
                for (int i = 0; i < n3; ++i) {
                    zzbz zzbz2 = zzbzArray[i];
                    String string5 = zzcy.zzbh((String)zzbz2.zzwj);
                    if (string5 == null) continue;
                    zzbz2.zzwj = string5;
                }
            }
            zzipArray = zzbx2.zzvv;
            n2 = zzbx2.zzvv.length;
            for (n = 0; n < n2; ++n) {
                zzip2 = zzipArray[n];
                string4 = zzcz.zzbh((String)((zzcb)zzip2).zzwq);
                if (string4 == null) continue;
                ((zzcb)zzip2).zzwq = string4;
            }
        }
        ((zzfr)((Object)object2)).zzdo().zza(string3, (zzbx[])object);
        try {
            zzce2.zzxe = null;
            byte[] byArray2 = new byte[zzce2.zzly()];
            object2 = byArray2;
            zzin zzin2 = zzin.zzk(byArray2, 0, ((zzo)object2).length);
            ((zziv)zzce2).zza(zzin2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            this.zzad().zzdd().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzau.zzao((String)string), (Object)iOException);
        }
        object = byArray;
        string3 = string;
        object2 = ((zzfr)this).zzdo();
        Preconditions.checkNotEmpty((String)string3);
        object2.zzq();
        ((zzfs)((Object)object2)).zzah();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzw)((Object)object2)).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                object2.zzad().zzda().zza("Failed to update remote config (got 0). appId", zzau.zzao((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            object2.zzad().zzda().zza("Error storing remote config. appId", zzau.zzao((String)string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzk(String string, String string2) {
        this.zzq();
        this.zzax(string);
        if (this.zzbe(string) && zzgd.zzbs((String)string2)) {
            return true;
        }
        if (this.zzbf(string) && zzgd.zzbm((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzms.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzl(String string, String string2) {
        this.zzq();
        this.zzax(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzmt.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzm(String string, String string2) {
        this.zzq();
        this.zzax(string);
        Map<String, Integer> map = this.zzmv.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzbd(String string) {
        String string2 = this.zzb(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzad().zzdd().zza("Unable to parse timezone offset. appId", zzau.zzao((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzce zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzce();
        }
        byte[] byArray2 = byArray;
        zzim zzim2 = zzim.zzj(byArray, 0, byArray2.length);
        zzce zzce2 = new zzce();
        try {
            ((zziv)zzce2).zza(zzim2);
            this.zzad().zzdi().zza("Parsed config. version, gmp_app_id", (Object)zzce2.zzxa, (Object)zzce2.zzch);
        }
        catch (IOException iOException) {
            this.zzad().zzdd().zza("Unable to merge remote config. appId", zzau.zzao((String)string), (Object)iOException);
            return new zzce();
        }
        return zzce2;
    }

    final boolean zzbe(String string) {
        return "1".equals(this.zzb(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzbf(String string) {
        return "1".equals(this.zzb(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzak() {
        return false;
    }
}

