/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.Context;
import android.os.Build;
import android.os.UserHandle;
import android.support.annotation.Nullable;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@TargetApi(value=24)
public final class zzi {
    private final JobScheduler zzf;
    @Nullable
    private static final Method zzg = zzi.zza();
    @Nullable
    private static final Method zzh = zzi.zzb();

    @Nullable
    private static Method zza() {
        block3: {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return JobScheduler.class.getDeclaredMethod("scheduleAsPackage", JobInfo.class, String.class, Integer.TYPE, String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"No scheduleAsPackage method available, falling back to schedule");
                }
            }
        }
        return null;
    }

    @Nullable
    private static Method zzb() {
        block3: {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return UserHandle.class.getDeclaredMethod("myUserId", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"No myUserId method available");
                }
            }
        }
        return null;
    }

    private static int zzc() {
        block3: {
            if (zzh != null) {
                try {
                    return (Integer)zzh.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"myUserId invocation illegal", (Throwable)reflectiveOperationException);
                }
            }
        }
        return 0;
    }

    private zzi(JobScheduler jobScheduler) {
        this.zzf = jobScheduler;
    }

    private final int zza(JobInfo jobInfo, String string, int n, String string2) {
        if (zzg != null) {
            try {
                return (Integer)zzg.invoke((Object)this.zzf, jobInfo, string, n, string2);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                Log.e((String)string2, (String)"error calling scheduleAsPackage", (Throwable)reflectiveOperationException);
            }
        }
        return this.zzf.schedule(jobInfo);
    }

    public static int zza(Context context, JobInfo jobInfo, String string, String string2) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (zzg == null || context.checkSelfPermission("android.permission.UPDATE_DEVICE_STATS") != 0) {
            return jobScheduler.schedule(jobInfo);
        }
        return new zzi(jobScheduler).zza(jobInfo, string, zzi.zzc(), string2);
    }
}

