/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzfk
extends zzdw {
    private final zzjg zzkz;
    private Boolean zzpb;
    @Nullable
    private String zzpc;

    public zzfk(zzjg zzjg2) {
        this(zzjg2, null);
    }

    private zzfk(zzjg zzjg2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzjg2);
        this.zzkz = zzjg2;
        this.zzpc = null;
    }

    @BinderThread
    public final void zzb(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zzc(new zzfn(this, zzn2));
    }

    @BinderThread
    public final void zza(zzai zzai2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzai2);
        this.zzb(zzn2, false);
        this.zzc(new zzfx(this, zzai2, zzn2));
    }

    @VisibleForTesting
    final zzai zzb(zzai zzai2, zzn zzn2) {
        String string;
        zzn zzn3 = zzn2;
        zzai zzai3 = zzai2;
        zzfk zzfk2 = this;
        if (!"_cmp".equals(zzai3.name) || zzai3.zzfq == null || zzai3.zzfq.size() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzai3.zzfq.getString("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzfk2.zzkz.zzad().zzt(zzn3.packageName)) {
            this.zzkz.zzab().zzgq().zza("Event has been filtered ", (Object)zzai2.toString());
            return new zzai("_cmpx", zzai2.zzfq, zzai2.origin, zzai2.zzfu);
        }
        return zzai2;
    }

    @BinderThread
    public final void zza(zzai zzai2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zzc(new zzfw(this, zzai2, string));
    }

    @BinderThread
    public final byte[] zza(zzai zzai2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzai2);
        this.zza(string, true);
        this.zzkz.zzab().zzgr().zza("Log and bundle. event", (Object)this.zzkz.zzy().zzaj(zzai2.name));
        long l = this.zzkz.zzx().nanoTime() / 1000000L;
        Future future = this.zzkz.zzaa().zzb((Callable)new zzfz(this, zzai2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zzkz.zzab().zzgk().zza("Log and bundle returned null. appId", zzef.zzam((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zzkz.zzx().nanoTime() / 1000000L;
            this.zzkz.zzab().zzgr().zza("Log and bundle processed. event, size, time_ms", (Object)this.zzkz.zzy().zzaj(zzai2.name), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkz.zzab().zzgk().zza("Failed to log and bundle. appId, event, error", zzef.zzam((String)string), (Object)this.zzkz.zzy().zzaj(zzai2.name), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzjn zzjn2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzjn2);
        this.zzb(zzn2, false);
        if (zzjn2.getValue() == null) {
            this.zzc(new zzfy(this, zzjn2, zzn2));
            return;
        }
        this.zzc(new zzgb(this, zzjn2, zzn2));
    }

    @BinderThread
    public final List<zzjn> zza(zzn zzn2, boolean bl) {
        this.zzb(zzn2, false);
        Future future = this.zzkz.zzaa().zza((Callable)new zzga(this, zzn2));
        try {
            List list = (List)future.get();
            ArrayList<zzjn> arrayList = new ArrayList<zzjn>(list.size());
            for (zzjp zzjp2 : list) {
                if (!bl && zzjs.zzbq((String)zzjp2.name)) continue;
                arrayList.add(new zzjn(zzjp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkz.zzab().zzgk().zza("Failed to get user attributes. appId", zzef.zzam((String)zzn2.packageName), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zzc(new zzgd(this, zzn2));
    }

    @BinderThread
    private final void zzb(zzn zzn2, boolean bl) {
        Preconditions.checkNotNull((Object)zzn2);
        this.zza(zzn2.packageName, false);
        this.zzkz.zzz().zzr(zzn2.zzcg, zzn2.zzcu);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzkz.zzab().zzgk().zzao("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzfk zzfk2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzfk2 = this;
                    if (!bl2) break block9;
                    if (zzfk2.zzpb == null) {
                        zzfk2.zzpb = "com.google.android.gms".equals(zzfk2.zzpc) || UidVerifier.isGooglePlayServicesUid((Context)zzfk2.zzkz.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzfk2.zzkz.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzfk2.zzpb.booleanValue()) break block10;
                }
                if (zzfk2.zzpc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzfk2.zzkz.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzfk2.zzpc = string2;
                }
                if (!string2.equals(zzfk2.zzpc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzkz.zzab().zzgk().zza("Measurement Service called with invalid calling package. appId", zzef.zzam((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzc(new zzgc(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzn zzn2) {
        this.zzb(zzn2, false);
        return this.zzkz.zzh(zzn2);
    }

    @BinderThread
    public final void zza(zzq zzq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotNull((Object)zzq2.zzdw);
        this.zzb(zzn2, false);
        zzq zzq3 = new zzq(zzq2);
        new zzq(zzq2).packageName = zzn2.packageName;
        if (zzq2.zzdw.getValue() == null) {
            this.zzc(new zzfm(this, zzq3, zzn2));
            return;
        }
        this.zzc(new zzfp(this, zzq3, zzn2));
    }

    @BinderThread
    public final void zzb(zzq zzq2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotNull((Object)zzq2.zzdw);
        this.zza(zzq2.packageName, true);
        zzq zzq3 = new zzq(zzq2);
        if (zzq2.zzdw.getValue() == null) {
            this.zzc(new zzfo(this, zzq3));
            return;
        }
        this.zzc(new zzfr(this, zzq3));
    }

    @BinderThread
    public final List<zzjn> zza(String string, String string2, boolean bl, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zzkz.zzaa().zza((Callable)new zzfq(this, zzn2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzjn> arrayList = new ArrayList<zzjn>(list.size());
            for (zzjp zzjp2 : list) {
                if (!bl && zzjs.zzbq((String)zzjp2.name)) continue;
                arrayList.add(new zzjn(zzjp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkz.zzab().zzgk().zza("Failed to get user attributes. appId", zzef.zzam((String)zzn2.packageName), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzjn> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zzkz.zzaa().zza((Callable)new zzft(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzjn> arrayList = new ArrayList<zzjn>(list.size());
            for (zzjp zzjp2 : list) {
                if (!bl && zzjs.zzbq((String)zzjp2.name)) continue;
                arrayList.add(new zzjn(zzjp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkz.zzab().zzgk().zza("Failed to get user attributes. appId", zzef.zzam((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzq> zza(String string, String string2, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zzkz.zzaa().zza((Callable)new zzfs(this, zzn2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkz.zzab().zzgk().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzq> zzc(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zzkz.zzaa().zza((Callable)new zzfv(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzkz.zzab().zzgk().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzn zzn2) {
        this.zza(zzn2.packageName, false);
        this.zzc(new zzfu(this, zzn2));
    }

    @VisibleForTesting
    private final void zzc(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zzkz.zzaa().zzhp()) {
            runnable.run();
            return;
        }
        this.zzkz.zzaa().zza(runnable);
    }

    static /* synthetic */ zzjg zza(zzfk zzfk2) {
        return zzfk2.zzkz;
    }
}

