/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzr;

public final class zzit<T extends Context> {
    private final T zzrz;

    public zzit(T t) {
        Preconditions.checkNotNull(t);
        this.zzrz = t;
    }

    @MainThread
    public final void onCreate() {
        zzfj zzfj2 = zzfj.zza(this.zzrz, null);
        zzef zzef2 = zzfj2.zzab();
        zzr zzr2 = zzfj2.zzae();
        zzef2.zzgs().zzao("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzfj zzfj2 = zzfj.zza(this.zzrz, null);
        zzef zzef2 = zzfj2.zzab();
        zzr zzr2 = zzfj2.zzae();
        zzef2.zzgs().zzao("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzfj zzfj2 = zzfj.zza(this.zzrz, null);
        zzef zzef2 = zzfj2.zzab();
        if (intent == null) {
            zzef2.zzgn().zzao("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzr zzr2 = zzfj2.zzae();
        zzef2.zzgs().zza("Local AppMeasurementService called. startId, action", (Object)n2, (Object)string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zze(new zzis(this, n2, zzef2, intent));
        }
        return 2;
    }

    private final void zze(Runnable runnable) {
        zzjg zzjg2 = zzjg.zzm(this.zzrz);
        zzjg2.zzaa().zza((Runnable)new zziu(this, zzjg2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzab().zzgk().zzao("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzfk(zzjg.zzm(this.zzrz));
        }
        this.zzab().zzgn().zza("onBind received unknown action", (Object)string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzab().zzgk().zzao("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzab().zzgs().zza("onUnbind called for intent. action", (Object)string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzfj zzfj2 = zzfj.zza(this.zzrz, null);
        zzef zzef2 = zzfj2.zzab();
        String string = jobParameters.getExtras().getString("action");
        zzr zzr2 = zzfj2.zzae();
        zzef2.zzgs().zza("Local AppMeasurementJobService called. action", (Object)string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zze(new zziv(this, zzef2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzab().zzgk().zzao("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzab().zzgs().zza("onRebind called. action", (Object)string);
    }

    private final zzef zzab() {
        return zzfj.zza(this.zzrz, null).zzab();
    }

    final /* synthetic */ void zza(zzef zzef2, JobParameters jobParameters) {
        zzef2.zzgs().zzao("AppMeasurementJobService processed last upload request.");
        ((zzix)this.zzrz).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzef zzef2, Intent intent) {
        if (((zzix)this.zzrz).zza(n)) {
            zzef2.zzgs().zza("Local AppMeasurementService processed last upload request. StartId", (Object)n);
            this.zzab().zzgs().zzao("Completed wakeful intent.");
            ((zzix)this.zzrz).zza(intent);
        }
    }
}

