/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzi;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzr;

public final class zzjc
extends zzjh {
    private final AlarmManager zzsj = (AlarmManager)this.getContext().getSystemService("alarm");
    private final zzaa zzsk;
    private Integer zzsl;

    protected zzjc(zzjg zzjg2) {
        super(zzjg2);
        this.zzsk = new zzjf(this, (zzgh)zzjg2.zzjt(), zzjg2);
    }

    @Override
    protected final boolean zzbk() {
        this.zzsj.cancel(this.zzje());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzjd();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzjd() {
        JobScheduler jobScheduler = (JobScheduler)this.getContext().getSystemService("jobscheduler");
        int n = this.getJobId();
        this.zzab().zzgs().zza("Cancelling job. JobID", (Object)n);
        jobScheduler.cancel(n);
    }

    public final void zzv(long l) {
        this.zzbi();
        zzr zzr2 = this.zzae();
        Context context = this.getContext();
        if (!zzez.zzl((Context)context)) {
            this.zzab().zzgr().zzao("Receiver not registered/enabled");
        }
        if (!zzjs.zzb((Context)context, (boolean)false)) {
            this.zzab().zzgr().zzao("Service not registered/enabled");
        }
        this.cancel();
        long l2 = this.zzx().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzak.zzhc.get(null)) && !this.zzsk.zzcp()) {
            this.zzab().zzgs().zzao("Scheduling upload with DelayedRunnable");
            this.zzsk.zzv(l);
        }
        zzr2 = this.zzae();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzab().zzgs().zzao("Scheduling upload with JobScheduler");
            long l3 = l;
            zzjc zzjc2 = this;
            Context context2 = zzjc2.getContext();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzjc2.getJobId();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzjc2.zzab().zzgs().zza("Scheduling job. JobID", (Object)n);
            zzi.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        this.zzab().zzgs().zzao("Scheduling upload with AlarmManager");
        this.zzsj.setInexactRepeating(2, l2, Math.max((Long)zzak.zzgx.get(null), l), this.zzje());
    }

    private final int getJobId() {
        if (this.zzsl == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzsl = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzsl;
    }

    public final void cancel() {
        this.zzbi();
        this.zzsj.cancel(this.zzje());
        this.zzsk.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzjd();
        }
    }

    private final PendingIntent zzje() {
        Context context = this.getContext();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }
}

