/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzi;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzr;

public final class zzjl
extends zzjm {
    private final AlarmManager zzb = (AlarmManager)this.zzn().getSystemService("alarm");
    private final zzaa zzc;
    private Integer zzd;

    protected zzjl(zzjp zzjp2) {
        super(zzjp2);
        this.zzc = new zzjk(this, (zzgl)zzjp2.zzs(), zzjp2);
    }

    @Override
    protected final boolean zze() {
        this.zzb.cancel(this.zzw());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzk();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzk() {
        JobScheduler jobScheduler = (JobScheduler)this.zzn().getSystemService("jobscheduler");
        int n = this.zzv();
        this.zzr().zzx().zza("Cancelling job. JobID", (Object)n);
        jobScheduler.cancel(n);
    }

    public final void zza(long l) {
        this.zzak();
        zzr zzr2 = this.zzu();
        Context context = this.zzn();
        if (!zzfd.zza((Context)context)) {
            this.zzr().zzw().zza("Receiver not registered/enabled");
        }
        if (!zzjx.zza((Context)context, (boolean)false)) {
            this.zzr().zzw().zza("Service not registered/enabled");
        }
        this.zzf();
        long l2 = this.zzm().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzak.zzaa.zza(null)) && !this.zzc.zzb()) {
            this.zzr().zzx().zza("Scheduling upload with DelayedRunnable");
            this.zzc.zza(l);
        }
        zzr2 = this.zzu();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzr().zzx().zza("Scheduling upload with JobScheduler");
            long l3 = l;
            zzjl zzjl2 = this;
            Context context2 = zzjl2.zzn();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzjl2.zzv();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzjl2.zzr().zzx().zza("Scheduling job. JobID", (Object)n);
            zzi.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        this.zzr().zzx().zza("Scheduling upload with AlarmManager");
        this.zzb.setInexactRepeating(2, l2, Math.max((Long)zzak.zzv.zza(null), l), this.zzw());
    }

    private final int zzv() {
        if (this.zzd == null) {
            String string = String.valueOf(this.zzn().getPackageName());
            this.zzd = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzd;
    }

    public final void zzf() {
        this.zzak();
        this.zzb.cancel(this.zzw());
        this.zzc.zzc();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzk();
        }
    }

    private final PendingIntent zzw() {
        Context context = this.zzn();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }
}

