/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzbo;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzjp
implements zzgl {
    private static volatile zzjp zza;
    private zzfh zzb;
    private zzen zzc;
    private zzx zzd;
    private zzeq zze;
    private zzjl zzf;
    private zzp zzg;
    private final zzjt zzh;
    private zzhs zzi;
    private final zzfn zzj;
    private boolean zzk = false;
    private boolean zzl;
    private boolean zzm;
    @VisibleForTesting
    private long zzn;
    private List<Runnable> zzo;
    private int zzp;
    private int zzq;
    private boolean zzr;
    private boolean zzs;
    private boolean zzt;
    private FileLock zzu;
    private FileChannel zzv;
    private List<Long> zzw;
    private List<Long> zzx;
    private long zzy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzjp zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzjp> clazz = zzjp.class;
        synchronized (zzjp.class) {
            if (zza != null) return zza;
            zzju zzju2 = new zzju(context);
            zza = new zzjp(zzju2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    private zzjp(zzju zzju2) {
        this(zzju2, null);
    }

    private zzjp(zzju zzju2, zzfn zzfn2) {
        Preconditions.checkNotNull((Object)zzju2);
        this.zzj = zzfn2 = zzfn.zza((Context)zzju2.zza, null);
        this.zzy = -1L;
        zzjp zzjp2 = this;
        zzjt zzjt2 = new zzjt(zzjp2);
        zzjt2.zzal();
        this.zzh = zzjt2;
        zzjp2 = this;
        zzen zzen2 = new zzen(zzjp2);
        zzen2.zzal();
        this.zzc = zzen2;
        zzjp2 = this;
        zzfh zzfh2 = new zzfh(zzjp2);
        zzfh2.zzal();
        this.zzb = zzfh2;
        this.zzj.zzq().zza((Runnable)new zzjo(this, zzju2));
    }

    @WorkerThread
    private final void zza(zzju zzju2) {
        this.zzj.zzq().zzd();
        zzjp zzjp2 = this;
        zzx zzx2 = new zzx(zzjp2);
        zzx2.zzal();
        this.zzd = zzx2;
        this.zzj.zzb().zza((zzu)this.zzb);
        zzjp2 = this;
        zzp zzp2 = new zzp(zzjp2);
        zzp2.zzal();
        this.zzg = zzp2;
        zzjp2 = this;
        zzhs zzhs2 = new zzhs(zzjp2);
        zzhs2.zzal();
        this.zzi = zzhs2;
        zzjp2 = this;
        zzjl zzjl2 = new zzjl(zzjp2);
        zzjl2.zzal();
        this.zzf = zzjl2;
        zzjp2 = this;
        this.zze = new zzeq(zzjp2);
        if (this.zzp != this.zzq) {
            this.zzj.zzr().zzf().zza("Not all upload components initialized", (Object)this.zzp, (Object)this.zzq);
        }
        this.zzk = true;
    }

    @WorkerThread
    protected final void zza() {
        this.zzj.zzq().zzd();
        this.zze().zzv();
        if (this.zzj.zzc().zzc.zza() == 0L) {
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzz();
    }

    public final zzr zzu() {
        return this.zzj.zzu();
    }

    public final zzs zzb() {
        return this.zzj.zzb();
    }

    public final zzej zzr() {
        return this.zzj.zzr();
    }

    public final zzfg zzq() {
        return this.zzj.zzq();
    }

    public final zzfh zzc() {
        zzjp.zzb(this.zzb);
        return this.zzb;
    }

    public final zzen zzd() {
        zzjp.zzb(this.zzc);
        return this.zzc;
    }

    public final zzx zze() {
        zzjp.zzb(this.zzd);
        return this.zzd;
    }

    private final zzeq zzt() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    private final zzjl zzv() {
        zzjp.zzb(this.zzf);
        return this.zzf;
    }

    public final zzp zzf() {
        zzjp.zzb(this.zzg);
        return this.zzg;
    }

    public final zzhs zzg() {
        zzjp.zzb(this.zzi);
        return this.zzi;
    }

    public final zzjt zzh() {
        zzjp.zzb(this.zzh);
        return this.zzh;
    }

    public final zzeh zzi() {
        return this.zzj.zzj();
    }

    public final Context zzn() {
        return this.zzj.zzn();
    }

    public final Clock zzm() {
        return this.zzj.zzm();
    }

    public final zzjx zzj() {
        return this.zzj.zzi();
    }

    @WorkerThread
    private final void zzw() {
        this.zzj.zzq().zzd();
    }

    final void zzk() {
        if (!this.zzk) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zzb(zzjm zzjm2) {
        if (zzjm2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzjm2.zzaj()) {
            String string = String.valueOf(((Object)((Object)zzjm2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zza(zzn zzn2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotEmpty((String)zzn2.zza);
        this.zze(zzn2);
    }

    private final long zzx() {
        long l = this.zzj.zzm().currentTimeMillis();
        zzes zzes2 = this.zzj.zzc();
        zzes2.zzaa();
        zzes2.zzd();
        long l2 = zzes2.zzg.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzes2.zzp().zzh().nextInt(86400000);
            zzes2.zzg.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zza(zzai zzai2, String string) {
        zzf zzf2 = this.zze().zzb(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzj())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzb(zzf2);
        if (bl == null) {
            if (!"_ui".equals(zzai2.zza)) {
                this.zzj.zzr().zzi().zza("Could not find package. appId", zzej.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping event. appId", zzej.zza((String)string));
            return;
        }
        zzn zzn2 = new zzn(string, zzf2.zzd(), zzf2.zzj(), zzf2.zzk(), zzf2.zzl(), zzf2.zzm(), zzf2.zzn(), null, zzf2.zzp(), false, zzf2.zzg(), zzf2.zzac(), 0L, 0, zzf2.zzad(), zzf2.zzae(), false, zzf2.zze(), zzf2.zzaf(), zzf2.zzo(), zzf2.zzag());
        this.zza(zzai2, zzn2);
    }

    @WorkerThread
    final void zza(zzai zzai2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        this.zzw();
        this.zzk();
        String string = zzn2.zza;
        long l = zzai2.zzd;
        if (!this.zzh().zza(zzai2, zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zze(zzn2);
            return;
        }
        if (this.zzj.zzb().zze(string, zzak.zzbt) && zzn2.zzu != null) {
            if (zzn2.zzu.contains(zzai2.zza)) {
                Bundle bundle = zzai2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzai2 = new zzai(zzai2.zza, new zzah(bundle), zzai2.zzc, zzai2.zzd);
            } else {
                this.zzj.zzr().zzw().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzai2.zza, (Object)zzai2.zzc);
                return;
            }
        }
        this.zze().zzf();
        try {
            zzq zzq2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzx zzx2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzx2.zzd();
            zzx2.zzak();
            if (l2 < 0L) {
                zzx2.zzr().zzi().zza("Invalid time querying timed out conditional properties", zzej.zza((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzx2.zza(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj.zzr().zzw().zza("User property timed out", (Object)((zzq)object22).zza, (Object)this.zzj.zzj().zzc(((zzq)object22).zzc.zza), ((zzq)object22).zzc.zza());
                if (((zzq)object22).zzg != null) {
                    this.zzb(new zzai(((zzq)object22).zzg, l), zzn2);
                }
                this.zze().zze(string, ((zzq)object22).zzc.zza);
            }
            l2 = l;
            string3 = string;
            zzx2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzx2.zzd();
            zzx2.zzak();
            if (l2 < 0L) {
                zzx2.zzr().zzi().zza("Invalid time querying expired conditional properties", zzej.zza((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzx2.zza(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzq)object4.next();
                if (object == null) continue;
                this.zzj.zzr().zzw().zza("User property expired", (Object)((zzq)object).zza, (Object)this.zzj.zzj().zzc(((zzq)object).zzc.zza), ((zzq)object).zzc.zza());
                this.zze().zzb(string, ((zzq)object).zzc.zza);
                if (((zzq)object).zzk != null) {
                    object22.add(((zzq)object).zzk);
                }
                this.zze().zze(string, ((zzq)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzai)e;
                this.zzb(new zzai((zzai)object, l), zzn2);
            }
            long l3 = l;
            String string4 = zzai2.zza;
            string3 = string;
            zzx2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzx2.zzd();
            zzx2.zzak();
            if (l3 < 0L) {
                zzx2.zzr().zzi().zza("Invalid time querying triggered conditional properties", zzej.zza((String)string3), (Object)zzx2.zzo().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzx2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzq2 = (zzq)iterator.next();
                if (zzq2 == null) continue;
                zzjw zzjw2 = zzq2.zzc;
                zzjy zzjy2 = new zzjy(zzq2.zza, zzq2.zzb, zzjw2.zza, l, zzjw2.zza());
                if (this.zze().zza(zzjy2)) {
                    this.zzj.zzr().zzw().zza("User property triggered", (Object)zzq2.zza, (Object)this.zzj.zzj().zzc(zzjy2.zzc), zzjy2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("Too many active user properties, ignoring", zzej.zza((String)zzq2.zza), (Object)this.zzj.zzj().zzc(zzjy2.zzc), zzjy2.zze);
                }
                if (zzq2.zzi != null) {
                    object.add(zzq2.zzi);
                }
                zzq2.zzc = new zzjw(zzjy2);
                zzq2.zze = true;
                this.zze().zza(zzq2);
            }
            this.zzb(zzai2, zzn2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzq2 = (zzai)e;
                this.zzb(new zzai((zzai)zzq2, l), zzn2);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzb(zzai var1_1, zzn var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzw();
        this.zzk();
        var5_4 = var2_2.zza;
        if (!this.zzh().zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zze(var2_2);
            return;
        }
        if (this.zzc().zzb(var5_4, var1_1.zza)) {
            this.zzj.zzr().zzi().zza("Dropping blacklisted event. appId", zzej.zza((String)var5_4), (Object)this.zzj.zzj().zza(var1_1.zza));
            var6_5 = this.zzc().zzg(var5_4) != false || this.zzc().zzh(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzj.zzi().zza(var5_4, 11, "_ev", var1_1.zza, 0);
            }
            if (var6_5 && (var7_7 = this.zze().zzb(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzs(), var7_7.zzr());
                if (Math.abs(this.zzj.zzm().currentTimeMillis() - var8_9) > (Long)zzak.zzac.zza(null)) {
                    this.zzj.zzr().zzw().zza("Fetching config for blacklisted app");
                    this.zza(var7_7);
                }
            }
            return;
        }
        if (this.zzj.zzr().zza(2)) {
            this.zzj.zzr().zzx().zza("Logging event", (Object)this.zzj.zzj().zza(var1_1));
        }
        this.zze().zzf();
        try {
            block70: {
                block71: {
                    block73: {
                        block77: {
                            block76: {
                                block74: {
                                    block75: {
                                        this.zze(var2_2);
                                        if (!"_iap".equals(var1_1.zza) && !"ecommerce_purchase".equals(var1_1.zza)) break block73;
                                        var20_11 = var1_1;
                                        var19_15 = var5_4;
                                        var18_16 = this;
                                        var21_17 = var20_11.zzb.zzd("currency");
                                        if (!"ecommerce_purchase".equals(var20_11.zza)) break block74;
                                        var24_18 = var20_11.zzb.zzc("value") * 1000000.0;
                                        if (var24_18 == 0.0) {
                                            var24_18 = (double)var20_11.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var24_18 <= 9.223372036854776E18) || !(var24_18 >= -9.223372036854776E18)) break block75;
                                        var22_21 = Math.round(var24_18);
                                        break block76;
                                    }
                                    var18_16.zzj.zzr().zzi().zza("Data lost. Currency value is too big. appId", zzej.zza((String)var19_15), (Object)var24_18);
                                    v0 = false;
                                    break block77;
                                }
                                var22_21 = var20_11.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var21_17) && (var21_17 = var21_17.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var21_17);
                                var24_19 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var25_24 = var18_16.zze().zzc(var19_15, var24_19);
                                if (var25_24 == null || !(var25_24.zze instanceof Long)) {
                                    var29_27 = var19_15;
                                    var34_28 = var18_16.zzj.zzb().zzb(var29_27, zzak.zzah) - 1;
                                    var33_29 = var19_15;
                                    var32_30 = var18_16.zze();
                                    Preconditions.checkNotEmpty((String)var33_29);
                                    var32_30.zzd();
                                    var32_30.zzak();
                                    try {
                                        var32_30.c_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var33_29, var33_29, String.valueOf(var34_28)});
                                    }
                                    catch (SQLiteException var35_31) {
                                        var32_30.zzr().zzf().zza("Error pruning currencies. appId", zzej.zza((String)var33_29), (Object)var35_31);
                                    }
                                    var25_24 = new zzjy(var19_15, var20_11.zzc, var24_19, var18_16.zzj.zzm().currentTimeMillis(), (Object)var22_21);
                                } else {
                                    var26_32 = (Long)var25_24.zze;
                                    var25_24 = new zzjy(var19_15, var20_11.zzc, var24_19, var18_16.zzj.zzm().currentTimeMillis(), (Object)(var26_32 + var22_21));
                                }
                                if (!var18_16.zze().zza(var25_24)) {
                                    var18_16.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property. appId", zzej.zza((String)var19_15), (Object)var18_16.zzj.zzj().zzc(var25_24.zzc), var25_24.zze);
                                    var18_16.zzj.zzi().zza(var19_15, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zze().b_();
                            return;
                        }
                    }
                    var6_6 = zzjx.zza((String)var1_1.zza);
                    var7_8 = "_err".equals(var1_1.zza);
                    var8_10 = this.zze().zza(this.zzx(), var5_4, true, var6_6, false, var7_8, false);
                    var9_34 = var8_10.zzb - (long)((Integer)zzak.zzn.zza(null)).intValue();
                    if (var9_34 > 0L) {
                        if (var9_34 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many events logged. appId, count", zzej.zza((String)var5_4), (Object)var8_10.zzb);
                        }
                        this.zze().b_();
                        return;
                    }
                    if (var6_6 && (var9_34 = var8_10.zza - (long)((Integer)zzak.zzp.zza(null)).intValue()) > 0L) {
                        if (var9_34 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many public events logged. appId, count", zzej.zza((String)var5_4), (Object)var8_10.zza);
                        }
                        this.zzj.zzi().zza(var5_4, 16, "_ev", var1_1.zza, 0);
                        this.zze().b_();
                        return;
                    }
                    if (var7_8) {
                        var19_15 = var2_2.zza;
                        var20_12 = this.zzj.zzb().zzb(var19_15, zzak.zzo);
                        var9_34 = var8_10.zzd - (long)Math.max(0, var20_12 = Math.min(1000000, var20_12));
                        if (var9_34 > 0L) {
                            if (var9_34 == 1L) {
                                this.zzj.zzr().zzf().zza("Too many error events logged. appId, count", zzej.zza((String)var5_4), (Object)var8_10.zzd);
                            }
                            this.zze().b_();
                            return;
                        }
                    }
                    var11_35 = var1_1.zzb.zzb();
                    this.zzj.zzi().zza(var11_35, "_o", (Object)var1_1.zzc);
                    if (this.zzj.zzi().zzf(var5_4)) {
                        this.zzj.zzi().zza(var11_35, "_dbg", (Object)1L);
                        this.zzj.zzi().zza(var11_35, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && this.zzj.zzb().zzo(var2_2.zza) && (var12_36 = this.zze().zzc(var2_2.zza, "_sno")) != null && var12_36.zze instanceof Long) {
                        this.zzj.zzi().zza(var11_35, "_sno", var12_36.zze);
                    }
                    if ("_s".equals(var1_1.zza) && this.zzj.zzb().zze(var2_2.zza, zzak.zzbc)) {
                        var19_15 = var2_2;
                        var18_16 = this;
                        if (!var18_16.zzj.zzb().zzo(var19_15.zza)) {
                            var20_13 = new zzjw("_sno", 0L, null);
                            var18_16.zzb(var20_13, (zzn)var19_15);
                        }
                    }
                    if ((var12_37 = this.zze().zzc(var5_4)) > 0L) {
                        this.zzj.zzr().zzi().zza("Data lost. Too many events stored on disk, deleted. appId", zzej.zza((String)var5_4), (Object)var12_37);
                    }
                    var14_38 = new zzaf(this.zzj, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var11_35);
                    var15_39 = this.zze().zza(var5_4, var14_38.zzb);
                    if (var15_39 == null) {
                        if (this.zze().zzg(var5_4) >= 500L && var6_6) {
                            this.zzj.zzr().zzf().zza("Too many event names used, ignoring event. appId, name, supported count", zzej.zza((String)var5_4), (Object)this.zzj.zzj().zza(var14_38.zzb), (Object)500);
                            this.zzj.zzi().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_40 = new zzae(var5_4, var14_38.zzb, 0L, 0L, var14_38.zzc, 0L, null, null, null, null);
                    } else {
                        var14_38 = var14_38.zza(this.zzj, var15_39.zzf);
                        var16_40 = var15_39.zza(var14_38.zzc);
                    }
                    this.zze().zza(var16_40);
                    var20_14 = var2_2;
                    var19_15 = var14_38;
                    var18_16 = this;
                    var18_16.zzw();
                    var18_16.zzk();
                    Preconditions.checkNotNull((Object)var19_15);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_15.zza);
                    Preconditions.checkArgument((boolean)var19_15.zza.equals(var20_14.zza));
                    var21_17 = zzbr.zzg.zzbe().zza(1).zza("android");
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zza)) {
                        var21_17.zzf(var20_14.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzd)) {
                        var21_17.zze(var20_14.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzc)) {
                        var21_17.zzg(var20_14.zzc);
                    }
                    if (var20_14.zzj != -2147483648L) {
                        var21_17.zzg((int)var20_14.zzj);
                    }
                    var21_17.zzf(var20_14.zze);
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzb)) {
                        var21_17.zzk(var20_14.zzb);
                    }
                    if (var18_16.zzj.zzb().zza(zzak.zzbp)) {
                        if (TextUtils.isEmpty((CharSequence)var21_17.zzl()) && !TextUtils.isEmpty((CharSequence)var20_14.zzr)) {
                            var21_17.zzo(var20_14.zzr);
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)var20_14.zzr)) {
                        var21_17.zzo(var20_14.zzr);
                    }
                    if (var20_14.zzf != 0L) {
                        var21_17.zzh(var20_14.zzf);
                    }
                    var21_17.zzk(var20_14.zzt);
                    if (var18_16.zzj.zzb().zze(var20_14.zza, zzak.zzbk) && (var22_22 = var18_16.zzh().zzf()) != null) {
                        var21_17.zzd(var22_22);
                    }
                    if ((var22_23 = var18_16.zzj.zzc().zza(var20_14.zza)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_23.first))) {
                        if (var20_14.zzo) {
                            var21_17.zzh((String)var22_23.first);
                            if (var22_23.second != null) {
                                var21_17.zza((Boolean)var22_23.second);
                            }
                        }
                    } else if (!var18_16.zzj.zzx().zza(var18_16.zzj.zzn()) && var20_14.zzp) {
                        var23_41 = Settings.Secure.getString((ContentResolver)var18_16.zzj.zzn().getContentResolver(), (String)"android_id");
                        if (var23_41 == null) {
                            var18_16.zzj.zzr().zzi().zza("null secure ID. appId", zzej.zza((String)var21_17.zzj()));
                            var23_41 = "null";
                        } else if (var23_41.isEmpty()) {
                            var18_16.zzj.zzr().zzi().zza("empty secure ID. appId", zzej.zza((String)var21_17.zzj()));
                        }
                        var21_17.zzm(var23_41);
                    }
                    var18_16.zzj.zzx().zzaa();
                    v3 = var21_17.zzc(Build.MODEL);
                    var18_16.zzj.zzx().zzaa();
                    v3.zzb(Build.VERSION.RELEASE).zze((int)var18_16.zzj.zzx().zzf()).zzd(var18_16.zzj.zzx().zzg()).zzj(var20_14.zzl);
                    if (var18_16.zzj.zzab() && com.google.android.gms.measurement.internal.zzs.zzy()) {
                        var21_17.zzj();
                        if (!TextUtils.isEmpty(null)) {
                            var21_17.zzn(null);
                        }
                    }
                    if ((var23_41 = var18_16.zze().zzb(var20_14.zza)) == null) {
                        var23_41 = new zzf(var18_16.zzj, var20_14.zza);
                        var23_41.zza(var18_16.zzj.zzi().zzk());
                        var23_41.zze(var20_14.zzk);
                        var23_41.zzb(var20_14.zzb);
                        var23_41.zzd(var18_16.zzj.zzc().zzb(var20_14.zza));
                        var23_41.zzg(0L);
                        var23_41.zza(0L);
                        var23_41.zzb(0L);
                        var23_41.zzf(var20_14.zzc);
                        var23_41.zzc(var20_14.zzj);
                        var23_41.zzg(var20_14.zzd);
                        var23_41.zzd(var20_14.zze);
                        var23_41.zze(var20_14.zzf);
                        var23_41.zza(var20_14.zzh);
                        var23_41.zzp(var20_14.zzl);
                        var23_41.zzf(var20_14.zzt);
                        var18_16.zze().zza((zzf)var23_41);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var23_41.zzc())) {
                        var21_17.zzi(var23_41.zzc());
                    }
                    if (!TextUtils.isEmpty((CharSequence)var23_41.zzg())) {
                        var21_17.zzl(var23_41.zzg());
                    }
                    var24_20 = var18_16.zze().zza(var20_14.zza);
                    for (var25_25 = 0; var25_25 < var24_20.size(); ++var25_25) {
                        var26_33 = zzbr.zzk.zzj().zza(var24_20.get((int)var25_25).zzc).zza(var24_20.get((int)var25_25).zzd);
                        var18_16.zzh().zza(var26_33, var24_20.get((int)var25_25).zze);
                        var21_17.zza(var26_33);
                    }
                    try {
                        var25_26 = var18_16.zze().zza((zzbr.zzg)((zzfd)var21_17.zzu()));
                    }
                    catch (IOException var27_42) {
                        var18_16.zzj.zzr().zzf().zza("Data loss. Failed to insert raw event metadata. appId", zzej.zza((String)var21_17.zzj()), (Object)var27_42);
                        break block70;
                    }
                    v4 = var18_16.zze();
                    var29_27 = var19_15;
                    var28_43 = var18_16;
                    if (var29_27.zze == null) ** GOTO lbl-1000
                    for (Object var31_46 : var29_27.zze) {
                        if (!"_r".equals(var31_46)) continue;
                        v5 = true;
                        break block71;
                    }
                    var30_45 = var28_43.zzc().zzc(var29_27.zza, var29_27.zzb);
                    var31_46 = var28_43.zze().zza(var28_43.zzx(), var29_27.zza, false, false, false, false, false);
                    if (var30_45 && var31_46.zze < (long)var28_43.zzj.zzb().zza(var29_27.zza)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzaf)var19_15, var25_26, v5)) {
                    var18_16.zzn = 0L;
                }
            }
            this.zze().b_();
            if (this.zzj.zzr().zza(2)) {
                this.zzj.zzr().zzx().zza("Event recorded", (Object)this.zzj.zzj().zza(var14_38));
            }
        }
        finally {
            this.zze().zzh();
        }
        this.zzz();
        this.zzj.zzr().zzx().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzl() {
        this.zzw();
        this.zzk();
        this.zzt = true;
        try {
            String string;
            zzr zzr2 = this.zzj.zzu();
            Boolean bl = this.zzj.zzw().zzag();
            if (bl == null) {
                this.zzj.zzr().zzi().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj.zzr().zzf().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzn > 0L) {
                this.zzz();
                return;
            }
            zzgl zzgl2 = this;
            zzgl2.zzw();
            if (zzgl2.zzw != null) {
                this.zzj.zzr().zzx().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzd().zzf()) {
                this.zzj.zzr().zzx().zza("Network not connected, ignoring upload request");
                this.zzz();
                return;
            }
            long l = this.zzj.zzm().currentTimeMillis();
            long l2 = l - com.google.android.gms.measurement.internal.zzs.zzv();
            this.zza(null, l2);
            long l3 = this.zzj.zzc().zzc.zza();
            if (l3 != 0L) {
                this.zzj.zzr().zzw().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zze().d_()))) {
                if (this.zzy == -1L) {
                    this.zzy = this.zze().zzaa();
                }
                Object object = string;
                int n = this.zzj.zzb().zzb((String)object, zzak.zzj);
                object = string;
                zzgl2 = this.zzj.zzb();
                int n2 = Math.max(0, zzgl2.zzb((String)object, zzak.zzk));
                List<Pair<zzbr.zzg, Long>> list = this.zze().zza(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    String string2 = null;
                    Object object5 = list.iterator();
                    while (object5.hasNext()) {
                        object4 = (zzbr.zzg)((Object)object5.next().first);
                        if (TextUtils.isEmpty((CharSequence)object4.zzad())) continue;
                        string2 = object4.zzad();
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            zzbr.zzg zzg2 = (zzbr.zzg)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) || zzg2.zzad().equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object5 = zzbr.zzf.zzb();
                    int n3 = list.size();
                    object4 = new ArrayList(list.size());
                    boolean bl2 = com.google.android.gms.measurement.internal.zzs.zzy() && this.zzj.zzb().zzd(string);
                    for (int i = 0; i < n3; ++i) {
                        object3 = (zzbr.zzg.zza)((zzbr.zzg)((Object)list.get((int)i).first)).zzbk();
                        object4.add((Long)list.get((int)i).second);
                        zzr2 = this.zzj.zzu();
                        ((zzbr.zzg.zza)((Object)object3)).zzg(this.zzj.zzb().zzf()).zza(l).zzb(false);
                        if (!bl2) {
                            ((zzbr.zzg.zza)((Object)object3)).zzn();
                        }
                        if (this.zzj.zzb().zze(string, zzak.zzbo)) {
                            object2 = ((zzbr.zzg)((zzfd)object3.zzu())).zzbh();
                            ((zzbr.zzg.zza)((Object)object3)).zzl(this.zzh().zza((byte[])object2));
                        }
                        ((zzbr.zzf.zza)((Object)object5)).zza((zzbr.zzg.zza)((Object)object3));
                    }
                    String string3 = null;
                    if (this.zzj.zzr().zza(2)) {
                        string3 = this.zzh().zza((zzbr.zzf)((zzfd)object5.zzu()));
                    }
                    this.zzh();
                    object3 = ((zzbr.zzf)((zzfd)object5.zzu())).zzbh();
                    object2 = (String)zzak.zzt.zza(null);
                    try {
                        URL uRL = new URL((String)object2);
                        object = object4;
                        zzgl2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzgl2.zzw != null) {
                            zzgl2.zzj.zzr().zzf().zza("Set uploading progress before finishing the previous upload");
                        } else {
                            zzgl2.zzw = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzj.zzc().zzd.zza(l);
                        String string4 = "?";
                        if (n3 > 0) {
                            string4 = ((zzbr.zzf.zza)((Object)object5)).zza(0).zzx();
                        }
                        this.zzj.zzr().zzx().zza("Uploading data. app, uncompressed size, data", (Object)string4, (Object)((Object)object3).length, (Object)string3);
                        this.zzs = true;
                        zzjr zzjr2 = new zzjr(this, string);
                        Object object6 = object3;
                        URL uRL2 = uRL;
                        object = string;
                        zzgl2 = this.zzd();
                        zzgl2.zzd();
                        zzgl2.zzak();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)object6);
                        Preconditions.checkNotNull((Object)zzjr2);
                        zzgl2.zzq().zzb((Runnable)new zzer((zzen)zzgl2, (String)object, uRL2, (byte[])object6, null, zzjr2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj.zzr().zzf().zza("Failed to parse upload URL. Not uploading. appId", zzej.zza((String)string), object2);
                    }
                }
            } else {
                zzf zzf2;
                this.zzy = -1L;
                String string5 = this.zze().zza(l - com.google.android.gms.measurement.internal.zzs.zzv());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzf2 = this.zze().zzb(string5)) != null) {
                    this.zza(zzf2);
                }
            }
            return;
        }
        finally {
            this.zzt = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final boolean zza(String string, long l) {
        this.zze().zzf();
        try {
            block157: {
                int n;
                int n2;
                zzae zzae2;
                String string2;
                Object object;
                Object object2;
                Object object3;
                zza zza2;
                block155: {
                    zza2 = new zza(null);
                    object3 = zza2;
                    long l2 = this.zzy;
                    long l3 = l;
                    String string3 = null;
                    object2 = this.zze();
                    Preconditions.checkNotNull((Object)object3);
                    object2.zzd();
                    ((zzjm)((Object)object2)).zzak();
                    try (Cursor cursor = null;){
                        String string4;
                        Object object4;
                        Object[] objectArray;
                        object = ((zzx)((Object)object2)).c_();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            object4 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = object.rawQuery(new StringBuilder(148 + String.valueOf(object4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append((String)object4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block155;
                            string3 = cursor.getString(0);
                            string2 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            object4 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = object.rawQuery(new StringBuilder(84 + String.valueOf(object4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append((String)object4).append(" order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block155;
                            string2 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = object.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string3, string2}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzf().zza("Raw event metadata record is missing. appId", zzej.zza((String)string3));
                            break block155;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            object4 = zzbr.zzg.zza((byte[])objectArray, com.google.android.gms.internal.measurement.zzeq.zzb());
                        }
                        catch (IOException iOException) {
                            object2.zzr().zzf().zza("Data loss. Failed to merge raw event metadata. appId", zzej.zza((String)string3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block155;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzr().zzi().zza("Get multiple raw event metadata records, expected one. appId", zzej.zza((String)string3));
                        }
                        cursor.close();
                        object3.zza((zzbr.zzg)((Object)object4));
                        if (l2 != -1L) {
                            string4 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            zzae2 = new String[]{string3, string2, String.valueOf(l2)};
                        } else {
                            string4 = "app_id = ? and metadata_fingerprint = ?";
                            zzae2 = new String[]{string3, string2};
                        }
                        cursor = object.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string4, (String[])zzae2, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzi().zza("Raw event data disappeared while in transaction. appId", zzej.zza((String)string3));
                            break block155;
                        }
                        do {
                            zzbr.zzc.zza zza3;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zza3 = (zzbr.zzc.zza)zzbr.zzc.zzj().zza((byte[])objectArray, com.google.android.gms.internal.measurement.zzeq.zzb());
                            }
                            catch (IOException iOException) {
                                object2.zzr().zzf().zza("Data loss. Failed to merge raw event. appId", zzej.zza((String)string3), (Object)iOException);
                                continue;
                            }
                            zza3.zza(cursor.getString(1)).zza(cursor.getLong(2));
                            if (!object3.zza(l4, (zzbr.zzc)((zzfd)zza3.zzu()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzc == null || ((zza)object2).zzc.isEmpty()) break block157;
                boolean bl = false;
                zzbr.zzg.zza zza4 = ((zzbr.zzg.zza)zza2.zza.zzbk()).zzc();
                int n3 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzj.zzb().zze(zza2.zza.zzx(), zzak.zzbf);
                zzbr.zzc.zza zzgp3 = null;
                int n4 = -1;
                zzbr.zzc.zza zza5 = null;
                int n5 = -1;
                for (n2 = 0; n2 < zza2.zzc.size(); ++n2) {
                    boolean bl3;
                    zzbr.zzc.zza zzgp22;
                    block159: {
                        boolean bl4;
                        block158: {
                            boolean bl5;
                            bl4 = bl;
                            zzgp22 = (zzbr.zzc.zza)zza2.zzc.get(n2).zzbk();
                            if (this.zzc().zzb(zza2.zza.zzx(), zzgp22.zzc())) {
                                this.zzj.zzr().zzi().zza("Dropping blacklisted raw event. appId", zzej.zza((String)zza2.zza.zzx()), (Object)this.zzj.zzj().zza(zzgp22.zzc()));
                                if (this.zzc().zzg(zza2.zza.zzx()) || this.zzc().zzh(zza2.zza.zzx()) || "_err".equals(zzgp22.zzc())) continue;
                                this.zzj.zzi().zza(zza2.zza.zzx(), 11, "_ev", zzgp22.zzc(), 0);
                                continue;
                            }
                            bl3 = this.zzc().zzc(zza2.zza.zzx(), zzgp22.zzc());
                            if (bl3) break block158;
                            this.zzh();
                            object2 = zzgp22.zzc();
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl5 = true;
                                    break;
                                }
                                default: {
                                    bl5 = false;
                                }
                            }
                            if (!bl5) break block159;
                        }
                        boolean l6 = false;
                        boolean bl6 = false;
                        for (int i = 0; i < zzgp22.zzb(); ++i) {
                            zzbr.zze zze2;
                            if ("_c".equals(zzgp22.zza(i).zza())) {
                                zze2 = (zzbr.zze)((zzfd)((zzbr.zze.zza)zzgp22.zza(i).zzbk()).zza(1L).zzu());
                                l6 = true;
                                zzgp22.zza(i, zze2);
                                continue;
                            }
                            if (!"_r".equals(zzgp22.zza(i).zza())) continue;
                            zze2 = (zzbr.zze)((zzfd)((zzbr.zze.zza)zzgp22.zza(i).zzbk()).zza(1L).zzu());
                            bl6 = true;
                            zzgp22.zza(i, zze2);
                        }
                        if (!l6 && bl3) {
                            this.zzj.zzr().zzx().zza("Marking event as conversion", (Object)this.zzj.zzj().zza(zzgp22.zzc()));
                            zzgp22.zza(zzbr.zze.zzh().zza("_c").zza(1L));
                        }
                        if (!bl6) {
                            this.zzj.zzr().zzx().zza("Marking event as real-time", (Object)this.zzj.zzj().zza(zzgp22.zzc()));
                            zzgp22.zza(zzbr.zze.zzh().zza("_r").zza(1L));
                        }
                        bl = true;
                        if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zzj.zzb().zza(zza2.zza.zzx())) {
                            zzjp.zza(zzgp22, "_r");
                            bl = bl4;
                        }
                        if (zzjx.zza((String)zzgp22.zzc()) && bl3) {
                            String string5 = zza2.zza.zzx();
                            if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zzj.zzb().zzb(string5, zzak.zzq)) {
                                this.zzj.zzr().zzi().zza("Too many conversions. Not logging as conversion. appId", zzej.zza((String)zza2.zza.zzx()));
                                boolean bl7 = false;
                                zzbr.zze.zza zza3 = null;
                                int n6 = -1;
                                for (int i = 0; i < zzgp22.zzb(); ++i) {
                                    zzbr.zze zze3 = zzgp22.zza(i);
                                    if ("_c".equals(zze3.zza())) {
                                        zza3 = (zzbr.zze.zza)zze3.zzbk();
                                        n6 = i;
                                        continue;
                                    }
                                    if (!"_err".equals(zze3.zza())) continue;
                                    bl7 = true;
                                }
                                if (bl7 && zza3 != null) {
                                    int n7 = n6;
                                    zzgp22.zzb(n7);
                                } else if (zza3 != null) {
                                    zzbr.zze zze4 = (zzbr.zze)((zzfd)((zzbr.zze.zza)((zzfd.zza)zza3.clone())).zza("_err").zza(10L).zzu());
                                    zzgp22.zza(n6, zze4);
                                } else {
                                    this.zzj.zzr().zzf().zza("Did not find conversion parameter. appId", zzej.zza((String)zza2.zza.zzx()));
                                }
                            }
                        }
                    }
                    if (this.zzj.zzb().zzk(zza2.zza.zzx()) && bl3) {
                        zzbr.zzc.zza zzgp4 = zzgp22;
                        object2 = this;
                        Object object5 = new ArrayList<zzbr.zze>(zzgp4.zza());
                        int i = -1;
                        int n9 = -1;
                        for (n = 0; n < object5.size(); ++n) {
                            if ("value".equals(((zzbr.zze)((Object)object5.get(n))).zza())) {
                                i = n;
                                continue;
                            }
                            if (!"currency".equals(((zzbr.zze)((Object)object5.get(n))).zza())) continue;
                            n9 = n;
                        }
                        if (i != -1) {
                            if (!((zzbr.zze)((Object)object5.get(i))).zzd() && !((zzbr.zze)((Object)object5.get(i))).zzf()) {
                                ((zzjp)object2).zzj.zzr().zzk().zza("Value must be specified with a numeric type.");
                                int n10 = i;
                                zzgp4.zzb(n10);
                                zzjp.zza(zzgp4, "_c");
                                zzjp.zza(zzgp4, 18, "value");
                            } else {
                                n = 0;
                                if (n9 == -1) {
                                    n = 1;
                                } else {
                                    object3 = ((zzbr.zze)((Object)object5.get(n9))).zzc();
                                    if (((String)object3).length() != 3) {
                                        n = 1;
                                    } else {
                                        int n11;
                                        for (i = 0; i < ((String)object3).length(); i += Character.charCount(n11)) {
                                            n11 = ((String)object3).codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n != 0) {
                                    ((zzjp)object2).zzj.zzr().zzk().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    int n12 = i;
                                    zzgp4.zzb(n12);
                                    zzjp.zza(zzgp4, "_c");
                                    zzjp.zza(zzgp4, 19, "currency");
                                }
                            }
                        }
                    }
                    if (this.zzj.zzb().zze(zza2.zza.zzx(), zzak.zzbe)) {
                        if ("_e".equals(zzgp22.zzc())) {
                            this.zzh();
                            if (zzjt.zza((zzbr.zzc)((zzfd)zzgp22.zzu()), "_fr") == null) {
                                if (zza5 != null && Math.abs(zza5.zze() - zzgp22.zze()) <= 1000L) {
                                    zzbr.zzc.zza l15 = (zzbr.zzc.zza)((zzfd.zza)zza5.clone());
                                    if (this.zza(zzgp22, l15)) {
                                        zzgp3 = null;
                                        zza5 = null;
                                        zza4.zza(n5, l15);
                                    } else {
                                        zzgp3 = zzgp22;
                                        n4 = n3;
                                    }
                                } else {
                                    zzgp3 = zzgp22;
                                    n4 = n3;
                                }
                            }
                        } else if ("_vs".equals(zzgp22.zzc())) {
                            this.zzh();
                            if (zzjt.zza((zzbr.zzc)((zzfd)zzgp22.zzu()), "_et") == null) {
                                if (zzgp3 != null && Math.abs(zzgp3.zze() - zzgp22.zze()) <= 1000L) {
                                    zzbr.zzc.zza zza6 = (zzbr.zzc.zza)((zzfd.zza)zzgp3.clone());
                                    if (this.zza(zza6, zzgp22)) {
                                        zzgp3 = null;
                                        zza5 = null;
                                        zza4.zza(n4, zza6);
                                    } else {
                                        zza5 = zzgp22;
                                        n5 = n3;
                                    }
                                } else {
                                    zza5 = zzgp22;
                                    n5 = n3;
                                }
                            }
                        } else if (this.zzj.zzb().zze(zza2.zza.zzx(), zzak.zzcj) && "_ab".equals(zzgp22.zzc())) {
                            this.zzh();
                            if (zzjt.zza((zzbr.zzc)((zzfd)zzgp22.zzu()), "_et") == null && zzgp3 != null && Math.abs(zzgp3.zze() - zzgp22.zze()) <= 4000L) {
                                zzbr.zzc.zza zza7 = (zzbr.zzc.zza)((zzfd.zza)zzgp3.clone());
                                this.zzb(zza7, zzgp22);
                                zzgp3 = null;
                                zza4.zza(n4, zza7);
                            }
                        }
                    }
                    if (!bl2 && "_e".equals(zzgp22.zzc())) {
                        if (zzgp22.zzb() == 0) {
                            this.zzj.zzr().zzi().zza("Engagement event does not contain any parameters. appId", zzej.zza((String)zza2.zza.zzx()));
                        } else {
                            this.zzh();
                            Long l2 = (Long)zzjt.zzb((zzbr.zzc)((zzfd)zzgp22.zzu()), "_et");
                            if (l2 == null) {
                                this.zzj.zzr().zzi().zza("Engagement event does not include duration. appId", zzej.zza((String)zza2.zza.zzx()));
                            } else {
                                l5 += l2.longValue();
                            }
                        }
                    }
                    zza2.zzc.set(n2, (zzbr.zzc)((zzfd)zzgp22.zzu()));
                    ++n3;
                    zza4.zza(zzgp22);
                }
                if (bl2) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        Long l3;
                        zzbr.zzc zzc2 = zza4.zzb(n2);
                        if ("_e".equals(zzc2.zzc())) {
                            this.zzh();
                            if (zzjt.zza(zzc2, "_fr") != null) {
                                zza4.zzc(n2);
                                --n3;
                                --n2;
                                continue;
                            }
                        }
                        this.zzh();
                        zzbr.zze zzb2 = zzjt.zza(zzc2, "_et");
                        if (zzb2 == null || (l3 = zzb2.zzd() ? Long.valueOf(zzb2.zze()) : null) == null || l3 <= 0L) continue;
                        l5 += l3.longValue();
                    }
                }
                this.zza(zza4, l5, false);
                if (this.zzj.zzb().zze(zza4.zzj(), zzak.zzbw)) {
                    n2 = 0;
                    for (zzbr.zzc zzc2 : zza4.zza()) {
                        if (!"_s".equals(zzc2.zzc())) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) {
                        this.zze().zzb(zza4.zzj(), "_se");
                    }
                    this.zza(zza4, l5, true);
                } else if (this.zzj.zzb().zze(zza4.zzj(), zzak.zzbx)) {
                    this.zze().zzb(zza4.zzj(), "_se");
                }
                if (this.zzj.zzb().zze(zza4.zzj(), zzak.zzbg)) {
                    zzf zzf2;
                    zzbr.zzg.zza zza10 = zza4;
                    object2 = this.zzh();
                    object2.zzr().zzx().zza("Checking account type status for ad personalization signals");
                    if (((zzjn)((Object)object2)).zzj().zze(zza10.zzj()) && (zzf2 = ((zzjn)((Object)object2)).zzi().zzb(zza10.zzj())) != null && zzf2.zzad() && object2.zzl().zzj()) {
                        object2.zzr().zzw().zza("Turning off ad personalization due to account type");
                        zzbr.zzk sQLiteException = (zzbr.zzk)((zzfd)zzbr.zzk.zzj().zza("_npa").zza(object2.zzl().zzh()).zzb(1L).zzu());
                        boolean bl9 = false;
                        for (n = 0; n < zza10.zze(); ++n) {
                            if (!"_npa".equals(zza10.zzd(n).zzc())) continue;
                            zza10.zza(n, sQLiteException);
                            bl9 = true;
                            break;
                        }
                        if (!bl9) {
                            zza10.zza(sQLiteException);
                        }
                    }
                }
                if (this.zzj.zzb().zze(zza4.zzj(), zzak.zzcf)) {
                    zzjp.zza(zza4);
                }
                zzbr.zzg.zza zza8 = zza4.zzm();
                long l8 = zza4.zzf();
                Object object4 = zza4.zza();
                Object object7 = zza4.zzd();
                Object object8 = zza4.zzj();
                object2 = this;
                Preconditions.checkNotEmpty((String)object8);
                zza8.zzc(((zzjp)object2).zzf().zza((String)object8, (List<zzbr.zzc>)object4, (List<zzbr.zzk>)object7, (Long)l8));
                if (this.zzj.zzb().zze(zza2.zza.zzx())) {
                    object7 = zza2;
                    object8 = zza4;
                    object2 = this;
                    object4 = new HashMap();
                    ArrayList<zzbr.zzc> arrayList = new ArrayList<zzbr.zzc>();
                    SecureRandom secureRandom = ((zzjp)object2).zzj.zzi().zzh();
                    for (int i = 0; i < ((zzbr.zzg.zza)((Object)object8)).zzb(); ++i) {
                        boolean bl8;
                        int n13;
                        long l9;
                        long l10;
                        zzbr.zzc.zza zza12;
                        block156: {
                            zza12 = (zzbr.zzc.zza)((zzbr.zzg.zza)((Object)object8)).zzb(i).zzbk();
                            if (zza12.zzc().equals("_ep")) {
                                ((zzjp)object2).zzh();
                                object = (String)zzjt.zzb((zzbr.zzc)((zzfd)zza12.zzu()), "_en");
                                string2 = (zzae)object4.get(object);
                                if (string2 == null) {
                                    string2 = ((zzjp)object2).zze().zza(((zza)object7).zza.zzx(), (String)object);
                                    object4.put(object, string2);
                                }
                                if (((zzae)string2).zzi == null) {
                                    if (((zzae)string2).zzj > 1L) {
                                        ((zzjp)object2).zzh();
                                        zzjt.zza(zza12, "_sr", ((zzae)string2).zzj);
                                    }
                                    if (((zzae)string2).zzk != null && ((zzae)string2).zzk.booleanValue()) {
                                        ((zzjp)object2).zzh();
                                        zzjt.zza(zza12, "_efs", 1L);
                                    }
                                    arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                                }
                                ((zzbr.zzg.zza)((Object)object8)).zza(i, zza12);
                                continue;
                            }
                            l10 = ((zzjp)object2).zzc().zzf(((zza)object7).zza.zzx());
                            ((zzjp)object2).zzj.zzi();
                            l9 = zzjx.zza((long)zza12.zze(), (long)l10);
                            n13 = 1;
                            Long l4 = 1L;
                            String string3 = "_dbg";
                            zzbr.zzc zzc3 = (zzbr.zzc)((zzfd)zza12.zzu());
                            if (TextUtils.isEmpty((CharSequence)string3) || l4 == null) {
                                bl8 = false;
                            } else {
                                for (zzbr.zze zze5 : zzc3.zza()) {
                                    if (!string3.equals(zze5.zza())) continue;
                                    bl8 = l4 instanceof Long && ((Object)l4).equals(zze5.zze()) || l4 instanceof String && ((Object)l4).equals(zze5.zzc()) || l4 instanceof Double && ((Object)l4).equals(zze5.zzg());
                                    break block156;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n13 = ((zzjp)object2).zzc().zzd(((zza)object7).zza.zzx(), zza12.zzc());
                        }
                        if (n13 <= 0) {
                            ((zzjp)object2).zzj.zzr().zzi().zza("Sample rate must be positive. event, rate", (Object)zza12.zzc(), (Object)n13);
                            arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                            ((zzbr.zzg.zza)((Object)object8)).zza(i, zza12);
                            continue;
                        }
                        zzae2 = (zzae)object4.get(zza12.zzc());
                        if (zzae2 == null && (zzae2 = ((zzjp)object2).zze().zza(((zza)object7).zza.zzx(), zza12.zzc())) == null) {
                            ((zzjp)object2).zzj.zzr().zzi().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)((zza)object7).zza.zzx(), (Object)zza12.zzc());
                            zzae2 = ((zzjp)object2).zzj.zzb().zze(((zza)object7).zza.zzx(), zzak.zzbv) ? new zzae(((zza)object7).zza.zzx(), zza12.zzc(), 1L, 1L, 1L, zza12.zze(), 0L, null, null, null, null) : new zzae(((zza)object7).zza.zzx(), zza12.zzc(), 1L, 1L, zza12.zze(), 0L, null, null, null, null);
                        }
                        ((zzjp)object2).zzh();
                        Long l12 = (Long)zzjt.zzb((zzbr.zzc)((zzfd)zza12.zzu()), "_eid");
                        Boolean bl9 = l12 != null;
                        if (n13 == 1) {
                            arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                            if (bl9.booleanValue() && (zzae2.zzi != null || zzae2.zzj != null || zzae2.zzk != null)) {
                                zzae2 = zzae2.zza(null, null, null);
                                object4.put(zza12.zzc(), zzae2);
                            }
                            ((zzbr.zzg.zza)((Object)object8)).zza(i, zza12);
                            continue;
                        }
                        if (secureRandom.nextInt(n13) == 0) {
                            ((zzjp)object2).zzh();
                            zzjt.zza(zza12, "_sr", n13);
                            arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                            if (bl9.booleanValue()) {
                                zzae2 = zzae2.zza(null, Long.valueOf(n13), null);
                            }
                            object4.put(zza12.zzc(), zzae2.zza(zza12.zze(), l9));
                        } else {
                            boolean bl12;
                            long l13;
                            if (((zzjp)object2).zzj.zzb().zzm(((zza)object7).zza.zzx())) {
                                if (zzae2.zzh != null) {
                                    l13 = zzae2.zzh;
                                } else {
                                    ((zzjp)object2).zzj.zzi();
                                    l13 = zzjx.zza((long)zza12.zzf(), (long)l10);
                                }
                                bl12 = l13 != l9;
                            } else {
                                l13 = zzae2.zzg;
                                boolean bl10 = bl12 = Math.abs(zza12.zze() - l13) >= 86400000L;
                            }
                            if (bl12) {
                                ((zzjp)object2).zzh();
                                zzjt.zza(zza12, "_efs", 1L);
                                ((zzjp)object2).zzh();
                                zzjt.zza(zza12, "_sr", n13);
                                arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                                if (bl9.booleanValue()) {
                                    zzae2 = zzae2.zza(null, Long.valueOf(n13), Boolean.valueOf(true));
                                }
                                object4.put(zza12.zzc(), zzae2.zza(zza12.zze(), l9));
                            } else if (bl9.booleanValue()) {
                                object4.put(zza12.zzc(), zzae2.zza(l12, null, null));
                            }
                        }
                        ((zzbr.zzg.zza)((Object)object8)).zza(i, zza12);
                    }
                    if (arrayList.size() < ((zzbr.zzg.zza)((Object)object8)).zzb()) {
                        ((zzbr.zzg.zza)((Object)object8)).zzc().zza(arrayList);
                    }
                    for (Map.Entry entry : object4.entrySet()) {
                        ((zzjp)object2).zze().zza((zzae)entry.getValue());
                    }
                }
                if (!this.zzj.zzb().zze(zza4.zzj(), zzak.zzcf)) {
                    zzjp.zza(zza4);
                }
                String string7 = zza2.zza.zzx();
                zzf zzf3 = this.zze().zzb(string7);
                if (zzf3 == null) {
                    this.zzj.zzr().zzf().zza("Bundling raw events w/o app info. appId", zzej.zza((String)zza2.zza.zzx()));
                } else if (zza4.zzb() > 0) {
                    long l6 = zzf3.zzi();
                    if (l6 != 0L) {
                        zza4.zze(l6);
                    } else {
                        zza4.zzi();
                    }
                    long l7 = zzf3.zzh();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    if (l7 != 0L) {
                        zza4.zzd(l7);
                    } else {
                        zza4.zzh();
                    }
                    zzf3.zzt();
                    zza4.zzf((int)zzf3.zzq());
                    zzf3.zza(zza4.zzf());
                    zzf3.zzb(zza4.zzg());
                    String string4 = zzf3.zzab();
                    if (string4 != null) {
                        zza4.zzj(string4);
                    } else {
                        zza4.zzk();
                    }
                    this.zze().zza(zzf3);
                }
                if (zza4.zzb() > 0) {
                    zzr zzr2 = this.zzj.zzu();
                    zzbo.zzb zzb2 = this.zzc().zza(zza2.zza.zzx());
                    if (zzb2 == null || !zzb2.zza()) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zza.zzam())) {
                            zza4.zzi(-1L);
                        } else {
                            this.zzj.zzr().zzi().zza("Did not find measurement config or missing version info. appId", zzej.zza((String)zza2.zza.zzx()));
                        }
                    } else {
                        zza4.zzi(zzb2.zzb());
                    }
                    this.zze().zza((zzbr.zzg)((zzfd)zza4.zzu()), bl);
                }
                object8 = zza2.zzb;
                object2 = this.zze();
                Preconditions.checkNotNull((Object)object8);
                object2.zzd();
                ((zzjm)((Object)object2)).zzak();
                object7 = new StringBuilder("rowid in (");
                for (int i = 0; i < object8.size(); ++i) {
                    if (i != 0) {
                        ((StringBuilder)object7).append(",");
                    }
                    ((StringBuilder)object7).append((Long)object8.get(i));
                }
                ((StringBuilder)object7).append(")");
                int n14 = ((zzx)((Object)object2)).c_().delete("raw_events", ((StringBuilder)object7).toString(), null);
                if (n14 != object8.size()) {
                    object2.zzr().zzf().zza("Deleted fewer rows from raw events table than expected", (Object)n14, (Object)object8.size());
                }
                object8 = string7;
                object2 = this.zze();
                object7 = ((zzx)((Object)object2)).c_();
                try {
                    object7.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{object8, object8});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzr().zzf().zza("Failed to remove unused event metadata. appId", zzej.zza((String)object8), (Object)sQLiteException);
                }
                this.zze().b_();
                return true;
            }
            this.zze().b_();
            return false;
        }
        finally {
            this.zze().zzh();
        }
    }

    private static void zza(zzbr.zzg.zza zza2) {
        zza2.zzb(Long.MAX_VALUE).zzc(Long.MIN_VALUE);
        for (int i = 0; i < zza2.zzb(); ++i) {
            zzbr.zzc zzc2 = zza2.zzb(i);
            if (zzc2.zze() < zza2.zzf()) {
                zza2.zzb(zzc2.zze());
            }
            if (zzc2.zze() <= zza2.zzg()) continue;
            zza2.zzc(zzc2.zze());
        }
    }

    @VisibleForTesting
    private final void zza(zzbr.zzg.zza zza2, long l, boolean bl) {
        zzjy zzjy2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzjy2 = (zzjy2 = this.zze().zzc(zza2.zzj(), string)) == null || zzjy2.zze == null ? new zzjy(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)l) : new zzjy(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)((Long)zzjy2.zze + l));
        zzbr.zzk zzk2 = (zzbr.zzk)((zzfd)zzbr.zzk.zzj().zza(string).zza(this.zzj.zzm().currentTimeMillis()).zzb((Long)zzjy2.zze).zzu());
        boolean bl2 = false;
        for (int i = 0; i < zza2.zze(); ++i) {
            if (!string.equals(zza2.zzd(i).zzc())) continue;
            zza2.zza(i, zzk2);
            bl2 = true;
            break;
        }
        if (!bl2) {
            zza2.zza(zzk2);
        }
        if (l > 0L) {
            this.zze().zza(zzjy2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj.zzr().zzw().zza("Updated engagement user property. scope, value", (Object)string2, zzjy2.zze);
        }
    }

    private final boolean zza(zzbr.zzc.zza zza2, zzbr.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzc()));
        this.zzh();
        zzbr.zze zze2 = zzjt.zza((zzbr.zzc)((zzfd)zza2.zzu()), "_sc");
        String string = zze2 == null ? null : zze2.zzc();
        this.zzh();
        zzbr.zze zze3 = zzjt.zza((zzbr.zzc)((zzfd)zza3.zzu()), "_pc");
        String string2 = zze3 == null ? null : zze3.zzc();
        if (string2 != null && string2.equals(string)) {
            this.zzb(zza2, zza3);
            return true;
        }
        return false;
    }

    private final void zzb(zzbr.zzc.zza zza2, zzbr.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzc()));
        this.zzh();
        zzbr.zze zze2 = zzjt.zza((zzbr.zzc)((zzfd)zza2.zzu()), "_et");
        if (!zze2.zzd() || zze2.zze() <= 0L) {
            return;
        }
        long l = zze2.zze();
        this.zzh();
        zze2 = zzjt.zza((zzbr.zzc)((zzfd)zza3.zzu()), "_et");
        if (zze2 != null && zze2.zze() > 0L) {
            l += zze2.zze();
        }
        this.zzh();
        zzjt.zza(zza3, "_et", l);
        this.zzh();
        zzjt.zza(zza2, "_fr", 1L);
    }

    @VisibleForTesting
    private static void zza(zzbr.zzc.zza zza2, @NonNull String string) {
        List<zzbr.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zza())) continue;
            int n = i;
            zza2.zzb(n);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzbr.zzc.zza zza2, int n, String string) {
        List<zzbr.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zza())) continue;
            return;
        }
        zzbr.zze zze2 = (zzbr.zze)((zzfd)zzbr.zze.zzh().zza("_err").zza(n).zzu());
        zzbr.zze zze3 = (zzbr.zze)((zzfd)zzbr.zze.zzh().zza("_ev").zzb(string).zzu());
        zza2.zza(zze2).zza(zze3);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzw();
        this.zzk();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzw;
            this.zzw = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
                    this.zzj.zzc().zzd.zza(0L);
                    this.zzz();
                    this.zzj.zzr().zzx().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zze().zzf();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzx zzx2 = this.zze();
                                zzx2.zzd();
                                zzx2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzx2.c_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzx2.zzr().zzf().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzx != null && this.zzx.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zze().b_();
                    }
                    finally {
                        this.zze().zzh();
                    }
                    this.zzx = null;
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzy = -1L;
                        this.zzz();
                    }
                    this.zzn = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj.zzr().zzf().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzn = this.zzj.zzm().elapsedRealtime();
                    this.zzj.zzr().zzx().zza("Disable upload, time", (Object)this.zzn);
                }
            } else {
                this.zzj.zzr().zzx().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                }
                this.zze().zza(list);
                this.zzz();
            }
            return;
        }
        finally {
            this.zzs = false;
            this.zzaa();
        }
    }

    private final boolean zzy() {
        this.zzw();
        this.zzk();
        return this.zze().zzy() || !TextUtils.isEmpty((CharSequence)this.zze().d_());
    }

    @WorkerThread
    private final void zza(zzf zzf2) {
        this.zzw();
        if (TextUtils.isEmpty((CharSequence)zzf2.zzd()) && TextUtils.isEmpty((CharSequence)zzf2.zze())) {
            this.zza(zzf2.zzb(), 204, null, null, null);
            return;
        }
        Object object = zzf2;
        Object object2 = this.zzj.zzb();
        Object object3 = new Uri.Builder();
        String string = object.zzd();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = object.zze();
        }
        String string2 = String.valueOf(string);
        object3.scheme((String)zzak.zzh.zza(null)).encodedAuthority((String)zzak.zzi.zza(null)).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", object.zzc()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(object2.zzf()));
        String string3 = object3.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzj.zzr().zzx().zza("Fetching remote configuration", (Object)zzf2.zzb());
            zzbo.zzb zzb2 = this.zzc().zza(zzf2.zzb());
            ArrayMap arrayMap = null;
            String string4 = this.zzc().zzb(zzf2.zzb());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzr = true;
            zzjq zzjq2 = new zzjq(this);
            string = arrayMap;
            object3 = uRL;
            object = zzf2.zzb();
            object2 = this.zzd();
            object2.zzd();
            ((zzjm)((Object)object2)).zzak();
            Preconditions.checkNotNull((Object)object3);
            Preconditions.checkNotNull((Object)zzjq2);
            object2.zzq().zzb((Runnable)new zzer((zzen)((Object)object2), (String)object, (URL)object3, null, (Map)((Object)string), zzjq2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj.zzr().zzf().zza("Failed to parse config URL. Not fetching. appId", zzej.zza((String)zzf2.zzb()), (Object)string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj.zzr().zzx().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zze().zzf();
            try {
                boolean bl;
                zzf zzf2 = this.zze().zzb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzf2 == null) {
                    this.zzj.zzr().zzi().zza("App does not exist in onConfigFetched. appId", zzej.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzc().zza(string) == null && !this.zzc().zza(string, null, null) : !this.zzc().zza(string, byArray, string2)) {
                        return;
                    }
                    zzf2.zzh(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzf2);
                    if (n == 404) {
                        this.zzj.zzr().zzk().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj.zzr().zzx().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzz();
                    }
                } else {
                    zzf2.zzi(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzf2);
                    this.zzj.zzr().zzx().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzc().zzc(string);
                    this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                    }
                    this.zzz();
                }
                this.zze().b_();
            }
            finally {
                this.zze().zzh();
            }
            return;
        }
        finally {
            this.zzr = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final void zzz() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzw();
            this.zzk();
            if (!this.zzac() && !this.zzj.zzb().zza(zzak.zzbj)) {
                return;
            }
            if (this.zzn > 0L) {
                l3 = this.zzj.zzm().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzn);
                if (l2 > 0L) {
                    this.zzj.zzr().zzx().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzt().zzb();
                    this.zzv().zzf();
                    return;
                }
                this.zzn = 0L;
            }
            if (!this.zzj.zzag() || !this.zzy()) {
                this.zzj.zzr().zzx().zza("Nothing to upload or uploading impossible");
                this.zzt().zzb();
                this.zzv().zzf();
                return;
            }
            zzjp zzjp2 = this;
            long l4 = zzjp2.zzj.zzm().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzak.zzad.zza(null));
            boolean bl = zzjp2.zze().zzz() || zzjp2.zze().zzk();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzjp2.zzj.zzb().zzw())) && !".none.".equals(string) ? Math.max(0L, (Long)zzak.zzy.zza(null)) : Math.max(0L, (Long)zzak.zzx.zza(null))) : Math.max(0L, (Long)zzak.zzw.zza(null));
            long l7 = zzjp2.zzj.zzc().zzc.zza();
            long l8 = zzjp2.zzj.zzc().zzd.zza();
            long l9 = zzjp2.zze().zzw();
            long l10 = zzjp2.zze().zzx();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzjp2.zzh().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzak.zzaf.zza(null))); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzak.zzae.zza(null)) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj.zzr().zzx().zza("Next upload time is 0");
            this.zzt().zzb();
            this.zzv().zzf();
            return;
        }
        if (!this.zzd().zzf()) {
            this.zzj.zzr().zzx().zza("No network");
            this.zzt().zza();
            this.zzv().zzf();
            return;
        }
        l2 = this.zzj.zzc().zze.zza();
        long l16 = Math.max(0L, (Long)zzak.zzu.zza(null));
        if (!this.zzh().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzt().zzb();
        long l17 = l3 - this.zzj.zzm().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzak.zzz.zza(null));
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzj.zzr().zzx().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzv().zza(l17);
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzw();
        if (this.zzo == null) {
            this.zzo = new ArrayList<Runnable>();
        }
        this.zzo.add(runnable);
    }

    @WorkerThread
    private final void zzaa() {
        this.zzw();
        if (this.zzr || this.zzs || this.zzt) {
            this.zzj.zzr().zzx().zza("Not stopping services. fetch, network, upload", (Object)this.zzr, (Object)this.zzs, (Object)this.zzt);
            return;
        }
        this.zzj.zzr().zzx().zza("Stopping uploading service(s)");
        if (this.zzo == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzo.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzo.clear();
    }

    @WorkerThread
    private final Boolean zzb(zzf zzf2) {
        try {
            if (zzf2.zzk() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzf2.zzb(), (int)0).versionCode;
                if (zzf2.zzk() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzf2.zzb(), (int)0).versionName;
                if (zzf2.zzj() != null && zzf2.zzj().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzab() {
        this.zzw();
        if (this.zzj.zzb().zza(zzak.zzce) && this.zzu != null && this.zzu.isValid()) {
            this.zzj.zzr().zzx().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzj.zzn().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzv = new RandomAccessFile(file2, "rw").getChannel();
            this.zzu = this.zzv.tryLock();
            if (this.zzu != null) {
                this.zzj.zzr().zzx().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj.zzr().zzf().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj.zzr().zzf().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj.zzr().zzi().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj.zzr().zzi().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj.zzr().zzf().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final void zzo() {
        block3: {
            block4: {
                this.zzw();
                this.zzk();
                if (this.zzm) break block3;
                this.zzm = true;
                var1_1 = this;
                var1_1.zzw();
                var1_1.zzk();
                if (!var1_1.zzj.zzb().zza(zzak.zzbj) && !var1_1.zzac() || !var1_1.zzab()) break block3;
                var2_2 = var1_1.zza(var1_1.zzv);
                var6_4 = var3_3 = var1_1.zzj.zzy().zzae();
                var5_5 = var2_2;
                var4_6 = var1_1;
                var4_6.zzw();
                if (var5_5 <= var6_4) break block4;
                var4_6.zzj.zzr().zzf().zza("Panic: can't downgrade version. Previous, current version", (Object)var5_5, (Object)var6_4);
                v0 = false;
                break block3;
            }
            if (var5_5 >= var6_4) ** GOTO lbl25
            if (!var4_6.zza(var6_4, var4_6.zzv)) {
                var4_6.zzj.zzr().zzf().zza("Storage version upgrade failed. Previous, current version", (Object)var5_5, (Object)var6_4);
                v0 = false;
            } else {
                var4_6.zzj.zzr().zzx().zza("Storage version upgraded. Previous, current version", (Object)var5_5, (Object)var6_4);
lbl25:
                // 2 sources

                v0 = true;
            }
        }
        if (!this.zzl && !this.zzj.zzb().zza(zzak.zzbj)) {
            this.zzj.zzr().zzv().zza("This instance being marked as an uploader");
            this.zzl = true;
            this.zzz();
        }
    }

    @WorkerThread
    private final boolean zzac() {
        this.zzw();
        this.zzk();
        return this.zzl;
        {
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(zzn zzn2) {
        if (this.zzw != null) {
            this.zzx = new ArrayList<Long>();
            this.zzx.addAll(this.zzw);
        }
        String string = zzn2.zza;
        zzx zzx2 = this.zze();
        Preconditions.checkNotEmpty((String)string);
        zzx2.zzd();
        zzx2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzx2.c_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzx2.zzr().zzx().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzx2.zzr().zzf().zza("Error resetting analytics data. appId, error", zzej.zza((String)string), (Object)sQLiteException);
        }
        zzjz.zzb();
        if (this.zzj.zzb().zza(zzak.zzck)) {
            if (zzn2.zzh) {
                this.zzc(zzn2);
                return;
            }
        } else {
            zzn zzn3 = this.zza(this.zzj.zzn(), zzn2.zza, zzn2.zzb, zzn2.zzh, zzn2.zzo, zzn2.zzp, zzn2.zzm, zzn2.zzr);
            if (zzn2.zzh) {
                this.zzc(zzn3);
            }
        }
    }

    private final zzn zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, String string3) {
        String string4 = "Unknown";
        String string5 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string6 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzj.zzr().zzf().zza("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string4 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzj.zzr().zzf().zza("Error retrieving installer package name. appId", zzej.zza((String)string));
        }
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string6 = charSequence.toString();
                }
                string5 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzj.zzr().zzf().zza("Error retrieving newly installed package info. appId, appName", zzej.zza((String)string), (Object)string6);
            return null;
        }
        long l2 = 0L;
        zzr zzr2 = this.zzj.zzu();
        long l3 = 0L;
        if (this.zzj.zzb().zzj(string)) {
            l3 = l;
        }
        return new zzn(string, string2, string5, (long)n, string4, this.zzj.zzb().zzf(), this.zzj.zzi().zza(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false, string3, null, 0L, null);
    }

    @WorkerThread
    final void zza(zzjw zzjw2, zzn zzn2) {
        this.zzw();
        this.zzk();
        if (TextUtils.isEmpty((CharSequence)zzn2.zzb) && TextUtils.isEmpty((CharSequence)zzn2.zzr)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zze(zzn2);
            return;
        }
        int n = this.zzj.zzi().zzc(zzjw2.zza);
        if (n != 0) {
            this.zzj.zzi();
            String string = zzjx.zza((String)zzjw2.zza, (int)24, (boolean)true);
            int n2 = zzjw2.zza != null ? zzjw2.zza.length() : 0;
            this.zzj.zzi().zza(zzn2.zza, n, "_ev", string, n2);
            return;
        }
        n = this.zzj.zzi().zzb(zzjw2.zza, zzjw2.zza());
        if (n != 0) {
            this.zzj.zzi();
            String string = zzjx.zza((String)zzjw2.zza, (int)24, (boolean)true);
            Object object = zzjw2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzj.zzi().zza(zzn2.zza, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzj.zzi().zzc(zzjw2.zza, zzjw2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzjw2.zza) && this.zzj.zzb().zzo(zzn2.zza)) {
            zzae zzae2;
            zzn zzn3 = zzn2;
            String string = zzjw2.zze;
            long l = zzjw2.zzb;
            zzjp zzjp2 = this;
            long l2 = 0L;
            zzjy zzjy2 = zzjp2.zze().zzc(zzn3.zza, "_sno");
            if (zzjy2 != null && zzjy2.zze instanceof Long) {
                l2 = (Long)zzjy2.zze;
            } else {
                if (zzjy2 != null) {
                    zzjp2.zzj.zzr().zzi().zza("Retrieved last session number from database does not contain a valid (long) value", zzjy2.zze);
                }
                if (zzjp2.zzj.zzb().zze(zzn3.zza, zzak.zzbb) && (zzae2 = zzjp2.zze().zza(zzn3.zza, "_s")) != null) {
                    l2 = zzae2.zzc;
                    zzjp2.zzj.zzr().zzx().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzae2 = new zzjw("_sno", l, (Object)(++l2), string);
            zzjp2.zza((zzjw)zzae2, zzn3);
        }
        zzjy zzjy3 = new zzjy(zzn2.zza, zzjw2.zze, zzjw2.zza, zzjw2.zzb, object);
        this.zzj.zzr().zzw().zza("Setting user property", (Object)this.zzj.zzj().zzc(zzjy3.zzc), object);
        this.zze().zzf();
        try {
            this.zze(zzn2);
            boolean bl = this.zze().zza(zzjy3);
            this.zze().b_();
            if (bl) {
                this.zzj.zzr().zzw().zza("User property set", (Object)this.zzj.zzj().zzc(zzjy3.zzc), zzjy3.zze);
            } else {
                this.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzj.zzj().zzc(zzjy3.zzc), zzjy3.zze);
                this.zzj.zzi().zza(zzn2.zza, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzjw zzjw2, zzn zzn2) {
        this.zzw();
        this.zzk();
        if (TextUtils.isEmpty((CharSequence)zzn2.zzb) && TextUtils.isEmpty((CharSequence)zzn2.zzr)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zze(zzn2);
            return;
        }
        if (this.zzj.zzb().zze(zzn2.zza, zzak.zzbg)) {
            if ("_npa".equals(zzjw2.zza) && zzn2.zzs != null) {
                this.zzj.zzr().zzw().zza("Falling back to manifest metadata value for ad personalization");
                zzjw zzjw3 = new zzjw("_npa", this.zzj.zzm().currentTimeMillis(), (Object)(zzn2.zzs != false ? 1L : 0L), "auto");
                this.zza(zzjw3, zzn2);
                return;
            }
            this.zzj.zzr().zzw().zza("Removing user property", (Object)this.zzj.zzj().zzc(zzjw2.zza));
            this.zze().zzf();
            try {
                this.zze(zzn2);
                this.zze().zzb(zzn2.zza, zzjw2.zza);
                this.zze().b_();
                this.zzj.zzr().zzw().zza("User property removed", (Object)this.zzj.zzj().zzc(zzjw2.zza));
                return;
            }
            finally {
                this.zze().zzh();
            }
        }
        this.zzj.zzr().zzw().zza("Removing user property", (Object)this.zzj.zzj().zzc(zzjw2.zza));
        this.zze().zzf();
        try {
            this.zze(zzn2);
            this.zze().zzb(zzn2.zza, zzjw2.zza);
            this.zze().b_();
            this.zzj.zzr().zzw().zza("User property removed", (Object)this.zzj.zzj().zzc(zzjw2.zza));
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    final void zza(zzjm zzjm2) {
        ++this.zzp;
    }

    final void zzp() {
        ++this.zzq;
    }

    final zzfn zzs() {
        return this.zzj;
    }

    @WorkerThread
    final void zzc(zzn zzn2) {
        int n;
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        if (TextUtils.isEmpty((CharSequence)zzn2.zzb) && TextUtils.isEmpty((CharSequence)zzn2.zzr)) {
            return;
        }
        zzf zzf2 = this.zze().zzb(zzn2.zza);
        if (zzf2 != null && TextUtils.isEmpty((CharSequence)zzf2.zzd()) && !TextUtils.isEmpty((CharSequence)zzn2.zzb)) {
            zzf2.zzh(0L);
            this.zze().zza(zzf2);
            this.zzc().zzd(zzn2.zza);
        }
        if (!zzn2.zzh) {
            this.zze(zzn2);
            return;
        }
        long l = zzn2.zzm;
        if (l == 0L) {
            l = this.zzj.zzm().currentTimeMillis();
        }
        if (this.zzj.zzb().zze(zzn2.zza, zzak.zzbg)) {
            this.zzj.zzx().zzi();
        }
        if ((n = zzn2.zzn) != 0 && n != 1) {
            this.zzj.zzr().zzi().zza("Incorrect app type, assuming installed app. appId, appType", zzej.zza((String)zzn2.zza), (Object)n);
            n = 0;
        }
        this.zze().zzf();
        try {
            zzai zzai2;
            Bundle bundle;
            zzjy zzjy2;
            if (this.zzj.zzb().zze(zzn2.zza, zzak.zzbg) && ((zzjy2 = this.zze().zzc(zzn2.zza, "_npa")) == null || "auto".equals(zzjy2.zzb))) {
                zzjw zzjw2;
                if (zzn2.zzs != null) {
                    zzjw2 = new zzjw("_npa", l, (Object)(zzn2.zzs != false ? 1L : 0L), "auto");
                    if (zzjy2 == null || !zzjy2.zze.equals(zzjw2.zzc)) {
                        this.zza(zzjw2, zzn2);
                    }
                } else if (zzjy2 != null) {
                    zzjw2 = new zzjw("_npa", l, null, "auto");
                    this.zzb(zzjw2, zzn2);
                }
            }
            long l2 = l;
            zzn zzn3 = zzn2;
            zzjp zzjp2 = this;
            zzf zzf3 = zzjp2.zze().zzb(zzn3.zza);
            if (zzf3 != null) {
                zzjp2.zzj.zzi();
                if (zzjx.zza((String)zzn3.zzb, (String)zzf3.zzd(), (String)zzn3.zzr, (String)zzf3.zze())) {
                    zzjp2.zzj.zzr().zzi().zza("New GMP App Id passed in. Removing cached database data. appId", zzej.zza((String)zzf3.zzb()));
                    String string = zzf3.zzb();
                    zzx zzx2 = zzjp2.zze();
                    zzx2.zzak();
                    zzx2.zzd();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzx2.c_();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzx2.zzr().zzx().zza("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzx2.zzr().zzf().zza("Error deleting application data. appId, error", zzej.zza((String)string), (Object)sQLiteException);
                    }
                    zzf3 = null;
                }
            }
            if (zzf3 != null) {
                if (zzf3.zzk() != Integer.MIN_VALUE) {
                    if (zzf3.zzk() != zzn3.zzj) {
                        bundle = new Bundle();
                        bundle.putString("_pv", zzf3.zzj());
                        zzai2 = new zzai("_au", new zzah(bundle), "auto", l2);
                        zzjp2.zza(zzai2, zzn3);
                    }
                } else if (zzf3.zzj() != null && !zzf3.zzj().equals(zzn3.zzc)) {
                    bundle = new Bundle();
                    bundle.putString("_pv", zzf3.zzj());
                    zzai2 = new zzai("_au", new zzah(bundle), "auto", l2);
                    zzjp2.zza(zzai2, zzn3);
                }
            }
            this.zze(zzn2);
            zzjy2 = null;
            if (n == 0) {
                zzjy2 = this.zze().zza(zzn2.zza, "_f");
            } else if (n == 1) {
                zzjy2 = this.zze().zza(zzn2.zza, "_v");
            }
            if (zzjy2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzjw zzjw3;
                    zzjw zzjw4 = new zzjw("_fot", l, (Object)l3, "auto");
                    this.zza(zzjw4, zzn2);
                    if (this.zzj.zzb().zzl(zzn2.zzb)) {
                        zzn3 = zzn2;
                        zzjp2 = this;
                        zzjp2.zzw();
                        zzjp2.zzj.zzf().zza(zzn3.zza);
                    }
                    l2 = l;
                    zzn3 = zzn2;
                    zzjp2 = this;
                    zzjp2.zzw();
                    zzjp2.zzk();
                    zzf3 = new Bundle();
                    zzf3.putLong("_c", 1L);
                    zzf3.putLong("_r", 1L);
                    zzf3.putLong("_uwa", 0L);
                    zzf3.putLong("_pfo", 0L);
                    zzf3.putLong("_sys", 0L);
                    zzf3.putLong("_sysu", 0L);
                    if (zzjp2.zzj.zzb().zzr(zzn3.zza)) {
                        zzf3.putLong("_et", 1L);
                    }
                    if (zzn3.zzq) {
                        zzf3.putLong("_dac", 1L);
                    }
                    if (zzjp2.zzj.zzn().getPackageManager() == null) {
                        zzjp2.zzj.zzr().zzf().zza("PackageManager is null, first open report might be inaccurate. appId", zzej.zza((String)zzn3.zza));
                    } else {
                        zzai2 = null;
                        try {
                            zzai2 = Wrappers.packageManager((Context)zzjp2.zzj.zzn()).getPackageInfo(zzn3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjp2.zzj.zzr().zzf().zza("Package info is null, first open report might be inaccurate. appId", zzej.zza((String)zzn3.zza), (Object)nameNotFoundException);
                        }
                        if (zzai2 != null && zzai2.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (zzai2.firstInstallTime != zzai2.lastUpdateTime) {
                                zzf3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzjw3 = new zzjw("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzjp2.zza(zzjw3, zzn3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzjp2.zzj.zzn()).getApplicationInfo(zzn3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjp2.zzj.zzr().zzf().zza("Application info is null, first open report might be inaccurate. appId", zzej.zza((String)zzn3.zza), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzf3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzf3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzn3.zza;
                    zzx zzx3 = zzjp2.zze();
                    Preconditions.checkNotEmpty((String)string);
                    zzx3.zzd();
                    zzx3.zzak();
                    long l4 = zzx3.zzh(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzf3.putLong("_pfo", l4);
                    }
                    zzjw3 = new zzai("_f", new zzah((Bundle)zzf3), "auto", l2);
                    zzjp2.zza((zzai)zzjw3, zzn3);
                } else if (n == 1) {
                    zzjw zzjw5 = new zzjw("_fvt", l, (Object)l3, "auto");
                    this.zza(zzjw5, zzn2);
                    l2 = l;
                    zzn3 = zzn2;
                    zzjp2 = this;
                    zzjp2.zzw();
                    zzjp2.zzk();
                    zzf3 = new Bundle();
                    zzf3.putLong("_c", 1L);
                    zzf3.putLong("_r", 1L);
                    if (zzjp2.zzj.zzb().zzr(zzn3.zza)) {
                        zzf3.putLong("_et", 1L);
                    }
                    if (zzn3.zzq) {
                        zzf3.putLong("_dac", 1L);
                    }
                    bundle = new zzai("_v", new zzah((Bundle)zzf3), "auto", l2);
                    zzjp2.zza((zzai)bundle, zzn3);
                }
                if (!this.zzj.zzb().zze(zzn2.zza, zzak.zzbf)) {
                    l2 = l;
                    zzn3 = zzn2;
                    zzjp2 = this;
                    zzf3 = new Bundle();
                    zzf3.putLong("_et", 1L);
                    if (zzjp2.zzj.zzb().zzr(zzn3.zza)) {
                        zzf3.putLong("_fr", 1L);
                    }
                    bundle = new zzai("_e", new zzah((Bundle)zzf3), "auto", l2);
                    zzjp2.zza((zzai)bundle, zzn3);
                }
            } else if (zzn2.zzi) {
                l2 = l;
                zzn3 = zzn2;
                zzjp2 = this;
                zzf3 = new Bundle();
                bundle = new zzai("_cd", new zzah((Bundle)zzf3), "auto", l2);
                zzjp2.zza((zzai)bundle, zzn3);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    private final zzn zza(String string) {
        zzf zzf2 = this.zze().zzb(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzj())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzb(zzf2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping. appId", zzej.zza((String)string));
            return null;
        }
        return new zzn(string, zzf2.zzd(), zzf2.zzj(), zzf2.zzk(), zzf2.zzl(), zzf2.zzm(), zzf2.zzn(), null, zzf2.zzp(), false, zzf2.zzg(), zzf2.zzac(), 0L, 0, zzf2.zzad(), zzf2.zzae(), false, zzf2.zze(), zzf2.zzaf(), zzf2.zzo(), zzf2.zzag());
    }

    @WorkerThread
    final void zza(zzq zzq2) {
        zzn zzn2 = this.zza(zzq2.zza);
        if (zzn2 != null) {
            this.zza(zzq2, zzn2);
        }
    }

    @WorkerThread
    final void zza(zzq zzq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Preconditions.checkNotNull((Object)zzq2.zzb);
        Preconditions.checkNotNull((Object)zzq2.zzc);
        Preconditions.checkNotEmpty((String)zzq2.zzc.zza);
        this.zzw();
        this.zzk();
        if (TextUtils.isEmpty((CharSequence)zzn2.zzb) && TextUtils.isEmpty((CharSequence)zzn2.zzr)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zze(zzn2);
            return;
        }
        zzq zzq3 = new zzq(zzq2);
        new zzq(zzq2).zze = false;
        this.zze().zzf();
        try {
            boolean bl = false;
            zzq zzq4 = this.zze().zzd(zzq3.zza, zzq3.zzc.zza);
            if (zzq4 != null && !zzq4.zzb.equals(zzq3.zzb)) {
                this.zzj.zzr().zzi().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzj.zzj().zzc(zzq3.zzc.zza), (Object)zzq3.zzb, (Object)zzq4.zzb);
            }
            if (zzq4 != null && zzq4.zze) {
                zzq3.zzb = zzq4.zzb;
                zzq3.zzd = zzq4.zzd;
                zzq3.zzh = zzq4.zzh;
                zzq3.zzf = zzq4.zzf;
                zzq3.zzi = zzq4.zzi;
                zzq3.zze = zzq4.zze;
                zzq3.zzc = new zzjw(zzq3.zzc.zza, zzq4.zzc.zzb, zzq3.zzc.zza(), zzq4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzq3.zzf)) {
                zzq3.zzc = new zzjw(zzq3.zzc.zza, zzq3.zzd, zzq3.zzc.zza(), zzq3.zzc.zze);
                zzq3.zze = true;
                bl = true;
            }
            if (zzq3.zze) {
                zzjw zzjw2 = zzq3.zzc;
                zzjy zzjy2 = new zzjy(zzq3.zza, zzq3.zzb, zzjw2.zza, zzjw2.zzb, zzjw2.zza());
                if (this.zze().zza(zzjy2)) {
                    this.zzj.zzr().zzw().zza("User property updated immediately", (Object)zzq3.zza, (Object)this.zzj.zzj().zzc(zzjy2.zzc), zzjy2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("(2)Too many active user properties, ignoring", zzej.zza((String)zzq3.zza), (Object)this.zzj.zzj().zzc(zzjy2.zzc), zzjy2.zze);
                }
                if (bl && zzq3.zzi != null) {
                    zzai zzai2 = new zzai(zzq3.zzi, zzq3.zzd);
                    this.zzb(zzai2, zzn2);
                }
            }
            if (this.zze().zza(zzq3)) {
                this.zzj.zzr().zzw().zza("Conditional property added", (Object)zzq3.zza, (Object)this.zzj.zzj().zzc(zzq3.zzc.zza), zzq3.zzc.zza());
            } else {
                this.zzj.zzr().zzf().zza("Too many conditional properties, ignoring", zzej.zza((String)zzq3.zza), (Object)this.zzj.zzj().zzc(zzq3.zzc.zza), zzq3.zzc.zza());
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzq zzq2) {
        zzn zzn2 = this.zza(zzq2.zza);
        if (zzn2 != null) {
            this.zzb(zzq2, zzn2);
        }
    }

    @WorkerThread
    final void zzb(zzq zzq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Preconditions.checkNotNull((Object)zzq2.zzc);
        Preconditions.checkNotEmpty((String)zzq2.zzc.zza);
        this.zzw();
        this.zzk();
        if (TextUtils.isEmpty((CharSequence)zzn2.zzb) && TextUtils.isEmpty((CharSequence)zzn2.zzr)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zze(zzn2);
            return;
        }
        this.zze().zzf();
        try {
            this.zze(zzn2);
            zzq zzq3 = this.zze().zzd(zzq2.zza, zzq2.zzc.zza);
            if (zzq3 != null) {
                this.zzj.zzr().zzw().zza("Removing conditional user property", (Object)zzq2.zza, (Object)this.zzj.zzj().zzc(zzq2.zzc.zza));
                this.zze().zze(zzq2.zza, zzq2.zzc.zza);
                if (zzq3.zze) {
                    this.zze().zzb(zzq2.zza, zzq2.zzc.zza);
                }
                if (zzq2.zzk != null) {
                    Bundle bundle = null;
                    if (zzq2.zzk.zzb != null) {
                        bundle = zzq2.zzk.zzb.zzb();
                    }
                    zzai zzai2 = this.zzj.zzi().zza(zzq2.zza, zzq2.zzk.zza, bundle, zzq3.zzb, zzq2.zzk.zzd, true, false);
                    this.zzb(zzai2, zzn2);
                }
            } else {
                this.zzj.zzr().zzi().zza("Conditional user property doesn't exist", zzej.zza((String)zzq2.zza), (Object)this.zzj.zzj().zzc(zzq2.zzc.zza));
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    private final zzf zze(zzn zzn2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        zzf zzf2 = this.zze().zzb(zzn2.zza);
        String string = this.zzj.zzc().zzb(zzn2.zza);
        boolean bl = false;
        if (zzf2 == null) {
            zzf2 = new zzf(this.zzj, zzn2.zza);
            zzf2.zza(this.zzj.zzi().zzk());
            zzf2.zzd(string);
            bl = true;
        } else if (!string.equals(zzf2.zzf())) {
            zzf2.zzd(string);
            zzf2.zza(this.zzj.zzi().zzk());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzn2.zzb, (CharSequence)zzf2.zzd())) {
            zzf2.zzb(zzn2.zzb);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzn2.zzr, (CharSequence)zzf2.zze())) {
            zzf2.zzc(zzn2.zzr);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzk) && !zzn2.zzk.equals(zzf2.zzg())) {
            zzf2.zze(zzn2.zzk);
            bl = true;
        }
        if (zzn2.zze != 0L && zzn2.zze != zzf2.zzm()) {
            zzf2.zzd(zzn2.zze);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzc) && !zzn2.zzc.equals(zzf2.zzj())) {
            zzf2.zzf(zzn2.zzc);
            bl = true;
        }
        if (zzn2.zzj != zzf2.zzk()) {
            zzf2.zzc(zzn2.zzj);
            bl = true;
        }
        if (zzn2.zzd != null && !zzn2.zzd.equals(zzf2.zzl())) {
            zzf2.zzg(zzn2.zzd);
            bl = true;
        }
        if (zzn2.zzf != zzf2.zzn()) {
            zzf2.zze(zzn2.zzf);
            bl = true;
        }
        if (zzn2.zzh != zzf2.zzp()) {
            zzf2.zza(zzn2.zzh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzg) && !zzn2.zzg.equals(zzf2.zzaa())) {
            zzf2.zzh(zzn2.zzg);
            bl = true;
        }
        if (zzn2.zzl != zzf2.zzac()) {
            zzf2.zzp(zzn2.zzl);
            bl = true;
        }
        if (zzn2.zzo != zzf2.zzad()) {
            zzf2.zzb(zzn2.zzo);
            bl = true;
        }
        if (zzn2.zzp != zzf2.zzae()) {
            zzf2.zzc(zzn2.zzp);
            bl = true;
        }
        if (this.zzj.zzb().zze(zzn2.zza, zzak.zzbg) && zzn2.zzs != zzf2.zzaf()) {
            zzf2.zza(zzn2.zzs);
            bl = true;
        }
        if (zzn2.zzt != 0L && zzn2.zzt != zzf2.zzo()) {
            zzf2.zzf(zzn2.zzt);
            bl = true;
        }
        if (bl) {
            this.zze().zza(zzf2);
        }
        return zzf2;
    }

    final String zzd(zzn zzn2) {
        Future future = this.zzj.zzq().zza((Callable)new zzjs(this, zzn2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj.zzr().zzf().zza("Failed to get app instance id. appId", zzej.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    final void zza(boolean bl) {
        this.zzz();
    }

    static /* synthetic */ void zza(zzjp zzjp2, zzju zzju2) {
        zzjp2.zza(zzju2);
    }

    static /* synthetic */ zzf zza(zzjp zzjp2, zzn zzn2) {
        return zzjp2.zze(zzn2);
    }

    final class zza
    implements zzz {
        zzbr.zzg zza;
        List<Long> zzb;
        List<zzbr.zzc> zzc;
        private long zzd;

        private zza() {
        }

        @Override
        public final void zza(zzbr.zzg zzg2) {
            Preconditions.checkNotNull((Object)((Object)zzg2));
            this.zza = zzg2;
        }

        @Override
        public final boolean zza(long l, zzbr.zzc zzc2) {
            Preconditions.checkNotNull((Object)((Object)zzc2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzbr.zzc>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (this.zzc.size() > 0 && com.google.android.gms.measurement.internal.zzjp$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzjp$zza.zza(zzc2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzc2.zzbl();
            if (l2 >= (long)Math.max(0, (Integer)zzak.zzl.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzc2);
            this.zzb.add(l);
            return this.zzc.size() < Math.max(1, (Integer)zzak.zzm.zza(null));
        }

        private static long zza(zzbr.zzc zzc2) {
            return zzc2.zze() / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzjo zzjo2) {
            this();
        }
    }
}

