/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzbo;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzjq
implements zzgj {
    private static volatile zzjq zza;
    private zzff zzb;
    private zzel zzc;
    private zzv zzd;
    private zzes zze;
    private zzjm zzf;
    private zzn zzg;
    private final zzju zzh;
    private zzht zzi;
    private final zzfl zzj;
    private boolean zzk = false;
    private boolean zzl;
    private boolean zzm;
    @VisibleForTesting
    private long zzn;
    private List<Runnable> zzo;
    private int zzp;
    private int zzq;
    private boolean zzr;
    private boolean zzs;
    private boolean zzt;
    private FileLock zzu;
    private FileChannel zzv;
    private List<Long> zzw;
    private List<Long> zzx;
    private long zzy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzjq zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzjq> clazz = zzjq.class;
        synchronized (zzjq.class) {
            if (zza != null) return zza;
            zzjv zzjv2 = new zzjv(context);
            zza = new zzjq(zzjv2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    private zzjq(zzjv zzjv2) {
        this(zzjv2, null);
    }

    private zzjq(zzjv zzjv2, zzfl zzfl2) {
        Preconditions.checkNotNull((Object)zzjv2);
        this.zzj = zzfl2 = zzfl.zza((Context)zzjv2.zza, null);
        this.zzy = -1L;
        zzjq zzjq2 = this;
        zzju zzju2 = new zzju(zzjq2);
        zzju2.zzal();
        this.zzh = zzju2;
        zzjq2 = this;
        zzel zzel2 = new zzel(zzjq2);
        zzel2.zzal();
        this.zzc = zzel2;
        zzjq2 = this;
        zzff zzff2 = new zzff(zzjq2);
        zzff2.zzal();
        this.zzb = zzff2;
        this.zzj.zzq().zza((Runnable)new zzjp(this, zzjv2));
    }

    @WorkerThread
    private final void zza(zzjv zzjv2) {
        this.zzj.zzq().zzd();
        zzjq zzjq2 = this;
        zzv zzv2 = new zzv(zzjq2);
        zzv2.zzal();
        this.zzd = zzv2;
        this.zzj.zzb().zza((zzw)this.zzb);
        zzjq2 = this;
        zzn zzn2 = new zzn(zzjq2);
        zzn2.zzal();
        this.zzg = zzn2;
        zzjq2 = this;
        zzht zzht2 = new zzht(zzjq2);
        zzht2.zzal();
        this.zzi = zzht2;
        zzjq2 = this;
        zzjm zzjm2 = new zzjm(zzjq2);
        zzjm2.zzal();
        this.zzf = zzjm2;
        zzjq2 = this;
        this.zze = new zzes(zzjq2);
        if (this.zzp != this.zzq) {
            this.zzj.zzr().zzf().zza("Not all upload components initialized", (Object)this.zzp, (Object)this.zzq);
        }
        this.zzk = true;
    }

    @WorkerThread
    protected final void zza() {
        this.zzj.zzq().zzd();
        this.zze().zzv();
        if (this.zzj.zzc().zzc.zza() == 0L) {
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzz();
    }

    public final zzp zzu() {
        return this.zzj.zzu();
    }

    public final zzu zzb() {
        return this.zzj.zzb();
    }

    public final zzeh zzr() {
        return this.zzj.zzr();
    }

    public final zzfi zzq() {
        return this.zzj.zzq();
    }

    public final zzff zzc() {
        zzjq.zzb(this.zzb);
        return this.zzb;
    }

    public final zzel zzd() {
        zzjq.zzb(this.zzc);
        return this.zzc;
    }

    public final zzv zze() {
        zzjq.zzb(this.zzd);
        return this.zzd;
    }

    private final zzes zzt() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    private final zzjm zzv() {
        zzjq.zzb(this.zzf);
        return this.zzf;
    }

    public final zzn zzf() {
        zzjq.zzb(this.zzg);
        return this.zzg;
    }

    public final zzht zzg() {
        zzjq.zzb(this.zzi);
        return this.zzi;
    }

    public final zzju zzh() {
        zzjq.zzb(this.zzh);
        return this.zzh;
    }

    public final zzef zzi() {
        return this.zzj.zzj();
    }

    public final Context zzn() {
        return this.zzj.zzn();
    }

    public final Clock zzm() {
        return this.zzj.zzm();
    }

    public final zzjy zzj() {
        return this.zzj.zzi();
    }

    @WorkerThread
    private final void zzw() {
        this.zzj.zzq().zzd();
    }

    final void zzk() {
        if (!this.zzk) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zzb(zzjn zzjn2) {
        if (zzjn2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzjn2.zzaj()) {
            String string = String.valueOf(((Object)((Object)zzjn2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zza(zzm zzm2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotEmpty((String)zzm2.zza);
        this.zze(zzm2);
    }

    private final long zzx() {
        long l = this.zzj.zzm().currentTimeMillis();
        zzeu zzeu2 = this.zzj.zzc();
        zzeu2.zzaa();
        zzeu2.zzd();
        long l2 = zzeu2.zzg.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzeu2.zzp().zzh().nextInt(86400000);
            zzeu2.zzg.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zza(zzak zzak2, String string) {
        zzg zzg2 = this.zze().zzb(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzj())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzb(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzak2.zza)) {
                this.zzj.zzr().zzi().zza("Could not find package. appId", zzeh.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping event. appId", zzeh.zza((String)string));
            return;
        }
        zzm zzm2 = new zzm(string, zzg2.zzd(), zzg2.zzj(), zzg2.zzk(), zzg2.zzl(), zzg2.zzm(), zzg2.zzn(), null, zzg2.zzp(), false, zzg2.zzg(), zzg2.zzac(), 0L, 0, zzg2.zzad(), zzg2.zzae(), false, zzg2.zze(), zzg2.zzaf(), zzg2.zzo(), zzg2.zzag());
        this.zza(zzak2, zzm2);
    }

    @WorkerThread
    final void zza(zzak zzak2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        this.zzw();
        this.zzk();
        String string = zzm2.zza;
        long l = zzak2.zzd;
        if (!this.zzh().zza(zzak2, zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zze(zzm2);
            return;
        }
        if (this.zzj.zzb().zze(string, zzam.zzbp) && zzm2.zzu != null) {
            if (zzm2.zzu.contains(zzak2.zza)) {
                Bundle bundle = zzak2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzak2 = new zzak(zzak2.zza, new zzaf(bundle), zzak2.zzc, zzak2.zzd);
            } else {
                this.zzj.zzr().zzw().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzak2.zza, (Object)zzak2.zzc);
                return;
            }
        }
        this.zze().zzf();
        try {
            zzs zzs2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzv zzv2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzv2.zzd();
            zzv2.zzak();
            if (l2 < 0L) {
                zzv2.zzr().zzi().zza("Invalid time querying timed out conditional properties", zzeh.zza((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzv2.zza(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj.zzr().zzw().zza("User property timed out", (Object)((zzs)object22).zza, (Object)this.zzj.zzj().zzc(((zzs)object22).zzc.zza), ((zzs)object22).zzc.zza());
                if (((zzs)object22).zzg != null) {
                    this.zzb(new zzak(((zzs)object22).zzg, l), zzm2);
                }
                this.zze().zze(string, ((zzs)object22).zzc.zza);
            }
            l2 = l;
            string3 = string;
            zzv2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzv2.zzd();
            zzv2.zzak();
            if (l2 < 0L) {
                zzv2.zzr().zzi().zza("Invalid time querying expired conditional properties", zzeh.zza((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzv2.zza(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzs)object4.next();
                if (object == null) continue;
                this.zzj.zzr().zzw().zza("User property expired", (Object)((zzs)object).zza, (Object)this.zzj.zzj().zzc(((zzs)object).zzc.zza), ((zzs)object).zzc.zza());
                this.zze().zzb(string, ((zzs)object).zzc.zza);
                if (((zzs)object).zzk != null) {
                    object22.add(((zzs)object).zzk);
                }
                this.zze().zze(string, ((zzs)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzak)e;
                this.zzb(new zzak((zzak)object, l), zzm2);
            }
            long l3 = l;
            String string4 = zzak2.zza;
            string3 = string;
            zzv2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzv2.zzd();
            zzv2.zzak();
            if (l3 < 0L) {
                zzv2.zzr().zzi().zza("Invalid time querying triggered conditional properties", zzeh.zza((String)string3), (Object)zzv2.zzo().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzv2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzs2 = (zzs)iterator.next();
                if (zzs2 == null) continue;
                zzjx zzjx2 = zzs2.zzc;
                zzjz zzjz2 = new zzjz(zzs2.zza, zzs2.zzb, zzjx2.zza, l, zzjx2.zza());
                if (this.zze().zza(zzjz2)) {
                    this.zzj.zzr().zzw().zza("User property triggered", (Object)zzs2.zza, (Object)this.zzj.zzj().zzc(zzjz2.zzc), zzjz2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("Too many active user properties, ignoring", zzeh.zza((String)zzs2.zza), (Object)this.zzj.zzj().zzc(zzjz2.zzc), zzjz2.zze);
                }
                if (zzs2.zzi != null) {
                    object.add(zzs2.zzi);
                }
                zzs2.zzc = new zzjx(zzjz2);
                zzs2.zze = true;
                this.zze().zza(zzs2);
            }
            this.zzb(zzak2, zzm2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzs2 = (zzak)e;
                this.zzb(new zzak((zzak)zzs2, l), zzm2);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzb(zzak var1_1, zzm var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzw();
        this.zzk();
        var5_4 = var2_2.zza;
        if (!this.zzh().zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zze(var2_2);
            return;
        }
        if (this.zzc().zzb(var5_4, var1_1.zza)) {
            this.zzj.zzr().zzi().zza("Dropping blacklisted event. appId", zzeh.zza((String)var5_4), (Object)this.zzj.zzj().zza(var1_1.zza));
            var6_5 = this.zzc().zzg(var5_4) != false || this.zzc().zzh(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzj.zzi().zza(var5_4, 11, "_ev", var1_1.zza, 0);
            }
            if (var6_5 && (var7_7 = this.zze().zzb(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzs(), var7_7.zzr());
                if (Math.abs(this.zzj.zzm().currentTimeMillis() - var8_9) > (Long)zzam.zzac.zza(null)) {
                    this.zzj.zzr().zzw().zza("Fetching config for blacklisted app");
                    this.zza(var7_7);
                }
            }
            return;
        }
        if (this.zzj.zzr().zza(2)) {
            this.zzj.zzr().zzx().zza("Logging event", (Object)this.zzj.zzj().zza(var1_1));
        }
        this.zze().zzf();
        try {
            block70: {
                block71: {
                    block73: {
                        block77: {
                            block76: {
                                block74: {
                                    block75: {
                                        this.zze(var2_2);
                                        if (!"_iap".equals(var1_1.zza) && !"ecommerce_purchase".equals(var1_1.zza)) break block73;
                                        var20_11 = var1_1;
                                        var19_15 = var5_4;
                                        var18_16 = this;
                                        var21_17 = var20_11.zzb.zzd("currency");
                                        if (!"ecommerce_purchase".equals(var20_11.zza)) break block74;
                                        var24_18 = var20_11.zzb.zzc("value") * 1000000.0;
                                        if (var24_18 == 0.0) {
                                            var24_18 = (double)var20_11.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var24_18 <= 9.223372036854776E18) || !(var24_18 >= -9.223372036854776E18)) break block75;
                                        var22_21 = Math.round(var24_18);
                                        break block76;
                                    }
                                    var18_16.zzj.zzr().zzi().zza("Data lost. Currency value is too big. appId", zzeh.zza((String)var19_15), (Object)var24_18);
                                    v0 = false;
                                    break block77;
                                }
                                var22_21 = var20_11.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var21_17) && (var21_17 = var21_17.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var21_17);
                                var24_19 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var25_24 = var18_16.zze().zzc(var19_15, var24_19);
                                if (var25_24 == null || !(var25_24.zze instanceof Long)) {
                                    var29_27 = var19_15;
                                    var34_28 = var18_16.zzj.zzb().zzb(var29_27, zzam.zzah) - 1;
                                    var33_29 = var19_15;
                                    var32_30 = var18_16.zze();
                                    Preconditions.checkNotEmpty((String)var33_29);
                                    var32_30.zzd();
                                    var32_30.zzak();
                                    try {
                                        var32_30.c_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var33_29, var33_29, String.valueOf(var34_28)});
                                    }
                                    catch (SQLiteException var35_31) {
                                        var32_30.zzr().zzf().zza("Error pruning currencies. appId", zzeh.zza((String)var33_29), (Object)var35_31);
                                    }
                                    var25_24 = new zzjz(var19_15, var20_11.zzc, var24_19, var18_16.zzj.zzm().currentTimeMillis(), (Object)var22_21);
                                } else {
                                    var26_32 = (Long)var25_24.zze;
                                    var25_24 = new zzjz(var19_15, var20_11.zzc, var24_19, var18_16.zzj.zzm().currentTimeMillis(), (Object)(var26_32 + var22_21));
                                }
                                if (!var18_16.zze().zza(var25_24)) {
                                    var18_16.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property. appId", zzeh.zza((String)var19_15), (Object)var18_16.zzj.zzj().zzc(var25_24.zzc), var25_24.zze);
                                    var18_16.zzj.zzi().zza(var19_15, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zze().b_();
                            return;
                        }
                    }
                    var6_6 = zzjy.zza((String)var1_1.zza);
                    var7_8 = "_err".equals(var1_1.zza);
                    var8_10 = this.zze().zza(this.zzx(), var5_4, true, var6_6, false, var7_8, false);
                    var9_34 = var8_10.zzb - (long)((Integer)zzam.zzn.zza(null)).intValue();
                    if (var9_34 > 0L) {
                        if (var9_34 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many events logged. appId, count", zzeh.zza((String)var5_4), (Object)var8_10.zzb);
                        }
                        this.zze().b_();
                        return;
                    }
                    if (var6_6 && (var9_34 = var8_10.zza - (long)((Integer)zzam.zzp.zza(null)).intValue()) > 0L) {
                        if (var9_34 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many public events logged. appId, count", zzeh.zza((String)var5_4), (Object)var8_10.zza);
                        }
                        this.zzj.zzi().zza(var5_4, 16, "_ev", var1_1.zza, 0);
                        this.zze().b_();
                        return;
                    }
                    if (var7_8) {
                        var19_15 = var2_2.zza;
                        var20_12 = this.zzj.zzb().zzb(var19_15, zzam.zzo);
                        var9_34 = var8_10.zzd - (long)Math.max(0, var20_12 = Math.min(1000000, var20_12));
                        if (var9_34 > 0L) {
                            if (var9_34 == 1L) {
                                this.zzj.zzr().zzf().zza("Too many error events logged. appId, count", zzeh.zza((String)var5_4), (Object)var8_10.zzd);
                            }
                            this.zze().b_();
                            return;
                        }
                    }
                    var11_35 = var1_1.zzb.zzb();
                    this.zzj.zzi().zza(var11_35, "_o", (Object)var1_1.zzc);
                    if (this.zzj.zzi().zzf(var5_4)) {
                        this.zzj.zzi().zza(var11_35, "_dbg", (Object)1L);
                        this.zzj.zzi().zza(var11_35, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && this.zzj.zzb().zzm(var2_2.zza) && (var12_36 = this.zze().zzc(var2_2.zza, "_sno")) != null && var12_36.zze instanceof Long) {
                        this.zzj.zzi().zza(var11_35, "_sno", var12_36.zze);
                    }
                    if ("_s".equals(var1_1.zza) && this.zzj.zzb().zze(var2_2.zza, zzam.zzba)) {
                        var19_15 = var2_2;
                        var18_16 = this;
                        if (!var18_16.zzj.zzb().zzm(var19_15.zza)) {
                            var20_13 = new zzjx("_sno", 0L, null);
                            var18_16.zzb(var20_13, (zzm)var19_15);
                        }
                    }
                    if ((var12_37 = this.zze().zzc(var5_4)) > 0L) {
                        this.zzj.zzr().zzi().zza("Data lost. Too many events stored on disk, deleted. appId", zzeh.zza((String)var5_4), (Object)var12_37);
                    }
                    var14_38 = new zzad(this.zzj, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var11_35);
                    var15_39 = this.zze().zza(var5_4, var14_38.zzb);
                    if (var15_39 == null) {
                        if (this.zze().zzg(var5_4) >= 500L && var6_6) {
                            this.zzj.zzr().zzf().zza("Too many event names used, ignoring event. appId, name, supported count", zzeh.zza((String)var5_4), (Object)this.zzj.zzj().zza(var14_38.zzb), (Object)500);
                            this.zzj.zzi().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_40 = new zzag(var5_4, var14_38.zzb, 0L, 0L, var14_38.zzc, 0L, null, null, null, null);
                    } else {
                        var14_38 = var14_38.zza(this.zzj, var15_39.zzf);
                        var16_40 = var15_39.zza(var14_38.zzc);
                    }
                    this.zze().zza(var16_40);
                    var20_14 = var2_2;
                    var19_15 = var14_38;
                    var18_16 = this;
                    var18_16.zzw();
                    var18_16.zzk();
                    Preconditions.checkNotNull((Object)var19_15);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_15.zza);
                    Preconditions.checkArgument((boolean)var19_15.zza.equals(var20_14.zza));
                    var21_17 = zzbr.zzg.zzbe().zza(1).zza("android");
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zza)) {
                        var21_17.zzf(var20_14.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzd)) {
                        var21_17.zze(var20_14.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzc)) {
                        var21_17.zzg(var20_14.zzc);
                    }
                    if (var20_14.zzj != -2147483648L) {
                        var21_17.zzg((int)var20_14.zzj);
                    }
                    var21_17.zzf(var20_14.zze);
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzb)) {
                        var21_17.zzk(var20_14.zzb);
                    }
                    if (var18_16.zzj.zzb().zza(zzam.zzbl)) {
                        if (TextUtils.isEmpty((CharSequence)var21_17.zzl()) && !TextUtils.isEmpty((CharSequence)var20_14.zzr)) {
                            var21_17.zzo(var20_14.zzr);
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)var20_14.zzr)) {
                        var21_17.zzo(var20_14.zzr);
                    }
                    if (var20_14.zzf != 0L) {
                        var21_17.zzh(var20_14.zzf);
                    }
                    var21_17.zzk(var20_14.zzt);
                    if (var18_16.zzj.zzb().zze(var20_14.zza, zzam.zzbi) && (var22_22 = var18_16.zzh().zzf()) != null) {
                        var21_17.zzd(var22_22);
                    }
                    if ((var22_23 = var18_16.zzj.zzc().zza(var20_14.zza)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_23.first))) {
                        if (var20_14.zzo) {
                            var21_17.zzh((String)var22_23.first);
                            if (var22_23.second != null) {
                                var21_17.zza((Boolean)var22_23.second);
                            }
                        }
                    } else if (!var18_16.zzj.zzx().zza(var18_16.zzj.zzn()) && var20_14.zzp) {
                        var23_41 = Settings.Secure.getString((ContentResolver)var18_16.zzj.zzn().getContentResolver(), (String)"android_id");
                        if (var23_41 == null) {
                            var18_16.zzj.zzr().zzi().zza("null secure ID. appId", zzeh.zza((String)var21_17.zzj()));
                            var23_41 = "null";
                        } else if (var23_41.isEmpty()) {
                            var18_16.zzj.zzr().zzi().zza("empty secure ID. appId", zzeh.zza((String)var21_17.zzj()));
                        }
                        var21_17.zzm(var23_41);
                    }
                    var18_16.zzj.zzx().zzaa();
                    v3 = var21_17.zzc(Build.MODEL);
                    var18_16.zzj.zzx().zzaa();
                    v3.zzb(Build.VERSION.RELEASE).zze((int)var18_16.zzj.zzx().zzf()).zzd(var18_16.zzj.zzx().zzg()).zzj(var20_14.zzl);
                    if (var18_16.zzj.zzab() && com.google.android.gms.measurement.internal.zzu.zzy()) {
                        var21_17.zzj();
                        if (!TextUtils.isEmpty(null)) {
                            var21_17.zzn(null);
                        }
                    }
                    if ((var23_41 = var18_16.zze().zzb(var20_14.zza)) == null) {
                        var23_41 = new zzg(var18_16.zzj, var20_14.zza);
                        var23_41.zza(var18_16.zzj.zzi().zzk());
                        var23_41.zze(var20_14.zzk);
                        var23_41.zzb(var20_14.zzb);
                        var23_41.zzd(var18_16.zzj.zzc().zzb(var20_14.zza));
                        var23_41.zzg(0L);
                        var23_41.zza(0L);
                        var23_41.zzb(0L);
                        var23_41.zzf(var20_14.zzc);
                        var23_41.zzc(var20_14.zzj);
                        var23_41.zzg(var20_14.zzd);
                        var23_41.zzd(var20_14.zze);
                        var23_41.zze(var20_14.zzf);
                        var23_41.zza(var20_14.zzh);
                        var23_41.zzp(var20_14.zzl);
                        var23_41.zzf(var20_14.zzt);
                        var18_16.zze().zza((zzg)var23_41);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var23_41.zzc())) {
                        var21_17.zzi(var23_41.zzc());
                    }
                    if (!TextUtils.isEmpty((CharSequence)var23_41.zzg())) {
                        var21_17.zzl(var23_41.zzg());
                    }
                    var24_20 = var18_16.zze().zza(var20_14.zza);
                    for (var25_25 = 0; var25_25 < var24_20.size(); ++var25_25) {
                        var26_33 = zzbr.zzk.zzj().zza(var24_20.get((int)var25_25).zzc).zza(var24_20.get((int)var25_25).zzd);
                        var18_16.zzh().zza(var26_33, var24_20.get((int)var25_25).zze);
                        var21_17.zza(var26_33);
                    }
                    try {
                        var25_26 = var18_16.zze().zza((zzbr.zzg)((zzfd)var21_17.zzu()));
                    }
                    catch (IOException var27_42) {
                        var18_16.zzj.zzr().zzf().zza("Data loss. Failed to insert raw event metadata. appId", zzeh.zza((String)var21_17.zzj()), (Object)var27_42);
                        break block70;
                    }
                    v4 = var18_16.zze();
                    var29_27 = var19_15;
                    var28_43 = var18_16;
                    if (var29_27.zze == null) ** GOTO lbl-1000
                    for (Object var31_46 : var29_27.zze) {
                        if (!"_r".equals(var31_46)) continue;
                        v5 = true;
                        break block71;
                    }
                    var30_45 = var28_43.zzc().zzc(var29_27.zza, var29_27.zzb);
                    var31_46 = var28_43.zze().zza(var28_43.zzx(), var29_27.zza, false, false, false, false, false);
                    if (var30_45 && var31_46.zze < (long)var28_43.zzj.zzb().zza(var29_27.zza)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzad)var19_15, var25_26, v5)) {
                    var18_16.zzn = 0L;
                }
            }
            this.zze().b_();
            if (this.zzj.zzr().zza(2)) {
                this.zzj.zzr().zzx().zza("Event recorded", (Object)this.zzj.zzj().zza(var14_38));
            }
        }
        finally {
            this.zze().zzh();
        }
        this.zzz();
        this.zzj.zzr().zzx().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzl() {
        this.zzw();
        this.zzk();
        this.zzt = true;
        try {
            String string;
            zzp zzp2 = this.zzj.zzu();
            Boolean bl = this.zzj.zzw().zzag();
            if (bl == null) {
                this.zzj.zzr().zzi().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj.zzr().zzf().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzn > 0L) {
                this.zzz();
                return;
            }
            zzgj zzgj2 = this;
            zzgj2.zzw();
            if (zzgj2.zzw != null) {
                this.zzj.zzr().zzx().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzd().zzf()) {
                this.zzj.zzr().zzx().zza("Network not connected, ignoring upload request");
                this.zzz();
                return;
            }
            long l = this.zzj.zzm().currentTimeMillis();
            long l2 = l - com.google.android.gms.measurement.internal.zzu.zzv();
            this.zza(null, l2);
            long l3 = this.zzj.zzc().zzc.zza();
            if (l3 != 0L) {
                this.zzj.zzr().zzw().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zze().d_()))) {
                if (this.zzy == -1L) {
                    this.zzy = this.zze().zzaa();
                }
                Object object = string;
                int n = this.zzj.zzb().zzb((String)object, zzam.zzj);
                object = string;
                zzgj2 = this.zzj.zzb();
                int n2 = Math.max(0, zzgj2.zzb((String)object, zzam.zzk));
                List<Pair<zzbr.zzg, Long>> list = this.zze().zza(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    String string2 = null;
                    Object object5 = list.iterator();
                    while (object5.hasNext()) {
                        object4 = (zzbr.zzg)((Object)object5.next().first);
                        if (TextUtils.isEmpty((CharSequence)object4.zzad())) continue;
                        string2 = object4.zzad();
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            zzbr.zzg zzg2 = (zzbr.zzg)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) || zzg2.zzad().equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object5 = zzbr.zzf.zzb();
                    int n3 = list.size();
                    object4 = new ArrayList(list.size());
                    boolean bl2 = com.google.android.gms.measurement.internal.zzu.zzy() && this.zzj.zzb().zzd(string);
                    for (int i = 0; i < n3; ++i) {
                        object3 = (zzbr.zzg.zza)((zzbr.zzg)((Object)list.get((int)i).first)).zzbk();
                        object4.add((Long)list.get((int)i).second);
                        zzp2 = this.zzj.zzu();
                        ((zzbr.zzg.zza)((Object)object3)).zzg(this.zzj.zzb().zzf()).zza(l).zzb(false);
                        if (!bl2) {
                            ((zzbr.zzg.zza)((Object)object3)).zzn();
                        }
                        if (this.zzj.zzb().zze(string, zzam.zzbk)) {
                            object2 = ((zzbr.zzg)((zzfd)object3.zzu())).zzbh();
                            ((zzbr.zzg.zza)((Object)object3)).zzl(this.zzh().zza((byte[])object2));
                        }
                        ((zzbr.zzf.zza)((Object)object5)).zza((zzbr.zzg.zza)((Object)object3));
                    }
                    String string3 = null;
                    if (this.zzj.zzr().zza(2)) {
                        string3 = this.zzh().zza((zzbr.zzf)((zzfd)object5.zzu()));
                    }
                    this.zzh();
                    object3 = ((zzbr.zzf)((zzfd)object5.zzu())).zzbh();
                    object2 = (String)zzam.zzt.zza(null);
                    try {
                        URL uRL = new URL((String)object2);
                        object = object4;
                        zzgj2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzgj2.zzw != null) {
                            zzgj2.zzj.zzr().zzf().zza("Set uploading progress before finishing the previous upload");
                        } else {
                            zzgj2.zzw = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzj.zzc().zzd.zza(l);
                        String string4 = "?";
                        if (n3 > 0) {
                            string4 = ((zzbr.zzf.zza)((Object)object5)).zza(0).zzx();
                        }
                        this.zzj.zzr().zzx().zza("Uploading data. app, uncompressed size, data", (Object)string4, (Object)((Object)object3).length, (Object)string3);
                        this.zzs = true;
                        zzjs zzjs2 = new zzjs(this, string);
                        Object object6 = object3;
                        URL uRL2 = uRL;
                        object = string;
                        zzgj2 = this.zzd();
                        zzgj2.zzd();
                        zzgj2.zzak();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)object6);
                        Preconditions.checkNotNull((Object)zzjs2);
                        zzgj2.zzq().zzb((Runnable)new zzep((zzel)zzgj2, (String)object, uRL2, (byte[])object6, null, zzjs2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj.zzr().zzf().zza("Failed to parse upload URL. Not uploading. appId", zzeh.zza((String)string), object2);
                    }
                }
            } else {
                zzg zzg3;
                this.zzy = -1L;
                String string5 = this.zze().zza(l - com.google.android.gms.measurement.internal.zzu.zzv());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzg3 = this.zze().zzb(string5)) != null) {
                    this.zza(zzg3);
                }
            }
            return;
        }
        finally {
            this.zzt = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final boolean zza(String string, long l) {
        this.zze().zzf();
        try {
            block157: {
                int n;
                int n2;
                zzag zzag2;
                String string2;
                Object object;
                Object object2;
                Object object3;
                zza zza2;
                block155: {
                    zza2 = new zza(null);
                    object3 = zza2;
                    long l2 = this.zzy;
                    long l3 = l;
                    String string3 = null;
                    object2 = this.zze();
                    Preconditions.checkNotNull((Object)object3);
                    object2.zzd();
                    ((zzjn)((Object)object2)).zzak();
                    try (Cursor cursor = null;){
                        String string4;
                        Object object4;
                        Object[] objectArray;
                        object = ((zzv)((Object)object2)).c_();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            object4 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = object.rawQuery(new StringBuilder(148 + String.valueOf(object4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append((String)object4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block155;
                            string3 = cursor.getString(0);
                            string2 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            object4 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = object.rawQuery(new StringBuilder(84 + String.valueOf(object4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append((String)object4).append(" order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block155;
                            string2 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = object.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string3, string2}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzf().zza("Raw event metadata record is missing. appId", zzeh.zza((String)string3));
                            break block155;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            object4 = (zzbr.zzg)((zzfd)zzju.zza(zzbr.zzg.zzbe(), (byte[])objectArray).zzu());
                        }
                        catch (IOException iOException) {
                            object2.zzr().zzf().zza("Data loss. Failed to merge raw event metadata. appId", zzeh.zza((String)string3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block155;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzr().zzi().zza("Get multiple raw event metadata records, expected one. appId", zzeh.zza((String)string3));
                        }
                        cursor.close();
                        object3.zza((zzbr.zzg)((Object)object4));
                        if (l2 != -1L) {
                            string4 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            zzag2 = new String[]{string3, string2, String.valueOf(l2)};
                        } else {
                            string4 = "app_id = ? and metadata_fingerprint = ?";
                            zzag2 = new String[]{string3, string2};
                        }
                        cursor = object.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string4, (String[])zzag2, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzi().zza("Raw event data disappeared while in transaction. appId", zzeh.zza((String)string3));
                            break block155;
                        }
                        do {
                            zzbr.zzc.zza zza3;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zza3 = zzju.zza(zzbr.zzc.zzj(), (byte[])objectArray);
                            }
                            catch (IOException iOException) {
                                object2.zzr().zzf().zza("Data loss. Failed to merge raw event. appId", zzeh.zza((String)string3), (Object)iOException);
                                continue;
                            }
                            zza3.zza(cursor.getString(1)).zza(cursor.getLong(2));
                            if (!object3.zza(l4, (zzbr.zzc)((zzfd)zza3.zzu()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzc == null || ((zza)object2).zzc.isEmpty()) break block157;
                boolean bl = false;
                zzbr.zzg.zza zza4 = ((zzbr.zzg.zza)zza2.zza.zzbk()).zzc();
                int n3 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzj.zzb().zze(zza2.zza.zzx(), zzam.zzbd);
                zzbr.zzc.zza zzgp3 = null;
                int n4 = -1;
                zzbr.zzc.zza zza5 = null;
                int n5 = -1;
                for (n2 = 0; n2 < zza2.zzc.size(); ++n2) {
                    boolean bl3;
                    zzbr.zzc.zza zzgp22;
                    block159: {
                        boolean bl4;
                        block158: {
                            boolean bl5;
                            bl4 = bl;
                            zzgp22 = (zzbr.zzc.zza)zza2.zzc.get(n2).zzbk();
                            if (this.zzc().zzb(zza2.zza.zzx(), zzgp22.zzc())) {
                                this.zzj.zzr().zzi().zza("Dropping blacklisted raw event. appId", zzeh.zza((String)zza2.zza.zzx()), (Object)this.zzj.zzj().zza(zzgp22.zzc()));
                                if (this.zzc().zzg(zza2.zza.zzx()) || this.zzc().zzh(zza2.zza.zzx()) || "_err".equals(zzgp22.zzc())) continue;
                                this.zzj.zzi().zza(zza2.zza.zzx(), 11, "_ev", zzgp22.zzc(), 0);
                                continue;
                            }
                            bl3 = this.zzc().zzc(zza2.zza.zzx(), zzgp22.zzc());
                            if (bl3) break block158;
                            this.zzh();
                            object2 = zzgp22.zzc();
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl5 = true;
                                    break;
                                }
                                default: {
                                    bl5 = false;
                                }
                            }
                            if (!bl5) break block159;
                        }
                        boolean l6 = false;
                        boolean bl6 = false;
                        for (int i = 0; i < zzgp22.zzb(); ++i) {
                            zzbr.zze zze2;
                            if ("_c".equals(zzgp22.zza(i).zza())) {
                                zze2 = (zzbr.zze)((zzfd)((zzbr.zze.zza)zzgp22.zza(i).zzbk()).zza(1L).zzu());
                                l6 = true;
                                zzgp22.zza(i, zze2);
                                continue;
                            }
                            if (!"_r".equals(zzgp22.zza(i).zza())) continue;
                            zze2 = (zzbr.zze)((zzfd)((zzbr.zze.zza)zzgp22.zza(i).zzbk()).zza(1L).zzu());
                            bl6 = true;
                            zzgp22.zza(i, zze2);
                        }
                        if (!l6 && bl3) {
                            this.zzj.zzr().zzx().zza("Marking event as conversion", (Object)this.zzj.zzj().zza(zzgp22.zzc()));
                            zzgp22.zza(zzbr.zze.zzh().zza("_c").zza(1L));
                        }
                        if (!bl6) {
                            this.zzj.zzr().zzx().zza("Marking event as real-time", (Object)this.zzj.zzj().zza(zzgp22.zzc()));
                            zzgp22.zza(zzbr.zze.zzh().zza("_r").zza(1L));
                        }
                        bl = true;
                        if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zzj.zzb().zza(zza2.zza.zzx())) {
                            zzjq.zza(zzgp22, "_r");
                            bl = bl4;
                        }
                        if (zzjy.zza((String)zzgp22.zzc()) && bl3) {
                            String string5 = zza2.zza.zzx();
                            if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zzj.zzb().zzb(string5, zzam.zzq)) {
                                this.zzj.zzr().zzi().zza("Too many conversions. Not logging as conversion. appId", zzeh.zza((String)zza2.zza.zzx()));
                                boolean bl7 = false;
                                zzbr.zze.zza zza3 = null;
                                int n6 = -1;
                                for (int i = 0; i < zzgp22.zzb(); ++i) {
                                    zzbr.zze zze3 = zzgp22.zza(i);
                                    if ("_c".equals(zze3.zza())) {
                                        zza3 = (zzbr.zze.zza)zze3.zzbk();
                                        n6 = i;
                                        continue;
                                    }
                                    if (!"_err".equals(zze3.zza())) continue;
                                    bl7 = true;
                                }
                                if (bl7 && zza3 != null) {
                                    int n7 = n6;
                                    zzgp22.zzb(n7);
                                } else if (zza3 != null) {
                                    zzbr.zze zze4 = (zzbr.zze)((zzfd)((zzbr.zze.zza)((zzfd.zza)zza3.clone())).zza("_err").zza(10L).zzu());
                                    zzgp22.zza(n6, zze4);
                                } else {
                                    this.zzj.zzr().zzf().zza("Did not find conversion parameter. appId", zzeh.zza((String)zza2.zza.zzx()));
                                }
                            }
                        }
                    }
                    if (bl3) {
                        zzbr.zzc.zza zzgp4 = zzgp22;
                        object2 = this;
                        Object object5 = new ArrayList<zzbr.zze>(zzgp4.zza());
                        int i = -1;
                        int n9 = -1;
                        for (n = 0; n < object5.size(); ++n) {
                            if ("value".equals(((zzbr.zze)((Object)object5.get(n))).zza())) {
                                i = n;
                                continue;
                            }
                            if (!"currency".equals(((zzbr.zze)((Object)object5.get(n))).zza())) continue;
                            n9 = n;
                        }
                        if (i != -1) {
                            if (!((zzbr.zze)((Object)object5.get(i))).zzd() && !((zzbr.zze)((Object)object5.get(i))).zzf()) {
                                ((zzjq)object2).zzj.zzr().zzk().zza("Value must be specified with a numeric type.");
                                int n10 = i;
                                zzgp4.zzb(n10);
                                zzjq.zza(zzgp4, "_c");
                                zzjq.zza(zzgp4, 18, "value");
                            } else {
                                n = 0;
                                if (n9 == -1) {
                                    n = 1;
                                } else {
                                    object3 = ((zzbr.zze)((Object)object5.get(n9))).zzc();
                                    if (((String)object3).length() != 3) {
                                        n = 1;
                                    } else {
                                        int n11;
                                        for (i = 0; i < ((String)object3).length(); i += Character.charCount(n11)) {
                                            n11 = ((String)object3).codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n != 0) {
                                    ((zzjq)object2).zzj.zzr().zzk().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    int n12 = i;
                                    zzgp4.zzb(n12);
                                    zzjq.zza(zzgp4, "_c");
                                    zzjq.zza(zzgp4, 19, "currency");
                                }
                            }
                        }
                    }
                    if (this.zzj.zzb().zze(zza2.zza.zzx(), zzam.zzbc)) {
                        if ("_e".equals(zzgp22.zzc())) {
                            this.zzh();
                            if (zzju.zza((zzbr.zzc)((zzfd)zzgp22.zzu()), "_fr") == null) {
                                if (zza5 != null && Math.abs(zza5.zze() - zzgp22.zze()) <= 1000L) {
                                    zzbr.zzc.zza l15 = (zzbr.zzc.zza)((zzfd.zza)zza5.clone());
                                    if (this.zza(zzgp22, l15)) {
                                        zzgp3 = null;
                                        zza5 = null;
                                        zza4.zza(n5, l15);
                                    } else {
                                        zzgp3 = zzgp22;
                                        n4 = n3;
                                    }
                                } else {
                                    zzgp3 = zzgp22;
                                    n4 = n3;
                                }
                            }
                        } else if ("_vs".equals(zzgp22.zzc())) {
                            this.zzh();
                            if (zzju.zza((zzbr.zzc)((zzfd)zzgp22.zzu()), "_et") == null) {
                                if (zzgp3 != null && Math.abs(zzgp3.zze() - zzgp22.zze()) <= 1000L) {
                                    zzbr.zzc.zza zza6 = (zzbr.zzc.zza)((zzfd.zza)zzgp3.clone());
                                    if (this.zza(zza6, zzgp22)) {
                                        zzgp3 = null;
                                        zza5 = null;
                                        zza4.zza(n4, zza6);
                                    } else {
                                        zza5 = zzgp22;
                                        n5 = n3;
                                    }
                                } else {
                                    zza5 = zzgp22;
                                    n5 = n3;
                                }
                            }
                        } else if (this.zzj.zzb().zze(zza2.zza.zzx(), zzam.zzch) && "_ab".equals(zzgp22.zzc())) {
                            this.zzh();
                            if (zzju.zza((zzbr.zzc)((zzfd)zzgp22.zzu()), "_et") == null && zzgp3 != null && Math.abs(zzgp3.zze() - zzgp22.zze()) <= 4000L) {
                                zzbr.zzc.zza zza7 = (zzbr.zzc.zza)((zzfd.zza)zzgp3.clone());
                                this.zzb(zza7, zzgp22);
                                zzgp3 = null;
                                zza4.zza(n4, zza7);
                            }
                        }
                    }
                    if (!bl2 && "_e".equals(zzgp22.zzc())) {
                        if (zzgp22.zzb() == 0) {
                            this.zzj.zzr().zzi().zza("Engagement event does not contain any parameters. appId", zzeh.zza((String)zza2.zza.zzx()));
                        } else {
                            this.zzh();
                            Long l2 = (Long)zzju.zzb((zzbr.zzc)((zzfd)zzgp22.zzu()), "_et");
                            if (l2 == null) {
                                this.zzj.zzr().zzi().zza("Engagement event does not include duration. appId", zzeh.zza((String)zza2.zza.zzx()));
                            } else {
                                l5 += l2.longValue();
                            }
                        }
                    }
                    zza2.zzc.set(n2, (zzbr.zzc)((zzfd)zzgp22.zzu()));
                    ++n3;
                    zza4.zza(zzgp22);
                }
                if (bl2) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        Long l3;
                        zzbr.zzc zzc2 = zza4.zzb(n2);
                        if ("_e".equals(zzc2.zzc())) {
                            this.zzh();
                            if (zzju.zza(zzc2, "_fr") != null) {
                                zza4.zzc(n2);
                                --n3;
                                --n2;
                                continue;
                            }
                        }
                        this.zzh();
                        zzbr.zze zzb2 = zzju.zza(zzc2, "_et");
                        if (zzb2 == null || (l3 = zzb2.zzd() ? Long.valueOf(zzb2.zze()) : null) == null || l3 <= 0L) continue;
                        l5 += l3.longValue();
                    }
                }
                this.zza(zza4, l5, false);
                if (this.zzj.zzb().zze(zza4.zzj(), zzam.zzbs)) {
                    n2 = 0;
                    for (zzbr.zzc zzc2 : zza4.zza()) {
                        if (!"_s".equals(zzc2.zzc())) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) {
                        this.zze().zzb(zza4.zzj(), "_se");
                    }
                    this.zza(zza4, l5, true);
                } else if (this.zzj.zzb().zze(zza4.zzj(), zzam.zzbt)) {
                    this.zze().zzb(zza4.zzj(), "_se");
                }
                if (this.zzj.zzb().zze(zza4.zzj(), zzam.zzbe)) {
                    zzg zzg2;
                    zzbr.zzg.zza zza10 = zza4;
                    object2 = this.zzh();
                    object2.zzr().zzx().zza("Checking account type status for ad personalization signals");
                    if (((zzjo)((Object)object2)).zzj().zze(zza10.zzj()) && (zzg2 = ((zzjo)((Object)object2)).zzi().zzb(zza10.zzj())) != null && zzg2.zzad() && object2.zzl().zzj()) {
                        object2.zzr().zzw().zza("Turning off ad personalization due to account type");
                        zzbr.zzk sQLiteException = (zzbr.zzk)((zzfd)zzbr.zzk.zzj().zza("_npa").zza(object2.zzl().zzh()).zzb(1L).zzu());
                        boolean bl9 = false;
                        for (n = 0; n < zza10.zze(); ++n) {
                            if (!"_npa".equals(zza10.zzd(n).zzc())) continue;
                            zza10.zza(n, sQLiteException);
                            bl9 = true;
                            break;
                        }
                        if (!bl9) {
                            zza10.zza(sQLiteException);
                        }
                    }
                }
                if (this.zzj.zzb().zze(zza4.zzj(), zzam.zzcd)) {
                    zzjq.zza(zza4);
                }
                zzbr.zzg.zza zza8 = zza4.zzm();
                long l8 = zza4.zzf();
                Object object4 = zza4.zza();
                Object object7 = zza4.zzd();
                Object object8 = zza4.zzj();
                object2 = this;
                Preconditions.checkNotEmpty((String)object8);
                zza8.zzc(((zzjq)object2).zzf().zza((String)object8, (List<zzbr.zzc>)object4, (List<zzbr.zzk>)object7, l8));
                if (this.zzj.zzb().zze(zza2.zza.zzx())) {
                    object7 = zza2;
                    object8 = zza4;
                    object2 = this;
                    object4 = new HashMap();
                    ArrayList<zzbr.zzc> arrayList = new ArrayList<zzbr.zzc>();
                    SecureRandom secureRandom = ((zzjq)object2).zzj.zzi().zzh();
                    for (int i = 0; i < ((zzbr.zzg.zza)((Object)object8)).zzb(); ++i) {
                        boolean bl8;
                        int n13;
                        long l9;
                        long l10;
                        zzbr.zzc.zza zza12;
                        block156: {
                            zza12 = (zzbr.zzc.zza)((zzbr.zzg.zza)((Object)object8)).zzb(i).zzbk();
                            if (zza12.zzc().equals("_ep")) {
                                ((zzjq)object2).zzh();
                                object = (String)zzju.zzb((zzbr.zzc)((zzfd)zza12.zzu()), "_en");
                                string2 = (zzag)object4.get(object);
                                if (string2 == null) {
                                    string2 = ((zzjq)object2).zze().zza(((zza)object7).zza.zzx(), (String)object);
                                    object4.put(object, string2);
                                }
                                if (((zzag)string2).zzi == null) {
                                    if (((zzag)string2).zzj > 1L) {
                                        ((zzjq)object2).zzh();
                                        zzju.zza(zza12, "_sr", ((zzag)string2).zzj);
                                    }
                                    if (((zzag)string2).zzk != null && ((zzag)string2).zzk.booleanValue()) {
                                        ((zzjq)object2).zzh();
                                        zzju.zza(zza12, "_efs", 1L);
                                    }
                                    arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                                }
                                ((zzbr.zzg.zza)((Object)object8)).zza(i, zza12);
                                continue;
                            }
                            l10 = ((zzjq)object2).zzc().zzf(((zza)object7).zza.zzx());
                            ((zzjq)object2).zzj.zzi();
                            l9 = zzjy.zza((long)zza12.zze(), (long)l10);
                            n13 = 1;
                            Long l4 = 1L;
                            String string3 = "_dbg";
                            zzbr.zzc zzc3 = (zzbr.zzc)((zzfd)zza12.zzu());
                            if (TextUtils.isEmpty((CharSequence)string3) || l4 == null) {
                                bl8 = false;
                            } else {
                                for (zzbr.zze zze5 : zzc3.zza()) {
                                    if (!string3.equals(zze5.zza())) continue;
                                    bl8 = l4 instanceof Long && ((Object)l4).equals(zze5.zze()) || l4 instanceof String && ((Object)l4).equals(zze5.zzc()) || l4 instanceof Double && ((Object)l4).equals(zze5.zzg());
                                    break block156;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n13 = ((zzjq)object2).zzc().zzd(((zza)object7).zza.zzx(), zza12.zzc());
                        }
                        if (n13 <= 0) {
                            ((zzjq)object2).zzj.zzr().zzi().zza("Sample rate must be positive. event, rate", (Object)zza12.zzc(), (Object)n13);
                            arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                            ((zzbr.zzg.zza)((Object)object8)).zza(i, zza12);
                            continue;
                        }
                        zzag2 = (zzag)object4.get(zza12.zzc());
                        if (zzag2 == null && (zzag2 = ((zzjq)object2).zze().zza(((zza)object7).zza.zzx(), zza12.zzc())) == null) {
                            ((zzjq)object2).zzj.zzr().zzi().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)((zza)object7).zza.zzx(), (Object)zza12.zzc());
                            zzag2 = ((zzjq)object2).zzj.zzb().zze(((zza)object7).zza.zzx(), zzam.zzbr) ? new zzag(((zza)object7).zza.zzx(), zza12.zzc(), 1L, 1L, 1L, zza12.zze(), 0L, null, null, null, null) : new zzag(((zza)object7).zza.zzx(), zza12.zzc(), 1L, 1L, zza12.zze(), 0L, null, null, null, null);
                        }
                        ((zzjq)object2).zzh();
                        Long l12 = (Long)zzju.zzb((zzbr.zzc)((zzfd)zza12.zzu()), "_eid");
                        Boolean bl9 = l12 != null;
                        if (n13 == 1) {
                            arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                            if (bl9.booleanValue() && (zzag2.zzi != null || zzag2.zzj != null || zzag2.zzk != null)) {
                                zzag2 = zzag2.zza(null, null, null);
                                object4.put(zza12.zzc(), zzag2);
                            }
                            ((zzbr.zzg.zza)((Object)object8)).zza(i, zza12);
                            continue;
                        }
                        if (secureRandom.nextInt(n13) == 0) {
                            ((zzjq)object2).zzh();
                            zzju.zza(zza12, "_sr", n13);
                            arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                            if (bl9.booleanValue()) {
                                zzag2 = zzag2.zza(null, Long.valueOf(n13), null);
                            }
                            object4.put(zza12.zzc(), zzag2.zza(zza12.zze(), l9));
                        } else {
                            boolean bl12;
                            long l13;
                            if (((zzjq)object2).zzj.zzb().zzk(((zza)object7).zza.zzx())) {
                                if (zzag2.zzh != null) {
                                    l13 = zzag2.zzh;
                                } else {
                                    ((zzjq)object2).zzj.zzi();
                                    l13 = zzjy.zza((long)zza12.zzf(), (long)l10);
                                }
                                bl12 = l13 != l9;
                            } else {
                                l13 = zzag2.zzg;
                                boolean bl10 = bl12 = Math.abs(zza12.zze() - l13) >= 86400000L;
                            }
                            if (bl12) {
                                ((zzjq)object2).zzh();
                                zzju.zza(zza12, "_efs", 1L);
                                ((zzjq)object2).zzh();
                                zzju.zza(zza12, "_sr", n13);
                                arrayList.add((zzbr.zzc)((zzfd)zza12.zzu()));
                                if (bl9.booleanValue()) {
                                    zzag2 = zzag2.zza(null, Long.valueOf(n13), Boolean.valueOf(true));
                                }
                                object4.put(zza12.zzc(), zzag2.zza(zza12.zze(), l9));
                            } else if (bl9.booleanValue()) {
                                object4.put(zza12.zzc(), zzag2.zza(l12, null, null));
                            }
                        }
                        ((zzbr.zzg.zza)((Object)object8)).zza(i, zza12);
                    }
                    if (arrayList.size() < ((zzbr.zzg.zza)((Object)object8)).zzb()) {
                        ((zzbr.zzg.zza)((Object)object8)).zzc().zza(arrayList);
                    }
                    for (Map.Entry entry : object4.entrySet()) {
                        ((zzjq)object2).zze().zza((zzag)entry.getValue());
                    }
                }
                if (!this.zzj.zzb().zze(zza4.zzj(), zzam.zzcd)) {
                    zzjq.zza(zza4);
                }
                String string7 = zza2.zza.zzx();
                zzg zzg3 = this.zze().zzb(string7);
                if (zzg3 == null) {
                    this.zzj.zzr().zzf().zza("Bundling raw events w/o app info. appId", zzeh.zza((String)zza2.zza.zzx()));
                } else if (zza4.zzb() > 0) {
                    long l6 = zzg3.zzi();
                    if (l6 != 0L) {
                        zza4.zze(l6);
                    } else {
                        zza4.zzi();
                    }
                    long l7 = zzg3.zzh();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    if (l7 != 0L) {
                        zza4.zzd(l7);
                    } else {
                        zza4.zzh();
                    }
                    zzg3.zzt();
                    zza4.zzf((int)zzg3.zzq());
                    zzg3.zza(zza4.zzf());
                    zzg3.zzb(zza4.zzg());
                    String string4 = zzg3.zzab();
                    if (string4 != null) {
                        zza4.zzj(string4);
                    } else {
                        zza4.zzk();
                    }
                    this.zze().zza(zzg3);
                }
                if (zza4.zzb() > 0) {
                    zzp zzp2 = this.zzj.zzu();
                    zzbo.zzb zzb2 = this.zzc().zza(zza2.zza.zzx());
                    if (zzb2 == null || !zzb2.zza()) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zza.zzam())) {
                            zza4.zzi(-1L);
                        } else {
                            this.zzj.zzr().zzi().zza("Did not find measurement config or missing version info. appId", zzeh.zza((String)zza2.zza.zzx()));
                        }
                    } else {
                        zza4.zzi(zzb2.zzb());
                    }
                    this.zze().zza((zzbr.zzg)((zzfd)zza4.zzu()), bl);
                }
                object8 = zza2.zzb;
                object2 = this.zze();
                Preconditions.checkNotNull((Object)object8);
                object2.zzd();
                ((zzjn)((Object)object2)).zzak();
                object7 = new StringBuilder("rowid in (");
                for (int i = 0; i < object8.size(); ++i) {
                    if (i != 0) {
                        ((StringBuilder)object7).append(",");
                    }
                    ((StringBuilder)object7).append((Long)object8.get(i));
                }
                ((StringBuilder)object7).append(")");
                int n14 = ((zzv)((Object)object2)).c_().delete("raw_events", ((StringBuilder)object7).toString(), null);
                if (n14 != object8.size()) {
                    object2.zzr().zzf().zza("Deleted fewer rows from raw events table than expected", (Object)n14, (Object)object8.size());
                }
                object8 = string7;
                object2 = this.zze();
                object7 = ((zzv)((Object)object2)).c_();
                try {
                    object7.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{object8, object8});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzr().zzf().zza("Failed to remove unused event metadata. appId", zzeh.zza((String)object8), (Object)sQLiteException);
                }
                this.zze().b_();
                return true;
            }
            this.zze().b_();
            return false;
        }
        finally {
            this.zze().zzh();
        }
    }

    private static void zza(zzbr.zzg.zza zza2) {
        zza2.zzb(Long.MAX_VALUE).zzc(Long.MIN_VALUE);
        for (int i = 0; i < zza2.zzb(); ++i) {
            zzbr.zzc zzc2 = zza2.zzb(i);
            if (zzc2.zze() < zza2.zzf()) {
                zza2.zzb(zzc2.zze());
            }
            if (zzc2.zze() <= zza2.zzg()) continue;
            zza2.zzc(zzc2.zze());
        }
    }

    @VisibleForTesting
    private final void zza(zzbr.zzg.zza zza2, long l, boolean bl) {
        zzjz zzjz2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzjz2 = (zzjz2 = this.zze().zzc(zza2.zzj(), string)) == null || zzjz2.zze == null ? new zzjz(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)l) : new zzjz(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)((Long)zzjz2.zze + l));
        zzbr.zzk zzk2 = (zzbr.zzk)((zzfd)zzbr.zzk.zzj().zza(string).zza(this.zzj.zzm().currentTimeMillis()).zzb((Long)zzjz2.zze).zzu());
        boolean bl2 = false;
        for (int i = 0; i < zza2.zze(); ++i) {
            if (!string.equals(zza2.zzd(i).zzc())) continue;
            zza2.zza(i, zzk2);
            bl2 = true;
            break;
        }
        if (!bl2) {
            zza2.zza(zzk2);
        }
        if (l > 0L) {
            this.zze().zza(zzjz2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj.zzr().zzw().zza("Updated engagement user property. scope, value", (Object)string2, zzjz2.zze);
        }
    }

    private final boolean zza(zzbr.zzc.zza zza2, zzbr.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzc()));
        this.zzh();
        zzbr.zze zze2 = zzju.zza((zzbr.zzc)((zzfd)zza2.zzu()), "_sc");
        String string = zze2 == null ? null : zze2.zzc();
        this.zzh();
        zzbr.zze zze3 = zzju.zza((zzbr.zzc)((zzfd)zza3.zzu()), "_pc");
        String string2 = zze3 == null ? null : zze3.zzc();
        if (string2 != null && string2.equals(string)) {
            this.zzb(zza2, zza3);
            return true;
        }
        return false;
    }

    private final void zzb(zzbr.zzc.zza zza2, zzbr.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzc()));
        this.zzh();
        zzbr.zze zze2 = zzju.zza((zzbr.zzc)((zzfd)zza2.zzu()), "_et");
        if (!zze2.zzd() || zze2.zze() <= 0L) {
            return;
        }
        long l = zze2.zze();
        this.zzh();
        zze2 = zzju.zza((zzbr.zzc)((zzfd)zza3.zzu()), "_et");
        if (zze2 != null && zze2.zze() > 0L) {
            l += zze2.zze();
        }
        this.zzh();
        zzju.zza(zza3, "_et", l);
        this.zzh();
        zzju.zza(zza2, "_fr", 1L);
    }

    @VisibleForTesting
    private static void zza(zzbr.zzc.zza zza2, @NonNull String string) {
        List<zzbr.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zza())) continue;
            int n = i;
            zza2.zzb(n);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzbr.zzc.zza zza2, int n, String string) {
        List<zzbr.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zza())) continue;
            return;
        }
        zzbr.zze zze2 = (zzbr.zze)((zzfd)zzbr.zze.zzh().zza("_err").zza(n).zzu());
        zzbr.zze zze3 = (zzbr.zze)((zzfd)zzbr.zze.zzh().zza("_ev").zzb(string).zzu());
        zza2.zza(zze2).zza(zze3);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzw();
        this.zzk();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzw;
            this.zzw = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
                    this.zzj.zzc().zzd.zza(0L);
                    this.zzz();
                    this.zzj.zzr().zzx().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zze().zzf();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzv zzv2 = this.zze();
                                zzv2.zzd();
                                zzv2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzv2.c_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzv2.zzr().zzf().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzx != null && this.zzx.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zze().b_();
                    }
                    finally {
                        this.zze().zzh();
                    }
                    this.zzx = null;
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzy = -1L;
                        this.zzz();
                    }
                    this.zzn = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj.zzr().zzf().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzn = this.zzj.zzm().elapsedRealtime();
                    this.zzj.zzr().zzx().zza("Disable upload, time", (Object)this.zzn);
                }
            } else {
                this.zzj.zzr().zzx().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                }
                this.zze().zza(list);
                this.zzz();
            }
            return;
        }
        finally {
            this.zzs = false;
            this.zzaa();
        }
    }

    private final boolean zzy() {
        this.zzw();
        this.zzk();
        return this.zze().zzy() || !TextUtils.isEmpty((CharSequence)this.zze().d_());
    }

    @WorkerThread
    private final void zza(zzg zzg2) {
        this.zzw();
        if (TextUtils.isEmpty((CharSequence)zzg2.zzd()) && TextUtils.isEmpty((CharSequence)zzg2.zze())) {
            this.zza(zzg2.zzb(), 204, null, null, null);
            return;
        }
        Object object = zzg2;
        Object object2 = this.zzj.zzb();
        Object object3 = new Uri.Builder();
        String string = object.zzd();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = object.zze();
        }
        String string2 = String.valueOf(string);
        object3.scheme((String)zzam.zzh.zza(null)).encodedAuthority((String)zzam.zzi.zza(null)).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", object.zzc()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(object2.zzf()));
        String string3 = object3.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzj.zzr().zzx().zza("Fetching remote configuration", (Object)zzg2.zzb());
            zzbo.zzb zzb2 = this.zzc().zza(zzg2.zzb());
            ArrayMap arrayMap = null;
            String string4 = this.zzc().zzb(zzg2.zzb());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzr = true;
            zzjr zzjr2 = new zzjr(this);
            string = arrayMap;
            object3 = uRL;
            object = zzg2.zzb();
            object2 = this.zzd();
            object2.zzd();
            ((zzjn)((Object)object2)).zzak();
            Preconditions.checkNotNull((Object)object3);
            Preconditions.checkNotNull((Object)zzjr2);
            object2.zzq().zzb((Runnable)new zzep((zzel)((Object)object2), (String)object, (URL)object3, null, (Map)((Object)string), zzjr2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj.zzr().zzf().zza("Failed to parse config URL. Not fetching. appId", zzeh.zza((String)zzg2.zzb()), (Object)string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj.zzr().zzx().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zze().zzf();
            try {
                boolean bl;
                zzg zzg2 = this.zze().zzb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzj.zzr().zzi().zza("App does not exist in onConfigFetched. appId", zzeh.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzc().zza(string) == null && !this.zzc().zza(string, null, null) : !this.zzc().zza(string, byArray, string2)) {
                        return;
                    }
                    zzg2.zzh(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzg2);
                    if (n == 404) {
                        this.zzj.zzr().zzk().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj.zzr().zzx().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzz();
                    }
                } else {
                    zzg2.zzi(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzg2);
                    this.zzj.zzr().zzx().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzc().zzc(string);
                    this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                    }
                    this.zzz();
                }
                this.zze().b_();
            }
            finally {
                this.zze().zzh();
            }
            return;
        }
        finally {
            this.zzr = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final void zzz() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzw();
            this.zzk();
            if (!this.zzac() && !this.zzj.zzb().zza(zzam.zzbh)) {
                return;
            }
            if (this.zzn > 0L) {
                l3 = this.zzj.zzm().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzn);
                if (l2 > 0L) {
                    this.zzj.zzr().zzx().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzt().zzb();
                    this.zzv().zzf();
                    return;
                }
                this.zzn = 0L;
            }
            if (!this.zzj.zzag() || !this.zzy()) {
                this.zzj.zzr().zzx().zza("Nothing to upload or uploading impossible");
                this.zzt().zzb();
                this.zzv().zzf();
                return;
            }
            zzjq zzjq2 = this;
            long l4 = zzjq2.zzj.zzm().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzam.zzad.zza(null));
            boolean bl = zzjq2.zze().zzz() || zzjq2.zze().zzk();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzjq2.zzj.zzb().zzw())) && !".none.".equals(string) ? Math.max(0L, (Long)zzam.zzy.zza(null)) : Math.max(0L, (Long)zzam.zzx.zza(null))) : Math.max(0L, (Long)zzam.zzw.zza(null));
            long l7 = zzjq2.zzj.zzc().zzc.zza();
            long l8 = zzjq2.zzj.zzc().zzd.zza();
            long l9 = zzjq2.zze().zzw();
            long l10 = zzjq2.zze().zzx();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzjq2.zzh().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzam.zzaf.zza(null))); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzam.zzae.zza(null)) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj.zzr().zzx().zza("Next upload time is 0");
            this.zzt().zzb();
            this.zzv().zzf();
            return;
        }
        if (!this.zzd().zzf()) {
            this.zzj.zzr().zzx().zza("No network");
            this.zzt().zza();
            this.zzv().zzf();
            return;
        }
        l2 = this.zzj.zzc().zze.zza();
        long l16 = Math.max(0L, (Long)zzam.zzu.zza(null));
        if (!this.zzh().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzt().zzb();
        long l17 = l3 - this.zzj.zzm().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzam.zzz.zza(null));
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzj.zzr().zzx().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzv().zza(l17);
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzw();
        if (this.zzo == null) {
            this.zzo = new ArrayList<Runnable>();
        }
        this.zzo.add(runnable);
    }

    @WorkerThread
    private final void zzaa() {
        this.zzw();
        if (this.zzr || this.zzs || this.zzt) {
            this.zzj.zzr().zzx().zza("Not stopping services. fetch, network, upload", (Object)this.zzr, (Object)this.zzs, (Object)this.zzt);
            return;
        }
        this.zzj.zzr().zzx().zza("Stopping uploading service(s)");
        if (this.zzo == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzo.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzo.clear();
    }

    @WorkerThread
    private final Boolean zzb(zzg zzg2) {
        try {
            if (zzg2.zzk() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzg2.zzb(), (int)0).versionCode;
                if (zzg2.zzk() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzg2.zzb(), (int)0).versionName;
                if (zzg2.zzj() != null && zzg2.zzj().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzab() {
        this.zzw();
        if (this.zzj.zzb().zza(zzam.zzcc) && this.zzu != null && this.zzu.isValid()) {
            this.zzj.zzr().zzx().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzj.zzn().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzv = new RandomAccessFile(file2, "rw").getChannel();
            this.zzu = this.zzv.tryLock();
            if (this.zzu != null) {
                this.zzj.zzr().zzx().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj.zzr().zzf().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj.zzr().zzf().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj.zzr().zzi().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj.zzr().zzi().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj.zzr().zzf().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final void zzo() {
        block3: {
            block4: {
                this.zzw();
                this.zzk();
                if (this.zzm) break block3;
                this.zzm = true;
                var1_1 = this;
                var1_1.zzw();
                var1_1.zzk();
                if (!var1_1.zzj.zzb().zza(zzam.zzbh) && !var1_1.zzac() || !var1_1.zzab()) break block3;
                var2_2 = var1_1.zza(var1_1.zzv);
                var6_4 = var3_3 = var1_1.zzj.zzy().zzae();
                var5_5 = var2_2;
                var4_6 = var1_1;
                var4_6.zzw();
                if (var5_5 <= var6_4) break block4;
                var4_6.zzj.zzr().zzf().zza("Panic: can't downgrade version. Previous, current version", (Object)var5_5, (Object)var6_4);
                v0 = false;
                break block3;
            }
            if (var5_5 >= var6_4) ** GOTO lbl25
            if (!var4_6.zza(var6_4, var4_6.zzv)) {
                var4_6.zzj.zzr().zzf().zza("Storage version upgrade failed. Previous, current version", (Object)var5_5, (Object)var6_4);
                v0 = false;
            } else {
                var4_6.zzj.zzr().zzx().zza("Storage version upgraded. Previous, current version", (Object)var5_5, (Object)var6_4);
lbl25:
                // 2 sources

                v0 = true;
            }
        }
        if (!this.zzl && !this.zzj.zzb().zza(zzam.zzbh)) {
            this.zzj.zzr().zzv().zza("This instance being marked as an uploader");
            this.zzl = true;
            this.zzz();
        }
    }

    @WorkerThread
    private final boolean zzac() {
        this.zzw();
        this.zzk();
        return this.zzl;
        {
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(zzm zzm2) {
        if (this.zzw != null) {
            this.zzx = new ArrayList<Long>();
            this.zzx.addAll(this.zzw);
        }
        String string = zzm2.zza;
        zzv zzv2 = this.zze();
        Preconditions.checkNotEmpty((String)string);
        zzv2.zzd();
        zzv2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzv2.c_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzv2.zzr().zzx().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzv2.zzr().zzf().zza("Error resetting analytics data. appId, error", zzeh.zza((String)string), (Object)sQLiteException);
        }
        zzka.zzb();
        if (this.zzj.zzb().zza(zzam.zzci)) {
            if (zzm2.zzh) {
                this.zzc(zzm2);
                return;
            }
        } else {
            zzm zzm3 = this.zza(this.zzj.zzn(), zzm2.zza, zzm2.zzb, zzm2.zzh, zzm2.zzo, zzm2.zzp, zzm2.zzm, zzm2.zzr);
            if (zzm2.zzh) {
                this.zzc(zzm3);
            }
        }
    }

    private final zzm zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, String string3) {
        String string4 = "Unknown";
        String string5 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string6 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzj.zzr().zzf().zza("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string4 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzj.zzr().zzf().zza("Error retrieving installer package name. appId", zzeh.zza((String)string));
        }
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string6 = charSequence.toString();
                }
                string5 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzj.zzr().zzf().zza("Error retrieving newly installed package info. appId, appName", zzeh.zza((String)string), (Object)string6);
            return null;
        }
        long l2 = 0L;
        zzp zzp2 = this.zzj.zzu();
        long l3 = 0L;
        if (this.zzj.zzb().zzi(string)) {
            l3 = l;
        }
        return new zzm(string, string2, string5, (long)n, string4, this.zzj.zzb().zzf(), this.zzj.zzi().zza(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false, string3, null, 0L, null);
    }

    @WorkerThread
    final void zza(zzjx zzjx2, zzm zzm2) {
        this.zzw();
        this.zzk();
        if (TextUtils.isEmpty((CharSequence)zzm2.zzb) && TextUtils.isEmpty((CharSequence)zzm2.zzr)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zze(zzm2);
            return;
        }
        int n = this.zzj.zzi().zzc(zzjx2.zza);
        if (n != 0) {
            this.zzj.zzi();
            String string = zzjy.zza((String)zzjx2.zza, (int)24, (boolean)true);
            int n2 = zzjx2.zza != null ? zzjx2.zza.length() : 0;
            this.zzj.zzi().zza(zzm2.zza, n, "_ev", string, n2);
            return;
        }
        n = this.zzj.zzi().zzb(zzjx2.zza, zzjx2.zza());
        if (n != 0) {
            this.zzj.zzi();
            String string = zzjy.zza((String)zzjx2.zza, (int)24, (boolean)true);
            Object object = zzjx2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzj.zzi().zza(zzm2.zza, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzj.zzi().zzc(zzjx2.zza, zzjx2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzjx2.zza) && this.zzj.zzb().zzm(zzm2.zza)) {
            zzag zzag2;
            zzm zzm3 = zzm2;
            String string = zzjx2.zze;
            long l = zzjx2.zzb;
            zzjq zzjq2 = this;
            long l2 = 0L;
            zzjz zzjz2 = zzjq2.zze().zzc(zzm3.zza, "_sno");
            if (zzjz2 != null && zzjz2.zze instanceof Long) {
                l2 = (Long)zzjz2.zze;
            } else {
                if (zzjz2 != null) {
                    zzjq2.zzj.zzr().zzi().zza("Retrieved last session number from database does not contain a valid (long) value", zzjz2.zze);
                }
                if (zzjq2.zzj.zzb().zze(zzm3.zza, zzam.zzaz) && (zzag2 = zzjq2.zze().zza(zzm3.zza, "_s")) != null) {
                    l2 = zzag2.zzc;
                    zzjq2.zzj.zzr().zzx().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzag2 = new zzjx("_sno", l, (Object)(++l2), string);
            zzjq2.zza((zzjx)zzag2, zzm3);
        }
        zzjz zzjz3 = new zzjz(zzm2.zza, zzjx2.zze, zzjx2.zza, zzjx2.zzb, object);
        this.zzj.zzr().zzw().zza("Setting user property", (Object)this.zzj.zzj().zzc(zzjz3.zzc), object);
        this.zze().zzf();
        try {
            this.zze(zzm2);
            boolean bl = this.zze().zza(zzjz3);
            this.zze().b_();
            if (bl) {
                this.zzj.zzr().zzw().zza("User property set", (Object)this.zzj.zzj().zzc(zzjz3.zzc), zzjz3.zze);
            } else {
                this.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzj.zzj().zzc(zzjz3.zzc), zzjz3.zze);
                this.zzj.zzi().zza(zzm2.zza, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzjx zzjx2, zzm zzm2) {
        this.zzw();
        this.zzk();
        if (TextUtils.isEmpty((CharSequence)zzm2.zzb) && TextUtils.isEmpty((CharSequence)zzm2.zzr)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zze(zzm2);
            return;
        }
        if (this.zzj.zzb().zze(zzm2.zza, zzam.zzbe)) {
            if ("_npa".equals(zzjx2.zza) && zzm2.zzs != null) {
                this.zzj.zzr().zzw().zza("Falling back to manifest metadata value for ad personalization");
                zzjx zzjx3 = new zzjx("_npa", this.zzj.zzm().currentTimeMillis(), (Object)(zzm2.zzs != false ? 1L : 0L), "auto");
                this.zza(zzjx3, zzm2);
                return;
            }
            this.zzj.zzr().zzw().zza("Removing user property", (Object)this.zzj.zzj().zzc(zzjx2.zza));
            this.zze().zzf();
            try {
                this.zze(zzm2);
                this.zze().zzb(zzm2.zza, zzjx2.zza);
                this.zze().b_();
                this.zzj.zzr().zzw().zza("User property removed", (Object)this.zzj.zzj().zzc(zzjx2.zza));
                return;
            }
            finally {
                this.zze().zzh();
            }
        }
        this.zzj.zzr().zzw().zza("Removing user property", (Object)this.zzj.zzj().zzc(zzjx2.zza));
        this.zze().zzf();
        try {
            this.zze(zzm2);
            this.zze().zzb(zzm2.zza, zzjx2.zza);
            this.zze().b_();
            this.zzj.zzr().zzw().zza("User property removed", (Object)this.zzj.zzj().zzc(zzjx2.zza));
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    final void zza(zzjn zzjn2) {
        ++this.zzp;
    }

    final void zzp() {
        ++this.zzq;
    }

    final zzfl zzs() {
        return this.zzj;
    }

    @WorkerThread
    final void zzc(zzm zzm2) {
        int n;
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        if (TextUtils.isEmpty((CharSequence)zzm2.zzb) && TextUtils.isEmpty((CharSequence)zzm2.zzr)) {
            return;
        }
        zzg zzg2 = this.zze().zzb(zzm2.zza);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.zzd()) && !TextUtils.isEmpty((CharSequence)zzm2.zzb)) {
            zzg2.zzh(0L);
            this.zze().zza(zzg2);
            this.zzc().zzd(zzm2.zza);
        }
        if (!zzm2.zzh) {
            this.zze(zzm2);
            return;
        }
        long l = zzm2.zzm;
        if (l == 0L) {
            l = this.zzj.zzm().currentTimeMillis();
        }
        if (this.zzj.zzb().zze(zzm2.zza, zzam.zzbe)) {
            this.zzj.zzx().zzi();
        }
        if ((n = zzm2.zzn) != 0 && n != 1) {
            this.zzj.zzr().zzi().zza("Incorrect app type, assuming installed app. appId, appType", zzeh.zza((String)zzm2.zza), (Object)n);
            n = 0;
        }
        this.zze().zzf();
        try {
            Bundle bundle;
            zzjz zzjz2;
            if (this.zzj.zzb().zze(zzm2.zza, zzam.zzbe) && ((zzjz2 = this.zze().zzc(zzm2.zza, "_npa")) == null || "auto".equals(zzjz2.zzb))) {
                zzjx zzjx2;
                if (zzm2.zzs != null) {
                    zzjx2 = new zzjx("_npa", l, (Object)(zzm2.zzs != false ? 1L : 0L), "auto");
                    if (zzjz2 == null || !zzjz2.zze.equals(zzjx2.zzc)) {
                        this.zza(zzjx2, zzm2);
                    }
                } else if (zzjz2 != null) {
                    zzjx2 = new zzjx("_npa", l, null, "auto");
                    this.zzb(zzjx2, zzm2);
                }
            }
            long l2 = l;
            zzm zzm3 = zzm2;
            zzjq zzjq2 = this;
            zzg zzg3 = zzjq2.zze().zzb(zzm3.zza);
            if (zzg3 != null) {
                zzjq2.zzj.zzi();
                if (zzjy.zza((String)zzm3.zzb, (String)zzg3.zzd(), (String)zzm3.zzr, (String)zzg3.zze())) {
                    zzjq2.zzj.zzr().zzi().zza("New GMP App Id passed in. Removing cached database data. appId", zzeh.zza((String)zzg3.zzb()));
                    String string = zzg3.zzb();
                    zzv zzv2 = zzjq2.zze();
                    zzv2.zzak();
                    zzv2.zzd();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzv2.c_();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzv2.zzr().zzx().zza("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzv2.zzr().zzf().zza("Error deleting application data. appId, error", zzeh.zza((String)string), (Object)sQLiteException);
                    }
                    zzg3 = null;
                }
            }
            if (zzg3 != null) {
                if (zzg3.zzk() != Integer.MIN_VALUE) {
                    if (zzg3.zzk() != zzm3.zzj) {
                        bundle = new Bundle();
                        bundle.putString("_pv", zzg3.zzj());
                        zzak zzak2 = new zzak("_au", new zzaf(bundle), "auto", l2);
                        zzjq2.zza(zzak2, zzm3);
                    }
                } else if (zzg3.zzj() != null && !zzg3.zzj().equals(zzm3.zzc)) {
                    bundle = new Bundle();
                    bundle.putString("_pv", zzg3.zzj());
                    zzak zzak3 = new zzak("_au", new zzaf(bundle), "auto", l2);
                    zzjq2.zza(zzak3, zzm3);
                }
            }
            this.zze(zzm2);
            zzjz2 = null;
            if (n == 0) {
                zzjz2 = this.zze().zza(zzm2.zza, "_f");
            } else if (n == 1) {
                zzjz2 = this.zze().zza(zzm2.zza, "_v");
            }
            if (zzjz2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    PackageInfo packageInfo;
                    zzjx zzjx3 = new zzjx("_fot", l, (Object)l3, "auto");
                    this.zza(zzjx3, zzm2);
                    if (this.zzj.zzb().zzj(zzm2.zzb)) {
                        zzm3 = zzm2;
                        zzjq2 = this;
                        zzjq2.zzw();
                        zzjq2.zzj.zzf().zza(zzm3.zza);
                    }
                    l2 = l;
                    zzm3 = zzm2;
                    zzjq2 = this;
                    zzjq2.zzw();
                    zzjq2.zzk();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    zzg3.putLong("_uwa", 0L);
                    zzg3.putLong("_pfo", 0L);
                    zzg3.putLong("_sys", 0L);
                    zzg3.putLong("_sysu", 0L);
                    if (zzjq2.zzj.zzb().zzp(zzm3.zza)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzm3.zzq) {
                        zzg3.putLong("_dac", 1L);
                    }
                    String string = zzm3.zza;
                    zzv zzv3 = zzjq2.zze();
                    Preconditions.checkNotEmpty((String)string);
                    zzv3.zzd();
                    zzv3.zzak();
                    long l4 = zzv3.zzh(string, "first_open_count");
                    if (zzjq2.zzj.zzn().getPackageManager() == null) {
                        zzjq2.zzj.zzr().zzf().zza("PackageManager is null, first open report might be inaccurate. appId", zzeh.zza((String)zzm3.zza));
                    } else {
                        packageInfo = null;
                        try {
                            packageInfo = Wrappers.packageManager((Context)zzjq2.zzj.zzn()).getPackageInfo(zzm3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjq2.zzj.zzr().zzf().zza("Package info is null, first open report might be inaccurate. appId", zzeh.zza((String)zzm3.zza), (Object)nameNotFoundException);
                        }
                        if (packageInfo != null && packageInfo.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                                if (zzjq2.zzj.zzb().zza(zzam.zzcj)) {
                                    if (l4 == 0L) {
                                        zzg3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    zzg3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl = true;
                            }
                            zzjx zzjx4 = new zzjx("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzjq2.zza(zzjx4, zzm3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzjq2.zzj.zzn()).getApplicationInfo(zzm3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjq2.zzj.zzr().zzf().zza("Application info is null, first open report might be inaccurate. appId", zzeh.zza((String)zzm3.zza), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzg3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzg3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l4 >= 0L) {
                        zzg3.putLong("_pfo", l4);
                    }
                    packageInfo = new zzak("_f", new zzaf((Bundle)zzg3), "auto", l2);
                    zzjq2.zza((zzak)packageInfo, zzm3);
                } else if (n == 1) {
                    zzjx zzjx5 = new zzjx("_fvt", l, (Object)l3, "auto");
                    this.zza(zzjx5, zzm2);
                    l2 = l;
                    zzm3 = zzm2;
                    zzjq2 = this;
                    zzjq2.zzw();
                    zzjq2.zzk();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    if (zzjq2.zzj.zzb().zzp(zzm3.zza)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzm3.zzq) {
                        zzg3.putLong("_dac", 1L);
                    }
                    bundle = new zzak("_v", new zzaf((Bundle)zzg3), "auto", l2);
                    zzjq2.zza((zzak)bundle, zzm3);
                }
                if (!this.zzj.zzb().zze(zzm2.zza, zzam.zzbd)) {
                    l2 = l;
                    zzm3 = zzm2;
                    zzjq2 = this;
                    zzg3 = new Bundle();
                    zzg3.putLong("_et", 1L);
                    if (zzjq2.zzj.zzb().zzp(zzm3.zza)) {
                        zzg3.putLong("_fr", 1L);
                    }
                    zzak zzak4 = new zzak("_e", new zzaf((Bundle)zzg3), "auto", l2);
                    zzjq2.zza(zzak4, zzm3);
                }
            } else if (zzm2.zzi) {
                l2 = l;
                zzm3 = zzm2;
                zzjq2 = this;
                zzg3 = new Bundle();
                bundle = new zzak("_cd", new zzaf((Bundle)zzg3), "auto", l2);
                zzjq2.zza((zzak)bundle, zzm3);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    private final zzm zza(String string) {
        zzg zzg2 = this.zze().zzb(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzj())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzb(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping. appId", zzeh.zza((String)string));
            return null;
        }
        return new zzm(string, zzg2.zzd(), zzg2.zzj(), zzg2.zzk(), zzg2.zzl(), zzg2.zzm(), zzg2.zzn(), null, zzg2.zzp(), false, zzg2.zzg(), zzg2.zzac(), 0L, 0, zzg2.zzad(), zzg2.zzae(), false, zzg2.zze(), zzg2.zzaf(), zzg2.zzo(), zzg2.zzag());
    }

    @WorkerThread
    final void zza(zzs zzs2) {
        zzm zzm2 = this.zza(zzs2.zza);
        if (zzm2 != null) {
            this.zza(zzs2, zzm2);
        }
    }

    @WorkerThread
    final void zza(zzs zzs2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzs2);
        Preconditions.checkNotEmpty((String)zzs2.zza);
        Preconditions.checkNotNull((Object)zzs2.zzb);
        Preconditions.checkNotNull((Object)zzs2.zzc);
        Preconditions.checkNotEmpty((String)zzs2.zzc.zza);
        this.zzw();
        this.zzk();
        if (TextUtils.isEmpty((CharSequence)zzm2.zzb) && TextUtils.isEmpty((CharSequence)zzm2.zzr)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zze(zzm2);
            return;
        }
        zzs zzs3 = new zzs(zzs2);
        new zzs(zzs2).zze = false;
        this.zze().zzf();
        try {
            boolean bl = false;
            zzs zzs4 = this.zze().zzd(zzs3.zza, zzs3.zzc.zza);
            if (zzs4 != null && !zzs4.zzb.equals(zzs3.zzb)) {
                this.zzj.zzr().zzi().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzj.zzj().zzc(zzs3.zzc.zza), (Object)zzs3.zzb, (Object)zzs4.zzb);
            }
            if (zzs4 != null && zzs4.zze) {
                zzs3.zzb = zzs4.zzb;
                zzs3.zzd = zzs4.zzd;
                zzs3.zzh = zzs4.zzh;
                zzs3.zzf = zzs4.zzf;
                zzs3.zzi = zzs4.zzi;
                zzs3.zze = zzs4.zze;
                zzs3.zzc = new zzjx(zzs3.zzc.zza, zzs4.zzc.zzb, zzs3.zzc.zza(), zzs4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzs3.zzf)) {
                zzs3.zzc = new zzjx(zzs3.zzc.zza, zzs3.zzd, zzs3.zzc.zza(), zzs3.zzc.zze);
                zzs3.zze = true;
                bl = true;
            }
            if (zzs3.zze) {
                zzjx zzjx2 = zzs3.zzc;
                zzjz zzjz2 = new zzjz(zzs3.zza, zzs3.zzb, zzjx2.zza, zzjx2.zzb, zzjx2.zza());
                if (this.zze().zza(zzjz2)) {
                    this.zzj.zzr().zzw().zza("User property updated immediately", (Object)zzs3.zza, (Object)this.zzj.zzj().zzc(zzjz2.zzc), zzjz2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("(2)Too many active user properties, ignoring", zzeh.zza((String)zzs3.zza), (Object)this.zzj.zzj().zzc(zzjz2.zzc), zzjz2.zze);
                }
                if (bl && zzs3.zzi != null) {
                    zzak zzak2 = new zzak(zzs3.zzi, zzs3.zzd);
                    this.zzb(zzak2, zzm2);
                }
            }
            if (this.zze().zza(zzs3)) {
                this.zzj.zzr().zzw().zza("Conditional property added", (Object)zzs3.zza, (Object)this.zzj.zzj().zzc(zzs3.zzc.zza), zzs3.zzc.zza());
            } else {
                this.zzj.zzr().zzf().zza("Too many conditional properties, ignoring", zzeh.zza((String)zzs3.zza), (Object)this.zzj.zzj().zzc(zzs3.zzc.zza), zzs3.zzc.zza());
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzs zzs2) {
        zzm zzm2 = this.zza(zzs2.zza);
        if (zzm2 != null) {
            this.zzb(zzs2, zzm2);
        }
    }

    @WorkerThread
    final void zzb(zzs zzs2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzs2);
        Preconditions.checkNotEmpty((String)zzs2.zza);
        Preconditions.checkNotNull((Object)zzs2.zzc);
        Preconditions.checkNotEmpty((String)zzs2.zzc.zza);
        this.zzw();
        this.zzk();
        if (TextUtils.isEmpty((CharSequence)zzm2.zzb) && TextUtils.isEmpty((CharSequence)zzm2.zzr)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zze(zzm2);
            return;
        }
        this.zze().zzf();
        try {
            this.zze(zzm2);
            zzs zzs3 = this.zze().zzd(zzs2.zza, zzs2.zzc.zza);
            if (zzs3 != null) {
                this.zzj.zzr().zzw().zza("Removing conditional user property", (Object)zzs2.zza, (Object)this.zzj.zzj().zzc(zzs2.zzc.zza));
                this.zze().zze(zzs2.zza, zzs2.zzc.zza);
                if (zzs3.zze) {
                    this.zze().zzb(zzs2.zza, zzs2.zzc.zza);
                }
                if (zzs2.zzk != null) {
                    Bundle bundle = null;
                    if (zzs2.zzk.zzb != null) {
                        bundle = zzs2.zzk.zzb.zzb();
                    }
                    zzak zzak2 = this.zzj.zzi().zza(zzs2.zza, zzs2.zzk.zza, bundle, zzs3.zzb, zzs2.zzk.zzd, true, false);
                    this.zzb(zzak2, zzm2);
                }
            } else {
                this.zzj.zzr().zzi().zza("Conditional user property doesn't exist", zzeh.zza((String)zzs2.zza), (Object)this.zzj.zzj().zzc(zzs2.zzc.zza));
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    private final zzg zze(zzm zzm2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        zzg zzg2 = this.zze().zzb(zzm2.zza);
        String string = this.zzj.zzc().zzb(zzm2.zza);
        boolean bl = false;
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzj, zzm2.zza);
            zzg2.zza(this.zzj.zzi().zzk());
            zzg2.zzd(string);
            bl = true;
        } else if (!string.equals(zzg2.zzf())) {
            zzg2.zzd(string);
            zzg2.zza(this.zzj.zzi().zzk());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzm2.zzb, (CharSequence)zzg2.zzd())) {
            zzg2.zzb(zzm2.zzb);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzm2.zzr, (CharSequence)zzg2.zze())) {
            zzg2.zzc(zzm2.zzr);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzk) && !zzm2.zzk.equals(zzg2.zzg())) {
            zzg2.zze(zzm2.zzk);
            bl = true;
        }
        if (zzm2.zze != 0L && zzm2.zze != zzg2.zzm()) {
            zzg2.zzd(zzm2.zze);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzc) && !zzm2.zzc.equals(zzg2.zzj())) {
            zzg2.zzf(zzm2.zzc);
            bl = true;
        }
        if (zzm2.zzj != zzg2.zzk()) {
            zzg2.zzc(zzm2.zzj);
            bl = true;
        }
        if (zzm2.zzd != null && !zzm2.zzd.equals(zzg2.zzl())) {
            zzg2.zzg(zzm2.zzd);
            bl = true;
        }
        if (zzm2.zzf != zzg2.zzn()) {
            zzg2.zze(zzm2.zzf);
            bl = true;
        }
        if (zzm2.zzh != zzg2.zzp()) {
            zzg2.zza(zzm2.zzh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzg) && !zzm2.zzg.equals(zzg2.zzaa())) {
            zzg2.zzh(zzm2.zzg);
            bl = true;
        }
        if (zzm2.zzl != zzg2.zzac()) {
            zzg2.zzp(zzm2.zzl);
            bl = true;
        }
        if (zzm2.zzo != zzg2.zzad()) {
            zzg2.zzb(zzm2.zzo);
            bl = true;
        }
        if (zzm2.zzp != zzg2.zzae()) {
            zzg2.zzc(zzm2.zzp);
            bl = true;
        }
        if (this.zzj.zzb().zze(zzm2.zza, zzam.zzbe) && zzm2.zzs != zzg2.zzaf()) {
            zzg2.zza(zzm2.zzs);
            bl = true;
        }
        if (zzm2.zzt != 0L && zzm2.zzt != zzg2.zzo()) {
            zzg2.zzf(zzm2.zzt);
            bl = true;
        }
        if (bl) {
            this.zze().zza(zzg2);
        }
        return zzg2;
    }

    final String zzd(zzm zzm2) {
        Future future = this.zzj.zzq().zza((Callable)new zzjt(this, zzm2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj.zzr().zzf().zza("Failed to get app instance id. appId", zzeh.zza((String)zzm2.zza), (Object)exception);
            return null;
        }
    }

    final void zza(boolean bl) {
        this.zzz();
    }

    static /* synthetic */ void zza(zzjq zzjq2, zzjv zzjv2) {
        zzjq2.zza(zzjv2);
    }

    static /* synthetic */ zzg zza(zzjq zzjq2, zzm zzm2) {
        return zzjq2.zze(zzm2);
    }

    final class zza
    implements zzx {
        zzbr.zzg zza;
        List<Long> zzb;
        List<zzbr.zzc> zzc;
        private long zzd;

        private zza() {
        }

        @Override
        public final void zza(zzbr.zzg zzg2) {
            Preconditions.checkNotNull((Object)((Object)zzg2));
            this.zza = zzg2;
        }

        @Override
        public final boolean zza(long l, zzbr.zzc zzc2) {
            Preconditions.checkNotNull((Object)((Object)zzc2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzbr.zzc>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (this.zzc.size() > 0 && com.google.android.gms.measurement.internal.zzjq$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzjq$zza.zza(zzc2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzc2.zzbl();
            if (l2 >= (long)Math.max(0, (Integer)zzam.zzl.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzc2);
            this.zzb.add(l);
            return this.zzc.size() < Math.max(1, (Integer)zzam.zzm.zza(null));
        }

        private static long zza(zzbr.zzc zzc2) {
            return zzc2.zze() / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzjp zzjp2) {
            this();
        }
    }
}

