/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzkg;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class zzu {
    String zza;
    int zzb;
    Boolean zzc;
    Boolean zzd;
    Long zze;
    Long zzf;

    zzu(String string, int n) {
        this.zza = string;
        this.zzb = n;
    }

    abstract int zza();

    @VisibleForTesting
    static Boolean zza(Boolean bl, boolean bl2) {
        if (bl == null) {
            return null;
        }
        return bl != bl2;
    }

    @VisibleForTesting
    static Boolean zza(String string, zzbj.zzf zzf2, zzet zzet2) {
        List<String> list;
        Preconditions.checkNotNull((Object)((Object)zzf2));
        if (string == null) {
            return null;
        }
        if (!zzf2.zza() || zzf2.zzb() == zzbj.zzf.zzb.zza) {
            return null;
        }
        if (zzf2.zzb() == zzbj.zzf.zzb.zzg ? zzf2.zzh() == 0 : !zzf2.zzc()) {
            return null;
        }
        zzbj.zzf.zzb zzb2 = zzf2.zzb();
        boolean bl = zzf2.zzf();
        String string2 = bl || zzb2 == zzbj.zzf.zzb.zzb || zzb2 == zzbj.zzf.zzb.zzg ? zzf2.zzd() : zzf2.zzd().toUpperCase(Locale.ENGLISH);
        if (zzf2.zzh() == 0) {
            list = null;
        } else {
            boolean bl2 = bl;
            List<String> list2 = zzf2.zzg();
            if (bl2) {
                list = list2;
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(list2.size());
                for (String string3 : list2) {
                    arrayList.add(string3.toUpperCase(Locale.ENGLISH));
                }
                list = Collections.unmodifiableList(arrayList);
            }
        }
        List<String> list3 = list;
        String string4 = null;
        if (zzb2 == zzbj.zzf.zzb.zzb) {
            string4 = string2;
        }
        return zzu.zza(string, zzb2, bl, string2, list3, string4, zzet2);
    }

    private static Boolean zza(String string, zzbj.zzf.zzb zzb2, boolean bl, String string2, List<String> list, String string3, zzet zzet2) {
        if (string == null) {
            return null;
        }
        if (zzb2 == zzbj.zzf.zzb.zzg ? list == null || list.size() == 0 : string2 == null) {
            return null;
        }
        string = bl || zzb2 == zzbj.zzf.zzb.zzb ? string : string.toUpperCase(Locale.ENGLISH);
        switch (zzb2) {
            case zzb: {
                int n = bl ? 0 : 66;
                try {
                    return Pattern.compile(string3, n).matcher(string).matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (zzet2 != null) {
                        zzet2.zzi().zza("Invalid regular expression in REGEXP audience filter. expression", (Object)string3);
                    }
                    return null;
                }
            }
            case zzc: {
                return string.startsWith(string2);
            }
            case zzd: {
                return string.endsWith(string2);
            }
            case zze: {
                return string.contains(string2);
            }
            case zzf: {
                return string.equals(string2);
            }
            case zzg: {
                return list.contains(string);
            }
        }
        return null;
    }

    static Boolean zza(long l, zzbj.zzd zzd2) {
        try {
            return zzu.zza(new BigDecimal(l), zzd2, 0.0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zza(double d, zzbj.zzd zzd2) {
        try {
            return zzu.zza(new BigDecimal(d), zzd2, Math.ulp(d));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zza(String string, zzbj.zzd zzd2) {
        if (!zzkg.zza(string)) {
            return null;
        }
        try {
            return zzu.zza(new BigDecimal(string), zzd2, 0.0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @VisibleForTesting
    private static Boolean zza(BigDecimal bigDecimal, zzbj.zzd zzd2, double d) {
        block24: {
            BigDecimal bigDecimal2;
            zzbj.zzd.zza zza2;
            BigDecimal bigDecimal3;
            BigDecimal bigDecimal4;
            BigDecimal bigDecimal5;
            double d2;
            block23: {
                block22: {
                    Preconditions.checkNotNull((Object)((Object)zzd2));
                    if (!zzd2.zza() || zzd2.zzb() == zzbj.zzd.zza.zza) {
                        return null;
                    }
                    if (zzd2.zzb() == zzbj.zzd.zza.zze ? !zzd2.zzg() || !zzd2.zzi() : !zzd2.zze()) {
                        return null;
                    }
                    zzbj.zzd.zza zza3 = zzd2.zzb();
                    BigDecimal bigDecimal6 = null;
                    BigDecimal bigDecimal7 = null;
                    BigDecimal bigDecimal8 = null;
                    if (zzd2.zzb() == zzbj.zzd.zza.zze) {
                        if (!zzkg.zza(zzd2.zzh()) || !zzkg.zza(zzd2.zzj())) {
                            return null;
                        }
                        try {
                            bigDecimal7 = new BigDecimal(zzd2.zzh());
                            bigDecimal8 = new BigDecimal(zzd2.zzj());
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    }
                    if (!zzkg.zza(zzd2.zzf())) {
                        return null;
                    }
                    try {
                        bigDecimal6 = new BigDecimal(zzd2.zzf());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    d2 = d;
                    bigDecimal5 = bigDecimal8;
                    bigDecimal4 = bigDecimal7;
                    bigDecimal3 = bigDecimal6;
                    zza2 = zza3;
                    bigDecimal2 = bigDecimal;
                    if (zza2 != zzbj.zzd.zza.zze) break block22;
                    if (bigDecimal4 == null) {
                        return null;
                    }
                    break block23;
                }
                if (bigDecimal3 == null) break block24;
            }
            switch (zza2) {
                case zzb: {
                    return bigDecimal2.compareTo(bigDecimal3) == -1;
                }
                case zzc: {
                    return bigDecimal2.compareTo(bigDecimal3) == 1;
                }
                case zzd: {
                    if (d2 != 0.0) {
                        return bigDecimal2.compareTo(bigDecimal3.subtract(new BigDecimal(d2).multiply(new BigDecimal(2)))) == 1 && bigDecimal2.compareTo(bigDecimal3.add(new BigDecimal(d2).multiply(new BigDecimal(2)))) == -1;
                    }
                    return bigDecimal2.compareTo(bigDecimal3) == 0;
                }
                case zze: {
                    return bigDecimal2.compareTo(bigDecimal4) != -1 && bigDecimal2.compareTo(bigDecimal5) != 1;
                }
            }
        }
        return null;
    }
}

