/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzkw;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgk
extends zzew {
    private final zzkj zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzgk(zzkj zzkj2) {
        this(zzkj2, null);
    }

    private zzgk(zzkj zzkj2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzkj2);
        this.zza = zzkj2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgj(this, zzm2));
    }

    @BinderThread
    public final void zza(zzan zzan2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzan2);
        this.zzb(zzm2, false);
        this.zza(new zzgs(this, zzan2, zzm2));
    }

    @VisibleForTesting
    final zzan zzb(zzan zzan2, zzm zzm2) {
        String string;
        zzm zzm3 = zzm2;
        zzan zzan3 = zzan2;
        zzgk zzgk2 = this;
        if (!"_cmp".equals(zzan3.zza) || zzan3.zzb == null || zzan3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzan3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzgk2.zza.zzb().zze(zzm3.zza, zzap.zzan)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzan2.toString());
            return new zzan("_cmpx", zzan2.zzb, zzan2.zzc, zzan2.zzd);
        }
        return zzan2;
    }

    @BinderThread
    public final void zza(zzan zzan2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzan2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgr(this, zzan2, string));
    }

    @BinderThread
    public final byte[] zza(zzan zzan2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzan2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzan2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzgu(this, zzan2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzfb.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzan2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzfb.zza((String)string), (Object)this.zza.zzi().zza(zzan2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkq zzkq2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzkq2);
        this.zzb(zzm2, false);
        this.zza(new zzgt(this, zzkq2, zzm2));
    }

    @BinderThread
    public final List<zzkq> zza(zzm zzm2, boolean bl) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgw(this, zzm2));
        try {
            List list = (List)future.get();
            ArrayList<zzkq> arrayList = new ArrayList<zzkq>(list.size());
            for (zzks zzks2 : list) {
                if (!bl && zzkv.zze((String)zzks2.zzc)) continue;
                arrayList.add(new zzkq(zzks2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            if (zzkw.zzb() && this.zza.zzb().zze(zzm2.zza, zzap.zzcx)) {
                this.zza.zzr().zzf().zza("Failed to get user properties. appId", zzfb.zza((String)zzm2.zza), (Object)exception);
            } else {
                this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzfb.zza((String)zzm2.zza), (Object)exception);
            }
            return null;
        }
    }

    @BinderThread
    public final void zza(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgv(this, zzm2));
    }

    @BinderThread
    private final void zzb(zzm zzm2, boolean bl) {
        Preconditions.checkNotNull((Object)zzm2);
        this.zza(zzm2.zza, false);
        this.zza.zzj().zza(zzm2.zzb, zzm2.zzr, zzm2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgk zzgk2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgk2 = this;
                    if (!bl2) break block9;
                    if (zzgk2.zzb == null) {
                        zzgk2.zzb = "com.google.android.gms".equals(zzgk2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzgk2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgk2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgk2.zzb.booleanValue()) break block10;
                }
                if (zzgk2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgk2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgk2.zzc = string2;
                }
                if (!string2.equals(zzgk2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzfb.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgy(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzm zzm2) {
        this.zzb(zzm2, false);
        return this.zza.zzd(zzm2);
    }

    @BinderThread
    public final void zza(zzv zzv2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        this.zzb(zzm2, false);
        zzv zzv3 = new zzv(zzv2);
        new zzv(zzv2).zza = zzm2.zza;
        this.zza(new zzgx(this, zzv3, zzm2));
    }

    @BinderThread
    public final void zza(zzv zzv2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        this.zza(zzv2.zza, true);
        zzv zzv3 = new zzv(zzv2);
        this.zza(new zzgm(this, zzv3));
    }

    @BinderThread
    public final List<zzkq> zza(String string, String string2, boolean bl, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgl(this, zzm2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkq> arrayList = new ArrayList<zzkq>(list.size());
            for (zzks zzks2 : list) {
                if (!bl && zzkv.zze((String)zzks2.zzc)) continue;
                arrayList.add(new zzkq(zzks2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            if (zzkw.zzb() && this.zza.zzb().zze(zzm2.zza, zzap.zzcx)) {
                this.zza.zzr().zzf().zza("Failed to query user properties. appId", zzfb.zza((String)zzm2.zza), (Object)exception);
            } else {
                this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzfb.zza((String)zzm2.zza), (Object)exception);
            }
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkq> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgo(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkq> arrayList = new ArrayList<zzkq>(list.size());
            for (zzks zzks2 : list) {
                if (!bl && zzkv.zze((String)zzks2.zzc)) continue;
                arrayList.add(new zzkq(zzks2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            if (zzkw.zzb() && this.zza.zzb().zze(string, zzap.zzcx)) {
                this.zza.zzr().zzf().zza("Failed to get user properties as. appId", zzfb.zza((String)string), (Object)exception);
            } else {
                this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzfb.zza((String)string), (Object)exception);
            }
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzv> zza(String string, String string2, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgn(this, zzm2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzv> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgq(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            if (zzkw.zzb() && this.zza.zzb().zze(string, zzap.zzcx)) {
                this.zza.zzr().zzf().zza("Failed to get conditional user properties as", (Object)exception);
            } else {
                this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            }
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzm zzm2) {
        this.zza(zzm2.zza, false);
        this.zza(new zzgp(this, zzm2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    static /* synthetic */ zzkj zza(zzgk zzgk2) {
        return zzgk2.zza;
    }
}

