/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.internal.measurement.zzgp;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzkw;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzw;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class zzkr
extends zzkk {
    zzkr(zzkj zzkj2) {
        super(zzkj2);
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    final void zza(zzbs.zzk.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zza().zzb().zzc();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zzb((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        this.zzr().zzf().zza("Ignoring invalid (type) user attribute value", object);
    }

    final void zza(zzbs.zze.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zza().zzb().zzc();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        this.zzr().zzf().zza("Ignoring invalid (type) event param value", object);
    }

    static zzbs.zze zza(zzbs.zzc zzc2, String string) {
        for (zzbs.zze zze2 : zzc2.zza()) {
            if (!zze2.zzb().equals(string)) continue;
            return zze2;
        }
        return null;
    }

    static Object zzb(zzbs.zzc zzc2, String string) {
        zzbs.zze zze2 = zzkr.zza(zzc2, string);
        if (zze2 != null) {
            if (zze2.zzc()) {
                return zze2.zzd();
            }
            if (zze2.zze()) {
                return zze2.zzf();
            }
            if (zze2.zzg()) {
                return zze2.zzh();
            }
        }
        return null;
    }

    static void zza(zzbs.zzc.zza zza2, String string, Object object) {
        List<zzbs.zze> list = zza2.zza();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzb())) continue;
            n = i;
            break;
        }
        zzbs.zze.zza zza3 = zzbs.zze.zzk().zza(string);
        if (object instanceof Long) {
            zza3.zza((Long)object);
        } else if (object instanceof String) {
            zza3.zzb((String)object);
        } else if (object instanceof Double) {
            zza3.zza((Double)object);
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    final String zza(zzbs.zzf zzf2) {
        if (zzf2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        Iterator<zzbs.zzg> iterator = zzf2.zza().iterator();
        while (iterator.hasNext()) {
            zzbs.zzg zzg2;
            zzbs.zzg zzg3 = zzg2 = iterator.next();
            StringBuilder stringBuilder2 = stringBuilder;
            zzkr zzkr2 = this;
            if (zzg3 == null) continue;
            zzkr.zza(stringBuilder2, 1);
            stringBuilder2.append("bundle {\n");
            if (zzg3.zza()) {
                zzkr.zza(stringBuilder2, 1, "protocol_version", zzg3.zzb());
            }
            zzkr.zza(stringBuilder2, 1, "platform", zzg3.zzq());
            if (zzg3.zzz()) {
                zzkr.zza(stringBuilder2, 1, "gmp_version", zzg3.zzaa());
            }
            if (zzg3.zzab()) {
                zzkr.zza(stringBuilder2, 1, "uploading_gmp_version", zzg3.zzac());
            }
            if (zzg3.zzbc()) {
                zzkr.zza(stringBuilder2, 1, "dynamite_version", zzg3.zzbd());
            }
            if (zzg3.zzau()) {
                zzkr.zza(stringBuilder2, 1, "config_version", zzg3.zzav());
            }
            zzkr.zza(stringBuilder2, 1, "gmp_app_id", zzg3.zzam());
            zzkr.zza(stringBuilder2, 1, "admob_app_id", zzg3.zzbb());
            zzkr.zza(stringBuilder2, 1, "app_id", zzg3.zzx());
            zzkr.zza(stringBuilder2, 1, "app_version", zzg3.zzy());
            if (zzg3.zzar()) {
                zzkr.zza(stringBuilder2, 1, "app_version_major", zzg3.zzas());
            }
            zzkr.zza(stringBuilder2, 1, "firebase_instance_id", zzg3.zzaq());
            if (zzg3.zzah()) {
                zzkr.zza(stringBuilder2, 1, "dev_cert_hash", zzg3.zzai());
            }
            zzkr.zza(stringBuilder2, 1, "app_store", zzg3.zzw());
            if (zzg3.zzg()) {
                zzkr.zza(stringBuilder2, 1, "upload_timestamp_millis", zzg3.zzh());
            }
            if (zzg3.zzi()) {
                zzkr.zza(stringBuilder2, 1, "start_timestamp_millis", zzg3.zzj());
            }
            if (zzg3.zzk()) {
                zzkr.zza(stringBuilder2, 1, "end_timestamp_millis", zzg3.zzl());
            }
            if (zzg3.zzm()) {
                zzkr.zza(stringBuilder2, 1, "previous_bundle_start_timestamp_millis", zzg3.zzn());
            }
            if (zzg3.zzo()) {
                zzkr.zza(stringBuilder2, 1, "previous_bundle_end_timestamp_millis", zzg3.zzp());
            }
            zzkr.zza(stringBuilder2, 1, "app_instance_id", zzg3.zzag());
            zzkr.zza(stringBuilder2, 1, "resettable_device_id", zzg3.zzad());
            zzkr.zza(stringBuilder2, 1, "device_id", zzg3.zzat());
            zzkr.zza(stringBuilder2, 1, "ds_id", zzg3.zzay());
            if (zzg3.zzae()) {
                zzkr.zza(stringBuilder2, 1, "limited_ad_tracking", zzg3.zzaf());
            }
            zzkr.zza(stringBuilder2, 1, "os_version", zzg3.zzr());
            zzkr.zza(stringBuilder2, 1, "device_model", zzg3.zzs());
            zzkr.zza(stringBuilder2, 1, "user_default_language", zzg3.zzt());
            if (zzg3.zzu()) {
                zzkr.zza(stringBuilder2, 1, "time_zone_offset_minutes", zzg3.zzv());
            }
            if (zzg3.zzaj()) {
                zzkr.zza(stringBuilder2, 1, "bundle_sequential_index", zzg3.zzak());
            }
            if (zzg3.zzan()) {
                zzkr.zza(stringBuilder2, 1, "service_upload", zzg3.zzao());
            }
            zzkr.zza(stringBuilder2, 1, "health_monitor", zzg3.zzal());
            if (zzg3.zzaw() && zzg3.zzax() != 0L) {
                zzkr.zza(stringBuilder2, 1, "android_id", zzg3.zzax());
            }
            if (zzg3.zzaz()) {
                zzkr.zza(stringBuilder2, 1, "retry_counter", zzg3.zzba());
            }
            List<zzfe> list = zzg3.zze();
            int n = 1;
            StringBuilder stringBuilder3 = stringBuilder2;
            zzkr zzkr3 = zzkr2;
            if (list != null) {
                ++n;
                for (zzbs.zzk zzk2 : list) {
                    if (zzk2 == null) continue;
                    zzkr.zza(stringBuilder3, 2);
                    stringBuilder3.append("user_property {\n");
                    zzkr.zza(stringBuilder3, 2, "set_timestamp_millis", zzk2.zza() ? Long.valueOf(zzk2.zzb()) : null);
                    zzkr.zza(stringBuilder3, 2, "name", zzkr3.zzo().zzc(zzk2.zzc()));
                    zzkr.zza(stringBuilder3, 2, "string_value", zzk2.zze());
                    zzkr.zza(stringBuilder3, 2, "int_value", zzk2.zzf() ? Long.valueOf(zzk2.zzg()) : null);
                    zzkr.zza(stringBuilder3, 2, "double_value", zzk2.zzh() ? Double.valueOf(zzk2.zzi()) : null);
                    zzkr.zza(stringBuilder3, 2);
                    stringBuilder3.append("}\n");
                }
            }
            Iterator<zzfe> iterator2 = zzg3.zzx();
            list = zzg3.zzap();
            n = 1;
            stringBuilder3 = stringBuilder2;
            zzkr3 = zzkr2;
            if (list != null) {
                ++n;
                for (zzbs.zza zza2 : list) {
                    if (zza2 == null) continue;
                    zzkr.zza(stringBuilder3, 2);
                    stringBuilder3.append("audience_membership {\n");
                    if (zza2.zza()) {
                        zzkr.zza(stringBuilder3, 2, "audience_id", zza2.zzb());
                    }
                    if (zza2.zzf()) {
                        zzkr.zza(stringBuilder3, 2, "new_audience", zza2.zzg());
                    }
                    zzkr.zza(stringBuilder3, 2, "current_data", zza2.zzc(), iterator2);
                    if (!zzkw.zzb() || !zzkr3.zzt().zza(zzap.zzcx) || zza2.zzd()) {
                        zzkr.zza(stringBuilder3, 2, "previous_data", zza2.zze(), iterator2);
                    }
                    zzkr.zza(stringBuilder3, 2);
                    stringBuilder3.append("}\n");
                }
            }
            list = zzg3.zzc();
            n = 1;
            stringBuilder3 = stringBuilder2;
            zzkr3 = zzkr2;
            if (list != null) {
                ++n;
                for (zzbs.zzc zzc2 : list) {
                    if (zzc2 == null) continue;
                    zzkr.zza(stringBuilder3, 2);
                    stringBuilder3.append("event {\n");
                    zzkr.zza(stringBuilder3, 2, "name", zzkr3.zzo().zza(zzc2.zzc()));
                    if (zzc2.zzd()) {
                        zzkr.zza(stringBuilder3, 2, "timestamp_millis", zzc2.zze());
                    }
                    if (zzc2.zzf()) {
                        zzkr.zza(stringBuilder3, 2, "previous_timestamp_millis", zzc2.zzg());
                    }
                    if (zzc2.zzh()) {
                        zzkr.zza(stringBuilder3, 2, "count", zzc2.zzi());
                    }
                    if (zzc2.zzb() != 0) {
                        zzkr3.zza(stringBuilder3, 2, zzc2.zza());
                    }
                    zzkr.zza(stringBuilder3, 2);
                    stringBuilder3.append("}\n");
                }
            }
            zzkr.zza(stringBuilder2, 1);
            stringBuilder2.append("}\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzbk.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zzb2.zza()) {
            zzkr.zza(stringBuilder, 0, "filter_id", zzb2.zzb());
        }
        zzkr.zza(stringBuilder, 0, "event_name", this.zzo().zza(zzb2.zzc()));
        String string = zzkr.zza(zzb2.zzh(), zzb2.zzi(), zzb2.zzk());
        if (!string.isEmpty()) {
            zzkr.zza(stringBuilder, 0, "filter_type", string);
        }
        if (!zzkw.zzb() || !this.zzt().zza(zzap.zzcx) || zzb2.zzf()) {
            this.zza(stringBuilder, 1, "event_count_filter", zzb2.zzg());
        }
        if (!zzkw.zzb() || !this.zzt().zza(zzap.zzcx) || zzb2.zze() > 0) {
            stringBuilder.append("  filters {\n");
            for (zzbk.zzc zzc2 : zzb2.zzd()) {
                this.zza(stringBuilder, 2, zzc2);
            }
        }
        zzkr.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zza(zzbk.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zze2.zza()) {
            zzkr.zza(stringBuilder, 0, "filter_id", zze2.zzb());
        }
        zzkr.zza(stringBuilder, 0, "property_name", this.zzo().zzc(zze2.zzc()));
        String string = zzkr.zza(zze2.zze(), zze2.zzf(), zze2.zzh());
        if (!string.isEmpty()) {
            zzkr.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zze2.zzd());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    private final void zza(StringBuilder stringBuilder, int n, List<zzbs.zze> list) {
        if (list == null) {
            return;
        }
        ++n;
        for (zzbs.zze zze2 : list) {
            if (zze2 == null) continue;
            zzkr.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            if (zzjr.zzb() && this.zzt().zza(zzap.zzcy)) {
                zzkr.zza(stringBuilder, n, "name", zze2.zza() ? this.zzo().zzb(zze2.zzb()) : null);
                zzkr.zza(stringBuilder, n, "string_value", zze2.zzc() ? zze2.zzd() : null);
                zzkr.zza(stringBuilder, n, "int_value", zze2.zze() ? Long.valueOf(zze2.zzf()) : null);
                zzkr.zza(stringBuilder, n, "double_value", zze2.zzg() ? Double.valueOf(zze2.zzh()) : null);
                if (zze2.zzj() > 0) {
                    this.zza(stringBuilder, n, zze2.zzi());
                }
            } else {
                zzkr.zza(stringBuilder, n, "name", this.zzo().zzb(zze2.zzb()));
                zzkr.zza(stringBuilder, n, "string_value", zze2.zzd());
                zzkr.zza(stringBuilder, n, "int_value", zze2.zze() ? Long.valueOf(zze2.zzf()) : null);
                zzkr.zza(stringBuilder, n, "double_value", zze2.zzg() ? Double.valueOf(zze2.zzh()) : null);
            }
            zzkr.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzbs.zzi zzi2, String string2) {
        int n2;
        if (zzi2 == null) {
            return;
        }
        ++n;
        zzkr.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzi2.zzd() != 0) {
            zzkr.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long object : zzi2.zzc()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzi2.zzb() != 0) {
            zzkr.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzi2.zza()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzi2.zzf() != 0) {
            zzkr.zza(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            n2 = 0;
            for (zzbs.zzb zzb2 : zzi2.zze()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzb2.zza() ? Integer.valueOf(zzb2.zzb()) : null).append(":").append(zzb2.zzc() ? Long.valueOf(zzb2.zzd()) : null);
            }
            stringBuilder.append("}\n");
        }
        if (zzi2.zzh() != 0) {
            zzkr.zza(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            n2 = 0;
            for (zzbs.zzj zzj2 : zzi2.zzg()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzj2.zza() ? Integer.valueOf(zzj2.zzb()) : null).append(": [");
                int n3 = 0;
                for (long l : zzj2.zzc()) {
                    if (n3++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                }
                stringBuilder.append("]");
            }
            stringBuilder.append("}\n");
        }
        zzkr.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzbk.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzkr.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zza()) {
            zzkr.zza(stringBuilder, n, "comparison_type", zzd2.zzb().name());
        }
        if (zzd2.zzc()) {
            zzkr.zza(stringBuilder, n, "match_as_float", zzd2.zzd());
        }
        if (!zzkw.zzb() || !this.zzt().zza(zzap.zzcx) || zzd2.zze()) {
            zzkr.zza(stringBuilder, n, "comparison_value", zzd2.zzf());
        }
        if (!zzkw.zzb() || !this.zzt().zza(zzap.zzcx) || zzd2.zzg()) {
            zzkr.zza(stringBuilder, n, "min_comparison_value", zzd2.zzh());
        }
        if (!zzkw.zzb() || !this.zzt().zza(zzap.zzcx) || zzd2.zzi()) {
            zzkr.zza(stringBuilder, n, "max_comparison_value", zzd2.zzj());
        }
        zzkr.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, zzbk.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzkr.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzc2.zze()) {
            zzkr.zza(stringBuilder, n, "complement", zzc2.zzf());
        }
        if (!zzkw.zzb() || !this.zzt().zza(zzap.zzcx) || zzc2.zzg()) {
            zzkr.zza(stringBuilder, n, "param_name", this.zzo().zzb(zzc2.zzh()));
        }
        if (!zzkw.zzb() || !this.zzt().zza(zzap.zzcx) || zzc2.zza()) {
            zzbk.zzf zzf2 = zzc2.zzb();
            String string = "string_filter";
            int n2 = n + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            zzkr zzkr2 = this;
            if (zzf2 != null) {
                zzkr.zza(stringBuilder2, n2);
                stringBuilder2.append(string);
                stringBuilder2.append(" {\n");
                if (zzf2.zza()) {
                    zzkr.zza(stringBuilder2, n2, "match_type", zzf2.zzb().name());
                }
                if (!zzkw.zzb() || !zzkr2.zzt().zza(zzap.zzcx) || zzf2.zzc()) {
                    zzkr.zza(stringBuilder2, n2, "expression", zzf2.zzd());
                }
                if (zzf2.zze()) {
                    zzkr.zza(stringBuilder2, n2, "case_sensitive", zzf2.zzf());
                }
                if (zzf2.zzh() > 0) {
                    zzkr.zza(stringBuilder2, n2 + 1);
                    stringBuilder2.append("expression_list {\n");
                    for (String string2 : zzf2.zzg()) {
                        zzkr.zza(stringBuilder2, n2 + 2);
                        stringBuilder2.append(string2);
                        stringBuilder2.append("\n");
                    }
                    stringBuilder2.append("}\n");
                }
                zzkr.zza(stringBuilder2, n2);
                stringBuilder2.append("}\n");
            }
        }
        if (!zzkw.zzb() || !this.zzt().zza(zzap.zzcx) || zzc2.zzc()) {
            this.zza(stringBuilder, n + 1, "number_filter", zzc2.zzd());
        }
        zzkr.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzkr.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzr().zzf().zza("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    @WorkerThread
    final boolean zza(zzan zzan2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzan2);
        Preconditions.checkNotNull((Object)zzm2);
        if (zzjg.zzb() && this.zzt().zza(zzap.zzcm)) {
            if (TextUtils.isEmpty((CharSequence)zzm2.zzb) && TextUtils.isEmpty((CharSequence)zzm2.zzr)) {
                return false;
            }
        } else if (TextUtils.isEmpty((CharSequence)zzm2.zzb) && TextUtils.isEmpty((CharSequence)zzm2.zzr)) {
            zzw zzw2 = this.zzu();
            return false;
        }
        return true;
    }

    static boolean zza(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzr().zzi().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzr().zzi().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final boolean zza(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzm().currentTimeMillis() - l) > l2;
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzp().zzd();
        MessageDigest messageDigest = zzkv.zzi();
        if (messageDigest == null) {
            this.zzr().zzf().zza("Failed to get MD5");
            return 0L;
        }
        return zzkv.zza((byte[])messageDigest.digest(byArray));
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzr().zzf().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzr().zzf().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    @Nullable
    final List<Integer> zzf() {
        Map map = zzap.zza((Context)this.zza.zzn());
        if (map == null || map.size() == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzap.zzal.zza(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzr().zzi().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzr().zzi().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    static <Builder extends zzgp> Builder zza(Builder Builder2, byte[] byArray) throws zzfm {
        zzer zzer2 = zzer.zzb();
        if (zzer2 != null) {
            return (Builder)Builder2.zza(byArray, zzer2);
        }
        return (Builder)Builder2.zza(byArray);
    }

    static int zza(zzbs.zzg.zza zza2, String string) {
        if (zza2 == null) {
            return -1;
        }
        for (int i = 0; i < zza2.zze(); ++i) {
            if (!string.equals(zza2.zzd(i).zzc())) continue;
            return i;
        }
        return -1;
    }
}

