/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzh;
import com.google.android.gms.internal.measurement.zzky;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzw;

public final class zzko
extends zzkp {
    private final AlarmManager zzb = (AlarmManager)this.zzn().getSystemService("alarm");
    private final zzaf zzc;
    private Integer zzd;

    protected zzko(zzks zzks2) {
        super(zzks2);
        this.zzc = new zzkn(this, (zzhh)zzks2.zzs(), zzks2);
    }

    @Override
    protected final boolean zze() {
        this.zzb.cancel(this.zzw());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzk();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzk() {
        JobScheduler jobScheduler = (JobScheduler)this.zzn().getSystemService("jobscheduler");
        int n = this.zzv();
        if (!this.zzx()) {
            this.zzr().zzx().zza("Cancelling job. JobID", (Object)n);
        }
        jobScheduler.cancel(n);
    }

    public final void zza(long l) {
        this.zzak();
        zzw zzw2 = this.zzu();
        Context context = this.zzn();
        if (!zzge.zza((Context)context)) {
            this.zzr().zzw().zza("Receiver not registered/enabled");
        }
        if (!zzla.zza((Context)context, (boolean)false)) {
            this.zzr().zzw().zza("Service not registered/enabled");
        }
        this.zzf();
        if (this.zzx()) {
            this.zzr().zzx().zza("Scheduling upload, millis", (Object)l);
        }
        long l2 = this.zzm().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzap.zzw.zza(null)) && !this.zzc.zzb()) {
            if (!this.zzx()) {
                this.zzr().zzx().zza("Scheduling upload with DelayedRunnable");
            }
            this.zzc.zza(l);
        }
        zzw2 = this.zzu();
        if (Build.VERSION.SDK_INT >= 24) {
            if (!this.zzx()) {
                this.zzr().zzx().zza("Scheduling upload with JobScheduler");
            }
            long l3 = l;
            zzko zzko2 = this;
            Context context2 = zzko2.zzn();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzko2.zzv();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            if (!zzko2.zzx()) {
                zzko2.zzr().zzx().zza("Scheduling job. JobID", (Object)n);
            }
            zzh.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        if (!this.zzx()) {
            this.zzr().zzx().zza("Scheduling upload with AlarmManager");
        }
        this.zzb.setInexactRepeating(2, l2, Math.max((Long)zzap.zzr.zza(null), l), this.zzw());
    }

    private final int zzv() {
        if (this.zzd == null) {
            String string = String.valueOf(this.zzn().getPackageName());
            this.zzd = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzd;
    }

    public final void zzf() {
        this.zzak();
        if (this.zzx()) {
            this.zzr().zzx().zza("Unscheduling upload");
        }
        this.zzb.cancel(this.zzw());
        this.zzc.zzc();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzk();
        }
    }

    private final PendingIntent zzw() {
        Context context = this.zzn();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }

    private final boolean zzx() {
        return zzky.zzb() && this.zzt().zza(zzap.zzcz);
    }
}

