/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzbo;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.internal.measurement.zzky;
import com.google.android.gms.internal.measurement.zzll;
import com.google.android.gms.internal.measurement.zzlx;
import com.google.android.gms.internal.measurement.zzmv;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzks
implements zzhh {
    private static volatile zzks zza;
    private zzgi zzb;
    private zzfo zzc;
    private zzac zzd;
    private zzfr zze;
    private zzko zzf;
    private zzn zzg;
    private final zzkw zzh;
    private zzir zzi;
    private final zzgo zzj;
    private boolean zzk = false;
    private boolean zzl;
    @VisibleForTesting
    private long zzm;
    private List<Runnable> zzn;
    private int zzo;
    private int zzp;
    private boolean zzq;
    private boolean zzr;
    private boolean zzs;
    private FileLock zzt;
    private FileChannel zzu;
    private List<Long> zzv;
    private List<Long> zzw;
    private long zzx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzks zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzks> clazz = zzks.class;
        synchronized (zzks.class) {
            if (zza != null) return zza;
            zzkx zzkx2 = new zzkx(context);
            zza = new zzks(zzkx2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    private zzks(zzkx zzkx2) {
        this(zzkx2, null);
    }

    private zzks(zzkx zzkx2, zzgo zzgo2) {
        Preconditions.checkNotNull((Object)zzkx2);
        this.zzj = zzgo2 = zzgo.zza((Context)zzkx2.zza, null);
        this.zzx = -1L;
        zzks zzks2 = this;
        zzkw zzkw2 = new zzkw(zzks2);
        zzkw2.zzal();
        this.zzh = zzkw2;
        zzks2 = this;
        zzfo zzfo2 = new zzfo(zzks2);
        zzfo2.zzal();
        this.zzc = zzfo2;
        zzks2 = this;
        zzgi zzgi2 = new zzgi(zzks2);
        zzgi2.zzal();
        this.zzb = zzgi2;
        this.zzj.zzq().zza((Runnable)new zzkr(this, zzkx2));
    }

    @WorkerThread
    private final void zza(zzkx zzkx2) {
        this.zzj.zzq().zzd();
        zzks zzks2 = this;
        zzac zzac2 = new zzac(zzks2);
        zzac2.zzal();
        this.zzd = zzac2;
        this.zzj.zzb().zza((zzz)this.zzb);
        zzks2 = this;
        zzn zzn2 = new zzn(zzks2);
        zzn2.zzal();
        this.zzg = zzn2;
        zzks2 = this;
        zzir zzir2 = new zzir(zzks2);
        zzir2.zzal();
        this.zzi = zzir2;
        zzks2 = this;
        zzko zzko2 = new zzko(zzks2);
        zzko2.zzal();
        this.zzf = zzko2;
        zzks2 = this;
        this.zze = new zzfr(zzks2);
        if (this.zzo != this.zzp) {
            this.zzj.zzr().zzf().zza("Not all upload components initialized", (Object)this.zzo, (Object)this.zzp);
        }
        this.zzk = true;
    }

    @WorkerThread
    protected final void zza() {
        this.zzj.zzq().zzd();
        this.zze().zzv();
        if (this.zzj.zzc().zzc.zza() == 0L) {
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzz();
    }

    public final zzw zzu() {
        return this.zzj.zzu();
    }

    public final zzx zzb() {
        return this.zzj.zzb();
    }

    public final zzfk zzr() {
        return this.zzj.zzr();
    }

    public final zzgh zzq() {
        return this.zzj.zzq();
    }

    public final zzgi zzc() {
        zzks.zzb(this.zzb);
        return this.zzb;
    }

    public final zzfo zzd() {
        zzks.zzb(this.zzc);
        return this.zzc;
    }

    public final zzac zze() {
        zzks.zzb(this.zzd);
        return this.zzd;
    }

    private final zzfr zzt() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    private final zzko zzv() {
        zzks.zzb(this.zzf);
        return this.zzf;
    }

    public final zzn zzf() {
        zzks.zzb(this.zzg);
        return this.zzg;
    }

    public final zzir zzg() {
        zzks.zzb(this.zzi);
        return this.zzi;
    }

    public final zzkw zzh() {
        zzks.zzb(this.zzh);
        return this.zzh;
    }

    public final zzfi zzi() {
        return this.zzj.zzj();
    }

    public final Context zzn() {
        return this.zzj.zzn();
    }

    public final Clock zzm() {
        return this.zzj.zzm();
    }

    public final zzla zzj() {
        return this.zzj.zzi();
    }

    @WorkerThread
    private final void zzw() {
        this.zzj.zzq().zzd();
    }

    final void zzk() {
        if (!this.zzk) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zzb(zzkp zzkp2) {
        if (zzkp2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzkp2.zzaj()) {
            String string = String.valueOf(((Object)((Object)zzkp2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private final long zzx() {
        long l = this.zzj.zzm().currentTimeMillis();
        zzft zzft2 = this.zzj.zzc();
        zzft2.zzaa();
        zzft2.zzd();
        long l2 = zzft2.zzg.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzft2.zzp().zzh().nextInt(86400000);
            zzft2.zzg.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zza(zzan zzan2, String string) {
        zzg zzg2 = this.zze().zzb(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzl())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzb(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzan2.zza)) {
                this.zzj.zzr().zzi().zza("Could not find package. appId", zzfk.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping event. appId", zzfk.zza((String)string));
            return;
        }
        zzm zzm2 = new zzm(string, zzg2.zze(), zzg2.zzl(), zzg2.zzm(), zzg2.zzn(), zzg2.zzo(), zzg2.zzp(), null, zzg2.zzr(), false, zzg2.zzi(), zzg2.zzae(), 0L, 0, zzg2.zzaf(), zzg2.zzag(), false, zzg2.zzf(), zzg2.zzah(), zzg2.zzq(), zzg2.zzai(), zzll.zzb() && this.zzj.zzb().zze(zzg2.zzc(), zzap.zzch) ? zzg2.zzg() : null);
        this.zza(zzan2, zzm2);
    }

    @WorkerThread
    final void zza(zzan zzan2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        this.zzw();
        this.zzk();
        String string = zzm2.zza;
        long l = zzan2.zzd;
        if (!this.zzh().zza(zzan2, zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        if (this.zzj.zzb().zze(string, zzap.zzbl) && zzm2.zzu != null) {
            if (zzm2.zzu.contains(zzan2.zza)) {
                Bundle bundle = zzan2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzan2 = new zzan(zzan2.zza, new zzam(bundle), zzan2.zzc, zzan2.zzd);
            } else {
                this.zzj.zzr().zzw().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzan2.zza, (Object)zzan2.zzc);
                return;
            }
        }
        this.zze().zzf();
        try {
            zzv zzv2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzac zzac2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzac2.zzd();
            zzac2.zzak();
            if (l2 < 0L) {
                zzac2.zzr().zzi().zza("Invalid time querying timed out conditional properties", zzfk.zza((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzac2.zza(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                if (zzky.zzb() && this.zzj.zzb().zze(zzm2.zza, zzap.zzcz)) {
                    this.zzj.zzr().zzx().zza("User property timed out", (Object)((zzv)object22).zza, (Object)this.zzj.zzj().zzc(((zzv)object22).zzc.zza), ((zzv)object22).zzc.zza());
                } else {
                    this.zzj.zzr().zzw().zza("User property timed out", (Object)((zzv)object22).zza, (Object)this.zzj.zzj().zzc(((zzv)object22).zzc.zza), ((zzv)object22).zzc.zza());
                }
                if (((zzv)object22).zzg != null) {
                    this.zzb(new zzan(((zzv)object22).zzg, l), zzm2);
                }
                this.zze().zze(string, ((zzv)object22).zzc.zza);
            }
            l2 = l;
            string3 = string;
            zzac2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzac2.zzd();
            zzac2.zzak();
            if (l2 < 0L) {
                zzac2.zzr().zzi().zza("Invalid time querying expired conditional properties", zzfk.zza((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzac2.zza(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzv)object4.next();
                if (object == null) continue;
                if (zzky.zzb() && this.zzj.zzb().zze(zzm2.zza, zzap.zzcz)) {
                    this.zzj.zzr().zzx().zza("User property expired", (Object)((zzv)object).zza, (Object)this.zzj.zzj().zzc(((zzv)object).zzc.zza), ((zzv)object).zzc.zza());
                } else {
                    this.zzj.zzr().zzw().zza("User property expired", (Object)((zzv)object).zza, (Object)this.zzj.zzj().zzc(((zzv)object).zzc.zza), ((zzv)object).zzc.zza());
                }
                this.zze().zzb(string, ((zzv)object).zzc.zza);
                if (((zzv)object).zzk != null) {
                    object22.add(((zzv)object).zzk);
                }
                this.zze().zze(string, ((zzv)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzan)e;
                this.zzb(new zzan((zzan)object, l), zzm2);
            }
            long l3 = l;
            String string4 = zzan2.zza;
            string3 = string;
            zzac2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzac2.zzd();
            zzac2.zzak();
            if (l3 < 0L) {
                zzac2.zzr().zzi().zza("Invalid time querying triggered conditional properties", zzfk.zza((String)string3), (Object)zzac2.zzo().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzac2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzv2 = (zzv)iterator.next();
                if (zzv2 == null) continue;
                zzkz zzkz2 = zzv2.zzc;
                zzlb zzlb2 = new zzlb(zzv2.zza, zzv2.zzb, zzkz2.zza, l, zzkz2.zza());
                if (this.zze().zza(zzlb2)) {
                    if (zzky.zzb() && this.zzj.zzb().zze(zzm2.zza, zzap.zzcz)) {
                        this.zzj.zzr().zzx().zza("User property triggered", (Object)zzv2.zza, (Object)this.zzj.zzj().zzc(zzlb2.zzc), zzlb2.zze);
                    } else {
                        this.zzj.zzr().zzw().zza("User property triggered", (Object)zzv2.zza, (Object)this.zzj.zzj().zzc(zzlb2.zzc), zzlb2.zze);
                    }
                } else {
                    this.zzj.zzr().zzf().zza("Too many active user properties, ignoring", zzfk.zza((String)zzv2.zza), (Object)this.zzj.zzj().zzc(zzlb2.zzc), zzlb2.zze);
                }
                if (zzv2.zzi != null) {
                    object.add(zzv2.zzi);
                }
                zzv2.zzc = new zzkz(zzlb2);
                zzv2.zze = true;
                this.zze().zza(zzv2);
            }
            this.zzb(zzan2, zzm2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzv2 = (zzan)e;
                this.zzb(new zzan((zzan)zzv2, l), zzm2);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzb(zzan var1_1, zzm var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzw();
        this.zzk();
        var5_4 = var2_2.zza;
        if (!this.zzh().zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zzc(var2_2);
            return;
        }
        if (this.zzc().zzb(var5_4, var1_1.zza)) {
            this.zzj.zzr().zzi().zza("Dropping blacklisted event. appId", zzfk.zza((String)var5_4), (Object)this.zzj.zzj().zza(var1_1.zza));
            var6_5 = this.zzc().zzg(var5_4) != false || this.zzc().zzh(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzj.zzi().zza(var5_4, 11, "_ev", var1_1.zza, 0);
            }
            if (var6_5 && (var7_7 = this.zze().zzb(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzu(), var7_7.zzt());
                if (Math.abs(this.zzj.zzm().currentTimeMillis() - var8_9) > (Long)zzap.zzy.zza(null)) {
                    this.zzj.zzr().zzw().zza("Fetching config for blacklisted app");
                    this.zza(var7_7);
                }
            }
            return;
        }
        if (this.zzj.zzr().zza(2)) {
            this.zzj.zzr().zzx().zza("Logging event", (Object)this.zzj.zzj().zza(var1_1));
        }
        this.zze().zzf();
        try {
            block76: {
                block77: {
                    block79: {
                        block83: {
                            block82: {
                                block80: {
                                    block81: {
                                        this.zzc(var2_2);
                                        var6_6 = zzjp.zzb() != false && this.zzj.zzb().zza(zzap.zzdf) != false;
                                        var7_8 = "ecommerce_purchase".equals(var1_1.zza) != false || var6_6 != false && ("purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false);
                                        if (!("_iap".equals(var1_1.zza) != false || var7_8 != false)) break block79;
                                        var26_10 = var7_8;
                                        var25_12 = var1_1;
                                        var24_16 = var5_4;
                                        var23_17 = this;
                                        var27_18 = var25_12.zzb.zzd("currency");
                                        if (!var26_10) break block80;
                                        var30_19 = var25_12.zzb.zzc("value") * 1000000.0;
                                        if (var30_19 == 0.0) {
                                            var30_19 = (double)var25_12.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var30_19 <= 9.223372036854776E18) || !(var30_19 >= -9.223372036854776E18)) break block81;
                                        var28_23 = Math.round(var30_19);
                                        if (zzjp.zzb() && var23_17.zzj.zzb().zza(zzap.zzdf) && "refund".equals(var25_12.zza)) {
                                            var28_23 = -var28_23;
                                        }
                                        break block82;
                                    }
                                    var23_17.zzj.zzr().zzi().zza("Data lost. Currency value is too big. appId", zzfk.zza((String)var24_16), (Object)var30_19);
                                    v0 = false;
                                    break block83;
                                }
                                var28_23 = var25_12.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var27_18) && (var27_18 = var27_18.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var27_18);
                                var30_20 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var31_26 /* !! */  = var23_17.zze().zzc(var24_16, var30_20);
                                if (var31_26 /* !! */  == null || !(var31_26 /* !! */ .zze instanceof Long)) {
                                    var35_27 = var24_16;
                                    var39_29 = var23_17.zzj.zzb().zzb(var35_27, zzap.zzad) - 1;
                                    var38_30 = var24_16;
                                    var37_31 = var23_17.zze();
                                    Preconditions.checkNotEmpty((String)var38_30);
                                    var37_31.zzd();
                                    var37_31.zzak();
                                    try {
                                        var37_31.c_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var38_30, var38_30, String.valueOf(var39_29)});
                                    }
                                    catch (SQLiteException var40_32) {
                                        var37_31.zzr().zzf().zza("Error pruning currencies. appId", zzfk.zza((String)var38_30), (Object)var40_32);
                                    }
                                    var31_26 /* !! */  = new zzlb(var24_16, var25_12.zzc, var30_20, var23_17.zzj.zzm().currentTimeMillis(), (Object)var28_23);
                                } else {
                                    var32_33 = (Long)var31_26 /* !! */ .zze;
                                    var31_26 /* !! */  = new zzlb(var24_16, var25_12.zzc, var30_20, var23_17.zzj.zzm().currentTimeMillis(), (Object)(var32_33 + var28_23));
                                }
                                if (!var23_17.zze().zza(var31_26 /* !! */ )) {
                                    var23_17.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property. appId", zzfk.zza((String)var24_16), (Object)var23_17.zzj.zzj().zzc(var31_26 /* !! */ .zzc), var31_26 /* !! */ .zze);
                                    var23_17.zzj.zzi().zza(var24_16, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zze().b_();
                            return;
                        }
                    }
                    var9_35 = zzla.zza((String)var1_1.zza);
                    var10_36 = "_err".equals(var1_1.zza);
                    var11_37 = 1L;
                    if (zzjp.zzb() && this.zzj.zzb().zze(var2_2.zza, zzap.zzdb)) {
                        this.zzj.zzi();
                        var11_37 = 1L + zzla.zza((zzam)var1_1.zzb);
                    }
                    var13_38 = this.zze().zza(this.zzx(), var5_4, var11_37, true, var9_35, false, var10_36, false);
                    var14_39 = var13_38.zzb - (long)((Integer)zzap.zzj.zza(null)).intValue();
                    if (var14_39 > 0L) {
                        if (var14_39 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many events logged. appId, count", zzfk.zza((String)var5_4), (Object)var13_38.zzb);
                        }
                        this.zze().b_();
                        return;
                    }
                    if (var9_35 && (var14_39 = var13_38.zza - (long)((Integer)zzap.zzl.zza(null)).intValue()) > 0L) {
                        if (var14_39 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many public events logged. appId, count", zzfk.zza((String)var5_4), (Object)var13_38.zza);
                        }
                        this.zzj.zzi().zza(var5_4, 16, "_ev", var1_1.zza, 0);
                        this.zze().b_();
                        return;
                    }
                    if (var10_36) {
                        var24_16 = var2_2.zza;
                        var25_13 = this.zzj.zzb().zzb(var24_16, zzap.zzk);
                        var14_39 = var13_38.zzd - (long)Math.max(0, var25_13 = Math.min(1000000, var25_13));
                        if (var14_39 > 0L) {
                            if (var14_39 == 1L) {
                                this.zzj.zzr().zzf().zza("Too many error events logged. appId, count", zzfk.zza((String)var5_4), (Object)var13_38.zzd);
                            }
                            this.zze().b_();
                            return;
                        }
                    }
                    var16_40 = var1_1.zzb.zzb();
                    this.zzj.zzi().zza(var16_40, "_o", (Object)var1_1.zzc);
                    if (this.zzj.zzi().zzf(var5_4)) {
                        this.zzj.zzi().zza(var16_40, "_dbg", (Object)1L);
                        this.zzj.zzi().zza(var16_40, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && this.zzj.zzb().zze(var2_2.zza, zzap.zzas) && (var17_41 = this.zze().zzc(var2_2.zza, "_sno")) != null && var17_41.zze instanceof Long) {
                        this.zzj.zzi().zza(var16_40, "_sno", var17_41.zze);
                    }
                    if ("_s".equals(var1_1.zza) && this.zzj.zzb().zze(var2_2.zza, zzap.zzaw)) {
                        var24_16 = var2_2;
                        var23_17 = this;
                        if (!var23_17.zzj.zzb().zze(var24_16.zza, zzap.zzas)) {
                            var25_14 = new zzkz("_sno", 0L, null);
                            var23_17.zzb(var25_14, (zzm)var24_16);
                        }
                    }
                    if ((var17_42 = this.zze().zzc(var5_4)) > 0L) {
                        this.zzj.zzr().zzi().zza("Data lost. Too many events stored on disk, deleted. appId", zzfk.zza((String)var5_4), (Object)var17_42);
                    }
                    var19_43 = new zzak(this.zzj, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var16_40);
                    var20_44 = this.zze().zza(var5_4, var19_43.zzb);
                    if (var20_44 == null) {
                        if (this.zze().zzh(var5_4) >= (long)this.zzj.zzb().zza(var5_4) && var9_35) {
                            this.zzj.zzr().zzf().zza("Too many event names used, ignoring event. appId, name, supported count", zzfk.zza((String)var5_4), (Object)this.zzj.zzj().zza(var19_43.zzb), (Object)this.zzj.zzb().zza(var5_4));
                            this.zzj.zzi().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var21_45 = new zzaj(var5_4, var19_43.zzb, 0L, 0L, var19_43.zzc, 0L, null, null, null, null);
                    } else {
                        var19_43 = var19_43.zza(this.zzj, var20_44.zzf);
                        var21_45 = var20_44.zza(var19_43.zzc);
                    }
                    this.zze().zza(var21_45);
                    var25_15 = var2_2;
                    var24_16 = var19_43;
                    var23_17 = this;
                    var23_17.zzw();
                    var23_17.zzk();
                    Preconditions.checkNotNull((Object)var24_16);
                    Preconditions.checkNotNull((Object)var25_15);
                    Preconditions.checkNotEmpty((String)var24_16.zza);
                    Preconditions.checkArgument((boolean)var24_16.zza.equals(var25_15.zza));
                    var26_11 = zzbr.zzg.zzbf().zza(1).zza("android");
                    if (!TextUtils.isEmpty((CharSequence)var25_15.zza)) {
                        var26_11.zzf(var25_15.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var25_15.zzd)) {
                        var26_11.zze(var25_15.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var25_15.zzc)) {
                        var26_11.zzg(var25_15.zzc);
                    }
                    if (var25_15.zzj != -2147483648L) {
                        var26_11.zzh((int)var25_15.zzj);
                    }
                    var26_11.zzf(var25_15.zze);
                    if (!TextUtils.isEmpty((CharSequence)var25_15.zzb)) {
                        var26_11.zzk(var25_15.zzb);
                    }
                    if (zzll.zzb() && var23_17.zzj.zzb().zze(var25_15.zza, zzap.zzch)) {
                        if (TextUtils.isEmpty((CharSequence)var26_11.zzl()) && !TextUtils.isEmpty((CharSequence)var25_15.zzv)) {
                            var26_11.zzp(var25_15.zzv);
                        }
                        if (TextUtils.isEmpty((CharSequence)var26_11.zzl()) && TextUtils.isEmpty((CharSequence)var26_11.zzo()) && !TextUtils.isEmpty((CharSequence)var25_15.zzr)) {
                            var26_11.zzo(var25_15.zzr);
                        }
                    } else if (var23_17.zzj.zzb().zza(zzap.zzbh)) {
                        if (TextUtils.isEmpty((CharSequence)var26_11.zzl()) && !TextUtils.isEmpty((CharSequence)var25_15.zzr)) {
                            var26_11.zzo(var25_15.zzr);
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)var25_15.zzr)) {
                        var26_11.zzo(var25_15.zzr);
                    }
                    if (var25_15.zzf != 0L) {
                        var26_11.zzh(var25_15.zzf);
                    }
                    var26_11.zzk(var25_15.zzt);
                    if (var23_17.zzj.zzb().zze(var25_15.zza, zzap.zzbe) && (var27_18 = var23_17.zzh().zzf()) != null) {
                        var26_11.zzd((Iterable<? extends Integer>)var27_18);
                    }
                    if ((var27_18 = var23_17.zzj.zzc().zza(var25_15.zza)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var27_18.first))) {
                        if (var25_15.zzo) {
                            var26_11.zzh((String)var27_18.first);
                            if (var27_18.second != null) {
                                var26_11.zza((Boolean)var27_18.second);
                            }
                        }
                    } else if (!var23_17.zzj.zzx().zza(var23_17.zzj.zzn()) && var25_15.zzp) {
                        var28_24 = Settings.Secure.getString((ContentResolver)var23_17.zzj.zzn().getContentResolver(), (String)"android_id");
                        if (var28_24 == null) {
                            var23_17.zzj.zzr().zzi().zza("null secure ID. appId", zzfk.zza((String)var26_11.zzj()));
                            var28_24 = "null";
                        } else if (var28_24.isEmpty()) {
                            var23_17.zzj.zzr().zzi().zza("empty secure ID. appId", zzfk.zza((String)var26_11.zzj()));
                        }
                        var26_11.zzm(var28_24);
                    }
                    var23_17.zzj.zzx().zzaa();
                    v3 = var26_11.zzc(Build.MODEL);
                    var23_17.zzj.zzx().zzaa();
                    v3.zzb(Build.VERSION.RELEASE).zzf((int)var23_17.zzj.zzx().zzf()).zzd(var23_17.zzj.zzx().zzg()).zzj(var25_15.zzl);
                    if (var23_17.zzj.zzab()) {
                        var26_11.zzj();
                        if (!TextUtils.isEmpty(null)) {
                            var26_11.zzn(null);
                        }
                    }
                    if ((var28_25 = var23_17.zze().zzb(var25_15.zza)) == null) {
                        var28_25 = new zzg(var23_17.zzj, var25_15.zza);
                        var28_25.zza(var23_17.zzj.zzi().zzk());
                        var28_25.zzf(var25_15.zzk);
                        var28_25.zzb(var25_15.zzb);
                        var28_25.zze(var23_17.zzj.zzc().zzb(var25_15.zza));
                        var28_25.zzg(0L);
                        var28_25.zza(0L);
                        var28_25.zzb(0L);
                        var28_25.zzg(var25_15.zzc);
                        var28_25.zzc(var25_15.zzj);
                        var28_25.zzh(var25_15.zzd);
                        var28_25.zzd(var25_15.zze);
                        var28_25.zze(var25_15.zzf);
                        var28_25.zza(var25_15.zzh);
                        var28_25.zzp(var25_15.zzl);
                        var28_25.zzf(var25_15.zzt);
                        var23_17.zze().zza(var28_25);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var28_25.zzd())) {
                        var26_11.zzi(var28_25.zzd());
                    }
                    if (!TextUtils.isEmpty((CharSequence)var28_25.zzi())) {
                        var26_11.zzl(var28_25.zzi());
                    }
                    var29_46 = var23_17.zze().zza(var25_15.zza);
                    for (var30_21 = 0; var30_21 < var29_46.size(); ++var30_21) {
                        var31_26 /* !! */  = zzbr.zzk.zzj().zza(var29_46.get((int)var30_21).zzc).zza(var29_46.get((int)var30_21).zzd);
                        var23_17.zzh().zza((zzbr.zzk.zza)var31_26 /* !! */ , var29_46.get((int)var30_21).zze);
                        var26_11.zza((zzbr.zzk.zza)var31_26 /* !! */ );
                    }
                    try {
                        var30_22 = var23_17.zze().zza((zzbr.zzg)((zzfd)var26_11.zzu()));
                    }
                    catch (IOException var32_34) {
                        var23_17.zzj.zzr().zzf().zza("Data loss. Failed to insert raw event metadata. appId", zzfk.zza((String)var26_11.zzj()), (Object)var32_34);
                        break block76;
                    }
                    v4 = var23_17.zze();
                    var34_47 = var24_16;
                    var33_48 = var23_17;
                    if (var34_47.zze == null) ** GOTO lbl-1000
                    for (Object var36_49 : var34_47.zze) {
                        if (!"_r".equals(var36_49)) continue;
                        v5 = true;
                        break block77;
                    }
                    var35_28 = var33_48.zzc().zzc(var34_47.zza, var34_47.zzb);
                    var36_49 = var33_48.zze().zza(var33_48.zzx(), var34_47.zza, false, false, false, false, false);
                    if (var35_28 && var36_49.zze < (long)var33_48.zzj.zzb().zzb(var34_47.zza)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzak)var24_16, var30_22, v5)) {
                    var23_17.zzm = 0L;
                }
            }
            this.zze().b_();
            if (!(zzky.zzb() && this.zzj.zzb().zze(var2_2.zza, zzap.zzcz) || !this.zzj.zzr().zza(2))) {
                this.zzj.zzr().zzx().zza("Event recorded", (Object)this.zzj.zzj().zza(var19_43));
            }
        }
        finally {
            this.zze().zzh();
        }
        this.zzz();
        this.zzj.zzr().zzx().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzl() {
        this.zzw();
        this.zzk();
        this.zzs = true;
        try {
            String string;
            long l;
            long l2;
            zzw zzw2 = this.zzj.zzu();
            Boolean bl = this.zzj.zzw().zzag();
            if (bl == null) {
                this.zzj.zzr().zzi().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj.zzr().zzf().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzm > 0L) {
                this.zzz();
                return;
            }
            zzhh zzhh2 = this;
            zzhh2.zzw();
            if (zzhh2.zzv != null) {
                this.zzj.zzr().zzx().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzd().zzf()) {
                this.zzj.zzr().zzx().zza("Network not connected, ignoring upload request");
                this.zzz();
                return;
            }
            long l3 = this.zzj.zzm().currentTimeMillis();
            int n = zzlx.zzb() ? this.zzj.zzb().zzb(null, zzap.zzao) : 1;
            if (n > 1) {
                l2 = l3 - com.google.android.gms.measurement.internal.zzx.zzk();
                for (int i = 0; i < n && this.zza(null, l = l2); ++i) {
                }
            } else {
                l = l3 - com.google.android.gms.measurement.internal.zzx.zzk();
                this.zza(null, l);
            }
            l2 = this.zzj.zzc().zzc.zza();
            if (l2 != 0L) {
                this.zzj.zzr().zzw().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l2));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zze().d_()))) {
                if (this.zzx == -1L) {
                    this.zzx = this.zze().zzaa();
                }
                Object object = string;
                int n2 = this.zzj.zzb().zzb((String)object, zzap.zzf);
                object = string;
                zzhh2 = this.zzj.zzb();
                int n3 = Math.max(0, zzhh2.zzb((String)object, zzap.zzg));
                List<Pair<zzbr.zzg, Long>> list = this.zze().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    String string2 = null;
                    Object object5 = list.iterator();
                    while (object5.hasNext()) {
                        object4 = (zzbr.zzg)((Object)object5.next().first);
                        if (TextUtils.isEmpty((CharSequence)object4.zzad())) continue;
                        string2 = object4.zzad();
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            zzbr.zzg zzg2 = (zzbr.zzg)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) || zzg2.zzad().equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object5 = zzbr.zzf.zzb();
                    int n4 = list.size();
                    object4 = new ArrayList(list.size());
                    boolean bl2 = this.zzj.zzb().zzf(string);
                    for (int i = 0; i < n4; ++i) {
                        object3 = (zzbr.zzg.zza)((zzbr.zzg)((Object)list.get((int)i).first)).zzbm();
                        object4.add((Long)list.get((int)i).second);
                        zzw2 = this.zzj.zzu();
                        ((zzbr.zzg.zza)((Object)object3)).zzg(this.zzj.zzb().zze()).zza(l3).zzb(false);
                        if (!bl2) {
                            ((zzbr.zzg.zza)((Object)object3)).zzn();
                        }
                        if (this.zzj.zzb().zze(string, zzap.zzbg)) {
                            object2 = ((zzbr.zzg)((zzfd)object3.zzu())).zzbi();
                            ((zzbr.zzg.zza)((Object)object3)).zzl(this.zzh().zza((byte[])object2));
                        }
                        ((zzbr.zzf.zza)((Object)object5)).zza((zzbr.zzg.zza)((Object)object3));
                    }
                    String string3 = null;
                    if (this.zzj.zzr().zza(2)) {
                        string3 = this.zzh().zza((zzbr.zzf)((zzfd)object5.zzu()));
                    }
                    this.zzh();
                    object3 = ((zzbr.zzf)((zzfd)object5.zzu())).zzbi();
                    object2 = (String)zzap.zzp.zza(null);
                    try {
                        URL uRL = new URL((String)object2);
                        object = object4;
                        zzhh2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzhh2.zzv != null) {
                            zzhh2.zzj.zzr().zzf().zza("Set uploading progress before finishing the previous upload");
                        } else {
                            zzhh2.zzv = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzj.zzc().zzd.zza(l3);
                        String string4 = "?";
                        if (n4 > 0) {
                            string4 = ((zzbr.zzf.zza)((Object)object5)).zza(0).zzx();
                        }
                        this.zzj.zzr().zzx().zza("Uploading data. app, uncompressed size, data", (Object)string4, (Object)((Object)object3).length, (Object)string3);
                        this.zzr = true;
                        zzku zzku2 = new zzku(this, string);
                        Object object6 = object3;
                        URL uRL2 = uRL;
                        object = string;
                        zzhh2 = this.zzd();
                        zzhh2.zzd();
                        zzhh2.zzak();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)object6);
                        Preconditions.checkNotNull((Object)zzku2);
                        zzhh2.zzq().zzb((Runnable)new zzfs((zzfo)zzhh2, (String)object, uRL2, (byte[])object6, null, zzku2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj.zzr().zzf().zza("Failed to parse upload URL. Not uploading. appId", zzfk.zza((String)string), object2);
                    }
                }
            } else {
                zzg zzg3;
                this.zzx = -1L;
                String string5 = this.zze().zza(l3 - com.google.android.gms.measurement.internal.zzx.zzk());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzg3 = this.zze().zzb(string5)) != null) {
                    this.zza(zzg3);
                }
            }
            return;
        }
        finally {
            this.zzs = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final boolean zza(String string, long l) {
        this.zze().zzf();
        try {
            block160: {
                int n;
                int n2;
                zzaj zzaj2;
                String string2;
                Object object;
                Object object2;
                Object object3;
                zza zza2;
                block158: {
                    zza2 = new zza(null);
                    object3 = zza2;
                    long l2 = this.zzx;
                    long l3 = l;
                    String string3 = null;
                    object2 = this.zze();
                    Preconditions.checkNotNull((Object)object3);
                    object2.zzd();
                    ((zzkp)((Object)object2)).zzak();
                    try (Cursor cursor = null;){
                        String string4;
                        Object object4;
                        Object[] objectArray;
                        object = ((zzac)((Object)object2)).c_();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            object4 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = object.rawQuery(new StringBuilder(148 + String.valueOf(object4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append((String)object4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block158;
                            string3 = cursor.getString(0);
                            string2 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            object4 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = object.rawQuery(new StringBuilder(84 + String.valueOf(object4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append((String)object4).append(" order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block158;
                            string2 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = object.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string3, string2}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzf().zza("Raw event metadata record is missing. appId", zzfk.zza((String)string3));
                            break block158;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            object4 = (zzbr.zzg)((zzfd)zzkw.zza(zzbr.zzg.zzbf(), (byte[])objectArray).zzu());
                        }
                        catch (IOException iOException) {
                            object2.zzr().zzf().zza("Data loss. Failed to merge raw event metadata. appId", zzfk.zza((String)string3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block158;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzr().zzi().zza("Get multiple raw event metadata records, expected one. appId", zzfk.zza((String)string3));
                        }
                        cursor.close();
                        object3.zza((zzbr.zzg)((Object)object4));
                        if (l2 != -1L) {
                            string4 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            zzaj2 = new String[]{string3, string2, String.valueOf(l2)};
                        } else {
                            string4 = "app_id = ? and metadata_fingerprint = ?";
                            zzaj2 = new String[]{string3, string2};
                        }
                        cursor = object.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string4, (String[])zzaj2, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzi().zza("Raw event data disappeared while in transaction. appId", zzfk.zza((String)string3));
                            break block158;
                        }
                        do {
                            zzbr.zzc.zza zza3;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zza3 = zzkw.zza(zzbr.zzc.zzj(), (byte[])objectArray);
                            }
                            catch (IOException iOException) {
                                object2.zzr().zzf().zza("Data loss. Failed to merge raw event. appId", zzfk.zza((String)string3), (Object)iOException);
                                continue;
                            }
                            zza3.zza(cursor.getString(1)).zza(cursor.getLong(2));
                            if (!object3.zza(l4, (zzbr.zzc)((zzfd)zza3.zzu()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzc == null || ((zza)object2).zzc.isEmpty()) break block160;
                boolean bl = false;
                zzbr.zzg.zza zza4 = ((zzbr.zzg.zza)zza2.zza.zzbm()).zzc();
                int n3 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzj.zzb().zze(zza2.zza.zzx(), zzap.zzbb);
                zzbr.zzc.zza zzgq3 = null;
                int n4 = -1;
                zzbr.zzc.zza zza5 = null;
                int n5 = -1;
                for (n2 = 0; n2 < zza2.zzc.size(); ++n2) {
                    boolean bl3;
                    zzbr.zzc.zza zzgq22;
                    block162: {
                        boolean bl4;
                        block161: {
                            boolean bl5;
                            bl4 = bl;
                            zzgq22 = (zzbr.zzc.zza)zza2.zzc.get(n2).zzbm();
                            if (this.zzc().zzb(zza2.zza.zzx(), zzgq22.zzd())) {
                                this.zzj.zzr().zzi().zza("Dropping blacklisted raw event. appId", zzfk.zza((String)zza2.zza.zzx()), (Object)this.zzj.zzj().zza(zzgq22.zzd()));
                                if (this.zzc().zzg(zza2.zza.zzx()) || this.zzc().zzh(zza2.zza.zzx()) || "_err".equals(zzgq22.zzd())) continue;
                                this.zzj.zzi().zza(zza2.zza.zzx(), 11, "_ev", zzgq22.zzd(), 0);
                                continue;
                            }
                            bl3 = this.zzc().zzc(zza2.zza.zzx(), zzgq22.zzd());
                            if (bl3) break block161;
                            this.zzh();
                            object2 = zzgq22.zzd();
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl5 = true;
                                    break;
                                }
                                default: {
                                    bl5 = false;
                                }
                            }
                            if (!bl5) break block162;
                        }
                        boolean l6 = false;
                        boolean bl6 = false;
                        for (int i = 0; i < zzgq22.zzb(); ++i) {
                            zzbr.zze zze2;
                            if ("_c".equals(zzgq22.zza(i).zzb())) {
                                zze2 = (zzbr.zze)((zzfd)((zzbr.zze.zza)zzgq22.zza(i).zzbm()).zza(1L).zzu());
                                l6 = true;
                                zzgq22.zza(i, zze2);
                                continue;
                            }
                            if (!"_r".equals(zzgq22.zza(i).zzb())) continue;
                            zze2 = (zzbr.zze)((zzfd)((zzbr.zze.zza)zzgq22.zza(i).zzbm()).zza(1L).zzu());
                            bl6 = true;
                            zzgq22.zza(i, zze2);
                        }
                        if (!l6 && bl3) {
                            this.zzj.zzr().zzx().zza("Marking event as conversion", (Object)this.zzj.zzj().zza(zzgq22.zzd()));
                            zzgq22.zza(zzbr.zze.zzk().zza("_c").zza(1L));
                        }
                        if (!bl6) {
                            this.zzj.zzr().zzx().zza("Marking event as real-time", (Object)this.zzj.zzj().zza(zzgq22.zzd()));
                            zzgq22.zza(zzbr.zze.zzk().zza("_r").zza(1L));
                        }
                        bl = true;
                        if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zzj.zzb().zzb(zza2.zza.zzx())) {
                            zzks.zza(zzgq22, "_r");
                            bl = bl4;
                        }
                        if (zzla.zza((String)zzgq22.zzd()) && bl3) {
                            String string5 = zza2.zza.zzx();
                            if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zzj.zzb().zzb(string5, zzap.zzm)) {
                                this.zzj.zzr().zzi().zza("Too many conversions. Not logging as conversion. appId", zzfk.zza((String)zza2.zza.zzx()));
                                boolean bl7 = false;
                                zzbr.zze.zza zza3 = null;
                                int n6 = -1;
                                for (int i = 0; i < zzgq22.zzb(); ++i) {
                                    zzbr.zze zze3 = zzgq22.zza(i);
                                    if ("_c".equals(zze3.zzb())) {
                                        zza3 = (zzbr.zze.zza)zze3.zzbm();
                                        n6 = i;
                                        continue;
                                    }
                                    if (!"_err".equals(zze3.zzb())) continue;
                                    bl7 = true;
                                }
                                if (bl7 && zza3 != null) {
                                    int n7 = n6;
                                    zzgq22.zzb(n7);
                                } else if (zza3 != null) {
                                    zzbr.zze zze4 = (zzbr.zze)((zzfd)((zzbr.zze.zza)((zzfd.zzb)zza3.clone())).zza("_err").zza(10L).zzu());
                                    zzgq22.zza(n6, zze4);
                                } else {
                                    this.zzj.zzr().zzf().zza("Did not find conversion parameter. appId", zzfk.zza((String)zza2.zza.zzx()));
                                }
                            }
                        }
                    }
                    if (bl3) {
                        zzbr.zzc.zza zzgq4 = zzgq22;
                        object2 = this;
                        Object object5 = new ArrayList<zzbr.zze>(zzgq4.zza());
                        int i = -1;
                        int n9 = -1;
                        for (n = 0; n < object5.size(); ++n) {
                            if ("value".equals(((zzbr.zze)((Object)object5.get(n))).zzb())) {
                                i = n;
                                continue;
                            }
                            if (!"currency".equals(((zzbr.zze)((Object)object5.get(n))).zzb())) continue;
                            n9 = n;
                        }
                        if (i != -1) {
                            if (!((zzbr.zze)((Object)object5.get(i))).zze() && !((zzbr.zze)((Object)object5.get(i))).zzg()) {
                                ((zzks)object2).zzj.zzr().zzk().zza("Value must be specified with a numeric type.");
                                int n10 = i;
                                zzgq4.zzb(n10);
                                zzks.zza(zzgq4, "_c");
                                zzks.zza(zzgq4, 18, "value");
                            } else {
                                n = 0;
                                if (n9 == -1) {
                                    n = 1;
                                } else {
                                    object3 = ((zzbr.zze)((Object)object5.get(n9))).zzd();
                                    if (((String)object3).length() != 3) {
                                        n = 1;
                                    } else {
                                        int n11;
                                        for (i = 0; i < ((String)object3).length(); i += Character.charCount(n11)) {
                                            n11 = ((String)object3).codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n != 0) {
                                    ((zzks)object2).zzj.zzr().zzk().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    int n12 = i;
                                    zzgq4.zzb(n12);
                                    zzks.zza(zzgq4, "_c");
                                    zzks.zza(zzgq4, 19, "currency");
                                }
                            }
                        }
                    }
                    if (this.zzj.zzb().zze(zza2.zza.zzx(), zzap.zzba)) {
                        if ("_e".equals(zzgq22.zzd())) {
                            this.zzh();
                            if (zzkw.zza((zzbr.zzc)((zzfd)zzgq22.zzu()), "_fr") == null) {
                                if (zza5 != null && Math.abs(zza5.zzf() - zzgq22.zzf()) <= 1000L) {
                                    zzbr.zzc.zza l14 = (zzbr.zzc.zza)((zzfd.zzb)zza5.clone());
                                    if (this.zza(zzgq22, l14)) {
                                        zzgq3 = null;
                                        zza5 = null;
                                        zza4.zza(n5, l14);
                                    } else {
                                        zzgq3 = zzgq22;
                                        n4 = n3;
                                    }
                                } else {
                                    zzgq3 = zzgq22;
                                    n4 = n3;
                                }
                            }
                        } else if ("_vs".equals(zzgq22.zzd())) {
                            this.zzh();
                            if (zzkw.zza((zzbr.zzc)((zzfd)zzgq22.zzu()), "_et") == null) {
                                if (zzgq3 != null && Math.abs(zzgq3.zzf() - zzgq22.zzf()) <= 1000L) {
                                    zzbr.zzc.zza zza6 = (zzbr.zzc.zza)((zzfd.zzb)zzgq3.clone());
                                    if (this.zza(zza6, zzgq22)) {
                                        zzgq3 = null;
                                        zza5 = null;
                                        zza4.zza(n4, zza6);
                                    } else {
                                        zza5 = zzgq22;
                                        n5 = n3;
                                    }
                                } else {
                                    zza5 = zzgq22;
                                    n5 = n3;
                                }
                            }
                        } else if (this.zzj.zzb().zze(zza2.zza.zzx(), zzap.zzcl) && "_ab".equals(zzgq22.zzd())) {
                            this.zzh();
                            if (zzkw.zza((zzbr.zzc)((zzfd)zzgq22.zzu()), "_et") == null && zzgq3 != null && Math.abs(zzgq3.zzf() - zzgq22.zzf()) <= 4000L) {
                                zzbr.zzc.zza zza7 = (zzbr.zzc.zza)((zzfd.zzb)zzgq3.clone());
                                this.zzb(zza7, zzgq22);
                                zzgq3 = null;
                                zza4.zza(n4, zza7);
                            }
                        }
                    }
                    if (!bl2 && "_e".equals(zzgq22.zzd())) {
                        if (zzgq22.zzb() == 0) {
                            this.zzj.zzr().zzi().zza("Engagement event does not contain any parameters. appId", zzfk.zza((String)zza2.zza.zzx()));
                        } else {
                            Long l2 = (Long)this.zzh().zzb((zzbr.zzc)((zzfd)zzgq22.zzu()), "_et");
                            if (l2 == null) {
                                this.zzj.zzr().zzi().zza("Engagement event does not include duration. appId", zzfk.zza((String)zza2.zza.zzx()));
                            } else {
                                l5 += l2.longValue();
                            }
                        }
                    }
                    zza2.zzc.set(n2, (zzbr.zzc)((zzfd)zzgq22.zzu()));
                    ++n3;
                    zza4.zza(zzgq22);
                }
                if (bl2) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        Long l3;
                        zzbr.zzc zzc2 = zza4.zzb(n2);
                        if ("_e".equals(zzc2.zzc())) {
                            this.zzh();
                            if (zzkw.zza(zzc2, "_fr") != null) {
                                zza4.zzc(n2);
                                --n3;
                                --n2;
                                continue;
                            }
                        }
                        this.zzh();
                        zzbr.zze l13 = zzkw.zza(zzc2, "_et");
                        if (l13 == null || (l3 = l13.zze() ? Long.valueOf(l13.zzf()) : null) == null || l3 <= 0L) continue;
                        l5 += l3.longValue();
                    }
                }
                this.zza(zza4, l5, false);
                if (this.zzj.zzb().zze(zza4.zzj(), zzap.zzbo)) {
                    n2 = 0;
                    for (zzbr.zzc zzc2 : zza4.zza()) {
                        if (!"_s".equals(zzc2.zzc())) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) {
                        this.zze().zzb(zza4.zzj(), "_se");
                    }
                    if (zzmv.zzb() && this.zzj.zzb().zze(zza4.zzj(), zzap.zzbp) && !(zzkw.zza(zza4, "_sid") >= 0)) {
                        int n7 = zzkw.zza(zza4, "_se");
                        if (n7 >= 0) {
                            zza4.zze(n7);
                            if (zzky.zzb() && this.zzj.zzb().zze(zza2.zza.zzx(), zzap.zzcz)) {
                                this.zzj.zzr().zzf().zza("Session engagement user property is in the bundle without session ID. appId", zzfk.zza((String)zza2.zza.zzx()));
                            } else {
                                this.zzj.zzr().zzi().zza("Session engagement user property is in the bundle without session ID. appId", zzfk.zza((String)zza2.zza.zzx()));
                            }
                        }
                    } else {
                        this.zza(zza4, l5, true);
                    }
                } else if (this.zzj.zzb().zze(zza4.zzj(), zzap.zzbr)) {
                    this.zze().zzb(zza4.zzj(), "_se");
                }
                if (this.zzj.zzb().zze(zza4.zzj(), zzap.zzbc)) {
                    zzg zzg2;
                    zzbr.zzg.zza zza10 = zza4;
                    object2 = this.zzh();
                    object2.zzr().zzx().zza("Checking account type status for ad personalization signals");
                    if (((zzkq)((Object)object2)).zzj().zze(zza10.zzj()) && (zzg2 = ((zzkq)((Object)object2)).zzi().zzb(zza10.zzj())) != null && zzg2.zzaf() && object2.zzl().zzj()) {
                        object2.zzr().zzw().zza("Turning off ad personalization due to account type");
                        zzbr.zzk sQLiteException = (zzbr.zzk)((zzfd)zzbr.zzk.zzj().zza("_npa").zza(object2.zzl().zzh()).zzb(1L).zzu());
                        boolean bl9 = false;
                        for (n = 0; n < zza10.zze(); ++n) {
                            if (!"_npa".equals(zza10.zzd(n).zzc())) continue;
                            zza10.zza(n, sQLiteException);
                            bl9 = true;
                            break;
                        }
                        if (!bl9) {
                            zza10.zza(sQLiteException);
                        }
                    }
                }
                if (this.zzj.zzb().zze(zza4.zzj(), zzap.zzcg)) {
                    zzks.zza(zza4);
                }
                zza4.zzm().zzc(this.zzf().zza(zza4.zzj(), zza4.zza(), zza4.zzd(), zza4.zzf(), zza4.zzg()));
                if (this.zzj.zzb().zzg(zza2.zza.zzx())) {
                    zza zza11 = zza2;
                    zzbr.zzg.zza zza12 = zza4;
                    object2 = this;
                    HashMap<Object, String> hashMap = new HashMap<Object, String>();
                    ArrayList<zzbr.zzc> arrayList = new ArrayList<zzbr.zzc>();
                    SecureRandom secureRandom = ((zzks)object2).zzj.zzi().zzh();
                    for (int i = 0; i < zza12.zzb(); ++i) {
                        Long l8;
                        boolean bl8;
                        int n14;
                        long l9;
                        long l10;
                        zzbr.zzc.zza zza13;
                        block159: {
                            zza13 = (zzbr.zzc.zza)zza12.zzb(i).zzbm();
                            if (zza13.zzd().equals("_ep")) {
                                object = (String)((zzks)object2).zzh().zzb((zzbr.zzc)((zzfd)zza13.zzu()), "_en");
                                string2 = (zzaj)hashMap.get(object);
                                if (string2 == null) {
                                    string2 = ((zzks)object2).zze().zza(zza11.zza.zzx(), (String)object);
                                    hashMap.put(object, string2);
                                }
                                if (((zzaj)string2).zzi == null) {
                                    if (((zzaj)string2).zzj > 1L) {
                                        ((zzks)object2).zzh().zza(zza13, "_sr", ((zzaj)string2).zzj);
                                    }
                                    if (((zzaj)string2).zzk != null && ((zzaj)string2).zzk.booleanValue()) {
                                        ((zzks)object2).zzh().zza(zza13, "_efs", 1L);
                                    }
                                    arrayList.add((zzbr.zzc)((zzfd)zza13.zzu()));
                                }
                                zza12.zza(i, zza13);
                                continue;
                            }
                            l10 = ((zzks)object2).zzc().zzf(zza11.zza.zzx());
                            ((zzks)object2).zzj.zzi();
                            l9 = zzla.zza((long)zza13.zzf(), (long)l10);
                            n14 = 1;
                            Long l4 = 1L;
                            String string3 = "_dbg";
                            zzbr.zzc zzc3 = (zzbr.zzc)((zzfd)zza13.zzu());
                            if (TextUtils.isEmpty((CharSequence)string3) || l4 == null) {
                                bl8 = false;
                            } else {
                                for (zzbr.zze zze5 : zzc3.zza()) {
                                    if (!string3.equals(zze5.zzb())) continue;
                                    bl8 = l4 instanceof Long && ((Object)l4).equals(zze5.zzf()) || l4 instanceof String && ((Object)l4).equals(zze5.zzd()) || l4 instanceof Double && ((Object)l4).equals(zze5.zzh());
                                    break block159;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n14 = ((zzks)object2).zzc().zzd(zza11.zza.zzx(), zza13.zzd());
                        }
                        if (n14 <= 0) {
                            ((zzks)object2).zzj.zzr().zzi().zza("Sample rate must be positive. event, rate", (Object)zza13.zzd(), (Object)n14);
                            arrayList.add((zzbr.zzc)((zzfd)zza13.zzu()));
                            zza12.zza(i, zza13);
                            continue;
                        }
                        zzaj2 = (zzaj)hashMap.get(zza13.zzd());
                        if (zzaj2 == null && (zzaj2 = ((zzks)object2).zze().zza(zza11.zza.zzx(), zza13.zzd())) == null) {
                            ((zzks)object2).zzj.zzr().zzi().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)zza11.zza.zzx(), (Object)zza13.zzd());
                            zzaj2 = ((zzks)object2).zzj.zzb().zze(zza11.zza.zzx(), zzap.zzbn) ? new zzaj(zza11.zza.zzx(), zza13.zzd(), 1L, 1L, 1L, zza13.zzf(), 0L, null, null, null, null) : new zzaj(zza11.zza.zzx(), zza13.zzd(), 1L, 1L, zza13.zzf(), 0L, null, null, null, null);
                        }
                        Boolean bl9 = (l8 = (Long)((zzks)object2).zzh().zzb((zzbr.zzc)((zzfd)zza13.zzu()), "_eid")) != null;
                        if (n14 == 1) {
                            arrayList.add((zzbr.zzc)((zzfd)zza13.zzu()));
                            if (bl9.booleanValue() && (zzaj2.zzi != null || zzaj2.zzj != null || zzaj2.zzk != null)) {
                                zzaj2 = zzaj2.zza(null, null, null);
                                hashMap.put(zza13.zzd(), (String)zzaj2);
                            }
                            zza12.zza(i, zza13);
                            continue;
                        }
                        if (secureRandom.nextInt(n14) == 0) {
                            ((zzks)object2).zzh().zza(zza13, "_sr", n14);
                            arrayList.add((zzbr.zzc)((zzfd)zza13.zzu()));
                            if (bl9.booleanValue()) {
                                zzaj2 = zzaj2.zza(null, Long.valueOf(n14), null);
                            }
                            hashMap.put(zza13.zzd(), (String)zzaj2.zza(zza13.zzf(), l9));
                        } else {
                            long l12;
                            if (zzaj2.zzh != null) {
                                l12 = zzaj2.zzh;
                            } else {
                                ((zzks)object2).zzj.zzi();
                                l12 = zzla.zza((long)zza13.zzg(), (long)l10);
                            }
                            if (l12 != l9) {
                                ((zzks)object2).zzh().zza(zza13, "_efs", 1L);
                                ((zzks)object2).zzh().zza(zza13, "_sr", n14);
                                arrayList.add((zzbr.zzc)((zzfd)zza13.zzu()));
                                if (bl9.booleanValue()) {
                                    zzaj2 = zzaj2.zza(null, Long.valueOf(n14), Boolean.valueOf(true));
                                }
                                hashMap.put(zza13.zzd(), (String)zzaj2.zza(zza13.zzf(), l9));
                            } else if (bl9.booleanValue()) {
                                hashMap.put(zza13.zzd(), (String)zzaj2.zza(l8, null, null));
                            }
                        }
                        zza12.zza(i, zza13);
                    }
                    if (arrayList.size() < zza12.zzb()) {
                        zza12.zzc().zza(arrayList);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ((zzks)object2).zze().zza((zzaj)entry.getValue());
                    }
                }
                if (!this.zzj.zzb().zze(zza4.zzj(), zzap.zzcg)) {
                    zzks.zza(zza4);
                }
                String string7 = zza2.zza.zzx();
                zzg zzg3 = this.zze().zzb(string7);
                if (zzg3 == null) {
                    this.zzj.zzr().zzf().zza("Bundling raw events w/o app info. appId", zzfk.zza((String)zza2.zza.zzx()));
                } else if (zza4.zzb() > 0) {
                    long l6 = zzg3.zzk();
                    if (l6 != 0L) {
                        zza4.zze(l6);
                    } else {
                        zza4.zzi();
                    }
                    long l7 = zzg3.zzj();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    if (l7 != 0L) {
                        zza4.zzd(l7);
                    } else {
                        zza4.zzh();
                    }
                    zzg3.zzv();
                    zza4.zzg((int)zzg3.zzs());
                    zzg3.zza(zza4.zzf());
                    zzg3.zzb(zza4.zzg());
                    String string4 = zzg3.zzad();
                    if (string4 != null) {
                        zza4.zzj(string4);
                    } else {
                        zza4.zzk();
                    }
                    this.zze().zza(zzg3);
                }
                if (zza4.zzb() > 0) {
                    zzw zzw2 = this.zzj.zzu();
                    zzbo.zzb zzb2 = this.zzc().zza(zza2.zza.zzx());
                    if (zzb2 == null || !zzb2.zza()) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zza.zzam())) {
                            zza4.zzi(-1L);
                        } else {
                            this.zzj.zzr().zzi().zza("Did not find measurement config or missing version info. appId", zzfk.zza((String)zza2.zza.zzx()));
                        }
                    } else {
                        zza4.zzi(zzb2.zzb());
                    }
                    this.zze().zza((zzbr.zzg)((zzfd)zza4.zzu()), bl);
                }
                Object object6 = zza2.zzb;
                object2 = this.zze();
                Preconditions.checkNotNull(object6);
                object2.zzd();
                ((zzkp)((Object)object2)).zzak();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int i = 0; i < object6.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(object6.get(i));
                }
                stringBuilder.append(")");
                int n15 = ((zzac)((Object)object2)).c_().delete("raw_events", stringBuilder.toString(), null);
                if (n15 != object6.size()) {
                    object2.zzr().zzf().zza("Deleted fewer rows from raw events table than expected", (Object)n15, (Object)object6.size());
                }
                object6 = string7;
                object2 = this.zze();
                stringBuilder = ((zzac)((Object)object2)).c_();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object6, object6});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzr().zzf().zza("Failed to remove unused event metadata. appId", zzfk.zza((String)object6), (Object)sQLiteException);
                }
                this.zze().b_();
                return true;
            }
            this.zze().b_();
            return false;
        }
        finally {
            this.zze().zzh();
        }
    }

    private static void zza(zzbr.zzg.zza zza2) {
        zza2.zzb(Long.MAX_VALUE).zzc(Long.MIN_VALUE);
        for (int i = 0; i < zza2.zzb(); ++i) {
            zzbr.zzc zzc2 = zza2.zzb(i);
            if (zzc2.zze() < zza2.zzf()) {
                zza2.zzb(zzc2.zze());
            }
            if (zzc2.zze() <= zza2.zzg()) continue;
            zza2.zzc(zzc2.zze());
        }
    }

    @VisibleForTesting
    private final void zza(zzbr.zzg.zza zza2, long l, boolean bl) {
        zzlb zzlb2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzlb2 = (zzlb2 = this.zze().zzc(zza2.zzj(), string)) == null || zzlb2.zze == null ? new zzlb(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)l) : new zzlb(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)((Long)zzlb2.zze + l));
        zzbr.zzk zzk2 = (zzbr.zzk)((zzfd)zzbr.zzk.zzj().zza(string).zza(this.zzj.zzm().currentTimeMillis()).zzb((Long)zzlb2.zze).zzu());
        boolean bl2 = false;
        int n = zzkw.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzk2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzk2);
        }
        if (l > 0L) {
            this.zze().zza(zzlb2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            if (zzky.zzb() && this.zzj.zzb().zze(zza2.zzj(), zzap.zzcz)) {
                this.zzj.zzr().zzx().zza("Updated engagement user property. scope, value", (Object)string2, zzlb2.zze);
                return;
            }
            this.zzj.zzr().zzw().zza("Updated engagement user property. scope, value", (Object)string2, zzlb2.zze);
        }
    }

    private final boolean zza(zzbr.zzc.zza zza2, zzbr.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzd()));
        this.zzh();
        zzbr.zze zze2 = zzkw.zza((zzbr.zzc)((zzfd)zza2.zzu()), "_sc");
        String string = zze2 == null ? null : zze2.zzd();
        this.zzh();
        zzbr.zze zze3 = zzkw.zza((zzbr.zzc)((zzfd)zza3.zzu()), "_pc");
        String string2 = zze3 == null ? null : zze3.zzd();
        if (string2 != null && string2.equals(string)) {
            this.zzb(zza2, zza3);
            return true;
        }
        return false;
    }

    private final void zzb(zzbr.zzc.zza zza2, zzbr.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzd()));
        this.zzh();
        zzbr.zze zze2 = zzkw.zza((zzbr.zzc)((zzfd)zza2.zzu()), "_et");
        if (!zze2.zze() || zze2.zzf() <= 0L) {
            return;
        }
        long l = zze2.zzf();
        this.zzh();
        zze2 = zzkw.zza((zzbr.zzc)((zzfd)zza3.zzu()), "_et");
        if (zze2 != null && zze2.zzf() > 0L) {
            l += zze2.zzf();
        }
        this.zzh().zza(zza3, "_et", l);
        this.zzh().zza(zza2, "_fr", 1L);
    }

    @VisibleForTesting
    private static void zza(zzbr.zzc.zza zza2, @NonNull String string) {
        List<zzbr.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzb())) continue;
            int n = i;
            zza2.zzb(n);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzbr.zzc.zza zza2, int n, String string) {
        List<zzbr.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzb())) continue;
            return;
        }
        zzbr.zze zze2 = (zzbr.zze)((zzfd)zzbr.zze.zzk().zza("_err").zza(n).zzu());
        zzbr.zze zze3 = (zzbr.zze)((zzfd)zzbr.zze.zzk().zza("_ev").zzb(string).zzu());
        zza2.zza(zze2).zza(zze3);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzw();
        this.zzk();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzv;
            this.zzv = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
                    this.zzj.zzc().zzd.zza(0L);
                    this.zzz();
                    this.zzj.zzr().zzx().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zze().zzf();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzac zzac2 = this.zze();
                                zzac2.zzd();
                                zzac2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzac2.c_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzac2.zzr().zzf().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzw != null && this.zzw.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zze().b_();
                    }
                    finally {
                        this.zze().zzh();
                    }
                    this.zzw = null;
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzx = -1L;
                        this.zzz();
                    }
                    this.zzm = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj.zzr().zzf().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzm = this.zzj.zzm().elapsedRealtime();
                    this.zzj.zzr().zzx().zza("Disable upload, time", (Object)this.zzm);
                }
            } else {
                this.zzj.zzr().zzx().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                }
                this.zze().zza(list);
                this.zzz();
            }
            return;
        }
        finally {
            this.zzr = false;
            this.zzaa();
        }
    }

    private final boolean zzy() {
        this.zzw();
        this.zzk();
        return this.zze().zzy() || !TextUtils.isEmpty((CharSequence)this.zze().d_());
    }

    @WorkerThread
    private final void zza(zzg zzg2) {
        this.zzw();
        if (zzll.zzb() && this.zzj.zzb().zze(zzg2.zzc(), zzap.zzch)) {
            if (TextUtils.isEmpty((CharSequence)zzg2.zze()) && TextUtils.isEmpty((CharSequence)zzg2.zzg()) && TextUtils.isEmpty((CharSequence)zzg2.zzf())) {
                this.zza(zzg2.zzc(), 204, null, null, null);
                return;
            }
        } else if (TextUtils.isEmpty((CharSequence)zzg2.zze()) && TextUtils.isEmpty((CharSequence)zzg2.zzf())) {
            this.zza(zzg2.zzc(), 204, null, null, null);
            return;
        }
        String string = this.zzj.zzb().zza(zzg2);
        try {
            URL uRL = new URL(string);
            this.zzj.zzr().zzx().zza("Fetching remote configuration", (Object)zzg2.zzc());
            zzbo.zzb zzb2 = this.zzc().zza(zzg2.zzc());
            ArrayMap arrayMap = null;
            String string2 = this.zzc().zzb(zzg2.zzc());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            this.zzq = true;
            zzkt zzkt2 = new zzkt(this);
            ArrayMap arrayMap2 = arrayMap;
            URL uRL2 = uRL;
            String string3 = zzg2.zzc();
            zzfo zzfo2 = this.zzd();
            zzfo2.zzd();
            zzfo2.zzak();
            Preconditions.checkNotNull((Object)uRL2);
            Preconditions.checkNotNull((Object)zzkt2);
            zzfo2.zzq().zzb((Runnable)new zzfs(zzfo2, string3, uRL2, null, (Map)arrayMap2, zzkt2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj.zzr().zzf().zza("Failed to parse config URL. Not fetching. appId", zzfk.zza((String)zzg2.zzc()), (Object)string);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj.zzr().zzx().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zze().zzf();
            try {
                boolean bl;
                zzg zzg2 = this.zze().zzb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzj.zzr().zzi().zza("App does not exist in onConfigFetched. appId", zzfk.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzc().zza(string) == null && !this.zzc().zza(string, null, null) : !this.zzc().zza(string, byArray, string2)) {
                        return;
                    }
                    zzg2.zzh(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzg2);
                    if (n == 404) {
                        this.zzj.zzr().zzk().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj.zzr().zzx().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzz();
                    }
                } else {
                    zzg2.zzi(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzg2);
                    this.zzj.zzr().zzx().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzc().zzc(string);
                    this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                    }
                    this.zzz();
                }
                this.zze().b_();
            }
            finally {
                this.zze().zzh();
            }
            return;
        }
        finally {
            this.zzq = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final void zzz() {
        long l;
        long l2;
        long l3;
        block14: {
            String string;
            this.zzw();
            this.zzk();
            if (this.zzm > 0L) {
                l3 = this.zzj.zzm().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzm);
                if (l2 > 0L) {
                    this.zzj.zzr().zzx().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzt().zzb();
                    this.zzv().zzf();
                    return;
                }
                this.zzm = 0L;
            }
            if (!this.zzj.zzah() || !this.zzy()) {
                this.zzj.zzr().zzx().zza("Nothing to upload or uploading impossible");
                this.zzt().zzb();
                this.zzv().zzf();
                return;
            }
            zzks zzks2 = this;
            long l4 = zzks2.zzj.zzm().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzap.zzz.zza(null));
            boolean bl = zzks2.zze().zzz() || zzks2.zze().zzk();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzks2.zzj.zzb().zzv())) && !".none.".equals(string) ? Math.max(0L, (Long)zzap.zzu.zza(null)) : Math.max(0L, (Long)zzap.zzt.zza(null))) : Math.max(0L, (Long)zzap.zzs.zza(null));
            long l7 = zzks2.zzj.zzc().zzc.zza();
            long l8 = zzks2.zzj.zzc().zzd.zza();
            long l9 = zzks2.zze().zzw();
            long l10 = zzks2.zze().zzx();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzks2.zzh().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzap.zzab.zza(null))); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzap.zzaa.zza(null)) * l15) <= l8) continue;
                        l = l14;
                        break block14;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj.zzr().zzx().zza("Next upload time is 0");
            this.zzt().zzb();
            this.zzv().zzf();
            return;
        }
        if (!this.zzd().zzf()) {
            this.zzj.zzr().zzx().zza("No network");
            this.zzt().zza();
            this.zzv().zzf();
            return;
        }
        l2 = this.zzj.zzc().zze.zza();
        long l16 = Math.max(0L, (Long)zzap.zzq.zza(null));
        if (!this.zzh().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzt().zzb();
        long l17 = l3 - this.zzj.zzm().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzap.zzv.zza(null));
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzj.zzr().zzx().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzv().zza(l17);
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzw();
        if (this.zzn == null) {
            this.zzn = new ArrayList<Runnable>();
        }
        this.zzn.add(runnable);
    }

    @WorkerThread
    private final void zzaa() {
        this.zzw();
        if (this.zzq || this.zzr || this.zzs) {
            this.zzj.zzr().zzx().zza("Not stopping services. fetch, network, upload", (Object)this.zzq, (Object)this.zzr, (Object)this.zzs);
            return;
        }
        this.zzj.zzr().zzx().zza("Stopping uploading service(s)");
        if (this.zzn == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzn.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzn.clear();
    }

    @WorkerThread
    private final Boolean zzb(zzg zzg2) {
        try {
            if (zzg2.zzm() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzg2.zzc(), (int)0).versionCode;
                if (zzg2.zzm() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzg2.zzc(), (int)0).versionName;
                if (zzg2.zzl() != null && zzg2.zzl().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @WorkerThread
    final void zzo() {
        int n;
        this.zzw();
        this.zzk();
        if (this.zzl) return;
        this.zzl = true;
        if (!this.zzab()) return;
        int n2 = this.zza(this.zzu);
        int n3 = n = this.zzj.zzy().zzaf();
        int n4 = n2;
        zzks zzks2 = this;
        zzks2.zzw();
        if (n4 > n3) {
            zzks2.zzj.zzr().zzf().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzks2.zza(n3, zzks2.zzu)) {
            zzks2.zzj.zzr().zzf().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzks2.zzj.zzr().zzx().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzab() {
        this.zzw();
        if (this.zzj.zzb().zza(zzap.zzcf) && this.zzt != null && this.zzt.isValid()) {
            this.zzj.zzr().zzx().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzj.zzn().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzu = new RandomAccessFile(file2, "rw").getChannel();
            this.zzt = this.zzu.tryLock();
            if (this.zzt != null) {
                this.zzj.zzr().zzx().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj.zzr().zzf().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj.zzr().zzf().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj.zzr().zzi().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj.zzr().zzi().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            if (this.zzj.zzb().zza(zzap.zzcu) && Build.VERSION.SDK_INT <= 19) {
                fileChannel.position(0L);
            }
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj.zzr().zzf().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(zzm zzm2) {
        if (this.zzv != null) {
            this.zzw = new ArrayList<Long>();
            this.zzw.addAll(this.zzv);
        }
        String string = zzm2.zza;
        zzac zzac2 = this.zze();
        Preconditions.checkNotEmpty((String)string);
        zzac2.zzd();
        zzac2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzac2.c_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzac2.zzr().zzx().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzac2.zzr().zzf().zza("Error resetting analytics data. appId, error", zzfk.zza((String)string), (Object)sQLiteException);
        }
        if (zzkn.zzb() && this.zzj.zzb().zza(zzap.zzcm)) {
            if (zzm2.zzh) {
                this.zzb(zzm2);
                return;
            }
        } else {
            zzm zzm3 = this.zza(this.zzj.zzn(), zzm2.zza, zzm2.zzb, zzm2.zzh, zzm2.zzo, zzm2.zzp, zzm2.zzm, zzm2.zzr, zzm2.zzv);
            if (zzm2.zzh) {
                this.zzb(zzm3);
            }
        }
    }

    private final zzm zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, String string3, String string4) {
        String string5 = "Unknown";
        String string6 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string7 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzj.zzr().zzf().zza("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string5 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzj.zzr().zzf().zza("Error retrieving installer package name. appId", zzfk.zza((String)string));
        }
        if (string5 == null) {
            string5 = "manual_install";
        } else if ("com.android.vending".equals(string5)) {
            string5 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string7 = charSequence.toString();
                }
                string6 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzj.zzr().zzf().zza("Error retrieving newly installed package info. appId, appName", zzfk.zza((String)string), (Object)string7);
            return null;
        }
        return new zzm(string, string2, string6, (long)n, string5, this.zzj.zzb().zze(), this.zzj.zzi().zza(context, string), null, bl, false, "", 0L, l, 0, bl2, bl3, false, string3, null, 0L, null, zzll.zzb() && this.zzj.zzb().zze(string, zzap.zzch) ? string4 : null);
    }

    @WorkerThread
    final void zza(zzkz zzkz2, zzm zzm2) {
        this.zzw();
        this.zzk();
        if (!this.zze(zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        int n = this.zzj.zzi().zzc(zzkz2.zza);
        if (n != 0) {
            this.zzj.zzi();
            String string = zzla.zza((String)zzkz2.zza, (int)24, (boolean)true);
            int n2 = zzkz2.zza != null ? zzkz2.zza.length() : 0;
            this.zzj.zzi().zza(zzm2.zza, n, "_ev", string, n2);
            return;
        }
        n = this.zzj.zzi().zzb(zzkz2.zza, zzkz2.zza());
        if (n != 0) {
            this.zzj.zzi();
            String string = zzla.zza((String)zzkz2.zza, (int)24, (boolean)true);
            Object object = zzkz2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzj.zzi().zza(zzm2.zza, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzj.zzi().zzc(zzkz2.zza, zzkz2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzkz2.zza) && this.zzj.zzb().zze(zzm2.zza, zzap.zzas)) {
            zzaj zzaj2;
            zzm zzm3 = zzm2;
            String string = zzkz2.zze;
            long l = zzkz2.zzb;
            zzks zzks2 = this;
            long l2 = 0L;
            zzlb zzlb2 = zzks2.zze().zzc(zzm3.zza, "_sno");
            if (zzlb2 != null && zzlb2.zze instanceof Long) {
                l2 = (Long)zzlb2.zze;
            } else {
                if (zzlb2 != null) {
                    zzks2.zzj.zzr().zzi().zza("Retrieved last session number from database does not contain a valid (long) value", zzlb2.zze);
                }
                if (zzks2.zzj.zzb().zze(zzm3.zza, zzap.zzav) && (zzaj2 = zzks2.zze().zza(zzm3.zza, "_s")) != null) {
                    l2 = zzaj2.zzc;
                    zzks2.zzj.zzr().zzx().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzaj2 = new zzkz("_sno", l, (Object)(++l2), string);
            zzks2.zza((zzkz)zzaj2, zzm3);
        }
        zzlb zzlb3 = new zzlb(zzm2.zza, zzkz2.zze, zzkz2.zza, zzkz2.zzb, object);
        if (zzky.zzb() && this.zzj.zzb().zze(zzm2.zza, zzap.zzcz)) {
            this.zzj.zzr().zzx().zza("Setting user property", (Object)this.zzj.zzj().zzc(zzlb3.zzc), object);
        } else {
            this.zzj.zzr().zzw().zza("Setting user property", (Object)this.zzj.zzj().zzc(zzlb3.zzc), object);
        }
        this.zze().zzf();
        try {
            this.zzc(zzm2);
            boolean bl = this.zze().zza(zzlb3);
            this.zze().b_();
            if (bl) {
                if (!zzky.zzb() || !this.zzj.zzb().zze(zzm2.zza, zzap.zzcz)) {
                    this.zzj.zzr().zzw().zza("User property set", (Object)this.zzj.zzj().zzc(zzlb3.zzc), zzlb3.zze);
                }
            } else {
                this.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzj.zzj().zzc(zzlb3.zzc), zzlb3.zze);
                this.zzj.zzi().zza(zzm2.zza, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzkz zzkz2, zzm zzm2) {
        this.zzw();
        this.zzk();
        if (!this.zze(zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        if (this.zzj.zzb().zze(zzm2.zza, zzap.zzbc)) {
            if ("_npa".equals(zzkz2.zza) && zzm2.zzs != null) {
                this.zzj.zzr().zzw().zza("Falling back to manifest metadata value for ad personalization");
                zzkz zzkz3 = new zzkz("_npa", this.zzj.zzm().currentTimeMillis(), (Object)(zzm2.zzs != false ? 1L : 0L), "auto");
                this.zza(zzkz3, zzm2);
                return;
            }
            this.zzj.zzr().zzw().zza("Removing user property", (Object)this.zzj.zzj().zzc(zzkz2.zza));
            this.zze().zzf();
            try {
                this.zzc(zzm2);
                this.zze().zzb(zzm2.zza, zzkz2.zza);
                this.zze().b_();
                this.zzj.zzr().zzw().zza("User property removed", (Object)this.zzj.zzj().zzc(zzkz2.zza));
                return;
            }
            finally {
                this.zze().zzh();
            }
        }
        this.zzj.zzr().zzw().zza("Removing user property", (Object)this.zzj.zzj().zzc(zzkz2.zza));
        this.zze().zzf();
        try {
            this.zzc(zzm2);
            this.zze().zzb(zzm2.zza, zzkz2.zza);
            this.zze().b_();
            this.zzj.zzr().zzw().zza("User property removed", (Object)this.zzj.zzj().zzc(zzkz2.zza));
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    final void zza(zzkp zzkp2) {
        ++this.zzo;
    }

    final void zzp() {
        ++this.zzp;
    }

    final zzgo zzs() {
        return this.zzj;
    }

    @WorkerThread
    final void zzb(zzm zzm2) {
        int n;
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        if (!this.zze(zzm2)) {
            return;
        }
        zzg zzg2 = this.zze().zzb(zzm2.zza);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.zze()) && !TextUtils.isEmpty((CharSequence)zzm2.zzb)) {
            zzg2.zzh(0L);
            this.zze().zza(zzg2);
            this.zzc().zzd(zzm2.zza);
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        long l = zzm2.zzm;
        if (l == 0L) {
            l = this.zzj.zzm().currentTimeMillis();
        }
        if (this.zzj.zzb().zze(zzm2.zza, zzap.zzbc)) {
            this.zzj.zzx().zzi();
        }
        if ((n = zzm2.zzn) != 0 && n != 1) {
            this.zzj.zzr().zzi().zza("Incorrect app type, assuming installed app. appId, appType", zzfk.zza((String)zzm2.zza), (Object)n);
            n = 0;
        }
        this.zze().zzf();
        try {
            zzlb zzlb2;
            if (this.zzj.zzb().zze(zzm2.zza, zzap.zzbc) && ((zzlb2 = this.zze().zzc(zzm2.zza, "_npa")) == null || "auto".equals(zzlb2.zzb))) {
                zzkz zzkz2;
                if (zzm2.zzs != null) {
                    zzkz2 = new zzkz("_npa", l, (Object)(zzm2.zzs != false ? 1L : 0L), "auto");
                    if (zzlb2 == null || !zzlb2.zze.equals(zzkz2.zzc)) {
                        this.zza(zzkz2, zzm2);
                    }
                } else if (zzlb2 != null) {
                    zzkz2 = new zzkz("_npa", l, null, "auto");
                    this.zzb(zzkz2, zzm2);
                }
            }
            long l2 = l;
            zzm zzm3 = zzm2;
            zzks zzks2 = this;
            zzg zzg3 = zzks2.zze().zzb(zzm3.zza);
            if (zzg3 != null) {
                zzks2.zzj.zzi();
                if (zzla.zza((String)zzm3.zzb, (String)zzg3.zze(), (String)zzm3.zzr, (String)zzg3.zzf())) {
                    zzks2.zzj.zzr().zzi().zza("New GMP App Id passed in. Removing cached database data. appId", zzfk.zza((String)zzg3.zzc()));
                    String string = zzg3.zzc();
                    zzac zzac2 = zzks2.zze();
                    zzac2.zzak();
                    zzac2.zzd();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzac2.c_();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzac2.zzr().zzx().zza("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzac2.zzr().zzf().zza("Error deleting application data. appId, error", zzfk.zza((String)string), (Object)sQLiteException);
                    }
                    zzg3 = null;
                }
            }
            if (zzg3 != null && (zzg3.zzm() != Integer.MIN_VALUE && zzg3.zzm() != zzm3.zzj) | (zzg3.zzm() == Integer.MIN_VALUE && zzg3.zzl() != null && !zzg3.zzl().equals(zzm3.zzc))) {
                Bundle bundle = new Bundle();
                bundle.putString("_pv", zzg3.zzl());
                zzan zzan2 = new zzan("_au", new zzam(bundle), "auto", l2);
                zzks2.zza(zzan2, zzm3);
            }
            this.zzc(zzm2);
            zzlb2 = null;
            if (n == 0) {
                zzlb2 = this.zze().zza(zzm2.zza, "_f");
            } else if (n == 1) {
                zzlb2 = this.zze().zza(zzm2.zza, "_v");
            }
            if (zzlb2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    PackageInfo packageInfo;
                    zzkz zzkz3 = new zzkz("_fot", l, (Object)l3, "auto");
                    this.zza(zzkz3, zzm2);
                    if (this.zzj.zzb().zze(zzm2.zzb, zzap.zzaq)) {
                        zzm3 = zzm2;
                        zzks2 = this;
                        zzks2.zzw();
                        zzks2.zzj.zzf().zza(zzm3.zza);
                    }
                    l2 = l;
                    zzm3 = zzm2;
                    zzks2 = this;
                    zzks2.zzw();
                    zzks2.zzk();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    zzg3.putLong("_uwa", 0L);
                    zzg3.putLong("_pfo", 0L);
                    zzg3.putLong("_sys", 0L);
                    zzg3.putLong("_sysu", 0L);
                    if (zzks2.zzj.zzb().zze(zzm3.zza, zzap.zzba)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzm3.zzq) {
                        zzg3.putLong("_dac", 1L);
                    }
                    String string = zzm3.zza;
                    zzac zzac3 = zzks2.zze();
                    Preconditions.checkNotEmpty((String)string);
                    zzac3.zzd();
                    zzac3.zzak();
                    long l4 = zzac3.zzh(string, "first_open_count");
                    if (zzks2.zzj.zzn().getPackageManager() == null) {
                        zzks2.zzj.zzr().zzf().zza("PackageManager is null, first open report might be inaccurate. appId", zzfk.zza((String)zzm3.zza));
                    } else {
                        packageInfo = null;
                        try {
                            packageInfo = Wrappers.packageManager((Context)zzks2.zzj.zzn()).getPackageInfo(zzm3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzks2.zzj.zzr().zzf().zza("Package info is null, first open report might be inaccurate. appId", zzfk.zza((String)zzm3.zza), (Object)nameNotFoundException);
                        }
                        if (packageInfo != null && packageInfo.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                                if (zzks2.zzj.zzb().zza(zzap.zzcn)) {
                                    if (l4 == 0L) {
                                        zzg3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    zzg3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl = true;
                            }
                            zzkz zzkz4 = new zzkz("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzks2.zza(zzkz4, zzm3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzks2.zzj.zzn()).getApplicationInfo(zzm3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzks2.zzj.zzr().zzf().zza("Application info is null, first open report might be inaccurate. appId", zzfk.zza((String)zzm3.zza), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzg3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzg3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l4 >= 0L) {
                        zzg3.putLong("_pfo", l4);
                    }
                    packageInfo = new zzan("_f", new zzam((Bundle)zzg3), "auto", l2);
                    zzks2.zza((zzan)packageInfo, zzm3);
                } else if (n == 1) {
                    zzkz zzkz5 = new zzkz("_fvt", l, (Object)l3, "auto");
                    this.zza(zzkz5, zzm2);
                    l2 = l;
                    zzm3 = zzm2;
                    zzks2 = this;
                    zzks2.zzw();
                    zzks2.zzk();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    if (zzks2.zzj.zzb().zze(zzm3.zza, zzap.zzba)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzm3.zzq) {
                        zzg3.putLong("_dac", 1L);
                    }
                    zzan zzan3 = new zzan("_v", new zzam((Bundle)zzg3), "auto", l2);
                    zzks2.zza(zzan3, zzm3);
                }
                if (!this.zzj.zzb().zze(zzm2.zza, zzap.zzbb)) {
                    l2 = l;
                    zzm3 = zzm2;
                    zzks2 = this;
                    zzg3 = new Bundle();
                    zzg3.putLong("_et", 1L);
                    if (zzks2.zzj.zzb().zze(zzm3.zza, zzap.zzba)) {
                        zzg3.putLong("_fr", 1L);
                    }
                    zzan zzan4 = new zzan("_e", new zzam((Bundle)zzg3), "auto", l2);
                    zzks2.zza(zzan4, zzm3);
                }
            } else if (zzm2.zzi) {
                l2 = l;
                zzm3 = zzm2;
                zzks2 = this;
                zzg3 = new Bundle();
                zzan zzan5 = new zzan("_cd", new zzam((Bundle)zzg3), "auto", l2);
                zzks2.zza(zzan5, zzm3);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    private final zzm zza(String string) {
        zzg zzg2 = this.zze().zzb(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzl())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzb(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping. appId", zzfk.zza((String)string));
            return null;
        }
        return new zzm(string, zzg2.zze(), zzg2.zzl(), zzg2.zzm(), zzg2.zzn(), zzg2.zzo(), zzg2.zzp(), null, zzg2.zzr(), false, zzg2.zzi(), zzg2.zzae(), 0L, 0, zzg2.zzaf(), zzg2.zzag(), false, zzg2.zzf(), zzg2.zzah(), zzg2.zzq(), zzg2.zzai(), zzll.zzb() && this.zzj.zzb().zze(string, zzap.zzch) ? zzg2.zzg() : null);
    }

    @WorkerThread
    final void zza(zzv zzv2) {
        zzm zzm2 = this.zza(zzv2.zza);
        if (zzm2 != null) {
            this.zza(zzv2, zzm2);
        }
    }

    @WorkerThread
    final void zza(zzv zzv2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotEmpty((String)zzv2.zza);
        Preconditions.checkNotNull((Object)zzv2.zzb);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        Preconditions.checkNotEmpty((String)zzv2.zzc.zza);
        this.zzw();
        this.zzk();
        if (!this.zze(zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        zzv zzv3 = new zzv(zzv2);
        new zzv(zzv2).zze = false;
        this.zze().zzf();
        try {
            boolean bl = false;
            zzv zzv4 = this.zze().zzd(zzv3.zza, zzv3.zzc.zza);
            if (zzv4 != null && !zzv4.zzb.equals(zzv3.zzb)) {
                this.zzj.zzr().zzi().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzj.zzj().zzc(zzv3.zzc.zza), (Object)zzv3.zzb, (Object)zzv4.zzb);
            }
            if (zzv4 != null && zzv4.zze) {
                zzv3.zzb = zzv4.zzb;
                zzv3.zzd = zzv4.zzd;
                zzv3.zzh = zzv4.zzh;
                zzv3.zzf = zzv4.zzf;
                zzv3.zzi = zzv4.zzi;
                zzv3.zze = zzv4.zze;
                zzv3.zzc = new zzkz(zzv3.zzc.zza, zzv4.zzc.zzb, zzv3.zzc.zza(), zzv4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzv3.zzf)) {
                zzv3.zzc = new zzkz(zzv3.zzc.zza, zzv3.zzd, zzv3.zzc.zza(), zzv3.zzc.zze);
                zzv3.zze = true;
                bl = true;
            }
            if (zzv3.zze) {
                zzkz zzkz2 = zzv3.zzc;
                zzlb zzlb2 = new zzlb(zzv3.zza, zzv3.zzb, zzkz2.zza, zzkz2.zzb, zzkz2.zza());
                if (this.zze().zza(zzlb2)) {
                    this.zzj.zzr().zzw().zza("User property updated immediately", (Object)zzv3.zza, (Object)this.zzj.zzj().zzc(zzlb2.zzc), zzlb2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("(2)Too many active user properties, ignoring", zzfk.zza((String)zzv3.zza), (Object)this.zzj.zzj().zzc(zzlb2.zzc), zzlb2.zze);
                }
                if (bl && zzv3.zzi != null) {
                    zzan zzan2 = new zzan(zzv3.zzi, zzv3.zzd);
                    this.zzb(zzan2, zzm2);
                }
            }
            if (this.zze().zza(zzv3)) {
                this.zzj.zzr().zzw().zza("Conditional property added", (Object)zzv3.zza, (Object)this.zzj.zzj().zzc(zzv3.zzc.zza), zzv3.zzc.zza());
            } else {
                this.zzj.zzr().zzf().zza("Too many conditional properties, ignoring", zzfk.zza((String)zzv3.zza), (Object)this.zzj.zzj().zzc(zzv3.zzc.zza), zzv3.zzc.zza());
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzv zzv2) {
        zzm zzm2 = this.zza(zzv2.zza);
        if (zzm2 != null) {
            this.zzb(zzv2, zzm2);
        }
    }

    @WorkerThread
    final void zzb(zzv zzv2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotEmpty((String)zzv2.zza);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        Preconditions.checkNotEmpty((String)zzv2.zzc.zza);
        this.zzw();
        this.zzk();
        if (!this.zze(zzm2)) {
            return;
        }
        if (!zzm2.zzh) {
            this.zzc(zzm2);
            return;
        }
        this.zze().zzf();
        try {
            this.zzc(zzm2);
            zzv zzv3 = this.zze().zzd(zzv2.zza, zzv2.zzc.zza);
            if (zzv3 != null) {
                this.zzj.zzr().zzw().zza("Removing conditional user property", (Object)zzv2.zza, (Object)this.zzj.zzj().zzc(zzv2.zzc.zza));
                this.zze().zze(zzv2.zza, zzv2.zzc.zza);
                if (zzv3.zze) {
                    this.zze().zzb(zzv2.zza, zzv2.zzc.zza);
                }
                if (zzv2.zzk != null) {
                    Bundle bundle = null;
                    if (zzv2.zzk.zzb != null) {
                        bundle = zzv2.zzk.zzb.zzb();
                    }
                    zzan zzan2 = this.zzj.zzi().zza(zzv2.zza, zzv2.zzk.zza, bundle, zzv3.zzb, zzv2.zzk.zzd, true, false);
                    this.zzb(zzan2, zzm2);
                }
            } else {
                this.zzj.zzr().zzi().zza("Conditional user property doesn't exist", zzfk.zza((String)zzv2.zza), (Object)this.zzj.zzj().zzc(zzv2.zzc.zza));
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    private final zzg zza(zzm zzm2, zzg zzg2, String string) {
        boolean bl = false;
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzj, zzm2.zza);
            zzg2.zza(this.zzj.zzi().zzk());
            zzg2.zze(string);
            bl = true;
        } else if (!string.equals(zzg2.zzh())) {
            zzg2.zze(string);
            zzg2.zza(this.zzj.zzi().zzk());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzm2.zzb, (CharSequence)zzg2.zze())) {
            zzg2.zzb(zzm2.zzb);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzm2.zzr, (CharSequence)zzg2.zzf())) {
            zzg2.zzc(zzm2.zzr);
            bl = true;
        }
        if (zzll.zzb() && this.zzj.zzb().zze(zzg2.zzc(), zzap.zzch) && !TextUtils.equals((CharSequence)zzm2.zzv, (CharSequence)zzg2.zzg())) {
            zzg2.zzd(zzm2.zzv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzk) && !zzm2.zzk.equals(zzg2.zzi())) {
            zzg2.zzf(zzm2.zzk);
            bl = true;
        }
        if (zzm2.zze != 0L && zzm2.zze != zzg2.zzo()) {
            zzg2.zzd(zzm2.zze);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzc) && !zzm2.zzc.equals(zzg2.zzl())) {
            zzg2.zzg(zzm2.zzc);
            bl = true;
        }
        if (zzm2.zzj != zzg2.zzm()) {
            zzg2.zzc(zzm2.zzj);
            bl = true;
        }
        if (zzm2.zzd != null && !zzm2.zzd.equals(zzg2.zzn())) {
            zzg2.zzh(zzm2.zzd);
            bl = true;
        }
        if (zzm2.zzf != zzg2.zzp()) {
            zzg2.zze(zzm2.zzf);
            bl = true;
        }
        if (zzm2.zzh != zzg2.zzr()) {
            zzg2.zza(zzm2.zzh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzm2.zzg) && !zzm2.zzg.equals(zzg2.zzac())) {
            zzg2.zzi(zzm2.zzg);
            bl = true;
        }
        if (zzm2.zzl != zzg2.zzae()) {
            zzg2.zzp(zzm2.zzl);
            bl = true;
        }
        if (zzm2.zzo != zzg2.zzaf()) {
            zzg2.zzb(zzm2.zzo);
            bl = true;
        }
        if (zzm2.zzp != zzg2.zzag()) {
            zzg2.zzc(zzm2.zzp);
            bl = true;
        }
        if (this.zzj.zzb().zze(zzm2.zza, zzap.zzbc) && zzm2.zzs != zzg2.zzah()) {
            zzg2.zza(zzm2.zzs);
            bl = true;
        }
        if (zzm2.zzt != 0L && zzm2.zzt != zzg2.zzq()) {
            zzg2.zzf(zzm2.zzt);
            bl = true;
        }
        if (bl) {
            this.zze().zza(zzg2);
        }
        return zzg2;
    }

    @WorkerThread
    final zzg zzc(zzm zzm2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.zza);
        zzg zzg2 = this.zze().zzb(zzm2.zza);
        String string = this.zzj.zzc().zzb(zzm2.zza);
        if (com.google.android.gms.internal.measurement.zzks.zzb() && this.zzj.zzb().zza(zzap.zzcp)) {
            if (zzg2 == null) {
                zzg2 = new zzg(this.zzj, zzm2.zza);
                zzg2.zza(this.zzj.zzi().zzk());
                zzg2.zze(string);
            } else if (!string.equals(zzg2.zzh())) {
                zzg2.zze(string);
                zzg2.zza(this.zzj.zzi().zzk());
            }
            zzg2.zzb(zzm2.zzb);
            zzg2.zzc(zzm2.zzr);
            if (zzll.zzb() && this.zzj.zzb().zze(zzg2.zzc(), zzap.zzch)) {
                zzg2.zzd(zzm2.zzv);
            }
            if (!TextUtils.isEmpty((CharSequence)zzm2.zzk)) {
                zzg2.zzf(zzm2.zzk);
            }
            if (zzm2.zze != 0L) {
                zzg2.zzd(zzm2.zze);
            }
            if (!TextUtils.isEmpty((CharSequence)zzm2.zzc)) {
                zzg2.zzg(zzm2.zzc);
            }
            zzg2.zzc(zzm2.zzj);
            if (zzm2.zzd != null) {
                zzg2.zzh(zzm2.zzd);
            }
            zzg2.zze(zzm2.zzf);
            zzg2.zza(zzm2.zzh);
            if (!TextUtils.isEmpty((CharSequence)zzm2.zzg)) {
                zzg2.zzi(zzm2.zzg);
            }
            zzg2.zzp(zzm2.zzl);
            zzg2.zzb(zzm2.zzo);
            zzg2.zzc(zzm2.zzp);
            if (this.zzj.zzb().zze(zzm2.zza, zzap.zzbc)) {
                zzg2.zza(zzm2.zzs);
            }
            zzg2.zzf(zzm2.zzt);
            if (zzg2.zza()) {
                this.zze().zza(zzg2);
            }
            return zzg2;
        }
        return this.zza(zzm2, zzg2, string);
    }

    final String zzd(zzm zzm2) {
        Future future = this.zzj.zzq().zza((Callable)new zzkv(this, zzm2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj.zzr().zzf().zza("Failed to get app instance id. appId", zzfk.zza((String)zzm2.zza), (Object)exception);
            return null;
        }
    }

    final void zza(boolean bl) {
        this.zzz();
    }

    private final boolean zze(zzm zzm2) {
        if (zzll.zzb() && this.zzj.zzb().zze(zzm2.zza, zzap.zzch)) {
            return !TextUtils.isEmpty((CharSequence)zzm2.zzb) || !TextUtils.isEmpty((CharSequence)zzm2.zzv) || !TextUtils.isEmpty((CharSequence)zzm2.zzr);
        }
        return !TextUtils.isEmpty((CharSequence)zzm2.zzb) || !TextUtils.isEmpty((CharSequence)zzm2.zzr);
    }

    static /* synthetic */ void zza(zzks zzks2, zzkx zzkx2) {
        zzks2.zza(zzkx2);
    }

    final class zza
    implements zzae {
        zzbr.zzg zza;
        List<Long> zzb;
        List<zzbr.zzc> zzc;
        private long zzd;

        private zza() {
        }

        @Override
        public final void zza(zzbr.zzg zzg2) {
            Preconditions.checkNotNull((Object)((Object)zzg2));
            this.zza = zzg2;
        }

        @Override
        public final boolean zza(long l, zzbr.zzc zzc2) {
            Preconditions.checkNotNull((Object)((Object)zzc2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzbr.zzc>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (this.zzc.size() > 0 && com.google.android.gms.measurement.internal.zzks$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzks$zza.zza(zzc2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzc2.zzbn();
            if (l2 >= (long)Math.max(0, (Integer)zzap.zzh.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzc2);
            this.zzb.add(l);
            return this.zzc.size() < Math.max(1, (Integer)zzap.zzi.zza(null));
        }

        private static long zza(zzbr.zzc zzc2) {
            return zzc2.zze() / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzkr zzkr2) {
            this();
        }
    }
}

