/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgr
extends zzfe {
    private final zzks zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzgr(zzks zzks2) {
        this(zzks2, null);
    }

    private zzgr(zzks zzks2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzks2);
        this.zza = zzks2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgu(this, zzm2));
    }

    @BinderThread
    public final void zza(zzan zzan2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzan2);
        this.zzb(zzm2, false);
        this.zza(new zzgz(this, zzan2, zzm2));
    }

    @VisibleForTesting
    final zzan zzb(zzan zzan2, zzm zzm2) {
        String string;
        zzm zzm3 = zzm2;
        zzan zzan3 = zzan2;
        zzgr zzgr2 = this;
        if (!"_cmp".equals(zzan3.zza) || zzan3.zzb == null || zzan3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzan3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzgr2.zza.zzb().zze(zzm3.zza, zzap.zzar)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzan2.toString());
            return new zzan("_cmpx", zzan2.zzb, zzan2.zzc, zzan2.zzd);
        }
        return zzan2;
    }

    @BinderThread
    public final void zza(zzan zzan2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzan2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzhc(this, zzan2, string));
    }

    @BinderThread
    public final byte[] zza(zzan zzan2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzan2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzan2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzhb(this, zzan2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzfj.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzan2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzfj.zza((String)string), (Object)this.zza.zzi().zza(zzan2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkz zzkz2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzkz2);
        this.zzb(zzm2, false);
        this.zza(new zzhe(this, zzkz2, zzm2));
    }

    @BinderThread
    public final List<zzkz> zza(zzm zzm2, boolean bl) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzhd(this, zzm2));
        try {
            List list = (List)future.get();
            ArrayList<zzkz> arrayList = new ArrayList<zzkz>(list.size());
            for (zzlb zzlb2 : list) {
                if (!bl && zzla.zze((String)zzlb2.zzc)) continue;
                arrayList.add(new zzkz(zzlb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            if (com.google.android.gms.internal.measurement.zzkz.zzb() && this.zza.zzb().zze(zzm2.zza, zzap.zzcy)) {
                this.zza.zzr().zzf().zza("Failed to get user properties. appId", zzfj.zza((String)zzm2.zza), (Object)exception);
            } else {
                this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzfj.zza((String)zzm2.zza), (Object)exception);
            }
            return null;
        }
    }

    @BinderThread
    public final void zza(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzhg(this, zzm2));
    }

    @BinderThread
    private final void zzb(zzm zzm2, boolean bl) {
        Preconditions.checkNotNull((Object)zzm2);
        this.zza(zzm2.zza, false);
        this.zza.zzj().zza(zzm2.zzb, zzm2.zzr, zzm2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgr zzgr2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgr2 = this;
                    if (!bl2) break block9;
                    if (zzgr2.zzb == null) {
                        zzgr2.zzb = "com.google.android.gms".equals(zzgr2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzgr2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgr2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgr2.zzb.booleanValue()) break block10;
                }
                if (zzgr2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgr2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgr2.zzc = string2;
                }
                if (!string2.equals(zzgr2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzfj.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzhf(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzm zzm2) {
        this.zzb(zzm2, false);
        return this.zza.zzd(zzm2);
    }

    @BinderThread
    public final void zza(zzv zzv2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        this.zzb(zzm2, false);
        zzv zzv3 = new zzv(zzv2);
        new zzv(zzv2).zza = zzm2.zza;
        this.zza(new zzhi(this, zzv3, zzm2));
    }

    @BinderThread
    public final void zza(zzv zzv2) {
        Preconditions.checkNotNull((Object)zzv2);
        Preconditions.checkNotNull((Object)zzv2.zzc);
        this.zza(zzv2.zza, true);
        zzv zzv3 = new zzv(zzv2);
        this.zza(new zzgt(this, zzv3));
    }

    @BinderThread
    public final List<zzkz> zza(String string, String string2, boolean bl, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgw(this, zzm2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkz> arrayList = new ArrayList<zzkz>(list.size());
            for (zzlb zzlb2 : list) {
                if (!bl && zzla.zze((String)zzlb2.zzc)) continue;
                arrayList.add(new zzkz(zzlb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            if (com.google.android.gms.internal.measurement.zzkz.zzb() && this.zza.zzb().zze(zzm2.zza, zzap.zzcy)) {
                this.zza.zzr().zzf().zza("Failed to query user properties. appId", zzfj.zza((String)zzm2.zza), (Object)exception);
            } else {
                this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzfj.zza((String)zzm2.zza), (Object)exception);
            }
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkz> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgv(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkz> arrayList = new ArrayList<zzkz>(list.size());
            for (zzlb zzlb2 : list) {
                if (!bl && zzla.zze((String)zzlb2.zzc)) continue;
                arrayList.add(new zzkz(zzlb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            if (com.google.android.gms.internal.measurement.zzkz.zzb() && this.zza.zzb().zze(string, zzap.zzcy)) {
                this.zza.zzr().zzf().zza("Failed to get user properties as. appId", zzfj.zza((String)string), (Object)exception);
            } else {
                this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzfj.zza((String)string), (Object)exception);
            }
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzv> zza(String string, String string2, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgy(this, zzm2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzv> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgx(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            if (com.google.android.gms.internal.measurement.zzkz.zzb() && this.zza.zzb().zze(string, zzap.zzcy)) {
                this.zza.zzr().zzf().zza("Failed to get conditional user properties as", (Object)exception);
            } else {
                this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            }
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzm zzm2) {
        this.zza(zzm2.zza, false);
        this.zza(new zzha(this, zzm2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    static /* synthetic */ zzks zza(zzgr zzgr2) {
        return zzgr2.zza;
    }
}

