/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzgo;
import com.google.android.gms.internal.measurement.zzlb;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class zzad
extends zzkb {
    private static final String[] zzb = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;", "current_session_count", "ALTER TABLE events ADD COLUMN current_session_count INTEGER;"};
    private static final String[] zzc = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzd = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;", "dynamite_version", "ALTER TABLE apps ADD COLUMN dynamite_version INTEGER;", "safelisted_events", "ALTER TABLE apps ADD COLUMN safelisted_events TEXT;", "ga_app_id", "ALTER TABLE apps ADD COLUMN ga_app_id TEXT;"};
    private static final String[] zze = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzf = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzg = new String[]{"session_scoped", "ALTER TABLE event_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzh = new String[]{"session_scoped", "ALTER TABLE property_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzi = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzae zzj;
    private final zzjx zzk = new zzjx(this.zzm());

    zzad(zzka zzka2) {
        super(zzka2);
        String string = "google_app_measurement.db";
        this.zzj = new zzae(this, this.zzn(), string);
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @WorkerThread
    public final void zzf() {
        this.zzak();
        this.c_().beginTransaction();
    }

    @WorkerThread
    public final void b_() {
        this.zzak();
        this.c_().setTransactionSuccessful();
    }

    @WorkerThread
    public final void zzh() {
        this.zzak();
        this.c_().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzr().zzf().zza("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.c_();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase c_() {
        this.zzd();
        try {
            return this.zzj.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzi().zza("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzak zza(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling", "current_session_count"));
        try (Cursor cursor = null;){
            cursor = this.c_().query("events", arrayList.toArray(new String[0]), "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl = null;
            if (!cursor.isNull(7)) {
                bl = cursor.getLong(7) == 1L;
            }
            long l8 = cursor.isNull(8) ? 0L : cursor.getLong(8);
            zzak zzak2 = new zzak(string, string2, l, l2, l8, l3, l4, l5, l6, l7, bl);
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for event aggregates, expected one. appId", zzes.zza((String)string));
            }
            zzak zzak3 = zzak2;
            return zzak3;
        }
    }

    @WorkerThread
    public final void zza(zzak zzak2) {
        Preconditions.checkNotNull((Object)zzak2);
        this.zzd();
        this.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzak2.zza);
        contentValues.put("name", zzak2.zzb);
        contentValues.put("lifetime_count", Long.valueOf(zzak2.zzc));
        contentValues.put("current_bundle_count", Long.valueOf(zzak2.zzd));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzak2.zzf));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzak2.zzg));
        contentValues.put("last_bundled_day", zzak2.zzh);
        contentValues.put("last_sampled_complex_event_id", zzak2.zzi);
        contentValues.put("last_sampling_rate", zzak2.zzj);
        contentValues.put("current_session_count", Long.valueOf(zzak2.zze));
        Long l = null;
        if (zzak2.zzk != null && zzak2.zzk.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.c_().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert/update event aggregates (got -1). appId", zzes.zza((String)zzak2.zza));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing event aggregates. appId", zzes.zza((String)zzak2.zza), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzb(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        try {
            this.c_().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error deleting user property. appId", zzes.zza((String)string), (Object)this.zzo().zzc(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzkj zzkj2) {
        Preconditions.checkNotNull((Object)zzkj2);
        this.zzd();
        this.zzak();
        if (this.zzc(zzkj2.zza, zzkj2.zzc) == null && (zzkm.zza((String)zzkj2.zzc) ? this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzkj2.zza}) >= (long)this.zzt().zzc(zzkj2.zza) : !"_npa".equals(zzkj2.zzc) && this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzkj2.zza, zzkj2.zzb}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzkj2.zza);
        contentValues.put("origin", zzkj2.zzb);
        contentValues.put("name", zzkj2.zzc);
        contentValues.put("set_timestamp", Long.valueOf(zzkj2.zzd));
        zzad.zza(contentValues, "value", zzkj2.zze);
        try {
            if (this.c_().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert/update user property (got -1). appId", zzes.zza((String)zzkj2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing user property. appId", zzes.zza((String)zzkj2.zza), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzkj zzc(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzkj zzkj2 = new zzkj(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for user property, expected one. appId", zzes.zza((String)string));
            }
            zzkj zzkj3 = zzkj2;
            return zzkj3;
        }
    }

    @WorkerThread
    public final List<zzkj> zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        ArrayList<zzkj> arrayList = new ArrayList<zzkj>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.c_().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzkj> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzr().zzf().zza("Read invalid user property value, ignoring it. appId", zzes.zza((String)string));
                    continue;
                }
                zzkj zzkj2 = new zzkj(string, string2, (String)object, l, object2);
                arrayList.add(zzkj2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzkj> zza(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        ArrayList<zzkj> arrayList = new ArrayList<zzkj>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.c_().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzkj> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzr().zzf().zza("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzr().zzf().zza("(2)Read invalid user property value, ignoring it", zzes.zza((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzkj zzkj2 = new zzkj(string, string2, (String)object, l, object2);
                arrayList.add(zzkj2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)zzw2);
        this.zzd();
        this.zzak();
        if (this.zzc(zzw2.zza, zzw2.zzc.zza) == null && this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzw2.zza}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzw2.zza);
        contentValues.put("origin", zzw2.zzb);
        contentValues.put("name", zzw2.zzc.zza);
        zzad.zza(contentValues, "value", zzw2.zzc.zza());
        contentValues.put("active", Boolean.valueOf(zzw2.zze));
        contentValues.put("trigger_event_name", zzw2.zzf);
        contentValues.put("trigger_timeout", Long.valueOf(zzw2.zzh));
        this.zzp();
        contentValues.put("timed_out_event", zzkm.zza((Parcelable)zzw2.zzg));
        contentValues.put("creation_timestamp", Long.valueOf(zzw2.zzd));
        this.zzp();
        contentValues.put("triggered_event", zzkm.zza((Parcelable)zzw2.zzi));
        contentValues.put("triggered_timestamp", Long.valueOf(zzw2.zzc.zzb));
        contentValues.put("time_to_live", Long.valueOf(zzw2.zzj));
        this.zzp();
        contentValues.put("expired_event", zzkm.zza((Parcelable)zzw2.zzk));
        try {
            if (this.c_().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert/update conditional user property (got -1)", zzes.zza((String)zzw2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing conditional user property", zzes.zza((String)zzw2.zza), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzw zzd(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzao zzao2 = (zzao)this.zzg().zza(cursor.getBlob(5), zzao.CREATOR);
            long l2 = cursor.getLong(6);
            zzao zzao3 = (zzao)this.zzg().zza(cursor.getBlob(7), zzao.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzao zzao4 = (zzao)this.zzg().zza(cursor.getBlob(10), zzao.CREATOR);
            zzkh zzkh2 = new zzkh(string2, l3, object, string3);
            zzw zzw2 = new zzw(string, string3, zzkh2, l2, bl, string4, zzao2, l, zzao3, l4, zzao4);
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for conditional property, expected one", zzes.zza((String)string), (Object)this.zzo().zzc(string2));
            }
            zzw zzw3 = zzw2;
            return zzw3;
        }
    }

    @WorkerThread
    public final int zze(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        try {
            return this.c_().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error deleting conditional property", zzes.zza((String)string), (Object)this.zzo().zzc(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzw> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zza(stringBuilder.toString(), stringArray);
    }

    public final List<zzw> zza(String string, String[] stringArray) {
        this.zzd();
        this.zzak();
        ArrayList<zzw> arrayList = new ArrayList<zzw>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.c_().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzw> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzr().zzf().zza("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzao zzao2 = (zzao)this.zzg().zza(cursor.getBlob(7), zzao.CREATOR);
                long l2 = cursor.getLong(8);
                zzao zzao3 = (zzao)this.zzg().zza(cursor.getBlob(9), zzao.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzao zzao4 = (zzao)this.zzg().zza(cursor.getBlob(12), zzao.CREATOR);
                zzkh zzkh2 = new zzkh(string3, l3, object2, string2);
                zzw zzw2 = new zzw((String)object, string2, zzkh2, l2, bl, string4, zzao2, l, zzao3, l4, zzao4);
                arrayList.add(zzw2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzf zzb(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled", "admob_app_id", "dynamite_version", "safelisted_events", "ga_app_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzf zzf2 = new zzf(this.zza.zzs(), string);
            zzf2.zza(cursor.getString(0));
            zzf2.zzb(cursor.getString(1));
            zzf2.zze(cursor.getString(2));
            zzf2.zzg(cursor.getLong(3));
            zzf2.zza(cursor.getLong(4));
            zzf2.zzb(cursor.getLong(5));
            zzf2.zzg(cursor.getString(6));
            zzf2.zzh(cursor.getString(7));
            zzf2.zzd(cursor.getLong(8));
            zzf2.zze(cursor.getLong(9));
            zzf2.zza(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzf2.zzj(cursor.getLong(11));
            zzf2.zzk(cursor.getLong(12));
            zzf2.zzl(cursor.getLong(13));
            zzf2.zzm(cursor.getLong(14));
            zzf2.zzh(cursor.getLong(15));
            zzf2.zzi(cursor.getLong(16));
            zzf2.zzc(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzf2.zzf(cursor.getString(18));
            zzf2.zzo(cursor.getLong(19));
            zzf2.zzn(cursor.getLong(20));
            zzf2.zzi(cursor.getString(21));
            if (!this.zzt().zza(zzaq.zzcm)) {
                zzf2.zzp(cursor.isNull(22) ? 0L : cursor.getLong(22));
            }
            zzf2.zzb(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzf2.zzc(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzf2.zzc(cursor.getString(25));
            zzf2.zzf(cursor.isNull(26) ? 0L : cursor.getLong(26));
            if (!cursor.isNull(27)) {
                zzf2.zza(Arrays.asList(cursor.getString(27).split(",", -1)));
            }
            if (zzlb.zzb() && this.zzt().zze(string, zzaq.zzbo)) {
                zzf2.zzd(cursor.getString(28));
            }
            zzf2.zzb();
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for app, expected one. appId", zzes.zza((String)string));
            }
            zzf zzf3 = zzf2;
            return zzf3;
        }
    }

    @WorkerThread
    public final void zza(zzf zzf2) {
        Preconditions.checkNotNull((Object)zzf2);
        this.zzd();
        this.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzf2.zzc());
        contentValues.put("app_instance_id", zzf2.zzd());
        contentValues.put("gmp_app_id", zzf2.zze());
        contentValues.put("resettable_device_id_hash", zzf2.zzh());
        contentValues.put("last_bundle_index", Long.valueOf(zzf2.zzs()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzf2.zzj()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzf2.zzk()));
        contentValues.put("app_version", zzf2.zzl());
        contentValues.put("app_store", zzf2.zzn());
        contentValues.put("gmp_version", Long.valueOf(zzf2.zzo()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzf2.zzp()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzf2.zzr()));
        contentValues.put("day", Long.valueOf(zzf2.zzw()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzf2.zzx()));
        contentValues.put("daily_events_count", Long.valueOf(zzf2.zzy()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzf2.zzz()));
        contentValues.put("config_fetched_time", Long.valueOf(zzf2.zzt()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzf2.zzu()));
        contentValues.put("app_version_int", Long.valueOf(zzf2.zzm()));
        contentValues.put("firebase_instance_id", zzf2.zzi());
        contentValues.put("daily_error_events_count", Long.valueOf(zzf2.zzab()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzf2.zzaa()));
        contentValues.put("health_monitor_sample", zzf2.zzac());
        contentValues.put("android_id", Long.valueOf(zzf2.zzae()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzf2.zzaf()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzf2.zzag()));
        contentValues.put("admob_app_id", zzf2.zzf());
        contentValues.put("dynamite_version", Long.valueOf(zzf2.zzq()));
        if (zzf2.zzai() != null) {
            if (zzf2.zzai().size() == 0) {
                this.zzr().zzi().zza("Safelisted events should not be an empty list. appId", (Object)zzf2.zzc());
            } else {
                contentValues.put("safelisted_events", TextUtils.join((CharSequence)",", (Iterable)zzf2.zzai()));
            }
        }
        if (zzlb.zzb() && this.zzt().zze(zzf2.zzc(), zzaq.zzbo)) {
            contentValues.put("ga_app_id", zzf2.zzg());
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.c_();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzf2.zzc()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert/update app (got -1). appId", zzes.zza((String)zzf2.zzc()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing app. appId", zzes.zza((String)zzf2.zzc()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzc(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = this.c_();
            String string2 = string;
            int n = this.zzt().zzb(string2, zzaq.zzo);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error deleting over the limit events. appId", zzes.zza((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzac zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return this.zza(l, string, 1L, false, false, bl3, false, bl5);
    }

    @WorkerThread
    public final zzac zza(long l, String string, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        String[] stringArray = new String[]{string};
        zzac zzac2 = new zzac();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.c_();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzr().zzi().zza("Not updating daily counts, app is not known. appId", zzes.zza((String)string));
                zzac zzac3 = zzac2;
                return zzac3;
            }
            if (cursor.getLong(0) == l) {
                zzac2.zzb = cursor.getLong(1);
                zzac2.zza = cursor.getLong(2);
                zzac2.zzc = cursor.getLong(3);
                zzac2.zzd = cursor.getLong(4);
                zzac2.zze = cursor.getLong(5);
            }
            if (bl) {
                zzac2.zzb += l2;
            }
            if (bl2) {
                zzac2.zza += l2;
            }
            if (bl3) {
                zzac2.zzc += l2;
            }
            if (bl4) {
                zzac2.zzd += l2;
            }
            if (bl5) {
                zzac2.zze += l2;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzac2.zza));
            contentValues.put("daily_events_count", Long.valueOf(zzac2.zzb));
            contentValues.put("daily_conversions_count", Long.valueOf(zzac2.zzc));
            contentValues.put("daily_error_events_count", Long.valueOf(zzac2.zzd));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzac2.zze));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzac zzac4 = zzac2;
            return zzac4;
        }
    }

    @WorkerThread
    public final byte[] zzd(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for app config, expected one. appId", zzes.zza((String)string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzbs.zzg zzg2, boolean bl) {
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zzg2));
        Preconditions.checkNotEmpty((String)zzg2.zzx());
        Preconditions.checkState((boolean)zzg2.zzk());
        this.zzv();
        long l = this.zzm().currentTimeMillis();
        if (zzg2.zzl() < l - zzy.zzk() || zzg2.zzl() > l + zzy.zzk()) {
            this.zzr().zzi().zza("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzes.zza((String)zzg2.zzx()), (Object)l, (Object)zzg2.zzl());
        }
        byte[] byArray = zzg2.zzbi();
        try {
            byArray = this.zzg().zzc(byArray);
        }
        catch (IOException iOException) {
            this.zzr().zzf().zza("Data loss. Failed to serialize bundle. appId", zzes.zza((String)zzg2.zzx()), (Object)iOException);
            return false;
        }
        this.zzr().zzx().zza("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzx());
        contentValues.put("bundle_end_timestamp", Long.valueOf(zzg2.zzl()));
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzg2.zzaz()) {
            contentValues.put("retry_count", Integer.valueOf(zzg2.zzba()));
        }
        try {
            if (this.c_().insert("queue", null, contentValues) == -1L) {
                this.zzr().zzf().zza("Failed to insert bundle (got -1). appId", zzes.zza((String)zzg2.zzx()));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing bundle. appId", zzes.zza((String)zzg2.zzx()), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final String d_() {
        SQLiteDatabase sQLiteDatabase = this.c_();
        Cursor cursor = null;
        try {
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Database error getting next bundle app id", (Object)sQLiteException);
            return null;
        }
        if (cursor == null) return null;
        cursor.close();
        return null;
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public final boolean zzk() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzbs.zzg, Long>> zza(String string, int n, int n2) {
        this.zzd();
        this.zzak();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.c_().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzbs.zzg, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzbs.zzg, Long>> arrayList = new ArrayList<Pair<zzbs.zzg, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzg().zzb((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to unzip queued bundle. appId", zzes.zza((String)string), (Object)iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                try {
                    object = (Object)zzki.zza(zzbs.zzg.zzbf(), byArray);
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge queued bundle. appId", zzes.zza((String)string), (Object)iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    ((zzbs.zzg.zza)((Object)object)).zzi(cursor.getInt(2));
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzbs.zzg, Long>)Pair.create((Object)((Object)((zzbs.zzg)((zzfe)object.zzv()))), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzbs.zzg, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzv() {
        this.zzd();
        this.zzak();
        if (!this.zzam()) {
            return;
        }
        long l = this.zzs().zzf.zza();
        long l2 = this.zzm().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzaq.zzx.zza(null)) {
            this.zzs().zzf.zza(l2);
            zzad zzad2 = this;
            zzad2.zzd();
            zzad2.zzak();
            if (zzad2.zzam()) {
                SQLiteDatabase sQLiteDatabase = zzad2.c_();
                String[] stringArray = new String[]{String.valueOf(zzad2.zzm().currentTimeMillis()), String.valueOf(zzy.zzk())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzad2.zzr().zzx().zza("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(List<Long> list) {
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzam()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zzb(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzr().zzi().zza("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.c_().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzbk.zzb zzb2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzb2));
        if (TextUtils.isEmpty((CharSequence)zzb2.zzc())) {
            this.zzr().zzi().zza("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzes.zza((String)string), (Object)n, (Object)String.valueOf(zzb2.zza() ? Integer.valueOf(zzb2.zzb()) : null));
            return false;
        }
        byte[] byArray = zzb2.zzbi();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zza() ? Integer.valueOf(zzb2.zzb()) : null);
        contentValues.put("event_name", zzb2.zzc());
        contentValues.put("session_scoped", zzb2.zzj() ? Boolean.valueOf(zzb2.zzk()) : null);
        contentValues.put("data", byArray);
        try {
            if (this.c_().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert event filter (got -1). appId", zzes.zza((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing event filter. appId", zzes.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzbk.zze zze2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zze2));
        if (TextUtils.isEmpty((CharSequence)zze2.zzc())) {
            this.zzr().zzi().zza("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzes.zza((String)string), (Object)n, (Object)String.valueOf(zze2.zza() ? Integer.valueOf(zze2.zzb()) : null));
            return false;
        }
        byte[] byArray = zze2.zzbi();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zza() ? Integer.valueOf(zze2.zzb()) : null);
        contentValues.put("property_name", zze2.zzc());
        contentValues.put("session_scoped", zze2.zzg() ? Boolean.valueOf(zze2.zzh()) : null);
        contentValues.put("data", byArray);
        try {
            if (this.c_().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert property filter (got -1). appId", zzes.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing property filter. appId", zzes.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzbk.zzb>> zzf(String string, String string2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzbk.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzbk.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzbk.zzb)((zzfe)zzki.zza(zzbk.zzb.zzl(), byArray).zzv());
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge filter. appId", zzes.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzbk.zzb> arrayList = (ArrayList<zzbk.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzbk.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzbk.zzb>> zze(String string) {
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzbk.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzbk.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzbk.zzb)((zzfe)zzki.zza(zzbk.zzb.zzl(), byArray).zzv());
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge filter. appId", zzes.zza((String)string), (Object)iOException);
                    continue;
                }
                if (!zzb2.zzf()) continue;
                int n = cursor.getInt(0);
                ArrayList<zzbk.zzb> arrayList = (ArrayList<zzbk.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzbk.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzbk.zze>> zzg(String string, String string2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzbk.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzbk.zze zze2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zze2 = (zzbk.zze)((zzfe)zzki.zza(zzbk.zze.zzi(), byArray).zzv());
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge filter", zzes.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzbk.zze> arrayList = (ArrayList<zzbk.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzbk.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<Integer>> zzf(String string) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("select audience_id, filter_id from event_filters where app_id = ? and session_scoped = 1 UNION select audience_id, filter_id from property_filters where app_id = ? and session_scoped = 1;", new String[]{string, string});
            if (!cursor.moveToFirst()) {
                Map<Integer, List<Integer>> map = Collections.emptyMap();
                return map;
            }
            do {
                int n;
                ArrayList<Integer> arrayList;
                if ((arrayList = (ArrayList<Integer>)arrayMap.get(n = cursor.getInt(0))) == null) {
                    arrayList = new ArrayList<Integer>();
                    arrayMap.put(n, arrayList);
                }
                int n2 = cursor.getInt(1);
                arrayList.add(n2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zzb(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzak();
        this.zzd();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Database error querying filters. appId", zzes.zza((String)string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzt().zzb(string2, zzaq.zzae);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzbs.zzi> zzg(String string) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                zzbs.zzi zzi2;
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzi2 = (zzbs.zzi)((zzfe)zzki.zza(zzbs.zzi.zzi(), byArray).zzv());
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge filter results. appId, audienceId, error", zzes.zza((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzi2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzr().zzf().zza("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzr().zzf().zza("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzr().zzf().zza("Loaded invalid unknown value type, ignoring it", (Object)n3);
        return null;
    }

    @WorkerThread
    public final long zzw() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.c_();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzr().zzf().zza("Failed to insert column (got -1). appId", zzes.zza((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzr().zzf().zza("Failed to update column (got 0). appId", zzes.zza((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error inserting column. appId", zzes.zza((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzx() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzbs.zzg zzg2) throws IOException {
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zzg2));
        Preconditions.checkNotEmpty((String)zzg2.zzx());
        byte[] byArray = zzg2.zzbi();
        long l = this.zzg().zza(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzx());
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            this.c_().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing raw event metadata. appId", zzes.zza((String)zzg2.zzx()), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public final boolean zzy() {
        return this.zzb("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzz() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zza(long l) {
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzr().zzx().zza("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzaa() {
        try (Cursor cursor = null;){
            cursor = this.c_().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzbs.zzc, Long> zza(String string, Long l) {
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            zzbs.zzc zzc2;
            cursor = this.c_().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzr().zzx().zza("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            try {
                zzc2 = (zzbs.zzc)((zzfe)zzki.zza(zzbs.zzc.zzj(), byArray).zzv());
            }
            catch (IOException iOException) {
                this.zzr().zzf().zza("Failed to merge main event. appId, eventId", zzes.zza((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzc2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzbs.zzc zzc2) {
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zzc2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        byte[] byArray = zzc2.zzbi();
        this.zzr().zzx().zza("Saving complex main event, appId, data size", (Object)this.zzo().zza(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.c_().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert complex main event (got -1). appId", zzes.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing complex main event. appId", zzes.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzal zzal2, long l, boolean bl) {
        String string2;
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull((Object)zzal2);
        Preconditions.checkNotEmpty((String)zzal2.zza);
        zzbs.zzc.zza zza2 = zzbs.zzc.zzj().zzb(zzal2.zzd);
        for (String string2 : zzal2.zze) {
            zzbs.zze.zza zza3 = zzbs.zze.zzk().zza(string2);
            Object object = zzal2.zze.zza(string2);
            this.zzg().zza(zza3, object);
            zza2.zza(zza3);
        }
        Object object = ((zzbs.zzc)((zzfe)zza2.zzv())).zzbi();
        string2 = new ContentValues();
        string2.put("app_id", zzal2.zza);
        string2.put("name", zzal2.zzb);
        string2.put("timestamp", Long.valueOf(zzal2.zzc));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.c_().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzr().zzf().zza("Failed to insert raw event (got -1). appId", zzes.zza((String)zzal2.zza));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing raw event. appId", zzes.zza((String)zzal2.zza), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    final void zza(String string, List<zzbk.zza> list) {
        Preconditions.checkNotNull(list);
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            zzgo zzgo2;
            int n;
            zzbk.zza.zza zza2 = (zzbk.zza.zza)list.get(i).zzbl();
            if (zza2.zzb() != 0) {
                for (n = 0; n < zza2.zzb(); ++n) {
                    zzgo2 = (zzbk.zzb.zza)zza2.zzb(n).zzbl();
                    object = (zzbk.zzb.zza)((zzfe.zza)zzgo2.clone());
                    boolean bl = false;
                    String string2 = zzgv.zzb((String)zzgo2.zza());
                    if (string2 != null) {
                        ((zzbk.zzb.zza)((Object)object)).zza(string2);
                        bl = true;
                    }
                    for (int j = 0; j < zzgo2.zzb(); ++j) {
                        zzbk.zzc zzc2 = zzgo2.zza(j);
                        String string3 = zzgu.zza((String)zzc2.zzh());
                        if (string3 == null) continue;
                        zzbk.zzc zzc3 = (zzbk.zzc)((zzfe)((zzbk.zzc.zza)zzc2.zzbl()).zza(string3).zzv());
                        ((zzbk.zzb.zza)((Object)object)).zza(j, zzc3);
                        bl = true;
                    }
                    if (!bl) continue;
                    zza2 = zza2.zza(n, (zzbk.zzb.zza)((Object)object));
                    list.set(i, (zzbk.zza)((zzfe)zza2.zzv()));
                }
            }
            if (zza2.zza() == 0) continue;
            for (n = 0; n < zza2.zza(); ++n) {
                zzgo2 = zza2.zza(n);
                object = zzgx.zza((String)zzgo2.zzc());
                if (object == null) continue;
                zza2 = zza2.zza(n, ((zzbk.zze.zza)zzgo2.zzbl()).zza((String)object));
                list.set(i, (zzbk.zza)((zzfe)zza2.zzv()));
            }
        }
        List<zzbk.zza> list2 = list;
        String string4 = string;
        zzad zzad2 = this;
        zzad2.zzak();
        zzad2.zzd();
        Preconditions.checkNotEmpty((String)string4);
        Preconditions.checkNotNull(list2);
        SQLiteDatabase sQLiteDatabase = zzad2.c_();
        sQLiteDatabase.beginTransaction();
        try {
            String string5 = string4;
            zzad zzad3 = zzad2;
            zzad3.zzak();
            zzad3.zzd();
            Preconditions.checkNotEmpty((String)string5);
            Object object = zzad3.c_();
            object.delete("property_filters", "app_id=?", new String[]{string5});
            object.delete("event_filters", "app_id=?", new String[]{string5});
            Object object2 = list2.iterator();
            block7: while (object2.hasNext()) {
                Object object3;
                object = object3 = object2.next();
                string5 = string4;
                zzad3 = zzad2;
                zzad3.zzak();
                zzad3.zzd();
                Preconditions.checkNotEmpty((String)string5);
                Preconditions.checkNotNull((Object)object);
                if (!((zzbk.zza)((Object)object)).zza()) {
                    zzad3.zzr().zzi().zza("Audience with no ID. appId", zzes.zza((String)string5));
                    continue;
                }
                int n = ((zzbk.zza)((Object)object)).zzb();
                Iterator<zzfe> iterator = ((zzbk.zza)((Object)object)).zze().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().zza()) continue;
                    zzad3.zzr().zzi().zza("Event filter with no ID. Audience definition ignored. appId, audienceId", zzes.zza((String)string5), (Object)n);
                    continue block7;
                }
                iterator = ((zzbk.zza)((Object)object)).zzc().iterator();
                while (iterator.hasNext()) {
                    if (((zzbk.zze)iterator.next()).zza()) continue;
                    zzad3.zzr().zzi().zza("Property filter with no ID. Audience definition ignored. appId, audienceId", zzes.zza((String)string5), (Object)n);
                    continue block7;
                }
                boolean bl = true;
                for (zzbk.zzb zzb2 : ((zzbk.zza)((Object)object)).zze()) {
                    if (zzad3.zza(string5, n, zzb2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (zzbk.zze zze2 : ((zzbk.zza)((Object)object)).zzc()) {
                        if (zzad3.zza(string5, n, zze2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n2 = n;
                String string2 = string5;
                zzad zzad4 = zzad3;
                zzad4.zzak();
                zzad4.zzd();
                Preconditions.checkNotEmpty((String)string2);
                SQLiteDatabase sQLiteDatabase2 = zzad4.c_();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n2)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n2)});
            }
            object2 = new ArrayList();
            for (zzbk.zza zza2 : list2) {
                object2.add(zza2.zza() ? Integer.valueOf(zza2.zzb()) : null);
            }
            zzad2.zzb(string4, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @VisibleForTesting
    private final boolean zzam() {
        return this.zzn().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzjx zza(zzad zzad2) {
        return zzad2.zzk;
    }

    static /* synthetic */ String[] zzab() {
        return zzb;
    }

    static /* synthetic */ String[] zzac() {
        return zzc;
    }

    static /* synthetic */ String[] zzad() {
        return zzd;
    }

    static /* synthetic */ String[] zzae() {
        return zzf;
    }

    static /* synthetic */ String[] zzaf() {
        return zze;
    }

    static /* synthetic */ String[] zzag() {
        return zzg;
    }

    static /* synthetic */ String[] zzah() {
        return zzh;
    }

    static /* synthetic */ String[] zzai() {
        return zzi;
    }
}

