/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzbq;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjm;
import com.google.android.gms.internal.measurement.zzkk;
import com.google.android.gms.internal.measurement.zzlb;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzka
implements zzgt {
    private static volatile zzka zza;
    private zzfq zzb;
    private zzez zzc;
    private zzad zzd;
    private zzfc zze;
    private zzjw zzf;
    private zzo zzg;
    private final zzki zzh;
    private zzif zzi;
    private final zzfw zzj;
    private boolean zzk = false;
    private boolean zzl;
    @VisibleForTesting
    private long zzm;
    private List<Runnable> zzn;
    private int zzo;
    private int zzp;
    private boolean zzq;
    private boolean zzr;
    private boolean zzs;
    private FileLock zzt;
    private FileChannel zzu;
    private List<Long> zzv;
    private List<Long> zzw;
    private long zzx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzka zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzka> clazz = zzka.class;
        synchronized (zzka.class) {
            if (zza != null) return zza;
            zzkg zzkg2 = new zzkg(context);
            zza = new zzka(zzkg2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    private zzka(zzkg zzkg2) {
        this(zzkg2, null);
    }

    private zzka(zzkg zzkg2, zzfw zzfw2) {
        Preconditions.checkNotNull((Object)zzkg2);
        this.zzj = zzfw2 = zzfw.zza((Context)zzkg2.zza, null, null);
        this.zzx = -1L;
        zzka zzka2 = this;
        zzki zzki2 = new zzki(zzka2);
        zzki2.zzal();
        this.zzh = zzki2;
        zzka2 = this;
        zzez zzez2 = new zzez(zzka2);
        zzez2.zzal();
        this.zzc = zzez2;
        zzka2 = this;
        zzfq zzfq2 = new zzfq(zzka2);
        zzfq2.zzal();
        this.zzb = zzfq2;
        this.zzj.zzq().zza((Runnable)new zzkd(this, zzkg2));
    }

    @WorkerThread
    private final void zza(zzkg zzkg2) {
        this.zzj.zzq().zzd();
        zzka zzka2 = this;
        zzad zzad2 = new zzad(zzka2);
        zzad2.zzal();
        this.zzd = zzad2;
        this.zzj.zzb().zza((zzaa)this.zzb);
        zzka2 = this;
        zzo zzo2 = new zzo(zzka2);
        zzo2.zzal();
        this.zzg = zzo2;
        zzka2 = this;
        zzif zzif2 = new zzif(zzka2);
        zzif2.zzal();
        this.zzi = zzif2;
        zzka2 = this;
        zzjw zzjw2 = new zzjw(zzka2);
        zzjw2.zzal();
        this.zzf = zzjw2;
        zzka2 = this;
        this.zze = new zzfc(zzka2);
        if (this.zzo != this.zzp) {
            this.zzj.zzr().zzf().zza("Not all upload components initialized", (Object)this.zzo, (Object)this.zzp);
        }
        this.zzk = true;
    }

    @WorkerThread
    protected final void zza() {
        this.zzj.zzq().zzd();
        this.zze().zzv();
        if (this.zzj.zzc().zzc.zza() == 0L) {
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzz();
    }

    public final zzx zzu() {
        return this.zzj.zzu();
    }

    public final zzy zzb() {
        return this.zzj.zzb();
    }

    public final zzes zzr() {
        return this.zzj.zzr();
    }

    public final zzft zzq() {
        return this.zzj.zzq();
    }

    public final zzfq zzc() {
        zzka.zzb(this.zzb);
        return this.zzb;
    }

    public final zzez zzd() {
        zzka.zzb(this.zzc);
        return this.zzc;
    }

    public final zzad zze() {
        zzka.zzb(this.zzd);
        return this.zzd;
    }

    private final zzfc zzt() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    private final zzjw zzv() {
        zzka.zzb(this.zzf);
        return this.zzf;
    }

    public final zzo zzf() {
        zzka.zzb(this.zzg);
        return this.zzg;
    }

    public final zzif zzg() {
        zzka.zzb(this.zzi);
        return this.zzi;
    }

    public final zzki zzh() {
        zzka.zzb(this.zzh);
        return this.zzh;
    }

    public final zzeq zzi() {
        return this.zzj.zzj();
    }

    public final Context zzn() {
        return this.zzj.zzn();
    }

    public final Clock zzm() {
        return this.zzj.zzm();
    }

    public final zzkm zzj() {
        return this.zzj.zzi();
    }

    @WorkerThread
    private final void zzw() {
        this.zzj.zzq().zzd();
    }

    final void zzk() {
        if (!this.zzk) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zzb(zzkb zzkb2) {
        if (zzkb2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzkb2.zzaj()) {
            String string = String.valueOf(((Object)((Object)zzkb2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private final long zzx() {
        long l = this.zzj.zzm().currentTimeMillis();
        zzfe zzfe2 = this.zzj.zzc();
        zzfe2.zzaa();
        zzfe2.zzd();
        long l2 = zzfe2.zzg.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzfe2.zzp().zzh().nextInt(86400000);
            zzfe2.zzg.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zza(zzao zzao2, String string) {
        zzf zzf2 = this.zze().zzb(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzl())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzb(zzf2);
        if (bl == null) {
            if (!"_ui".equals(zzao2.zza)) {
                this.zzj.zzr().zzi().zza("Could not find package. appId", zzes.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping event. appId", zzes.zza((String)string));
            return;
        }
        zzn zzn2 = new zzn(string, zzf2.zze(), zzf2.zzl(), zzf2.zzm(), zzf2.zzn(), zzf2.zzo(), zzf2.zzp(), null, zzf2.zzr(), false, zzf2.zzi(), zzf2.zzae(), 0L, 0, zzf2.zzaf(), zzf2.zzag(), false, zzf2.zzf(), zzf2.zzah(), zzf2.zzq(), zzf2.zzai(), zzlb.zzb() && this.zzj.zzb().zze(zzf2.zzc(), zzaq.zzbo) ? zzf2.zzg() : null);
        this.zza(zzao2, zzn2);
    }

    @WorkerThread
    final void zza(zzao zzao2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        this.zzw();
        this.zzk();
        String string = zzn2.zza;
        long l = zzao2.zzd;
        this.zzh();
        if (!zzki.zza(zzao2, zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        if (this.zzj.zzb().zze(string, zzaq.zzbc) && zzn2.zzu != null) {
            if (zzn2.zzu.contains(zzao2.zza)) {
                Bundle bundle = zzao2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzao2 = new zzao(zzao2.zza, new zzan(bundle), zzao2.zzc, zzao2.zzd);
            } else {
                this.zzj.zzr().zzw().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzao2.zza, (Object)zzao2.zzc);
                return;
            }
        }
        this.zze().zzf();
        try {
            zzw zzw2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzad zzad2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzad2.zzd();
            zzad2.zzak();
            if (l2 < 0L) {
                zzad2.zzr().zzi().zza("Invalid time querying timed out conditional properties", zzes.zza((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzad2.zza(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj.zzr().zzx().zza("User property timed out", (Object)((zzw)object22).zza, (Object)this.zzj.zzj().zzc(((zzw)object22).zzc.zza), ((zzw)object22).zzc.zza());
                if (((zzw)object22).zzg != null) {
                    this.zzb(new zzao(((zzw)object22).zzg, l), zzn2);
                }
                this.zze().zze(string, ((zzw)object22).zzc.zza);
            }
            l2 = l;
            string3 = string;
            zzad2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            zzad2.zzd();
            zzad2.zzak();
            if (l2 < 0L) {
                zzad2.zzr().zzi().zza("Invalid time querying expired conditional properties", zzes.zza((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzad2.zza(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzw)object4.next();
                if (object == null) continue;
                this.zzj.zzr().zzx().zza("User property expired", (Object)((zzw)object).zza, (Object)this.zzj.zzj().zzc(((zzw)object).zzc.zza), ((zzw)object).zzc.zza());
                this.zze().zzb(string, ((zzw)object).zzc.zza);
                if (((zzw)object).zzk != null) {
                    object22.add(((zzw)object).zzk);
                }
                this.zze().zze(string, ((zzw)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzao)e;
                this.zzb(new zzao((zzao)object, l), zzn2);
            }
            long l3 = l;
            String string4 = zzao2.zza;
            string3 = string;
            zzad2 = this.zze();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzad2.zzd();
            zzad2.zzak();
            if (l3 < 0L) {
                zzad2.zzr().zzi().zza("Invalid time querying triggered conditional properties", zzes.zza((String)string3), (Object)zzad2.zzo().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzad2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzw2 = (zzw)iterator.next();
                if (zzw2 == null) continue;
                zzkh zzkh2 = zzw2.zzc;
                zzkj zzkj2 = new zzkj(zzw2.zza, zzw2.zzb, zzkh2.zza, l, zzkh2.zza());
                if (this.zze().zza(zzkj2)) {
                    this.zzj.zzr().zzx().zza("User property triggered", (Object)zzw2.zza, (Object)this.zzj.zzj().zzc(zzkj2.zzc), zzkj2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("Too many active user properties, ignoring", zzes.zza((String)zzw2.zza), (Object)this.zzj.zzj().zzc(zzkj2.zzc), zzkj2.zze);
                }
                if (zzw2.zzi != null) {
                    object.add(zzw2.zzi);
                }
                zzw2.zzc = new zzkh(zzkj2);
                zzw2.zze = true;
                this.zze().zza(zzw2);
            }
            this.zzb(zzao2, zzn2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzw2 = (zzao)e;
                this.zzb(new zzao((zzao)zzw2, l), zzn2);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzb(zzao var1_1, zzn var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzw();
        this.zzk();
        var5_4 = var2_2.zza;
        this.zzh();
        if (!zzki.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zzc(var2_2);
            return;
        }
        if (this.zzc().zzb(var5_4, var1_1.zza)) {
            this.zzj.zzr().zzi().zza("Dropping blacklisted event. appId", zzes.zza((String)var5_4), (Object)this.zzj.zzj().zza(var1_1.zza));
            var6_5 = this.zzc().zzg(var5_4) != false || this.zzc().zzh(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzj.zzi().zza(var5_4, 11, "_ev", var1_1.zza, 0);
            }
            if (var6_5 && (var7_8 = this.zze().zzb(var5_4)) != null) {
                var8_10 = Math.max(var7_8.zzu(), var7_8.zzt());
                if (Math.abs(this.zzj.zzm().currentTimeMillis() - var8_10) > (Long)zzaq.zzy.zza(null)) {
                    this.zzj.zzr().zzw().zza("Fetching config for blacklisted app");
                    this.zza(var7_8);
                }
            }
            return;
        }
        if (zzjg.zzb() && this.zzj.zzb().zza(zzaq.zzck)) {
            var23_11 = var1_1;
            var6_6 = new zzew(var23_11.zza, var23_11.zzc, var23_11.zzb.zzb(), var23_11.zzd);
            var24_12 = var5_4;
            var25_13 = this.zzj.zzb().zza(var24_12, zzaq.zzah, 25, 100);
            var24_12 = var6_6;
            var23_11 = this.zzj.zzi();
            var26_17 = 0;
            for (Object var29_23 : new TreeSet<E>(var24_12.zzd.keySet())) {
                if (!zzkm.zza((String)var29_23) || ++var26_17 <= var25_13) continue;
                var30_24 = new StringBuilder(48).append("Event can't contain more than ").append(var25_13).append(" params").toString();
                var23_11.zzr().zzh().zza(var30_24, (Object)var23_11.zzo().zza(var24_12.zza), (Object)var23_11.zzo().zza(var24_12.zzd));
                zzkm.zzb((Bundle)var24_12.zzd, (int)5);
                var24_12.zzd.remove((String)var29_23);
            }
            var23_11 = var6_6;
            var1_1 = new zzao(var23_11.zza, new zzan(new Bundle(var23_11.zzd)), var23_11.zzb, var23_11.zzc);
        }
        if (this.zzj.zzr().zza(2)) {
            this.zzj.zzr().zzx().zza("Logging event", (Object)this.zzj.zzj().zza(var1_1));
        }
        this.zze().zzf();
        try {
            block74: {
                block75: {
                    block77: {
                        block81: {
                            block80: {
                                block78: {
                                    block79: {
                                        this.zzc(var2_2);
                                        var6_7 = zzjm.zzb() != false && this.zzj.zzb().zza(zzaq.zzcj) != false;
                                        var7_9 = "ecommerce_purchase".equals(var1_1.zza) != false || var6_7 != false && ("purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false) ? 1 : 0;
                                        if (!("_iap".equals(var1_1.zza) != false || var7_9 != 0)) break block77;
                                        var26_17 = var7_9;
                                        var25_14 = var1_1;
                                        var24_12 = var5_4;
                                        var23_11 = this;
                                        var27_29 = var25_14.zzb.zzd("currency");
                                        if (var26_17 == 0) break block78;
                                        var30_25 = var25_14.zzb.zzc("value") * 1000000.0;
                                        if (var30_25 == 0.0) {
                                            var30_25 = (double)var25_14.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var30_25 <= 9.223372036854776E18) || !(var30_25 >= -9.223372036854776E18)) break block79;
                                        var28_20 = Math.round(var30_25);
                                        if (zzjm.zzb() && var23_11.zzj.zzb().zza(zzaq.zzcj) && "refund".equals(var25_14.zza)) {
                                            var28_20 = -var28_20;
                                        }
                                        break block80;
                                    }
                                    var23_11.zzj.zzr().zzi().zza("Data lost. Currency value is too big. appId", zzes.zza((String)var24_12), (Object)var30_25);
                                    v0 = false;
                                    break block81;
                                }
                                var28_20 = var25_14.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var27_29) && (var27_29 = var27_29.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var27_29);
                                var30_26 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var31_30 /* !! */  = var23_11.zze().zzc(var24_12, var30_26);
                                if (var31_30 /* !! */  == null || !(var31_30 /* !! */ .zze instanceof Long)) {
                                    var35_31 = var24_12;
                                    var39_33 = var23_11.zzj.zzb().zzb(var35_31, zzaq.zzad) - 1;
                                    var38_34 = var24_12;
                                    var37_35 = var23_11.zze();
                                    Preconditions.checkNotEmpty((String)var38_34);
                                    var37_35.zzd();
                                    var37_35.zzak();
                                    try {
                                        var37_35.c_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var38_34, var38_34, String.valueOf(var39_33)});
                                    }
                                    catch (SQLiteException var40_36) {
                                        var37_35.zzr().zzf().zza("Error pruning currencies. appId", zzes.zza((String)var38_34), (Object)var40_36);
                                    }
                                    var31_30 /* !! */  = new zzkj(var24_12, var25_14.zzc, var30_26, var23_11.zzj.zzm().currentTimeMillis(), (Object)var28_20);
                                } else {
                                    var32_37 = (Long)var31_30 /* !! */ .zze;
                                    var31_30 /* !! */  = new zzkj(var24_12, var25_14.zzc, var30_26, var23_11.zzj.zzm().currentTimeMillis(), (Object)(var32_37 + var28_20));
                                }
                                if (!var23_11.zze().zza(var31_30 /* !! */ )) {
                                    var23_11.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property. appId", zzes.zza((String)var24_12), (Object)var23_11.zzj.zzj().zzc(var31_30 /* !! */ .zzc), var31_30 /* !! */ .zze);
                                    var23_11.zzj.zzi().zza(var24_12, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zze().b_();
                            return;
                        }
                    }
                    var9_39 = zzkm.zza((String)var1_1.zza);
                    var10_40 = "_err".equals(var1_1.zza);
                    var11_41 = 1L;
                    if (zzjm.zzb() && this.zzj.zzb().zze(var2_2.zza, zzaq.zzcf)) {
                        this.zzj.zzi();
                        var11_41 = 1L + zzkm.zza((zzan)var1_1.zzb);
                    }
                    var13_42 = this.zze().zza(this.zzx(), var5_4, var11_41, true, var9_39, false, var10_40, false);
                    var14_43 = var13_42.zzb - (long)((Integer)zzaq.zzj.zza(null)).intValue();
                    if (var14_43 > 0L) {
                        if (var14_43 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many events logged. appId, count", zzes.zza((String)var5_4), (Object)var13_42.zzb);
                        }
                        this.zze().b_();
                        return;
                    }
                    if (var9_39 && (var14_43 = var13_42.zza - (long)((Integer)zzaq.zzl.zza(null)).intValue()) > 0L) {
                        if (var14_43 % 1000L == 1L) {
                            this.zzj.zzr().zzf().zza("Data loss. Too many public events logged. appId, count", zzes.zza((String)var5_4), (Object)var13_42.zza);
                        }
                        this.zzj.zzi().zza(var5_4, 16, "_ev", var1_1.zza, 0);
                        this.zze().b_();
                        return;
                    }
                    if (var10_40) {
                        var24_12 = var2_2.zza;
                        var25_15 = this.zzj.zzb().zzb(var24_12, zzaq.zzk);
                        var14_43 = var13_42.zzd - (long)Math.max(0, var25_15 = Math.min(1000000, var25_15));
                        if (var14_43 > 0L) {
                            if (var14_43 == 1L) {
                                this.zzj.zzr().zzf().zza("Too many error events logged. appId, count", zzes.zza((String)var5_4), (Object)var13_42.zzd);
                            }
                            this.zze().b_();
                            return;
                        }
                    }
                    var16_44 = var1_1.zzb.zzb();
                    this.zzj.zzi().zza(var16_44, "_o", (Object)var1_1.zzc);
                    if (this.zzj.zzi().zzf(var5_4)) {
                        this.zzj.zzi().zza(var16_44, "_dbg", (Object)1L);
                        this.zzj.zzi().zza(var16_44, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var17_45 = this.zze().zzc(var2_2.zza, "_sno")) != null && var17_45.zze instanceof Long) {
                        this.zzj.zzi().zza(var16_44, "_sno", var17_45.zze);
                    }
                    if ((var17_46 = this.zze().zzc(var5_4)) > 0L) {
                        this.zzj.zzr().zzi().zza("Data lost. Too many events stored on disk, deleted. appId", zzes.zza((String)var5_4), (Object)var17_46);
                    }
                    var19_47 = new zzal(this.zzj, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var16_44);
                    var20_48 = this.zze().zza(var5_4, var19_47.zzb);
                    if (var20_48 == null) {
                        if (this.zze().zzh(var5_4) >= (long)this.zzj.zzb().zza(var5_4) && var9_39) {
                            this.zzj.zzr().zzf().zza("Too many event names used, ignoring event. appId, name, supported count", zzes.zza((String)var5_4), (Object)this.zzj.zzj().zza(var19_47.zzb), (Object)this.zzj.zzb().zza(var5_4));
                            this.zzj.zzi().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var21_49 = new zzak(var5_4, var19_47.zzb, 0L, 0L, var19_47.zzc, 0L, null, null, null, null);
                    } else {
                        var19_47 = var19_47.zza(this.zzj, var20_48.zzf);
                        var21_49 = var20_48.zza(var19_47.zzc);
                    }
                    this.zze().zza(var21_49);
                    var25_16 = var2_2;
                    var24_12 = var19_47;
                    var23_11 = this;
                    var23_11.zzw();
                    var23_11.zzk();
                    Preconditions.checkNotNull((Object)var24_12);
                    Preconditions.checkNotNull((Object)var25_16);
                    Preconditions.checkNotEmpty((String)var24_12.zza);
                    Preconditions.checkArgument((boolean)var24_12.zza.equals(var25_16.zza));
                    var26_18 = zzbs.zzg.zzbf().zza(1).zza("android");
                    if (!TextUtils.isEmpty((CharSequence)var25_16.zza)) {
                        var26_18.zzf(var25_16.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var25_16.zzd)) {
                        var26_18.zze(var25_16.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var25_16.zzc)) {
                        var26_18.zzg(var25_16.zzc);
                    }
                    if (var25_16.zzj != -2147483648L) {
                        var26_18.zzh((int)var25_16.zzj);
                    }
                    var26_18.zzf(var25_16.zze);
                    if (!TextUtils.isEmpty((CharSequence)var25_16.zzb)) {
                        var26_18.zzk(var25_16.zzb);
                    }
                    if (zzlb.zzb() && var23_11.zzj.zzb().zze(var25_16.zza, zzaq.zzbo)) {
                        if (TextUtils.isEmpty((CharSequence)var26_18.zzl()) && !TextUtils.isEmpty((CharSequence)var25_16.zzv)) {
                            var26_18.zzp(var25_16.zzv);
                        }
                        if (TextUtils.isEmpty((CharSequence)var26_18.zzl()) && TextUtils.isEmpty((CharSequence)var26_18.zzo()) && !TextUtils.isEmpty((CharSequence)var25_16.zzr)) {
                            var26_18.zzo(var25_16.zzr);
                        }
                    } else if (TextUtils.isEmpty((CharSequence)var26_18.zzl()) && !TextUtils.isEmpty((CharSequence)var25_16.zzr)) {
                        var26_18.zzo(var25_16.zzr);
                    }
                    if (var25_16.zzf != 0L) {
                        var26_18.zzh(var25_16.zzf);
                    }
                    var26_18.zzk(var25_16.zzt);
                    if (var23_11.zzj.zzb().zze(var25_16.zza, zzaq.zzaw) && (var27_29 = var23_11.zzh().zzf()) != null) {
                        var26_18.zzd((Iterable<? extends Integer>)var27_29);
                    }
                    if ((var27_29 = var23_11.zzj.zzc().zza(var25_16.zza)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var27_29.first))) {
                        if (var25_16.zzo) {
                            var26_18.zzh((String)var27_29.first);
                            if (var27_29.second != null) {
                                var26_18.zza((Boolean)var27_29.second);
                            }
                        }
                    } else if (!var23_11.zzj.zzx().zza(var23_11.zzj.zzn()) && var25_16.zzp) {
                        var28_21 = Settings.Secure.getString((ContentResolver)var23_11.zzj.zzn().getContentResolver(), (String)"android_id");
                        if (var28_21 == null) {
                            var23_11.zzj.zzr().zzi().zza("null secure ID. appId", zzes.zza((String)var26_18.zzj()));
                            var28_21 = "null";
                        } else if (var28_21.isEmpty()) {
                            var23_11.zzj.zzr().zzi().zza("empty secure ID. appId", zzes.zza((String)var26_18.zzj()));
                        }
                        var26_18.zzm(var28_21);
                    }
                    var23_11.zzj.zzx().zzaa();
                    v3 = var26_18.zzc(Build.MODEL);
                    var23_11.zzj.zzx().zzaa();
                    v3.zzb(Build.VERSION.RELEASE).zzf((int)var23_11.zzj.zzx().zzf()).zzd(var23_11.zzj.zzx().zzg());
                    if (!var23_11.zzj.zzb().zza(zzaq.zzcm)) {
                        var26_18.zzj(var25_16.zzl);
                    }
                    if (var23_11.zzj.zzab()) {
                        var26_18.zzj();
                        if (!TextUtils.isEmpty(null)) {
                            var26_18.zzn(null);
                        }
                    }
                    if ((var28_22 = var23_11.zze().zzb(var25_16.zza)) == null) {
                        var28_22 = new zzf(var23_11.zzj, var25_16.zza);
                        var28_22.zza(var23_11.zzj.zzi().zzk());
                        var28_22.zzf(var25_16.zzk);
                        var28_22.zzb(var25_16.zzb);
                        var28_22.zze(var23_11.zzj.zzc().zzb(var25_16.zza));
                        var28_22.zzg(0L);
                        var28_22.zza(0L);
                        var28_22.zzb(0L);
                        var28_22.zzg(var25_16.zzc);
                        var28_22.zzc(var25_16.zzj);
                        var28_22.zzh(var25_16.zzd);
                        var28_22.zzd(var25_16.zze);
                        var28_22.zze(var25_16.zzf);
                        var28_22.zza(var25_16.zzh);
                        if (!var23_11.zzj.zzb().zza(zzaq.zzcm)) {
                            var28_22.zzp(var25_16.zzl);
                        }
                        var28_22.zzf(var25_16.zzt);
                        var23_11.zze().zza(var28_22);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var28_22.zzd())) {
                        var26_18.zzi(var28_22.zzd());
                    }
                    if (!TextUtils.isEmpty((CharSequence)var28_22.zzi())) {
                        var26_18.zzl(var28_22.zzi());
                    }
                    var29_23 = var23_11.zze().zza(var25_16.zza);
                    for (var30_27 = 0; var30_27 < var29_23.size(); ++var30_27) {
                        var31_30 /* !! */  = zzbs.zzk.zzj().zza(((zzkj)var29_23.get((int)var30_27)).zzc).zza(((zzkj)var29_23.get((int)var30_27)).zzd);
                        var23_11.zzh().zza((zzbs.zzk.zza)var31_30 /* !! */ , ((zzkj)var29_23.get((int)var30_27)).zze);
                        var26_18.zza((zzbs.zzk.zza)var31_30 /* !! */ );
                    }
                    try {
                        var30_28 = var23_11.zze().zza((zzbs.zzg)((com.google.android.gms.internal.measurement.zzfe)var26_18.zzv()));
                    }
                    catch (IOException var32_38) {
                        var23_11.zzj.zzr().zzf().zza("Data loss. Failed to insert raw event metadata. appId", zzes.zza((String)var26_18.zzj()), (Object)var32_38);
                        break block74;
                    }
                    v4 = var23_11.zze();
                    var34_50 = var24_12;
                    var33_51 = var23_11;
                    if (var34_50.zze == null) ** GOTO lbl-1000
                    for (Object var36_52 : var34_50.zze) {
                        if (!"_r".equals(var36_52)) continue;
                        v5 = true;
                        break block75;
                    }
                    var35_32 = var33_51.zzc().zzc(var34_50.zza, var34_50.zzb);
                    var36_52 = var33_51.zze().zza(super.zzx(), var34_50.zza, false, false, false, false, false);
                    if (var35_32 && var36_52.zze < (long)var33_51.zzj.zzb().zzb(var34_50.zza)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzal)var24_12, var30_28, v5)) {
                    var23_11.zzm = 0L;
                }
            }
            this.zze().b_();
        }
        finally {
            this.zze().zzh();
        }
        this.zzz();
        this.zzj.zzr().zzx().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzl() {
        this.zzw();
        this.zzk();
        this.zzs = true;
        try {
            String string;
            long l;
            zzx zzx2 = this.zzj.zzu();
            Boolean bl = this.zzj.zzw().zzag();
            if (bl == null) {
                this.zzj.zzr().zzi().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj.zzr().zzf().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzm > 0L) {
                this.zzz();
                return;
            }
            zzgt zzgt2 = this;
            zzgt2.zzw();
            if (zzgt2.zzv != null) {
                this.zzj.zzr().zzx().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzd().zzf()) {
                this.zzj.zzr().zzx().zza("Network not connected, ignoring upload request");
                this.zzz();
                return;
            }
            long l2 = this.zzj.zzm().currentTimeMillis();
            int n = this.zzj.zzb().zzb(null, zzaq.zzap);
            long l3 = l2 - zzy.zzv();
            for (int i = 0; i < n && this.zza(null, l = l3); ++i) {
            }
            long l4 = this.zzj.zzc().zzc.zza();
            if (l4 != 0L) {
                this.zzj.zzr().zzw().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l2 - l4));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zze().d_()))) {
                if (this.zzx == -1L) {
                    this.zzx = this.zze().zzaa();
                }
                Object object = string;
                int n2 = this.zzj.zzb().zzb((String)object, zzaq.zzf);
                object = string;
                zzgt2 = this.zzj.zzb();
                int n3 = Math.max(0, zzgt2.zzb((String)object, zzaq.zzg));
                List<Pair<zzbs.zzg, Long>> list = this.zze().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    String string2 = null;
                    Object object5 = list.iterator();
                    while (object5.hasNext()) {
                        object4 = (zzbs.zzg)((Object)object5.next().first);
                        if (TextUtils.isEmpty((CharSequence)object4.zzad())) continue;
                        string2 = object4.zzad();
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            zzbs.zzg zzg2 = (zzbs.zzg)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) || zzg2.zzad().equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object5 = zzbs.zzf.zzb();
                    int n4 = list.size();
                    object4 = new ArrayList(list.size());
                    boolean bl2 = this.zzj.zzb().zzf(string);
                    for (int i = 0; i < n4; ++i) {
                        object3 = (zzbs.zzg.zza)((zzbs.zzg)((Object)list.get((int)i).first)).zzbl();
                        object4.add((Long)list.get((int)i).second);
                        zzx2 = this.zzj.zzu();
                        ((zzbs.zzg.zza)((Object)object3)).zzg(this.zzj.zzb().zzf()).zza(l2).zzb(false);
                        if (!bl2) {
                            ((zzbs.zzg.zza)((Object)object3)).zzn();
                        }
                        if (this.zzj.zzb().zze(string, zzaq.zzay)) {
                            object2 = ((zzbs.zzg)((com.google.android.gms.internal.measurement.zzfe)object3.zzv())).zzbi();
                            ((zzbs.zzg.zza)((Object)object3)).zzl(this.zzh().zza((byte[])object2));
                        }
                        ((zzbs.zzf.zza)((Object)object5)).zza((zzbs.zzg.zza)((Object)object3));
                    }
                    String string3 = null;
                    if (this.zzj.zzr().zza(2)) {
                        string3 = this.zzh().zza((zzbs.zzf)((com.google.android.gms.internal.measurement.zzfe)object5.zzv()));
                    }
                    this.zzh();
                    object3 = ((zzbs.zzf)((com.google.android.gms.internal.measurement.zzfe)object5.zzv())).zzbi();
                    object2 = (String)zzaq.zzp.zza(null);
                    try {
                        URL uRL = new URL((String)object2);
                        object = object4;
                        zzgt2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzgt2.zzv != null) {
                            zzgt2.zzj.zzr().zzf().zza("Set uploading progress before finishing the previous upload");
                        } else {
                            zzgt2.zzv = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzj.zzc().zzd.zza(l2);
                        String string4 = "?";
                        if (n4 > 0) {
                            string4 = ((zzbs.zzf.zza)((Object)object5)).zza(0).zzx();
                        }
                        this.zzj.zzr().zzx().zza("Uploading data. app, uncompressed size, data", (Object)string4, (Object)((Object)object3).length, (Object)string3);
                        this.zzr = true;
                        zzkc zzkc2 = new zzkc(this, string);
                        Object object6 = object3;
                        URL uRL2 = uRL;
                        object = string;
                        zzgt2 = this.zzd();
                        zzgt2.zzd();
                        zzgt2.zzak();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)object6);
                        Preconditions.checkNotNull((Object)zzkc2);
                        zzgt2.zzq().zzb((Runnable)new zzfd((zzez)zzgt2, (String)object, uRL2, (byte[])object6, null, zzkc2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj.zzr().zzf().zza("Failed to parse upload URL. Not uploading. appId", zzes.zza((String)string), object2);
                    }
                }
            } else {
                zzf zzf2;
                this.zzx = -1L;
                String string5 = this.zze().zza(l2 - zzy.zzv());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzf2 = this.zze().zzb(string5)) != null) {
                    this.zza(zzf2);
                }
            }
            return;
        }
        finally {
            this.zzs = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final boolean zza(String string, long l) {
        this.zze().zzf();
        try {
            block157: {
                zzf zzf2;
                int n;
                String[] stringArray;
                String string2;
                Object object;
                Object object2;
                Object object3;
                zza zza2;
                block155: {
                    zza2 = new zza(null);
                    object3 = zza2;
                    long l2 = this.zzx;
                    long l3 = l;
                    String string3 = null;
                    object2 = this.zze();
                    Preconditions.checkNotNull((Object)object3);
                    object2.zzd();
                    ((zzkb)((Object)object2)).zzak();
                    try (Cursor cursor = null;){
                        String string4;
                        Object object4;
                        Object[] objectArray;
                        object = ((zzad)((Object)object2)).c_();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            object4 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = object.rawQuery(new StringBuilder(148 + String.valueOf(object4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append((String)object4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block155;
                            string3 = cursor.getString(0);
                            string2 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            object4 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = object.rawQuery(new StringBuilder(84 + String.valueOf(object4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append((String)object4).append(" order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block155;
                            string2 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = object.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string3, string2}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzf().zza("Raw event metadata record is missing. appId", zzes.zza((String)string3));
                            break block155;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            object4 = (zzbs.zzg)((com.google.android.gms.internal.measurement.zzfe)zzki.zza(zzbs.zzg.zzbf(), (byte[])objectArray).zzv());
                        }
                        catch (IOException iOException) {
                            object2.zzr().zzf().zza("Data loss. Failed to merge raw event metadata. appId", zzes.zza((String)string3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block155;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzr().zzi().zza("Get multiple raw event metadata records, expected one. appId", zzes.zza((String)string3));
                        }
                        cursor.close();
                        object3.zza((zzbs.zzg)((Object)object4));
                        if (l2 != -1L) {
                            string4 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string3, string2, String.valueOf(l2)};
                        } else {
                            string4 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string3, string2};
                        }
                        cursor = object.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string4, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzr().zzi().zza("Raw event data disappeared while in transaction. appId", zzes.zza((String)string3));
                            break block155;
                        }
                        do {
                            zzbs.zzc.zza zza3;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zza3 = zzki.zza(zzbs.zzc.zzj(), (byte[])objectArray);
                            }
                            catch (IOException iOException) {
                                object2.zzr().zzf().zza("Data loss. Failed to merge raw event. appId", zzes.zza((String)string3), (Object)iOException);
                                continue;
                            }
                            zza3.zza(cursor.getString(1)).zza(cursor.getLong(2));
                            if (!object3.zza(l4, (zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza3.zzv()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzc == null || ((zza)object2).zzc.isEmpty()) break block157;
                boolean bl = false;
                zzbs.zzg.zza zza4 = ((zzbs.zzg.zza)zza2.zza.zzbl()).zzc();
                int n2 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzj.zzb().zze(zza2.zza.zzx(), zzaq.zzau);
                zzbs.zzc.zza zzgo3 = null;
                int n3 = -1;
                zzbs.zzc.zza zza5 = null;
                int n4 = -1;
                for (n = 0; n < zza2.zzc.size(); ++n) {
                    Object object5;
                    boolean bl3;
                    zzbs.zzc.zza zzgo22;
                    block159: {
                        boolean bl4;
                        block158: {
                            boolean bl5;
                            bl4 = bl;
                            zzgo22 = (zzbs.zzc.zza)zza2.zzc.get(n).zzbl();
                            if (this.zzc().zzb(zza2.zza.zzx(), zzgo22.zzd())) {
                                this.zzj.zzr().zzi().zza("Dropping blacklisted raw event. appId", zzes.zza((String)zza2.zza.zzx()), (Object)this.zzj.zzj().zza(zzgo22.zzd()));
                                if (this.zzc().zzg(zza2.zza.zzx()) || this.zzc().zzh(zza2.zza.zzx()) || "_err".equals(zzgo22.zzd())) continue;
                                this.zzj.zzi().zza(zza2.zza.zzx(), 11, "_ev", zzgo22.zzd(), 0);
                                continue;
                            }
                            bl3 = this.zzc().zzc(zza2.zza.zzx(), zzgo22.zzd());
                            if (bl3) break block158;
                            this.zzh();
                            object2 = zzgo22.zzd();
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl5 = true;
                                    break;
                                }
                                default: {
                                    bl5 = false;
                                }
                            }
                            if (!bl5) break block159;
                        }
                        boolean l6 = false;
                        boolean bl6 = false;
                        for (int i = 0; i < zzgo22.zzb(); ++i) {
                            zzbs.zze zze2;
                            if ("_c".equals(zzgo22.zza(i).zzb())) {
                                zze2 = (zzbs.zze)((com.google.android.gms.internal.measurement.zzfe)((zzbs.zze.zza)zzgo22.zza(i).zzbl()).zza(1L).zzv());
                                l6 = true;
                                zzgo22.zza(i, zze2);
                                continue;
                            }
                            if (!"_r".equals(zzgo22.zza(i).zzb())) continue;
                            zze2 = (zzbs.zze)((com.google.android.gms.internal.measurement.zzfe)((zzbs.zze.zza)zzgo22.zza(i).zzbl()).zza(1L).zzv());
                            bl6 = true;
                            zzgo22.zza(i, zze2);
                        }
                        if (!l6 && bl3) {
                            this.zzj.zzr().zzx().zza("Marking event as conversion", (Object)this.zzj.zzj().zza(zzgo22.zzd()));
                            zzgo22.zza(zzbs.zze.zzk().zza("_c").zza(1L));
                        }
                        if (!bl6) {
                            this.zzj.zzr().zzx().zza("Marking event as real-time", (Object)this.zzj.zzj().zza(zzgo22.zzd()));
                            zzgo22.zza(zzbs.zze.zzk().zza("_r").zza(1L));
                        }
                        bl = true;
                        if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zzj.zzb().zzb(zza2.zza.zzx())) {
                            zzka.zza(zzgo22, "_r");
                            bl = bl4;
                        }
                        if (zzkm.zza((String)zzgo22.zzd()) && bl3) {
                            String string5 = zza2.zza.zzx();
                            if (this.zze().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zzj.zzb().zzb(string5, zzaq.zzm)) {
                                this.zzj.zzr().zzi().zza("Too many conversions. Not logging as conversion. appId", zzes.zza((String)zza2.zza.zzx()));
                                boolean bl7 = false;
                                zzbs.zze.zza zza3 = null;
                                int n5 = -1;
                                for (int i = 0; i < zzgo22.zzb(); ++i) {
                                    zzbs.zze zze3 = zzgo22.zza(i);
                                    if ("_c".equals(zze3.zzb())) {
                                        zza3 = (zzbs.zze.zza)zze3.zzbl();
                                        n5 = i;
                                        continue;
                                    }
                                    if (!"_err".equals(zze3.zzb())) continue;
                                    bl7 = true;
                                }
                                if (bl7 && zza3 != null) {
                                    int n6 = n5;
                                    zzgo22.zzb(n6);
                                } else if (zza3 != null) {
                                    zzbs.zze zze4 = (zzbs.zze)((com.google.android.gms.internal.measurement.zzfe)((zzbs.zze.zza)((zzfe.zza)zza3.clone())).zza("_err").zza(10L).zzv());
                                    zzgo22.zza(n5, zze4);
                                } else {
                                    this.zzj.zzr().zzf().zza("Did not find conversion parameter. appId", zzes.zza((String)zza2.zza.zzx()));
                                }
                            }
                        }
                    }
                    if (bl3) {
                        int n6;
                        zzbs.zzc.zza zzgo4 = zzgo22;
                        object2 = this;
                        object5 = new ArrayList<zzbs.zze>(zzgo4.zza());
                        int i = -1;
                        int n9 = -1;
                        for (n6 = 0; n6 < object5.size(); ++n6) {
                            if ("value".equals(((zzbs.zze)((Object)object5.get(n6))).zzb())) {
                                i = n6;
                                continue;
                            }
                            if (!"currency".equals(((zzbs.zze)((Object)object5.get(n6))).zzb())) continue;
                            n9 = n6;
                        }
                        if (i != -1) {
                            if (!((zzbs.zze)((Object)object5.get(i))).zze() && !((zzbs.zze)((Object)object5.get(i))).zzg()) {
                                ((zzka)object2).zzj.zzr().zzk().zza("Value must be specified with a numeric type.");
                                int n10 = i;
                                zzgo4.zzb(n10);
                                zzka.zza(zzgo4, "_c");
                                zzka.zza(zzgo4, 18, "value");
                            } else {
                                n6 = 0;
                                if (n9 == -1) {
                                    n6 = 1;
                                } else {
                                    object3 = ((zzbs.zze)((Object)object5.get(n9))).zzd();
                                    if (((String)object3).length() != 3) {
                                        n6 = 1;
                                    } else {
                                        int n11;
                                        for (i = 0; i < ((String)object3).length(); i += Character.charCount(n11)) {
                                            n11 = ((String)object3).codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n6 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n6 != 0) {
                                    ((zzka)object2).zzj.zzr().zzk().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    int n12 = i;
                                    zzgo4.zzb(n12);
                                    zzka.zza(zzgo4, "_c");
                                    zzka.zza(zzgo4, 19, "currency");
                                }
                            }
                        }
                    }
                    if (this.zzj.zzb().zze(zza2.zza.zzx(), zzaq.zzat)) {
                        if ("_e".equals(zzgo22.zzd())) {
                            this.zzh();
                            if (zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zzgo22.zzv()), "_fr") == null) {
                                if (zza5 != null && Math.abs(zza5.zzf() - zzgo22.zzf()) <= 1000L) {
                                    zzbs.zzc.zza l13 = (zzbs.zzc.zza)((zzfe.zza)zza5.clone());
                                    if (this.zza(zzgo22, l13)) {
                                        zzgo3 = null;
                                        zza5 = null;
                                        zza4.zza(n4, l13);
                                    } else {
                                        zzgo3 = zzgo22;
                                        n3 = n2;
                                    }
                                } else {
                                    zzgo3 = zzgo22;
                                    n3 = n2;
                                }
                            }
                        } else if ("_vs".equals(zzgo22.zzd())) {
                            this.zzh();
                            if (zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zzgo22.zzv()), "_et") == null) {
                                if (zzgo3 != null && Math.abs(zzgo3.zzf() - zzgo22.zzf()) <= 1000L) {
                                    zzbs.zzc.zza zzb2 = (zzbs.zzc.zza)((zzfe.zza)zzgo3.clone());
                                    if (this.zza(zzb2, zzgo22)) {
                                        zzgo3 = null;
                                        zza5 = null;
                                        zza4.zza(n3, zzb2);
                                    } else {
                                        zza5 = zzgo22;
                                        n4 = n2;
                                    }
                                } else {
                                    zza5 = zzgo22;
                                    n4 = n2;
                                }
                            }
                        } else if (this.zzj.zzb().zze(zza2.zza.zzx(), zzaq.zzbs) && "_ab".equals(zzgo22.zzd())) {
                            this.zzh();
                            if (zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zzgo22.zzv()), "_et") == null && zzgo3 != null && Math.abs(zzgo3.zzf() - zzgo22.zzf()) <= 4000L) {
                                String string6;
                                zzbs.zzc.zza zza6 = (zzbs.zzc.zza)((zzfe.zza)zzgo3.clone());
                                this.zzb(zza6, zzgo22);
                                object5 = zzgo22;
                                zzbs.zzc.zza zza10 = zza6;
                                object2 = this;
                                Preconditions.checkArgument((boolean)"_e".equals(zza10.zzd()));
                                ((zzka)object2).zzh();
                                zzbs.zze sQLiteException = zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza10.zzv()), "_sn");
                                ((zzka)object2).zzh();
                                zzbs.zze zze6 = zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza10.zzv()), "_sc");
                                ((zzka)object2).zzh();
                                zzbs.zze zze5 = zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza10.zzv()), "_si");
                                object3 = sQLiteException != null ? sQLiteException.zzd() : "";
                                if (!TextUtils.isEmpty((CharSequence)object3)) {
                                    ((zzka)object2).zzh().zza((zzbs.zzc.zza)((Object)object5), "_sn", object3);
                                }
                                if (!TextUtils.isEmpty((CharSequence)(string6 = zze6 != null ? zze6.zzd() : ""))) {
                                    ((zzka)object2).zzh().zza((zzbs.zzc.zza)((Object)object5), "_sc", string6);
                                }
                                if (zze5 != null) {
                                    ((zzka)object2).zzh().zza((zzbs.zzc.zza)((Object)object5), "_si", zze5.zzf());
                                }
                                zzgo3 = null;
                                zza4.zza(n3, zza6);
                            }
                        }
                    }
                    if (!bl2 && "_e".equals(zzgo22.zzd())) {
                        if (zzgo22.zzb() == 0) {
                            this.zzj.zzr().zzi().zza("Engagement event does not contain any parameters. appId", zzes.zza((String)zza2.zza.zzx()));
                        } else {
                            Long l2 = (Long)this.zzh().zzb((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zzgo22.zzv()), "_et");
                            if (l2 == null) {
                                this.zzj.zzr().zzi().zza("Engagement event does not include duration. appId", zzes.zza((String)zza2.zza.zzx()));
                            } else {
                                l5 += l2.longValue();
                            }
                        }
                    }
                    zza2.zzc.set(n, (zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zzgo22.zzv()));
                    ++n2;
                    zza4.zza(zzgo22);
                }
                if (bl2) {
                    for (n = 0; n < n2; ++n) {
                        Long l3;
                        zzbs.zzc zzc2 = zza4.zzb(n);
                        if ("_e".equals(zzc2.zzc())) {
                            this.zzh();
                            if (zzki.zza(zzc2, "_fr") != null) {
                                zza4.zzc(n);
                                --n2;
                                --n;
                                continue;
                            }
                        }
                        this.zzh();
                        zzbs.zze string8 = zzki.zza(zzc2, "_et");
                        if (string8 == null || (l3 = string8.zze() ? Long.valueOf(string8.zzf()) : null) == null || l3 <= 0L) continue;
                        l5 += l3.longValue();
                    }
                }
                this.zza(zza4, l5, false);
                n = 0;
                for (zzbs.zzc zzc2 : zza4.zza()) {
                    if (!"_s".equals(zzc2.zzc())) continue;
                    n = 1;
                    break;
                }
                if (n != 0) {
                    this.zze().zzb(zza4.zzj(), "_se");
                }
                if (zzki.zza(zza4, "_sid") >= 0) {
                    this.zza(zza4, l5, true);
                } else {
                    int n7 = zzki.zza(zza4, "_se");
                    if (n7 >= 0) {
                        zza4.zze(n7);
                        this.zzj.zzr().zzf().zza("Session engagement user property is in the bundle without session ID. appId", zzes.zza((String)zza2.zza.zzx()));
                    }
                }
                Object object6 = zza4;
                object2 = this.zzh();
                object2.zzr().zzx().zza("Checking account type status for ad personalization signals");
                if (((zzjy)((Object)object2)).zzj().zze(((zzbs.zzg.zza)((Object)object6)).zzj()) && (zzf2 = ((zzjy)((Object)object2)).zzi().zzb(((zzbs.zzg.zza)((Object)object6)).zzj())) != null && zzf2.zzaf() && object2.zzl().zzj()) {
                    object2.zzr().zzw().zza("Turning off ad personalization due to account type");
                    zzbs.zzk zzk2 = (zzbs.zzk)((com.google.android.gms.internal.measurement.zzfe)zzbs.zzk.zzj().zza("_npa").zza(object2.zzl().zzh()).zzb(1L).zzv());
                    boolean bl9 = false;
                    for (int i = 0; i < ((zzbs.zzg.zza)((Object)object6)).zze(); ++i) {
                        if (!"_npa".equals(((zzbs.zzg.zza)((Object)object6)).zzd(i).zzc())) continue;
                        ((zzbs.zzg.zza)((Object)object6)).zza(i, zzk2);
                        bl9 = true;
                        break;
                    }
                    if (!bl9) {
                        ((zzbs.zzg.zza)((Object)object6)).zza(zzk2);
                    }
                }
                if (this.zzj.zzb().zze(zza4.zzj(), zzaq.zzbn)) {
                    zzka.zza(zza4);
                }
                zza4.zzm().zzc(this.zzf().zza(zza4.zzj(), zza4.zza(), zza4.zzd(), zza4.zzf(), zza4.zzg()));
                if (this.zzj.zzb().zzg(zza2.zza.zzx())) {
                    zza zza11 = zza2;
                    object6 = zza4;
                    object2 = this;
                    HashMap<Object, String> hashMap = new HashMap<Object, String>();
                    ArrayList<zzbs.zzc> arrayList = new ArrayList<zzbs.zzc>();
                    SecureRandom secureRandom = ((zzka)object2).zzj.zzi().zzh();
                    for (int i = 0; i < ((zzbs.zzg.zza)((Object)object6)).zzb(); ++i) {
                        Long l8;
                        boolean bl8;
                        int n14;
                        long l9;
                        long l10;
                        zzbs.zzc.zza zza12;
                        block156: {
                            zza12 = (zzbs.zzc.zza)((zzbs.zzg.zza)((Object)object6)).zzb(i).zzbl();
                            if (zza12.zzd().equals("_ep")) {
                                object = (String)((zzka)object2).zzh().zzb((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza12.zzv()), "_en");
                                string2 = (zzak)hashMap.get(object);
                                if (string2 == null) {
                                    string2 = ((zzka)object2).zze().zza(zza11.zza.zzx(), (String)object);
                                    hashMap.put(object, string2);
                                }
                                if (((zzak)string2).zzi == null) {
                                    if (((zzak)string2).zzj > 1L) {
                                        ((zzka)object2).zzh().zza(zza12, "_sr", ((zzak)string2).zzj);
                                    }
                                    if (((zzak)string2).zzk != null && ((zzak)string2).zzk.booleanValue()) {
                                        ((zzka)object2).zzh().zza(zza12, "_efs", 1L);
                                    }
                                    arrayList.add((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza12.zzv()));
                                }
                                ((zzbs.zzg.zza)((Object)object6)).zza(i, zza12);
                                continue;
                            }
                            l10 = ((zzka)object2).zzc().zzf(zza11.zza.zzx());
                            ((zzka)object2).zzj.zzi();
                            l9 = zzkm.zza((long)zza12.zzf(), (long)l10);
                            n14 = 1;
                            Long l4 = 1L;
                            String string3 = "_dbg";
                            zzbs.zzc zzc3 = (zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza12.zzv());
                            if (TextUtils.isEmpty((CharSequence)string3) || l4 == null) {
                                bl8 = false;
                            } else {
                                for (zzbs.zze zze6 : zzc3.zza()) {
                                    if (!string3.equals(zze6.zzb())) continue;
                                    bl8 = l4 instanceof Long && ((Object)l4).equals(zze6.zzf()) || l4 instanceof String && ((Object)l4).equals(zze6.zzd()) || l4 instanceof Double && ((Object)l4).equals(zze6.zzh());
                                    break block156;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n14 = ((zzka)object2).zzc().zzd(zza11.zza.zzx(), zza12.zzd());
                        }
                        if (n14 <= 0) {
                            ((zzka)object2).zzj.zzr().zzi().zza("Sample rate must be positive. event, rate", (Object)zza12.zzd(), (Object)n14);
                            arrayList.add((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza12.zzv()));
                            ((zzbs.zzg.zza)((Object)object6)).zza(i, zza12);
                            continue;
                        }
                        stringArray = (String[])hashMap.get(zza12.zzd());
                        if (stringArray == null && (stringArray = ((zzka)object2).zze().zza(zza11.zza.zzx(), zza12.zzd())) == null) {
                            ((zzka)object2).zzj.zzr().zzi().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)zza11.zza.zzx(), (Object)zza12.zzd());
                            stringArray = new zzak(zza11.zza.zzx(), zza12.zzd(), 1L, 1L, 1L, zza12.zzf(), 0L, null, null, null, null);
                        }
                        Boolean bl9 = (l8 = (Long)((zzka)object2).zzh().zzb((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza12.zzv()), "_eid")) != null;
                        if (n14 == 1) {
                            arrayList.add((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza12.zzv()));
                            if (bl9.booleanValue() && (stringArray.zzi != null || stringArray.zzj != null || stringArray.zzk != null)) {
                                stringArray = stringArray.zza(null, null, null);
                                hashMap.put(zza12.zzd(), (String)stringArray);
                            }
                            ((zzbs.zzg.zza)((Object)object6)).zza(i, zza12);
                            continue;
                        }
                        if (secureRandom.nextInt(n14) == 0) {
                            ((zzka)object2).zzh().zza(zza12, "_sr", n14);
                            arrayList.add((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza12.zzv()));
                            if (bl9.booleanValue()) {
                                stringArray = stringArray.zza(null, Long.valueOf(n14), null);
                            }
                            hashMap.put(zza12.zzd(), (String)stringArray.zza(zza12.zzf(), l9));
                        } else {
                            long l12;
                            if (stringArray.zzh != null) {
                                l12 = stringArray.zzh;
                            } else {
                                ((zzka)object2).zzj.zzi();
                                l12 = zzkm.zza((long)zza12.zzg(), (long)l10);
                            }
                            if (l12 != l9) {
                                ((zzka)object2).zzh().zza(zza12, "_efs", 1L);
                                ((zzka)object2).zzh().zza(zza12, "_sr", n14);
                                arrayList.add((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza12.zzv()));
                                if (bl9.booleanValue()) {
                                    stringArray = stringArray.zza(null, Long.valueOf(n14), Boolean.valueOf(true));
                                }
                                hashMap.put(zza12.zzd(), (String)stringArray.zza(zza12.zzf(), l9));
                            } else if (bl9.booleanValue()) {
                                hashMap.put(zza12.zzd(), (String)stringArray.zza(l8, null, null));
                            }
                        }
                        ((zzbs.zzg.zza)((Object)object6)).zza(i, zza12);
                    }
                    if (arrayList.size() < ((zzbs.zzg.zza)((Object)object6)).zzb()) {
                        ((zzbs.zzg.zza)((Object)object6)).zzc().zza(arrayList);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ((zzka)object2).zze().zza((zzak)entry.getValue());
                    }
                }
                if (!this.zzj.zzb().zze(zza4.zzj(), zzaq.zzbn)) {
                    zzka.zza(zza4);
                }
                String string4 = zza2.zza.zzx();
                zzf zzf3 = this.zze().zzb(string4);
                if (zzf3 == null) {
                    this.zzj.zzr().zzf().zza("Bundling raw events w/o app info. appId", zzes.zza((String)zza2.zza.zzx()));
                } else if (zza4.zzb() > 0) {
                    long l6 = zzf3.zzk();
                    if (l6 != 0L) {
                        zza4.zze(l6);
                    } else {
                        zza4.zzi();
                    }
                    long l7 = zzf3.zzj();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    if (l7 != 0L) {
                        zza4.zzd(l7);
                    } else {
                        zza4.zzh();
                    }
                    zzf3.zzv();
                    zza4.zzg((int)zzf3.zzs());
                    zzf3.zza(zza4.zzf());
                    zzf3.zzb(zza4.zzg());
                    String string5 = zzf3.zzad();
                    if (string5 != null) {
                        zza4.zzj(string5);
                    } else {
                        zza4.zzk();
                    }
                    this.zze().zza(zzf3);
                }
                if (zza4.zzb() > 0) {
                    zzx zzx2 = this.zzj.zzu();
                    zzbq.zzb zzb2 = this.zzc().zza(zza2.zza.zzx());
                    if (zzb2 == null || !zzb2.zza()) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zza.zzam())) {
                            zza4.zzi(-1L);
                        } else {
                            this.zzj.zzr().zzi().zza("Did not find measurement config or missing version info. appId", zzes.zza((String)zza2.zza.zzx()));
                        }
                    } else {
                        zza4.zzi(zzb2.zzb());
                    }
                    this.zze().zza((zzbs.zzg)((com.google.android.gms.internal.measurement.zzfe)zza4.zzv()), bl);
                }
                object6 = zza2.zzb;
                object2 = this.zze();
                Preconditions.checkNotNull((Object)object6);
                object2.zzd();
                ((zzkb)((Object)object2)).zzak();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int i = 0; i < object6.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object6.get(i));
                }
                stringBuilder.append(")");
                int n15 = ((zzad)((Object)object2)).c_().delete("raw_events", stringBuilder.toString(), null);
                if (n15 != object6.size()) {
                    object2.zzr().zzf().zza("Deleted fewer rows from raw events table than expected", (Object)n15, (Object)object6.size());
                }
                object6 = string4;
                object2 = this.zze();
                stringBuilder = ((zzad)((Object)object2)).c_();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object6, object6});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzr().zzf().zza("Failed to remove unused event metadata. appId", zzes.zza((String)object6), (Object)sQLiteException);
                }
                this.zze().b_();
                return true;
            }
            this.zze().b_();
            return false;
        }
        finally {
            this.zze().zzh();
        }
    }

    private static void zza(zzbs.zzg.zza zza2) {
        zza2.zzb(Long.MAX_VALUE).zzc(Long.MIN_VALUE);
        for (int i = 0; i < zza2.zzb(); ++i) {
            zzbs.zzc zzc2 = zza2.zzb(i);
            if (zzc2.zze() < zza2.zzf()) {
                zza2.zzb(zzc2.zze());
            }
            if (zzc2.zze() <= zza2.zzg()) continue;
            zza2.zzc(zzc2.zze());
        }
    }

    @VisibleForTesting
    private final void zza(zzbs.zzg.zza zza2, long l, boolean bl) {
        zzkj zzkj2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzkj2 = (zzkj2 = this.zze().zzc(zza2.zzj(), string)) == null || zzkj2.zze == null ? new zzkj(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)l) : new zzkj(zza2.zzj(), "auto", string, this.zzj.zzm().currentTimeMillis(), (Object)((Long)zzkj2.zze + l));
        zzbs.zzk zzk2 = (zzbs.zzk)((com.google.android.gms.internal.measurement.zzfe)zzbs.zzk.zzj().zza(string).zza(this.zzj.zzm().currentTimeMillis()).zzb((Long)zzkj2.zze).zzv());
        boolean bl2 = false;
        int n = zzki.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzk2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzk2);
        }
        if (l > 0L) {
            this.zze().zza(zzkj2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj.zzr().zzx().zza("Updated engagement user property. scope, value", (Object)string2, zzkj2.zze);
        }
    }

    private final boolean zza(zzbs.zzc.zza zza2, zzbs.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzd()));
        this.zzh();
        zzbs.zze zze2 = zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza2.zzv()), "_sc");
        String string = zze2 == null ? null : zze2.zzd();
        this.zzh();
        zzbs.zze zze3 = zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza3.zzv()), "_pc");
        String string2 = zze3 == null ? null : zze3.zzd();
        if (string2 != null && string2.equals(string)) {
            this.zzb(zza2, zza3);
            return true;
        }
        return false;
    }

    private final void zzb(zzbs.zzc.zza zza2, zzbs.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zzd()));
        this.zzh();
        zzbs.zze zze2 = zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza2.zzv()), "_et");
        if (!zze2.zze() || zze2.zzf() <= 0L) {
            return;
        }
        long l = zze2.zzf();
        this.zzh();
        zze2 = zzki.zza((zzbs.zzc)((com.google.android.gms.internal.measurement.zzfe)zza3.zzv()), "_et");
        if (zze2 != null && zze2.zzf() > 0L) {
            l += zze2.zzf();
        }
        this.zzh().zza(zza3, "_et", l);
        this.zzh().zza(zza2, "_fr", 1L);
    }

    @VisibleForTesting
    private static void zza(zzbs.zzc.zza zza2, @NonNull String string) {
        List<zzbs.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzb())) continue;
            int n = i;
            zza2.zzb(n);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzbs.zzc.zza zza2, int n, String string) {
        List<zzbs.zze> list = zza2.zza();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzb())) continue;
            return;
        }
        zzbs.zze zze2 = (zzbs.zze)((com.google.android.gms.internal.measurement.zzfe)zzbs.zze.zzk().zza("_err").zza(n).zzv());
        zzbs.zze zze3 = (zzbs.zze)((com.google.android.gms.internal.measurement.zzfe)zzbs.zze.zzk().zza("_ev").zzb(string).zzv());
        zza2.zza(zze2).zza(zze3);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzw();
        this.zzk();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzv;
            this.zzv = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
                    this.zzj.zzc().zzd.zza(0L);
                    this.zzz();
                    this.zzj.zzr().zzx().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zze().zzf();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzad zzad2 = this.zze();
                                zzad2.zzd();
                                zzad2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzad2.c_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzad2.zzr().zzf().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzw != null && this.zzw.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zze().b_();
                    }
                    finally {
                        this.zze().zzh();
                    }
                    this.zzw = null;
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzx = -1L;
                        this.zzz();
                    }
                    this.zzm = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj.zzr().zzf().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzm = this.zzj.zzm().elapsedRealtime();
                    this.zzj.zzr().zzx().zza("Disable upload, time", (Object)this.zzm);
                }
            } else {
                this.zzj.zzr().zzx().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                }
                this.zze().zza(list);
                this.zzz();
            }
            return;
        }
        finally {
            this.zzr = false;
            this.zzaa();
        }
    }

    private final boolean zzy() {
        this.zzw();
        this.zzk();
        return this.zze().zzy() || !TextUtils.isEmpty((CharSequence)this.zze().d_());
    }

    @WorkerThread
    private final void zza(zzf zzf2) {
        this.zzw();
        if (zzlb.zzb() && this.zzj.zzb().zze(zzf2.zzc(), zzaq.zzbo)) {
            if (TextUtils.isEmpty((CharSequence)zzf2.zze()) && TextUtils.isEmpty((CharSequence)zzf2.zzg()) && TextUtils.isEmpty((CharSequence)zzf2.zzf())) {
                this.zza(zzf2.zzc(), 204, null, null, null);
                return;
            }
        } else if (TextUtils.isEmpty((CharSequence)zzf2.zze()) && TextUtils.isEmpty((CharSequence)zzf2.zzf())) {
            this.zza(zzf2.zzc(), 204, null, null, null);
            return;
        }
        String string = this.zzj.zzb().zza(zzf2);
        try {
            URL uRL = new URL(string);
            this.zzj.zzr().zzx().zza("Fetching remote configuration", (Object)zzf2.zzc());
            zzbq.zzb zzb2 = this.zzc().zza(zzf2.zzc());
            ArrayMap arrayMap = null;
            String string2 = this.zzc().zzb(zzf2.zzc());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            this.zzq = true;
            zzkf zzkf2 = new zzkf(this);
            ArrayMap arrayMap2 = arrayMap;
            URL uRL2 = uRL;
            String string3 = zzf2.zzc();
            zzez zzez2 = this.zzd();
            zzez2.zzd();
            zzez2.zzak();
            Preconditions.checkNotNull((Object)uRL2);
            Preconditions.checkNotNull((Object)zzkf2);
            zzez2.zzq().zzb((Runnable)new zzfd(zzez2, string3, uRL2, null, (Map)arrayMap2, zzkf2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj.zzr().zzf().zza("Failed to parse config URL. Not fetching. appId", zzes.zza((String)zzf2.zzc()), (Object)string);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj.zzr().zzx().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zze().zzf();
            try {
                boolean bl;
                zzf zzf2 = this.zze().zzb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzf2 == null) {
                    this.zzj.zzr().zzi().zza("App does not exist in onConfigFetched. appId", zzes.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzc().zza(string) == null && !this.zzc().zza(string, null, null) : !this.zzc().zza(string, byArray, string2)) {
                        return;
                    }
                    zzf2.zzh(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzf2);
                    if (n == 404) {
                        this.zzj.zzr().zzk().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj.zzr().zzx().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzd().zzf() && this.zzy()) {
                        this.zzl();
                    } else {
                        this.zzz();
                    }
                } else {
                    zzf2.zzi(this.zzj.zzm().currentTimeMillis());
                    this.zze().zza(zzf2);
                    this.zzj.zzr().zzx().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzc().zzc(string);
                    this.zzj.zzc().zzd.zza(this.zzj.zzm().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc().zze.zza(this.zzj.zzm().currentTimeMillis());
                    }
                    this.zzz();
                }
                this.zze().b_();
            }
            finally {
                this.zze().zzh();
            }
            return;
        }
        finally {
            this.zzq = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final void zzz() {
        long l;
        long l2;
        long l3;
        block14: {
            String string;
            this.zzw();
            this.zzk();
            if (this.zzm > 0L) {
                l3 = this.zzj.zzm().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzm);
                if (l2 > 0L) {
                    this.zzj.zzr().zzx().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzt().zzb();
                    this.zzv().zzf();
                    return;
                }
                this.zzm = 0L;
            }
            if (!this.zzj.zzag() || !this.zzy()) {
                this.zzj.zzr().zzx().zza("Nothing to upload or uploading impossible");
                this.zzt().zzb();
                this.zzv().zzf();
                return;
            }
            zzka zzka2 = this;
            long l4 = zzka2.zzj.zzm().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzaq.zzz.zza(null));
            boolean bl = zzka2.zze().zzz() || zzka2.zze().zzk();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzka2.zzj.zzb().zzw())) && !".none.".equals(string) ? Math.max(0L, (Long)zzaq.zzu.zza(null)) : Math.max(0L, (Long)zzaq.zzt.zza(null))) : Math.max(0L, (Long)zzaq.zzs.zza(null));
            long l7 = zzka2.zzj.zzc().zzc.zza();
            long l8 = zzka2.zzj.zzc().zzd.zza();
            long l9 = zzka2.zze().zzw();
            long l10 = zzka2.zze().zzx();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzka2.zzh().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzaq.zzab.zza(null))); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzaq.zzaa.zza(null)) * l15) <= l8) continue;
                        l = l14;
                        break block14;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj.zzr().zzx().zza("Next upload time is 0");
            this.zzt().zzb();
            this.zzv().zzf();
            return;
        }
        if (!this.zzd().zzf()) {
            this.zzj.zzr().zzx().zza("No network");
            this.zzt().zza();
            this.zzv().zzf();
            return;
        }
        l2 = this.zzj.zzc().zze.zza();
        long l16 = Math.max(0L, (Long)zzaq.zzq.zza(null));
        if (!this.zzh().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzt().zzb();
        long l17 = l3 - this.zzj.zzm().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzaq.zzv.zza(null));
            this.zzj.zzc().zzc.zza(this.zzj.zzm().currentTimeMillis());
        }
        this.zzj.zzr().zzx().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzv().zza(l17);
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzw();
        if (this.zzn == null) {
            this.zzn = new ArrayList<Runnable>();
        }
        this.zzn.add(runnable);
    }

    @WorkerThread
    private final void zzaa() {
        this.zzw();
        if (this.zzq || this.zzr || this.zzs) {
            this.zzj.zzr().zzx().zza("Not stopping services. fetch, network, upload", (Object)this.zzq, (Object)this.zzr, (Object)this.zzs);
            return;
        }
        this.zzj.zzr().zzx().zza("Stopping uploading service(s)");
        if (this.zzn == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzn.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzn.clear();
    }

    @WorkerThread
    private final Boolean zzb(zzf zzf2) {
        try {
            if (zzf2.zzm() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzf2.zzc(), (int)0).versionCode;
                if (zzf2.zzm() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzj.zzn()).getPackageInfo((String)zzf2.zzc(), (int)0).versionName;
                if (zzf2.zzl() != null && zzf2.zzl().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @WorkerThread
    final void zzo() {
        int n;
        this.zzw();
        this.zzk();
        if (this.zzl) return;
        this.zzl = true;
        if (!this.zzab()) return;
        int n2 = this.zza(this.zzu);
        int n3 = n = this.zzj.zzy().zzaf();
        int n4 = n2;
        zzka zzka2 = this;
        zzka2.zzw();
        if (n4 > n3) {
            zzka2.zzj.zzr().zzf().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzka2.zza(n3, zzka2.zzu)) {
            zzka2.zzj.zzr().zzf().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzka2.zzj.zzr().zzx().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzab() {
        this.zzw();
        if (this.zzj.zzb().zza(zzaq.zzbm) && this.zzt != null && this.zzt.isValid()) {
            this.zzj.zzr().zzx().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzj.zzn().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzu = new RandomAccessFile(file2, "rw").getChannel();
            this.zzt = this.zzu.tryLock();
            if (this.zzt != null) {
                this.zzj.zzr().zzx().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj.zzr().zzf().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj.zzr().zzf().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj.zzr().zzi().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj.zzr().zzi().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzw();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzr().zzf().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            if (this.zzj.zzb().zza(zzaq.zzbz) && Build.VERSION.SDK_INT <= 19) {
                fileChannel.position(0L);
            }
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj.zzr().zzf().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj.zzr().zzf().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(zzn zzn2) {
        if (this.zzv != null) {
            this.zzw = new ArrayList<Long>();
            this.zzw.addAll(this.zzv);
        }
        String string = zzn2.zza;
        zzad zzad2 = this.zze();
        Preconditions.checkNotEmpty((String)string);
        zzad2.zzd();
        zzad2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzad2.c_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzad2.zzr().zzx().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzad2.zzr().zzf().zza("Error resetting analytics data. appId, error", zzes.zza((String)string), (Object)sQLiteException);
        }
        if (zzn2.zzh) {
            this.zzb(zzn2);
        }
    }

    @WorkerThread
    final void zza(zzkh zzkh2, zzn zzn2) {
        this.zzw();
        this.zzk();
        if (!this.zze(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        int n = this.zzj.zzi().zzc(zzkh2.zza);
        if (n != 0) {
            this.zzj.zzi();
            String string = zzkm.zza((String)zzkh2.zza, (int)24, (boolean)true);
            int n2 = zzkh2.zza != null ? zzkh2.zza.length() : 0;
            this.zzj.zzi().zza(zzn2.zza, n, "_ev", string, n2);
            return;
        }
        n = this.zzj.zzi().zzb(zzkh2.zza, zzkh2.zza());
        if (n != 0) {
            this.zzj.zzi();
            String string = zzkm.zza((String)zzkh2.zza, (int)24, (boolean)true);
            Object object = zzkh2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzj.zzi().zza(zzn2.zza, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzj.zzi().zzc(zzkh2.zza, zzkh2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzkh2.zza)) {
            zzak zzak2;
            zzn zzn3 = zzn2;
            String string = zzkh2.zze;
            long l = zzkh2.zzb;
            zzka zzka2 = this;
            long l2 = 0L;
            zzkj zzkj2 = zzka2.zze().zzc(zzn3.zza, "_sno");
            if (zzkj2 != null && zzkj2.zze instanceof Long) {
                l2 = (Long)zzkj2.zze;
            } else {
                if (zzkj2 != null) {
                    zzka2.zzj.zzr().zzi().zza("Retrieved last session number from database does not contain a valid (long) value", zzkj2.zze);
                }
                if ((zzak2 = zzka2.zze().zza(zzn3.zza, "_s")) != null) {
                    l2 = zzak2.zzc;
                    zzka2.zzj.zzr().zzx().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzak2 = new zzkh("_sno", l, (Object)(++l2), string);
            zzka2.zza((zzkh)zzak2, zzn3);
        }
        zzkj zzkj3 = new zzkj(zzn2.zza, zzkh2.zze, zzkh2.zza, zzkh2.zzb, object);
        this.zzj.zzr().zzx().zza("Setting user property", (Object)this.zzj.zzj().zzc(zzkj3.zzc), object);
        this.zze().zzf();
        try {
            this.zzc(zzn2);
            boolean bl = this.zze().zza(zzkj3);
            this.zze().b_();
            if (!bl) {
                this.zzj.zzr().zzf().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzj.zzj().zzc(zzkj3.zzc), zzkj3.zze);
                this.zzj.zzi().zza(zzn2.zza, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzkh zzkh2, zzn zzn2) {
        this.zzw();
        this.zzk();
        if (!this.zze(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        if ("_npa".equals(zzkh2.zza) && zzn2.zzs != null) {
            this.zzj.zzr().zzw().zza("Falling back to manifest metadata value for ad personalization");
            zzkh zzkh3 = new zzkh("_npa", this.zzj.zzm().currentTimeMillis(), (Object)(zzn2.zzs != false ? 1L : 0L), "auto");
            this.zza(zzkh3, zzn2);
            return;
        }
        this.zzj.zzr().zzw().zza("Removing user property", (Object)this.zzj.zzj().zzc(zzkh2.zza));
        this.zze().zzf();
        try {
            this.zzc(zzn2);
            this.zze().zzb(zzn2.zza, zzkh2.zza);
            this.zze().b_();
            this.zzj.zzr().zzw().zza("User property removed", (Object)this.zzj.zzj().zzc(zzkh2.zza));
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    final void zza(zzkb zzkb2) {
        ++this.zzo;
    }

    final void zzp() {
        ++this.zzp;
    }

    final zzfw zzs() {
        return this.zzj;
    }

    @WorkerThread
    final void zzb(zzn zzn2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        if (!this.zze(zzn2)) {
            return;
        }
        zzf zzf2 = this.zze().zzb(zzn2.zza);
        if (zzf2 != null && TextUtils.isEmpty((CharSequence)zzf2.zze()) && !TextUtils.isEmpty((CharSequence)zzn2.zzb)) {
            zzf2.zzh(0L);
            this.zze().zza(zzf2);
            this.zzc().zzd(zzn2.zza);
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        long l = zzn2.zzm;
        if (l == 0L) {
            l = this.zzj.zzm().currentTimeMillis();
        }
        this.zzj.zzx().zzi();
        int n = zzn2.zzn;
        if (n != 0 && n != 1) {
            this.zzj.zzr().zzi().zza("Incorrect app type, assuming installed app. appId, appType", zzes.zza((String)zzn2.zza), (Object)n);
            n = 0;
        }
        this.zze().zzf();
        try {
            zzkh zzkh2;
            zzkj zzkj2 = this.zze().zzc(zzn2.zza, "_npa");
            if (zzkj2 == null || "auto".equals(zzkj2.zzb)) {
                if (zzn2.zzs != null) {
                    zzkh2 = new zzkh("_npa", l, (Object)(zzn2.zzs != false ? 1L : 0L), "auto");
                    if (zzkj2 == null || !zzkj2.zze.equals(zzkh2.zzc)) {
                        this.zza(zzkh2, zzn2);
                    }
                } else if (zzkj2 != null) {
                    zzkh2 = new zzkh("_npa", l, null, "auto");
                    this.zzb(zzkh2, zzn2);
                }
            }
            long l2 = l;
            zzn zzn3 = zzn2;
            zzka zzka2 = this;
            zzf zzf3 = zzka2.zze().zzb(zzn3.zza);
            if (zzf3 != null) {
                zzka2.zzj.zzi();
                if (zzkm.zza((String)zzn3.zzb, (String)zzf3.zze(), (String)zzn3.zzr, (String)zzf3.zzf())) {
                    zzka2.zzj.zzr().zzi().zza("New GMP App Id passed in. Removing cached database data. appId", zzes.zza((String)zzf3.zzc()));
                    String string = zzf3.zzc();
                    zzad zzad2 = zzka2.zze();
                    zzad2.zzak();
                    zzad2.zzd();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzad2.c_();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzad2.zzr().zzx().zza("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzad2.zzr().zzf().zza("Error deleting application data. appId, error", zzes.zza((String)string), (Object)sQLiteException);
                    }
                    zzf3 = null;
                }
            }
            if (zzf3 != null && (zzf3.zzm() != Integer.MIN_VALUE && zzf3.zzm() != zzn3.zzj) | (zzf3.zzm() == Integer.MIN_VALUE && zzf3.zzl() != null && !zzf3.zzl().equals(zzn3.zzc))) {
                Bundle bundle = new Bundle();
                bundle.putString("_pv", zzf3.zzl());
                zzao zzao2 = new zzao("_au", new zzan(bundle), "auto", l2);
                zzka2.zza(zzao2, zzn3);
            }
            this.zzc(zzn2);
            zzkh2 = null;
            if (n == 0) {
                zzkh2 = this.zze().zza(zzn2.zza, "_f");
            } else if (n == 1) {
                zzkh2 = this.zze().zza(zzn2.zza, "_v");
            }
            if (zzkh2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    PackageInfo packageInfo;
                    zzkh zzkh3 = new zzkh("_fot", l, (Object)l3, "auto");
                    this.zza(zzkh3, zzn2);
                    if (this.zzj.zzb().zze(zzn2.zzb, zzaq.zzar)) {
                        zzn3 = zzn2;
                        zzka2 = this;
                        zzka2.zzw();
                        zzka2.zzj.zzf().zza(zzn3.zza);
                    }
                    l2 = l;
                    zzn3 = zzn2;
                    zzka2 = this;
                    zzka2.zzw();
                    zzka2.zzk();
                    zzf3 = new Bundle();
                    zzf3.putLong("_c", 1L);
                    zzf3.putLong("_r", 1L);
                    zzf3.putLong("_uwa", 0L);
                    zzf3.putLong("_pfo", 0L);
                    zzf3.putLong("_sys", 0L);
                    zzf3.putLong("_sysu", 0L);
                    if (zzka2.zzj.zzb().zze(zzn3.zza, zzaq.zzat)) {
                        zzf3.putLong("_et", 1L);
                    }
                    if (zzn3.zzq) {
                        zzf3.putLong("_dac", 1L);
                    }
                    String string = zzn3.zza;
                    zzad zzad3 = zzka2.zze();
                    Preconditions.checkNotEmpty((String)string);
                    zzad3.zzd();
                    zzad3.zzak();
                    long l4 = zzad3.zzh(string, "first_open_count");
                    if (zzka2.zzj.zzn().getPackageManager() == null) {
                        zzka2.zzj.zzr().zzf().zza("PackageManager is null, first open report might be inaccurate. appId", zzes.zza((String)zzn3.zza));
                    } else {
                        packageInfo = null;
                        try {
                            packageInfo = Wrappers.packageManager((Context)zzka2.zzj.zzn()).getPackageInfo(zzn3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzka2.zzj.zzr().zzf().zza("Package info is null, first open report might be inaccurate. appId", zzes.zza((String)zzn3.zza), (Object)nameNotFoundException);
                        }
                        if (packageInfo != null && packageInfo.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                                if (zzka2.zzj.zzb().zza(zzaq.zzbt)) {
                                    if (l4 == 0L) {
                                        zzf3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    zzf3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl = true;
                            }
                            zzkh zzkh4 = new zzkh("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzka2.zza(zzkh4, zzn3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzka2.zzj.zzn()).getApplicationInfo(zzn3.zza, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzka2.zzj.zzr().zzf().zza("Application info is null, first open report might be inaccurate. appId", zzes.zza((String)zzn3.zza), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzf3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzf3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l4 >= 0L) {
                        zzf3.putLong("_pfo", l4);
                    }
                    packageInfo = new zzao("_f", new zzan((Bundle)zzf3), "auto", l2);
                    zzka2.zza((zzao)packageInfo, zzn3);
                } else if (n == 1) {
                    zzkh zzkh5 = new zzkh("_fvt", l, (Object)l3, "auto");
                    this.zza(zzkh5, zzn2);
                    l2 = l;
                    zzn3 = zzn2;
                    zzka2 = this;
                    zzka2.zzw();
                    zzka2.zzk();
                    zzf3 = new Bundle();
                    zzf3.putLong("_c", 1L);
                    zzf3.putLong("_r", 1L);
                    if (zzka2.zzj.zzb().zze(zzn3.zza, zzaq.zzat)) {
                        zzf3.putLong("_et", 1L);
                    }
                    if (zzn3.zzq) {
                        zzf3.putLong("_dac", 1L);
                    }
                    zzao zzao3 = new zzao("_v", new zzan((Bundle)zzf3), "auto", l2);
                    zzka2.zza(zzao3, zzn3);
                }
                if (!this.zzj.zzb().zze(zzn2.zza, zzaq.zzau)) {
                    l2 = l;
                    zzn3 = zzn2;
                    zzka2 = this;
                    zzf3 = new Bundle();
                    zzf3.putLong("_et", 1L);
                    if (zzka2.zzj.zzb().zze(zzn3.zza, zzaq.zzat)) {
                        zzf3.putLong("_fr", 1L);
                    }
                    zzao zzao4 = new zzao("_e", new zzan((Bundle)zzf3), "auto", l2);
                    zzka2.zza(zzao4, zzn3);
                }
            } else if (zzn2.zzi) {
                l2 = l;
                zzn3 = zzn2;
                zzka2 = this;
                zzf3 = new Bundle();
                zzao zzao5 = new zzao("_cd", new zzan((Bundle)zzf3), "auto", l2);
                zzka2.zza(zzao5, zzn3);
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    private final zzn zza(String string) {
        zzf zzf2 = this.zze().zzb(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzl())) {
            this.zzj.zzr().zzw().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzb(zzf2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj.zzr().zzf().zza("App version does not match; dropping. appId", zzes.zza((String)string));
            return null;
        }
        return new zzn(string, zzf2.zze(), zzf2.zzl(), zzf2.zzm(), zzf2.zzn(), zzf2.zzo(), zzf2.zzp(), null, zzf2.zzr(), false, zzf2.zzi(), zzf2.zzae(), 0L, 0, zzf2.zzaf(), zzf2.zzag(), false, zzf2.zzf(), zzf2.zzah(), zzf2.zzq(), zzf2.zzai(), zzlb.zzb() && this.zzj.zzb().zze(string, zzaq.zzbo) ? zzf2.zzg() : null);
    }

    @WorkerThread
    final void zza(zzw zzw2) {
        zzn zzn2 = this.zza(zzw2.zza);
        if (zzn2 != null) {
            this.zza(zzw2, zzn2);
        }
    }

    @WorkerThread
    final void zza(zzw zzw2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotEmpty((String)zzw2.zza);
        Preconditions.checkNotNull((Object)zzw2.zzb);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        Preconditions.checkNotEmpty((String)zzw2.zzc.zza);
        this.zzw();
        this.zzk();
        if (!this.zze(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        zzw zzw3 = new zzw(zzw2);
        new zzw(zzw2).zze = false;
        this.zze().zzf();
        try {
            boolean bl = false;
            zzw zzw4 = this.zze().zzd(zzw3.zza, zzw3.zzc.zza);
            if (zzw4 != null && !zzw4.zzb.equals(zzw3.zzb)) {
                this.zzj.zzr().zzi().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzj.zzj().zzc(zzw3.zzc.zza), (Object)zzw3.zzb, (Object)zzw4.zzb);
            }
            if (zzw4 != null && zzw4.zze) {
                zzw3.zzb = zzw4.zzb;
                zzw3.zzd = zzw4.zzd;
                zzw3.zzh = zzw4.zzh;
                zzw3.zzf = zzw4.zzf;
                zzw3.zzi = zzw4.zzi;
                zzw3.zze = zzw4.zze;
                zzw3.zzc = new zzkh(zzw3.zzc.zza, zzw4.zzc.zzb, zzw3.zzc.zza(), zzw4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzw3.zzf)) {
                zzw3.zzc = new zzkh(zzw3.zzc.zza, zzw3.zzd, zzw3.zzc.zza(), zzw3.zzc.zze);
                zzw3.zze = true;
                bl = true;
            }
            if (zzw3.zze) {
                zzkh zzkh2 = zzw3.zzc;
                zzkj zzkj2 = new zzkj(zzw3.zza, zzw3.zzb, zzkh2.zza, zzkh2.zzb, zzkh2.zza());
                if (this.zze().zza(zzkj2)) {
                    this.zzj.zzr().zzw().zza("User property updated immediately", (Object)zzw3.zza, (Object)this.zzj.zzj().zzc(zzkj2.zzc), zzkj2.zze);
                } else {
                    this.zzj.zzr().zzf().zza("(2)Too many active user properties, ignoring", zzes.zza((String)zzw3.zza), (Object)this.zzj.zzj().zzc(zzkj2.zzc), zzkj2.zze);
                }
                if (bl && zzw3.zzi != null) {
                    zzao zzao2 = new zzao(zzw3.zzi, zzw3.zzd);
                    this.zzb(zzao2, zzn2);
                }
            }
            if (this.zze().zza(zzw3)) {
                this.zzj.zzr().zzw().zza("Conditional property added", (Object)zzw3.zza, (Object)this.zzj.zzj().zzc(zzw3.zzc.zza), zzw3.zzc.zza());
            } else {
                this.zzj.zzr().zzf().zza("Too many conditional properties, ignoring", zzes.zza((String)zzw3.zza), (Object)this.zzj.zzj().zzc(zzw3.zzc.zza), zzw3.zzc.zza());
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    @WorkerThread
    final void zzb(zzw zzw2) {
        zzn zzn2 = this.zza(zzw2.zza);
        if (zzn2 != null) {
            this.zzb(zzw2, zzn2);
        }
    }

    @WorkerThread
    final void zzb(zzw zzw2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotEmpty((String)zzw2.zza);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        Preconditions.checkNotEmpty((String)zzw2.zzc.zza);
        this.zzw();
        this.zzk();
        if (!this.zze(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zzc(zzn2);
            return;
        }
        this.zze().zzf();
        try {
            this.zzc(zzn2);
            zzw zzw3 = this.zze().zzd(zzw2.zza, zzw2.zzc.zza);
            if (zzw3 != null) {
                this.zzj.zzr().zzw().zza("Removing conditional user property", (Object)zzw2.zza, (Object)this.zzj.zzj().zzc(zzw2.zzc.zza));
                this.zze().zze(zzw2.zza, zzw2.zzc.zza);
                if (zzw3.zze) {
                    this.zze().zzb(zzw2.zza, zzw2.zzc.zza);
                }
                if (zzw2.zzk != null) {
                    Bundle bundle = null;
                    if (zzw2.zzk.zzb != null) {
                        bundle = zzw2.zzk.zzb.zzb();
                    }
                    zzao zzao2 = this.zzj.zzi().zza(zzw2.zza, zzw2.zzk.zza, bundle, zzw3.zzb, zzw2.zzk.zzd, true, false);
                    this.zzb(zzao2, zzn2);
                }
            } else {
                this.zzj.zzr().zzi().zza("Conditional user property doesn't exist", zzes.zza((String)zzw2.zza), (Object)this.zzj.zzj().zzc(zzw2.zzc.zza));
            }
            this.zze().b_();
            return;
        }
        finally {
            this.zze().zzh();
        }
    }

    private final zzf zza(zzn zzn2, zzf zzf2, String string) {
        boolean bl = false;
        if (zzf2 == null) {
            zzf2 = new zzf(this.zzj, zzn2.zza);
            zzf2.zza(this.zzj.zzi().zzk());
            zzf2.zze(string);
            bl = true;
        } else if (!string.equals(zzf2.zzh())) {
            zzf2.zze(string);
            zzf2.zza(this.zzj.zzi().zzk());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzn2.zzb, (CharSequence)zzf2.zze())) {
            zzf2.zzb(zzn2.zzb);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzn2.zzr, (CharSequence)zzf2.zzf())) {
            zzf2.zzc(zzn2.zzr);
            bl = true;
        }
        if (zzlb.zzb() && this.zzj.zzb().zze(zzf2.zzc(), zzaq.zzbo) && !TextUtils.equals((CharSequence)zzn2.zzv, (CharSequence)zzf2.zzg())) {
            zzf2.zzd(zzn2.zzv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzk) && !zzn2.zzk.equals(zzf2.zzi())) {
            zzf2.zzf(zzn2.zzk);
            bl = true;
        }
        if (zzn2.zze != 0L && zzn2.zze != zzf2.zzo()) {
            zzf2.zzd(zzn2.zze);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzc) && !zzn2.zzc.equals(zzf2.zzl())) {
            zzf2.zzg(zzn2.zzc);
            bl = true;
        }
        if (zzn2.zzj != zzf2.zzm()) {
            zzf2.zzc(zzn2.zzj);
            bl = true;
        }
        if (zzn2.zzd != null && !zzn2.zzd.equals(zzf2.zzn())) {
            zzf2.zzh(zzn2.zzd);
            bl = true;
        }
        if (zzn2.zzf != zzf2.zzp()) {
            zzf2.zze(zzn2.zzf);
            bl = true;
        }
        if (zzn2.zzh != zzf2.zzr()) {
            zzf2.zza(zzn2.zzh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzg) && !zzn2.zzg.equals(zzf2.zzac())) {
            zzf2.zzi(zzn2.zzg);
            bl = true;
        }
        if (!this.zzj.zzb().zza(zzaq.zzcm) && zzn2.zzl != zzf2.zzae()) {
            zzf2.zzp(zzn2.zzl);
            bl = true;
        }
        if (zzn2.zzo != zzf2.zzaf()) {
            zzf2.zzb(zzn2.zzo);
            bl = true;
        }
        if (zzn2.zzp != zzf2.zzag()) {
            zzf2.zzc(zzn2.zzp);
            bl = true;
        }
        if (zzn2.zzs != zzf2.zzah()) {
            zzf2.zza(zzn2.zzs);
            bl = true;
        }
        if (zzn2.zzt != 0L && zzn2.zzt != zzf2.zzq()) {
            zzf2.zzf(zzn2.zzt);
            bl = true;
        }
        if (bl) {
            this.zze().zza(zzf2);
        }
        return zzf2;
    }

    @WorkerThread
    final zzf zzc(zzn zzn2) {
        this.zzw();
        this.zzk();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        zzf zzf2 = this.zze().zzb(zzn2.zza);
        String string = this.zzj.zzc().zzb(zzn2.zza);
        if (zzkk.zzb() && this.zzj.zzb().zza(zzaq.zzbu)) {
            if (zzf2 == null) {
                zzf2 = new zzf(this.zzj, zzn2.zza);
                zzf2.zza(this.zzj.zzi().zzk());
                zzf2.zze(string);
            } else if (!string.equals(zzf2.zzh())) {
                zzf2.zze(string);
                zzf2.zza(this.zzj.zzi().zzk());
            }
            zzf2.zzb(zzn2.zzb);
            zzf2.zzc(zzn2.zzr);
            if (zzlb.zzb() && this.zzj.zzb().zze(zzf2.zzc(), zzaq.zzbo)) {
                zzf2.zzd(zzn2.zzv);
            }
            if (!TextUtils.isEmpty((CharSequence)zzn2.zzk)) {
                zzf2.zzf(zzn2.zzk);
            }
            if (zzn2.zze != 0L) {
                zzf2.zzd(zzn2.zze);
            }
            if (!TextUtils.isEmpty((CharSequence)zzn2.zzc)) {
                zzf2.zzg(zzn2.zzc);
            }
            zzf2.zzc(zzn2.zzj);
            if (zzn2.zzd != null) {
                zzf2.zzh(zzn2.zzd);
            }
            zzf2.zze(zzn2.zzf);
            zzf2.zza(zzn2.zzh);
            if (!TextUtils.isEmpty((CharSequence)zzn2.zzg)) {
                zzf2.zzi(zzn2.zzg);
            }
            if (!this.zzj.zzb().zza(zzaq.zzcm)) {
                zzf2.zzp(zzn2.zzl);
            }
            zzf2.zzb(zzn2.zzo);
            zzf2.zzc(zzn2.zzp);
            zzf2.zza(zzn2.zzs);
            zzf2.zzf(zzn2.zzt);
            if (zzf2.zza()) {
                this.zze().zza(zzf2);
            }
            return zzf2;
        }
        return this.zza(zzn2, zzf2, string);
    }

    final String zzd(zzn zzn2) {
        Future future = this.zzj.zzq().zza((Callable)new zzke(this, zzn2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj.zzr().zzf().zza("Failed to get app instance id. appId", zzes.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    final void zza(boolean bl) {
        this.zzz();
    }

    private final boolean zze(zzn zzn2) {
        if (zzlb.zzb() && this.zzj.zzb().zze(zzn2.zza, zzaq.zzbo)) {
            return !TextUtils.isEmpty((CharSequence)zzn2.zzb) || !TextUtils.isEmpty((CharSequence)zzn2.zzv) || !TextUtils.isEmpty((CharSequence)zzn2.zzr);
        }
        return !TextUtils.isEmpty((CharSequence)zzn2.zzb) || !TextUtils.isEmpty((CharSequence)zzn2.zzr);
    }

    static /* synthetic */ void zza(zzka zzka2, zzkg zzkg2) {
        zzka2.zza(zzkg2);
    }

    final class zza
    implements zzaf {
        zzbs.zzg zza;
        List<Long> zzb;
        List<zzbs.zzc> zzc;
        private long zzd;

        private zza() {
        }

        @Override
        public final void zza(zzbs.zzg zzg2) {
            Preconditions.checkNotNull((Object)((Object)zzg2));
            this.zza = zzg2;
        }

        @Override
        public final boolean zza(long l, zzbs.zzc zzc2) {
            Preconditions.checkNotNull((Object)((Object)zzc2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzbs.zzc>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (this.zzc.size() > 0 && com.google.android.gms.measurement.internal.zzka$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzka$zza.zza(zzc2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzc2.zzbm();
            if (l2 >= (long)Math.max(0, (Integer)zzaq.zzh.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzc2);
            this.zzb.add(l);
            return this.zzc.size() < Math.max(1, (Integer)zzaq.zzi.zza(null));
        }

        private static long zza(zzbs.zzc zzc2) {
            return zzc2.zze() / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzkd zzkd2) {
            this();
        }
    }
}

