/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgc
extends zzeo {
    private final zzkg zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzgc(zzkg zzkg2) {
        this(zzkg2, null);
    }

    private zzgc(zzkg zzkg2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzkg2);
        this.zza = zzkg2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgb(this, zzm2));
    }

    @BinderThread
    public final void zza(zzaq zzaq2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzaq2);
        this.zzb(zzm2, false);
        this.zza(new zzgk(this, zzaq2, zzm2));
    }

    @VisibleForTesting
    final zzaq zzb(zzaq zzaq2, zzm zzm2) {
        String string;
        zzm zzm3 = zzm2;
        zzaq zzaq3 = zzaq2;
        zzgc zzgc2 = this;
        if (!"_cmp".equals(zzaq3.zza) || zzaq3.zzb == null || zzaq3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzaq3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzgc2.zza.zzb().zze(zzm3.zza, zzas.zzar)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzaq2.toString());
            return new zzaq("_cmpx", zzaq2.zzb, zzaq2.zzc, zzaq2.zzd);
        }
        return zzaq2;
    }

    @BinderThread
    public final void zza(zzaq zzaq2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzaq2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgj(this, zzaq2, string));
    }

    @BinderThread
    public final byte[] zza(zzaq zzaq2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzaq2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzaq2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzgm(this, zzaq2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzet.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzaq2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzet.zza((String)string), (Object)this.zza.zzi().zza(zzaq2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkn zzkn2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzkn2);
        this.zzb(zzm2, false);
        this.zza(new zzgl(this, zzkn2, zzm2));
    }

    @BinderThread
    public final List<zzkn> zza(zzm zzm2, boolean bl) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgo(this, zzm2));
        try {
            List list = (List)future.get();
            ArrayList<zzkn> arrayList = new ArrayList<zzkn>(list.size());
            for (zzkp zzkp2 : list) {
                if (!bl && zzko.zze((String)zzkp2.zzc)) continue;
                arrayList.add(new zzkn(zzkp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user properties. appId", zzet.zza((String)zzm2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgn(this, zzm2));
    }

    @BinderThread
    private final void zzb(zzm zzm2, boolean bl) {
        Preconditions.checkNotNull((Object)zzm2);
        this.zza(zzm2.zza, false);
        this.zza.zzj().zza(zzm2.zzb, zzm2.zzr, zzm2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgc zzgc2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgc2 = this;
                    if (!bl2) break block9;
                    if (zzgc2.zzb == null) {
                        zzgc2.zzb = "com.google.android.gms".equals(zzgc2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzgc2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgc2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgc2.zzb.booleanValue()) break block10;
                }
                if (zzgc2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgc2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgc2.zzc = string2;
                }
                if (!string2.equals(zzgc2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzet.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgq(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzm zzm2) {
        this.zzb(zzm2, false);
        return this.zza.zzd(zzm2);
    }

    @BinderThread
    public final void zza(zzy zzy2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzy2);
        Preconditions.checkNotNull((Object)zzy2.zzc);
        this.zzb(zzm2, false);
        zzy zzy3 = new zzy(zzy2);
        new zzy(zzy2).zza = zzm2.zza;
        this.zza(new zzgp(this, zzy3, zzm2));
    }

    @BinderThread
    public final void zza(zzy zzy2) {
        Preconditions.checkNotNull((Object)zzy2);
        Preconditions.checkNotNull((Object)zzy2.zzc);
        this.zza(zzy2.zza, true);
        zzy zzy3 = new zzy(zzy2);
        this.zza(new zzge(this, zzy3));
    }

    @BinderThread
    public final List<zzkn> zza(String string, String string2, boolean bl, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgd(this, zzm2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkn> arrayList = new ArrayList<zzkn>(list.size());
            for (zzkp zzkp2 : list) {
                if (!bl && zzko.zze((String)zzkp2.zzc)) continue;
                arrayList.add(new zzkn(zzkp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to query user properties. appId", zzet.zza((String)zzm2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkn> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgg(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkn> arrayList = new ArrayList<zzkn>(list.size());
            for (zzkp zzkp2 : list) {
                if (!bl && zzko.zze((String)zzkp2.zzc)) continue;
                arrayList.add(new zzkn(zzkp2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user properties as. appId", zzet.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzy> zza(String string, String string2, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgf(this, zzm2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzy> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzgi(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzm zzm2) {
        this.zza(zzm2.zza, false);
        this.zza(new zzgh(this, zzm2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    static /* synthetic */ zzkg zza(zzgc zzgc2) {
        return zzgc2.zza;
    }
}

