/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.Context;
import android.os.Build;
import android.os.UserHandle;
import android.util.Log;
import androidx.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@TargetApi(value=24)
public final class zzh {
    private final JobScheduler zza;
    @Nullable
    private static final Method zzb = zzh.zza();
    @Nullable
    private static final Method zzc = zzh.zzb();

    @Nullable
    private static Method zza() {
        block3: {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return JobScheduler.class.getDeclaredMethod("scheduleAsPackage", JobInfo.class, String.class, Integer.TYPE, String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"No scheduleAsPackage method available, falling back to schedule");
                }
            }
        }
        return null;
    }

    @Nullable
    private static Method zzb() {
        block3: {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return UserHandle.class.getDeclaredMethod("myUserId", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"No myUserId method available");
                }
            }
        }
        return null;
    }

    private static int zzc() {
        block3: {
            if (zzc != null) {
                try {
                    return (Integer)zzc.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"myUserId invocation illegal", (Throwable)reflectiveOperationException);
                }
            }
        }
        return 0;
    }

    private zzh(JobScheduler jobScheduler) {
        this.zza = jobScheduler;
    }

    private final int zza(JobInfo jobInfo, String string, int n, String string2) {
        if (zzb != null) {
            try {
                return (Integer)zzb.invoke((Object)this.zza, jobInfo, string, n, string2);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                Log.e((String)string2, (String)"error calling scheduleAsPackage", (Throwable)reflectiveOperationException);
            }
        }
        return this.zza.schedule(jobInfo);
    }

    public static int zza(Context context, JobInfo jobInfo, String string, String string2) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (zzb == null || context.checkSelfPermission("android.permission.UPDATE_DEVICE_STATS") != 0) {
            return jobScheduler.schedule(jobInfo);
        }
        return new zzh(jobScheduler).zza(jobInfo, string, zzh.zzc(), string2);
    }
}

