/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbv;
import com.google.android.gms.internal.measurement.zzca;
import com.google.android.gms.internal.measurement.zzhz;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.internal.measurement.zzlq;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkw;
import java.util.ArrayList;
import java.util.Map;

public final class zzfp
extends zzkj
implements zzaa {
    @VisibleForTesting
    private static int zzb = 65535;
    @VisibleForTesting
    private static int zzc = 2;
    private final Map<String, Map<String, String>> zzd = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zze = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzf = new ArrayMap();
    private final Map<String, zzca.zzb> zzg = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzh;
    private final Map<String, String> zzi = new ArrayMap();

    zzfp(zzki zzki2) {
        super(zzki2);
        this.zzh = new ArrayMap();
    }

    @WorkerThread
    private final void zzi(String string) {
        this.zzaj();
        this.zzc();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzg.get(string) == null) {
            byte[] byArray = ((zzkg)this).zzi().zzd(string);
            if (byArray == null) {
                this.zzd.put(string, null);
                this.zze.put(string, null);
                this.zzf.put(string, null);
                this.zzg.put(string, null);
                this.zzi.put(string, null);
                this.zzh.put(string, null);
                return;
            }
            zzca.zzb.zza zza2 = (zzca.zzb.zza)this.zza(string, byArray).zzbn();
            this.zza(string, zza2);
            this.zzd.put(string, zzfp.zza((zzca.zzb)((zzhz)zza2.zzz())));
            this.zzg.put(string, (zzca.zzb)((zzhz)zza2.zzz()));
            this.zzi.put(string, null);
        }
    }

    @WorkerThread
    protected final zzca.zzb zza(String string) {
        this.zzaj();
        this.zzc();
        Preconditions.checkNotEmpty((String)string);
        this.zzi(string);
        return this.zzg.get(string);
    }

    @WorkerThread
    protected final String zzb(String string) {
        this.zzc();
        return this.zzi.get(string);
    }

    @WorkerThread
    protected final void zzc(String string) {
        this.zzc();
        this.zzi.put(string, null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzc();
        this.zzg.remove(string);
    }

    @WorkerThread
    final boolean zze(String string) {
        this.zzc();
        zzca.zzb zzb2 = this.zza(string);
        if (zzb2 == null) {
            return false;
        }
        return zzb2.zzh();
    }

    @WorkerThread
    public final String zza(String string, String string2) {
        this.zzc();
        this.zzi(string);
        Map<String, String> map = this.zzd.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzca.zzb zzb2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzb2 != null) {
            for (zzca.zzc zzc2 : zzb2.zze()) {
                arrayMap.put(zzc2.zza(), zzc2.zzb());
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzca.zzb.zza zza2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zza2 != null) {
            for (int i = 0; i < zza2.zza(); ++i) {
                zzca.zza.zza zza3 = (zzca.zza.zza)zza2.zza(i).zzbn();
                if (TextUtils.isEmpty((CharSequence)zza3.zza())) {
                    this.zzq().zzh().zza("EventConfig contained null event name");
                    continue;
                }
                String string2 = zza3.zza();
                String string3 = zzgs.zzb((String)zza3.zza());
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    zza3 = zza3.zza(string3);
                    zza2.zza(i, zza3);
                }
                if (zzlq.zzb() && this.zzs().zza(zzat.zzcm)) {
                    arrayMap.put(string2, zza3.zzb());
                } else {
                    arrayMap.put(zza3.zza(), zza3.zzb());
                }
                arrayMap2.put(zza3.zza(), zza3.zzc());
                if (!zza3.zzd()) continue;
                if (zza3.zze() < zzc || zza3.zze() > zzb) {
                    this.zzq().zzh().zza("Invalid sampling rate. Event name, sample rate", (Object)zza3.zza(), (Object)zza3.zze());
                    continue;
                }
                arrayMap3.put(zza3.zza(), zza3.zze());
            }
        }
        this.zze.put(string, (Map<String, Boolean>)arrayMap);
        this.zzf.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzh.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzaj();
        this.zzc();
        Preconditions.checkNotEmpty((String)string);
        zzca.zzb.zza zza2 = (zzca.zzb.zza)this.zza(string, byArray).zzbn();
        if (zza2 == null) {
            return false;
        }
        this.zza(string, zza2);
        this.zzg.put(string, (zzca.zzb)((zzhz)zza2.zzz()));
        this.zzi.put(string, string2);
        this.zzd.put(string, zzfp.zza((zzca.zzb)((zzhz)zza2.zzz())));
        ((zzkg)this).zzi().zza(string, new ArrayList<zzbv.zza>(zza2.zzb()));
        try {
            zza2.zzc();
            byArray = ((zzca.zzb)((zzhz)zza2.zzz())).zzbk();
        }
        catch (RuntimeException runtimeException) {
            this.zzq().zzh().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzer.zza((String)string), (Object)runtimeException);
        }
        byte[] byArray2 = byArray;
        String string3 = string;
        zzac zzac2 = ((zzkg)this).zzi();
        Preconditions.checkNotEmpty((String)string3);
        zzac2.zzc();
        zzac2.zzaj();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray2);
        try {
            if ((long)zzac2.c_().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                zzac2.zzq().zze().zza("Failed to update remote config (got 0). appId", zzer.zza((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            zzac2.zzq().zze().zza("Error storing remote config. appId", zzer.zza((String)string3), (Object)sQLiteException);
        }
        this.zzg.put(string, (zzca.zzb)((zzhz)zza2.zzz()));
        return true;
    }

    @WorkerThread
    final boolean zzb(String string, String string2) {
        this.zzc();
        this.zzi(string);
        if (this.zzg(string) && zzkw.zzd((String)string2)) {
            return true;
        }
        if (this.zzh(string) && zzkw.zza((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zze.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzc(String string, String string2) {
        this.zzc();
        this.zzi(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        if ("purchase".equals(string2) || "refund".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzf.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzd(String string, String string2) {
        this.zzc();
        this.zzi(string);
        Map<String, Integer> map = this.zzh.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzf(String string) {
        String string2 = this.zza(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzq().zzh().zza("Unable to parse timezone offset. appId", zzer.zza((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzca.zzb zza(String string, byte[] byArray) {
        zzca.zzb zzb2;
        if (byArray == null) {
            return zzca.zzb.zzj();
        }
        try {
            zzb2 = (zzca.zzb)((zzhz)zzks.zza(zzca.zzb.zzi(), byArray).zzz());
            this.zzq().zzw().zza("Parsed config. version, gmp_app_id", (Object)(zzb2.zza() ? Long.valueOf(zzb2.zzb()) : null), (Object)(zzb2.zzc() ? zzb2.zzd() : null));
        }
        catch (zzih zzih2) {
            this.zzq().zzh().zza("Unable to merge remote config. appId", zzer.zza((String)string), (Object)zzih2);
            return zzca.zzb.zzj();
        }
        catch (RuntimeException runtimeException) {
            this.zzq().zzh().zza("Unable to merge remote config. appId", zzer.zza((String)string), (Object)runtimeException);
            return zzca.zzb.zzj();
        }
        return zzb2;
    }

    final boolean zzg(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzh(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzd() {
        return false;
    }
}

