/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzcd;
import com.google.android.gms.internal.measurement.zzcj;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzkf;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class zzw {
    final String zzb;
    final int zzc;
    Boolean zzd;
    Boolean zze;
    Long zzf;
    Long zzg;

    zzw(String string, int n) {
        this.zzb = string;
        this.zzc = n;
    }

    abstract int zza();

    abstract boolean zzb();

    abstract boolean zzc();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    static Boolean zze(Boolean bl, boolean bl2) {
        boolean bl3;
        if (bl == null) {
            return null;
        }
        if (bl != bl2) {
            bl3 = true;
            return bl3;
        }
        bl3 = false;
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static Boolean zzf(String string, zzck object, zzei zzei2) {
        ArrayList<String> arrayList;
        Preconditions.checkNotNull((Object)object);
        if (string == null) {
            return null;
        }
        if (!((zzck)((Object)object)).zza()) return null;
        if (((zzck)((Object)object)).zzb() == zzcj.zza) {
            return null;
        }
        if (((zzck)((Object)object)).zzb() == zzcj.zzg) {
            if (((zzck)((Object)object)).zzh() == 0) return null;
        } else if (!((zzck)((Object)object)).zzc()) {
            return null;
        }
        zzcj zzcj2 = ((zzck)((Object)object)).zzb();
        boolean bl = ((zzck)((Object)object)).zzf();
        String string2 = bl || zzcj2 == zzcj.zzb || zzcj2 == zzcj.zzg ? ((zzck)((Object)object)).zzd() : ((zzck)((Object)object)).zzd().toUpperCase(Locale.ENGLISH);
        if (((zzck)((Object)object)).zzh() == 0) {
            object = null;
        } else {
            object = ((zzck)((Object)object)).zzg();
            if (!bl) {
                arrayList = new ArrayList<String>(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    arrayList.add(((String)object.next()).toUpperCase(Locale.ENGLISH));
                }
                object = Collections.unmodifiableList(arrayList);
            }
        }
        if (zzcj2 == zzcj.zzb) {
            arrayList = string2;
            return zzw.zzd(string, zzcj2, bl, string2, (List<String>)object, arrayList, zzei2);
        }
        arrayList = null;
        return zzw.zzd(string, zzcj2, bl, string2, (List<String>)object, arrayList, zzei2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Boolean zzd(String object, zzcj zzcj2, boolean bl, String string, List<String> list, String string2, zzei zzei2) {
        if (zzcj2 == zzcj.zzg) {
            if (list == null) return null;
            if (list.size() == 0) {
                return null;
            }
        } else if (string == null) {
            return null;
        }
        if (!bl && zzcj2 != zzcj.zzb) {
            object = ((String)object).toUpperCase(Locale.ENGLISH);
        }
        switch (zzcj2.ordinal()) {
            case 6: {
                if (list != null) return list.contains(object);
                return null;
            }
            case 5: {
                return ((String)object).equals(string);
            }
            case 4: {
                return ((String)object).contains(string);
            }
            case 3: {
                return ((String)object).endsWith(string);
            }
            case 2: {
                return ((String)object).startsWith(string);
            }
            case 1: {
                if (string2 == null) {
                    return null;
                }
                int n = true != bl ? 66 : 0;
                return Pattern.compile(string2, n).matcher((CharSequence)object).matches();
            }
        }
        return null;
        catch (PatternSyntaxException patternSyntaxException) {
            if (zzei2 == null) return null;
            zzei2.zze().zzb("Invalid regular expression in REGEXP audience filter. expression", (Object)string2);
            return null;
        }
    }

    static Boolean zzg(long l, zzcd object) {
        try {
            BigDecimal bigDecimal = new BigDecimal(l);
            object = zzw.zzj(bigDecimal, object, 0.0);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zzh(double d, zzcd object) {
        try {
            BigDecimal bigDecimal = new BigDecimal(d);
            object = zzw.zzj(bigDecimal, object, Math.ulp(d));
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zzi(String object, zzcd zzcd2) {
        if (!zzkf.zzl((String)object)) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal((String)object);
            object = zzw.zzj(bigDecimal, zzcd2, 0.0);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static Boolean zzj(BigDecimal comparable, zzcd object, double d) {
        boolean bl;
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        Preconditions.checkNotNull((Object)object);
        if (!((zzcd)((Object)object)).zza()) return null;
        if (((zzcd)((Object)object)).zzb() == zzcc.zza) {
            return null;
        }
        if (((zzcd)((Object)object)).zzb() == zzcc.zze) {
            if (!((zzcd)((Object)object)).zzg()) return null;
            if (!((zzcd)((Object)object)).zzi()) return null;
        } else if (!((zzcd)((Object)object)).zze()) {
            return null;
        }
        zzcc zzcc2 = ((zzcd)((Object)object)).zzb();
        if (((zzcd)((Object)object)).zzb() == zzcc.zze) {
            if (!zzkf.zzl(((zzcd)((Object)object)).zzh())) return null;
            if (!zzkf.zzl(((zzcd)((Object)object)).zzj())) {
                return null;
            }
            bigDecimal2 = new BigDecimal(((zzcd)((Object)object)).zzh());
            bigDecimal = new BigDecimal(((zzcd)((Object)object)).zzj());
            object = null;
        }
        if (!zzkf.zzl(((zzcd)((Object)object)).zzf())) {
            return null;
        }
        try {
            bigDecimal2 = new BigDecimal(((zzcd)((Object)object)).zzf());
            object = bigDecimal2;
            bigDecimal2 = null;
            bigDecimal = null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (zzcc2 == zzcc.zze ? bigDecimal2 == null : object == null) {
            return null;
        }
        switch (zzcc2.ordinal()) {
            default: {
                return null;
            }
            case 1: {
                boolean bl2;
                if (object == null) {
                    return null;
                }
                if (((BigDecimal)comparable).compareTo((BigDecimal)object) == -1) {
                    bl2 = true;
                    return bl2;
                }
                bl2 = false;
                return bl2;
            }
            case 4: {
                if (bigDecimal2 == null) {
                    return null;
                }
                boolean bl3 = ((BigDecimal)comparable).compareTo(bigDecimal2) != -1 ? ((BigDecimal)comparable).compareTo(bigDecimal) != 1 : false;
                return bl3;
            }
            case 3: {
                if (object == null) {
                    return null;
                }
                if (d != 0.0) {
                    bigDecimal2 = new BigDecimal(d);
                    bigDecimal = new BigDecimal(2);
                    boolean bl4 = ((BigDecimal)comparable).compareTo(((BigDecimal)object).subtract(bigDecimal2.multiply(bigDecimal))) == 1 ? ((BigDecimal)comparable).compareTo(((BigDecimal)object).add((bigDecimal2 = new BigDecimal(d)).multiply(bigDecimal = new BigDecimal(2)))) == -1 : false;
                    return bl4;
                }
                boolean bl5 = ((BigDecimal)comparable).compareTo((BigDecimal)object) == 0;
                return bl5;
            }
            case 2: 
        }
        if (object == null) {
            return null;
        }
        if (((BigDecimal)comparable).compareTo((BigDecimal)object) == 1) {
            bl = true;
            return bl;
        }
        bl = false;
        return bl;
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

