/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzg;
import com.google.android.gms.internal.measurement.zzh;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkp;

public final class zzjx
extends zzjz {
    private final AlarmManager zza;
    private zzal zzb;
    private Integer zzc;

    protected zzjx(zzki zzki2) {
        super(zzki2);
        this.zza = (AlarmManager)this.zzs.zzax().getSystemService("alarm");
    }

    private final zzal zzf() {
        if (this.zzb == null) {
            zzjw zzjw2 = new zzjw(this, (zzgk)this.zzf.zzO());
            this.zzb = zzjw2;
        }
        return this.zzb;
    }

    @Override
    protected final boolean zzaA() {
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzj());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzh();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzh() {
        JobScheduler jobScheduler = (JobScheduler)this.zzs.zzax().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzi());
            return;
        }
    }

    public final void zzc(long l) {
        this.zzZ();
        this.zzs.zzat();
        Context context = this.zzs.zzax();
        if (!zzkp.zzam((Context)context)) {
            this.zzs.zzau().zzj().zza("Receiver not registered/enabled");
        }
        if (!zzkp.zzP((Context)context, (boolean)false)) {
            this.zzs.zzau().zzj().zza("Service not registered/enabled");
        }
        this.zzd();
        this.zzs.zzau().zzk().zzb("Scheduling upload, millis", (Object)l);
        long l2 = this.zzs.zzay().elapsedRealtime() + l;
        this.zzs.zzc();
        if (l < Math.max(0L, (Long)zzea.zzw.zzb(null)) && !this.zzf().zzc()) {
            this.zzf().zzb(l);
        }
        this.zzs.zzat();
        if (Build.VERSION.SDK_INT >= 24) {
            context = this.zzs.zzax();
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = this.zzi();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo.Builder builder = new JobInfo.Builder(n, componentName);
            zzh.zza(context, builder.setMinimumLatency(l).setOverrideDeadline(l + l).setExtras(persistableBundle).build(), "com.google.android.gms", "UploadAlarm");
            return;
        }
        context = this.zza;
        if (context != null) {
            this.zzs.zzc();
            context.setInexactRepeating(2, l2, Math.max((Long)zzea.zzr.zzb(null), l), this.zzj());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int zzi() {
        if (this.zzc == null) {
            String string = String.valueOf(this.zzs.zzax().getPackageName());
            String string2 = "measurement";
            string = string.length() != 0 ? string2.concat(string) : new String(string2);
            this.zzc = string.hashCode();
        }
        return this.zzc;
    }

    public final void zzd() {
        this.zzZ();
        this.zzs.zzau().zzk().zza("Unscheduling upload");
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzj());
        }
        this.zzf().zzd();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzh();
            return;
        }
    }

    private final PendingIntent zzj() {
        zzjx zzjx2 = zzjx2.zzs.zzax();
        Intent intent = new Intent();
        return zzg.zza((Context)zzjx2, 0, intent.setClassName((Context)zzjx2, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD"), zzg.zza);
    }
}

