/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzjl;
import com.google.android.gms.internal.measurement.zzkj;
import com.google.android.gms.internal.measurement.zzlf;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public final class zzku
extends zzki {
    static int zza(zzfx zzfx2, String string) {
        for (int i = 0; i < zzfx2.zzb(); ++i) {
            if (!string.equals(zzfx2.zzak(i).zzf())) continue;
            return i;
        }
        return -1;
    }

    @WorkerThread
    final long zzd(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzs.zzv().zzg();
        MessageDigest messageDigest = zzkz.zzE((String)"MD5");
        if (messageDigest == null) {
            this.zzs.zzay().zzd().zza("Failed to get MD5");
            return 0L;
        }
        return zzkz.zzp((byte[])messageDigest.digest(byArray));
    }

    final Bundle zzf(Map<String, Object> map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) {
                bundle.putString(string, null);
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)object;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    arrayList2.add(this.zzf((Map)arrayList.get(i), false));
                }
                bundle.putParcelableArrayList(string, arrayList2);
                continue;
            }
            bundle.putString(string, object.toString());
        }
        return bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <T extends Parcelable> T zzh(byte[] object, Parcelable.Creator<T> creator) {
        if (object == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall((byte[])object, 0, ((Object)object).length);
            parcel.setDataPosition(0);
            object = (Parcelable)creator.createFromParcel(parcel);
        }
        catch (SafeParcelReader.ParseException parseException) {
            try {
                zzku zzku2;
                zzku2 = zzku2.zzs.zzay();
                zzku2.zzd().zza("Failed to load parcelable from buffer");
                return null;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                parcel.recycle();
            }
        }
        parcel.recycle();
        return (T)object;
    }

    final zzat zzi(zzaa zzaa2) {
        Object object;
        Bundle bundle = object2.zzf(zzaa2.zze(), true);
        Object object2 = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            object2 = object.toString();
        }
        if ((object = zzgs.zzb((String)zzaa2.zzd())) == null) {
            object = zzaa2.zzd();
        }
        zzar zzar2 = new zzar(bundle);
        zzat zzat2 = new zzat((String)object, zzar2, (String)object2, zzaa2.zza());
        return zzat2;
    }

    final zzfo zzj(zzao zzao2) {
        zzfn zzfn2 = zzfo.zze();
        zzfn2.zzl(zzao2.zze);
        Object object = zzao2.zzf;
        zzaq zzaq2 = new zzaq(object);
        while (zzaq2.hasNext()) {
            object = zzaq2.zza();
            zzfr zzfr2 = zzfs.zze();
            zzfr2.zzj((String)object);
            object = zzao2.zzf.zzf((String)object);
            Preconditions.checkNotNull((Object)object);
            this.zzu(zzfr2, object);
            zzfn2.zze(zzfr2);
        }
        return (zzfo)zzfn2.zzaA();
    }

    static <Builder extends zzlf> Builder zzl(Builder Builder2, byte[] byArray) throws zzkj {
        zzjl zzjl2 = zzjl.zzb();
        if (zzjl2 != null) {
            return (Builder)Builder2.zzaw(byArray, zzjl2);
        }
        return (Builder)Builder2.zzav(byArray);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    final String zzm(zzfw var1_1) {
        if (var1_1 == null) {
            return "";
        }
        var2_2 = new StringBuilder();
        var2_2.append("\nbatch {\n");
        var3_3 = var1_1.zzd().iterator();
        block0: while (true) {
            if (!var3_3.hasNext()) {
                var2_2.append("}\n");
                return var2_2.toString();
            }
            var4_5 = var3_3.next();
            if (var4_5 == null) continue;
            zzku.zzG(var2_2, 1);
            var2_2.append("bundle {\n");
            if (var4_5.zzbh()) {
                zzku.zzJ(var2_2, 1, "protocol_version", var4_5.zzd());
            }
            zzku.zzJ(var2_2, 1, "platform", var4_5.zzK());
            if (var4_5.zzbd()) {
                zzku.zzJ(var2_2, 1, "gmp_version", var4_5.zzn());
            }
            if (var4_5.zzbn()) {
                zzku.zzJ(var2_2, 1, "uploading_gmp_version", var4_5.zzs());
            }
            if (var4_5.zzbb()) {
                zzku.zzJ(var2_2, 1, "dynamite_version", var4_5.zzk());
            }
            if (var4_5.zzaY()) {
                zzku.zzJ(var2_2, 1, "config_version", var4_5.zzi());
            }
            zzku.zzJ(var2_2, 1, "gmp_app_id", var4_5.zzH());
            zzku.zzJ(var2_2, 1, "admob_app_id", var4_5.zzx());
            zzku.zzJ(var2_2, 1, "app_id", var4_5.zzy());
            zzku.zzJ(var2_2, 1, "app_version", var4_5.zzB());
            if (var4_5.zzaW()) {
                zzku.zzJ(var2_2, 1, "app_version_major", var4_5.zza());
            }
            zzku.zzJ(var2_2, 1, "firebase_instance_id", var4_5.zzF());
            if (var4_5.zzba()) {
                zzku.zzJ(var2_2, 1, "dev_cert_hash", var4_5.zzj());
            }
            zzku.zzJ(var2_2, 1, "app_store", var4_5.zzA());
            if (var4_5.zzbm()) {
                zzku.zzJ(var2_2, 1, "upload_timestamp_millis", var4_5.zzr());
            }
            if (var4_5.zzbk()) {
                zzku.zzJ(var2_2, 1, "start_timestamp_millis", var4_5.zzq());
            }
            if (var4_5.zzbc()) {
                zzku.zzJ(var2_2, 1, "end_timestamp_millis", var4_5.zzm());
            }
            if (var4_5.zzbg()) {
                zzku.zzJ(var2_2, 1, "previous_bundle_start_timestamp_millis", var4_5.zzp());
            }
            if (var4_5.zzbf()) {
                zzku.zzJ(var2_2, 1, "previous_bundle_end_timestamp_millis", var4_5.zzo());
            }
            zzku.zzJ(var2_2, 1, "app_instance_id", var4_5.zzz());
            zzku.zzJ(var2_2, 1, "resettable_device_id", var4_5.zzL());
            zzku.zzJ(var2_2, 1, "ds_id", var4_5.zzE());
            if (var4_5.zzbe()) {
                zzku.zzJ(var2_2, 1, "limited_ad_tracking", var4_5.zzaT());
            }
            zzku.zzJ(var2_2, 1, "os_version", var4_5.zzJ());
            zzku.zzJ(var2_2, 1, "device_model", var4_5.zzD());
            zzku.zzJ(var2_2, 1, "user_default_language", var4_5.zzM());
            if (var4_5.zzbl()) {
                zzku.zzJ(var2_2, 1, "time_zone_offset_minutes", var4_5.zzf());
            }
            if (var4_5.zzaX()) {
                zzku.zzJ(var2_2, 1, "bundle_sequential_index", var4_5.zzb());
            }
            if (var4_5.zzbj()) {
                zzku.zzJ(var2_2, 1, "service_upload", var4_5.zzaU());
            }
            zzku.zzJ(var2_2, 1, "health_monitor", var4_5.zzI());
            if (!this.zzs.zzf().zzs(null, zzdy.zzan) && var4_5.zzaV() && var4_5.zzh() != 0L) {
                zzku.zzJ(var2_2, 1, "android_id", var4_5.zzh());
            }
            if (var4_5.zzbi()) {
                zzku.zzJ(var2_2, 1, "retry_counter", var4_5.zze());
            }
            if (var4_5.zzaZ()) {
                zzku.zzJ(var2_2, 1, "consent_signals", var4_5.zzC());
            }
            if ((var1_1 = var4_5.zzP()) == null) ** GOTO lbl73
            var5_7 /* !! */  = var1_1.iterator();
            while (true) {
                block37: {
                    if (var5_7 /* !! */ .hasNext()) break block37;
lbl73:
                    // 2 sources

                    if ((var1_1 = var4_5.zzN()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var5_7 /* !! */  = (zzfk)var1_1.next();
                            if (var5_7 /* !! */  == null) continue;
                            zzku.zzG(var2_2, 2);
                            var2_2.append("audience_membership {\n");
                            if (var5_7 /* !! */ .zzk()) {
                                zzku.zzJ(var2_2, 2, "audience_id", var5_7 /* !! */ .zza());
                            }
                            if (var5_7 /* !! */ .zzm()) {
                                zzku.zzJ(var2_2, 2, "new_audience", var5_7 /* !! */ .zzj());
                            }
                            zzku.zzI(var2_2, 2, "current_data", var5_7 /* !! */ .zzd());
                            if (var5_7 /* !! */ .zzn()) {
                                zzku.zzI(var2_2, 2, "previous_data", var5_7 /* !! */ .zze());
                            }
                            zzku.zzG(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    if ((var1_1 = var4_5.zzO()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var4_6 = (zzfo)var1_1.next();
                            if (var4_6 == null) continue;
                            zzku.zzG(var2_2, 2);
                            var2_2.append("event {\n");
                            zzku.zzJ(var2_2, 2, "name", this.zzs.zzj().zzd(var4_6.zzh()));
                            if (var4_6.zzu()) {
                                zzku.zzJ(var2_2, 2, "timestamp_millis", var4_6.zzd());
                            }
                            if (var4_6.zzt()) {
                                zzku.zzJ(var2_2, 2, "previous_timestamp_millis", var4_6.zzc());
                            }
                            if (var4_6.zzs()) {
                                zzku.zzJ(var2_2, 2, "count", var4_6.zza());
                            }
                            if (var4_6.zzb() != 0) {
                                this.zzE(var2_2, 2, var4_6.zzi());
                            }
                            zzku.zzG(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    zzku.zzG(var2_2, 1);
                    var2_2.append("}\n");
                    continue block0;
                }
                var6_8 = (zzgh)var5_7 /* !! */ .next();
                if (var6_8 == null) continue;
                zzku.zzG(var2_2, 2);
                var2_2.append("user_property {\n");
                var1_1 = var6_8.zzs() != false ? Long.valueOf(var6_8.zzc()) : null;
                zzku.zzJ(var2_2, 2, "set_timestamp_millis", var1_1);
                zzku.zzJ(var2_2, 2, "name", this.zzs.zzj().zzf(var6_8.zzf()));
                zzku.zzJ(var2_2, 2, "string_value", var6_8.zzg());
                var1_1 = var6_8.zzr() != false ? Long.valueOf(var6_8.zzb()) : null;
                zzku.zzJ(var2_2, 2, "int_value", var1_1);
                var1_1 = var6_8.zzq() != false ? Double.valueOf(var6_8.zza()) : null;
                zzku.zzJ(var2_2, 2, "double_value", var1_1);
                zzku.zzG(var2_2, 2);
                var2_2.append("}\n");
            }
            break;
        }
    }

    final String zzo(zzej object) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (((zzej)((Object)object)).zzp()) {
            zzku.zzJ(stringBuilder, 0, "filter_id", ((zzej)((Object)object)).zzb());
        }
        zzku.zzJ(stringBuilder, 0, "event_name", this.zzs.zzj().zzd(((zzej)((Object)object)).zzg()));
        String string = zzku.zzH(((zzej)((Object)object)).zzk(), ((zzej)((Object)object)).zzm(), ((zzej)((Object)object)).zzn());
        if (!string.isEmpty()) {
            zzku.zzJ(stringBuilder, 0, "filter_type", string);
        }
        if (((zzej)((Object)object)).zzo()) {
            zzku.zzK(stringBuilder, 1, "event_count_filter", ((zzej)((Object)object)).zzf());
        }
        if (((zzej)((Object)object)).zza() > 0) {
            stringBuilder.append("  filters {\n");
            object = ((zzej)((Object)object)).zzh().iterator();
            while (object.hasNext()) {
                this.zzF(stringBuilder, 2, (zzel)((Object)object.next()));
            }
        }
        zzku.zzG(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zzp(zzes zzes2) {
        if (zzes2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zzes2.zzj()) {
            zzku.zzJ(stringBuilder, 0, "filter_id", zzes2.zza());
        }
        zzku.zzJ(stringBuilder, 0, "property_name", this.zzs.zzj().zzf(zzes2.zze()));
        String string = zzku.zzH(zzes2.zzg(), zzes2.zzh(), zzes2.zzi());
        if (!string.isEmpty()) {
            zzku.zzJ(stringBuilder, 0, "filter_type", string);
        }
        this.zzF(stringBuilder, 1, zzes2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    static List<zzfs> zzq(Bundle[] var0) {
        var2_1 = new ArrayList<zzfs>();
        block0: for (Bundle var4_4 : var0) {
            if (var4_4 == null) lbl-1000:
            // 3 sources

            {
                continue block0;
            }
            var5_5 = zzfs.zze();
            block2: for (Object var7_7 : var4_4.keySet()) {
                block6: {
                    var8_8 = zzfs.zze();
                    var8_8.zzj((String)var7_7);
                    var7_7 = var4_4.get((String)var7_7);
                    if (var7_7 instanceof Long) {
                        var8_8.zzi((Long)var7_7);
lbl15:
                        // 3 sources

                        while (true) {
                            var5_5.zzc(var8_8);
                            continue block2;
                            break;
                        }
                    }
                    if (!(var7_7 instanceof String)) break block6;
                    var8_8.zzk((String)var7_7);
                    ** GOTO lbl15
                }
                if (!(var7_7 instanceof Double)) continue;
                var8_8.zzh((Double)var7_7);
                ** continue;
            }
            if (var5_5.zza() <= 0) ** GOTO lbl-1000
            var2_1.add((zzfs)var5_5.zzaA());
            ** continue;
        }
        return var2_1;
    }

    final List<Long> zzr(List<Long> object, List<Integer> object2) {
        ArrayList<Long> arrayList = new ArrayList<Long>((Collection<Long>)object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Integer)object.next();
            if ((Integer)object2 < 0) {
                this.zzs.zzay().zzk().zzb("Ignoring negative bit index to be cleared", object2);
                continue;
            }
            int n = (Integer)object2 / 64;
            if (n >= arrayList.size()) {
                this.zzs.zzay().zzk().zzc("Ignoring bit index greater than bitSet size", object2, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n, arrayList.get(n) & (1L << (Integer)object2 % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n2 = arrayList.size() + -1;
        while (n2 >= 0 && arrayList.get(n2) == 0L) {
            int n3 = n2 + -1;
            n = n2;
            n2 = n3;
        }
        return arrayList.subList(0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static List<Long> zzs(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        int n2 = 0;
        block0: while (n2 < n) {
            long l = 0L;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 >= 64 || (n4 = n2 * 64 + n3) >= bitSet.length()) {
                    arrayList.add(l);
                    ++n2;
                    continue block0;
                }
                long l2 = bitSet.get(n4) ? (l |= 1L << n3) : l;
                ++n3;
                l = l2;
            }
            break;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Map<String, Object> zzt(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = bundle.get(string);
            if (object instanceof Bundle[] || object instanceof ArrayList || object instanceof Bundle) {
                if (!bl) continue;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                if (object instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(this.zzt((Bundle)parcelable, false));
                    }
                } else if (object instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(this.zzt((Bundle)e, false));
                    }
                } else if (object instanceof Bundle) {
                    arrayList.add(this.zzt((Bundle)object, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzku(zzks zzks2) {
        super(zzks2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzE(StringBuilder stringBuilder, int n, List<zzfs> iterator) {
        if (iterator == null) {
            return;
        }
        int n2 = n + 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzfs zzfs2 = (zzfs)((Object)iterator.next());
            if (zzfs2 == null) continue;
            zzku.zzG(stringBuilder, n2);
            stringBuilder.append("param {\n");
            Object object = zzfs2.zzx() ? this.zzs.zzj().zze(zzfs2.zzg()) : null;
            zzku.zzJ(stringBuilder, n2, "name", object);
            object = zzfs2.zzy() ? zzfs2.zzh() : null;
            zzku.zzJ(stringBuilder, n2, "string_value", object);
            object = zzfs2.zzw() ? Long.valueOf(zzfs2.zzd()) : null;
            zzku.zzJ(stringBuilder, n2, "int_value", object);
            object = zzfs2.zzu() ? Double.valueOf(zzfs2.zza()) : null;
            zzku.zzJ(stringBuilder, n2, "double_value", object);
            if (zzfs2.zzc() > 0) {
                this.zzE(stringBuilder, n2, zzfs2.zzi());
            }
            zzku.zzG(stringBuilder, n2);
            stringBuilder.append("}\n");
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzF(StringBuilder stringBuilder, int n, zzel zzel2) {
        if (zzel2 == null) {
            return;
        }
        zzku.zzG(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzel2.zzh()) {
            zzku.zzJ(stringBuilder, n, "complement", zzel2.zzg());
        }
        if (zzel2.zzj()) {
            zzku.zzJ(stringBuilder, n, "param_name", ((zzgo)object).zzs.zzj().zze(zzel2.zze()));
        }
        if (zzel2.zzk()) {
            int n2 = n + 1;
            zzex zzex2 = zzel2.zzd();
            if (zzex2 != null) {
                zzku.zzG(stringBuilder, n2);
                stringBuilder.append("string_filter {\n");
                if (zzex2.zzi()) {
                    switch (zzex2.zzj()) {
                        default: {
                            Object object = "IN_LIST";
                            break;
                        }
                        case 1: {
                            Object object = "UNKNOWN_MATCH_TYPE";
                            break;
                        }
                        case 6: {
                            Object object = "EXACT";
                            break;
                        }
                        case 5: {
                            Object object = "PARTIAL";
                            break;
                        }
                        case 4: {
                            Object object = "ENDS_WITH";
                            break;
                        }
                        case 3: {
                            Object object = "BEGINS_WITH";
                            break;
                        }
                        case 2: {
                            Object object = "REGEXP";
                        }
                    }
                    zzku.zzJ(stringBuilder, n2, "match_type", object);
                }
                if (zzex2.zzh()) {
                    zzku.zzJ(stringBuilder, n2, "expression", zzex2.zzd());
                }
                if (zzex2.zzg()) {
                    zzku.zzJ(stringBuilder, n2, "case_sensitive", zzex2.zzf());
                }
                if (zzex2.zza() > 0) {
                    zzku.zzG(stringBuilder, n2 + 1);
                    stringBuilder.append("expression_list {\n");
                    for (Object e : zzex2.zze()) {
                        String string = (String)e;
                        zzku.zzG(stringBuilder, n2 + 2);
                        stringBuilder.append(string);
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("}\n");
                }
                zzku.zzG(stringBuilder, n2);
                stringBuilder.append("}\n");
            }
        }
        if (zzel2.zzi()) {
            zzku.zzK(stringBuilder, n + 1, "number_filter", zzel2.zzc());
        }
        zzku.zzG(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    final void zzu(zzfr zzfr2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzfr2.zzg();
        zzfr2.zze();
        zzfr2.zzd();
        zzfr2.zzf();
        if (object instanceof String) {
            zzfr2.zzk((String)object);
            return;
        }
        if (object instanceof Long) {
            zzfr2.zzi((Long)object);
            return;
        }
        if (object instanceof Double) {
            zzfr2.zzh((Double)object);
            return;
        }
        if (object instanceof Bundle[]) {
            zzfr2.zzb(zzku.zzq((Bundle[])object));
            return;
        }
        this.zzs.zzay().zzd().zzb("Ignoring invalid (type) event param value", object);
    }

    final void zzv(zzgg zzgg2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzgg2.zzc();
        zzgg2.zzb();
        zzgg2.zza();
        if (object instanceof String) {
            zzgg2.zzh((String)object);
            return;
        }
        if (object instanceof Long) {
            zzgg2.zze((Long)object);
            return;
        }
        if (object instanceof Double) {
            zzgg2.zzd((Double)object);
            return;
        }
        this.zzs.zzay().zzd().zzb("Ignoring invalid (type) user attribute value", object);
    }

    static boolean zzw(List<Long> list, int n) {
        return n < list.size() * 64 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zzx(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzs.zzav().currentTimeMillis() - l) > l2;
    }

    static boolean zzy(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzb() {
        return false;
    }

    final byte[] zzz(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzs.zzay().zzd().zzb("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    static final void zzA(zzfn zzfn2, String string, Object object) {
        int n;
        Object object2;
        block10: {
            object2 = zzfn2.zzp();
            for (n = 0; n < object2.size(); ++n) {
                if (!string.equals(object2.get(n).zzg())) {
                    continue;
                }
                break block10;
            }
            n = -1;
        }
        object2 = zzfs.zze();
        ((zzfr)((Object)object2)).zzj(string);
        if (object instanceof Long) {
            ((zzfr)((Object)object2)).zzi((Long)object);
        } else if (object instanceof String) {
            ((zzfr)((Object)object2)).zzk((String)object);
        } else if (object instanceof Double) {
            ((zzfr)((Object)object2)).zzh((Double)object);
        } else if (object instanceof Bundle[]) {
            ((zzfr)((Object)object2)).zzb(zzku.zzq((Bundle[])object));
        }
        if (n >= 0) {
            zzfn2.zzj(n, (zzfr)((Object)object2));
            return;
        }
        zzfn2.zze((zzfr)((Object)object2));
    }

    private static final void zzG(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    @WorkerThread
    static final boolean zzB(zzat zzat2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzat2);
        Preconditions.checkNotNull((Object)zzp2);
        return !TextUtils.isEmpty((CharSequence)zzp2.zzb) || !TextUtils.isEmpty((CharSequence)zzp2.zzq);
    }

    static final zzfs zzC(zzfo object, String string) {
        for (zzfs zzfs2 : ((zzfo)((Object)object)).zzi()) {
            if (!zzfs2.zzg().equals(string)) continue;
            return zzfs2;
        }
        return null;
    }

    private static final String zzH(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void zzI(StringBuilder stringBuilder, int n, String iterator, zzgd object) {
        void var5_27;
        Object object2;
        Iterator<Object> iterator2;
        Object object3;
        if (object3 == null) {
            return;
        }
        zzku.zzG(stringBuilder, 3);
        stringBuilder.append((String)((Object)iterator2));
        stringBuilder.append(" {\n");
        if (((zzgd)((Object)object3)).zzb() != 0) {
            zzku.zzG(stringBuilder, 4);
            stringBuilder.append("results: ");
            iterator2 = ((zzgd)((Object)object3)).zzk().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_3;
                object2 = iterator2.next();
                var5_27 = var1_3 + true;
                if (var1_3 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object2);
                var1_3 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (((zzgd)((Object)object3)).zzd() != 0) {
            zzku.zzG(stringBuilder, 4);
            stringBuilder.append("status: ");
            iterator2 = ((zzgd)((Object)object3)).zzn().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_5;
                object2 = (Long)iterator2.next();
                var5_27 = var1_5 + true;
                if (var1_5 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object2);
                var1_5 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (((zzgd)((Object)object3)).zza() != 0) {
            zzku.zzG(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            iterator2 = ((zzgd)((Object)object3)).zzj().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_11;
                void var1_9;
                void var1_7;
                object2 = (zzfm)((Object)iterator2.next());
                var5_27 = var1_7 + true;
                if (var1_7 != false) {
                    stringBuilder.append(", ");
                }
                if (((zzfm)((Object)object2)).zzh()) {
                    Integer n2 = ((zzfm)((Object)object2)).zza();
                } else {
                    Object var1_14 = null;
                }
                stringBuilder.append(var1_9);
                stringBuilder.append(":");
                if (((zzfm)((Object)object2)).zzg()) {
                    Long l = ((zzfm)((Object)object2)).zzb();
                } else {
                    Object var1_13 = null;
                }
                stringBuilder.append(var1_11);
                void var1_12 = var5_27;
            }
            stringBuilder.append("}\n");
        }
        if (((zzgd)((Object)object3)).zzc() != 0) {
            zzku.zzG(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            iterator2 = ((zzgd)((Object)object3)).zzm().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_18;
                void var1_16;
                object3 = (zzgf)((Object)iterator2.next());
                void var4_26 = var1_16 + true;
                if (var1_16 != false) {
                    stringBuilder.append(", ");
                }
                if (((zzgf)((Object)object3)).zzi()) {
                    Integer n3 = ((zzgf)((Object)object3)).zzb();
                } else {
                    Object var1_22 = null;
                }
                stringBuilder.append(var1_18);
                stringBuilder.append(": [");
                object3 = ((zzgf)((Object)object3)).zzf().iterator();
                boolean bl2 = false;
                while (object3.hasNext()) {
                    void var1_20;
                    long l = (Long)object3.next();
                    var5_27 = var1_20 + true;
                    if (var1_20 != false) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                    var1_20 = var5_27;
                }
                stringBuilder.append("]");
                void var1_21 = var4_26;
            }
            stringBuilder.append("}\n");
        }
        zzku.zzG(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private static final void zzJ(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzku.zzG(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    static final Object zzD(zzfo object, String arrayList) {
        if ((object = zzku.zzC((zzfo)((Object)object), (String)((Object)arrayList))) != null) {
            if (((zzfs)((Object)object)).zzy()) {
                return ((zzfs)((Object)object)).zzh();
            }
            if (((zzfs)((Object)object)).zzw()) {
                return ((zzfs)((Object)object)).zzd();
            }
            if (((zzfs)((Object)object)).zzu()) {
                return ((zzfs)((Object)object)).zza();
            }
            if (((zzfs)((Object)object)).zzc() > 0) {
                object = ((zzfs)((Object)object)).zzi();
                arrayList = new ArrayList<Bundle>();
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = (zzfs)((Object)object.next());
                    if (object2 == null) continue;
                    Bundle bundle = new Bundle();
                    for (zzfs zzfs2 : object2.zzi()) {
                        if (zzfs2.zzy()) {
                            bundle.putString(zzfs2.zzg(), zzfs2.zzh());
                            continue;
                        }
                        if (zzfs2.zzw()) {
                            bundle.putLong(zzfs2.zzg(), zzfs2.zzd());
                            continue;
                        }
                        if (!zzfs2.zzu()) continue;
                        bundle.putDouble(zzfs2.zzg(), zzfs2.zza());
                    }
                    if (bundle.isEmpty()) continue;
                    arrayList.add(bundle);
                }
                return arrayList.toArray(new Bundle[arrayList.size()]);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void zzK(StringBuilder stringBuilder, int n, String string, zzeq zzeq2) {
        if (zzeq2 == null) {
            return;
        }
        zzku.zzG(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzeq2.zzg()) {
            switch (zzeq2.zzm()) {
                default: {
                    string = "BETWEEN";
                    break;
                }
                case 1: {
                    string = "UNKNOWN_COMPARISON_TYPE";
                    break;
                }
                case 4: {
                    string = "EQUAL";
                    break;
                }
                case 3: {
                    string = "GREATER_THAN";
                    break;
                }
                case 2: {
                    string = "LESS_THAN";
                }
            }
            zzku.zzJ(stringBuilder, n, "comparison_type", string);
        }
        if (zzeq2.zzi()) {
            zzku.zzJ(stringBuilder, n, "match_as_float", zzeq2.zzf());
        }
        if (zzeq2.zzh()) {
            zzku.zzJ(stringBuilder, n, "comparison_value", zzeq2.zzc());
        }
        if (zzeq2.zzk()) {
            zzku.zzJ(stringBuilder, n, "min_comparison_value", zzeq2.zze());
        }
        if (zzeq2.zzj()) {
            zzku.zzJ(stringBuilder, n, "max_comparison_value", zzeq2.zzd());
        }
        zzku.zzG(stringBuilder, n);
        stringBuilder.append("}\n");
    }
}

