/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.internal.measurement.zzpe;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgn
extends zzea {
    private final zzks zza;
    private Boolean zzb;
    private String zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzat zzb(zzat zzat2, zzp object) {
        if (!"_cmp".equals(zzat2.zza)) return zzat2;
        zzar zzar2 = zzat2.zzb;
        if (zzar2 == null) return zzat2;
        if (zzar2.zza() == 0) {
            return zzat2;
        }
        String string = zzat2.zzb.zzg("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzat2;
        }
        this.zza.zzay().zzi().zzb("Event has been filtered ", (Object)zzat2.toString());
        return new zzat("_cmpx", zzat2.zzb, zzat2.zzc, zzat2.zzd);
    }

    static /* bridge */ /* synthetic */ zzks zzc(zzgn zzgn2) {
        return zzgn2.zza;
    }

    @BinderThread
    public final String zzd(zzp zzp2) {
        this.zzz(zzp2, false);
        return this.zza.zzx(zzp2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkv> zze(zzp zzp2, boolean bl) {
        this.zzz(zzp2, false);
        Iterator iterator = zzp2.zza;
        Preconditions.checkNotNull((Object)iterator);
        ArrayList<zzkv> arrayList = this.zza;
        arrayList = ((zzks)((Object)arrayList)).zzaz();
        zzgk zzgk2 = new zzgk(this, (String)((Object)iterator));
        iterator = arrayList.zzh(zzgk2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkv>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzgk2 = (zzkx)iterator.next();
                if (!bl && (bl2 = zzkz.zzag((String)((zzkx)zzgk2).zzc))) continue;
                zzkv zzkv2 = new zzkv((zzkx)zzgk2);
                arrayList.add(zzkv2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties. appId", zzel.zzn((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzab> zzf(String object, String string, zzp object2) {
        this.zzz((zzp)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        zzks zzks2 = this.zza;
        zzks2 = zzks2.zzaz();
        zzgb zzgb2 = new zzgb(this, (String)object2, (String)object, string);
        object = zzks2.zzh(zzgb2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzab> zzg(String object, String string, String string2) {
        this.zzA((String)object, true);
        zzks zzks2 = this.zza;
        zzks2 = zzks2.zzaz();
        zzgc zzgc2 = new zzgc(this, (String)object, string, string2);
        object = zzks2.zzh(zzgc2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkv> zzh(String iterator, String arrayList, boolean bl, zzp zzp2) {
        this.zzz(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        zzks zzks2 = this.zza;
        zzks2 = zzks2.zzaz();
        zzfz zzfz2 = new zzfz(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzks2.zzh(zzfz2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkv>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                string = (zzkx)iterator.next();
                if (!bl && (bl2 = zzkz.zzag((String)((zzkx)string).zzc))) continue;
                zzkv zzkv2 = new zzkv((zzkx)string);
                arrayList.add(zzkv2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to query user properties. appId", zzel.zzn((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkv> zzi(String string, String iterator, String arrayList, boolean bl) {
        this.zzA(string, true);
        zzks zzks2 = this.zza;
        zzks2 = zzks2.zzaz();
        zzga zzga2 = new zzga(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzks2.zzh(zzga2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkv>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzks2 = (zzkx)iterator.next();
                if (!bl && (bl2 = zzkz.zzag((String)((zzkx)zzks2).zzc))) continue;
                zzkv zzkv2 = new zzkv((zzkx)zzks2);
                arrayList.add(zzkv2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties as. appId", zzel.zzn((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    static /* bridge */ /* synthetic */ void zzv(zzgn zzgn2, zzat zzat2, zzp zzp2) {
        zzgn2.zzB(zzat2, zzp2);
    }

    public zzgn(zzks zzks2, String string) {
        Preconditions.checkNotNull((Object)zzks2);
        this.zza = zzks2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzj(zzp zzp2) {
        this.zzz(zzp2, false);
        zzgl zzgl2 = new zzgl(this, zzp2);
        this.zzy(zzgl2);
    }

    @BinderThread
    private final void zzz(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzA(zzp2.zza, false);
        this.zza.zzv().zzW(zzp2.zzb, zzp2.zzq, zzp2.zzu);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzA(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzay().zzd().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)this.zza.zzau(), (int)Binder.getCallingUid());
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)this.zza.zzau()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzay().zzd().zzb("Measurement Service called with invalid calling package. appId", zzel.zzn((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzau(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzw(zzat object, zzp zzp2) {
        block12: {
            void var3_5;
            block14: {
                block13: {
                    if (!this.zza.zzo().zzl(zzp2.zza)) {
                        this.zzB((zzat)object, zzp2);
                        return;
                    }
                    this.zza.zzay().zzj().zzb("EES config found for", (Object)zzp2.zza);
                    zzfm zzfm2 = this.zza.zzo();
                    Object object2 = zzp2.zza;
                    zzpe.zzc();
                    if (zzfm2.zzs.zzf().zzs(null, zzdy.zzat)) {
                        if (TextUtils.isEmpty((CharSequence)object2)) {
                            Object var3_4 = null;
                        } else {
                            zzc zzc2 = (zzc)zzfm2.zzc.get(object2);
                        }
                    } else {
                        Object var3_9 = null;
                    }
                    if (var3_5 == null) {
                        this.zza.zzay().zzj().zzb("EES not loaded for", (Object)zzp2.zza);
                        this.zzB((zzat)object, zzp2);
                        return;
                    }
                    try {
                        zzaa zzaa2;
                        boolean bl;
                        object2 = this.zza.zzu();
                        Map<String, Object> map = ((zzku)((Object)object2)).zzt(((zzat)object).zzb.zzc(), true);
                        object2 = zzgs.zza((String)((zzat)object).zza);
                        if (object2 == null) {
                            object2 = ((zzat)object).zza;
                        }
                        if (!(bl = var3_5.zze(zzaa2 = new zzaa((String)object2, ((zzat)object).zzd, map)))) break block12;
                        if (!var3_5.zzg()) break block13;
                    }
                    catch (zzd zzd2) {
                        this.zza.zzay().zzd().zzc("EES error. appId, eventName", (Object)zzp2.zzb, (Object)((zzat)object).zza);
                    }
                    this.zza.zzay().zzj().zzb("EES edited event", (Object)((zzat)object).zza);
                    this.zzB(this.zza.zzu().zzi(var3_5.zza().zzb()), zzp2);
                    break block14;
                }
                this.zzB((zzat)object, zzp2);
            }
            if (var3_5.zzf()) {
                for (zzaa zzaa3 : var3_5.zza().zzc()) {
                    this.zza.zzay().zzj().zzb("EES logging created event", (Object)zzaa3.zzd());
                    this.zzB(this.zza.zzu().zzi(zzaa3), zzp2);
                }
            }
            return;
        }
        this.zza.zzay().zzj().zzb("EES was not applied to event", (Object)((zzat)object).zza);
        this.zzB((zzat)object, zzp2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzx(String string, Bundle object) {
        zzaj zzaj2 = ((zzgn)((Object)zzaj2)).zza.zzi();
        zzaj2.zzg();
        zzaj2.zzY();
        zzao zzao2 = new zzao(zzaj2.zzs, "", string, "dep", 0L, 0L, object);
        byte[] byArray = zzaj2.zzf.zzu().zzj(zzao2).zzbs();
        zzaj2.zzs.zzay().zzj().zzc("Saving default event parameters, appId, data size", (Object)zzaj2.zzs.zzj().zzd(string), (Object)byArray.length);
        zzao2 = new ContentValues();
        zzao2.put("app_id", string);
        zzao2.put("parameters", byArray);
        try {
            long l = zzaj2.zzh().insertWithOnConflict("default_event_params", null, (ContentValues)zzao2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzaj2.zzs.zzay().zzd().zzc("Error storing default event parameters. appId", zzel.zzn((String)string), (Object)sQLiteException);
            return;
        }
        zzel zzel2 = zzaj2.zzs.zzay();
        zzel2.zzd().zzb("Failed to insert default event parameters (got -1). appId", zzel.zzn((String)string));
    }

    @BinderThread
    public final void zzk(zzat zzat2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzat2);
        this.zzz(zzp2, false);
        zzgg zzgg2 = new zzgg(this, zzat2, zzp2);
        this.zzy(zzgg2);
    }

    @BinderThread
    public final void zzl(zzat zzat2, String string, String object) {
        Preconditions.checkNotNull((Object)zzat2);
        Preconditions.checkNotEmpty((String)string);
        this.zzA(string, true);
        object = new zzgh(this, zzat2, string);
        this.zzy((Runnable)object);
    }

    private final void zzB(zzat zzat2, zzp zzp2) {
        this.zza.zzA();
        this.zza.zzD(zzat2, zzp2);
    }

    @BinderThread
    public final void zzm(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzA(zzp2.zza, false);
        zzgd zzgd2 = new zzgd(this, zzp2);
        this.zzy(zzgd2);
    }

    @VisibleForTesting
    final void zzy(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzaz().zzs()) {
            runnable.run();
            return;
        }
        this.zza.zzaz().zzp(runnable);
    }

    @BinderThread
    public final void zzn(zzab object, zzp zzp2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzz(zzp2, false);
        zzab zzab2 = new zzab(object);
        zzab2.zza = zzp2.zza;
        object = new zzfx(this, zzab2, zzp2);
        this.zzy((Runnable)object);
    }

    @BinderThread
    public final void zzo(zzab object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        Preconditions.checkNotEmpty((String)object.zza);
        this.zzA(object.zza, true);
        zzab zzab2 = new zzab(object);
        object = new zzfy(this, zzab2);
        this.zzy((Runnable)object);
    }

    @BinderThread
    public final void zzp(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzv);
        zzgf zzgf2 = new zzgf(this, zzp2);
        Preconditions.checkNotNull((Object)zzgf2);
        if (this.zza.zzaz().zzs()) {
            zzgf2.run();
            return;
        }
        this.zza.zzaz().zzq((Runnable)zzgf2);
    }

    @BinderThread
    public final void zzq(long l, String string, String string2, String string3) {
        zzgm zzgm2 = new zzgm(this, string2, string3, string, l);
        this.zzy(zzgm2);
    }

    @BinderThread
    public final void zzr(Bundle bundle, zzp object) {
        this.zzz((zzp)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzfw zzfw2 = new zzfw(this, (String)object, bundle);
        this.zzy(zzfw2);
    }

    @BinderThread
    public final void zzs(zzp zzp2) {
        this.zzz(zzp2, false);
        zzge zzge2 = new zzge(this, zzp2);
        this.zzy(zzge2);
    }

    @BinderThread
    public final void zzt(zzkv zzkv2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzkv2);
        this.zzz(zzp2, false);
        zzgj zzgj2 = new zzgj(this, zzkv2, zzp2);
        this.zzy(zzgj2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzu(zzat zzat2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzat2);
        this.zzA(string, true);
        this.zza.zzay().zzc().zzb("Log and bundle. event", (Object)this.zza.zzj().zzd(zzat2.zza));
        long l = this.zza.zzav().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzks)object).zzaz();
        Object object2 = new zzgi(this, zzat2, string);
        object = object.zzi((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzay().zzd().zzb("Log and bundle returned null. appId", zzel.zzn((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzks)object2).zzav();
            long l2 = object2.nanoTime();
            this.zza.zzay().zzc().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zzd(zzat2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzd("Failed to log and bundle. appId, event, error", zzel.zzn((String)string), (Object)this.zza.zzj().zzd(zzat2.zza), (Object)exception);
            return null;
        }
    }
}

