/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgj
extends zzdw {
    private final zzkp zza;
    private Boolean zzb;
    private String zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzau zzb(zzau zzau2, zzp object) {
        if (!"_cmp".equals(zzau2.zza)) return zzau2;
        zzas zzas2 = zzau2.zzb;
        if (zzas2 == null) return zzau2;
        if (zzas2.zza() == 0) {
            return zzau2;
        }
        String string = zzau2.zzb.zzg("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzau2;
        }
        this.zza.zzay().zzi().zzb("Event has been filtered ", (Object)zzau2.toString());
        return new zzau("_cmpx", zzau2.zzb, zzau2.zzc, zzau2.zzd);
    }

    static /* bridge */ /* synthetic */ zzkp zzc(zzgj zzgj2) {
        return zzgj2.zza;
    }

    @BinderThread
    public final String zzd(zzp zzp2) {
        this.zzy(zzp2, false);
        return this.zza.zzx(zzp2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zze(zzp zzp2, boolean bl) {
        this.zzy(zzp2, false);
        Iterator iterator = zzp2.zza;
        Preconditions.checkNotNull((Object)iterator);
        ArrayList<zzks> arrayList = this.zza;
        arrayList = ((zzkp)((Object)arrayList)).zzaz();
        zzgg zzgg2 = new zzgg(this, (String)((Object)iterator));
        iterator = arrayList.zzh(zzgg2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzks>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzgg2 = (zzku)iterator.next();
                if (!bl && (bl2 = zzkw.zzag((String)((zzku)zzgg2).zzc))) continue;
                zzks zzks2 = new zzks((zzku)zzgg2);
                arrayList.add(zzks2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties. appId", zzeh.zzn((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List zzf(String object, String string, zzp object2) {
        this.zzy((zzp)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        zzkp zzkp2 = this.zza;
        zzkp2 = zzkp2.zzaz();
        zzfx zzfx2 = new zzfx(this, (String)object2, (String)object, string);
        object = zzkp2.zzh(zzfx2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List zzg(String object, String string, String string2) {
        this.zzz((String)object, true);
        zzkp zzkp2 = this.zza;
        zzkp2 = zzkp2.zzaz();
        zzfy zzfy2 = new zzfy(this, (String)object, string, string2);
        object = zzkp2.zzh(zzfy2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzh(String iterator, String arrayList, boolean bl, zzp zzp2) {
        this.zzy(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        zzkp zzkp2 = this.zza;
        zzkp2 = zzkp2.zzaz();
        zzfv zzfv2 = new zzfv(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkp2.zzh(zzfv2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzks>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                string = (zzku)iterator.next();
                if (!bl && (bl2 = zzkw.zzag((String)((zzku)string).zzc))) continue;
                zzks zzks2 = new zzks((zzku)string);
                arrayList.add(zzks2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to query user properties. appId", zzeh.zzn((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzi(String string, String iterator, String arrayList, boolean bl) {
        this.zzz(string, true);
        zzkp zzkp2 = this.zza;
        zzkp2 = zzkp2.zzaz();
        zzfw zzfw2 = new zzfw(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkp2.zzh(zzfw2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzks>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzkp2 = (zzku)iterator.next();
                if (!bl && (bl2 = zzkw.zzag((String)((zzku)zzkp2).zzc))) continue;
                zzks zzks2 = new zzks((zzku)zzkp2);
                arrayList.add(zzks2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties as. appId", zzeh.zzn((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzgj(zzkp zzkp2, String string) {
        Preconditions.checkNotNull((Object)zzkp2);
        this.zza = zzkp2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzj(zzp zzp2) {
        this.zzy(zzp2, false);
        zzgh zzgh2 = new zzgh(this, zzp2);
        this.zzx(zzgh2);
    }

    @BinderThread
    private final void zzy(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzz(zzp2.zza, false);
        this.zza.zzv().zzW(zzp2.zzb, zzp2.zzq);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzz(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzay().zzd().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)this.zza.zzau(), (int)Binder.getCallingUid());
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)this.zza.zzau()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzay().zzd().zzb("Measurement Service called with invalid calling package. appId", zzeh.zzn((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzau(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzv(zzau object, zzp zzp2) {
        block11: {
            Object object22;
            block10: {
                if (!this.zza.zzo().zzl(zzp2.zza)) {
                    this.zzA((zzau)object, zzp2);
                    return;
                }
                this.zza.zzay().zzj().zzb("EES config found for", (Object)zzp2.zza);
                object22 = this.zza.zzo();
                Object object3 = zzp2.zza;
                object22 = TextUtils.isEmpty((CharSequence)object3) ? null : (zzc)((zzfi)((Object)object22)).zzc.get(object3);
                if (object22 == null) {
                    this.zza.zzay().zzj().zzb("EES not loaded for", (Object)zzp2.zza);
                    this.zzA((zzau)object, zzp2);
                    return;
                }
                try {
                    zzaa zzaa2;
                    boolean bl;
                    object3 = this.zza.zzu();
                    Map map = ((zzkr)((Object)object3)).zzs(((zzau)object).zzb.zzc(), true);
                    object3 = zzgo.zza((String)((zzau)object).zza);
                    if (object3 == null) {
                        object3 = ((zzau)object).zza;
                    }
                    if (!(bl = ((zzc)object22).zze(zzaa2 = new zzaa((String)object3, ((zzau)object).zzd, map)))) {
                    }
                    break block10;
                }
                catch (zzd zzd2) {
                    this.zza.zzay().zzd().zzc("EES error. appId, eventName", (Object)zzp2.zzb, (Object)((zzau)object).zza);
                }
                break block11;
            }
            if (((zzc)object22).zzg()) {
                this.zza.zzay().zzj().zzb("EES edited event", (Object)((zzau)object).zza);
                this.zzA(this.zza.zzu().zzi(((zzc)object22).zza().zzb()), zzp2);
            } else {
                this.zzA((zzau)object, zzp2);
            }
            if (((zzc)object22).zzf()) {
                for (Object object22 : ((zzc)object22).zza().zzc()) {
                    this.zza.zzay().zzj().zzb("EES logging created event", (Object)((zzaa)object22).zzd());
                    this.zzA(this.zza.zzu().zzi((zzaa)object22), zzp2);
                }
            }
            return;
        }
        this.zza.zzay().zzj().zzb("EES was not applied to event", (Object)((zzau)object).zza);
        this.zzA((zzau)object, zzp2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzw(String string, Bundle object) {
        zzak zzak2 = ((zzgj)((Object)zzak2)).zza.zzi();
        zzak2.zzg();
        zzak2.zzW();
        zzap zzap2 = new zzap(zzak2.zzs, "", string, "dep", 0L, 0L, object);
        byte[] byArray = zzak2.zzf.zzu().zzj(zzap2).zzbq();
        zzak2.zzs.zzay().zzj().zzc("Saving default event parameters, appId, data size", (Object)zzak2.zzs.zzj().zzd(string), (Object)byArray.length);
        zzap2 = new ContentValues();
        zzap2.put("app_id", string);
        zzap2.put("parameters", byArray);
        try {
            long l = zzak2.zzh().insertWithOnConflict("default_event_params", null, (ContentValues)zzap2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzak2.zzs.zzay().zzd().zzc("Error storing default event parameters. appId", zzeh.zzn((String)string), (Object)sQLiteException);
            return;
        }
        zzeh zzeh2 = zzak2.zzs.zzay();
        zzeh2.zzd().zzb("Failed to insert default event parameters (got -1). appId", zzeh.zzn((String)string));
    }

    @BinderThread
    public final void zzk(zzau zzau2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzau2);
        this.zzy(zzp2, false);
        zzgc zzgc2 = new zzgc(this, zzau2, zzp2);
        this.zzx(zzgc2);
    }

    @BinderThread
    public final void zzl(zzau zzau2, String string, String object) {
        Preconditions.checkNotNull((Object)zzau2);
        Preconditions.checkNotEmpty((String)string);
        this.zzz(string, true);
        object = new zzgd(this, zzau2, string);
        this.zzx((Runnable)object);
    }

    private final void zzA(zzau zzau2, zzp zzp2) {
        this.zza.zzA();
        this.zza.zzD(zzau2, zzp2);
    }

    @BinderThread
    public final void zzm(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzz(zzp2.zza, false);
        zzfz zzfz2 = new zzfz(this, zzp2);
        this.zzx(zzfz2);
    }

    @VisibleForTesting
    final void zzx(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzaz().zzs()) {
            runnable.run();
            return;
        }
        this.zza.zzaz().zzp(runnable);
    }

    @BinderThread
    public final void zzn(zzab object, zzp zzp2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzy(zzp2, false);
        zzab zzab2 = new zzab(object);
        zzab2.zza = zzp2.zza;
        object = new zzft(this, zzab2, zzp2);
        this.zzx((Runnable)object);
    }

    @BinderThread
    public final void zzo(zzab object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        Preconditions.checkNotEmpty((String)object.zza);
        this.zzz(object.zza, true);
        zzab zzab2 = new zzab(object);
        object = new zzfu(this, zzab2);
        this.zzx((Runnable)object);
    }

    @BinderThread
    public final void zzp(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzv);
        zzgb zzgb2 = new zzgb(this, zzp2);
        Preconditions.checkNotNull((Object)zzgb2);
        if (this.zza.zzaz().zzs()) {
            zzgb2.run();
            return;
        }
        this.zza.zzaz().zzq((Runnable)zzgb2);
    }

    @BinderThread
    public final void zzq(long l, String string, String string2, String string3) {
        zzgi zzgi2 = new zzgi(this, string2, string3, string, l);
        this.zzx(zzgi2);
    }

    @BinderThread
    public final void zzr(Bundle bundle, zzp object) {
        this.zzy((zzp)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzfs zzfs2 = new zzfs(this, (String)object, bundle);
        this.zzx(zzfs2);
    }

    @BinderThread
    public final void zzs(zzp zzp2) {
        this.zzy(zzp2, false);
        zzga zzga2 = new zzga(this, zzp2);
        this.zzx(zzga2);
    }

    @BinderThread
    public final void zzt(zzks zzks2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzks2);
        this.zzy(zzp2, false);
        zzgf zzgf2 = new zzgf(this, zzks2, zzp2);
        this.zzx(zzgf2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzu(zzau zzau2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzau2);
        this.zzz(string, true);
        this.zza.zzay().zzc().zzb("Log and bundle. event", (Object)this.zza.zzj().zzd(zzau2.zza));
        long l = this.zza.zzav().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzkp)object).zzaz();
        Object object2 = new zzge(this, zzau2, string);
        object = object.zzi((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzay().zzd().zzb("Log and bundle returned null. appId", zzeh.zzn((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzkp)object2).zzav();
            long l2 = object2.nanoTime();
            this.zza.zzay().zzc().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zzd(zzau2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzd("Failed to log and bundle. appId, event, error", zzeh.zzn((String)string), (Object)this.zza.zzj().zzd(zzau2.zza), (Object)exception);
            return null;
        }
    }
}

