/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgq
extends zzed {
    private final zzkz zza;
    private Boolean zzb;
    private String zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzaw zzb(zzaw zzaw2, zzq object) {
        if (!"_cmp".equals(zzaw2.zza)) return zzaw2;
        zzau zzau2 = zzaw2.zzb;
        if (zzau2 == null) return zzaw2;
        if (zzau2.zza() == 0) {
            return zzaw2;
        }
        String string = zzaw2.zzb.zzg("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzaw2;
        }
        this.zza.zzay().zzi().zzb("Event has been filtered ", (Object)zzaw2.toString());
        return new zzaw("_cmpx", zzaw2.zzb, zzaw2.zzc, zzaw2.zzd);
    }

    static /* bridge */ /* synthetic */ zzkz zzc(zzgq zzgq2) {
        return zzgq2.zza;
    }

    @BinderThread
    public final String zzd(zzq zzq2) {
        this.zzy(zzq2, false);
        return this.zza.zzx(zzq2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zze(zzq zzq2, boolean bl) {
        this.zzy(zzq2, false);
        Iterator iterator = zzq2.zza;
        Preconditions.checkNotNull((Object)iterator);
        ArrayList<zzlc> arrayList = this.zza;
        arrayList = ((zzkz)((Object)arrayList)).zzaz();
        zzgn zzgn2 = new zzgn(this, (String)((Object)iterator));
        iterator = arrayList.zzh(zzgn2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzlc>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzgn2 = (zzle)iterator.next();
                if (!bl && (bl2 = zzlh.zzah((String)((zzle)zzgn2).zzc))) continue;
                zzlc zzlc2 = new zzlc((zzle)zzgn2);
                arrayList.add(zzlc2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties. appId", zzeo.zzn((String)zzq2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List zzf(String object, String string, zzq object2) {
        this.zzy((zzq)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        zzkz zzkz2 = this.zza;
        zzkz2 = zzkz2.zzaz();
        zzge zzge2 = new zzge(this, (String)object2, (String)object, string);
        object = zzkz2.zzh(zzge2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List zzg(String object, String string, String string2) {
        this.zzz((String)object, true);
        zzkz zzkz2 = this.zza;
        zzkz2 = zzkz2.zzaz();
        zzgf zzgf2 = new zzgf(this, (String)object, string, string2);
        object = zzkz2.zzh(zzgf2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzh(String iterator, String arrayList, boolean bl, zzq zzq2) {
        this.zzy(zzq2, false);
        String string = zzq2.zza;
        Preconditions.checkNotNull((Object)string);
        zzkz zzkz2 = this.zza;
        zzkz2 = zzkz2.zzaz();
        zzgc zzgc2 = new zzgc(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkz2.zzh(zzgc2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzlc>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                string = (zzle)iterator.next();
                if (!bl && (bl2 = zzlh.zzah((String)((zzle)string).zzc))) continue;
                zzlc zzlc2 = new zzlc((zzle)string);
                arrayList.add(zzlc2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to query user properties. appId", zzeo.zzn((String)zzq2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzi(String string, String iterator, String arrayList, boolean bl) {
        this.zzz(string, true);
        zzkz zzkz2 = this.zza;
        zzkz2 = zzkz2.zzaz();
        zzgd zzgd2 = new zzgd(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkz2.zzh(zzgd2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzlc>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzkz2 = (zzle)iterator.next();
                if (!bl && (bl2 = zzlh.zzah((String)((zzle)zzkz2).zzc))) continue;
                zzlc zzlc2 = new zzlc((zzle)zzkz2);
                arrayList.add(zzlc2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties as. appId", zzeo.zzn((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzgq(zzkz zzkz2, String string) {
        Preconditions.checkNotNull((Object)zzkz2);
        this.zza = zzkz2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzj(zzq zzq2) {
        this.zzy(zzq2, false);
        zzgo zzgo2 = new zzgo(this, zzq2);
        this.zzx(zzgo2);
    }

    @BinderThread
    private final void zzy(zzq zzq2, boolean bl) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zzz(zzq2.zza, false);
        this.zza.zzv().zzX(zzq2.zzb, zzq2.zzq);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzz(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzay().zzd().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)this.zza.zzau(), (int)Binder.getCallingUid());
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)this.zza.zzau()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzay().zzd().zzb("Measurement Service called with invalid calling package. appId", zzeo.zzn((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzau(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzv(zzaw object, zzq zzq2) {
        block11: {
            Object object22;
            block10: {
                if (!this.zza.zzo().zzo(zzq2.zza)) {
                    this.zzA((zzaw)object, zzq2);
                    return;
                }
                this.zza.zzay().zzj().zzb("EES config found for", (Object)zzq2.zza);
                object22 = this.zza.zzo();
                Object object3 = zzq2.zza;
                object22 = TextUtils.isEmpty((CharSequence)object3) ? null : (zzc)((zzfp)((Object)object22)).zzd.get(object3);
                if (object22 == null) {
                    this.zza.zzay().zzj().zzb("EES not loaded for", (Object)zzq2.zza);
                    this.zzA((zzaw)object, zzq2);
                    return;
                }
                try {
                    zzaa zzaa2;
                    boolean bl;
                    object3 = this.zza.zzu();
                    Map map = ((zzlb)((Object)object3)).zzs(((zzaw)object).zzb.zzc(), true);
                    object3 = zzgv.zza((String)((zzaw)object).zza);
                    if (object3 == null) {
                        object3 = ((zzaw)object).zza;
                    }
                    if (!(bl = ((zzc)object22).zze(zzaa2 = new zzaa((String)object3, ((zzaw)object).zzd, map)))) {
                    }
                    break block10;
                }
                catch (zzd zzd2) {
                    this.zza.zzay().zzd().zzc("EES error. appId, eventName", (Object)zzq2.zzb, (Object)((zzaw)object).zza);
                }
                break block11;
            }
            if (((zzc)object22).zzg()) {
                this.zza.zzay().zzj().zzb("EES edited event", (Object)((zzaw)object).zza);
                this.zzA(this.zza.zzu().zzi(((zzc)object22).zza().zzb()), zzq2);
            } else {
                this.zzA((zzaw)object, zzq2);
            }
            if (((zzc)object22).zzf()) {
                for (Object object22 : ((zzc)object22).zza().zzc()) {
                    this.zza.zzay().zzj().zzb("EES logging created event", (Object)((zzaa)object22).zzd());
                    this.zzA(this.zza.zzu().zzi((zzaa)object22), zzq2);
                }
            }
            return;
        }
        this.zza.zzay().zzj().zzb("EES was not applied to event", (Object)((zzaw)object).zza);
        this.zzA((zzaw)object, zzq2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzw(String string, Bundle object) {
        zzam zzam2 = ((zzgq)((Object)zzam2)).zza.zzi();
        zzam2.zzg();
        zzam2.zzW();
        zzar zzar2 = new zzar(zzam2.zzs, "", string, "dep", 0L, 0L, object);
        byte[] byArray = zzam2.zzf.zzu().zzj(zzar2).zzbv();
        zzam2.zzs.zzay().zzj().zzc("Saving default event parameters, appId, data size", (Object)zzam2.zzs.zzj().zzd(string), (Object)byArray.length);
        zzar2 = new ContentValues();
        zzar2.put("app_id", string);
        zzar2.put("parameters", byArray);
        try {
            long l = zzam2.zzh().insertWithOnConflict("default_event_params", null, (ContentValues)zzar2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzam2.zzs.zzay().zzd().zzc("Error storing default event parameters. appId", zzeo.zzn((String)string), (Object)sQLiteException);
            return;
        }
        zzeo zzeo2 = zzam2.zzs.zzay();
        zzeo2.zzd().zzb("Failed to insert default event parameters (got -1). appId", zzeo.zzn((String)string));
    }

    @BinderThread
    public final void zzk(zzaw zzaw2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzaw2);
        this.zzy(zzq2, false);
        zzgj zzgj2 = new zzgj(this, zzaw2, zzq2);
        this.zzx(zzgj2);
    }

    @BinderThread
    public final void zzl(zzaw zzaw2, String string, String object) {
        Preconditions.checkNotNull((Object)zzaw2);
        Preconditions.checkNotEmpty((String)string);
        this.zzz(string, true);
        object = new zzgk(this, zzaw2, string);
        this.zzx((Runnable)object);
    }

    private final void zzA(zzaw zzaw2, zzq zzq2) {
        this.zza.zzA();
        this.zza.zzE(zzaw2, zzq2);
    }

    @BinderThread
    public final void zzm(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zzz(zzq2.zza, false);
        zzgg zzgg2 = new zzgg(this, zzq2);
        this.zzx(zzgg2);
    }

    @VisibleForTesting
    final void zzx(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzaz().zzs()) {
            runnable.run();
            return;
        }
        this.zza.zzaz().zzp(runnable);
    }

    @BinderThread
    public final void zzn(zzac object, zzq zzq2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzy(zzq2, false);
        zzac zzac2 = new zzac(object);
        zzac2.zza = zzq2.zza;
        object = new zzga(this, zzac2, zzq2);
        this.zzx((Runnable)object);
    }

    @BinderThread
    public final void zzo(zzac object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        Preconditions.checkNotEmpty((String)object.zza);
        this.zzz(object.zza, true);
        zzac zzac2 = new zzac(object);
        object = new zzgb(this, zzac2);
        this.zzx((Runnable)object);
    }

    @BinderThread
    public final void zzp(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Preconditions.checkNotNull((Object)zzq2.zzv);
        zzgi zzgi2 = new zzgi(this, zzq2);
        Preconditions.checkNotNull((Object)zzgi2);
        if (this.zza.zzaz().zzs()) {
            zzgi2.run();
            return;
        }
        this.zza.zzaz().zzq((Runnable)zzgi2);
    }

    @BinderThread
    public final void zzq(long l, String string, String string2, String string3) {
        zzgp zzgp2 = new zzgp(this, string2, string3, string, l);
        this.zzx(zzgp2);
    }

    @BinderThread
    public final void zzr(Bundle bundle, zzq object) {
        this.zzy((zzq)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzfz zzfz2 = new zzfz(this, (String)object, bundle);
        this.zzx(zzfz2);
    }

    @BinderThread
    public final void zzs(zzq zzq2) {
        this.zzy(zzq2, false);
        zzgh zzgh2 = new zzgh(this, zzq2);
        this.zzx(zzgh2);
    }

    @BinderThread
    public final void zzt(zzlc zzlc2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzlc2);
        this.zzy(zzq2, false);
        zzgm zzgm2 = new zzgm(this, zzlc2, zzq2);
        this.zzx(zzgm2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzu(zzaw zzaw2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzaw2);
        this.zzz(string, true);
        this.zza.zzay().zzc().zzb("Log and bundle. event", (Object)this.zza.zzj().zzd(zzaw2.zza));
        long l = this.zza.zzav().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzkz)object).zzaz();
        Object object2 = new zzgl(this, zzaw2, string);
        object = object.zzi((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzay().zzd().zzb("Log and bundle returned null. appId", zzeo.zzn((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzkz)object2).zzav();
            long l2 = object2.nanoTime();
            this.zza.zzay().zzc().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zzd(zzaw2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzd("Failed to log and bundle. appId, event, error", zzeo.zzn((String)string), (Object)this.zza.zzj().zzd(zzaw2.zza), (Object)exception);
            return null;
        }
    }
}

