/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgj
extends zzdw {
    private final zzkt zza;
    private Boolean zzb;
    private String zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzaw zzb(zzaw zzaw2, zzq object) {
        if (!"_cmp".equals(zzaw2.zza)) return zzaw2;
        zzau zzau2 = zzaw2.zzb;
        if (zzau2 == null) return zzaw2;
        if (zzau2.zza() == 0) {
            return zzaw2;
        }
        String string = zzaw2.zzb.zzg("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzaw2;
        }
        this.zza.zzay().zzi().zzb("Event has been filtered ", (Object)zzaw2.toString());
        return new zzaw("_cmpx", zzaw2.zzb, zzaw2.zzc, zzaw2.zzd);
    }

    static /* bridge */ /* synthetic */ zzkt zzc(zzgj zzgj2) {
        return zzgj2.zza;
    }

    @BinderThread
    public final String zzd(zzq zzq2) {
        this.zzy(zzq2, false);
        return this.zza.zzx(zzq2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zze(zzq zzq2, boolean bl) {
        this.zzy(zzq2, false);
        Iterator iterator = zzq2.zza;
        Preconditions.checkNotNull((Object)iterator);
        ArrayList<zzkw> arrayList = this.zza;
        arrayList = ((zzkt)((Object)arrayList)).zzaz();
        zzgg zzgg2 = new zzgg(this, (String)((Object)iterator));
        iterator = arrayList.zzh(zzgg2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkw>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzgg2 = (zzky)iterator.next();
                if (!bl && (bl2 = zzlb.zzah((String)((zzky)zzgg2).zzc))) continue;
                zzkw zzkw2 = new zzkw((zzky)zzgg2);
                arrayList.add(zzkw2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties. appId", zzeh.zzn((String)zzq2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List zzf(String object, String string, zzq object2) {
        this.zzy((zzq)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        zzkt zzkt2 = this.zza;
        zzkt2 = zzkt2.zzaz();
        zzfx zzfx2 = new zzfx(this, (String)object2, (String)object, string);
        object = zzkt2.zzh(zzfx2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List zzg(String object, String string, String string2) {
        this.zzz((String)object, true);
        zzkt zzkt2 = this.zza;
        zzkt2 = zzkt2.zzaz();
        zzfy zzfy2 = new zzfy(this, (String)object, string, string2);
        object = zzkt2.zzh(zzfy2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzh(String iterator, String arrayList, boolean bl, zzq zzq2) {
        this.zzy(zzq2, false);
        String string = zzq2.zza;
        Preconditions.checkNotNull((Object)string);
        zzkt zzkt2 = this.zza;
        zzkt2 = zzkt2.zzaz();
        zzfv zzfv2 = new zzfv(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkt2.zzh(zzfv2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkw>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                string = (zzky)iterator.next();
                if (!bl && (bl2 = zzlb.zzah((String)((zzky)string).zzc))) continue;
                zzkw zzkw2 = new zzkw((zzky)string);
                arrayList.add(zzkw2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to query user properties. appId", zzeh.zzn((String)zzq2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzi(String string, String iterator, String arrayList, boolean bl) {
        this.zzz(string, true);
        zzkt zzkt2 = this.zza;
        zzkt2 = zzkt2.zzaz();
        zzfw zzfw2 = new zzfw(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkt2.zzh(zzfw2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkw>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzkt2 = (zzky)iterator.next();
                if (!bl && (bl2 = zzlb.zzah((String)((zzky)zzkt2).zzc))) continue;
                zzkw zzkw2 = new zzkw((zzky)zzkt2);
                arrayList.add(zzkw2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties as. appId", zzeh.zzn((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzgj(zzkt zzkt2, String string) {
        Preconditions.checkNotNull((Object)zzkt2);
        this.zza = zzkt2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzj(zzq zzq2) {
        this.zzy(zzq2, false);
        zzgh zzgh2 = new zzgh(this, zzq2);
        this.zzx(zzgh2);
    }

    @BinderThread
    private final void zzy(zzq zzq2, boolean bl) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zzz(zzq2.zza, false);
        this.zza.zzv().zzX(zzq2.zzb, zzq2.zzq);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzz(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzay().zzd().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)this.zza.zzau(), (int)Binder.getCallingUid());
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)this.zza.zzau()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzay().zzd().zzb("Measurement Service called with invalid calling package. appId", zzeh.zzn((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzau(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzv(zzaw object, zzq zzq2) {
        block11: {
            Object object22;
            block10: {
                if (!this.zza.zzo().zzo(zzq2.zza)) {
                    this.zzA((zzaw)object, zzq2);
                    return;
                }
                this.zza.zzay().zzj().zzb("EES config found for", (Object)zzq2.zza);
                object22 = this.zza.zzo();
                Object object3 = zzq2.zza;
                object22 = TextUtils.isEmpty((CharSequence)object3) ? null : (zzc)((zzfi)((Object)object22)).zzd.get(object3);
                if (object22 == null) {
                    this.zza.zzay().zzj().zzb("EES not loaded for", (Object)zzq2.zza);
                    this.zzA((zzaw)object, zzq2);
                    return;
                }
                try {
                    zzaa zzaa2;
                    boolean bl;
                    object3 = this.zza.zzu();
                    Map map = ((zzkv)((Object)object3)).zzs(((zzaw)object).zzb.zzc(), true);
                    object3 = zzgo.zza((String)((zzaw)object).zza);
                    if (object3 == null) {
                        object3 = ((zzaw)object).zza;
                    }
                    if (!(bl = ((zzc)object22).zze(zzaa2 = new zzaa((String)object3, ((zzaw)object).zzd, map)))) {
                    }
                    break block10;
                }
                catch (zzd zzd2) {
                    this.zza.zzay().zzd().zzc("EES error. appId, eventName", (Object)zzq2.zzb, (Object)((zzaw)object).zza);
                }
                break block11;
            }
            if (((zzc)object22).zzg()) {
                this.zza.zzay().zzj().zzb("EES edited event", (Object)((zzaw)object).zza);
                this.zzA(this.zza.zzu().zzi(((zzc)object22).zza().zzb()), zzq2);
            } else {
                this.zzA((zzaw)object, zzq2);
            }
            if (((zzc)object22).zzf()) {
                for (Object object22 : ((zzc)object22).zza().zzc()) {
                    this.zza.zzay().zzj().zzb("EES logging created event", (Object)((zzaa)object22).zzd());
                    this.zzA(this.zza.zzu().zzi((zzaa)object22), zzq2);
                }
            }
            return;
        }
        this.zza.zzay().zzj().zzb("EES was not applied to event", (Object)((zzaw)object).zza);
        this.zzA((zzaw)object, zzq2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzw(String string, Bundle object) {
        zzam zzam2 = ((zzgj)((Object)zzam2)).zza.zzi();
        zzam2.zzg();
        zzam2.zzW();
        zzar zzar2 = new zzar(zzam2.zzt, "", string, "dep", 0L, 0L, object);
        byte[] byArray = zzam2.zzf.zzu().zzj(zzar2).zzbu();
        zzam2.zzt.zzay().zzj().zzc("Saving default event parameters, appId, data size", (Object)zzam2.zzt.zzj().zzd(string), (Object)byArray.length);
        zzar2 = new ContentValues();
        zzar2.put("app_id", string);
        zzar2.put("parameters", byArray);
        try {
            long l = zzam2.zzh().insertWithOnConflict("default_event_params", null, (ContentValues)zzar2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzam2.zzt.zzay().zzd().zzc("Error storing default event parameters. appId", zzeh.zzn((String)string), (Object)sQLiteException);
            return;
        }
        zzeh zzeh2 = zzam2.zzt.zzay();
        zzeh2.zzd().zzb("Failed to insert default event parameters (got -1). appId", zzeh.zzn((String)string));
    }

    @BinderThread
    public final void zzk(zzaw zzaw2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzaw2);
        this.zzy(zzq2, false);
        zzgc zzgc2 = new zzgc(this, zzaw2, zzq2);
        this.zzx(zzgc2);
    }

    @BinderThread
    public final void zzl(zzaw zzaw2, String string, String object) {
        Preconditions.checkNotNull((Object)zzaw2);
        Preconditions.checkNotEmpty((String)string);
        this.zzz(string, true);
        object = new zzgd(this, zzaw2, string);
        this.zzx((Runnable)object);
    }

    private final void zzA(zzaw zzaw2, zzq zzq2) {
        this.zza.zzA();
        this.zza.zzE(zzaw2, zzq2);
    }

    @BinderThread
    public final void zzm(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zzz(zzq2.zza, false);
        zzfz zzfz2 = new zzfz(this, zzq2);
        this.zzx(zzfz2);
    }

    @VisibleForTesting
    final void zzx(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzaz().zzs()) {
            runnable.run();
            return;
        }
        this.zza.zzaz().zzp(runnable);
    }

    @BinderThread
    public final void zzn(zzac object, zzq zzq2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzy(zzq2, false);
        zzac zzac2 = new zzac(object);
        zzac2.zza = zzq2.zza;
        object = new zzft(this, zzac2, zzq2);
        this.zzx((Runnable)object);
    }

    @BinderThread
    public final void zzo(zzac object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        Preconditions.checkNotEmpty((String)object.zza);
        this.zzz(object.zza, true);
        zzac zzac2 = new zzac(object);
        object = new zzfu(this, zzac2);
        this.zzx((Runnable)object);
    }

    @BinderThread
    public final void zzp(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Preconditions.checkNotNull((Object)zzq2.zzv);
        zzgb zzgb2 = new zzgb(this, zzq2);
        Preconditions.checkNotNull((Object)zzgb2);
        if (this.zza.zzaz().zzs()) {
            zzgb2.run();
            return;
        }
        this.zza.zzaz().zzq((Runnable)zzgb2);
    }

    @BinderThread
    public final void zzq(long l, String string, String string2, String string3) {
        zzgi zzgi2 = new zzgi(this, string2, string3, string, l);
        this.zzx(zzgi2);
    }

    @BinderThread
    public final void zzr(Bundle bundle, zzq object) {
        this.zzy((zzq)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzfs zzfs2 = new zzfs(this, (String)object, bundle);
        this.zzx(zzfs2);
    }

    @BinderThread
    public final void zzs(zzq zzq2) {
        this.zzy(zzq2, false);
        zzga zzga2 = new zzga(this, zzq2);
        this.zzx(zzga2);
    }

    @BinderThread
    public final void zzt(zzkw zzkw2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzkw2);
        this.zzy(zzq2, false);
        zzgf zzgf2 = new zzgf(this, zzkw2, zzq2);
        this.zzx(zzgf2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzu(zzaw zzaw2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzaw2);
        this.zzz(string, true);
        this.zza.zzay().zzc().zzb("Log and bundle. event", (Object)this.zza.zzj().zzd(zzaw2.zza));
        long l = this.zza.zzav().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzkt)object).zzaz();
        Object object2 = new zzge(this, zzaw2, string);
        object = object.zzi((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzay().zzd().zzb("Log and bundle returned null. appId", zzeh.zzn((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzkt)object2).zzav();
            long l2 = object2.nanoTime();
            this.zza.zzay().zzc().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zzd(zzaw2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzd("Failed to log and bundle. appId, event, error", zzeh.zzn((String)string), (Object)this.zza.zzj().zzd(zzaw2.zza), (Object)exception);
            return null;
        }
    }
}

