/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzll;
import com.google.android.gms.internal.measurement.zzpd;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzq;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public final class zzkv
extends zzkh {
    static int zza(zzgc zzgc2, String string) {
        for (int i = 0; i < zzgc2.zzb(); ++i) {
            if (!string.equals(zzgc2.zzao(i).zzf())) continue;
            return i;
        }
        return -1;
    }

    @WorkerThread
    final long zzd(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzt.zzv().zzg();
        MessageDigest messageDigest = zzlb.zzF();
        if (messageDigest == null) {
            this.zzt.zzay().zzd().zza("Failed to get MD5");
            return 0L;
        }
        return zzlb.zzp((byte[])messageDigest.digest(byArray));
    }

    final Bundle zzf(Map map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v == null) {
                bundle.putString(string, null);
                continue;
            }
            if (v instanceof Long) {
                bundle.putLong(string, ((Long)v).longValue());
                continue;
            }
            if (v instanceof Double) {
                bundle.putDouble(string, ((Double)v).doubleValue());
                continue;
            }
            if (v instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)v;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    arrayList2.add(this.zzf((Map)arrayList.get(i), false));
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, v.toString());
        }
        return bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Parcelable zzh(byte[] object, Parcelable.Creator creator) {
        if (object == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall((byte[])object, 0, ((Object)object).length);
            parcel.setDataPosition(0);
            object = (Parcelable)creator.createFromParcel(parcel);
        }
        catch (SafeParcelReader.ParseException parseException) {
            try {
                zzkv zzkv2;
                zzkv2 = zzkv2.zzt.zzay();
                zzkv2.zzd().zza("Failed to load parcelable from buffer");
                return null;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                parcel.recycle();
            }
        }
        parcel.recycle();
        return object;
    }

    final zzaw zzi(zzaa zzaa2) {
        Object object;
        Bundle bundle = object2.zzf(zzaa2.zze(), true);
        Object object2 = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            object2 = object.toString();
        }
        if ((object = zzgo.zzb((String)zzaa2.zzd())) == null) {
            object = zzaa2.zzd();
        }
        zzau zzau2 = new zzau(bundle);
        zzaw zzaw2 = new zzaw((String)object, zzau2, (String)object2, zzaa2.zza());
        return zzaw2;
    }

    final zzft zzj(zzar zzar2) {
        zzfs zzfs2 = zzft.zze();
        zzfs2.zzl(zzar2.zze);
        Object object = zzar2.zzf;
        zzat zzat2 = new zzat(object);
        while (zzat2.hasNext()) {
            object = zzat2.zza();
            zzfw zzfw2 = zzfx.zze();
            zzfw2.zzj((String)object);
            object = zzar2.zzf.zzf((String)object);
            Preconditions.checkNotNull((Object)object);
            this.zzt(zzfw2, object);
            zzfs2.zze(zzfw2);
        }
        return (zzft)zzfs2.zzaC();
    }

    static zzll zzl(zzll zzll2, byte[] byArray) throws zzkp {
        zzjr zzjr2 = zzjr.zza();
        if (zzjr2 != null) {
            return zzll2.zzay(byArray, zzjr2);
        }
        return zzll2.zzax(byArray);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    final String zzm(zzgb var1_1) {
        if (var1_1 == null) {
            return "";
        }
        var2_2 = new StringBuilder();
        var2_2.append("\nbatch {\n");
        var3_3 = var1_1.zzd().iterator();
        block0: while (true) {
            if (!var3_3.hasNext()) {
                var2_2.append("}\n");
                return var2_2.toString();
            }
            var4_4 = (zzgd)var3_3.next();
            if (var4_4 == null) continue;
            zzkv.zzF(var2_2, 1);
            var2_2.append("bundle {\n");
            if (var4_4.zzbj()) {
                zzkv.zzI(var2_2, 1, "protocol_version", var4_4.zzd());
            }
            zzpd.zzc();
            if (this.zzt.zzf().zzs(null, zzdu.zzal) && this.zzt.zzf().zzs(var4_4.zzx(), zzdu.zzan) && var4_4.zzbm()) {
                zzkv.zzI(var2_2, 1, "session_stitching_token", var4_4.zzK());
            }
            zzkv.zzI(var2_2, 1, "platform", var4_4.zzI());
            if (var4_4.zzbf()) {
                zzkv.zzI(var2_2, 1, "gmp_version", var4_4.zzm());
            }
            if (var4_4.zzbq()) {
                zzkv.zzI(var2_2, 1, "uploading_gmp_version", var4_4.zzr());
            }
            if (var4_4.zzbd()) {
                zzkv.zzI(var2_2, 1, "dynamite_version", var4_4.zzj());
            }
            if (var4_4.zzba()) {
                zzkv.zzI(var2_2, 1, "config_version", var4_4.zzh());
            }
            zzkv.zzI(var2_2, 1, "gmp_app_id", var4_4.zzF());
            zzkv.zzI(var2_2, 1, "admob_app_id", var4_4.zzw());
            zzkv.zzI(var2_2, 1, "app_id", var4_4.zzx());
            zzkv.zzI(var2_2, 1, "app_version", var4_4.zzA());
            if (var4_4.zzaY()) {
                zzkv.zzI(var2_2, 1, "app_version_major", var4_4.zza());
            }
            zzkv.zzI(var2_2, 1, "firebase_instance_id", var4_4.zzE());
            if (var4_4.zzbc()) {
                zzkv.zzI(var2_2, 1, "dev_cert_hash", var4_4.zzi());
            }
            zzkv.zzI(var2_2, 1, "app_store", var4_4.zzz());
            if (var4_4.zzbp()) {
                zzkv.zzI(var2_2, 1, "upload_timestamp_millis", var4_4.zzq());
            }
            if (var4_4.zzbn()) {
                zzkv.zzI(var2_2, 1, "start_timestamp_millis", var4_4.zzp());
            }
            if (var4_4.zzbe()) {
                zzkv.zzI(var2_2, 1, "end_timestamp_millis", var4_4.zzk());
            }
            if (var4_4.zzbi()) {
                zzkv.zzI(var2_2, 1, "previous_bundle_start_timestamp_millis", var4_4.zzo());
            }
            if (var4_4.zzbh()) {
                zzkv.zzI(var2_2, 1, "previous_bundle_end_timestamp_millis", var4_4.zzn());
            }
            zzkv.zzI(var2_2, 1, "app_instance_id", var4_4.zzy());
            zzkv.zzI(var2_2, 1, "resettable_device_id", var4_4.zzJ());
            zzkv.zzI(var2_2, 1, "ds_id", var4_4.zzD());
            if (var4_4.zzbg()) {
                zzkv.zzI(var2_2, 1, "limited_ad_tracking", var4_4.zzaW());
            }
            zzkv.zzI(var2_2, 1, "os_version", var4_4.zzH());
            zzkv.zzI(var2_2, 1, "device_model", var4_4.zzC());
            zzkv.zzI(var2_2, 1, "user_default_language", var4_4.zzL());
            if (var4_4.zzbo()) {
                zzkv.zzI(var2_2, 1, "time_zone_offset_minutes", var4_4.zzf());
            }
            if (var4_4.zzaZ()) {
                zzkv.zzI(var2_2, 1, "bundle_sequential_index", var4_4.zzb());
            }
            if (var4_4.zzbl()) {
                zzkv.zzI(var2_2, 1, "service_upload", var4_4.zzaX());
            }
            zzkv.zzI(var2_2, 1, "health_monitor", var4_4.zzG());
            if (var4_4.zzbk()) {
                zzkv.zzI(var2_2, 1, "retry_counter", var4_4.zze());
            }
            if (var4_4.zzbb()) {
                zzkv.zzI(var2_2, 1, "consent_signals", var4_4.zzB());
            }
            if ((var1_1 = var4_4.zzO()) == null) ** GOTO lbl75
            var5_5 /* !! */  = var1_1.iterator();
            while (true) {
                block37: {
                    if (var5_5 /* !! */ .hasNext()) break block37;
lbl75:
                    // 2 sources

                    if ((var1_1 = var4_4.zzM()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var5_5 /* !! */  = (zzfp)var1_1.next();
                            if (var5_5 /* !! */  == null) continue;
                            zzkv.zzF(var2_2, 2);
                            var2_2.append("audience_membership {\n");
                            if (var5_5 /* !! */ .zzk()) {
                                zzkv.zzI(var2_2, 2, "audience_id", var5_5 /* !! */ .zza());
                            }
                            if (var5_5 /* !! */ .zzm()) {
                                zzkv.zzI(var2_2, 2, "new_audience", var5_5 /* !! */ .zzj());
                            }
                            zzkv.zzH(var2_2, 2, "current_data", var5_5 /* !! */ .zzd());
                            if (var5_5 /* !! */ .zzn()) {
                                zzkv.zzH(var2_2, 2, "previous_data", var5_5 /* !! */ .zze());
                            }
                            zzkv.zzF(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    if ((var1_1 = var4_4.zzN()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var4_4 = (zzft)var1_1.next();
                            if (var4_4 == null) continue;
                            zzkv.zzF(var2_2, 2);
                            var2_2.append("event {\n");
                            zzkv.zzI(var2_2, 2, "name", this.zzt.zzj().zzd(var4_4.zzh()));
                            if (var4_4.zzu()) {
                                zzkv.zzI(var2_2, 2, "timestamp_millis", var4_4.zzd());
                            }
                            if (var4_4.zzt()) {
                                zzkv.zzI(var2_2, 2, "previous_timestamp_millis", var4_4.zzc());
                            }
                            if (var4_4.zzs()) {
                                zzkv.zzI(var2_2, 2, "count", var4_4.zza());
                            }
                            if (var4_4.zzb() != 0) {
                                this.zzD(var2_2, 2, var4_4.zzi());
                            }
                            zzkv.zzF(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    zzkv.zzF(var2_2, 1);
                    var2_2.append("}\n");
                    continue block0;
                }
                var6_6 = (zzgm)var5_5 /* !! */ .next();
                if (var6_6 == null) continue;
                zzkv.zzF(var2_2, 2);
                var2_2.append("user_property {\n");
                var1_1 = var6_6.zzs() != false ? Long.valueOf(var6_6.zzc()) : null;
                zzkv.zzI(var2_2, 2, "set_timestamp_millis", var1_1);
                zzkv.zzI(var2_2, 2, "name", this.zzt.zzj().zzf(var6_6.zzf()));
                zzkv.zzI(var2_2, 2, "string_value", var6_6.zzg());
                var1_1 = var6_6.zzr() != false ? Long.valueOf(var6_6.zzb()) : null;
                zzkv.zzI(var2_2, 2, "int_value", var1_1);
                var1_1 = var6_6.zzq() != false ? Double.valueOf(var6_6.zza()) : null;
                zzkv.zzI(var2_2, 2, "double_value", var1_1);
                zzkv.zzF(var2_2, 2);
                var2_2.append("}\n");
            }
            break;
        }
    }

    final String zzo(zzek object) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (((zzek)((Object)object)).zzp()) {
            zzkv.zzI(stringBuilder, 0, "filter_id", ((zzek)((Object)object)).zzb());
        }
        zzkv.zzI(stringBuilder, 0, "event_name", this.zzt.zzj().zzd(((zzek)((Object)object)).zzg()));
        String string = zzkv.zzG(((zzek)((Object)object)).zzk(), ((zzek)((Object)object)).zzm(), ((zzek)((Object)object)).zzn());
        if (!string.isEmpty()) {
            zzkv.zzI(stringBuilder, 0, "filter_type", string);
        }
        if (((zzek)((Object)object)).zzo()) {
            zzkv.zzJ(stringBuilder, 1, "event_count_filter", ((zzek)((Object)object)).zzf());
        }
        if (((zzek)((Object)object)).zza() > 0) {
            stringBuilder.append("  filters {\n");
            object = ((zzek)((Object)object)).zzh().iterator();
            while (object.hasNext()) {
                this.zzE(stringBuilder, 2, (zzem)((Object)object.next()));
            }
        }
        zzkv.zzF(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zzp(zzet zzet2) {
        if (zzet2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zzet2.zzj()) {
            zzkv.zzI(stringBuilder, 0, "filter_id", zzet2.zza());
        }
        zzkv.zzI(stringBuilder, 0, "property_name", this.zzt.zzj().zzf(zzet2.zze()));
        String string = zzkv.zzG(zzet2.zzg(), zzet2.zzh(), zzet2.zzi());
        if (!string.isEmpty()) {
            zzkv.zzI(stringBuilder, 0, "filter_type", string);
        }
        this.zzE(stringBuilder, 1, zzet2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List zzq(List object, List object2) {
        ArrayList<Long> arrayList = new ArrayList<Long>((Collection<Long>)object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Integer)object.next();
            if ((Integer)object2 < 0) {
                this.zzt.zzay().zzk().zzb("Ignoring negative bit index to be cleared", object2);
                continue;
            }
            int n = (Integer)object2 / 64;
            if (n >= arrayList.size()) {
                this.zzt.zzay().zzk().zzc("Ignoring bit index greater than bitSet size", object2, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n, (Long)arrayList.get(n) & (1L << (Integer)object2 % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n2 = arrayList.size() + -1;
        while (n2 >= 0 && (Long)arrayList.get(n2) == 0L) {
            int n3 = n2 + -1;
            n = n2;
            n2 = n3;
        }
        return arrayList.subList(0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static List zzr(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        int n2 = 0;
        block0: while (n2 < n) {
            long l = 0L;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 >= 64 || (n4 = n2 * 64 + n3) >= bitSet.length()) {
                    arrayList.add(l);
                    ++n2;
                    continue block0;
                }
                long l2 = bitSet.get(n4) ? (l |= 1L << n3) : l;
                ++n3;
                l = l2;
            }
            break;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Map zzs(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = bundle.get(string);
            boolean bl2 = object instanceof Parcelable[];
            if (bl2 || object instanceof ArrayList || object instanceof Bundle) {
                if (!bl) continue;
                ArrayList<Map> arrayList = new ArrayList<Map>();
                if (bl2) {
                    for (Parcelable parcelable : (Parcelable[])object) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(this.zzs((Bundle)parcelable, false));
                    }
                } else if (object instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(this.zzs((Bundle)e, false));
                    }
                } else if (object instanceof Bundle) {
                    arrayList.add(this.zzs((Bundle)object, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzkv(zzkt zzkt2) {
        super(zzkt2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzD(StringBuilder stringBuilder, int n, List iterator) {
        if (iterator == null) {
            return;
        }
        int n2 = n + 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzfx zzfx2 = (zzfx)((Object)iterator.next());
            if (zzfx2 == null) continue;
            zzkv.zzF(stringBuilder, n2);
            stringBuilder.append("param {\n");
            Object object = zzfx2.zzx() ? this.zzt.zzj().zze(zzfx2.zzg()) : null;
            zzkv.zzI(stringBuilder, n2, "name", object);
            object = zzfx2.zzy() ? zzfx2.zzh() : null;
            zzkv.zzI(stringBuilder, n2, "string_value", object);
            object = zzfx2.zzw() ? Long.valueOf(zzfx2.zzd()) : null;
            zzkv.zzI(stringBuilder, n2, "int_value", object);
            object = zzfx2.zzu() ? Double.valueOf(zzfx2.zza()) : null;
            zzkv.zzI(stringBuilder, n2, "double_value", object);
            if (zzfx2.zzc() > 0) {
                this.zzD(stringBuilder, n2, zzfx2.zzi());
            }
            zzkv.zzF(stringBuilder, n2);
            stringBuilder.append("}\n");
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzE(StringBuilder stringBuilder, int n, zzem zzem2) {
        if (zzem2 == null) {
            return;
        }
        zzkv.zzF(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzem2.zzh()) {
            zzkv.zzI(stringBuilder, n, "complement", zzem2.zzg());
        }
        if (zzem2.zzj()) {
            zzkv.zzI(stringBuilder, n, "param_name", ((zzgk)object).zzt.zzj().zze(zzem2.zze()));
        }
        if (zzem2.zzk()) {
            int n2 = n + 1;
            zzey zzey2 = zzem2.zzd();
            if (zzey2 != null) {
                zzkv.zzF(stringBuilder, n2);
                stringBuilder.append("string_filter {\n");
                if (zzey2.zzi()) {
                    switch (zzey2.zzj()) {
                        default: {
                            Object object = "IN_LIST";
                            break;
                        }
                        case 1: {
                            Object object = "UNKNOWN_MATCH_TYPE";
                            break;
                        }
                        case 6: {
                            Object object = "EXACT";
                            break;
                        }
                        case 5: {
                            Object object = "PARTIAL";
                            break;
                        }
                        case 4: {
                            Object object = "ENDS_WITH";
                            break;
                        }
                        case 3: {
                            Object object = "BEGINS_WITH";
                            break;
                        }
                        case 2: {
                            Object object = "REGEXP";
                        }
                    }
                    zzkv.zzI(stringBuilder, n2, "match_type", object);
                }
                if (zzey2.zzh()) {
                    zzkv.zzI(stringBuilder, n2, "expression", zzey2.zzd());
                }
                if (zzey2.zzg()) {
                    zzkv.zzI(stringBuilder, n2, "case_sensitive", zzey2.zzf());
                }
                if (zzey2.zza() > 0) {
                    zzkv.zzF(stringBuilder, n2 + 1);
                    stringBuilder.append("expression_list {\n");
                    for (Object e : zzey2.zze()) {
                        String string = (String)e;
                        zzkv.zzF(stringBuilder, n2 + 2);
                        stringBuilder.append(string);
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("}\n");
                }
                zzkv.zzF(stringBuilder, n2);
                stringBuilder.append("}\n");
            }
        }
        if (zzem2.zzi()) {
            zzkv.zzJ(stringBuilder, n + 1, "number_filter", zzem2.zzc());
        }
        zzkv.zzF(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    /*
     * Unable to fully structure code
     */
    final void zzt(zzfw var1_2, Object var2_3) {
        block9: {
            Preconditions.checkNotNull((Object)var2_3);
            var1_2.zzg();
            var1_2.zze();
            var1_2.zzd();
            var1_2.zzf();
            if (var2_3 instanceof String) {
                var1_2.zzk((String)var2_3);
                return;
            }
            if (var2_3 instanceof Long) {
                var1_2.zzi((Long)var2_3);
                return;
            }
            if (var2_3 instanceof Double) {
                var1_2.zzh((Double)var2_3);
                return;
            }
            if (!(var2_3 instanceof Bundle[])) break block9;
            var2_3 = var2_3;
            var3_4 = new ArrayList<zzfx>();
            block0: for (Bundle var5_6 : var2_3) {
                if (var5_6 == null) lbl-1000:
                // 3 sources

                {
                    continue block0;
                }
                var6_7 = zzfx.zze();
                block2: for (Object var8_9 : var5_6.keySet()) {
                    block10: {
                        var9_10 = zzfx.zze();
                        var9_10.zzj((String)var8_9);
                        var8_9 = var5_6.get((String)var8_9);
                        if (var8_9 instanceof Long) {
                            var9_10.zzi((Long)var8_9);
lbl39:
                            // 3 sources

                            while (true) {
                                var6_7.zzc(var9_10);
                                continue block2;
                                break;
                            }
                        }
                        if (!(var8_9 instanceof String)) break block10;
                        var9_10.zzk((String)var8_9);
                        ** GOTO lbl39
                    }
                    if (!(var8_9 instanceof Double)) continue;
                    var9_10.zzh((Double)var8_9);
                    ** continue;
                }
                if (var6_7.zza() <= 0) ** GOTO lbl-1000
                var3_4.add((zzfx)var6_7.zzaC());
                ** continue;
            }
            var1_2.zzb(var3_4);
            return;
        }
        this.zzt.zzay().zzd().zzb("Ignoring invalid (type) event param value", (Object)var2_3);
    }

    final void zzu(zzgl zzgl2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzgl2.zzc();
        zzgl2.zzb();
        zzgl2.zza();
        if (object instanceof String) {
            zzgl2.zzh((String)object);
            return;
        }
        if (object instanceof Long) {
            zzgl2.zze((Long)object);
            return;
        }
        if (object instanceof Double) {
            zzgl2.zzd((Double)object);
            return;
        }
        this.zzt.zzay().zzd().zzb("Ignoring invalid (type) user attribute value", object);
    }

    static boolean zzv(List list, int n) {
        return n < list.size() * 64 && ((Long)list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zzw(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzt.zzav().currentTimeMillis() - l) > l2;
    }

    static boolean zzx(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzb() {
        return false;
    }

    final byte[] zzy(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzt.zzay().zzd().zzb("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    static final void zzz(zzfs zzfs2, String string, Object object) {
        int n;
        Object object2;
        block4: {
            object2 = zzfs2.zzp();
            for (n = 0; n < object2.size(); ++n) {
                if (!string.equals(((zzfx)((Object)object2.get(n))).zzg())) {
                    continue;
                }
                break block4;
            }
            n = -1;
        }
        object2 = zzfx.zze();
        ((zzfw)((Object)object2)).zzj(string);
        if (object instanceof Long) {
            ((zzfw)((Object)object2)).zzi((Long)object);
        }
        if (n >= 0) {
            zzfs2.zzj(n, (zzfw)((Object)object2));
            return;
        }
        zzfs2.zze((zzfw)((Object)object2));
    }

    private static final void zzF(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    @WorkerThread
    static final boolean zzA(zzaw zzaw2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzaw2);
        Preconditions.checkNotNull((Object)zzq2);
        return !TextUtils.isEmpty((CharSequence)zzq2.zzb) || !TextUtils.isEmpty((CharSequence)zzq2.zzq);
    }

    static final zzfx zzB(zzft object, String string) {
        for (zzfx zzfx2 : ((zzft)((Object)object)).zzi()) {
            if (!zzfx2.zzg().equals(string)) continue;
            return zzfx2;
        }
        return null;
    }

    private static final String zzG(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void zzH(StringBuilder stringBuilder, int n, String iterator, zzgi object) {
        void var5_27;
        Object object2;
        Iterator iterator2;
        Object object3;
        if (object3 == null) {
            return;
        }
        zzkv.zzF(stringBuilder, 3);
        stringBuilder.append((String)((Object)iterator2));
        stringBuilder.append(" {\n");
        if (((zzgi)((Object)object3)).zzb() != 0) {
            zzkv.zzF(stringBuilder, 4);
            stringBuilder.append("results: ");
            iterator2 = ((zzgi)((Object)object3)).zzk().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_3;
                object2 = (Long)iterator2.next();
                var5_27 = var1_3 + true;
                if (var1_3 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object2);
                var1_3 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (((zzgi)((Object)object3)).zzd() != 0) {
            zzkv.zzF(stringBuilder, 4);
            stringBuilder.append("status: ");
            iterator2 = ((zzgi)((Object)object3)).zzn().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_5;
                object2 = (Long)iterator2.next();
                var5_27 = var1_5 + true;
                if (var1_5 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object2);
                var1_5 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (((zzgi)((Object)object3)).zza() != 0) {
            zzkv.zzF(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            iterator2 = ((zzgi)((Object)object3)).zzj().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_11;
                void var1_9;
                void var1_7;
                object2 = (zzfr)((Object)iterator2.next());
                var5_27 = var1_7 + true;
                if (var1_7 != false) {
                    stringBuilder.append(", ");
                }
                if (((zzfr)((Object)object2)).zzh()) {
                    Integer n2 = ((zzfr)((Object)object2)).zza();
                } else {
                    Object var1_14 = null;
                }
                stringBuilder.append(var1_9);
                stringBuilder.append(":");
                if (((zzfr)((Object)object2)).zzg()) {
                    Long l = ((zzfr)((Object)object2)).zzb();
                } else {
                    Object var1_13 = null;
                }
                stringBuilder.append(var1_11);
                void var1_12 = var5_27;
            }
            stringBuilder.append("}\n");
        }
        if (((zzgi)((Object)object3)).zzc() != 0) {
            zzkv.zzF(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            iterator2 = ((zzgi)((Object)object3)).zzm().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_18;
                void var1_16;
                object3 = (com.google.android.gms.internal.measurement.zzgk)((Object)iterator2.next());
                void var4_26 = var1_16 + true;
                if (var1_16 != false) {
                    stringBuilder.append(", ");
                }
                if (((com.google.android.gms.internal.measurement.zzgk)((Object)object3)).zzi()) {
                    Integer n3 = ((com.google.android.gms.internal.measurement.zzgk)((Object)object3)).zzb();
                } else {
                    Object var1_22 = null;
                }
                stringBuilder.append(var1_18);
                stringBuilder.append(": [");
                object3 = ((com.google.android.gms.internal.measurement.zzgk)((Object)object3)).zzf().iterator();
                boolean bl2 = false;
                while (object3.hasNext()) {
                    void var1_20;
                    long l = (Long)object3.next();
                    var5_27 = var1_20 + true;
                    if (var1_20 != false) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                    var1_20 = var5_27;
                }
                stringBuilder.append("]");
                void var1_21 = var4_26;
            }
            stringBuilder.append("}\n");
        }
        zzkv.zzF(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private static final void zzI(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzkv.zzF(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    static final Object zzC(zzft object, String arrayList) {
        if ((object = zzkv.zzB((zzft)((Object)object), (String)((Object)arrayList))) != null) {
            if (((zzfx)((Object)object)).zzy()) {
                return ((zzfx)((Object)object)).zzh();
            }
            if (((zzfx)((Object)object)).zzw()) {
                return ((zzfx)((Object)object)).zzd();
            }
            if (((zzfx)((Object)object)).zzu()) {
                return ((zzfx)((Object)object)).zza();
            }
            if (((zzfx)((Object)object)).zzc() > 0) {
                object = ((zzfx)((Object)object)).zzi();
                arrayList = new ArrayList<Bundle>();
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = (zzfx)((Object)object.next());
                    if (object2 == null) continue;
                    Bundle bundle = new Bundle();
                    for (zzfx zzfx2 : object2.zzi()) {
                        if (zzfx2.zzy()) {
                            bundle.putString(zzfx2.zzg(), zzfx2.zzh());
                            continue;
                        }
                        if (zzfx2.zzw()) {
                            bundle.putLong(zzfx2.zzg(), zzfx2.zzd());
                            continue;
                        }
                        if (!zzfx2.zzu()) continue;
                        bundle.putDouble(zzfx2.zzg(), zzfx2.zza());
                    }
                    if (bundle.isEmpty()) continue;
                    arrayList.add(bundle);
                }
                return arrayList.toArray(new Bundle[arrayList.size()]);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void zzJ(StringBuilder stringBuilder, int n, String string, zzer zzer2) {
        if (zzer2 == null) {
            return;
        }
        zzkv.zzF(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzer2.zzg()) {
            switch (zzer2.zzm()) {
                default: {
                    string = "BETWEEN";
                    break;
                }
                case 1: {
                    string = "UNKNOWN_COMPARISON_TYPE";
                    break;
                }
                case 4: {
                    string = "EQUAL";
                    break;
                }
                case 3: {
                    string = "GREATER_THAN";
                    break;
                }
                case 2: {
                    string = "LESS_THAN";
                }
            }
            zzkv.zzI(stringBuilder, n, "comparison_type", string);
        }
        if (zzer2.zzi()) {
            zzkv.zzI(stringBuilder, n, "match_as_float", zzer2.zzf());
        }
        if (zzer2.zzh()) {
            zzkv.zzI(stringBuilder, n, "comparison_value", zzer2.zzc());
        }
        if (zzer2.zzk()) {
            zzkv.zzI(stringBuilder, n, "min_comparison_value", zzer2.zze());
        }
        if (zzer2.zzj()) {
            zzkv.zzI(stringBuilder, n, "max_comparison_value", zzer2.zzd());
        }
        zzkv.zzF(stringBuilder, n);
        stringBuilder.append("}\n");
    }
}

