/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgw
extends zzej {
    private final zzlg zza;
    private Boolean zzb;
    private String zzc;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final zzaw zzb(zzaw zzaw2, zzq object) {
        String string;
        zzau zzau2;
        void var1_3;
        if (!"_cmp".equals(var1_3.zza) || (zzau2 = var1_3.zzb) == null || zzau2.zza() == 0 || !"referrer broadcast".equals(string = var1_3.zzb.zzg("_cis")) && !"referrer API".equals(string)) {
            return var1_3;
        }
        String string2 = var1_3.toString();
        this.zza.zzaA().zzi().zzb("Event has been filtered ", (Object)string2);
        zzau zzau3 = var1_3.zzb;
        String string3 = var1_3.zzc;
        long l = var1_3.zzd;
        return new zzaw("_cmpx", zzau3, string3, l);
    }

    static /* bridge */ /* synthetic */ zzlg zzc(zzgw zzgw2) {
        return zzgw2.zza;
    }

    @BinderThread
    public final String zzd(zzq zzq2) {
        this.zzy(zzq2, false);
        return this.zza.zzx(zzq2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zze(zzq zzq2, boolean bl) {
        void var1_2;
        this.zzy((zzq)var1_2, false);
        Iterator iterator = var1_2.zza;
        Preconditions.checkNotNull((Object)iterator);
        iterator = this.zza.zzaB().zzh((Callable)new zzgt(this, (String)((Object)iterator)));
        try {
            iterator = (List)iterator.get();
            ArrayList<zzlj> arrayList = new ArrayList<zzlj>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                void var2_3;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzll zzll2 = (zzll)iterator.next();
                if (var2_3 == false && (bl2 = zzlo.zzaj((String)zzll2.zzc))) continue;
                arrayList.add(new zzlj(zzll2));
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Object object = zzeu.zzn((String)var1_2.zza);
            this.zza.zzaA().zzd().zzc("Failed to get user properties. appId", object, (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List zzf(String object, String string, zzq object2) {
        object3.zzy((zzq)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        object = object3.zza.zzaB().zzh((Callable)new zzgk((zzgw)((Object)object3), (String)object2, (String)object, string));
        try {
            Object object3 = (List)object.get();
            return object3;
        }
        catch (InterruptedException | ExecutionException exception) {
            object3.zza.zzaA().zzd().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List zzg(String object, String string, String string2) {
        object2.zzz((String)object, true);
        object = object2.zza.zzaB().zzh((Callable)new zzgl((zzgw)((Object)object2), (String)object, string, string2));
        try {
            Object object2 = (List)object.get();
            return object2;
        }
        catch (InterruptedException | ExecutionException exception) {
            object2.zza.zzaA().zzd().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzh(String iterator, String arrayList, boolean bl, zzq zzq2) {
        ArrayList<zzlj> arrayList2;
        Iterator iterator2;
        void var4_6;
        this.zzy((zzq)var4_6, false);
        String string = var4_6.zza;
        Preconditions.checkNotNull((Object)string);
        iterator2 = this.zza.zzaB().zzh((Callable)new zzgi(this, string, (String)((Object)iterator2), (String)((Object)arrayList2)));
        try {
            iterator2 = (List)iterator2.get();
            arrayList2 = new ArrayList<zzlj>(iterator2.size());
            iterator2 = iterator2.iterator();
            while (true) {
                boolean bl2;
                void var3_5;
                boolean bl3;
                if (!(bl3 = iterator2.hasNext())) {
                    return arrayList2;
                }
                string = (zzll)iterator2.next();
                if (var3_5 == false && (bl2 = zzlo.zzaj((String)((zzll)string).zzc))) continue;
                arrayList2.add(new zzlj((zzll)string));
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Object object = zzeu.zzn((String)var4_6.zza);
            this.zza.zzaA().zzd().zzc("Failed to query user properties. appId", object, (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzi(String string, String iterator, String arrayList, boolean bl) {
        ArrayList<zzlj> arrayList2;
        Iterator iterator2;
        void var1_2;
        this.zzz((String)var1_2, true);
        iterator2 = this.zza.zzaB().zzh((Callable)new zzgj(this, (String)var1_2, (String)((Object)iterator2), (String)((Object)arrayList2)));
        try {
            iterator2 = (List)iterator2.get();
            arrayList2 = new ArrayList<zzlj>(iterator2.size());
            iterator2 = iterator2.iterator();
            while (true) {
                boolean bl2;
                void var4_6;
                boolean bl3;
                if (!(bl3 = iterator2.hasNext())) {
                    return arrayList2;
                }
                zzll zzll2 = (zzll)iterator2.next();
                if (var4_6 == false && (bl2 = zzlo.zzaj((String)zzll2.zzc))) continue;
                arrayList2.add(new zzlj(zzll2));
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Object object = zzeu.zzn((String)var1_2);
            this.zza.zzaA().zzd().zzc("Failed to get user properties as. appId", object, (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzgw(zzlg zzlg2, String string) {
        Preconditions.checkNotNull((Object)zzlg2);
        this.zza = zzlg2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzj(zzq zzq2) {
        this.zzy(zzq2, false);
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgu(zzgw2, zzq2));
    }

    @BinderThread
    private final void zzy(zzq zzq2, boolean bl) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zzz(zzq2.zza, false);
        this.zza.zzv().zzY(zzq2.zzb, zzq2.zzq);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzz(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzaA().zzd().zza("Measurement Service called without app package");
                                throw new SecurityException("Measurement Service called without app package");
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)this.zza.zzaw(), (int)Binder.getCallingUid());
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)this.zza.zzaw()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                Object object = zzeu.zzn((String)var1_2);
                                this.zza.zzaA().zzd().zzb("Measurement Service called with invalid calling package. appId", object);
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzaw(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                throw new SecurityException(String.format("Unknown calling package name '%s'.", var1_2));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzv(zzaw object, zzq zzq2) {
        Object object22;
        block7: {
            block9: {
                block8: {
                    if (!this.zza.zzo().zzo(zzq2.zza)) {
                        this.zzA((zzaw)object, zzq2);
                        return;
                    }
                    object22 = zzq2.zza;
                    this.zza.zzaA().zzj().zzb("EES config found for", object22);
                    object22 = this.zza.zzo();
                    Object object3 = zzq2.zza;
                    object22 = TextUtils.isEmpty((CharSequence)object3) ? null : (zzc)((zzfv)((Object)object22)).zzd.get(object3);
                    if (object22 == null) {
                        object22 = zzq2.zza;
                        this.zza.zzaA().zzj().zzb("EES not loaded for", object22);
                        this.zzA((zzaw)object, zzq2);
                        return;
                    }
                    try {
                        zzaa zzaa2;
                        boolean bl;
                        object3 = this.zza.zzu();
                        Map map = ((zzli)((Object)object3)).zzs(((zzaw)object).zzb.zzc(), true);
                        object3 = zzhb.zza((String)((zzaw)object).zza);
                        if (object3 == null) {
                            object3 = ((zzaw)object).zza;
                        }
                        if (!(bl = ((zzc)object22).zze(zzaa2 = new zzaa((String)object3, ((zzaw)object).zzd, map)))) break block7;
                        if (!((zzc)object22).zzg()) break block8;
                        object = ((zzaw)object).zza;
                    }
                    catch (zzd zzd2) {
                        object22 = zzq2.zzb;
                        object3 = ((zzaw)object).zza;
                        this.zza.zzaA().zzd().zzc("EES error. appId, eventName", object22, object3);
                    }
                    this.zza.zzaA().zzj().zzb("EES edited event", object);
                    zzgw zzgw2 = this;
                    zzgw2.zzA(zzgw2.zza.zzu().zzi(((zzc)object22).zza().zzb()), zzq2);
                    break block9;
                }
                this.zzA((zzaw)object, zzq2);
            }
            if (((zzc)object22).zzf()) {
                for (Object object22 : ((zzc)object22).zza().zzc()) {
                    String string = ((zzaa)object22).zzd();
                    this.zza.zzaA().zzj().zzb("EES logging created event", (Object)string);
                    zzgw zzgw3 = this;
                    zzgw3.zzA(zzgw3.zza.zzu().zzi((zzaa)object22), zzq2);
                }
            }
            return;
        }
        object22 = ((zzaw)object).zza;
        this.zza.zzaA().zzj().zzb("EES was not applied to event", object22);
        this.zzA((zzaw)object, zzq2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzw(String string, Bundle object) {
        Object object2 = ((zzgw)((Object)object2)).zza.zzi();
        object2.zzg();
        ((zzkt)((Object)object2)).zzW();
        Object object3 = "dep";
        zzar zzar2 = new zzar(((zzam)((Object)object2)).zzt, "", string, (String)object3, 0L, 0L, object);
        byte[] byArray = ((zzks)((Object)object2)).zzf.zzu().zzj(zzar2).zzbx();
        String string2 = ((zzgx)object2).zzt.zzj().zzd(string);
        object3 = byArray.length;
        ((zzgx)object2).zzt.zzaA().zzj().zzc("Saving default event parameters, appId, data size", (Object)string2, object3);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("parameters", byArray);
        try {
            long l = ((zzam)((Object)object2)).zzh().insertWithOnConflict("default_event_params", null, contentValues, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            object2 = zzeu.zzn((String)string);
            ((zzgx)object2).zzt.zzaA().zzd().zzc("Error storing default event parameters. appId", object2, (Object)sQLiteException);
            return;
        }
        zzeu zzeu2 = ((zzgx)object2).zzt.zzaA();
        zzeu2.zzd().zzb("Failed to insert default event parameters (got -1). appId", zzeu.zzn((String)string));
    }

    @BinderThread
    public final void zzk(zzaw zzaw2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzaw2);
        this.zzy(zzq2, false);
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgp(zzgw2, zzaw2, zzq2));
    }

    @BinderThread
    public final void zzl(zzaw zzaw2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzaw2);
        Preconditions.checkNotEmpty((String)string);
        this.zzz(string, true);
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgq(zzgw2, zzaw2, string));
    }

    private final void zzA(zzaw zzaw2, zzq zzq2) {
        this.zza.zzA();
        this.zza.zzE(zzaw2, zzq2);
    }

    @BinderThread
    public final void zzm(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zzz(zzq2.zza, false);
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgm(zzgw2, zzq2));
    }

    @VisibleForTesting
    final void zzx(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzaB().zzs()) {
            runnable.run();
            return;
        }
        this.zza.zzaB().zzp(runnable);
    }

    @BinderThread
    public final void zzn(zzac zzac2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzac2);
        Preconditions.checkNotNull((Object)zzac2.zzc);
        this.zzy(zzq2, false);
        zzac zzac3 = new zzac(zzac2);
        zzac3.zza = zzq2.zza;
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgg(zzgw2, zzac3, zzq2));
    }

    @BinderThread
    public final void zzo(zzac zzac2) {
        Preconditions.checkNotNull((Object)zzac2);
        Preconditions.checkNotNull((Object)zzac2.zzc);
        Preconditions.checkNotEmpty((String)zzac2.zza);
        this.zzz(zzac2.zza, true);
        zzac zzac3 = new zzac(zzac2);
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgh(zzgw2, zzac3));
    }

    @BinderThread
    public final void zzp(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Preconditions.checkNotNull((Object)zzq2.zzv);
        zzgo zzgo2 = new zzgo(this, zzq2);
        Preconditions.checkNotNull((Object)zzgo2);
        if (this.zza.zzaB().zzs()) {
            zzgo2.run();
            return;
        }
        this.zza.zzaB().zzq((Runnable)zzgo2);
    }

    @BinderThread
    public final void zzq(long l, String string, String string2, String string3) {
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgv(zzgw2, string2, string3, string, l));
    }

    @BinderThread
    public final void zzr(Bundle bundle, zzq object) {
        this.zzy((zzq)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgf(zzgw2, (String)object, bundle));
    }

    @BinderThread
    public final void zzs(zzq zzq2) {
        this.zzy(zzq2, false);
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgn(zzgw2, zzq2));
    }

    @BinderThread
    public final void zzt(zzlj zzlj2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzlj2);
        this.zzy(zzq2, false);
        zzgw zzgw2 = this;
        zzgw2.zzx(new zzgs(zzgw2, zzlj2, zzq2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzu(zzaw zzaw2, String object) {
        void var1_2;
        Object object2;
        Preconditions.checkNotEmpty((String)object2);
        Preconditions.checkNotNull((Object)var1_2);
        this.zzz((String)object2, true);
        Object object3 = this.zza.zzj().zzd(var1_2.zza);
        this.zza.zzaA().zzc().zzb("Log and bundle. event", object3);
        long l = this.zza.zzax().nanoTime() / 1000000L;
        object3 = this.zza.zzaB().zzi((Callable)new zzgr(this, (zzaw)var1_2, (String)object2));
        try {
            object3 = (byte[])object3.get();
            if (object3 == null) {
                this.zza.zzaA().zzd().zzb("Log and bundle returned null. appId", zzeu.zzn((String)object2));
                object3 = new byte[0];
            }
            long l2 = this.zza.zzax().nanoTime() / 1000000L;
            this.zza.zzaA().zzc().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zzd(var1_2.zza), (Object)((Object)object3).length, (Object)(l2 - l));
            return object3;
        }
        catch (InterruptedException | ExecutionException exception) {
            object2 = zzeu.zzn((String)object2);
            String string = this.zza.zzj().zzd(var1_2.zza);
            this.zza.zzaA().zzd().zzd("Failed to log and bundle. appId, event, error", object2, (Object)string, (Object)exception);
            return null;
        }
    }
}

