/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzlp;

public final class zzks
extends zzku {
    private final AlarmManager zza;
    private zzan zzb;
    private Integer zzc;

    private final int zzf() {
        if (this.zzc == null) {
            String string = String.valueOf(this.zzt.zzaw().getPackageName());
            this.zzc = "measurement".concat(string).hashCode();
        }
        return this.zzc;
    }

    private final PendingIntent zzh() {
        Context context = this.zzt.zzaw();
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD"), (int)zzbs.zza);
    }

    private final zzan zzi() {
        if (this.zzb == null) {
            zzks zzks2 = this;
            zzks2.zzb = new zzkr(zzks2, (zzgy)zzks2.zzf.zzp());
        }
        return this.zzb;
    }

    protected zzks(zzlh zzlh2) {
        super(zzlh2);
        this.zza = (AlarmManager)this.zzt.zzaw().getSystemService("alarm");
    }

    public final void zza() {
        this.zzW();
        this.zzt.zzaA().zzj().zza("Unscheduling upload");
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzh());
        }
        this.zzi().zzb();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzj();
            return;
        }
    }

    @TargetApi(value=24)
    private final void zzj() {
        JobScheduler jobScheduler = (JobScheduler)this.zzt.zzaw().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzf());
            return;
        }
    }

    public final void zzd(long l) {
        this.zzW();
        this.zzt.zzay();
        Object object = this.zzt.zzaw();
        if (!zzlp.zzal((Context)object)) {
            this.zzt.zzaA().zzc().zza("Receiver not registered/enabled");
        }
        if (!zzlp.zzam((Context)object, (boolean)false)) {
            this.zzt.zzaA().zzc().zza("Service not registered/enabled");
        }
        this.zza();
        object = l;
        this.zzt.zzaA().zzj().zzb("Scheduling upload, millis", object);
        long l2 = this.zzt.zzax().elapsedRealtime() + l;
        this.zzt.zzf();
        if (l < Math.max(0L, (Long)zzeg.zzx.zza(null)) && !this.zzi().zze()) {
            this.zzi().zzd(l);
        }
        this.zzt.zzay();
        if (Build.VERSION.SDK_INT >= 24) {
            object = this.zzt.zzaw();
            String string = "com.google.android.gms.measurement.AppMeasurementJobService";
            ComponentName componentName = new ComponentName(object, string);
            int n = this.zzf();
            string = new PersistableBundle();
            string.putString("action", "com.google.android.gms.measurement.UPLOAD");
            long l3 = l;
            zzbt.zza(object, new JobInfo.Builder(n, componentName).setMinimumLatency(l).setOverrideDeadline(l3 + l3).setExtras((PersistableBundle)string).build(), "com.google.android.gms", "UploadAlarm");
            return;
        }
        object = this.zza;
        if (object != null) {
            this.zzt.zzf();
            object.setInexactRepeating(2, l2, Math.max((Long)zzeg.zzs.zza(null), l), this.zzh());
            return;
        }
    }

    @Override
    protected final boolean zzb() {
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzh());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzj();
        }
        return false;
    }
}

