/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzna;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class zzac {
    String zza;
    int zzb;
    Boolean zzc;
    Boolean zzd;
    Long zze;
    Long zzf;

    abstract int zza();

    @VisibleForTesting
    private static @Nullable Boolean zza(BigDecimal bigDecimal, zzev.zzd zzd2, double d) {
        block25: {
            BigDecimal bigDecimal2;
            zzev.zzd.zza zza2;
            BigDecimal bigDecimal3;
            BigDecimal bigDecimal4;
            BigDecimal bigDecimal5;
            double d2;
            block24: {
                block23: {
                    Preconditions.checkNotNull((Object)((Object)zzd2));
                    if (!zzd2.zzh() || zzd2.zza() == zzev.zzd.zza.zza) {
                        return null;
                    }
                    if (zzd2.zza() == zzev.zzd.zza.zze ? !zzd2.zzl() || !zzd2.zzk() : !zzd2.zzi()) {
                        return null;
                    }
                    zzev.zzd.zza zza3 = zzd2.zza();
                    BigDecimal bigDecimal6 = null;
                    BigDecimal bigDecimal7 = null;
                    BigDecimal bigDecimal8 = null;
                    if (zzd2.zza() == zzev.zzd.zza.zze) {
                        if (!zzna.zzb(zzd2.zzf()) || !zzna.zzb(zzd2.zze())) {
                            return null;
                        }
                        try {
                            bigDecimal7 = new BigDecimal(zzd2.zzf());
                            bigDecimal8 = new BigDecimal(zzd2.zze());
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    }
                    if (!zzna.zzb(zzd2.zzd())) {
                        return null;
                    }
                    try {
                        bigDecimal6 = new BigDecimal(zzd2.zzd());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    d2 = d;
                    bigDecimal5 = bigDecimal8;
                    bigDecimal4 = bigDecimal7;
                    bigDecimal3 = bigDecimal6;
                    zza2 = zza3;
                    bigDecimal2 = bigDecimal;
                    if (zza2 != zzev.zzd.zza.zze) break block23;
                    if (bigDecimal4 == null) {
                        return null;
                    }
                    break block24;
                }
                if (bigDecimal3 == null) break block25;
            }
            switch (zza2) {
                case zzb: {
                    if (bigDecimal3 == null) break;
                    return bigDecimal2.compareTo(bigDecimal3) < 0;
                }
                case zzc: {
                    if (bigDecimal3 == null) break;
                    return bigDecimal2.compareTo(bigDecimal3) > 0;
                }
                case zzd: {
                    if (bigDecimal3 == null) break;
                    if (d2 != 0.0) {
                        return bigDecimal2.compareTo(bigDecimal3.subtract(new BigDecimal(d2).multiply(new BigDecimal(2)))) > 0 && bigDecimal2.compareTo(bigDecimal3.add(new BigDecimal(d2).multiply(new BigDecimal(2)))) < 0;
                    }
                    return bigDecimal2.compareTo(bigDecimal3) == 0;
                }
                case zze: {
                    if (bigDecimal4 == null) {
                        return null;
                    }
                    return bigDecimal2.compareTo(bigDecimal4) >= 0 && bigDecimal2.compareTo(bigDecimal5) <= 0;
                }
            }
        }
        return null;
    }

    @VisibleForTesting
    static @Nullable Boolean zza(String string, zzev.zzf zzf2, @Nullable zzfs zzfs2) {
        List<String> list;
        Preconditions.checkNotNull((Object)((Object)zzf2));
        if (string == null) {
            return null;
        }
        if (!zzf2.zzj() || zzf2.zzb() == zzev.zzf.zzb.zza) {
            return null;
        }
        if (zzf2.zzb() == zzev.zzf.zzb.zzg ? zzf2.zza() == 0 : !zzf2.zzi()) {
            return null;
        }
        zzev.zzf.zzb zzb2 = zzf2.zzb();
        boolean bl = zzf2.zzg();
        String string2 = bl || zzb2 == zzev.zzf.zzb.zzb || zzb2 == zzev.zzf.zzb.zzg ? zzf2.zze() : zzf2.zze().toUpperCase(Locale.ENGLISH);
        if (zzf2.zza() == 0) {
            list = null;
        } else {
            boolean bl2 = bl;
            List<String> list2 = zzf2.zzf();
            if (bl2) {
                list = list2;
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(list2.size());
                for (String string3 : list2) {
                    arrayList.add(string3.toUpperCase(Locale.ENGLISH));
                }
                list = Collections.unmodifiableList(arrayList);
            }
        }
        List<String> list3 = list;
        String string4 = null;
        if (zzb2 == zzev.zzf.zzb.zzb) {
            string4 = string2;
        }
        return zzac.zza(string, zzb2, bl, string2, list3, string4, zzfs2);
    }

    private static @Nullable Boolean zza(String string, zzev.zzf.zzb zzb2, boolean bl, String string2, @Nullable List<String> list, @Nullable String string3, @Nullable zzfs zzfs2) {
        if (string == null) {
            return null;
        }
        if (zzb2 == zzev.zzf.zzb.zzg ? list == null || list.isEmpty() : string2 == null) {
            return null;
        }
        string = bl || zzb2 == zzev.zzf.zzb.zzb ? string : string.toUpperCase(Locale.ENGLISH);
        switch (zzb2) {
            case zzb: {
                if (string3 == null) {
                    return null;
                }
                int n = bl ? 0 : 66;
                try {
                    return Pattern.compile(string3, n).matcher(string).matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (zzfs2 != null) {
                        zzfs2.zzu().zza("Invalid regular expression in REGEXP audience filter. expression", (Object)string3);
                    }
                    return null;
                }
            }
            case zzc: {
                return string.startsWith(string2);
            }
            case zzd: {
                return string.endsWith(string2);
            }
            case zze: {
                return string.contains(string2);
            }
            case zzf: {
                return string.equals(string2);
            }
            case zzg: {
                if (list == null) {
                    return null;
                }
                return list.contains(string);
            }
        }
        return null;
    }

    static @Nullable Boolean zza(double d, zzev.zzd zzd2) {
        try {
            return zzac.zza(new BigDecimal(d), zzd2, Math.ulp(d));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static @Nullable Boolean zza(long l, zzev.zzd zzd2) {
        try {
            return zzac.zza(new BigDecimal(l), zzd2, 0.0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static @Nullable Boolean zza(String string, zzev.zzd zzd2) {
        if (!zzna.zzb(string)) {
            return null;
        }
        try {
            return zzac.zza(new BigDecimal(string), zzd2, 0.0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @VisibleForTesting
    static @Nullable Boolean zza(@Nullable Boolean bl, boolean bl2) {
        if (bl == null) {
            return null;
        }
        return bl != bl2;
    }

    zzac(String string, int n) {
        this.zza = string;
        this.zzb = n;
    }

    abstract boolean zzb();

    abstract boolean zzc();
}

