/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzce;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzmj;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zzmq;
import com.google.android.gms.measurement.internal.zzne;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzmk
extends zzml {
    private final @Nullable AlarmManager zza = (AlarmManager)this.zza().getSystemService("alarm");
    private @Nullable zzaw zzb;
    private Integer zzc;

    private final int zzv() {
        if (this.zzc == null) {
            String string = this.zza().getPackageName();
            this.zzc = ("measurement" + string).hashCode();
        }
        return this.zzc;
    }

    private final PendingIntent zzw() {
        Context context = this.zza();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return zzcc.zza(context, 0, intent, zzcc.zza);
    }

    private final zzaw zzx() {
        if (this.zzb == null) {
            this.zzb = new zzmj(this, (zzic)this.zzf.zzk());
        }
        return this.zzb;
    }

    protected zzmk(zzmq zzmq2) {
        super(zzmq2);
    }

    public final void zzu() {
        this.zzak();
        this.zzj().zzp().zza("Unscheduling upload");
        if (this.zza != null) {
            this.zza.cancel(this.zzw());
        }
        this.zzx().zza();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzy();
        }
    }

    @TargetApi(value=24)
    private final void zzy() {
        JobScheduler jobScheduler = (JobScheduler)this.zza().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzv());
        }
    }

    public final void zza(long l) {
        this.zzak();
        Context context = this.zza();
        if (!zzne.zza((Context)context)) {
            this.zzj().zzc().zza("Receiver not registered/enabled");
        }
        if (!zzne.zza((Context)context, (boolean)false)) {
            this.zzj().zzc().zza("Service not registered/enabled");
        }
        this.zzu();
        this.zzj().zzp().zza("Scheduling upload, millis", (Object)l);
        long l2 = this.zzb().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzbi.zzx.zza(null)) && !this.zzx().zzc()) {
            this.zzx().zza(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            long l3 = l;
            zzmk zzmk2 = this;
            Context context2 = zzmk2.zza();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzmk2.zzv();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzce.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        if (this.zza != null) {
            this.zza.setInexactRepeating(2, l2, Math.max((Long)zzbi.zzs.zza(null), l), this.zzw());
        }
    }

    @Override
    protected final boolean zzc() {
        if (this.zza != null) {
            this.zza.cancel(this.zzw());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzy();
        }
        return false;
    }
}

