/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzlw;
import com.google.android.gms.internal.measurement.zzqk;
import com.google.android.gms.internal.measurement.zzql;
import com.google.android.gms.internal.measurement.zzqq;
import com.google.android.gms.internal.measurement.zzri;
import com.google.android.gms.internal.measurement.zzrj;
import com.google.android.gms.internal.measurement.zzrp;
import com.google.android.gms.internal.measurement.zzsg;
import com.google.android.gms.internal.measurement.zzss;
import com.google.android.gms.internal.measurement.zzsz;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zzmk;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zzmn;
import com.google.android.gms.measurement.internal.zzmo;
import com.google.android.gms.measurement.internal.zzmp;
import com.google.android.gms.measurement.internal.zzmr;
import com.google.android.gms.measurement.internal.zzms;
import com.google.android.gms.measurement.internal.zzmt;
import com.google.android.gms.measurement.internal.zzmu;
import com.google.android.gms.measurement.internal.zzmw;
import com.google.android.gms.measurement.internal.zzmx;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zzne;
import com.google.android.gms.measurement.internal.zznf;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzmq
implements zzic {
    private static volatile @Nullable zzmq zza;
    private zzgp zzb;
    private zzfv zzc;
    private zzao zzd;
    private zzgc zze;
    private zzmk zzf;
    private zzt zzg;
    private final zzna zzh;
    private zzkd zzi;
    private zzlp zzj;
    private final zzmo zzk;
    private @MonotonicNonNull zzgj zzl;
    private final zzhc zzm;
    private boolean zzn = false;
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Set<String> zzr = new HashSet<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zzie> zzac;
    private final Map<String, zzay> zzad;
    private final Map<String, zzb> zzae;
    private @Nullable zzkf zzaf;
    private @Nullable String zzag;
    private final zznf zzah = new zzmt(this);

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzu().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzx() {
        long l = this.zzb().currentTimeMillis();
        zzlp zzlp2 = this.zzj;
        zzlp2.zzak();
        zzlp2.zzt();
        long l2 = zzlp2.zze.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzlp2.zzq().zzv().nextInt(86400000);
            zzlp2.zze.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final @Nullable Bundle zza(String var1_1) {
        block5: {
            this.zzl().zzt();
            this.zzs();
            if (!zzql.zzb()) break block5;
            if (this.zzi().zzb(var1_1) == null) {
                return null;
            }
            var2_2 = new Bundle();
            var3_3 = this.zzb(var1_1);
            var2_2.putAll(var3_3.zzb());
            var4_4 = this.zza(var1_1, this.zzd(var1_1), var3_3, new zzak());
            var2_2.putAll(var4_4.zzb());
            if (this.zzp().zzc(var1_1)) ** GOTO lbl-1000
            var6_5 = this.zzf().zze(var1_1, "_npa");
            if (var6_5 != null) {
                var5_6 = var6_5.zze.equals(1L) != false;
            } else {
                if (this.zzb.zzb(var1_1, zzie.zza.zzd)) {
                    v0 = false;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = true;
                }
                var5_6 = v0;
            }
            var2_2.putString("ad_personalization", var5_6 == true ? "denied" : "granted");
            return var2_2;
        }
        return null;
    }

    public final Clock zzb(@UnknownInitialization zzmq this) {
        return ((zzhc)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzh zza(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zzo2.zzu.isEmpty()) {
            this.zzae.put(zzo2.zza, new zzb(this, zzo2.zzu, null));
        }
        zzh zzh2 = this.zzf().zzd(zzo2.zza);
        zzie zzie2 = this.zzb(zzo2.zza).zza(zzie.zza((String)zzo2.zzt));
        String string = zzie2.zzg() ? this.zzj.zza(zzo2.zza, zzo2.zzn) : "";
        if (zzh2 == null) {
            zzh2 = new zzh(this.zzm, zzo2.zza);
            if (zzie2.zzh()) {
                zzh2.zzb(this.zza(zzie2));
            }
            if (zzie2.zzg()) {
                zzh2.zzh(string);
            }
        } else if (zzie2.zzg() && string != null && !string.equals(zzh2.zzae())) {
            zzh2.zzh(string);
            if (zzo2.zzn && !"00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzo2.zza, (zzie)zzie2).first)) {
                zzh2.zzb(this.zza(zzie2));
                if (this.zzf().zze(zzo2.zza, "_id") != null && this.zzf().zze(zzo2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zznb zznb2 = new zznb(zzo2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zznb2);
                }
            }
        } else if (TextUtils.isEmpty((CharSequence)zzh2.zzy()) && zzie2.zzh()) {
            zzh2.zzb(this.zza(zzie2));
        }
        zzh2.zzf(zzo2.zzb);
        zzh2.zza(zzo2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzk)) {
            zzh2.zze(zzo2.zzk);
        }
        if (zzo2.zze != 0L) {
            zzh2.zzm(zzo2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzc)) {
            zzh2.zzd(zzo2.zzc);
        }
        zzh2.zza(zzo2.zzj);
        if (zzo2.zzd != null) {
            zzh2.zzc(zzo2.zzd);
        }
        zzh2.zzj(zzo2.zzf);
        zzh2.zzb(zzo2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzg)) {
            zzh2.zzg(zzo2.zzg);
        }
        zzh2.zza(zzo2.zzn);
        zzh2.zza(zzo2.zzq);
        zzh2.zzk(zzo2.zzr);
        if (zzss.zzb() && (this.zze().zza(zzbi.zzbr) || this.zze().zze(zzo2.zza, zzbi.zzbt))) {
            zzh2.zzi(zzo2.zzv);
        }
        if (zzqq.zzb() && this.zze().zza(zzbi.zzbq)) {
            zzh2.zza(zzo2.zzs);
        } else if (zzqq.zzb() && this.zze().zza(zzbi.zzbp)) {
            zzh2.zza((List<String>)null);
        }
        if (zzsz.zzb() && this.zze().zza(zzbi.zzbu)) {
            zzh2.zzc(zzo2.zzw);
        }
        if (zzsg.zzb() && this.zze().zza(zzbi.zzcf)) {
            zzh2.zza(zzo2.zzaa);
        }
        zzh2.zzr(zzo2.zzx);
        if (zzh2.zzal()) {
            this.zzf().zza(zzh2);
        }
        return zzh2;
    }

    @WorkerThread
    private final @Nullable zzo zzc(String string) {
        zzh zzh2 = this.zzf().zzd(string);
        if (zzh2 == null || TextUtils.isEmpty((CharSequence)zzh2.zzaa())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzh2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzfs.zza((String)string));
            return null;
        }
        zzie zzie2 = this.zzb(string);
        String string2 = "";
        int n = 100;
        if (zzql.zzb() && this.zze().zza(zzbi.zzcm)) {
            string2 = this.zzd(string).zzf();
            n = zzie2.zza();
        }
        return new zzo(string, zzh2.zzac(), zzh2.zzaa(), zzh2.zzc(), zzh2.zzz(), zzh2.zzo(), zzh2.zzl(), null, zzh2.zzak(), false, zzh2.zzab(), zzh2.zzb(), 0L, 0, zzh2.zzaj(), false, zzh2.zzv(), zzh2.zzu(), zzh2.zzm(), zzh2.zzag(), null, zzie2.zze(), "", null, zzh2.zzam(), zzh2.zzt(), n, string2, zzh2.zza(), zzh2.zzd());
    }

    public final zzt zzc() {
        return (zzt)zzmq.zza(this.zzg);
    }

    public final zzae zzd() {
        return this.zzm.zzd();
    }

    public final zzaf zze(@UnknownInitialization zzmq this) {
        return ((zzhc)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzao zzf(@UnknownInitialization zzmq this) {
        return (zzao)zzmq.zza(this.zzd);
    }

    @VisibleForTesting
    @WorkerThread
    private final zzay zza(String string, zzay zzay2, zzie zzie2, zzak zzak2) {
        if (zzql.zzb()) {
            int n;
            if (this.zzi().zzb(string) == null) {
                int n2;
                if (zzay2.zzc() == Boolean.FALSE) {
                    n2 = zzay2.zza();
                    zzak2.zza(zzie.zza.zzc, n2);
                } else {
                    n2 = 90;
                    zzak2.zza(zzie.zza.zzc, zzaj.zzh);
                }
                return new zzay(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
            }
            Boolean bl = zzay2.zzc();
            if (bl != null) {
                n = zzay2.zza();
                zzak2.zza(zzie.zza.zzc, n);
            } else {
                n = 90;
                if (this.zzb.zza(string, zzie.zza.zzc) == zzie.zza.zza && zzie2.zzc() != null) {
                    bl = zzie2.zzc();
                    zzak2.zza(zzie.zza.zzc, zzaj.zzc);
                }
                if (bl == null) {
                    bl = this.zzb.zzb(string, zzie.zza.zzc);
                    zzak2.zza(zzie.zza.zzc, zzaj.zzb);
                }
            }
            Preconditions.checkNotNull((Object)bl);
            boolean bl2 = this.zzb.zzn(string);
            SortedSet<String> sortedSet = this.zzi().zzh(string);
            if (!bl.booleanValue() || sortedSet.isEmpty()) {
                return new zzay(Boolean.valueOf(false), n, Boolean.valueOf(bl2), "-");
            }
            return new zzay(Boolean.valueOf(true), n, Boolean.valueOf(bl2), bl2 ? TextUtils.join((CharSequence)"", sortedSet) : "");
        }
        return zzay.zza;
    }

    @WorkerThread
    private final zzay zzd(String string) {
        this.zzl().zzt();
        this.zzs();
        if (zzql.zzb()) {
            zzay zzay2 = this.zzad.get(string);
            if (zzay2 == null) {
                zzay2 = this.zzf().zzf(string);
                this.zzad.put(string, zzay2);
            }
            return zzay2;
        }
        return zzay.zza;
    }

    public final zzfn zzg() {
        return this.zzm.zzk();
    }

    public final zzfs zzj(@UnknownInitialization zzmq this) {
        return ((zzhc)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzfv zzh() {
        return (zzfv)zzmq.zza(this.zzc);
    }

    private final zzgc zzy() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzgp zzi() {
        return (zzgp)zzmq.zza(this.zzb);
    }

    public final zzgz zzl(@UnknownInitialization zzmq this) {
        return ((zzhc)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzhc zza(zzmq zzmq2) {
        return zzmq2.zzm;
    }

    final zzhc zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zzie zzb(String string) {
        this.zzl().zzt();
        this.zzs();
        zzie zzie2 = this.zzac.get(string);
        if (zzie2 == null) {
            zzie2 = this.zzf().zzg(string);
            if (zzie2 == null) {
                zzie2 = zzie.zza;
            }
            this.zza(string, zzie2);
        }
        return zzie2;
    }

    public final zzkd zzm() {
        return (zzkd)zzmq.zza(this.zzi);
    }

    public final zzlp zzn() {
        return this.zzj;
    }

    private final zzmk zzz() {
        return (zzmk)zzmq.zza(this.zzf);
    }

    private static zzml zza(@Nullable zzml zzml2) {
        if (zzml2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzml2.zzam()) {
            String string = String.valueOf(((Object)((Object)zzml2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zzml2;
    }

    public final zzmo zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzmq zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzmq> clazz = zzmq.class;
        synchronized (zzmq.class) {
            if (zza != null) return zza;
            zzmx zzmx2 = (zzmx)Preconditions.checkNotNull((Object)new zzmx(context));
            zza = new zzmq(zzmx2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zzna zzp() {
        return (zzna)zzmq.zza(this.zzh);
    }

    public final zzne zzq(@UnknownInitialization zzmq this) {
        return ((zzhc)Preconditions.checkNotNull((Object)this.zzm)).zzt();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzh zzh2) {
        try {
            if (zzh2.zzc() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzh2.zzx(), (int)0).versionCode;
                if (zzh2.zzc() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzh2.zzx(), (int)0).versionName;
                String string2 = zzh2.zzaa();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @WorkerThread
    private final @Nullable String zza(zzie zzie2) {
        if (zzie2.zzh()) {
            zzmq zzmq2 = this;
            byte[] byArray = new byte[16];
            zzmq2.zzq().zzv().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzo zzo2) {
        Future future = this.zzl().zza((Callable)new zzmu(this, zzo2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzfs.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    static /* synthetic */ void zza(zzmq zzmq2, zzmx zzmx2) {
        zzmq zzmq3 = zzmq2;
        zzmq3.zzl().zzt();
        zzmq zzmq4 = zzmq3;
        zzmq3.zzl = new zzgj(zzmq4);
        zzmq4 = zzmq3;
        zzao zzao2 = new zzao(zzmq4);
        zzao2.zzal();
        zzmq3.zzd = zzao2;
        zzmq3.zze().zza((zzah)Preconditions.checkNotNull((Object)((Object)zzmq3.zzb)));
        zzmq4 = zzmq3;
        zzlp zzlp2 = new zzlp(zzmq4);
        zzlp2.zzal();
        zzmq3.zzj = zzlp2;
        zzmq4 = zzmq3;
        zzt zzt2 = new zzt(zzmq4);
        zzt2.zzal();
        zzmq3.zzg = zzt2;
        zzmq4 = zzmq3;
        zzkd zzkd2 = new zzkd(zzmq4);
        zzkd2.zzal();
        zzmq3.zzi = zzkd2;
        zzmq4 = zzmq3;
        zzmk zzmk2 = new zzmk(zzmq4);
        zzmk2.zzal();
        zzmq3.zzf = zzmk2;
        zzmq4 = zzmq3;
        zzmq3.zze = new zzgc(zzmq4);
        if (zzmq3.zzs != zzmq3.zzt) {
            zzmq3.zzj().zzg().zza("Not all upload components initialized", (Object)zzmq3.zzs, (Object)zzmq3.zzt);
        }
        zzmq3.zzn = true;
    }

    private zzmq(zzmx zzmx2) {
        this(zzmx2, null);
    }

    private zzmq(zzmx zzmx2, @Nullable zzhc zzhc2) {
        Preconditions.checkNotNull((Object)zzmx2);
        this.zzm = zzhc2 = zzhc.zza((Context)zzmx2.zza, null, null);
        this.zzab = -1L;
        zzmq zzmq2 = this;
        this.zzk = new zzmo(zzmq2);
        zzmq2 = this;
        zzna zzna2 = new zzna(zzmq2);
        zzna2.zzal();
        this.zzh = zzna2;
        zzmq2 = this;
        zzfv zzfv2 = new zzfv(zzmq2);
        zzfv2.zzal();
        this.zzc = zzfv2;
        zzmq2 = this;
        zzgp zzgp2 = new zzgp(zzmq2);
        zzgp2.zzal();
        this.zzb = zzgp2;
        this.zzac = new HashMap<String, zzie>();
        this.zzad = new HashMap<String, zzay>();
        this.zzae = new HashMap<String, zzb>();
        this.zzl().zzb((Runnable)new zzmp(this, zzmx2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzt();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzr() {
        int n;
        this.zzl().zzt();
        this.zzs();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzad()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzab();
        int n4 = n2;
        zzmq zzmq2 = this;
        zzmq2.zzl().zzt();
        if (n4 > n3) {
            zzmq2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzmq2.zza(n3, zzmq2.zzy)) {
            zzmq2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzmq2.zzj().zzp().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzs() {
        if (!this.zzn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    @WorkerThread
    private final void zzaa() {
        this.zzl().zzt();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzp().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzp().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzfh.zzj.zza zza2) {
        int n;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzq(string)) {
            zza2.zzg();
        }
        if (this.zzi().zzt(string)) {
            if (this.zze().zze(string, zzbi.zzbv)) {
                int n2;
                String string2 = zza2.zzu();
                if (!TextUtils.isEmpty((CharSequence)string2) && (n2 = string2.indexOf(".")) != -1) {
                    string2 = string2.substring(0, n2);
                    zza2.zzo(string2);
                }
            } else {
                zza2.zzl();
            }
        }
        if (this.zzi().zzu(string) && (n = zzna.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzs(string)) {
            zza2.zzh();
        }
        if (this.zzi().zzp(string)) {
            zza2.zze();
            zzb zzb2 = this.zzae.get(string);
            if (zzb2 == null || zzb2.zzb + this.zze().zzc(string, zzbi.zzat) < this.zzb().elapsedRealtime()) {
                zzb2 = new zzb(this, null);
                this.zzae.put(string, zzb2);
            }
            zza2.zzk(zzb2.zza);
        }
        if (this.zzi().zzr(string)) {
            zza2.zzp();
        }
    }

    @WorkerThread
    private final void zzb(zzh zzh2) {
        this.zzl().zzt();
        if (TextUtils.isEmpty((CharSequence)zzh2.zzac()) && TextUtils.isEmpty((CharSequence)zzh2.zzv())) {
            this.zza((String)Preconditions.checkNotNull((Object)zzh2.zzx()), 204, null, null, null);
            return;
        }
        Object object = zzh2;
        Object object2 = new Uri.Builder();
        String string = ((zzh)object).zzac();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = ((zzh)object).zzv();
        }
        Object object3 = string;
        object2.scheme((String)zzbi.zze.zza(null)).encodedAuthority((String)zzbi.zzf.zza(null)).path("config/app/" + (String)object3).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "81010").appendQueryParameter("runtime_version", "0");
        String string2 = object2.build().toString();
        try {
            String string3 = (String)Preconditions.checkNotNull((Object)zzh2.zzx());
            URL uRL = new URL(string2);
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string3);
            zzfa.zzd zzd2 = this.zzi().zzc(string3);
            ArrayMap arrayMap = null;
            String string4 = this.zzi().zze(string3);
            if (zzd2 != null) {
                String string5;
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string4);
                }
                if (!TextUtils.isEmpty((CharSequence)(string5 = this.zzi().zzd(string3)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string5);
                }
            }
            this.zzu = true;
            object3 = new zzmr(this);
            string = arrayMap;
            object2 = uRL;
            object = string3;
            zzfv zzfv2 = this.zzh();
            zzfv2.zzt();
            zzfv2.zzak();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)object3);
            zzfv2.zzl().zza((Runnable)new zzfz(zzfv2, (String)object, (URL)object2, null, (Map)((Object)string), (zzfy)object3));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzfs.zza((String)zzh2.zzx()), (Object)string2);
            return;
        }
    }

    @WorkerThread
    final void zza(zzh zzh2, zzfh.zzj.zza zza2) {
        this.zzl().zzt();
        this.zzs();
        if (zzql.zzb()) {
            Object object;
            zzak zzak2;
            zzak zzak3 = zzak2 = zzak.zza(zza2.zzs());
            zzfh.zzj.zza zza3 = zza2;
            Object object2 = zzh2.zzx();
            zzmq zzmq2 = this;
            zzmq2.zzl().zzt();
            zzmq2.zzs();
            if (zzql.zzb()) {
                object = zzmq2.zzb((String)object2);
                if (zzql.zzb() && zzmq2.zze().zza(zzbi.zzco)) {
                    zza3.zzg(object.zzf());
                }
                if (object.zzc() != null) {
                    zzak3.zza(zzie.zza.zza, object.zza());
                } else {
                    zzak3.zza(zzie.zza.zza, zzaj.zzh);
                }
                if (object.zzd() != null) {
                    zzak3.zza(zzie.zza.zzb, object.zza());
                } else {
                    zzak3.zza(zzie.zza.zzb, zzaj.zzh);
                }
            }
            zzak3 = zzak2;
            zza3 = zza2;
            object2 = zzh2.zzx();
            zzmq2 = this;
            zzmq2.zzl().zzt();
            zzmq2.zzs();
            if (zzql.zzb()) {
                object = zzmq2.zza((String)object2, zzmq2.zzd((String)object2), zzmq2.zzb((String)object2), zzak3);
                zza3.zzb((Boolean)Preconditions.checkNotNull((Object)object.zzd()));
                if (!TextUtils.isEmpty((CharSequence)object.zze())) {
                    zza3.zzh(object.zze());
                }
            }
            zzak3 = zzak2;
            zza3 = zza2;
            object2 = zzh2;
            zzmq2 = this;
            zzmq2.zzl().zzt();
            zzmq2.zzs();
            if (zzql.zzb()) {
                object = null;
                for (zzfh.zzn zzn2 : zza3.zzx()) {
                    if (!"_npa".equals(zzn2.zzg())) continue;
                    object = zzn2;
                    break;
                }
                if (object != null) {
                    if (zzak3.zza(zzie.zza.zzd) == zzaj.zza) {
                        Boolean bl = ((zzh)object2).zzu();
                        if (bl == null || bl == Boolean.TRUE && ((zzfh.zzn)((Object)object)).zzc() != 1L || bl == Boolean.FALSE && ((zzfh.zzn)((Object)object)).zzc() != 0L) {
                            zzak3.zza(zzie.zza.zzd, zzaj.zzf);
                        } else {
                            zzak3.zza(zzie.zza.zzd, zzaj.zzd);
                        }
                    }
                } else if (zzql.zzb() && zzmq2.zze().zza(zzbi.zzcp)) {
                    int n;
                    if (zzmq2.zzb.zzb(((zzh)object2).zzx()) == null) {
                        n = 1;
                        zzak3.zza(zzie.zza.zzd, zzaj.zzh);
                    } else {
                        n = zzmq2.zzb.zzb(((zzh)object2).zzx(), zzie.zza.zzd) ? 0 : 1;
                        zzak3.zza(zzie.zza.zzd, zzaj.zzb);
                    }
                    zza3.zza((zzfh.zzn)((zzlw)zzfh.zzn.zze().zza("_npa").zzb(zzmq2.zzb().currentTimeMillis()).zza(n).zzab()));
                }
            }
            zza2.zzf(zzak2.toString());
        }
    }

    @VisibleForTesting
    private static void zza(zzfh.zze.zza zza2, int n, String string) {
        List<zzfh.zzg> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzg())) continue;
            return;
        }
        zzfh.zzg zzg2 = (zzfh.zzg)((zzlw)zzfh.zzg.zze().zza("_err").zza(n).zzab());
        zzfh.zzg zzg3 = (zzfh.zzg)((zzlw)zzfh.zzg.zze().zza("_ev").zzb(string).zzab());
        zza2.zza(zzg2).zza(zzg3);
    }

    @WorkerThread
    final void zza(zzbg zzbg2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zzl().zzt();
        this.zzs();
        String string = zzo2.zza;
        long l = zzbg2.zzd;
        zzfw zzfw2 = zzfw.zza((zzbg)zzbg2);
        String string2 = string;
        zzic zzic2 = this;
        zzic2.zzl().zzt();
        zzne.zza(zzic2.zzaf == null || zzic2.zzag == null || !zzic2.zzag.equals(string2) ? null : zzic2.zzaf, (Bundle)zzfw2.zzb, (boolean)false);
        zzbg2 = zzfw2.zza();
        this.zzp();
        if (!zzna.zza(zzbg2, zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        if (zzo2.zzs != null) {
            if (zzo2.zzs.contains(zzbg2.zza)) {
                Bundle bundle = zzbg2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbg2 = new zzbg(zzbg2.zza, new zzbb(bundle), zzbg2.zzc, zzbg2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbg2.zza, (Object)zzbg2.zzc);
                return;
            }
        }
        this.zzf().zzp();
        try {
            zzad zzad2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            long l2 = l;
            string2 = string;
            zzic2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzic2.zzt();
            zzic2.zzak();
            if (l2 < 0L) {
                zzic2.zzj().zzu().zza("Invalid time querying timed out conditional properties", zzfs.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zzic2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzp().zza("User property timed out", (Object)((zzad)object22).zza, (Object)this.zzm.zzk().zzc(((zzad)object22).zzc.zza), ((zzad)object22).zzc.zza());
                if (((zzad)object22).zzg != null) {
                    this.zzc(new zzbg(((zzad)object22).zzg, l), zzo2);
                }
                this.zzf().zza(string, ((zzad)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zzic2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzic2.zzt();
            zzic2.zzak();
            if (l2 < 0L) {
                zzic2.zzj().zzu().zza("Invalid time querying expired conditional properties", zzfs.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zzic2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzad)object4.next();
                if (object == null) continue;
                this.zzj().zzp().zza("User property expired", (Object)((zzad)object).zza, (Object)this.zzm.zzk().zzc(((zzad)object).zzc.zza), ((zzad)object).zzc.zza());
                this.zzf().zzh(string, ((zzad)object).zzc.zza);
                if (((zzad)object).zzk != null) {
                    object22.add(((zzad)object).zzk);
                }
                this.zzf().zza(string, ((zzad)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbg)e;
                this.zzc(new zzbg((zzbg)object, l), zzo2);
            }
            long l3 = l;
            String string4 = zzbg2.zza;
            string2 = string;
            zzic2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zzic2.zzt();
            zzic2.zzak();
            if (l3 < 0L) {
                zzic2.zzj().zzu().zza("Invalid time querying triggered conditional properties", zzfs.zza((String)string2), (Object)zzic2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zzic2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzad2 = (zzad)iterator.next();
                if (zzad2 == null) continue;
                zzmz zzmz2 = zzad2.zzc;
                zznb zznb2 = new zznb((String)Preconditions.checkNotNull((Object)zzad2.zza), zzad2.zzb, zzmz2.zza, l, Preconditions.checkNotNull((Object)zzmz2.zza()));
                if (this.zzf().zza(zznb2)) {
                    this.zzj().zzp().zza("User property triggered", (Object)zzad2.zza, (Object)this.zzm.zzk().zzc(zznb2.zzc), zznb2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzfs.zza((String)zzad2.zza), (Object)this.zzm.zzk().zzc(zznb2.zzc), zznb2.zze);
                }
                if (zzad2.zzi != null) {
                    object.add(zzad2.zzi);
                }
                zzad2.zzc = new zzmz(zznb2);
                zzad2.zze = true;
                this.zzf().zza(zzad2);
            }
            this.zzc(zzbg2, zzo2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzad2 = (zzbg)e;
                this.zzc(new zzbg((zzbg)zzad2, l), zzo2);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(zzbg zzbg2, String string) {
        zzh zzh2 = this.zzf().zzd(string);
        if (zzh2 == null || TextUtils.isEmpty((CharSequence)zzh2.zzaa())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzh2);
        if (bl == null) {
            if (!"_ui".equals(zzbg2.zza)) {
                this.zzj().zzu().zza("Could not find package. appId", zzfs.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzfs.zza((String)string));
            return;
        }
        zzie zzie2 = this.zzb(string);
        String string2 = "";
        int n = 100;
        if (zzql.zzb() && this.zze().zza(zzbi.zzcm)) {
            string2 = this.zzd(string).zzf();
            n = zzie2.zza();
        }
        zzo zzo2 = new zzo(string, zzh2.zzac(), zzh2.zzaa(), zzh2.zzc(), zzh2.zzz(), zzh2.zzo(), zzh2.zzl(), null, zzh2.zzak(), false, zzh2.zzab(), zzh2.zzb(), 0L, 0, zzh2.zzaj(), false, zzh2.zzv(), zzh2.zzu(), zzh2.zzm(), zzh2.zzag(), null, zzie2.zze(), "", null, zzh2.zzam(), zzh2.zzt(), n, string2, zzh2.zza(), zzh2.zzd());
        this.zzb(zzbg2, zzo2);
    }

    @WorkerThread
    private final void zzb(zzbg zzbg2, zzo zzo2) {
        zzmz zzmz2;
        String string;
        Preconditions.checkNotEmpty((String)zzo2.zza);
        zzfw zzfw2 = zzfw.zza((zzbg)zzbg2);
        this.zzq().zza(zzfw2.zzb, this.zzf().zzc(zzo2.zza));
        this.zzq().zza(zzfw2, this.zze().zzd(zzo2.zza));
        zzbg2 = zzfw2.zza();
        zzo zzo3 = zzo2;
        zzbg zzbg3 = zzbg2;
        zzmq zzmq2 = this;
        if ("_cmp".equals(zzbg3.zza) && "referrer API v2".equals(zzbg3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbg3.zzb.zzd("gclid")))) {
            zzmz2 = new zzmz("_lgclid", zzbg3.zzd, (Object)string, "auto");
            zzmq2.zza(zzmz2, zzo3);
        }
        if (zzri.zzb() && zzri.zzd()) {
            zzo3 = zzo2;
            zzbg3 = zzbg2;
            zzmq2 = this;
            if ("_cmp".equals(zzbg3.zza) && "referrer API v2".equals(zzbg3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbg3.zzb.zzd("gbraid")))) {
                zzmz2 = new zzmz("_gbraid", zzbg3.zzd, (Object)string, "auto");
                zzmq2.zza(zzmz2, zzo3);
            }
        }
        this.zza(zzbg2, zzo2);
    }

    @VisibleForTesting
    private final void zza(zzfh.zzj.zza zza2, long l, boolean bl) {
        zznb zznb2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zznb2 = (zznb2 = this.zzf().zze(zza2.zzr(), string)) == null || zznb2.zze == null ? new zznb(zza2.zzr(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zznb(zza2.zzr(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zznb2.zze + l));
        zzfh.zzn zzn2 = (zzfh.zzn)((zzlw)zzfh.zzn.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza((Long)zznb2.zze).zzab());
        boolean bl2 = false;
        int n = zzna.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzn2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzn2);
        }
        if (l > 0L) {
            this.zzf().zza(zznb2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzp().zza("Updated engagement user property. scope, value", (Object)string2, zznb2.zze);
        }
    }

    final void zzt() {
        ++this.zzt;
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzp().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzp();
            try {
                boolean bl;
                zzh zzh2 = this.zzf().zzd(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzh2 == null) {
                    this.zzj().zzu().zza("App does not exist in onConfigFetched. appId", zzfs.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = list != null && !list.isEmpty() ? list.get(0) : null;
                    List<String> list2 = map != null ? map.get("ETag") : null;
                    String string4 = string2 = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string3, string2)) {
                        return;
                    }
                    zzh2.zzc(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzh2);
                    if (n == 404) {
                        this.zzj().zzv().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzp().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab();
                    }
                } else {
                    zzh2.zzl(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzh2);
                    this.zzj().zzp().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzab();
                }
                this.zzf().zzw();
            }
            finally {
                this.zzf().zzu();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzaa();
        }
    }

    final void zza(boolean bl) {
        this.zzab();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string) {
        this.zzl().zzt();
        this.zzs();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (zzqk.zzb() && this.zze().zza(zzbi.zzcr) && !bl || (n == 200 || n == 204) && throwable == null) {
                try {
                    if (!zzqk.zzb() || !this.zze().zza(zzbi.zzcr) || bl) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zzd.zza(0L);
                    this.zzab();
                    if (!zzqk.zzb() || !this.zze().zza(zzbi.zzcr) || bl) {
                        this.zzj().zzp().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else if (zzqk.zzb() && this.zze().zza(zzbi.zzcr)) {
                        this.zzj().zzp().zza("Purged empty bundles");
                    }
                    this.zzf().zzp();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzao zzao2 = this.zzf();
                                zzao2.zzt();
                                zzao2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzao2.e_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzao2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzw();
                    }
                    finally {
                        this.zzf().zzu();
                    }
                    this.zzaa = null;
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab = -1L;
                        this.zzab();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzp().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                this.zzj().zzp().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list);
                this.zzab();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    final void zzc(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zzmq.zze(zzo2)) {
            return;
        }
        zzh zzh2 = this.zzf().zzd(zzo2.zza);
        if (zzh2 != null && TextUtils.isEmpty((CharSequence)zzh2.zzac()) && !TextUtils.isEmpty((CharSequence)zzo2.zzb)) {
            zzh2.zzc(0L);
            this.zzf().zza(zzh2);
            this.zzi().zzj(zzo2.zza);
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        long l = zzo2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzm();
        int n = zzo2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzu().zza("Incorrect app type, assuming installed app. appId, appType", zzfs.zza((String)zzo2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzp();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzao zzao2;
            String string2;
            zzmz zzmz2;
            zznb zznb2 = this.zzf().zze(zzo2.zza, "_npa");
            if (zznb2 == null || "auto".equals(zznb2.zzb)) {
                if (zzo2.zzq != null) {
                    zzmz2 = new zzmz("_npa", l, (Object)(zzo2.zzq != false ? 1L : 0L), "auto");
                    if (zznb2 == null || !zznb2.zze.equals(zzmz2.zzc)) {
                        this.zza(zzmz2, zzo2);
                    }
                } else if (zznb2 != null) {
                    this.zza("_npa", zzo2);
                }
            }
            long l2 = l;
            zzo zzo3 = zzo2;
            zzmq zzmq2 = this;
            Object object3 = zzmq2.zzf().zzd((String)Preconditions.checkNotNull((Object)zzo3.zza));
            if (object3 != null) {
                zzmq2.zzq();
                if (zzne.zza((String)zzo3.zzb, (String)((zzh)object3).zzac(), (String)zzo3.zzp, (String)((zzh)object3).zzv())) {
                    zzmq2.zzj().zzu().zza("New GMP App Id passed in. Removing cached database data. appId", zzfs.zza((String)((zzh)object3).zzx()));
                    string2 = ((zzh)object3).zzx();
                    zzao2 = zzmq2.zzf();
                    zzao2.zzak();
                    zzao2.zzt();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzao2.e_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzao2.zzj().zzp().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzao2.zzj().zzg().zza("Error deleting application data. appId, error", zzfs.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl = ((zzh)object3).zzc() != Integer.MIN_VALUE && ((zzh)object3).zzc() != zzo3.zzj;
                string = ((zzh)object3).zzaa();
                if (bl | (((zzh)object3).zzc() == Integer.MIN_VALUE && string != null && !string.equals(zzo3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbg("_au", new zzbb(bundle), "auto", l2);
                    zzmq2.zza((zzbg)object, zzo3);
                }
            }
            this.zza(zzo2);
            zzmz2 = null;
            if (n == 0) {
                zzmz2 = this.zzf().zzd(zzo2.zza, "_f");
            } else if (n == 1) {
                zzmz2 = this.zzf().zzd(zzo2.zza, "_v");
            }
            if (zzmz2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzmz zzmz3 = new zzmz("_fot", l, (Object)l3, "auto");
                    this.zza(zzmz3, zzo2);
                    zzo3 = zzo2;
                    zzmq2 = this;
                    zzmq2.zzl().zzt();
                    String string3 = zzo3.zza;
                    zzgj zzgj2 = (zzgj)Preconditions.checkNotNull((Object)zzmq2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzgj2.zza.zzj().zzw().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzgj2.zza.zzl().zzt();
                        if (!zzgj2.zza()) {
                            zzgj2.zza.zzj().zzn().zza("Install Referrer Reporter is not available");
                        } else {
                            zzgm zzgm2 = new zzgm(zzgj2, string3);
                            object3 = zzgj2;
                            ((zzgj)object3).zza.zzl().zzt();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzgj)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzgj)object3).zza.zzj().zzw().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzao2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzao2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzao2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzao2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzgj)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl = ConnectionTracker.getInstance().bindService(((zzgj)object3).zza.zza(), intent, (ServiceConnection)zzgm2, 1);
                                                ((zzgj)object3).zza.zzj().zzp().zza("Install Referrer Service is", (Object)(bl ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzgj)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzgj)object3).zza.zzj().zzu().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzgj)object3).zza.zzj().zzn().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzo3 = zzo2;
                    zzmq2 = this;
                    zzmq2.zzl().zzt();
                    zzmq2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
                    object2 = string4;
                    zzao zzao3 = zzmq2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzao3.zzt();
                    zzao3.zzak();
                    long l5 = zzao3.zzb((String)object2, "first_open_count");
                    if (zzmq2.zzm.zza().getPackageManager() == null) {
                        zzmq2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzfs.zza((String)string4));
                    } else {
                        zzao2 = null;
                        try {
                            zzao2 = Wrappers.packageManager((Context)zzmq2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzmq2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzfs.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzao2 != null && ((PackageInfo)zzao2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzao2).firstInstallTime != ((PackageInfo)zzao2).lastUpdateTime) {
                                if (zzmq2.zze().zza(zzbi.zzbl)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl = true;
                            }
                            sQLiteDatabase = new zzmz("_fi", l4, (Object)(bl ? 1L : 0L), "auto");
                            zzmq2.zza((zzmz)sQLiteDatabase, zzo3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzmq2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzmq2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzfs.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzao2 = new zzbg("_f", new zzbb((Bundle)object3), "auto", l4);
                    zzmq2.zzb((zzbg)zzao2, zzo3);
                } else if (n == 1) {
                    zzmz zzmz4 = new zzmz("_fvt", l, (Object)l3, "auto");
                    this.zza(zzmz4, zzo2);
                    l2 = l;
                    zzo3 = zzo2;
                    zzmq2 = this;
                    zzmq2.zzl().zzt();
                    zzmq2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbg zzbg2 = new zzbg("_v", new zzbb((Bundle)object3), "auto", l2);
                    zzmq2.zzb(zzbg2, zzo3);
                }
            } else if (zzo2.zzi) {
                l2 = l;
                zzo3 = zzo2;
                zzmq2 = this;
                object3 = new Bundle();
                zzbg zzbg3 = new zzbg("_cd", new zzbb((Bundle)object3), "auto", l2);
                zzmq2.zzb(zzbg3, zzo3);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    final void zzu() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzad zzad2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzad2.zza));
        if (zzo2 != null) {
            this.zza(zzad2, zzo2);
        }
    }

    @WorkerThread
    final void zza(zzad zzad2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzad2);
        Preconditions.checkNotEmpty((String)zzad2.zza);
        Preconditions.checkNotNull((Object)zzad2.zzc);
        Preconditions.checkNotEmpty((String)zzad2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zzmq.zze(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            String string = (String)Preconditions.checkNotNull((Object)zzad2.zza);
            zzad zzad3 = this.zzf().zzc(string, zzad2.zzc.zza);
            if (zzad3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzad2.zza, (Object)this.zzm.zzk().zzc(zzad2.zzc.zza));
                this.zzf().zza(string, zzad2.zzc.zza);
                if (zzad3.zze) {
                    this.zzf().zzh(string, zzad2.zzc.zza);
                }
                if (zzad2.zzk != null) {
                    Bundle bundle = null;
                    if (zzad2.zzk.zzb != null) {
                        bundle = zzad2.zzk.zzb.zzb();
                    }
                    zzbg zzbg2 = this.zzq().zza(string, ((zzbg)Preconditions.checkNotNull((Object)zzad2.zzk)).zza, bundle, zzad3.zzb, zzad2.zzk.zzd, true, true);
                    this.zzc((zzbg)Preconditions.checkNotNull((Object)zzbg2), zzo2);
                }
            } else {
                this.zzj().zzu().zza("Conditional user property doesn't exist", zzfs.zza((String)zzad2.zza), (Object)this.zzm.zzk().zzc(zzad2.zzc.zza));
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting
    private static void zza(zzfh.zze.zza zza2, @NonNull String string) {
        List<zzfh.zzg> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zzmq.zze(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        if ("_npa".equals(string) && zzo2.zzq != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zzmz zzmz2 = new zzmz("_npa", this.zzb().currentTimeMillis(), (Object)(zzo2.zzq != false ? 1L : 0L), "auto");
            this.zza(zzmz2, zzo2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), string);
            this.zzf().zzw();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zzd(zzo zzo2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzo2.zza);
        zzao zzao2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzao2.zzt();
        zzao2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzao2.e_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray);
            if (n > 0) {
                zzao2.zzj().zzp().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzao2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzfs.zza((String)string), (Object)sQLiteException);
        }
        if (zzo2.zzh) {
            this.zzc(zzo2);
        }
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzkf zzkf2) {
        this.zzl().zzt();
        if (this.zzag == null || this.zzag.equals(string) || zzkf2 != null) {
            this.zzag = string;
            this.zzaf = zzkf2;
        }
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzv() {
        this.zzl().zzt();
        this.zzf().zzv();
        if (this.zzj.zzc.zza() == 0L) {
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzab();
    }

    @WorkerThread
    final void zzb(zzad zzad2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzad2.zza));
        if (zzo2 != null) {
            this.zzb(zzad2, zzo2);
        }
    }

    @WorkerThread
    final void zzb(zzad zzad2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzad2);
        Preconditions.checkNotEmpty((String)zzad2.zza);
        Preconditions.checkNotNull((Object)zzad2.zzb);
        Preconditions.checkNotNull((Object)zzad2.zzc);
        Preconditions.checkNotEmpty((String)zzad2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zzmq.zze(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        zzad zzad3 = new zzad(zzad2);
        new zzad(zzad2).zze = false;
        this.zzf().zzp();
        try {
            boolean bl = false;
            zzad zzad4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzad3.zza), zzad3.zzc.zza);
            if (zzad4 != null && !zzad4.zzb.equals(zzad3.zzb)) {
                this.zzj().zzu().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzad3.zzc.zza), (Object)zzad3.zzb, (Object)zzad4.zzb);
            }
            if (zzad4 != null && zzad4.zze) {
                zzad3.zzb = zzad4.zzb;
                zzad3.zzd = zzad4.zzd;
                zzad3.zzh = zzad4.zzh;
                zzad3.zzf = zzad4.zzf;
                zzad3.zzi = zzad4.zzi;
                zzad3.zze = zzad4.zze;
                zzad3.zzc = new zzmz(zzad3.zzc.zza, zzad4.zzc.zzb, zzad3.zzc.zza(), zzad4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzad3.zzf)) {
                zzad3.zzc = new zzmz(zzad3.zzc.zza, zzad3.zzd, zzad3.zzc.zza(), zzad3.zzc.zze);
                zzad3.zze = true;
                bl = true;
            }
            if (zzad3.zze) {
                zzmz zzmz2 = zzad3.zzc;
                zznb zznb2 = new zznb((String)Preconditions.checkNotNull((Object)zzad3.zza), zzad3.zzb, zzmz2.zza, zzmz2.zzb, Preconditions.checkNotNull((Object)zzmz2.zza()));
                if (this.zzf().zza(zznb2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzad3.zza, (Object)this.zzm.zzk().zzc(zznb2.zzc), zznb2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzfs.zza((String)zzad3.zza), (Object)this.zzm.zzk().zzc(zznb2.zzc), zznb2.zze);
                }
                if (bl && zzad3.zzi != null) {
                    zzbg zzbg2 = new zzbg(zzad3.zzi, zzad3.zzd);
                    this.zzc(zzbg2, zzo2);
                }
            }
            if (this.zzf().zza(zzad3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzad3.zza, (Object)this.zzm.zzk().zzc(zzad3.zzc.zza), zzad3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzfs.zza((String)zzad3.zza), (Object)this.zzm.zzk().zzc(zzad3.zzc.zza), zzad3.zzc.zza());
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(String string, zzie zzie2) {
        this.zzl().zzt();
        this.zzs();
        this.zzac.put(string, zzie2);
        this.zzf().zza(string, zzie2);
    }

    @WorkerThread
    final void zza(String string, zzay zzay2) {
        this.zzl().zzt();
        this.zzs();
        if (zzql.zzb()) {
            this.zzad.put(string, zzay2);
            this.zzf().zza(string, zzay2);
        }
    }

    @WorkerThread
    private final void zzab() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzt();
            this.zzs();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzp().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzy().zzb();
                    this.zzz().zzu();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzaf() || !this.zzac()) {
                this.zzj().zzp().zza("Nothing to upload or uploading impossible");
                this.zzy().zzb();
                this.zzz().zzu();
                return;
            }
            zzmq zzmq2 = this;
            long l5 = zzmq2.zzb().currentTimeMillis();
            zzmq2.zze();
            long l6 = Math.max(0L, (Long)zzbi.zzaa.zza(null));
            boolean bl = zzmq2.zzf().zzz() || zzmq2.zzf().zzy();
            if (bl) {
                String string = zzmq2.zze().zzn();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zzmq2.zze();
                    l4 = Math.max(0L, (Long)zzbi.zzv.zza(null));
                } else {
                    zzmq2.zze();
                    l4 = Math.max(0L, (Long)zzbi.zzu.zza(null));
                }
            } else {
                zzmq2.zze();
                l4 = Math.max(0L, (Long)zzbi.zzt.zza(null));
            }
            long l7 = zzmq2.zzj.zzc.zza();
            long l8 = zzmq2.zzj.zzd.zza();
            long l9 = zzmq2.zzf().c_();
            long l10 = zzmq2.zzf().d_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zzmq2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zzmq2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbi.zzac.zza(null)))) break;
                        long l15 = 1L << n;
                        zzmq2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbi.zzab.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzp().zza("Next upload time is 0");
            this.zzy().zzb();
            this.zzz().zzu();
            return;
        }
        if (!this.zzh().zzu()) {
            this.zzj().zzp().zza("No network");
            this.zzy().zza();
            this.zzz().zzu();
            return;
        }
        l2 = this.zzj.zzb.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbi.zzr.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzy().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbi.zzw.zza(null));
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzp().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzz().zza(l17);
    }

    @WorkerThread
    private final void zza(String string, boolean bl) {
        zzh zzh2 = this.zzf().zzd(string);
        if (zzh2 != null) {
            zzh2.zzd(bl);
            if (zzh2.zzal()) {
                this.zzf().zza(zzh2);
            }
        }
    }

    @WorkerThread
    final void zza(zzmz zzmz2, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zzmq.zze(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        int n = this.zzq().zzb(zzmz2.zza);
        if (n != 0) {
            this.zzq();
            String string = zzmz2.zza;
            this.zze();
            String string2 = zzne.zza((String)string, (int)24, (boolean)true);
            int n2 = zzmz2.zza != null ? zzmz2.zza.length() : 0;
            this.zzq();
            zzne.zza((zznf)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zzmz2.zza, zzmz2.zza());
        if (n != 0) {
            this.zzq();
            String string = zzmz2.zza;
            this.zze();
            String string3 = zzne.zza((String)string, (int)24, (boolean)true);
            Object object = zzmz2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zzne.zza((zznf)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zzmz2.zza, zzmz2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzmz2.zza)) {
            zzbc zzbc2;
            zzo zzo3 = zzo2;
            String string = zzmz2.zze;
            long l = zzmz2.zzb;
            zzmq zzmq2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
            long l2 = 0L;
            zznb zznb2 = zzmq2.zzf().zze(string4, "_sno");
            if (zznb2 != null && zznb2.zze instanceof Long) {
                l2 = (Long)zznb2.zze;
            } else {
                if (zznb2 != null) {
                    zzmq2.zzj().zzu().zza("Retrieved last session number from database does not contain a valid (long) value", zznb2.zze);
                }
                if ((zzbc2 = zzmq2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzbc2.zzc;
                    zzmq2.zzj().zzp().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzbc2 = new zzmz("_sno", l, (Object)(++l2), string);
            zzmq2.zza((zzmz)zzbc2, zzo3);
        }
        zznb zznb3 = new zznb((String)Preconditions.checkNotNull((Object)zzo2.zza), (String)Preconditions.checkNotNull((Object)zzmz2.zze), zzmz2.zza, zzmz2.zzb, object);
        this.zzj().zzp().zza("Setting user property", (Object)this.zzm.zzk().zzc(zznb3.zzc), object);
        this.zzf().zzp();
        try {
            zznb zznb4;
            if ("_id".equals(zznb3.zzc) && (zznb4 = this.zzf().zze(zzo2.zza, "_id")) != null && !zznb3.zze.equals(zznb4.zze)) {
                this.zzf().zzh(zzo2.zza, "_lair");
            }
            this.zza(zzo2);
            boolean bl = this.zzf().zza(zznb3);
            if ("_sid".equals(zzmz2.zza)) {
                long l = this.zzp().zza(zzo2.zzv);
                zzh zzh2 = this.zzf().zzd(zzo2.zza);
                if (zzh2 != null) {
                    zzh2.zzq(l);
                    if (zzh2.zzal()) {
                        this.zzf().zza(zzh2);
                    }
                }
            }
            this.zzf().zzw();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zznb3.zzc), zznb3.zze);
                this.zzq();
                zzne.zza((zznf)this.zzah, (String)zzo2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zzw() {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzr().zzab();
            if (bl == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzab();
                return;
            }
            zzic zzic2 = this;
            zzic2.zzl().zzt();
            if (zzic2.zzz != null) {
                this.zzj().zzp().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzab();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbi.zzar);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzaf.zzh();
            for (int i = 0; i < n && this.zza(null, l2 = l4); ++i) {
            }
            if (zzsg.zzb()) {
                zzic2 = this;
                zzic2.zzl().zzt();
                for (String object7 : zzic2.zzr) {
                    if (!zzsg.zzb() || !zzic2.zze().zze(object7, zzbi.zzcf)) continue;
                    zzic2.zzj().zzc().zza("Notifying app that trigger URIs are available. App ID", (Object)object7);
                    Intent intent = new Intent();
                    intent.setAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
                    intent.setPackage(object7);
                    zzic2.zzm.zza().sendBroadcast(intent);
                }
                zzic2.zzr.clear();
            }
            if ((l = this.zzj.zzc.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().f_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().b_();
                }
                int n2 = this.zze().zzb(string, zzbi.zzg);
                Object object = string;
                zzic2 = this.zze();
                int n3 = Math.max(0, zzic2.zzb((String)object, zzbi.zzh));
                List<Pair<zzfh.zzj, Long>> list = this.zzf().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    if (this.zzb(string).zzg()) {
                        object6 = null;
                        Iterator<Pair<zzfh.zzj, Long>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            zzfh.zzj zzj2 = (zzfh.zzj)((Object)iterator.next().first);
                            if (zzj2.zzal().isEmpty()) continue;
                            object6 = zzj2.zzal();
                            break;
                        }
                        if (object6 != null) {
                            for (int i = 0; i < list.size(); ++i) {
                                object5 = (zzfh.zzj)((Object)list.get((int)i).first);
                                if (((zzfh.zzj)((Object)object5)).zzal().isEmpty() || ((zzfh.zzj)((Object)object5)).zzal().equals(object6)) continue;
                                list = list.subList(0, i);
                                break;
                            }
                        }
                    }
                    object6 = zzfh.zzi.zzb();
                    int n4 = list.size();
                    object5 = new ArrayList(list.size());
                    boolean bl2 = this.zze().zzk(string) && this.zzb(string).zzg();
                    boolean bl3 = this.zzb(string).zzg();
                    boolean bl4 = this.zzb(string).zzh();
                    boolean bl5 = zzss.zzb() && this.zze().zze(string, zzbi.zzbt);
                    for (int i = 0; i < n4; ++i) {
                        object4 = (zzfh.zzj.zza)((zzfh.zzj)((Object)list.get((int)i).first)).zzby();
                        object5.add((Long)list.get((int)i).second);
                        this.zze();
                        ((zzfh.zzj.zza)((Object)object4)).zzl(81010L).zzk(l3).zzd(false);
                        if (!bl2) {
                            ((zzfh.zzj.zza)((Object)object4)).zzh();
                        }
                        if (!bl3) {
                            ((zzfh.zzj.zza)((Object)object4)).zzo();
                            ((zzfh.zzj.zza)((Object)object4)).zzk();
                        }
                        if (!bl4) {
                            ((zzfh.zzj.zza)((Object)object4)).zze();
                        }
                        this.zza(string, (zzfh.zzj.zza)((Object)object4));
                        if (!bl5) {
                            ((zzfh.zzj.zza)((Object)object4)).zzp();
                        }
                        if (zzqk.zzb() && this.zze().zza(zzbi.zzcr)) {
                            object = object4;
                            zzic2 = this;
                            String string2 = ((zzfh.zzj.zza)((Object)object)).zzv();
                            boolean bl6 = false;
                            if (TextUtils.isEmpty((CharSequence)string2) || string2.equals("00000000-0000-0000-0000-000000000000")) {
                                object3 = new ArrayList<zzfh.zze>(((zzfh.zzj.zza)((Object)object)).zzw());
                                boolean bl7 = false;
                                Iterator iterator = object3.iterator();
                                while (iterator.hasNext()) {
                                    zzfh.zze zze2 = (zzfh.zze)((Object)iterator.next());
                                    if ("_fx".equals(zze2.zzg())) {
                                        bl6 = true;
                                        iterator.remove();
                                        bl7 = true;
                                        continue;
                                    }
                                    if (!"_f".equals(zze2.zzg())) continue;
                                    bl6 = true;
                                }
                                if (bl7) {
                                    ((zzfh.zzj.zza)((Object)object)).zzi();
                                    ((zzfh.zzj.zza)((Object)object)).zzb((Iterable<? extends zzfh.zze>)object3);
                                }
                                if (bl6) {
                                    super.zza(((zzfh.zzj.zza)((Object)object)).zzr(), true);
                                }
                            }
                            if (((zzfh.zzj.zza)((Object)object4)).zza() == 0) continue;
                        }
                        if (this.zze().zze(string, zzbi.zzbd)) {
                            object2 = ((zzfh.zzj)((zzlw)object4.zzab())).zzbv();
                            ((zzfh.zzj.zza)((Object)object4)).zza(this.zzp().zza((byte[])object2));
                        }
                        ((zzfh.zzi.zza)((Object)object6)).zza((zzfh.zzj.zza)((Object)object4));
                    }
                    if (zzqk.zzb() && this.zze().zza(zzbi.zzcr) && ((zzfh.zzi.zza)((Object)object6)).zza() == 0) {
                        this.zza((List<Long>)object5);
                        this.zza(false, 204, null, null, string);
                        return;
                    }
                    String string3 = null;
                    if (this.zzj().zza(2)) {
                        string3 = this.zzp().zza((zzfh.zzi)((zzlw)object6.zzab()));
                    }
                    this.zzp();
                    object4 = ((zzfh.zzi)((zzlw)object6.zzab())).zzbv();
                    object2 = this.zzk.zza(string);
                    try {
                        this.zza((List<Long>)object5);
                        this.zzj.zzd.zza(l3);
                        String string4 = "?";
                        if (n4 > 0) {
                            string4 = ((zzfh.zzi.zza)((Object)object6)).zza(0).zzx();
                        }
                        this.zzj().zzp().zza("Uploading data. app, uncompressed size, data", (Object)string4, (Object)((Object)object4).length, (Object)string3);
                        this.zzv = true;
                        zzms zzms2 = new zzms(this, string);
                        object3 = ((zzmn)object2).zzb();
                        Object object7 = object4;
                        URL uRL = new URL(((zzmn)object2).zza());
                        object = string;
                        zzic2 = this.zzh();
                        zzic2.zzt();
                        zzic2.zzak();
                        Preconditions.checkNotNull((Object)uRL);
                        Preconditions.checkNotNull((Object)object7);
                        Preconditions.checkNotNull((Object)zzms2);
                        zzic2.zzl().zza((Runnable)new zzfz((zzfv)zzic2, (String)object, uRL, (byte[])object7, (Map)object3, zzms2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj().zzg().zza("Failed to parse upload URL. Not uploading. appId", zzfs.zza((String)string), (Object)((zzmn)object2).zza());
                    }
                }
            } else {
                zzh zzh2;
                this.zzab = -1L;
                zzao zzao2 = this.zzf();
                this.zze();
                String string5 = zzao2.zza(l3 - com.google.android.gms.measurement.internal.zzaf.zzh());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzh2 = this.zzf().zzd(string5)) != null) {
                    this.zzb(zzh2);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbg var1_1, zzo var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzt();
        this.zzs();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zzna.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzu().zza("Dropping blocked event. appId", zzfs.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzm(var5_4) != false || this.zzi().zzo(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zzne.zza((zznf)this.zzah, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zzd(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzn(), var7_7.zze());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbi.zzz.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzfw.zza((zzbg)var1_1);
        this.zzq().zza(var6_6, this.zze().zzd(var5_4));
        var7_8 = zzrp.zzb() != false && this.zze().zza(zzbi.zzcd) != false ? this.zze().zza(var5_4, zzbi.zzaq, 10, 35) : 0;
        for (String var10_12 : new TreeSet<E>(var6_6.zzb.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzb.getParcelableArray(var10_12), var7_8, zzrp.zzb() != false && this.zze().zza(zzbi.zzcd) != false);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzp().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        if (zzrj.zzb()) {
            this.zze().zza(zzbi.zzca);
        }
        this.zzf().zzp();
        try {
            block69: {
                block70: {
                    block72: {
                        block76: {
                            block75: {
                                block73: {
                                    block74: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block72;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block73;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block74;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block75;
                                    }
                                    var25_19.zzj().zzu().zza("Data lost. Currency value is too big. appId", zzfs.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block76;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbi.zzae) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzt();
                                    var41_32.zzak();
                                    try {
                                        var41_32.e_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_33) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzfs.zza((String)var42_31), (Object)var44_33);
                                    }
                                    var33_29 = new zznb(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_34 = (Long)var33_29.zze;
                                    var33_29 = new zznb(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_34 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zznb)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzfs.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zzne.zza((zznf)var25_19.zzah, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var11_38 = zzne.zzh((String)var1_1.zza);
                    var12_39 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_40 = 1L + zzne.zza((zzbb)var1_1.zzb);
                    var15_41 = this.zzf().zza(this.zzx(), var5_4, var13_40, true, var11_38, false, var12_39, false);
                    v2 = var15_41.zzb;
                    this.zze();
                    var16_42 = v2 - (long)((Integer)zzbi.zzk.zza(null)).intValue();
                    if (var16_42 > 0L) {
                        if (var16_42 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzfs.zza((String)var5_4), (Object)var15_41.zzb);
                        }
                        this.zzf().zzw();
                        return;
                    }
                    if (var11_38) {
                        v3 = var15_41.zza;
                        this.zze();
                        var16_42 = v3 - (long)((Integer)zzbi.zzm.zza(null)).intValue();
                        if (var16_42 > 0L) {
                            if (var16_42 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzfs.zza((String)var5_4), (Object)var15_41.zza);
                            }
                            this.zzq();
                            zzne.zza((zznf)this.zzah, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzw();
                            return;
                        }
                    }
                    if (var12_39) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbi.zzl);
                        var16_42 = var15_41.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_42 > 0L) {
                            if (var16_42 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzfs.zza((String)var5_4), (Object)var15_41.zzd);
                            }
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var18_43 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_43, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzf(var5_4)) {
                        this.zzq().zza(var18_43, "_dbg", (Object)1L);
                        this.zzq().zza(var18_43, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_44 = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_44.zze instanceof Long) {
                        this.zzq().zza(var18_43, "_sno", var19_44.zze);
                    }
                    if ((var19_45 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzu().zza("Data lost. Too many events stored on disk, deleted. appId", zzfs.zza((String)var5_4), (Object)var19_45);
                    }
                    var21_46 = new zzaz(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_43);
                    var22_47 = this.zzf().zzd(var5_4, var21_46.zzb);
                    if (var22_47 == null) {
                        if (this.zzf().zzb(var5_4) >= (long)this.zze().zza(var5_4) && var11_38) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzfs.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_46.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zzne.zza((zznf)this.zzah, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_48 = new zzbc(var5_4, var21_46.zzb, 0L, 0L, var21_46.zzc, 0L, null, null, null, null);
                    } else {
                        var21_46 = var21_46.zza(this.zzm, var22_47.zzf);
                        var23_48 = var22_47.zza(var21_46.zzc);
                    }
                    this.zzf().zza(var23_48);
                    var27_17 = var2_2;
                    var26_18 = var21_46;
                    var25_19 = this;
                    var25_19.zzl().zzt();
                    var25_19.zzs();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzfh.zzj.zzu().zzg(1).zzp("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (zzss.zzb() && !TextUtils.isEmpty((CharSequence)var27_17.zzv) && (var25_19.zze().zza(zzbi.zzbr) || var25_19.zze().zze(var27_17.zza, zzbi.zzbt))) {
                        var28_14.zzr(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzf(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzm(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzie.zza((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zze());
                    if (var28_14.zzt().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (zzsg.zzb() && var25_19.zze().zze(var27_17.zza, zzbi.zzcf)) {
                        var25_19.zzq();
                        if (zzne.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var29_20.zzg() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_49 = var30_25;
                                var40_51 /* !! */  = zzfh.zzb.zza();
                                var40_51 /* !! */ .zzc((var37_49 & 1L) != 0L);
                                var40_51 /* !! */ .zze((var37_49 & 2L) != 0L);
                                var40_51 /* !! */ .zzf((var37_49 & 4L) != 0L);
                                var40_51 /* !! */ .zzg((var37_49 & 8L) != 0L);
                                var40_51 /* !! */ .zzb((var37_49 & 16L) != 0L);
                                var40_51 /* !! */ .zza((var37_49 & 32L) != 0L);
                                var40_51 /* !! */ .zzd((var37_49 & 64L) != 0L);
                                var28_14.zza((zzfh.zzb)((zzlw)var40_51 /* !! */ .zzab()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzc(var27_17.zzf);
                    }
                    var28_14.zzd(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzu();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if ((var31_52 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzie.zza((String)var27_17.zzt))).zzg() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_52)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzq((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc((Boolean)var32_23.second);
                        }
                        if (zzqk.zzb() && var25_19.zze().zza(zzbi.zzcr) && !var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zzd(var27_17.zza)) != null && var33_29.zzan()) {
                            var25_19.zza(var27_17.zza, false);
                            var34_35 = new Bundle();
                            var34_35.putLong("_r", 1L);
                            var25_19.zzah.zza(var27_17.zza, "_fx", var34_35);
                        }
                    }
                    var25_19.zzm.zzg().zzab();
                    v4 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzab();
                    v4.zzo(Build.VERSION.RELEASE).zzi((int)var25_19.zzm.zzg().zzg()).zzs(var25_19.zzm.zzg().zzh());
                    var28_14.zzj(var27_17.zzx);
                    if (var25_19.zzm.zzac()) {
                        var28_14.zzr();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zzd(var27_17.zza)) == null) {
                        var32_24 = new zzh(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_52));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_52.zzg()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzo(0L);
                        var32_24.zzp(0L);
                        var32_24.zzn(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zza(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzm(var27_17.zze);
                        var32_24.zzj(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzk(var27_17.zzr);
                        var25_19.zzf().zza(var32_24);
                    }
                    if (var31_52.zzh() && !TextUtils.isEmpty((CharSequence)var32_24.zzy())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzy()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzab())) {
                        var28_14.zzl((String)Preconditions.checkNotNull((Object)var32_24.zzab()));
                    }
                    var33_29 = var25_19.zzf().zzi(var27_17.zza);
                    for (var34_36 = 0; var34_36 < var33_29.size(); ++var34_36) {
                        var35_53 = zzfh.zzn.zze().zza(((zznb)var33_29.get((int)var34_36)).zzc).zzb(((zznb)var33_29.get((int)var34_36)).zzd);
                        var25_19.zzp().zza(var35_53, ((zznb)var33_29.get((int)var34_36)).zze);
                        var28_14.zza(var35_53);
                        if (!"_sid".equals(((zznb)var33_29.get((int)var34_36)).zzc) || var32_24.zzs() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzs()) continue;
                        var28_14.zzp();
                    }
                    try {
                        var34_37 = var25_19.zzf().zza((zzfh.zzj)((zzlw)var28_14.zzab()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzfs.zza((String)var28_14.zzr()), (Object)var36_28);
                        break block69;
                    }
                    v5 = var25_19.zzf();
                    var38_54 = var26_18;
                    var37_50 = var25_19;
                    if (var38_54.zze == null) ** GOTO lbl-1000
                    for (zzfh.zzb.zza var40_51 : var38_54.zze) {
                        if (!"_r".equals((Object)var40_51 /* !! */ )) continue;
                        v6 = true;
                        break block70;
                    }
                    var39_56 = var37_50.zzi().zzc(var38_54.zza, var38_54.zzb);
                    var40_51 /* !! */  = var37_50.zzf().zza(var37_50.zzx(), var38_54.zza, false, false, false, false, false);
                    if (var39_56 && var40_51 /* !! */ .zze < (long)var37_50.zze().zze(var38_54.zza)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                }
                if (v5.zza((zzaz)var26_18, var34_37, v6)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzw();
        }
        finally {
            this.zzf().zzu();
        }
        this.zzab();
        this.zzj().zzp().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zze(zzo zzo2) {
        return !TextUtils.isEmpty((CharSequence)zzo2.zzb) || !TextUtils.isEmpty((CharSequence)zzo2.zzp);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final boolean zza(@Nullable String string, long l) {
        this.zzf().zzp();
        try {
            block153: {
                zzfh.zzg zzg2;
                boolean bl;
                int n;
                String[] stringArray;
                String string2;
                String string3;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                zza zza2;
                block151: {
                    zza2 = new zza(null);
                    object4 = zza2;
                    long l2 = this.zzab;
                    long l3 = l;
                    object3 = null;
                    object2 = this.zzf();
                    Preconditions.checkNotNull((Object)object4);
                    object2.zzt();
                    ((zzml)((Object)object2)).zzak();
                    try (Cursor cursor = null;){
                        String string4;
                        zzfh.zzj zzj2;
                        Object[] objectArray;
                        object = ((zzao)((Object)object2)).e_();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string3 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = object.rawQuery("select app_id, metadata_fingerprint from raw_events where " + string3 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", objectArray);
                            if (!cursor.moveToFirst()) break block151;
                            object3 = cursor.getString(0);
                            string2 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string3 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = object.rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + string3 + " order by rowid limit 1;", objectArray);
                            if (!cursor.moveToFirst()) break block151;
                            string2 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = object.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object3, string2}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzj().zzg().zza("Raw event metadata record is missing. appId", zzfs.zza((String)object3));
                            break block151;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            zzj2 = (zzfh.zzj)((zzlw)zzna.zza(zzfh.zzj.zzu(), (byte[])objectArray).zzab());
                        }
                        catch (IOException iOException) {
                            object2.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzfs.zza((String)object3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block151;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzj().zzu().zza("Get multiple raw event metadata records, expected one. appId", zzfs.zza((String)object3));
                        }
                        cursor.close();
                        object4.zza(zzj2);
                        if (l2 != -1L) {
                            string4 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object3, string2, String.valueOf(l2)};
                        } else {
                            string4 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object3, string2};
                        }
                        cursor = object.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string4, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzj().zzu().zza("Raw event data disappeared while in transaction. appId", zzfs.zza((String)object3));
                            break block151;
                        }
                        do {
                            zzfh.zze.zza zza3;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zza3 = zzna.zza(zzfh.zze.zze(), (byte[])objectArray);
                            }
                            catch (IOException iOException) {
                                object2.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzfs.zza((String)object3), (Object)iOException);
                                continue;
                            }
                            zza3.zza(cursor.getString(1)).zzb(cursor.getLong(2));
                            if (!object4.zza(l4, (zzfh.zze)((zzlw)zza3.zzab()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzc == null || ((zza)object2).zzc.isEmpty()) break block153;
                boolean bl2 = false;
                zzfh.zzj.zza zza4 = ((zzfh.zzj.zza)zza2.zza.zzby()).zzi();
                int n2 = 0;
                long l5 = 0L;
                zzfh.zze.zza zznl3 = null;
                int n3 = -1;
                zzfh.zze.zza zza5 = null;
                int n4 = -1;
                for (n = 0; n < zza2.zzc.size(); ++n) {
                    int n5;
                    zzfh.zze.zza zznl22;
                    block155: {
                        boolean bl3;
                        block154: {
                            boolean bl4;
                            bl3 = bl2;
                            zznl22 = (zzfh.zze.zza)zza2.zzc.get(n).zzby();
                            if (this.zzi().zzd(zza2.zza.zzx(), zznl22.zze())) {
                                this.zzj().zzu().zza("Dropping blocked raw event. appId", zzfs.zza((String)zza2.zza.zzx()), (Object)this.zzm.zzk().zza(zznl22.zze()));
                                if (this.zzi().zzm(zza2.zza.zzx()) || this.zzi().zzo(zza2.zza.zzx()) || "_err".equals(zznl22.zze())) continue;
                                this.zzq();
                                zzne.zza((zznf)this.zzah, (String)zza2.zza.zzx(), (int)11, (String)"_ev", (String)zznl22.zze(), (int)0);
                                continue;
                            }
                            if (zznl22.zze().equals(zzii.zza((String)"_ai"))) {
                                zznl22.zza("_ai");
                                this.zzj().zzp().zza("Renaming ad_impression to _ai");
                                if (this.zzj().zza(5)) {
                                    for (n5 = 0; n5 < zznl22.zza(); ++n5) {
                                        if (!"ad_platform".equals(zznl22.zzb(n5).zzg()) || zznl22.zzb(n5).zzh().isEmpty() || !"admob".equalsIgnoreCase(zznl22.zzb(n5).zzh())) continue;
                                        this.zzj().zzv().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                    }
                                }
                            }
                            if ((n5 = this.zzi().zzc(zza2.zza.zzx(), zznl22.zze())) != 0) break block154;
                            this.zzp();
                            object2 = zznl22.zze();
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_ui": {
                                    bl4 = true;
                                    break;
                                }
                                default: {
                                    bl4 = false;
                                }
                            }
                            if (!bl4) break block155;
                        }
                        bl = false;
                        boolean bl5 = false;
                        for (int i = 0; i < zznl22.zza(); ++i) {
                            if ("_c".equals(zznl22.zzb(i).zzg())) {
                                zzg2 = (zzfh.zzg)((zzlw)((zzfh.zzg.zza)zznl22.zzb(i).zzby()).zza(1L).zzab());
                                bl = true;
                                zznl22.zza(i, zzg2);
                                continue;
                            }
                            if (!"_r".equals(zznl22.zzb(i).zzg())) continue;
                            zzg2 = (zzfh.zzg)((zzlw)((zzfh.zzg.zza)zznl22.zzb(i).zzby()).zza(1L).zzab());
                            bl5 = true;
                            zznl22.zza(i, zzg2);
                        }
                        if (!bl && n5 != 0) {
                            this.zzj().zzp().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(zznl22.zze()));
                            zznl22.zza(zzfh.zzg.zze().zza("_c").zza(1L));
                        }
                        if (!bl5) {
                            this.zzj().zzp().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(zznl22.zze()));
                            zznl22.zza(zzfh.zzg.zze().zza("_r").zza(1L));
                        }
                        bl2 = true;
                        if (this.zzf().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zze().zze(zza2.zza.zzx())) {
                            zzmq.zza(zznl22, "_r");
                            bl2 = bl3;
                        }
                        if (zzne.zzh((String)zznl22.zze()) && n5 != 0 && this.zzf().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(zza2.zza.zzx(), zzbi.zzn)) {
                            this.zzj().zzu().zza("Too many conversions. Not logging as conversion. appId", zzfs.zza((String)zza2.zza.zzx()));
                            boolean bl6 = false;
                            zzfh.zzg.zza zza3 = null;
                            int n6 = -1;
                            for (int i = 0; i < zznl22.zza(); ++i) {
                                zzfh.zzg zzg3 = zznl22.zzb(i);
                                if ("_c".equals(zzg3.zzg())) {
                                    zza3 = (zzfh.zzg.zza)zzg3.zzby();
                                    n6 = i;
                                    continue;
                                }
                                if (!"_err".equals(zzg3.zzg())) continue;
                                bl6 = true;
                            }
                            if (bl6 && zza3 != null) {
                                zznl22.zza(n6);
                            } else if (zza3 != null) {
                                zzfh.zzg zzg4 = (zzfh.zzg)((zzlw)((zzfh.zzg.zza)((zzlw.zza)zza3.clone())).zza("_err").zza(10L).zzab());
                                zznl22.zza(n6, zzg4);
                            } else {
                                this.zzj().zzg().zza("Did not find conversion parameter. appId", zzfs.zza((String)zza2.zza.zzx()));
                            }
                        }
                    }
                    if (n5 != 0) {
                        int n7;
                        object3 = zznl22;
                        object2 = this;
                        Object object5 = new ArrayList<zzfh.zzg>(((zzfh.zze.zza)((Object)object3)).zzf());
                        int i = -1;
                        int n9 = -1;
                        for (n7 = 0; n7 < object5.size(); ++n7) {
                            if ("value".equals(((zzfh.zzg)((Object)object5.get(n7))).zzg())) {
                                i = n7;
                                continue;
                            }
                            if (!"currency".equals(((zzfh.zzg)((Object)object5.get(n7))).zzg())) continue;
                            n9 = n7;
                        }
                        if (i != -1) {
                            if (!((zzfh.zzg)((Object)object5.get(i))).zzl() && !((zzfh.zzg)((Object)object5.get(i))).zzj()) {
                                ((zzmq)object2).zzj().zzv().zza("Value must be specified with a numeric type.");
                                ((zzfh.zze.zza)((Object)object3)).zza(i);
                                zzmq.zza((zzfh.zze.zza)((Object)object3), "_c");
                                zzmq.zza((zzfh.zze.zza)((Object)object3), 18, "value");
                            } else {
                                n7 = 0;
                                if (n9 == -1) {
                                    n7 = 1;
                                } else {
                                    object4 = ((zzfh.zzg)((Object)object5.get(n9))).zzh();
                                    if (((String)object4).length() != 3) {
                                        n7 = 1;
                                    } else {
                                        int n10;
                                        for (i = 0; i < ((String)object4).length(); i += Character.charCount(n10)) {
                                            n10 = ((String)object4).codePointAt(i);
                                            if (Character.isLetter(n10)) continue;
                                            n7 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n7 != 0) {
                                    ((zzmq)object2).zzj().zzv().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    ((zzfh.zze.zza)((Object)object3)).zza(i);
                                    zzmq.zza((zzfh.zze.zza)((Object)object3), "_c");
                                    zzmq.zza((zzfh.zze.zza)((Object)object3), 19, "currency");
                                }
                            }
                        }
                    }
                    if ("_e".equals(zznl22.zze())) {
                        this.zzp();
                        if (zzna.zza((zzfh.zze)((zzlw)zznl22.zzab()), "_fr") == null) {
                            if (zza5 != null && Math.abs(zza5.zzc() - zznl22.zzc()) <= 1000L) {
                                zzfh.zze.zza zza6 = (zzfh.zze.zza)((zzlw.zza)zza5.clone());
                                if (this.zza(zznl22, zza6)) {
                                    zznl3 = null;
                                    zza5 = null;
                                    zza4.zza(n4, zza6);
                                } else {
                                    zznl3 = zznl22;
                                    n3 = n2;
                                }
                            } else {
                                zznl3 = zznl22;
                                n3 = n2;
                            }
                        }
                    } else if ("_vs".equals(zznl22.zze())) {
                        this.zzp();
                        if (zzna.zza((zzfh.zze)((zzlw)zznl22.zzab()), "_et") == null) {
                            if (zznl3 != null && Math.abs(zznl3.zzc() - zznl22.zzc()) <= 1000L) {
                                zzfh.zze.zza zza7 = (zzfh.zze.zza)((zzlw.zza)zznl3.clone());
                                if (this.zza(zza7, zznl22)) {
                                    zznl3 = null;
                                    zza5 = null;
                                    zza4.zza(n3, zza7);
                                } else {
                                    zza5 = zznl22;
                                    n4 = n2;
                                }
                            } else {
                                zza5 = zznl22;
                                n4 = n2;
                            }
                        }
                    }
                    zza2.zzc.set(n, (zzfh.zze)((zzlw)zznl22.zzab()));
                    ++n2;
                    zza4.zza(zznl22);
                }
                for (n = 0; n < n2; ++n) {
                    Long l2;
                    zzfh.zze zze2 = zza4.zza(n);
                    if ("_e".equals(zze2.zzg())) {
                        this.zzp();
                        if (zzna.zza(zze2, "_fr") != null) {
                            zza4.zzb(n);
                            --n2;
                            --n;
                            continue;
                        }
                    }
                    this.zzp();
                    zzfh.zzg i = zzna.zza(zze2, "_et");
                    if (i == null || (l2 = i.zzl() ? Long.valueOf(i.zzd()) : null) == null || l2 <= 0L) continue;
                    l5 += l2.longValue();
                }
                this.zza(zza4, l5, false);
                n = 0;
                for (zzfh.zze zze2 : zza4.zzw()) {
                    if (!"_s".equals(zze2.zzg())) continue;
                    n = 1;
                    break;
                }
                if (n != 0) {
                    this.zzf().zzh(zza4.zzr(), "_se");
                }
                if (zzna.zza(zza4, "_sid") >= 0) {
                    this.zza(zza4, l5, true);
                } else {
                    int n8 = zzna.zza(zza4, "_se");
                    if (n8 >= 0) {
                        zza4.zzc(n8);
                        this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzfs.zza((String)zza2.zza.zzx()));
                    }
                }
                this.zzp().zza(zza4);
                if (zzql.zzb() && this.zze().zza(zzbi.zzcm)) {
                    zzfh.zzj.zza zza9 = zza4;
                    object3 = zza2.zza.zzx();
                    object2 = this;
                    ((zzmq)object2).zzl().zzt();
                    ((zzmq)object2).zzs();
                    if (zzql.zzb()) {
                        zzh sQLiteException = ((zzmq)object2).zzf().zzd((String)object3);
                        if (sQLiteException == null) {
                            ((zzmq)object2).zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzfs.zza((String)object3));
                        } else {
                            ((zzmq)object2).zza(sQLiteException, zza9);
                        }
                    }
                }
                object2 = zza4;
                ((zzfh.zzj.zza)((Object)object2)).zzi(Long.MAX_VALUE).zze(Long.MIN_VALUE);
                for (int i = 0; i < ((zzfh.zzj.zza)((Object)object2)).zza(); ++i) {
                    zzfh.zze zze3 = ((zzfh.zzj.zza)((Object)object2)).zza(i);
                    if (zze3.zzd() < ((zzfh.zzj.zza)((Object)object2)).zzd()) {
                        ((zzfh.zzj.zza)((Object)object2)).zzi(zze3.zzd());
                    }
                    if (zze3.zzd() <= ((zzfh.zzj.zza)((Object)object2)).zzc()) continue;
                    ((zzfh.zzj.zza)((Object)object2)).zze(zze3.zzd());
                }
                zza4.zzq();
                if (zzsg.zzb() && this.zze().zze(zza2.zza.zzx(), zzbi.zzcf)) {
                    this.zzq();
                    if (zzne.zzd((String)zza2.zza.zzx()) && this.zzb(zza2.zza.zzx()).zzg() && zza2.zza.zzar()) {
                        void var16_61;
                        boolean bl7 = false;
                        while (var16_61 < zza2.zzc.size()) {
                            zzfh.zze.zza zza8 = (zzfh.zze.zza)zza2.zzc.get((int)var16_61).zzby();
                            bl = false;
                            for (zzfh.zzg zzg5 : zza8.zzf()) {
                                if (!"_c".equals(zzg5.zzg())) continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                if (zza2.zza.zza() >= this.zze().zzb(zza2.zza.zzx(), zzbi.zzau)) {
                                    zzfh.zzg zzg5;
                                    Object object5 = null;
                                    if (this.zze().zze(zza2.zza.zzx(), zzbi.zzch)) {
                                        object5 = this.zzq().zzp();
                                        zzg5 = (zzfh.zzg)((zzlw)zzfh.zzg.zze().zza("_tu").zzb((String)object5).zzab());
                                        zza8.zza(zzg5);
                                    }
                                    zzg5 = (zzfh.zzg)((zzlw)zzfh.zzg.zze().zza("_tr").zza(1L).zzab());
                                    zza8.zza(zzg5);
                                    zzg2 = this.zzp().zza(zza2.zza.zzx(), zza2.zza, zza8, (String)object5);
                                    if (zzg2 != null) {
                                        this.zzj().zzp().zza("Generated trigger URI. appId, uri", (Object)zza2.zza.zzx(), (Object)((zzmi)zzg2).zza);
                                        this.zzf().zza(zza2.zza.zzx(), (zzmi)zzg2);
                                        this.zzr.add(zza2.zza.zzx());
                                    }
                                }
                                zza4.zza((int)var16_61, (zzfh.zze)((zzlw)zza8.zzab()));
                            }
                            ++var16_61;
                        }
                    }
                }
                zza4.zzf().zza(this.zzc().zza(zza4.zzr(), zza4.zzw(), zza4.zzx(), zza4.zzd(), zza4.zzc()));
                if (this.zze().zzl(zza2.zza.zzx())) {
                    zza zza11 = zza2;
                    object3 = zza4;
                    object2 = this;
                    HashMap<Object, String> hashMap = new HashMap<Object, String>();
                    ArrayList<zzfh.zze> arrayList = new ArrayList<zzfh.zze>();
                    SecureRandom secureRandom = ((zzmq)object2).zzq().zzv();
                    for (int i = 0; i < ((zzfh.zzj.zza)((Object)object3)).zza(); ++i) {
                        boolean bl8;
                        int n12;
                        long l7;
                        long l8;
                        zzfh.zze.zza zza12;
                        block152: {
                            zza12 = (zzfh.zze.zza)((zzfh.zzj.zza)((Object)object3)).zza(i).zzby();
                            if (zza12.zze().equals("_ep")) {
                                ((zzmq)object2).zzp();
                                object = (String)zzna.zzb((zzfh.zze)((zzlw)zza12.zzab()), "_en");
                                string2 = (zzbc)hashMap.get(object);
                                if (string2 == null && (string2 = ((zzmq)object2).zzf().zzd(zza11.zza.zzx(), (String)Preconditions.checkNotNull((Object)object))) != null) {
                                    hashMap.put(object, string2);
                                }
                                if (string2 != null && ((zzbc)string2).zzi == null) {
                                    if (((zzbc)string2).zzj != null && ((zzbc)string2).zzj > 1L) {
                                        ((zzmq)object2).zzp();
                                        zzna.zza(zza12, "_sr", ((zzbc)string2).zzj);
                                    }
                                    if (((zzbc)string2).zzk != null && ((zzbc)string2).zzk.booleanValue()) {
                                        ((zzmq)object2).zzp();
                                        zzna.zza(zza12, "_efs", 1L);
                                    }
                                    arrayList.add((zzfh.zze)((zzlw)zza12.zzab()));
                                }
                                ((zzfh.zzj.zza)((Object)object3)).zza(i, zza12);
                                continue;
                            }
                            l8 = ((zzmq)object2).zzi().zza(zza11.zza.zzx());
                            ((zzmq)object2).zzq();
                            l7 = zzne.zza((long)zza12.zzc(), (long)l8);
                            n12 = 1;
                            Long l3 = 1L;
                            string3 = "_dbg";
                            zzfh.zze zze4 = (zzfh.zze)((zzlw)zza12.zzab());
                            if (TextUtils.isEmpty((CharSequence)string3) || l3 == null) {
                                bl8 = false;
                            } else {
                                for (zzfh.zzg zzg6 : zze4.zzh()) {
                                    if (!string3.equals(zzg6.zzg())) continue;
                                    bl8 = l3 instanceof Long && ((Object)l3).equals(zzg6.zzd()) || l3 instanceof String && ((Object)l3).equals(zzg6.zzh()) || l3 instanceof Double && ((Object)l3).equals(zzg6.zza());
                                    break block152;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n12 = ((zzmq)object2).zzi().zzb(zza11.zza.zzx(), zza12.zze());
                        }
                        if (n12 <= 0) {
                            ((zzmq)object2).zzj().zzu().zza("Sample rate must be positive. event, rate", (Object)zza12.zze(), (Object)n12);
                            arrayList.add((zzfh.zze)((zzlw)zza12.zzab()));
                            ((zzfh.zzj.zza)((Object)object3)).zza(i, zza12);
                            continue;
                        }
                        stringArray = (String[])hashMap.get(zza12.zze());
                        if (stringArray == null && (stringArray = ((zzmq)object2).zzf().zzd(zza11.zza.zzx(), zza12.zze())) == null) {
                            ((zzmq)object2).zzj().zzu().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)zza11.zza.zzx(), (Object)zza12.zze());
                            stringArray = new zzbc(zza11.zza.zzx(), zza12.zze(), 1L, 1L, 1L, zza12.zzc(), 0L, null, null, null, null);
                        }
                        ((zzmq)object2).zzp();
                        Long l10 = (Long)zzna.zzb((zzfh.zze)((zzlw)zza12.zzab()), "_eid");
                        Boolean bl9 = l10 != null;
                        if (n12 == 1) {
                            arrayList.add((zzfh.zze)((zzlw)zza12.zzab()));
                            if (bl9.booleanValue() && (stringArray.zzi != null || stringArray.zzj != null || stringArray.zzk != null)) {
                                stringArray = stringArray.zza(null, null, null);
                                hashMap.put(zza12.zze(), (String)stringArray);
                            }
                            ((zzfh.zzj.zza)((Object)object3)).zza(i, zza12);
                            continue;
                        }
                        if (secureRandom.nextInt(n12) == 0) {
                            ((zzmq)object2).zzp();
                            zzna.zza(zza12, "_sr", n12);
                            arrayList.add((zzfh.zze)((zzlw)zza12.zzab()));
                            if (bl9.booleanValue()) {
                                stringArray = stringArray.zza(null, Long.valueOf(n12), null);
                            }
                            hashMap.put(zza12.zze(), (String)stringArray.zza(zza12.zzc(), l7));
                        } else {
                            long l11;
                            if (stringArray.zzh != null) {
                                l11 = stringArray.zzh;
                            } else {
                                ((zzmq)object2).zzq();
                                l11 = zzne.zza((long)zza12.zzb(), (long)l8);
                            }
                            if (l11 != l7) {
                                ((zzmq)object2).zzp();
                                zzna.zza(zza12, "_efs", 1L);
                                ((zzmq)object2).zzp();
                                zzna.zza(zza12, "_sr", n12);
                                arrayList.add((zzfh.zze)((zzlw)zza12.zzab()));
                                if (bl9.booleanValue()) {
                                    stringArray = stringArray.zza(null, Long.valueOf(n12), Boolean.valueOf(true));
                                }
                                hashMap.put(zza12.zze(), (String)stringArray.zza(zza12.zzc(), l7));
                            } else if (bl9.booleanValue()) {
                                hashMap.put(zza12.zze(), (String)stringArray.zza(l10, null, null));
                            }
                        }
                        ((zzfh.zzj.zza)((Object)object3)).zza(i, zza12);
                    }
                    if (arrayList.size() < ((zzfh.zzj.zza)((Object)object3)).zza()) {
                        ((zzfh.zzj.zza)((Object)object3)).zzi().zzb(arrayList);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ((zzmq)object2).zzf().zza((zzbc)entry.getValue());
                    }
                }
                String string4 = zza2.zza.zzx();
                zzh zzh2 = this.zzf().zzd(string4);
                if (zzh2 == null) {
                    this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzfs.zza((String)zza2.zza.zzx()));
                } else if (zza4.zza() > 0) {
                    long l4 = zzh2.zzp();
                    if (l4 != 0L) {
                        zza4.zzg(l4);
                    } else {
                        zza4.zzm();
                    }
                    long l6 = zzh2.zzr();
                    if (l6 == 0L) {
                        l6 = l4;
                    }
                    if (l6 != 0L) {
                        zza4.zzh(l6);
                    } else {
                        zza4.zzn();
                    }
                    zzh2.zzai();
                    zza4.zzf((int)zzh2.zzq());
                    zzh2.zzp(zza4.zzd());
                    zzh2.zzn(zza4.zzc());
                    String string5 = zzh2.zzw();
                    if (string5 != null) {
                        zza4.zzn(string5);
                    } else {
                        zza4.zzj();
                    }
                    this.zzf().zza(zzh2);
                }
                if (zza4.zza() > 0) {
                    zzfa.zzd zzd2 = this.zzi().zzc(zza2.zza.zzx());
                    if (zzd2 == null || !zzd2.zzs()) {
                        if (zza2.zza.zzah().isEmpty()) {
                            zza4.zzb(-1L);
                        } else {
                            this.zzj().zzu().zza("Did not find measurement config or missing version info. appId", zzfs.zza((String)zza2.zza.zzx()));
                        }
                    } else {
                        zza4.zzb(zzd2.zzc());
                    }
                    this.zzf().zza((zzfh.zzj)((zzlw)zza4.zzab()), bl2);
                }
                object3 = zza2.zzb;
                object2 = this.zzf();
                Preconditions.checkNotNull((Object)object3);
                object2.zzt();
                ((zzml)((Object)object2)).zzak();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int i = 0; i < object3.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object3.get(i));
                }
                stringBuilder.append(")");
                int n13 = ((zzao)((Object)object2)).e_().delete("raw_events", stringBuilder.toString(), null);
                if (n13 != object3.size()) {
                    object2.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)n13, (Object)object3.size());
                }
                object3 = string4;
                object2 = this.zzf();
                stringBuilder = ((zzao)((Object)object2)).e_();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object3, object3});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzfs.zza((String)object3), (Object)sQLiteException);
                }
                this.zzf().zzw();
                return true;
            }
            this.zzf().zzw();
            return false;
        }
        finally {
            this.zzf().zzu();
        }
    }

    private final boolean zzac() {
        this.zzl().zzt();
        this.zzs();
        return this.zzf().zzx() || !TextUtils.isEmpty((CharSequence)this.zzf().f_());
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzad() {
        this.zzl().zzt();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzp().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzp().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzu().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzfh.zze.zza zza2, zzfh.zze.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzfh.zzg zzg2 = zzna.zza((zzfh.zze)((zzlw)zza2.zzab()), "_sc");
        String string = zzg2 == null ? null : zzg2.zzh();
        this.zzp();
        zzfh.zzg zzg3 = zzna.zza((zzfh.zze)((zzlw)zza3.zzab()), "_pc");
        String string2 = zzg3 == null ? null : zzg3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzfh.zze.zza zza4 = zza3;
            zzfh.zze.zza zza5 = zza2;
            zzmq zzmq2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zzmq2.zzp();
            zzfh.zzg zzg4 = zzna.zza((zzfh.zze)((zzlw)zza5.zzab()), "_et");
            if (zzg4 != null && zzg4.zzl() && zzg4.zzd() > 0L) {
                long l = zzg4.zzd();
                zzmq2.zzp();
                zzg4 = zzna.zza((zzfh.zze)((zzlw)zza4.zzab()), "_et");
                if (zzg4 != null && zzg4.zzd() > 0L) {
                    l += zzg4.zzd();
                }
                zzmq2.zzp();
                zzna.zza(zza4, "_et", l);
                zzmq2.zzp();
                zzna.zza(zza5, "_fr", 1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    private final class zzb {
        final String zza;
        long zzb;

        private zzb(zzmq zzmq2) {
            this(zzmq2, zzmq2.zzq().zzp());
        }

        /* synthetic */ zzb(zzmq zzmq2, zzmy zzmy2) {
            this(zzmq2);
        }

        private zzb(zzmq zzmq2, String string) {
            this.zza = string;
            this.zzb = zzmq2.zzb().elapsedRealtime();
        }

        /* synthetic */ zzb(zzmq zzmq2, String string, zzmy zzmy2) {
            this(zzmq2, string);
        }
    }

    private final class zza
    implements zzas {
        zzfh.zzj zza;
        List<Long> zzb;
        List<zzfh.zze> zzc;
        private long zzd;

        private static long zza(zzfh.zze zze2) {
            return zze2.zzd() / 1000L / 60L / 60L;
        }

        private zza() {
        }

        /* synthetic */ zza(zzmw zzmw2) {
            this();
        }

        @Override
        public final void zza(zzfh.zzj zzj2) {
            Preconditions.checkNotNull((Object)((Object)zzj2));
            this.zza = zzj2;
        }

        @Override
        public final boolean zza(long l, zzfh.zze zze2) {
            Preconditions.checkNotNull((Object)((Object)zze2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzfh.zze>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zzmq$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzmq$zza.zza(zze2)) {
                return false;
            }
            long l2 = this.zzd + (long)zze2.zzbw();
            zzmq.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbi.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zze2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zzmq.this.zze();
            return n < Math.max(1, (Integer)zzbi.zzj.zza(null));
        }
    }
}

