/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzix;
import com.google.android.gms.internal.measurement.zzkl;
import com.google.android.gms.internal.measurement.zznk;
import com.google.android.gms.internal.measurement.zznp;
import com.google.android.gms.internal.measurement.zznq;
import com.google.android.gms.internal.measurement.zzpg;
import com.google.android.gms.internal.measurement.zzps;
import com.google.android.gms.internal.measurement.zzqd;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zzmo;
import com.google.android.gms.measurement.internal.zzmp;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zznc;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zzne;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

final class zzao
extends zzmo {
    private static final String[] zza = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;", "current_session_count", "ALTER TABLE events ADD COLUMN current_session_count INTEGER;"};
    private static final String[] zzb = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzc = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;", "dynamite_version", "ALTER TABLE apps ADD COLUMN dynamite_version INTEGER;", "safelisted_events", "ALTER TABLE apps ADD COLUMN safelisted_events TEXT;", "ga_app_id", "ALTER TABLE apps ADD COLUMN ga_app_id TEXT;", "config_last_modified_time", "ALTER TABLE apps ADD COLUMN config_last_modified_time TEXT;", "e_tag", "ALTER TABLE apps ADD COLUMN e_tag TEXT;", "session_stitching_token", "ALTER TABLE apps ADD COLUMN session_stitching_token TEXT;", "sgtm_upload_enabled", "ALTER TABLE apps ADD COLUMN sgtm_upload_enabled INTEGER;", "target_os_version", "ALTER TABLE apps ADD COLUMN target_os_version INTEGER;", "session_stitching_token_hash", "ALTER TABLE apps ADD COLUMN session_stitching_token_hash INTEGER;", "ad_services_version", "ALTER TABLE apps ADD COLUMN ad_services_version INTEGER;", "unmatched_first_open_without_ad_id", "ALTER TABLE apps ADD COLUMN unmatched_first_open_without_ad_id INTEGER;", "npa_metadata_value", "ALTER TABLE apps ADD COLUMN npa_metadata_value INTEGER;", "attribution_eligibility_status", "ALTER TABLE apps ADD COLUMN attribution_eligibility_status INTEGER;"};
    private static final String[] zzd = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zze = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzg = new String[]{"session_scoped", "ALTER TABLE event_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzh = new String[]{"session_scoped", "ALTER TABLE property_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzi = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private static final String[] zzj = new String[]{"consent_source", "ALTER TABLE consent_settings ADD COLUMN consent_source INTEGER;", "dma_consent_settings", "ALTER TABLE consent_settings ADD COLUMN dma_consent_settings TEXT;"};
    private static final String[] zzk = new String[]{"idempotent", "CREATE INDEX IF NOT EXISTS trigger_uris_index ON trigger_uris (app_id);"};
    private final zzau zzl;
    private final zzmi zzm = new zzmi(this.zzb());

    @WorkerThread
    public final int zza(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzak();
        try {
            return this.e_().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting conditional property", zzfr.zza((String)string), (Object)this.zzi().zzc(string2), (Object)sQLiteException);
            return 0;
        }
    }

    public final long zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = this.e_();
            int n = this.zze().zzb(string, zzbi.zzp);
            n = Math.min(1000000, n);
            String string2 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting over the limit events. appId", zzfr.zza((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    public final long b_() {
        try (Cursor cursor = null;){
            cursor = this.e_().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final long zza(zzfi.zzj zzj2) throws IOException {
        this.zzt();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zzj2));
        Preconditions.checkNotEmpty((String)zzj2.zzx());
        byte[] byArray = zzj2.zzbv();
        long l = this.g_().zza(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzj2.zzx());
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            this.e_().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing raw event metadata. appId", zzfr.zza((String)zzj2.zzx()), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzb(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzak();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.e_();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            String string3 = string2;
            l = this.zza("select " + string3 + " from app2 where app_id=?", new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzj().zzg().zza("Failed to insert column (got -1). appId", zzfr.zza((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzj().zzg().zza("Failed to update column (got 0). appId", zzfr.zza((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error inserting column. appId", zzfr.zza((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long c_() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public final long d_() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zzb(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    @WorkerThread
    private final long zzb(String string, String @Nullable [] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzj().zzg().zza("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String @Nullable [] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.e_();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase e_() {
        this.zzt();
        try {
            return this.zzl.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzu().zza("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public final @Nullable Bundle zzc(String string) {
        this.zzt();
        this.zzak();
        try (Cursor cursor = null;){
            zzfi.zze zze2;
            cursor = this.e_().rawQuery("select parameters from default_event_params where app_id=?", new String[]{string});
            if (!cursor.moveToFirst()) {
                this.zzj().zzp().zza("Default event parameters not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            try {
                zze2 = (zzfi.zze)((zzix)zzmz.zza(zzfi.zze.zze(), byArray).zzab());
            }
            catch (IOException iOException) {
                this.zzj().zzg().zza("Failed to retrieve default event parameters. appId", zzfr.zza((String)string), (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            this.g_();
            List<zzfi.zzg> list = zze2.zzh();
            Bundle bundle = new Bundle();
            for (zzfi.zzg zzg2 : list) {
                String string2 = zzg2.zzg();
                if (zzg2.zzj()) {
                    bundle.putDouble(string2, zzg2.zza());
                    continue;
                }
                if (zzg2.zzk()) {
                    bundle.putFloat(string2, zzg2.zzb());
                    continue;
                }
                if (zzg2.zzn()) {
                    bundle.putString(string2, zzg2.zzh());
                    continue;
                }
                if (!zzg2.zzl()) continue;
                bundle.putLong(string2, zzg2.zzd());
            }
            Bundle bundle2 = bundle;
            return bundle2;
        }
        return null;
    }

    public final @Nullable Pair<zzfi.zze, Long> zza(String string, Long l) {
        this.zzt();
        this.zzak();
        try (Cursor cursor = null;){
            zzfi.zze zze2;
            cursor = this.e_().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzj().zzp().zza("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            try {
                zze2 = (zzfi.zze)((zzix)zzmz.zza(zzfi.zze.zze(), byArray).zzab());
            }
            catch (IOException iOException) {
                this.zzj().zzg().zza("Failed to merge main event. appId, eventId", zzfr.zza((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zze2), (Object)l2);
            return pair;
        }
        return null;
    }

    @WorkerThread
    public final @Nullable zzh zzd(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.e_().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "admob_app_id", "dynamite_version", "safelisted_events", "ga_app_id", "session_stitching_token", "sgtm_upload_enabled", "target_os_version", "session_stitching_token_hash", "ad_services_version", "unmatched_first_open_without_ad_id", "npa_metadata_value", "attribution_eligibility_status"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzh zzh2 = new zzh(this.zzf.zzk(), string);
            zzh2.zzb(cursor.getString(0));
            zzh2.zzf(cursor.getString(1));
            zzh2.zzh(cursor.getString(2));
            zzh2.zzo(cursor.getLong(3));
            zzh2.zzp(cursor.getLong(4));
            zzh2.zzn(cursor.getLong(5));
            zzh2.zzd(cursor.getString(6));
            zzh2.zzc(cursor.getString(7));
            zzh2.zzm(cursor.getLong(8));
            zzh2.zzj(cursor.getLong(9));
            zzh2.zzb(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzh2.zzi(cursor.getLong(11));
            zzh2.zzg(cursor.getLong(12));
            zzh2.zzf(cursor.getLong(13));
            zzh2.zzd(cursor.getLong(14));
            zzh2.zzc(cursor.getLong(15));
            zzh2.zzl(cursor.getLong(16));
            zzh2.zza(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzh2.zze(cursor.getString(18));
            zzh2.zze(cursor.getLong(19));
            zzh2.zzh(cursor.getLong(20));
            zzh2.zzg(cursor.getString(21));
            zzh2.zza(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzh2.zza(cursor.getString(24));
            zzh2.zzk(cursor.isNull(25) ? 0L : cursor.getLong(25));
            if (!cursor.isNull(26)) {
                zzh2.zza(Arrays.asList(cursor.getString(26).split(",", -1)));
            }
            if (zzps.zza() && (this.zze().zze(string, zzbi.zzbt) || this.zze().zza(zzbi.zzbr))) {
                zzh2.zzi(cursor.getString(28));
            }
            if (zzqd.zza() && this.zze().zza(zzbi.zzbu)) {
                zzh2.zzc(!cursor.isNull(29) && cursor.getInt(29) != 0);
            }
            zzh2.zzr(cursor.getLong(30));
            zzh2.zzq(cursor.getLong(31));
            if (zzpg.zza() && this.zze().zze(string, zzbi.zzcf)) {
                zzh2.zza(cursor.getInt(32));
                zzh2.zzb(cursor.getLong(35));
            }
            if (zznk.zza() && this.zze().zze(string, zzbi.zzcr)) {
                zzh2.zzd(!cursor.isNull(33) && cursor.getInt(33) != 0);
            }
            if (zznp.zza() && this.zze().zze(string, zzbi.zzcm)) {
                zzh2.zza(cursor.isNull(34) ? null : Boolean.valueOf(cursor.getInt(34) != 0));
            }
            zzh2.zzah();
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for app, expected one. appId", zzfr.zza((String)string));
            }
            zzh zzh3 = zzh2;
            return zzh3;
        }
    }

    @WorkerThread
    public final @Nullable zzad zzc(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.e_().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            if (string3 == null) {
                string3 = "";
            }
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzbg zzbg2 = (zzbg)this.g_().zza(cursor.getBlob(5), zzbg.CREATOR);
            long l2 = cursor.getLong(6);
            zzbg zzbg3 = (zzbg)this.g_().zza(cursor.getBlob(7), zzbg.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzbg zzbg4 = (zzbg)this.g_().zza(cursor.getBlob(10), zzbg.CREATOR);
            zznc zznc2 = new zznc(string2, l3, object, string3);
            zzad zzad2 = new zzad(string, string3, zznc2, l2, bl, string4, zzbg2, l, zzbg3, l4, zzbg4);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for conditional property, expected one", zzfr.zza((String)string), (Object)this.zzi().zzc(string2));
            }
            zzad zzad3 = zzad2;
            return zzad3;
        }
    }

    @WorkerThread
    public final @Nullable zzaq zze(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.e_().query("apps", new String[]{"remote_config", "config_last_modified_time", "e_tag"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            String string2 = cursor.getString(1);
            String string3 = cursor.getString(2);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for app config, expected one. appId", zzfr.zza((String)string));
            }
            if (byArray == null) {
                return null;
            }
            zzaq zzaq2 = new zzaq(byArray, string2, string3);
            return zzaq2;
        }
    }

    @WorkerThread
    public final zzap zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return this.zza(l, string, 1L, false, false, bl3, false, bl5);
    }

    @WorkerThread
    public final zzap zza(long l, String string, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzak();
        String[] stringArray = new String[]{string};
        zzap zzap2 = new zzap();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.e_();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzj().zzu().zza("Not updating daily counts, app is not known. appId", zzfr.zza((String)string));
                zzap zzap3 = zzap2;
                return zzap3;
            }
            if (cursor.getLong(0) == l) {
                zzap2.zzb = cursor.getLong(1);
                zzap2.zza = cursor.getLong(2);
                zzap2.zzc = cursor.getLong(3);
                zzap2.zzd = cursor.getLong(4);
                zzap2.zze = cursor.getLong(5);
            }
            if (bl) {
                zzap2.zzb += l2;
            }
            if (bl2) {
                zzap2.zza += l2;
            }
            if (bl3) {
                zzap2.zzc += l2;
            }
            if (bl4) {
                zzap2.zzd += l2;
            }
            if (bl5) {
                zzap2.zze += l2;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzap2.zza));
            contentValues.put("daily_events_count", Long.valueOf(zzap2.zzb));
            contentValues.put("daily_conversions_count", Long.valueOf(zzap2.zzc));
            contentValues.put("daily_error_events_count", Long.valueOf(zzap2.zzd));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzap2.zze));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzap zzap4 = zzap2;
            return zzap4;
        }
    }

    public final zzay zzf(String string) {
        if (!zznp.zza() || !this.zze().zza(zzbi.zzcm)) {
            return zzay.zza;
        }
        Preconditions.checkNotNull((Object)string);
        this.zzt();
        this.zzak();
        return zzay.zza((String)this.zza("select dma_consent_settings from consent_settings where app_id=? limit 1;", new String[]{string}, ""));
    }

    @WorkerThread
    public final @Nullable zzbc zzd(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzak();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling", "current_session_count"));
        try (Cursor cursor = null;){
            cursor = this.e_().query("events", arrayList.toArray(new String[0]), "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl = null;
            if (!cursor.isNull(7)) {
                bl = cursor.getLong(7) == 1L;
            }
            long l8 = cursor.isNull(8) ? 0L : cursor.getLong(8);
            zzbc zzbc2 = new zzbc(string, string2, l, l2, l8, l3, l4, l5, l6, l7, bl);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for event aggregates, expected one. appId", zzfr.zza((String)string));
            }
            zzbc zzbc3 = zzbc2;
            return zzbc3;
        }
    }

    static /* synthetic */ zzih zza(Cursor cursor) {
        String string = cursor.getString(0);
        int n = cursor.getInt(1);
        return zzih.zza((String)string, (int)n);
    }

    public final zzih zzg(String string) {
        Preconditions.checkNotNull((Object)string);
        this.zzt();
        this.zzak();
        if (zznp.zza() && this.zze().zza(zzbi.zzcm)) {
            zzih zzih2 = (zzih)this.zza("select consent_state, consent_source from consent_settings where app_id=? limit 1;", new String[]{string}, zzan.zza);
            if (zzih2 == null) {
                return zzih.zza;
            }
            return zzih2;
        }
        return zzih.zza((String)this.zza("select consent_state from consent_settings where app_id=? limit 1;", new String[]{string}, "G1"));
    }

    static /* bridge */ /* synthetic */ zzmi zza(zzao zzao2) {
        return zzao2.zzm;
    }

    @WorkerThread
    public final @Nullable zzne zze(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.e_().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            if (object == null) {
                return null;
            }
            String string3 = cursor.getString(2);
            zzne zzne2 = new zzne(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for user property, expected one. appId", zzfr.zza((String)string));
            }
            zzne zzne3 = zzne2;
            return zzne3;
        }
    }

    @VisibleForTesting
    @WorkerThread
    private final @Nullable Object zza(Cursor cursor, int n) {
        int n2 = cursor.getType(n);
        switch (n2) {
            case 0: {
                this.zzj().zzg().zza("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzj().zzg().zza("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzj().zzg().zza("Loaded invalid unknown value type, ignoring it", (Object)n2);
        return null;
    }

    @WorkerThread
    private final <T> @Nullable T zza(String string, String[] stringArray, zzar<T> zzar2) {
        try (Cursor cursor = null;){
            cursor = this.e_().rawQuery(string, stringArray);
            if (!cursor.moveToFirst()) {
                this.zzj().zzp().zza("No data found");
                return null;
            }
            T t = zzar2.zza(cursor);
            return t;
        }
        return null;
    }

    public final @Nullable String zza(long l) {
        this.zzt();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.e_().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzj().zzp().zza("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final @Nullable String f_() {
        SQLiteDatabase sQLiteDatabase = this.e_();
        Cursor cursor = null;
        try {
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Database error getting next bundle app id", (Object)sQLiteException);
            return null;
        }
        if (cursor == null) return null;
        cursor.close();
        return null;
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @WorkerThread
    private final String zza(String string, String[] stringArray, String string2) {
        String string3;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.e_();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    String string4 = cursor.getString(0);
                    return string4;
                }
                string3 = string2;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return string3;
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    public final List<Pair<zzfi.zzj, Long>> zza(String var1_1, int var2_2, int var3_3) {
        this.zzt();
        this.zzak();
        Preconditions.checkArgument((boolean)(var2_2 > 0));
        Preconditions.checkArgument((boolean)(var3_3 > 0));
        Preconditions.checkNotEmpty((String)var1_1);
        var4_4 = null;
        try {
            var4_4 = this.e_().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{var1_1}, null, null, "rowid", String.valueOf(var2_2));
            if (!var4_4.moveToFirst()) {
                var6_5 = Collections.emptyList();
                return var6_5;
            }
            var6_6 = new ArrayList<Pair<zzfi.zzj, Long>>();
            var7_8 = 0;
            do {
                block18: {
                    var8_9 = var4_4.getLong(0);
                    try {
                        var11_12 = var4_4.getBlob(1);
                        var10_11 = this.g_().zzc((byte[])var11_12);
                    }
                    catch (IOException var11_13) {
                        this.zzj().zzg().zza("Failed to unzip queued bundle. appId", zzfr.zza((String)var1_1), (Object)var11_13);
                        continue;
                    }
                    if (!var6_6.isEmpty() && var7_8 + var10_11.length > var3_3) break;
                    try {
                        var11_12 = (Object)zzmz.zza(zzfi.zzj.zzu(), var10_11);
                    }
                    catch (IOException var12_14) {
                        this.zzj().zzg().zza("Failed to merge queued bundle. appId", zzfr.zza((String)var1_1), (Object)var12_14);
                        continue;
                    }
                    if (!zznp.zza() || !this.zze().zza(zzbi.zzcq) || var6_6.isEmpty()) break block18;
                    var15_16 = (zzfi.zzj)((zzix)var11_12.zzab());
                    var14_15 = (zzfi.zzj)((Pair)var6_6.get((int)0)).first;
                    if (!var14_15.zzac().equals(var15_16.zzac()) || !var14_15.zzab().equals(var15_16.zzab()) || var14_15.zzas() != var15_16.zzas() || !var14_15.zzad().equals(var15_16.zzad())) ** GOTO lbl-1000
                    var16_17 = -1L;
                    for (zzfi.zzn var19_20 : var14_15.zzaq()) {
                        if (!"_npa".equals(var19_20.zzg())) continue;
                        var16_17 = var19_20.zzc();
                        break;
                    }
                    var18_18 = -1L;
                    for (zzfi.zzn var21_22 : var15_16.zzaq()) {
                        if (!"_npa".equals(var21_22.zzg())) continue;
                        var18_18 = var21_22.zzc();
                        break;
                    }
                    if (var16_17 == var18_18) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) break;
                }
                if (!var4_4.isNull(2)) {
                    var11_12.zzh(var4_4.getInt(2));
                }
                var7_8 += var10_11.length;
                var6_6.add((Pair<zzfi.zzj, Long>)Pair.create((Object)((zzfi.zzj)((zzix)var11_12.zzab())), (Object)var8_9));
            } while (var4_4.moveToNext() && var7_8 <= var3_3);
            var8_10 = var6_6;
            return var8_10;
        }
        catch (SQLiteException var5_23) {
            this.zzj().zzg().zza("Error querying bundles. appId", zzfr.zza((String)var1_1), (Object)var5_23);
            var6_7 = Collections.emptyList();
            return var6_7;
        }
        finally {
            if (var4_4 != null) {
                var4_4.close();
            }
        }
    }

    @WorkerThread
    public final List<zzad> zza(String string, @Nullable String string2, @Nullable String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzak();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            String string4 = string3;
            arrayList.add(string4 + "*");
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zza(stringBuilder.toString(), stringArray);
    }

    public final List<zzad> zza(String string, String[] stringArray) {
        this.zzt();
        this.zzak();
        ArrayList<zzad> arrayList = new ArrayList<zzad>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.e_().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzad> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzj().zzg().zza("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzbg zzbg2 = (zzbg)this.g_().zza(cursor.getBlob(7), zzbg.CREATOR);
                long l2 = cursor.getLong(8);
                zzbg zzbg3 = (zzbg)this.g_().zza(cursor.getBlob(9), zzbg.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzbg zzbg4 = (zzbg)this.g_().zza(cursor.getBlob(12), zzbg.CREATOR);
                zznc zznc2 = new zznc(string3, l3, object2, string2);
                zzad zzad2 = new zzad((String)object, string2, zznc2, l2, bl, string4, zzbg2, l, zzbg3, l4, zzbg4);
                arrayList.add(zzad2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    public final List<zzmh> zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzak();
        ArrayList<zzmh> arrayList = new ArrayList<zzmh>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.e_().query("trigger_uris", new String[]{"trigger_uri", "timestamp_millis", "source"}, "app_id=?", new String[]{string}, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                ArrayList<zzmh> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if ((object = cursor.getString(0)) == null) {
                    object = "";
                }
                long l = cursor.getLong(1);
                int n = cursor.getInt(2);
                zzmh zzmh2 = new zzmh((String)object, l, n);
                arrayList.add(zzmh2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzne> zzi(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzak();
        ArrayList<zzne> arrayList = new ArrayList<zzne>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.e_().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzne> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzj().zzg().zza("Read invalid user property value, ignoring it. appId", zzfr.zza((String)string));
                    continue;
                }
                zzne zzne2 = new zzne(string, string2, (String)object, l, object2);
                arrayList.add(zzne2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzne> zzb(String string, @Nullable String string2, @Nullable String string3) {
        Object object;
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzak();
        ArrayList<zzne> arrayList = new ArrayList<zzne>();
        try (Cursor cursor = null;){
            Object object2;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            object = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                ((StringBuilder)object).append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                String string4 = string3;
                arrayList2.add(string4 + "*");
                ((StringBuilder)object).append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.e_().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, ((StringBuilder)object).toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzne> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzj().zzg().zza("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object2 = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object3 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object3 == null) {
                    this.zzj().zzg().zza("(2)Read invalid user property value, ignoring it", zzfr.zza((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzne zzne2 = new zzne(string, string2, (String)object2, l, object3);
                arrayList.add(zzne2);
            } while (cursor.moveToNext());
            object2 = arrayList;
            return object2;
        }
    }

    final Map<Integer, zzfi.zzl> zzj(String string) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, zzfi.zzl> map = Collections.emptyMap();
                return map;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                zzfi.zzl zzl2;
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzl2 = (zzfi.zzl)((zzix)zzmz.zza(zzfi.zzl.zze(), byArray).zzab());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter results. appId, audienceId, error", zzfr.zza((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzl2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    final Map<Integer, List<zzew.zzb>> zzk(String string) {
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzew.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzew.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzew.zzb)((zzix)zzmz.zza(zzew.zzb.zzc(), byArray).zzab());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter. appId", zzfr.zza((String)string), (Object)iOException);
                    continue;
                }
                if (!zzb2.zzk()) continue;
                int n = cursor.getInt(0);
                ArrayList<zzew.zzb> arrayList = (ArrayList<zzew.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzew.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzew.zzb>> zzf(String string, String string2) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzew.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzew.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzew.zzb)((zzix)zzmz.zza(zzew.zzb.zzc(), byArray).zzab());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter. appId", zzfr.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzew.zzb> arrayList = (ArrayList<zzew.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzew.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzew.zze>> zzg(String string, String string2) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzew.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzew.zze zze2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zze2 = (zzew.zze)((zzix)zzmz.zza(zzew.zze.zzc(), byArray).zzab());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter", zzfr.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzew.zze> arrayList = (ArrayList<zzew.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzew.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<Integer>> zzl(String string) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("select audience_id, filter_id from event_filters where app_id = ? and session_scoped = 1 UNION select audience_id, filter_id from property_filters where app_id = ? and session_scoped = 1;", new String[]{string, string});
            if (!cursor.moveToFirst()) {
                Map<Integer, List<Integer>> map = Collections.emptyMap();
                return map;
            }
            do {
                int n;
                ArrayList<Integer> arrayList;
                if ((arrayList = (ArrayList<Integer>)arrayMap.get(n = cursor.getInt(0))) == null) {
                    arrayList = new ArrayList<Integer>();
                    arrayMap.put(n, arrayList);
                }
                int n2 = cursor.getInt(1);
                arrayList.add(n2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    zzao(zzmp zzmp2) {
        super(zzmp2);
        String string = "google_app_measurement.db";
        this.zzl = new zzau(this, this.zza(), string);
    }

    @WorkerThread
    public final void zzp() {
        this.zzak();
        this.e_().beginTransaction();
    }

    @WorkerThread
    public final void zzu() {
        this.zzak();
        this.e_().endTransaction();
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(List<Long> list) {
        this.zzt();
        this.zzak();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzan()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = "(" + string + ")";
        if (this.zzb("SELECT COUNT(1) FROM queue WHERE rowid IN " + (string = string2) + " AND retry_count =  2147483647 LIMIT 1", (String[])null) > 0L) {
            this.zzj().zzu().zza("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            string = string2;
            this.e_().execSQL("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN " + string + " AND (retry_count IS NULL OR retry_count < 2147483647)");
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zzv() {
        this.zzt();
        this.zzak();
        if (!this.zzan()) {
            return;
        }
        long l = this.zzn().zza.zza();
        long l2 = this.zzb().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzbi.zzy.zza(null)) {
            this.zzn().zza.zza(l2);
            zzao zzao2 = this;
            zzao2.zzt();
            zzao2.zzak();
            if (zzao2.zzan()) {
                SQLiteDatabase sQLiteDatabase = zzao2.e_();
                String[] stringArray = new String[]{String.valueOf(zzao2.zzb().currentTimeMillis()), String.valueOf(zzaf.zzm())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzao2.zzj().zzp().zza("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @WorkerThread
    public final void zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzak();
        try {
            this.e_().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting user property. appId", zzfr.zza((String)string), (Object)this.zzi().zzc(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    final void zza(String string, List<zzew.zza> list) {
        Preconditions.checkNotNull(list);
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            zzkl zzkl2;
            int n;
            zzew.zza.zza zza2 = (zzew.zza.zza)list.get(i).zzby();
            if (zza2.zza() != 0) {
                for (n = 0; n < zza2.zza(); ++n) {
                    zzkl2 = (zzew.zzb.zza)zza2.zza(n).zzby();
                    object = (zzew.zzb.zza)((zzix.zzb)zzkl2.clone());
                    boolean bl = false;
                    String string2 = zzii.zzb((String)zzkl2.zzb());
                    if (string2 != null) {
                        ((zzew.zzb.zza)((Object)object)).zza(string2);
                        bl = true;
                    }
                    for (int j = 0; j < zzkl2.zza(); ++j) {
                        zzew.zzc zzc2 = zzkl2.zza(j);
                        String string3 = zzik.zza((String)zzc2.zze());
                        if (string3 == null) continue;
                        zzew.zzc zzc3 = (zzew.zzc)((zzix)((zzew.zzc.zza)zzc2.zzby()).zza(string3).zzab());
                        ((zzew.zzb.zza)((Object)object)).zza(j, zzc3);
                        bl = true;
                    }
                    if (!bl) continue;
                    zza2 = zza2.zza(n, (zzew.zzb.zza)((Object)object));
                    list.set(i, (zzew.zza)((zzix)zza2.zzab()));
                }
            }
            if (zza2.zzb() == 0) continue;
            for (n = 0; n < zza2.zzb(); ++n) {
                zzkl2 = zza2.zzb(n);
                object = zzij.zza((String)zzkl2.zze());
                if (object == null) continue;
                zza2 = zza2.zza(n, ((zzew.zze.zza)zzkl2.zzby()).zza((String)object));
                list.set(i, (zzew.zza)((zzix)zza2.zzab()));
            }
        }
        List<zzew.zza> list2 = list;
        String string4 = string;
        zzao zzao2 = this;
        zzao2.zzak();
        zzao2.zzt();
        Preconditions.checkNotEmpty((String)string4);
        Preconditions.checkNotNull(list2);
        SQLiteDatabase sQLiteDatabase = zzao2.e_();
        sQLiteDatabase.beginTransaction();
        try {
            String string5 = string4;
            zzao zzao3 = zzao2;
            zzao3.zzak();
            zzao3.zzt();
            Preconditions.checkNotEmpty((String)string5);
            Object object = zzao3.e_();
            object.delete("property_filters", "app_id=?", new String[]{string5});
            object.delete("event_filters", "app_id=?", new String[]{string5});
            Object object2 = list2.iterator();
            block7: while (object2.hasNext()) {
                Object object3;
                object = object3 = object2.next();
                string5 = string4;
                zzao3 = zzao2;
                zzao3.zzak();
                zzao3.zzt();
                Preconditions.checkNotEmpty((String)string5);
                Preconditions.checkNotNull((Object)object);
                if (!((zzew.zza)((Object)object)).zzg()) {
                    zzao3.zzj().zzu().zza("Audience with no ID. appId", zzfr.zza((String)string5));
                    continue;
                }
                int n = ((zzew.zza)((Object)object)).zza();
                Iterator<zzix> iterator = ((zzew.zza)((Object)object)).zze().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().zzl()) continue;
                    zzao3.zzj().zzu().zza("Event filter with no ID. Audience definition ignored. appId, audienceId", zzfr.zza((String)string5), (Object)n);
                    continue block7;
                }
                iterator = ((zzew.zza)((Object)object)).zzf().iterator();
                while (iterator.hasNext()) {
                    if (((zzew.zze)iterator.next()).zzi()) continue;
                    zzao3.zzj().zzu().zza("Property filter with no ID. Audience definition ignored. appId, audienceId", zzfr.zza((String)string5), (Object)n);
                    continue block7;
                }
                boolean bl = true;
                for (zzew.zzb zzb2 : ((zzew.zza)((Object)object)).zze()) {
                    if (zzao3.zza(string5, n, zzb2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (zzew.zze zze2 : ((zzew.zza)((Object)object)).zzf()) {
                        if (zzao3.zza(string5, n, zze2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n2 = n;
                String string2 = string5;
                zzao zzao4 = zzao3;
                zzao4.zzak();
                zzao4.zzt();
                Preconditions.checkNotEmpty((String)string2);
                SQLiteDatabase sQLiteDatabase2 = zzao4.e_();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n2)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n2)});
            }
            object2 = new ArrayList();
            for (zzew.zza zza2 : list2) {
                object2.add(zza2.zzg() ? Integer.valueOf(zza2.zza()) : null);
            }
            zzao2.zzb(string4, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    public final void zzw() {
        this.zzak();
        this.e_().setTransactionSuccessful();
    }

    @WorkerThread
    public final void zza(zzh zzh2) {
        List<String> list;
        Preconditions.checkNotNull((Object)zzh2);
        this.zzt();
        this.zzak();
        String string = zzh2.zzx();
        Preconditions.checkNotNull((Object)string);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("app_instance_id", zzh2.zzy());
        contentValues.put("gmp_app_id", zzh2.zzac());
        contentValues.put("resettable_device_id_hash", zzh2.zzae());
        contentValues.put("last_bundle_index", Long.valueOf(zzh2.zzq()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzh2.zzr()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzh2.zzp()));
        contentValues.put("app_version", zzh2.zzaa());
        contentValues.put("app_store", zzh2.zzz());
        contentValues.put("gmp_version", Long.valueOf(zzh2.zzo()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzh2.zzl()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzh2.zzak()));
        contentValues.put("day", Long.valueOf(zzh2.zzk()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzh2.zzi()));
        contentValues.put("daily_events_count", Long.valueOf(zzh2.zzh()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzh2.zzf()));
        contentValues.put("config_fetched_time", Long.valueOf(zzh2.zze()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzh2.zzn()));
        contentValues.put("app_version_int", Long.valueOf(zzh2.zzc()));
        contentValues.put("firebase_instance_id", zzh2.zzab());
        contentValues.put("daily_error_events_count", Long.valueOf(zzh2.zzg()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzh2.zzj()));
        contentValues.put("health_monitor_sample", zzh2.zzad());
        contentValues.put("android_id", Long.valueOf(zzh2.zzb()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzh2.zzaj()));
        contentValues.put("admob_app_id", zzh2.zzv());
        contentValues.put("dynamite_version", Long.valueOf(zzh2.zzm()));
        contentValues.put("session_stitching_token", zzh2.zzaf());
        contentValues.put("sgtm_upload_enabled", Boolean.valueOf(zzh2.zzam()));
        contentValues.put("target_os_version", Long.valueOf(zzh2.zzt()));
        contentValues.put("session_stitching_token_hash", Long.valueOf(zzh2.zzs()));
        if (zzpg.zza() && this.zze().zze(string, zzbi.zzcf)) {
            contentValues.put("ad_services_version", Integer.valueOf(zzh2.zza()));
            contentValues.put("attribution_eligibility_status", Long.valueOf(zzh2.zzd()));
        }
        if (zznk.zza() && this.zze().zze(string, zzbi.zzcr)) {
            contentValues.put("unmatched_first_open_without_ad_id", Boolean.valueOf(zzh2.zzan()));
        }
        if ((list = zzh2.zzag()) != null) {
            if (list.isEmpty()) {
                this.zzj().zzu().zza("Safelisted events should not be an empty list. appId", (Object)string);
            } else {
                contentValues.put("safelisted_events", TextUtils.join((CharSequence)",", list));
            }
        }
        if (zznq.zza() && this.zze().zza(zzbi.zzbp) && !contentValues.containsKey("safelisted_events")) {
            contentValues.put("safelisted_events", null);
        }
        if (zznp.zza() && this.zze().zze(string, zzbi.zzcm)) {
            contentValues.put("npa_metadata_value", zzh2.zzu());
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.e_();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update app (got -1). appId", zzfr.zza((String)string));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing app. appId", zzfr.zza((String)string), (Object)sQLiteException);
            return;
        }
    }

    public final void zza(String string, zzih zzih2) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)zzih2);
        this.zzt();
        this.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("consent_state", zzih2.zze());
        if (zznp.zza() && this.zze().zza(zzbi.zzcm)) {
            contentValues.put("consent_source", Integer.valueOf(zzih2.zza()));
            this.zza("consent_settings", "app_id", contentValues);
            return;
        }
        try {
            if (this.e_().insertWithOnConflict("consent_settings", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update consent setting (got -1). appId", zzfr.zza((String)string));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing consent setting. appId, error", zzfr.zza((String)string), (Object)sQLiteException);
            return;
        }
    }

    public final void zza(String string, zzay zzay2) {
        if (!zznp.zza() || !this.zze().zza(zzbi.zzcm)) {
            return;
        }
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)zzay2);
        this.zzt();
        this.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("dma_consent_settings", zzay2.zzf());
        this.zza("consent_settings", "app_id", contentValues);
    }

    @WorkerThread
    public final void zza(zzbc zzbc2) {
        Preconditions.checkNotNull((Object)zzbc2);
        this.zzt();
        this.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzbc2.zza);
        contentValues.put("name", zzbc2.zzb);
        contentValues.put("lifetime_count", Long.valueOf(zzbc2.zzc));
        contentValues.put("current_bundle_count", Long.valueOf(zzbc2.zzd));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzbc2.zzf));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzbc2.zzg));
        contentValues.put("last_bundled_day", zzbc2.zzh);
        contentValues.put("last_sampled_complex_event_id", zzbc2.zzi);
        contentValues.put("last_sampling_rate", zzbc2.zzj);
        contentValues.put("current_session_count", Long.valueOf(zzbc2.zze));
        Long l = null;
        if (zzbc2.zzk != null && zzbc2.zzk.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.e_().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update event aggregates (got -1). appId", zzfr.zza((String)zzbc2.zza));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing event aggregates. appId", zzfr.zza((String)zzbc2.zza), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    private final void zza(String string, String string2, ContentValues contentValues) {
        try {
            SQLiteDatabase sQLiteDatabase = this.e_();
            String string3 = contentValues.getAsString(string2);
            if (string3 == null) {
                this.zzj().zzh().zza("Value of the primary key is not set.", zzfr.zza((String)string2));
                return;
            }
            String string4 = string2;
            if ((long)sQLiteDatabase.update(string, contentValues, string4 + " = ?", new String[]{string3}) == 0L && sQLiteDatabase.insertWithOnConflict(string, null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update table (got -1). key", zzfr.zza((String)string), zzfr.zza((String)string2));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing into table. key", zzfr.zza((String)string), zzfr.zza((String)string2), (Object)sQLiteException);
            return;
        }
    }

    private final boolean zzb(String string, List<@Nullable Integer> list) {
        String string2;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzak();
        this.zzt();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Database error querying filters. appId", zzfr.zza((String)string), (Object)sQLiteException);
            return false;
        }
        int n = this.zze().zzb(string, zzbi.zzaf);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Integer n3 = list.get(i);
            if (n3 == null) {
                return false;
            }
            arrayList.add(Integer.toString(n3));
        }
        String string3 = TextUtils.join((CharSequence)",", arrayList);
        string3 = string2 = "(" + string3 + ")";
        return sQLiteDatabase.delete("audience_filter_values", "audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in " + string3 + " order by rowid desc limit -1 offset ?)", new String[]{string, Integer.toString(n2)}) > 0;
    }

    public final boolean zzx() {
        return this.zzb("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzy() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    public final boolean zzz() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final boolean zza(zzfi.zzj zzj2, boolean bl) {
        this.zzt();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zzj2));
        Preconditions.checkNotEmpty((String)zzj2.zzx());
        Preconditions.checkState((boolean)zzj2.zzbe());
        this.zzv();
        long l = this.zzb().currentTimeMillis();
        if (zzj2.zzl() < l - zzaf.zzm() || zzj2.zzl() > l + zzaf.zzm()) {
            this.zzj().zzu().zza("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzfr.zza((String)zzj2.zzx()), (Object)l, (Object)zzj2.zzl());
        }
        byte[] byArray = zzj2.zzbv();
        try {
            byArray = this.g_().zzb(byArray);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Data loss. Failed to serialize bundle. appId", zzfr.zza((String)zzj2.zzx()), (Object)iOException);
            return false;
        }
        this.zzj().zzp().zza("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzj2.zzx());
        contentValues.put("bundle_end_timestamp", Long.valueOf(zzj2.zzl()));
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzj2.zzbl()) {
            contentValues.put("retry_count", Integer.valueOf(zzj2.zzf()));
        }
        try {
            if (this.e_().insert("queue", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert bundle (got -1). appId", zzfr.zza((String)zzj2.zzx()));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing bundle. appId", zzfr.zza((String)zzj2.zzx()), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzew.zzb zzb2) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzb2));
        if (zzb2.zzf().isEmpty()) {
            this.zzj().zzu().zza("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzfr.zza((String)string), (Object)n, (Object)String.valueOf(zzb2.zzl() ? Integer.valueOf(zzb2.zzb()) : null));
            return false;
        }
        byte[] byArray = zzb2.zzbv();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zzl() ? Integer.valueOf(zzb2.zzb()) : null);
        contentValues.put("event_name", zzb2.zzf());
        contentValues.put("session_scoped", zzb2.zzm() ? Boolean.valueOf(zzb2.zzj()) : null);
        contentValues.put("data", byArray);
        try {
            if (this.e_().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert event filter (got -1). appId", zzfr.zza((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing event filter. appId", zzfr.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzew.zze zze2) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zze2));
        if (zze2.zze().isEmpty()) {
            this.zzj().zzu().zza("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzfr.zza((String)string), (Object)n, (Object)String.valueOf(zze2.zzi() ? Integer.valueOf(zze2.zza()) : null));
            return false;
        }
        byte[] byArray = zze2.zzbv();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zzi() ? Integer.valueOf(zze2.zza()) : null);
        contentValues.put("property_name", zze2.zze());
        contentValues.put("session_scoped", zze2.zzj() ? Boolean.valueOf(zze2.zzh()) : null);
        contentValues.put("data", byArray);
        try {
            if (this.e_().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert property filter (got -1). appId", zzfr.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing property filter. appId", zzfr.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzaz zzaz2, long l, boolean bl) {
        this.zzt();
        this.zzak();
        Preconditions.checkNotNull((Object)zzaz2);
        Preconditions.checkNotEmpty((String)zzaz2.zza);
        byte[] byArray = this.g_().zza(zzaz2).zzbv();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzaz2.zza);
        contentValues.put("name", zzaz2.zzb);
        contentValues.put("timestamp", Long.valueOf(zzaz2.zzc));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", byArray);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.e_().insert("raw_events", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert raw event (got -1). appId", zzfr.zza((String)zzaz2.zza));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing raw event. appId", zzfr.zza((String)zzaz2.zza), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(String string, zzmh zzmh2) {
        this.zzt();
        this.zzak();
        Preconditions.checkNotNull((Object)zzmh2);
        Preconditions.checkNotEmpty((String)string);
        long l = this.zzb().currentTimeMillis();
        if (zzmh2.zzb < l - zzaf.zzm() || zzmh2.zzb > l + zzaf.zzm()) {
            this.zzj().zzu().zza("Storing trigger URI outside of the max retention time span. appId, now, timestamp", zzfr.zza((String)string), (Object)l, (Object)zzmh2.zzb);
        }
        this.zzj().zzp().zza("Saving trigger URI");
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("trigger_uri", zzmh2.zza);
        contentValues.put("source", Integer.valueOf(zzmh2.zzc));
        contentValues.put("timestamp_millis", Long.valueOf(zzmh2.zzb));
        try {
            if (this.e_().insert("trigger_uris", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert trigger URI (got -1). appId", zzfr.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing trigger URI. appId", zzfr.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    private final boolean zzan() {
        return this.zza().getDatabasePath("google_app_measurement.db").exists();
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    public final boolean zza(String string, Long l, long l2, zzfi.zze zze2) {
        this.zzt();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zze2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        byte[] byArray = zze2.zzbv();
        this.zzj().zzp().zza("Saving complex main event, appId, data size", (Object)this.zzi().zza(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.e_().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert complex main event (got -1). appId", zzfr.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing complex main event. appId", zzfr.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(zzad zzad2) {
        Preconditions.checkNotNull((Object)zzad2);
        this.zzt();
        this.zzak();
        String string = zzad2.zza;
        Preconditions.checkNotNull((Object)string);
        if (this.zze(string, zzad2.zzc.zza) == null && this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{string}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("origin", zzad2.zzb);
        contentValues.put("name", zzad2.zzc.zza);
        zzao.zza(contentValues, "value", Preconditions.checkNotNull((Object)zzad2.zzc.zza()));
        contentValues.put("active", Boolean.valueOf(zzad2.zze));
        contentValues.put("trigger_event_name", zzad2.zzf);
        contentValues.put("trigger_timeout", Long.valueOf(zzad2.zzh));
        this.zzq();
        contentValues.put("timed_out_event", zznd.zza((Parcelable)zzad2.zzg));
        contentValues.put("creation_timestamp", Long.valueOf(zzad2.zzd));
        this.zzq();
        contentValues.put("triggered_event", zznd.zza((Parcelable)zzad2.zzi));
        contentValues.put("triggered_timestamp", Long.valueOf(zzad2.zzc.zzb));
        contentValues.put("time_to_live", Long.valueOf(zzad2.zzj));
        this.zzq();
        contentValues.put("expired_event", zznd.zza((Parcelable)zzad2.zzk));
        try {
            if (this.e_().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update conditional user property (got -1)", zzfr.zza((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing conditional user property", zzfr.zza((String)string), (Object)sQLiteException);
        }
        return true;
    }

    final boolean zza(String string, Bundle bundle) {
        this.zzt();
        this.zzak();
        zzaz zzaz2 = new zzaz(this.zzu, "", string, "dep", 0L, 0L, bundle);
        byte[] byArray = this.g_().zza(zzaz2).zzbv();
        this.zzj().zzp().zza("Saving default event parameters, appId, data size", (Object)this.zzi().zza(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("parameters", byArray);
        try {
            if (this.e_().insertWithOnConflict("default_event_params", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert default event parameters (got -1). appId", zzfr.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing default event parameters. appId", zzfr.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(zzne zzne2) {
        Preconditions.checkNotNull((Object)zzne2);
        this.zzt();
        this.zzak();
        if (this.zze(zzne2.zza, zzne2.zzc) == null && (zznd.zzh((String)zzne2.zzc) ? this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzne2.zza}) >= (long)this.zze().zza(zzne2.zza, zzbi.zzag, 25, 100) : !"_npa".equals(zzne2.zzc) && this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzne2.zza, zzne2.zzb}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzne2.zza);
        contentValues.put("origin", zzne2.zzb);
        contentValues.put("name", zzne2.zzc);
        contentValues.put("set_timestamp", Long.valueOf(zzne2.zzd));
        zzao.zza(contentValues, "value", zzne2.zze);
        try {
            if (this.e_().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update user property (got -1). appId", zzfr.zza((String)zzne2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing user property. appId", zzfr.zza((String)zzne2.zza), (Object)sQLiteException);
        }
        return true;
    }

    static /* bridge */ /* synthetic */ String[] zzaa() {
        return zzi;
    }

    static /* bridge */ /* synthetic */ String[] zzab() {
        return zzc;
    }

    static /* bridge */ /* synthetic */ String[] zzac() {
        return zzj;
    }

    static /* bridge */ /* synthetic */ String[] zzad() {
        return zza;
    }

    static /* bridge */ /* synthetic */ String[] zzae() {
        return zzg;
    }

    static /* bridge */ /* synthetic */ String[] zzaf() {
        return zzh;
    }

    static /* bridge */ /* synthetic */ String[] zzag() {
        return zze;
    }

    static /* bridge */ /* synthetic */ String[] zzah() {
        return zzd;
    }

    static /* bridge */ /* synthetic */ String[] zzai() {
        return zzk;
    }

    static /* bridge */ /* synthetic */ String[] zzaj() {
        return zzb;
    }
}

