/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzh;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class zzaf
implements zzak,
zzaq,
Iterable<zzaq> {
    @VisibleForTesting
    private final SortedMap<Integer, zzaq> zza = new TreeMap<Integer, zzaq>();
    @VisibleForTesting
    private final Map<String, zzaq> zzb = new TreeMap<String, zzaq>();

    public final int zza() {
        return this.zza.size();
    }

    public final int hashCode() {
        return this.zza.hashCode() * 31;
    }

    public final int zzb() {
        if (this.zza.isEmpty()) {
            return 0;
        }
        return this.zza.lastKey() + 1;
    }

    @Override
    public final zzaq zza(String string, zzh zzh2, List<zzaq> list) {
        String string2 = string;
        if ("concat".equals(string2) || "every".equals(string2) || "filter".equals(string2) || "forEach".equals(string2) || "indexOf".equals(string2) || "join".equals(string2) || "lastIndexOf".equals(string2) || "map".equals(string2) || "pop".equals(string2) || "push".equals(string2) || "reduce".equals(string2) || "reduceRight".equals(string2) || "reverse".equals(string2) || "shift".equals(string2) || "slice".equals(string2) || "some".equals(string2) || "sort".equals(string2) || "splice".equals(string2) || "toString".equals(string2) || "unshift".equals(string2)) {
            return zzbe.zza(string, this, zzh2, list);
        }
        return zzan.zza(this, new zzas(string), zzh2, list);
    }

    @Override
    public final zzaq zzc() {
        zzaf zzaf2 = new zzaf();
        for (Map.Entry<Integer, zzaq> entry : this.zza.entrySet()) {
            if (entry.getValue() instanceof zzak) {
                zzaf2.zza.put(entry.getKey(), entry.getValue());
                continue;
            }
            zzaf2.zza.put(entry.getKey(), entry.getValue().zzc());
        }
        return zzaf2;
    }

    public final zzaq zza(int n) {
        zzaq zzaq2;
        if (n >= this.zzb()) {
            throw new IndexOutOfBoundsException("Attempting to get element outside of current array");
        }
        if (this.zzc(n) && (zzaq2 = (zzaq)this.zza.get(n)) != null) {
            return zzaq2;
        }
        return zzc;
    }

    @Override
    public final zzaq zza(String string) {
        zzaq zzaq2;
        if ("length".equals(string)) {
            return new zzai(Double.valueOf(this.zzb()));
        }
        if (this.zzc(string) && (zzaq2 = this.zzb.get(string)) != null) {
            return zzaq2;
        }
        return zzc;
    }

    @Override
    public final Boolean zzd() {
        return true;
    }

    @Override
    public final Double zze() {
        if (this.zza.size() == 1) {
            return this.zza(0).zze();
        }
        if (this.zza.size() <= 0) {
            return 0.0;
        }
        return Double.NaN;
    }

    @Override
    public final String zzf() {
        return this.toString();
    }

    public final String toString() {
        return this.zzb(",");
    }

    public final String zzb(String string) {
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.zza.isEmpty()) {
            for (int i = 0; i < this.zzb(); ++i) {
                zzaq zzaq2 = this.zza(i);
                stringBuilder.append(string);
                if (zzaq2 instanceof zzax || zzaq2 instanceof zzao) continue;
                stringBuilder.append(zzaq2.zzf());
            }
            stringBuilder.delete(0, string.length());
        }
        return stringBuilder.toString();
    }

    public final Iterator<Integer> zzg() {
        return this.zza.keySet().iterator();
    }

    @Override
    public final @Nullable Iterator<zzaq> zzh() {
        Iterator<Integer> iterator = this.zza.keySet().iterator();
        Iterator<String> iterator2 = this.zzb.keySet().iterator();
        return new zzae(this, iterator, iterator2);
    }

    @Override
    public final Iterator<zzaq> iterator() {
        return new zzah(this);
    }

    public final List<zzaq> zzi() {
        ArrayList<zzaq> arrayList = new ArrayList<zzaq>(this.zzb());
        for (int i = 0; i < this.zzb(); ++i) {
            arrayList.add(this.zza(i));
        }
        return arrayList;
    }

    public zzaf() {
    }

    public zzaf(List<zzaq> list) {
        this();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.zzb(i, list.get(i));
            }
        }
    }

    public zzaf(zzaq ... zzaqArray) {
        this(Arrays.asList(zzaqArray));
    }

    public final void zza(zzaq zzaq2) {
        this.zzb(this.zzb(), zzaq2);
    }

    public final void zzj() {
        this.zza.clear();
    }

    public final void zza(int n, zzaq zzaq2) {
        if (n < 0) {
            int n2 = n;
            throw new IllegalArgumentException("Invalid value index: " + n2);
        }
        if (n >= this.zzb()) {
            this.zzb(n, zzaq2);
            return;
        }
        for (int i = this.zza.lastKey().intValue(); i >= n; --i) {
            zzaq zzaq3 = (zzaq)this.zza.get(i);
            if (zzaq3 == null) continue;
            this.zzb(i + 1, zzaq3);
            this.zza.remove(i);
        }
        this.zzb(n, zzaq2);
    }

    public final void zzb(int n) {
        int n2 = this.zza.lastKey();
        if (n > n2 || n < 0) {
            return;
        }
        this.zza.remove(n);
        if (n == n2) {
            if (!this.zza.containsKey(n - 1) && n - 1 >= 0) {
                this.zza.put(n - 1, zzaq.zzc);
            }
            return;
        }
        for (int i = n + 1; i <= this.zza.lastKey(); ++i) {
            zzaq zzaq2 = (zzaq)this.zza.get(i);
            if (zzaq2 == null) continue;
            this.zza.put(i - 1, zzaq2);
            this.zza.remove(i);
        }
    }

    @RequiresNonNull(value={"elements"})
    public final void zzb(@UnknownInitialization zzaf this, int n, @Nullable zzaq zzaq2) {
        if (n > 32468) {
            throw new IllegalStateException("Array too large");
        }
        if (n < 0) {
            int n2 = n;
            throw new IndexOutOfBoundsException("Out of bounds index: " + n2);
        }
        if (zzaq2 == null) {
            this.zza.remove(n);
            return;
        }
        this.zza.put(n, zzaq2);
    }

    @Override
    public final void zza(String string, zzaq zzaq2) {
        if (zzaq2 == null) {
            this.zzb.remove(string);
            return;
        }
        this.zzb.put(string, zzaq2);
    }

    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzaf)) {
            return false;
        }
        zzaf zzaf2 = (zzaf)object;
        if (this.zzb() != zzaf2.zzb()) {
            return false;
        }
        if (this.zza.isEmpty()) {
            return zzaf2.zza.isEmpty();
        }
        for (int i = this.zza.firstKey().intValue(); i <= this.zza.lastKey(); ++i) {
            if (this.zza(i).equals(zzaf2.zza(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean zzc(int n) {
        if (n < 0 || n > this.zza.lastKey()) {
            int n2 = n;
            throw new IndexOutOfBoundsException("Out of bounds index: " + n2);
        }
        return this.zza.containsKey(n);
    }

    @Override
    public final boolean zzc(String string) {
        return "length".equals(string) || this.zzb.containsKey(string);
    }
}

