/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzci;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzlj;
import com.google.android.gms.internal.measurement.zzod;
import com.google.android.gms.internal.measurement.zzoi;
import com.google.android.gms.internal.measurement.zzoo;
import com.google.android.gms.internal.measurement.zzop;
import com.google.android.gms.internal.measurement.zzpg;
import com.google.android.gms.internal.measurement.zzph;
import com.google.android.gms.internal.measurement.zzpm;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.internal.measurement.zzpz;
import com.google.android.gms.internal.measurement.zzql;
import com.google.android.gms.internal.measurement.zzqw;
import com.google.android.gms.internal.measurement.zzqx;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzmg;
import com.google.android.gms.measurement.internal.zzmw;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zzne;
import com.google.android.gms.measurement.internal.zznf;
import com.google.android.gms.measurement.internal.zznh;
import com.google.android.gms.measurement.internal.zzni;
import com.google.android.gms.measurement.internal.zznj;
import com.google.android.gms.measurement.internal.zznk;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zznn;
import com.google.android.gms.measurement.internal.zznp;
import com.google.android.gms.measurement.internal.zznq;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zznw;
import com.google.android.gms.measurement.internal.zznx;
import com.google.android.gms.measurement.internal.zzny;
import com.google.android.gms.measurement.internal.zzs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzng
implements zziq {
    private static volatile @Nullable zzng zza;
    private zzgy zzb;
    private zzge zzc;
    private zzan zzd;
    private zzgl zze;
    private zzna zzf;
    private zzs zzg;
    private final zznt zzh;
    private zzkv zzi;
    private zzmg zzj;
    private final zzne zzk;
    private @MonotonicNonNull zzgv zzl;
    private final zzho zzm;
    private boolean zzn = false;
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Set<String> zzr = new HashSet<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zzis> zzac;
    private final Map<String, zzax> zzad;
    private final Map<String, zzb> zzae;
    private @Nullable zzkx zzaf;
    private @Nullable String zzag;
    private final zzny zzah = new zznn(this);

    private final int zza(String string, zzaj zzaj2) {
        zzir zzir2;
        zzf zzf2;
        if (this.zzb.zzb(string) == null) {
            zzaj2.zza(zzis.zza.zzd, zzai.zzj);
            return 1;
        }
        if (com.google.android.gms.internal.measurement.zznx.zza() && this.zze().zza(zzbh.zzcz) && (zzf2 = this.zzf().zze(string)) != null && zzgn.zza((String)zzf2.zzak()).zza() == zzir.zzb && (zzir2 = this.zzb.zza(string, zzis.zza.zzd)) != zzir.zza) {
            zzaj2.zza(zzis.zza.zzd, zzai.zzi);
            if (zzir2 == zzir.zzd) {
                return 0;
            }
            return 1;
        }
        zzaj2.zza(zzis.zza.zzd, zzai.zzb);
        if (this.zzb.zzc(string, zzis.zza.zzd)) {
            return 0;
        }
        return 1;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzu().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzx() {
        long l = this.zzb().currentTimeMillis();
        zzmg zzmg2 = this.zzj;
        zzmg2.zzak();
        zzmg2.zzt();
        long l2 = zzmg2.zze.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzmg2.zzq().zzv().nextInt(86400000);
            zzmg2.zze.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    @WorkerThread
    final @Nullable Bundle zza(String string) {
        zznx zznx2;
        this.zzl().zzt();
        this.zzs();
        if (this.zzi().zzb(string) == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        zzis zzis2 = this.zzb(string);
        bundle.putAll(zzis2.zzb());
        zzax zzax2 = this.zza(string, this.zzd(string), zzis2, new zzaj());
        bundle.putAll(zzax2.zzb());
        int n = this.zzp().zzc(string) ? 1 : ((zznx2 = this.zzf().zze(string, "_npa")) != null ? (zznx2.zze.equals(1L) ? 1 : 0) : this.zza(string, new zzaj()));
        bundle.putString("ad_personalization", n == 1 ? "denied" : "granted");
        return bundle;
    }

    public final Clock zzb(@UnknownInitialization zzng this) {
        return ((zzho)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzf zza(zzn zzn2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        if (!zzn2.zzu.isEmpty()) {
            this.zzae.put(zzn2.zza, new zzb(this, zzn2.zzu, null));
        }
        zzf zzf2 = this.zzf().zze(zzn2.zza);
        zzis zzis2 = this.zzb(zzn2.zza).zza(zzis.zzb((String)zzn2.zzt));
        String string = zzis2.zzi() ? this.zzj.zza(zzn2.zza, zzn2.zzn) : "";
        if (zzf2 == null) {
            zzf2 = new zzf(this.zzm, zzn2.zza);
            if (zzis2.zzj()) {
                zzf2.zzb(this.zza(zzis2));
            }
            if (zzis2.zzi()) {
                zzf2.zzh(string);
            }
        } else if (zzis2.zzi() && string != null && !string.equals(zzf2.zzaj())) {
            boolean bl = TextUtils.isEmpty((CharSequence)zzf2.zzaj());
            zzf2.zzh(string);
            if (!(!zzn2.zzn || "00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzn2.zza, (zzis)zzis2).first) || this.zze().zza(zzbh.zzdb) && bl)) {
                if (!zzod.zza() || !this.zze().zza(zzbh.zzdg) || zzis2.zzj()) {
                    zzf2.zzb(this.zza(zzis2));
                }
                if (this.zzf().zze(zzn2.zza, "_id") != null && this.zzf().zze(zzn2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zznx zznx2 = new zznx(zzn2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zznx2);
                }
            } else if (this.zze().zza(zzbh.zzdb) && TextUtils.isEmpty((CharSequence)zzf2.zzad()) && zzis2.zzj()) {
                zzf2.zzb(this.zza(zzis2));
            }
        } else if (TextUtils.isEmpty((CharSequence)zzf2.zzad()) && zzis2.zzj()) {
            zzf2.zzb(this.zza(zzis2));
        }
        zzf2.zzf(zzn2.zzb);
        zzf2.zza(zzn2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzk)) {
            zzf2.zze(zzn2.zzk);
        }
        if (zzn2.zze != 0L) {
            zzf2.zzn(zzn2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzc)) {
            zzf2.zzd(zzn2.zzc);
        }
        zzf2.zzb(zzn2.zzj);
        if (zzn2.zzd != null) {
            zzf2.zzc(zzn2.zzd);
        }
        zzf2.zzk(zzn2.zzf);
        zzf2.zzb(zzn2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzg)) {
            zzf2.zzg(zzn2.zzg);
        }
        zzf2.zza(zzn2.zzn);
        zzf2.zza(zzn2.zzq);
        zzf2.zzl(zzn2.zzr);
        if (zzql.zza() && (this.zze().zza(zzbh.zzbq) || this.zze().zze(zzn2.zza, zzbh.zzbs))) {
            zzf2.zzj(zzn2.zzv);
        }
        if (zzop.zza() && this.zze().zza(zzbh.zzbp)) {
            zzf2.zza(zzn2.zzs);
        } else if (zzop.zza() && this.zze().zza(zzbh.zzbo)) {
            zzf2.zza((List<String>)null);
        }
        if (zzqw.zza() && this.zze().zza(zzbh.zzbt)) {
            this.zzq();
            if (zznw.zzf((String)zzf2.zzac())) {
                zzf2.zzc(zzn2.zzw);
                if (this.zze().zza(zzbh.zzbu)) {
                    zzf2.zzk(zzn2.zzac);
                }
            }
        }
        if (zzpz.zza() && this.zze().zza(zzbh.zzcg)) {
            zzf2.zza(zzn2.zzaa);
        }
        zzf2.zzt(zzn2.zzx);
        if (com.google.android.gms.internal.measurement.zznx.zza() && this.zze().zza(zzbh.zzcz)) {
            zzf2.zzi(zzn2.zzad);
        }
        if (zzf2.zzas()) {
            this.zzf().zza(zzf2);
        }
        return zzf2;
    }

    @WorkerThread
    private final @Nullable zzn zzc(String string) {
        zzf zzf2 = this.zzf().zze(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzf2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzgb.zza((String)string));
            return null;
        }
        return new zzn(string, zzf2.zzah(), zzf2.zzaf(), zzf2.zze(), zzf2.zzae(), zzf2.zzq(), zzf2.zzn(), null, zzf2.zzar(), false, zzf2.zzag(), zzf2.zzd(), 0L, 0, zzf2.zzaq(), false, zzf2.zzaa(), zzf2.zzx(), zzf2.zzo(), zzf2.zzan(), null, this.zzb(string).zzh(), "", null, zzf2.zzat(), zzf2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzf2.zza(), zzf2.zzf(), zzf2.zzam(), zzf2.zzak());
    }

    public final zzs zzc() {
        return (zzs)zzng.zza(this.zzg);
    }

    public final zzad zzd() {
        return this.zzm.zzd();
    }

    public final zzae zze(@UnknownInitialization zzng this) {
        return ((zzho)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzan zzf(@UnknownInitialization zzng this) {
        return (zzan)zzng.zza(this.zzd);
    }

    @VisibleForTesting
    @WorkerThread
    private final zzax zza(String string, zzax zzax2, zzis zzis2, zzaj zzaj2) {
        int n;
        if (this.zzi().zzb(string) == null) {
            int n2;
            if (zzax2.zzc() == zzir.zzc) {
                n2 = zzax2.zza();
                zzaj2.zza(zzis.zza.zzc, n2);
            } else {
                n2 = 90;
                zzaj2.zza(zzis.zza.zzc, zzai.zzj);
            }
            return new zzax(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
        }
        zzir zzir2 = zzax2.zzc();
        if (zzir2 == zzir.zzd || zzir2 == zzir.zzc) {
            n = zzax2.zza();
            zzaj2.zza(zzis.zza.zzc, n);
        } else {
            n = 90;
            if (com.google.android.gms.internal.measurement.zznx.zza() && this.zze().zza(zzbh.zzcz)) {
                zzis.zza zza2;
                zzis.zza zza3;
                zzaj zzaj3 = zzaj2;
                zzis zzis3 = zzis2;
                zzir zzir3 = zzir2;
                String string2 = string;
                zzng zzng2 = this;
                if (zzir3 == zzir.zzb && (zza3 = zzng2.zzb.zza(string2, zzis.zza.zzc)) != zzir.zza) {
                    zzaj3.zza(zzis.zza.zzc, zzai.zzi);
                    zza2 = zza3;
                } else {
                    boolean bl;
                    zza3 = zzng2.zzb.zzb(string2, zzis.zza.zzc);
                    zzir zzir4 = zzis3.zzc();
                    boolean bl2 = bl = zzir4 == zzir.zzd || zzir4 == zzir.zzc;
                    if (zza3 == zzis.zza.zza && bl) {
                        zzaj3.zza(zzis.zza.zzc, zzai.zzc);
                        zza2 = zzir4;
                    } else {
                        zzaj3.zza(zzis.zza.zzc, zzai.zzb);
                        zza2 = zzng2.zzb.zzc(string2, zzis.zza.zzc) ? zzir.zzd : zzir.zzc;
                    }
                }
                zzir2 = zza2;
            } else {
                zzaj zzaj4 = zzaj2;
                zzis zzis4 = zzis2;
                zzir zzir5 = zzir2;
                String string3 = string;
                zzng zzng3 = this;
                Preconditions.checkArgument((zzir5 == zzir.zza || zzir5 == zzir.zzb ? 1 : 0) != 0);
                zzir zzir6 = zzir5;
                zzis.zza zza4 = zzng3.zzb.zzb(string3, zzis.zza.zzc);
                Boolean bl = zzis4.zze();
                if (zza4 == zzis.zza.zza && bl != null) {
                    zzir6 = bl != false ? zzir.zzd : zzir.zzc;
                    zzaj4.zza(zzis.zza.zzc, zzai.zzc);
                }
                if (zzir6 == zzir.zza) {
                    zzir6 = zzng3.zzb.zzc(string3, zzis.zza.zzc) ? zzir.zzd : zzir.zzc;
                    zzaj4.zza(zzis.zza.zzc, zzai.zzb);
                }
                zzir2 = zzir6;
            }
        }
        boolean bl = this.zzb.zzn(string);
        SortedSet<String> sortedSet = this.zzi().zzh(string);
        if (zzir2 == zzir.zzc || sortedSet.isEmpty()) {
            return new zzax(Boolean.valueOf(false), n, Boolean.valueOf(bl), "-");
        }
        return new zzax(Boolean.valueOf(true), n, Boolean.valueOf(bl), bl ? TextUtils.join((CharSequence)"", sortedSet) : "");
    }

    @WorkerThread
    private final zzax zzd(String string) {
        this.zzl().zzt();
        this.zzs();
        zzax zzax2 = this.zzad.get(string);
        if (zzax2 == null) {
            zzax2 = this.zzf().zzg(string);
            this.zzad.put(string, zzax2);
        }
        return zzax2;
    }

    public final zzfw zzg() {
        return this.zzm.zzk();
    }

    public final zzgb zzj(@UnknownInitialization zzng this) {
        return ((zzho)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzge zzh() {
        return (zzge)zzng.zza(this.zzc);
    }

    private final zzgl zzy() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzgy zzi() {
        return (zzgy)zzng.zza(this.zzb);
    }

    public final zzhh zzl(@UnknownInitialization zzng this) {
        return ((zzho)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzho zza(zzng zzng2) {
        return zzng2.zzm;
    }

    final zzho zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zzis zzb(String string) {
        this.zzl().zzt();
        this.zzs();
        zzis zzis2 = this.zzac.get(string);
        if (zzis2 == null) {
            zzis2 = this.zzf().zzh(string);
            if (zzis2 == null) {
                zzis2 = zzis.zza;
            }
            this.zza(string, zzis2);
        }
        return zzis2;
    }

    public final zzkv zzm() {
        return (zzkv)zzng.zza(this.zzi);
    }

    public final zzmg zzn() {
        return this.zzj;
    }

    private final zzna zzz() {
        return (zzna)zzng.zza(this.zzf);
    }

    private static zznf zza(@Nullable zznf zznf2) {
        if (zznf2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zznf2.zzam()) {
            String string = String.valueOf(((Object)((Object)zznf2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zznf2;
    }

    public final zzne zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzng zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzng> clazz = zzng.class;
        synchronized (zzng.class) {
            if (zza != null) return zza;
            zznq zznq2 = (zznq)Preconditions.checkNotNull((Object)new zznq(context));
            zza = new zzng(zznq2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zznt zzp() {
        return (zznt)zzng.zza(this.zzh);
    }

    public final zznw zzq(@UnknownInitialization zzng this) {
        return ((zzho)Preconditions.checkNotNull((Object)this.zzm)).zzt();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzf zzf2) {
        try {
            if (zzf2.zze() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzf2.zzac(), (int)0).versionCode;
                if (zzf2.zze() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzf2.zzac(), (int)0).versionName;
                String string2 = zzf2.zzaf();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    private final @Nullable Boolean zzg(zzn zzn2) {
        Boolean bl = zzn2.zzq;
        if (com.google.android.gms.internal.measurement.zznx.zza() && this.zze().zza(zzbh.zzcz) && !TextUtils.isEmpty((CharSequence)zzn2.zzad)) {
            zzir zzir2 = zzgn.zza((String)zzn2.zzad).zza();
            switch (zzir2) {
                case zzd: {
                    bl = false;
                    break;
                }
                case zzc: {
                    bl = true;
                    break;
                }
                case zzb: 
                case zza: {
                    bl = null;
                }
            }
        }
        return bl;
    }

    @WorkerThread
    private final @Nullable String zza(zzis zzis2) {
        if (zzis2.zzj()) {
            zzng zzng2 = this;
            byte[] byArray = new byte[16];
            zzng2.zzq().zzv().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzn zzn2) {
        Future future = this.zzl().zza((Callable)new zznk(this, zzn2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzgb.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    static /* synthetic */ void zza(zzng zzng2, zznq zznq2) {
        zzng zzng3 = zzng2;
        zzng3.zzl().zzt();
        zzng zzng4 = zzng3;
        zzng3.zzl = new zzgv(zzng4);
        zzng4 = zzng3;
        zzan zzan2 = new zzan(zzng4);
        zzan2.zzal();
        zzng3.zzd = zzan2;
        zzng3.zze().zza((zzag)Preconditions.checkNotNull((Object)((Object)zzng3.zzb)));
        zzng4 = zzng3;
        zzmg zzmg2 = new zzmg(zzng4);
        zzmg2.zzal();
        zzng3.zzj = zzmg2;
        zzng4 = zzng3;
        zzs zzs2 = new zzs(zzng4);
        zzs2.zzal();
        zzng3.zzg = zzs2;
        zzng4 = zzng3;
        zzkv zzkv2 = new zzkv(zzng4);
        zzkv2.zzal();
        zzng3.zzi = zzkv2;
        zzng4 = zzng3;
        zzna zzna2 = new zzna(zzng4);
        zzna2.zzal();
        zzng3.zzf = zzna2;
        zzng4 = zzng3;
        zzng3.zze = new zzgl(zzng4);
        if (zzng3.zzs != zzng3.zzt) {
            zzng3.zzj().zzg().zza("Not all upload components initialized", (Object)zzng3.zzs, (Object)zzng3.zzt);
        }
        zzng3.zzn = true;
    }

    private zzng(zznq zznq2) {
        this(zznq2, null);
    }

    private zzng(zznq zznq2, @Nullable zzho zzho2) {
        Preconditions.checkNotNull((Object)zznq2);
        this.zzm = zzho2 = zzho.zza((Context)zznq2.zza, null, null);
        this.zzab = -1L;
        zzng zzng2 = this;
        this.zzk = new zzne(zzng2);
        zzng2 = this;
        zznt zznt2 = new zznt(zzng2);
        zznt2.zzal();
        this.zzh = zznt2;
        zzng2 = this;
        zzge zzge2 = new zzge(zzng2);
        zzge2.zzal();
        this.zzc = zzge2;
        zzng2 = this;
        zzgy zzgy2 = new zzgy(zzng2);
        zzgy2.zzal();
        this.zzb = zzgy2;
        this.zzac = new HashMap<String, zzis>();
        this.zzad = new HashMap<String, zzax>();
        this.zzae = new HashMap<String, zzb>();
        this.zzl().zzb((Runnable)new zznj(this, zznq2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzt();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzr() {
        int n;
        this.zzl().zzt();
        this.zzs();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzad()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzab();
        int n4 = n2;
        zzng zzng2 = this;
        zzng2.zzl().zzt();
        if (n4 > n3) {
            zzng2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzng2.zza(n3, zzng2.zzy)) {
            zzng2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzng2.zzj().zzp().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzs() {
        if (!this.zzn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    @WorkerThread
    private final void zzaa() {
        this.zzl().zzt();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzp().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzp().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzfs.zzj.zza zza2) {
        int n;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzq(string)) {
            zza2.zzi();
        }
        if (this.zzi().zzt(string)) {
            if (this.zze().zze(string, zzbh.zzbw)) {
                int n2;
                String string2 = zza2.zzy();
                if (!TextUtils.isEmpty((CharSequence)string2) && (n2 = string2.indexOf(".")) != -1) {
                    string2 = string2.substring(0, n2);
                    zza2.zzo(string2);
                }
            } else {
                zza2.zzn();
            }
        }
        if (this.zzi().zzu(string) && (n = zznt.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzs(string)) {
            zza2.zzj();
        }
        if (this.zzi().zzp(string)) {
            zza2.zzg();
            if (!zzod.zza() || !this.zze().zza(zzbh.zzdg) || this.zzb(string).zzj()) {
                zzb zzb2 = this.zzae.get(string);
                if (zzb2 == null || zzb2.zzb + this.zze().zzc(string, zzbh.zzau) < this.zzb().elapsedRealtime()) {
                    zzb2 = new zzb(this, null);
                    this.zzae.put(string, zzb2);
                }
                zza2.zzk(zzb2.zza);
            }
        }
        if (this.zzi().zzr(string)) {
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzb(zzf zzf2) {
        this.zzl().zzt();
        if (TextUtils.isEmpty((CharSequence)zzf2.zzah()) && TextUtils.isEmpty((CharSequence)zzf2.zzaa())) {
            this.zza((String)Preconditions.checkNotNull((Object)zzf2.zzac()), 204, null, null, null);
            return;
        }
        Object object = zzf2;
        Object object2 = new Uri.Builder();
        String string = ((zzf)object).zzah();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = ((zzf)object).zzaa();
        }
        Object object3 = string;
        object2.scheme((String)zzbh.zze.zza(null)).encodedAuthority((String)zzbh.zzf.zza(null)).path("config/app/" + (String)object3).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "88000").appendQueryParameter("runtime_version", "0");
        String string2 = object2.build().toString();
        try {
            String string3 = (String)Preconditions.checkNotNull((Object)zzf2.zzac());
            URL uRL = new URL(string2);
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string3);
            zzfl.zzd zzd2 = this.zzi().zzc(string3);
            ArrayMap arrayMap = null;
            String string4 = this.zzi().zze(string3);
            if (zzd2 != null) {
                String string5;
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string4);
                }
                if (!TextUtils.isEmpty((CharSequence)(string5 = this.zzi().zzd(string3)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string5);
                }
            }
            this.zzu = true;
            object3 = new zznl(this);
            string = arrayMap;
            object2 = uRL;
            object = string3;
            zzge zzge2 = this.zzh();
            zzge2.zzt();
            zzge2.zzak();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)object3);
            zzge2.zzl().zza((Runnable)new zzgi(zzge2, (String)object, (URL)object2, null, (Map)((Object)string), (zzgh)object3));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzgb.zza((String)zzf2.zzac()), (Object)string2);
            return;
        }
    }

    @WorkerThread
    final void zza(zzf zzf2, zzfs.zzj.zza zza2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.zzl().zzt();
        this.zzs();
        zzaj zzaj2 = zzaj.zza(zza2.zzv());
        if (com.google.android.gms.internal.measurement.zznx.zza() && this.zze().zza(zzbh.zzcz)) {
            object6 = zzaj2;
            object5 = zzf2.zzac();
            object4 = this;
            ((zzng)object4).zzl().zzt();
            ((zzng)object4).zzs();
            object3 = ((zzng)object4).zzb((String)object5);
            switch (object3.zzc()) {
                case zzb: {
                    ((zzaj)object6).zza(zzis.zza.zza, zzai.zzi);
                    break;
                }
                case zzd: 
                case zzc: {
                    ((zzaj)object6).zza(zzis.zza.zza, object3.zza());
                    break;
                }
                default: {
                    ((zzaj)object6).zza(zzis.zza.zza, zzai.zzj);
                }
            }
            switch (object3.zzd()) {
                case zzb: {
                    ((zzaj)object6).zza(zzis.zza.zzb, zzai.zzi);
                    break;
                }
                case zzd: 
                case zzc: {
                    ((zzaj)object6).zza(zzis.zza.zzb, object3.zza());
                    break;
                }
                default: {
                    ((zzaj)object6).zza(zzis.zza.zzb, zzai.zzj);
                    break;
                }
            }
        } else {
            object3 = zzaj2;
            object5 = zzf2.zzac();
            object4 = this;
            ((zzng)object4).zzl().zzt();
            ((zzng)object4).zzs();
            object2 = ((zzng)object4).zzb((String)object5);
            if (object2.zze() != null) {
                ((zzaj)object3).zza(zzis.zza.zza, object2.zza());
            } else {
                ((zzaj)object3).zza(zzis.zza.zza, zzai.zzj);
            }
            if (object2.zzf() != null) {
                ((zzaj)object3).zza(zzis.zza.zzb, object2.zza());
            } else {
                ((zzaj)object3).zza(zzis.zza.zzb, zzai.zzj);
            }
        }
        object3 = zzaj2;
        object6 = zza2;
        object5 = zzf2.zzac();
        object4 = this;
        ((zzng)object4).zzl().zzt();
        ((zzng)object4).zzs();
        object2 = ((zzng)object4).zza((String)object5, ((zzng)object4).zzd((String)object5), ((zzng)object4).zzb((String)object5), (zzaj)object3);
        ((zzfs.zzj.zza)((Object)object6)).zzb((Boolean)Preconditions.checkNotNull((Object)object2.zzd()));
        if (!TextUtils.isEmpty((CharSequence)object2.zze())) {
            ((zzfs.zzj.zza)((Object)object6)).zzh(object2.zze());
        }
        object3 = zzaj2;
        object6 = zza2;
        object5 = zzf2;
        object4 = this;
        ((zzng)object4).zzl().zzt();
        ((zzng)object4).zzs();
        object2 = null;
        Object object7 = ((zzfs.zzj.zza)((Object)object6)).zzab().iterator();
        while (object7.hasNext()) {
            object = object7.next();
            if (!"_npa".equals(object.zzg())) continue;
            object2 = object;
            break;
        }
        if (object2 != null) {
            if (((zzaj)object3).zza(zzis.zza.zzd) == zzai.zza) {
                if (zzqx.zza() && ((zzng)object4).zze().zza(zzbh.zzcy) && (object7 = ((zzng)object4).zzf().zze(((zzf)object5).zzac(), "_npa")) != null) {
                    if ("tcf".equals(((zznx)object7).zzb)) {
                        ((zzaj)object3).zza(zzis.zza.zzd, zzai.zzh);
                    } else if ("app".equals(((zznx)object7).zzb)) {
                        ((zzaj)object3).zza(zzis.zza.zzd, zzai.zzf);
                    } else {
                        ((zzaj)object3).zza(zzis.zza.zzd, zzai.zzd);
                    }
                } else {
                    object7 = ((zzf)object5).zzx();
                    if (object7 == null || object7 == Boolean.TRUE && ((zzfs.zzn)((Object)object2)).zzc() != 1L || object7 == Boolean.FALSE && ((zzfs.zzn)((Object)object2)).zzc() != 0L) {
                        ((zzaj)object3).zza(zzis.zza.zzd, zzai.zzf);
                    } else {
                        ((zzaj)object3).zza(zzis.zza.zzd, zzai.zzd);
                    }
                }
            }
        } else {
            int n = ((zzng)object4).zza(((zzf)object5).zzac(), (zzaj)object3);
            ((zzfs.zzj.zza)((Object)object6)).zza((zzfs.zzn)((zzju)zzfs.zzn.zze().zza("_npa").zzb(((zzng)object4).zzb().currentTimeMillis()).zza(n).zzah()));
        }
        zza2.zzf(zzaj2.toString());
        if (zzqx.zza() && this.zze().zza(zzbh.zzcy)) {
            boolean bl = this.zzb.zzn(zzf2.zzac());
            object4 = zza2;
            object3 = ((zzfs.zzj.zza)((Object)object4)).zzaa();
            for (int i = 0; i < object3.size(); ++i) {
                if (!"_tcf".equals(((zzfs.zze)((Object)object3.get(i))).zzg())) continue;
                zzfs.zze.zza zza3 = (zzfs.zze.zza)((zzfs.zze)((Object)object3.get(i))).zzca();
                object = zza3.zzf();
                for (int j = 0; j < object.size(); ++j) {
                    if (!"_tcfd".equals(((zzfs.zzg)((Object)object.get(j))).zzg())) continue;
                    String string = zzmw.zza((String)((zzfs.zzg)((Object)object.get(j))).zzh(), (boolean)bl);
                    zza3.zza(j, zzfs.zzg.zze().zza("_tcfd").zzb(string));
                    break;
                }
                ((zzfs.zzj.zza)((Object)object4)).zza(i, zza3);
                return;
            }
        }
    }

    @VisibleForTesting
    private static void zza(zzfs.zze.zza zza2, int n, String string) {
        List<zzfs.zzg> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzg())) continue;
            return;
        }
        zzfs.zzg zzg2 = (zzfs.zzg)((zzju)zzfs.zzg.zze().zza("_err").zza(n).zzah());
        zzfs.zzg zzg3 = (zzfs.zzg)((zzju)zzfs.zzg.zze().zza("_ev").zzb(string).zzah());
        zza2.zza(zzg2).zza(zzg3);
    }

    @WorkerThread
    final void zza(zzbf zzbf2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        this.zzl().zzt();
        this.zzs();
        String string = zzn2.zza;
        long l = zzbf2.zzd;
        zzgf zzgf2 = zzgf.zza((zzbf)zzbf2);
        String string2 = string;
        zziq zziq2 = this;
        zziq2.zzl().zzt();
        zznw.zza(zziq2.zzaf == null || zziq2.zzag == null || !zziq2.zzag.equals(string2) ? null : zziq2.zzaf, (Bundle)zzgf2.zzb, (boolean)false);
        zzbf2 = zzgf2.zza();
        this.zzp();
        if (!zznt.zza(zzbf2, zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zza(zzn2);
            return;
        }
        if (zzn2.zzs != null) {
            if (zzn2.zzs.contains(zzbf2.zza)) {
                Bundle bundle = zzbf2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbf2 = new zzbf(zzbf2.zza, new zzba(bundle), zzbf2.zzc, zzbf2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbf2.zza, (Object)zzbf2.zzc);
                return;
            }
        }
        this.zzf().zzp();
        try {
            zzac zzac2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            long l2 = l;
            string2 = string;
            zziq2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zziq2.zzt();
            zziq2.zzak();
            if (l2 < 0L) {
                zziq2.zzj().zzu().zza("Invalid time querying timed out conditional properties", zzgb.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zziq2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzp().zza("User property timed out", (Object)((zzac)object22).zza, (Object)this.zzm.zzk().zzc(((zzac)object22).zzc.zza), ((zzac)object22).zzc.zza());
                if (((zzac)object22).zzg != null) {
                    this.zzc(new zzbf(((zzac)object22).zzg, l), zzn2);
                }
                this.zzf().zza(string, ((zzac)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zziq2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zziq2.zzt();
            zziq2.zzak();
            if (l2 < 0L) {
                zziq2.zzj().zzu().zza("Invalid time querying expired conditional properties", zzgb.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zziq2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzac)object4.next();
                if (object == null) continue;
                this.zzj().zzp().zza("User property expired", (Object)((zzac)object).zza, (Object)this.zzm.zzk().zzc(((zzac)object).zzc.zza), ((zzac)object).zzc.zza());
                this.zzf().zzh(string, ((zzac)object).zzc.zza);
                if (((zzac)object).zzk != null) {
                    object22.add(((zzac)object).zzk);
                }
                this.zzf().zza(string, ((zzac)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbf)e;
                this.zzc(new zzbf((zzbf)object, l), zzn2);
            }
            long l3 = l;
            String string4 = zzbf2.zza;
            string2 = string;
            zziq2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zziq2.zzt();
            zziq2.zzak();
            if (l3 < 0L) {
                zziq2.zzj().zzu().zza("Invalid time querying triggered conditional properties", zzgb.zza((String)string2), (Object)zziq2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zziq2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzac2 = (zzac)iterator.next();
                if (zzac2 == null) continue;
                zznv zznv2 = zzac2.zzc;
                zznx zznx2 = new zznx((String)Preconditions.checkNotNull((Object)zzac2.zza), zzac2.zzb, zznv2.zza, l, Preconditions.checkNotNull((Object)zznv2.zza()));
                if (this.zzf().zza(zznx2)) {
                    this.zzj().zzp().zza("User property triggered", (Object)zzac2.zza, (Object)this.zzm.zzk().zzc(zznx2.zzc), zznx2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzgb.zza((String)zzac2.zza), (Object)this.zzm.zzk().zzc(zznx2.zzc), zznx2.zze);
                }
                if (zzac2.zzi != null) {
                    object.add(zzac2.zzi);
                }
                zzac2.zzc = new zznv(zznx2);
                zzac2.zze = true;
                this.zzf().zza(zzac2);
            }
            this.zzc(zzbf2, zzn2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzac2 = (zzbf)e;
                this.zzc(new zzbf((zzbf)zzac2, l), zzn2);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(zzbf zzbf2, String string) {
        zzf zzf2 = this.zzf().zze(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzf2);
        if (bl == null) {
            if (!"_ui".equals(zzbf2.zza)) {
                this.zzj().zzu().zza("Could not find package. appId", zzgb.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzgb.zza((String)string));
            return;
        }
        zzn zzn2 = new zzn(string, zzf2.zzah(), zzf2.zzaf(), zzf2.zze(), zzf2.zzae(), zzf2.zzq(), zzf2.zzn(), null, zzf2.zzar(), false, zzf2.zzag(), zzf2.zzd(), 0L, 0, zzf2.zzaq(), false, zzf2.zzaa(), zzf2.zzx(), zzf2.zzo(), zzf2.zzan(), null, this.zzb(string).zzh(), "", null, zzf2.zzat(), zzf2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzf2.zza(), zzf2.zzf(), zzf2.zzam(), zzf2.zzak());
        this.zzb(zzbf2, zzn2);
    }

    @WorkerThread
    private final void zzb(zzbf zzbf2, zzn zzn2) {
        zznv zznv2;
        String string;
        Preconditions.checkNotEmpty((String)zzn2.zza);
        zzgf zzgf2 = zzgf.zza((zzbf)zzbf2);
        this.zzq().zza(zzgf2.zzb, this.zzf().zzd(zzn2.zza));
        this.zzq().zza(zzgf2, this.zze().zzb(zzn2.zza));
        zzbf2 = zzgf2.zza();
        zzn zzn3 = zzn2;
        zzbf zzbf3 = zzbf2;
        zzng zzng2 = this;
        if ("_cmp".equals(zzbf3.zza) && "referrer API v2".equals(zzbf3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbf3.zzb.zzd("gclid")))) {
            zznv2 = new zznv("_lgclid", zzbf3.zzd, (Object)string, "auto");
            zzng2.zza(zznv2, zzn3);
        }
        if (zzpg.zza() && zzpg.zzc()) {
            zzn3 = zzn2;
            zzbf3 = zzbf2;
            zzng2 = this;
            if ("_cmp".equals(zzbf3.zza) && "referrer API v2".equals(zzbf3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbf3.zzb.zzd("gbraid")))) {
                zznv2 = new zznv("_gbraid", zzbf3.zzd, (Object)string, "auto");
                zzng2.zza(zznv2, zzn3);
            }
        }
        this.zza(zzbf2, zzn2);
    }

    @VisibleForTesting
    private final void zza(zzfs.zzj.zza zza2, long l, boolean bl) {
        zznx zznx2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zznx2 = (zznx2 = this.zzf().zze(zza2.zzt(), string)) == null || zznx2.zze == null ? new zznx(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zznx(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zznx2.zze + l));
        zzfs.zzn zzn2 = (zzfs.zzn)((zzju)zzfs.zzn.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza((Long)zznx2.zze).zzah());
        boolean bl2 = false;
        int n = zznt.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzn2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzn2);
        }
        if (l > 0L) {
            this.zzf().zza(zznx2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzp().zza("Updated engagement user property. scope, value", (Object)string2, zznx2.zze);
        }
    }

    final void zzt() {
        ++this.zzt;
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzp().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzp();
            try {
                boolean bl;
                zzf zzf2 = this.zzf().zze(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzf2 == null) {
                    this.zzj().zzu().zza("App does not exist in onConfigFetched. appId", zzgb.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = list != null && !list.isEmpty() ? list.get(0) : null;
                    List<String> list2 = map != null ? map.get("ETag") : null;
                    String string4 = string2 = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string3, string2)) {
                        return;
                    }
                    zzf2.zzd(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzf2);
                    if (n == 404) {
                        this.zzj().zzv().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzp().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab();
                    }
                } else {
                    zzf2.zzm(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzf2);
                    this.zzj().zzp().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzab();
                }
                this.zzf().zzw();
            }
            finally {
                this.zzf().zzu();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzaa();
        }
    }

    final void zza(boolean bl) {
        this.zzab();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string) {
        this.zzl().zzt();
        this.zzs();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (zzoi.zza() && this.zze().zza(zzbh.zzcs) && !bl || (n == 200 || n == 204) && throwable == null) {
                try {
                    if (!zzoi.zza() || !this.zze().zza(zzbh.zzcs) || bl) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zzd.zza(0L);
                    this.zzab();
                    if (!zzoi.zza() || !this.zze().zza(zzbh.zzcs) || bl) {
                        this.zzj().zzp().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else if (zzoi.zza() && this.zze().zza(zzbh.zzcs)) {
                        this.zzj().zzp().zza("Purged empty bundles");
                    }
                    this.zzf().zzp();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzan zzan2 = this.zzf();
                                zzan2.zzt();
                                zzan2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzan2.e_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzan2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzw();
                    }
                    finally {
                        this.zzf().zzu();
                    }
                    this.zzaa = null;
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab = -1L;
                        this.zzab();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzp().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                this.zzj().zzp().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list);
                this.zzab();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    final void zzc(zzn zzn2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.zza);
        if (!zzng.zzh(zzn2)) {
            return;
        }
        zzf zzf2 = this.zzf().zze(zzn2.zza);
        if (zzf2 != null && TextUtils.isEmpty((CharSequence)zzf2.zzah()) && !TextUtils.isEmpty((CharSequence)zzn2.zzb)) {
            zzf2.zzd(0L);
            this.zzf().zza(zzf2);
            this.zzi().zzj(zzn2.zza);
        }
        if (!zzn2.zzh) {
            this.zza(zzn2);
            return;
        }
        long l = zzn2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzm();
        int n = zzn2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzu().zza("Incorrect app type, assuming installed app. appId, appType", zzgb.zza((String)zzn2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzp();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzan zzan2;
            String string2;
            zznv zznv2;
            zznx zznx2 = this.zzf().zze(zzn2.zza, "_npa");
            Boolean bl = this.zzg(zzn2);
            if (zznx2 == null || "auto".equals(zznx2.zzb)) {
                if (bl != null) {
                    zznv2 = new zznv("_npa", l, (Object)(bl != false ? 1L : 0L), "auto");
                    if (zznx2 == null || !zznx2.zze.equals(zznv2.zzc)) {
                        this.zza(zznv2, zzn2);
                    }
                } else if (zznx2 != null) {
                    this.zza("_npa", zzn2);
                }
            }
            long l2 = l;
            zzn zzn3 = zzn2;
            zzng zzng2 = this;
            Object object3 = zzng2.zzf().zze((String)Preconditions.checkNotNull((Object)zzn3.zza));
            if (object3 != null) {
                zzng2.zzq();
                if (zznw.zza((String)zzn3.zzb, (String)((zzf)object3).zzah(), (String)zzn3.zzp, (String)((zzf)object3).zzaa())) {
                    zzng2.zzj().zzu().zza("New GMP App Id passed in. Removing cached database data. appId", zzgb.zza((String)((zzf)object3).zzac()));
                    string2 = ((zzf)object3).zzac();
                    zzan2 = zzng2.zzf();
                    zzan2.zzak();
                    zzan2.zzt();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzan2.e_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzan2.zzj().zzp().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzan2.zzj().zzg().zza("Error deleting application data. appId, error", zzgb.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl2 = ((zzf)object3).zze() != Integer.MIN_VALUE && ((zzf)object3).zze() != zzn3.zzj;
                string = ((zzf)object3).zzaf();
                if (bl2 | (((zzf)object3).zze() == Integer.MIN_VALUE && string != null && !string.equals(zzn3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbf("_au", new zzba(bundle), "auto", l2);
                    zzng2.zza((zzbf)object, zzn3);
                }
            }
            this.zza(zzn2);
            zznv2 = null;
            if (n == 0) {
                zznv2 = this.zzf().zzd(zzn2.zza, "_f");
            } else if (n == 1) {
                zznv2 = this.zzf().zzd(zzn2.zza, "_v");
            }
            if (zznv2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zznv zznv3 = new zznv("_fot", l, (Object)l3, "auto");
                    this.zza(zznv3, zzn2);
                    zzn3 = zzn2;
                    zzng2 = this;
                    zzng2.zzl().zzt();
                    String string3 = zzn3.zza;
                    zzgv zzgv2 = (zzgv)Preconditions.checkNotNull((Object)zzng2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzgv2.zza.zzj().zzw().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzgv2.zza.zzl().zzt();
                        if (!zzgv2.zza()) {
                            zzgv2.zza.zzj().zzn().zza("Install Referrer Reporter is not available");
                        } else {
                            zzgu zzgu2 = new zzgu(zzgv2, string3);
                            object3 = zzgv2;
                            ((zzgv)object3).zza.zzl().zzt();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzgv)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzgv)object3).zza.zzj().zzw().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzan2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzan2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzan2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzan2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzgv)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl3 = ConnectionTracker.getInstance().bindService(((zzgv)object3).zza.zza(), intent, (ServiceConnection)zzgu2, 1);
                                                ((zzgv)object3).zza.zzj().zzp().zza("Install Referrer Service is", (Object)(bl3 ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzgv)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzgv)object3).zza.zzj().zzu().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzgv)object3).zza.zzj().zzn().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzn3 = zzn2;
                    zzng2 = this;
                    zzng2.zzl().zzt();
                    zzng2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzn3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzn3.zza);
                    object2 = string4;
                    zzan zzan3 = zzng2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzan3.zzt();
                    zzan3.zzak();
                    long l5 = zzan3.zzb((String)object2, "first_open_count");
                    if (zzng2.zzm.zza().getPackageManager() == null) {
                        zzng2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzgb.zza((String)string4));
                    } else {
                        zzan2 = null;
                        try {
                            zzan2 = Wrappers.packageManager((Context)zzng2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzng2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzgb.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzan2 != null && ((PackageInfo)zzan2).firstInstallTime != 0L) {
                            boolean bl4 = false;
                            if (((PackageInfo)zzan2).firstInstallTime != ((PackageInfo)zzan2).lastUpdateTime) {
                                if (zzng2.zze().zza(zzbh.zzbl)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl4 = true;
                            }
                            sQLiteDatabase = new zznv("_fi", l4, (Object)(bl4 ? 1L : 0L), "auto");
                            zzng2.zza((zznv)sQLiteDatabase, zzn3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzng2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzng2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzgb.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzan2 = new zzbf("_f", new zzba((Bundle)object3), "auto", l4);
                    zzng2.zzb((zzbf)zzan2, zzn3);
                } else if (n == 1) {
                    zznv zznv4 = new zznv("_fvt", l, (Object)l3, "auto");
                    this.zza(zznv4, zzn2);
                    l2 = l;
                    zzn3 = zzn2;
                    zzng2 = this;
                    zzng2.zzl().zzt();
                    zzng2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzn3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbf zzbf2 = new zzbf("_v", new zzba((Bundle)object3), "auto", l2);
                    zzng2.zzb(zzbf2, zzn3);
                }
            } else if (zzn2.zzi) {
                l2 = l;
                zzn3 = zzn2;
                zzng2 = this;
                object3 = new Bundle();
                zzbf zzbf3 = new zzbf("_cd", new zzba((Bundle)object3), "auto", l2);
                zzng2.zzb(zzbf3, zzn3);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    final void zzu() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzac zzac2) {
        zzn zzn2 = this.zzc((String)Preconditions.checkNotNull((Object)zzac2.zza));
        if (zzn2 != null) {
            this.zza(zzac2, zzn2);
        }
    }

    @WorkerThread
    final void zza(zzac zzac2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzac2);
        Preconditions.checkNotEmpty((String)zzac2.zza);
        Preconditions.checkNotNull((Object)zzac2.zzc);
        Preconditions.checkNotEmpty((String)zzac2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zzng.zzh(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zza(zzn2);
            return;
        }
        this.zzf().zzp();
        try {
            this.zza(zzn2);
            String string = (String)Preconditions.checkNotNull((Object)zzac2.zza);
            zzac zzac3 = this.zzf().zzc(string, zzac2.zzc.zza);
            if (zzac3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzac2.zza, (Object)this.zzm.zzk().zzc(zzac2.zzc.zza));
                this.zzf().zza(string, zzac2.zzc.zza);
                if (zzac3.zze) {
                    this.zzf().zzh(string, zzac2.zzc.zza);
                }
                if (zzac2.zzk != null) {
                    Bundle bundle = null;
                    if (zzac2.zzk.zzb != null) {
                        bundle = zzac2.zzk.zzb.zzb();
                    }
                    zzbf zzbf2 = this.zzq().zza(string, ((zzbf)Preconditions.checkNotNull((Object)zzac2.zzk)).zza, bundle, zzac3.zzb, zzac2.zzk.zzd, true, true);
                    this.zzc((zzbf)Preconditions.checkNotNull((Object)zzbf2), zzn2);
                }
            } else {
                this.zzj().zzu().zza("Conditional user property doesn't exist", zzgb.zza((String)zzac2.zza), (Object)this.zzm.zzk().zzc(zzac2.zzc.zza));
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting
    private static void zza(zzfs.zze.zza zza2, @NonNull String string) {
        List<zzfs.zzg> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzn zzn2) {
        this.zzl().zzt();
        this.zzs();
        if (!zzng.zzh(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zza(zzn2);
            return;
        }
        Boolean bl = this.zzg(zzn2);
        if ("_npa".equals(string) && bl != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zznv zznv2 = new zznv("_npa", this.zzb().currentTimeMillis(), (Object)(bl != false ? 1L : 0L), "auto");
            this.zza(zznv2, zzn2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzp();
        try {
            this.zza(zzn2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzn2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzn2.zza), string);
            this.zzf().zzw();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zzd(zzn zzn2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzn2.zza);
        zzan zzan2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzan2.zzt();
        zzan2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzan2.e_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray);
            if (n > 0) {
                zzan2.zzj().zzp().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzan2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzgb.zza((String)string), (Object)sQLiteException);
        }
        if (zzn2.zzh) {
            this.zzc(zzn2);
        }
    }

    @WorkerThread
    final void zze(zzn zzn2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzn2.zza);
        zzax zzax2 = zzax.zza((String)zzn2.zzz);
        this.zzj().zzp().zza("Setting DMA consent. package, consent", (Object)zzn2.zza, (Object)zzax2);
        this.zza(zzn2.zza, zzax2);
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzkx zzkx2) {
        this.zzl().zzt();
        if (this.zzag == null || this.zzag.equals(string) || zzkx2 != null) {
            this.zzag = string;
            this.zzaf = zzkx2;
        }
    }

    @WorkerThread
    final void zzf(zzn zzn2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzn2.zza);
        int n = zzn2.zzy;
        zzis zzis2 = zzis.zza((String)zzn2.zzt, (int)n);
        zzis zzis3 = this.zzb(zzn2.zza);
        this.zzj().zzp().zza("Setting consent, package, consent", (Object)zzn2.zza, (Object)zzis2);
        this.zza(zzn2.zza, zzis2);
        if (!(zzod.zza() && this.zze().zza(zzbh.zzdg) || !zzis2.zzc(zzis3))) {
            this.zzd(zzn2);
        }
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzv() {
        this.zzl().zzt();
        this.zzf().zzv();
        if (this.zzj.zzc.zza() == 0L) {
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzab();
    }

    @WorkerThread
    final void zzb(zzac zzac2) {
        zzn zzn2 = this.zzc((String)Preconditions.checkNotNull((Object)zzac2.zza));
        if (zzn2 != null) {
            this.zzb(zzac2, zzn2);
        }
    }

    @WorkerThread
    final void zzb(zzac zzac2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzac2);
        Preconditions.checkNotEmpty((String)zzac2.zza);
        Preconditions.checkNotNull((Object)zzac2.zzb);
        Preconditions.checkNotNull((Object)zzac2.zzc);
        Preconditions.checkNotEmpty((String)zzac2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zzng.zzh(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zza(zzn2);
            return;
        }
        zzac zzac3 = new zzac(zzac2);
        new zzac(zzac2).zze = false;
        this.zzf().zzp();
        try {
            boolean bl = false;
            zzac zzac4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzac3.zza), zzac3.zzc.zza);
            if (zzac4 != null && !zzac4.zzb.equals(zzac3.zzb)) {
                this.zzj().zzu().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzac3.zzc.zza), (Object)zzac3.zzb, (Object)zzac4.zzb);
            }
            if (zzac4 != null && zzac4.zze) {
                zzac3.zzb = zzac4.zzb;
                zzac3.zzd = zzac4.zzd;
                zzac3.zzh = zzac4.zzh;
                zzac3.zzf = zzac4.zzf;
                zzac3.zzi = zzac4.zzi;
                zzac3.zze = zzac4.zze;
                zzac3.zzc = new zznv(zzac3.zzc.zza, zzac4.zzc.zzb, zzac3.zzc.zza(), zzac4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzac3.zzf)) {
                zzac3.zzc = new zznv(zzac3.zzc.zza, zzac3.zzd, zzac3.zzc.zza(), zzac3.zzc.zze);
                zzac3.zze = true;
                bl = true;
            }
            if (zzac3.zze) {
                zznv zznv2 = zzac3.zzc;
                zznx zznx2 = new zznx((String)Preconditions.checkNotNull((Object)zzac3.zza), zzac3.zzb, zznv2.zza, zznv2.zzb, Preconditions.checkNotNull((Object)zznv2.zza()));
                if (this.zzf().zza(zznx2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzac3.zza, (Object)this.zzm.zzk().zzc(zznx2.zzc), zznx2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzgb.zza((String)zzac3.zza), (Object)this.zzm.zzk().zzc(zznx2.zzc), zznx2.zze);
                }
                if (bl && zzac3.zzi != null) {
                    zzbf zzbf2 = new zzbf(zzac3.zzi, zzac3.zzd);
                    this.zzc(zzbf2, zzn2);
                }
            }
            if (this.zzf().zza(zzac3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzac3.zza, (Object)this.zzm.zzk().zzc(zzac3.zzc.zza), zzac3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzgb.zza((String)zzac3.zza), (Object)this.zzm.zzk().zzc(zzac3.zzc.zza), zzac3.zzc.zza());
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(String string, zzis zzis2) {
        this.zzl().zzt();
        this.zzs();
        this.zzac.put(string, zzis2);
        this.zzf().zza(string, zzis2);
    }

    @WorkerThread
    final void zza(String string, zzax zzax2) {
        this.zzl().zzt();
        this.zzs();
        if (zzoo.zza() && this.zze().zza(zzbh.zzcr)) {
            zzir zzir2;
            zzir zzir3 = zzax.zza((Bundle)this.zza(string), (int)100).zzc();
            this.zzad.put(string, zzax2);
            this.zzf().zza(string, zzax2);
            zzir zzir4 = zzir2 = zzax.zza((Bundle)this.zza(string), (int)100).zzc();
            zzir zzir5 = zzir3;
            String string2 = string;
            zzng zzng2 = this;
            zzng2.zzl().zzt();
            zzng2.zzs();
            if (zzir5 == zzir.zzc && zzir4 == zzir.zzd) {
                zzng2.zzj().zzp().zza("Generated _dcu event for", (Object)string2);
                Bundle bundle = new Bundle();
                if (zzng2.zzf().zza((long)zzng2.zzx(), (String)string2, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzf < (long)zzng2.zze().zzb(string2, zzbh.zzaw)) {
                    bundle.putLong("_r", 1L);
                    zzao zzao2 = zzng2.zzf().zza(zzng2.zzx(), string2, false, false, false, false, false, true);
                    zzng2.zzj().zzp().zza("_dcu realtime event count", (Object)string2, (Object)zzao2.zzf);
                }
                zzng2.zzah.zza(string2, "_dcu", bundle);
            }
            return;
        }
        this.zzad.put(string, zzax2);
        this.zzf().zza(string, zzax2);
    }

    @WorkerThread
    private final void zzab() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzt();
            this.zzs();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzp().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzy().zzb();
                    this.zzz().zzu();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzaf() || !this.zzac()) {
                this.zzj().zzp().zza("Nothing to upload or uploading impossible");
                this.zzy().zzb();
                this.zzz().zzu();
                return;
            }
            zzng zzng2 = this;
            long l5 = zzng2.zzb().currentTimeMillis();
            zzng2.zze();
            long l6 = Math.max(0L, (Long)zzbh.zzaa.zza(null));
            boolean bl = zzng2.zzf().zzz() || zzng2.zzf().zzy();
            if (bl) {
                String string = zzng2.zze().zzn();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zzng2.zze();
                    l4 = Math.max(0L, (Long)zzbh.zzv.zza(null));
                } else {
                    zzng2.zze();
                    l4 = Math.max(0L, (Long)zzbh.zzu.zza(null));
                }
            } else {
                zzng2.zze();
                l4 = Math.max(0L, (Long)zzbh.zzt.zza(null));
            }
            long l7 = zzng2.zzj.zzc.zza();
            long l8 = zzng2.zzj.zzd.zza();
            long l9 = zzng2.zzf().c_();
            long l10 = zzng2.zzf().d_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zzng2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zzng2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbh.zzac.zza(null)))) break;
                        long l15 = 1L << n;
                        zzng2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbh.zzab.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzp().zza("Next upload time is 0");
            this.zzy().zzb();
            this.zzz().zzu();
            return;
        }
        if (!this.zzh().zzu()) {
            this.zzj().zzp().zza("No network");
            this.zzy().zza();
            this.zzz().zzu();
            return;
        }
        l2 = this.zzj.zzb.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbh.zzr.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzy().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbh.zzw.zza(null));
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzp().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzz().zza(l17);
    }

    @WorkerThread
    private final void zza(String string, boolean bl, @Nullable Long l, @Nullable Long l2) {
        zzf zzf2 = this.zzf().zze(string);
        if (zzf2 != null) {
            zzf2.zzd(bl);
            zzf2.zza(l);
            zzf2.zzb(l2);
            if (zzf2.zzas()) {
                this.zzf().zza(zzf2);
            }
        }
    }

    @WorkerThread
    final void zza(zznv zznv2, zzn zzn2) {
        this.zzl().zzt();
        this.zzs();
        if (!zzng.zzh(zzn2)) {
            return;
        }
        if (!zzn2.zzh) {
            this.zza(zzn2);
            return;
        }
        int n = this.zzq().zzb(zznv2.zza);
        if (n != 0) {
            this.zzq();
            String string = zznv2.zza;
            this.zze();
            String string2 = zznw.zza((String)string, (int)24, (boolean)true);
            int n2 = zznv2.zza != null ? zznv2.zza.length() : 0;
            this.zzq();
            zznw.zza((zzny)this.zzah, (String)zzn2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zznv2.zza, zznv2.zza());
        if (n != 0) {
            this.zzq();
            String string = zznv2.zza;
            this.zze();
            String string3 = zznw.zza((String)string, (int)24, (boolean)true);
            Object object = zznv2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zznw.zza((zzny)this.zzah, (String)zzn2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zznv2.zza, zznv2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zznv2.zza)) {
            zzbb zzbb2;
            zzn zzn3 = zzn2;
            String string = zznv2.zze;
            long l = zznv2.zzb;
            zzng zzng2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzn3.zza);
            long l2 = 0L;
            zznx zznx2 = zzng2.zzf().zze(string4, "_sno");
            if (zznx2 != null && zznx2.zze instanceof Long) {
                l2 = (Long)zznx2.zze;
            } else {
                if (zznx2 != null) {
                    zzng2.zzj().zzu().zza("Retrieved last session number from database does not contain a valid (long) value", zznx2.zze);
                }
                if ((zzbb2 = zzng2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzbb2.zzc;
                    zzng2.zzj().zzp().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzbb2 = new zznv("_sno", l, (Object)(++l2), string);
            zzng2.zza((zznv)zzbb2, zzn3);
        }
        zznx zznx3 = new zznx((String)Preconditions.checkNotNull((Object)zzn2.zza), (String)Preconditions.checkNotNull((Object)zznv2.zze), zznv2.zza, zznv2.zzb, object);
        this.zzj().zzp().zza("Setting user property", (Object)this.zzm.zzk().zzc(zznx3.zzc), object, (Object)zznx3.zzb);
        this.zzf().zzp();
        try {
            zznx zznx4;
            if ("_id".equals(zznx3.zzc) && (zznx4 = this.zzf().zze(zzn2.zza, "_id")) != null && !zznx3.zze.equals(zznx4.zze)) {
                this.zzf().zzh(zzn2.zza, "_lair");
            }
            this.zza(zzn2);
            boolean bl = this.zzf().zza(zznx3);
            if ("_sid".equals(zznv2.zza)) {
                long l = this.zzp().zza(zzn2.zzv);
                zzf zzf2 = this.zzf().zze(zzn2.zza);
                if (zzf2 != null) {
                    zzf2.zzs(l);
                    if (zzf2.zzas()) {
                        this.zzf().zza(zzf2);
                    }
                }
            }
            this.zzf().zzw();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zznx3.zzc), zznx3.zze);
                this.zzq();
                zznw.zza((zzny)this.zzah, (String)zzn2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zzw() {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzr().zzab();
            if (bl == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzab();
                return;
            }
            zziq zziq2 = this;
            zziq2.zzl().zzt();
            if (zziq2.zzz != null) {
                this.zzj().zzp().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzab();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbh.zzas);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzae.zzh();
            for (int i = 0; i < n && this.zza(null, l2 = l4); ++i) {
            }
            if (zzpz.zza()) {
                zziq2 = this;
                zziq2.zzl().zzt();
                for (String object7 : zziq2.zzr) {
                    if (!zzpz.zza() || !zziq2.zze().zze(object7, zzbh.zzcg)) continue;
                    zziq2.zzj().zzc().zza("Notifying app that trigger URIs are available. App ID", (Object)object7);
                    Intent intent = new Intent();
                    intent.setAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
                    intent.setPackage(object7);
                    zziq2.zzm.zza().sendBroadcast(intent);
                }
                zziq2.zzr.clear();
            }
            if ((l = this.zzj.zzc.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().f_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().b_();
                }
                int n2 = this.zze().zzb(string, zzbh.zzg);
                Object object = string;
                zziq2 = this.zze();
                int n3 = Math.max(0, zziq2.zzb((String)object, zzbh.zzh));
                List<Pair<zzfs.zzj, Long>> list = this.zzf().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    if (this.zzb(string).zzi()) {
                        object6 = null;
                        Iterator<Pair<zzfs.zzj, Long>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            zzfs.zzj zzj2 = (zzfs.zzj)((Object)iterator.next().first);
                            if (zzj2.zzam().isEmpty()) continue;
                            object6 = zzj2.zzam();
                            break;
                        }
                        if (object6 != null) {
                            for (int i = 0; i < list.size(); ++i) {
                                object5 = (zzfs.zzj)((Object)list.get((int)i).first);
                                if (((zzfs.zzj)((Object)object5)).zzam().isEmpty() || ((zzfs.zzj)((Object)object5)).zzam().equals(object6)) continue;
                                list = list.subList(0, i);
                                break;
                            }
                        }
                    }
                    object6 = zzfs.zzi.zzb();
                    int n4 = list.size();
                    object5 = new ArrayList(list.size());
                    boolean bl2 = this.zze().zzk(string) && this.zzb(string).zzi();
                    boolean bl3 = this.zzb(string).zzi();
                    boolean bl4 = this.zzb(string).zzj();
                    boolean bl5 = zzql.zza() && this.zze().zze(string, zzbh.zzbs);
                    Pair<zznh, Boolean> pair = this.zzk.zzb(string);
                    boolean bl6 = (Boolean)pair.second;
                    if (zzqw.zza() && this.zze().zza(zzbh.zzbt)) {
                        this.zzq();
                        if (zznw.zzf((String)string)) {
                            String string2 = this.zzi().zzf(string);
                            if (!bl6 && !TextUtils.isEmpty((CharSequence)string2)) {
                                ((zzfs.zzi.zza)((Object)object6)).zza(string2);
                            }
                        }
                    }
                    for (int i = 0; i < n4; ++i) {
                        object4 = (zzfs.zzj.zza)((zzfs.zzj)((Object)list.get((int)i).first)).zzca();
                        object5.add((Long)list.get((int)i).second);
                        this.zze();
                        ((zzfs.zzj.zza)((Object)object4)).zzl(88000L).zzk(l3).zzd(false);
                        if (!bl2) {
                            ((zzfs.zzj.zza)((Object)object4)).zzj();
                        }
                        if (!bl3) {
                            ((zzfs.zzj.zza)((Object)object4)).zzq();
                            ((zzfs.zzj.zza)((Object)object4)).zzm();
                        }
                        if (!bl4) {
                            ((zzfs.zzj.zza)((Object)object4)).zzg();
                        }
                        this.zza(string, (zzfs.zzj.zza)((Object)object4));
                        if (!bl5) {
                            ((zzfs.zzj.zza)((Object)object4)).zzr();
                        }
                        if (zzoi.zza() && this.zze().zza(zzbh.zzcs)) {
                            object = object4;
                            zziq2 = this;
                            String string3 = ((zzfs.zzj.zza)((Object)object)).zzz();
                            boolean bl7 = false;
                            if (TextUtils.isEmpty((CharSequence)string3) || string3.equals("00000000-0000-0000-0000-000000000000")) {
                                object3 = new ArrayList<zzfs.zze>(((zzfs.zzj.zza)((Object)object)).zzaa());
                                boolean bl8 = false;
                                Iterator iterator = object3.iterator();
                                Long l5 = null;
                                Long l6 = null;
                                while (iterator.hasNext()) {
                                    zzfs.zze zze2 = (zzfs.zze)((Object)iterator.next());
                                    if ("_fx".equals(zze2.zzg())) {
                                        bl7 = true;
                                        iterator.remove();
                                        bl8 = true;
                                        continue;
                                    }
                                    if (!"_f".equals(zze2.zzg())) continue;
                                    bl7 = true;
                                    if (!zziq2.zze().zza(zzbh.zzdd)) continue;
                                    zziq2.zzp();
                                    zzfs.zzg zzg2 = zznt.zza(zze2, "_pfo");
                                    if (zzg2 != null) {
                                        l5 = zzg2.zzd();
                                    }
                                    zziq2.zzp();
                                    zzfs.zzg zzg3 = zznt.zza(zze2, "_uwa");
                                    if (zzg3 == null) continue;
                                    l6 = zzg3.zzd();
                                }
                                if (bl8) {
                                    ((zzfs.zzj.zza)((Object)object)).zzk();
                                    ((zzfs.zzj.zza)((Object)object)).zzb((Iterable<? extends zzfs.zze>)object3);
                                }
                                if (bl7) {
                                    super.zza(((zzfs.zzj.zza)((Object)object)).zzt(), true, l5, l6);
                                }
                            }
                            if (((zzfs.zzj.zza)((Object)object4)).zzc() == 0) continue;
                        }
                        if (this.zze().zze(string, zzbh.zzbf)) {
                            object2 = ((zzfs.zzj)((zzju)object4.zzah())).zzbx();
                            ((zzfs.zzj.zza)((Object)object4)).zza(this.zzp().zza((byte[])object2));
                        }
                        if (zzqw.zza() && this.zze().zza(zzbh.zzbt)) {
                            this.zzq();
                            if (zznw.zzf((String)string) && !bl6) {
                                ((zzfs.zzj.zza)((Object)object4)).zzj();
                            }
                        }
                        ((zzfs.zzi.zza)((Object)object6)).zza((zzfs.zzj.zza)((Object)object4));
                    }
                    if (zzoi.zza() && this.zze().zza(zzbh.zzcs) && ((zzfs.zzi.zza)((Object)object6)).zza() == 0) {
                        this.zza((List<Long>)object5);
                        this.zza(false, 204, null, null, string);
                        return;
                    }
                    String string4 = null;
                    if (this.zzj().zza(2)) {
                        string4 = this.zzp().zza((zzfs.zzi)((zzju)object6.zzah()));
                    }
                    this.zzp();
                    object4 = ((zzfs.zzi)((zzju)object6.zzah())).zzbx();
                    try {
                        this.zza((List<Long>)object5);
                        this.zzj.zzd.zza(l3);
                        object2 = "?";
                        if (n4 > 0) {
                            object2 = ((zzfs.zzi.zza)((Object)object6)).zza(0).zzy();
                        }
                        this.zzj().zzp().zza("Uploading data. app, uncompressed size, data", object2, (Object)((Object)object4).length, (Object)string4);
                        this.zzv = true;
                        zzni zzni2 = new zzni(this, string);
                        object3 = ((zznh)pair.first).zzb();
                        Object object7 = object4;
                        URL uRL = new URL(((zznh)pair.first).zza());
                        object = string;
                        zziq2 = this.zzh();
                        zziq2.zzt();
                        zziq2.zzak();
                        Preconditions.checkNotNull((Object)uRL);
                        Preconditions.checkNotNull((Object)object7);
                        Preconditions.checkNotNull((Object)zzni2);
                        zziq2.zzl().zza((Runnable)new zzgi((zzge)zziq2, (String)object, uRL, (byte[])object7, (Map)object3, zzni2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj().zzg().zza("Failed to parse upload URL. Not uploading. appId", zzgb.zza((String)string), (Object)((zznh)pair.first).zza());
                    }
                }
            } else {
                zzf zzf2;
                this.zzab = -1L;
                zzan zzan2 = this.zzf();
                this.zze();
                String string5 = zzan2.zza(l3 - com.google.android.gms.measurement.internal.zzae.zzh());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzf2 = this.zzf().zze(string5)) != null) {
                    this.zzb(zzf2);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    @VisibleForTesting
    private final void zza(String string, zzfs.zzg.zza zza2, Bundle bundle, @Nullable String string2) {
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        long l = zznw.zzg((String)zza2.zzf()) || zznw.zzg((String)string) ? (long)this.zze().zzb(string2, true) : (long)this.zze().zza(string2, true);
        long l2 = zza2.zzg().codePointCount(0, zza2.zzg().length());
        this.zzq();
        String string3 = zza2.zzf();
        this.zze();
        String string4 = zznw.zza((String)string3, (int)40, (boolean)true);
        if (l2 > l && !list.contains(zza2.zzf())) {
            if ("_ev".equals(zza2.zzf())) {
                this.zzq();
                String string5 = zznw.zza((String)zza2.zzg(), (int)this.zze().zzb(string2, true), (boolean)true);
                bundle.putString("_ev", string5);
                return;
            }
            this.zzj().zzv().zza("Param value is too long; discarded. Name, value length", (Object)string4, (Object)l2);
            if (bundle.getLong("_err") == 0L) {
                bundle.putLong("_err", 4L);
                if (bundle.getString("_ev") == null) {
                    bundle.putString("_ev", string4);
                    bundle.putLong("_el", l2);
                }
            }
            bundle.remove(zza2.zzf());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbf var1_1, zzn var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzt();
        this.zzs();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zznt.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzu().zza("Dropping blocked event. appId", zzgb.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzm(var5_4) != false || this.zzi().zzo(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zznw.zza((zzny)this.zzah, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zze(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzp(), var7_7.zzg());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbh.zzz.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzgf.zza((zzbf)var1_1);
        this.zzq().zza(var6_6, this.zze().zzb(var5_4));
        var7_8 = zzpn.zza() != false && this.zze().zza(zzbh.zzce) != false ? this.zze().zza(var5_4, zzbh.zzaq, 10, 35) : 0;
        for (String var10_12 : new TreeSet<E>(var6_6.zzb.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzb.getParcelableArray(var10_12), var7_8, zzpn.zza() != false && this.zze().zza(zzbh.zzce) != false);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzp().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        if (zzph.zza()) {
            this.zze().zza(zzbh.zzcb);
        }
        this.zzf().zzp();
        try {
            block74: {
                block75: {
                    block77: {
                        block81: {
                            block80: {
                                block78: {
                                    block79: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block77;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block78;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block79;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block80;
                                    }
                                    var25_19.zzj().zzu().zza("Data lost. Currency value is too big. appId", zzgb.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block81;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + (String)var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbh.zzae) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzt();
                                    var41_32.zzak();
                                    try {
                                        var41_32.e_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_33) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzgb.zza((String)var42_31), (Object)var44_33);
                                    }
                                    var33_29 = new zznx(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_34 = (Long)var33_29.zze;
                                    var33_29 = new zznx(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_34 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zznx)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzgb.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zznw.zza((zzny)var25_19.zzah, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var11_38 = zznw.zzh((String)var1_1.zza);
                    var12_39 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_40 = 1L + zznw.zza((zzba)var1_1.zzb);
                    var15_41 = this.zzf().zza(this.zzx(), var5_4, var13_40, true, var11_38, false, var12_39, false, false);
                    v2 = var15_41.zzb;
                    this.zze();
                    var16_42 = v2 - (long)((Integer)zzbh.zzk.zza(null)).intValue();
                    if (var16_42 > 0L) {
                        if (var16_42 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzgb.zza((String)var5_4), (Object)var15_41.zzb);
                        }
                        this.zzf().zzw();
                        return;
                    }
                    if (var11_38) {
                        v3 = var15_41.zza;
                        this.zze();
                        var16_42 = v3 - (long)((Integer)zzbh.zzm.zza(null)).intValue();
                        if (var16_42 > 0L) {
                            if (var16_42 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzgb.zza((String)var5_4), (Object)var15_41.zza);
                            }
                            this.zzq();
                            zznw.zza((zzny)this.zzah, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzw();
                            return;
                        }
                    }
                    if (var12_39) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbh.zzl);
                        var16_42 = var15_41.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_42 > 0L) {
                            if (var16_42 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzgb.zza((String)var5_4), (Object)var15_41.zzd);
                            }
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var18_43 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_43, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzd(var5_4, var2_2.zzac)) {
                        this.zzq().zza(var18_43, "_dbg", (Object)1L);
                        this.zzq().zza(var18_43, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_44 = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_44.zze instanceof Long) {
                        this.zzq().zza(var18_43, "_sno", var19_44.zze);
                    }
                    if ((var19_45 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzu().zza("Data lost. Too many events stored on disk, deleted. appId", zzgb.zza((String)var5_4), (Object)var19_45);
                    }
                    var21_46 = new zzay(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_43);
                    var22_47 = this.zzf().zzd(var5_4, var21_46.zzb);
                    if (var22_47 == null) {
                        if (this.zzf().zzc(var5_4) >= (long)this.zze().zza(var5_4) && var11_38) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzgb.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_46.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zznw.zza((zzny)this.zzah, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_48 = new zzbb(var5_4, var21_46.zzb, 0L, 0L, var21_46.zzc, 0L, null, null, null, null);
                    } else {
                        var21_46 = var21_46.zza(this.zzm, var22_47.zzf);
                        var23_48 = var22_47.zza(var21_46.zzc);
                    }
                    this.zzf().zza(var23_48);
                    var27_17 = var2_2;
                    var26_18 = var21_46;
                    var25_19 = this;
                    var25_19.zzl().zzt();
                    var25_19.zzs();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzfs.zzj.zzv().zzh(1).zzp("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (zzql.zza() && !TextUtils.isEmpty((CharSequence)var27_17.zzv) && (var25_19.zze().zza(zzbh.zzbq) || var25_19.zze().zze(var27_17.zza, zzbh.zzbs))) {
                        var28_14.zzr(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzf(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzm(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzis.zzb((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zzg());
                    if (var28_14.zzx().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (zzpz.zza() && var25_19.zze().zze(var27_17.zza, zzbh.zzcg)) {
                        var25_19.zzq();
                        if (zznw.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var29_20.zzi() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_49 = var30_25;
                                var40_51 /* !! */  = zzfs.zzb.zza();
                                var40_51 /* !! */ .zzc((var37_49 & 1L) != 0L);
                                var40_51 /* !! */ .zze((var37_49 & 2L) != 0L);
                                var40_51 /* !! */ .zzf((var37_49 & 4L) != 0L);
                                var40_51 /* !! */ .zzg((var37_49 & 8L) != 0L);
                                var40_51 /* !! */ .zzb((var37_49 & 16L) != 0L);
                                var40_51 /* !! */ .zza((var37_49 & 32L) != 0L);
                                var40_51 /* !! */ .zzd((var37_49 & 64L) != 0L);
                                var28_14.zza((zzfs.zzb)((zzju)var40_51 /* !! */ .zzah()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzc(var27_17.zzf);
                    }
                    var28_14.zzd(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzu();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if ((var31_52 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzis.zzb((String)var27_17.zzt))).zzi() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_52)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzq((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc((Boolean)var32_23.second);
                        }
                        if (zzoi.zza() && var25_19.zze().zza(zzbh.zzcs) && !var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zze(var27_17.zza)) != null && var33_29.zzau()) {
                            var25_19.zza(var27_17.zza, false, null, null);
                            var34_35 = new Bundle();
                            if (var25_19.zze().zza(zzbh.zzdd)) {
                                var35_53 = var33_29.zzy();
                                if (var35_53 != null) {
                                    var34_35.putLong("_pfo", Math.max(0L, var35_53.longValue()));
                                }
                                if ((var36_27 = var33_29.zzz()) != null) {
                                    var34_35.putLong("_uwa", var36_27.longValue());
                                }
                            } else if (var25_19.zze().zza(zzbh.zzdc)) {
                                var35_54 = var25_19.zzf().zzb(var27_17.zza) - 1L;
                                var34_35.putLong("_pfo", Math.max(0L, var35_54));
                            }
                            var34_35.putLong("_r", 1L);
                            var25_19.zzah.zza(var27_17.zza, "_fx", var34_35);
                        }
                    }
                    var25_19.zzm.zzg().zzac();
                    v4 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzac();
                    v4.zzo(Build.VERSION.RELEASE).zzj((int)var25_19.zzm.zzg().zzg()).zzs(var25_19.zzm.zzg().zzh());
                    var28_14.zzj(var27_17.zzx);
                    if (var25_19.zzm.zzac()) {
                        var28_14.zzt();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zze(var27_17.zza)) == null) {
                        var32_24 = new zzf(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_52));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_52.zzi()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzq(0L);
                        var32_24.zzr(0L);
                        var32_24.zzp(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zzb(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzn(var27_17.zze);
                        var32_24.zzk(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzl(var27_17.zzr);
                        var25_19.zzf().zza(var32_24);
                    }
                    if (var31_52.zzj() && !TextUtils.isEmpty((CharSequence)var32_24.zzad())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzad()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzag())) {
                        var28_14.zzl((String)Preconditions.checkNotNull((Object)var32_24.zzag()));
                    }
                    var33_29 = var25_19.zzf().zzj(var27_17.zza);
                    for (var34_36 = 0; var34_36 < var33_29.size(); ++var34_36) {
                        var35_53 = zzfs.zzn.zze().zza(((zznx)var33_29.get((int)var34_36)).zzc).zzb(((zznx)var33_29.get((int)var34_36)).zzd);
                        var25_19.zzp().zza((zzfs.zzn.zza)var35_53, ((zznx)var33_29.get((int)var34_36)).zze);
                        var28_14.zza((zzfs.zzn.zza)var35_53);
                        if (!"_sid".equals(((zznx)var33_29.get((int)var34_36)).zzc) || var32_24.zzv() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzv()) continue;
                        var28_14.zzr();
                    }
                    try {
                        var34_37 = var25_19.zzf().zza((zzfs.zzj)((zzju)var28_14.zzah()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzgb.zza((String)var28_14.zzt()), (Object)var36_28);
                        break block74;
                    }
                    v5 = var25_19.zzf();
                    var38_55 = var26_18;
                    var37_50 = var25_19;
                    if (var38_55.zze == null) ** GOTO lbl-1000
                    for (zzfs.zzb.zza var40_51 : var38_55.zze) {
                        if (!"_r".equals((Object)var40_51 /* !! */ )) continue;
                        v6 = true;
                        break block75;
                    }
                    var39_57 = var37_50.zzi().zzc(var38_55.zza, var38_55.zzb);
                    var40_51 /* !! */  = var37_50.zzf().zza(var37_50.zzx(), var38_55.zza, false, false, false, false, false, false);
                    if (var39_57 && var40_51 /* !! */ .zze < (long)var37_50.zze().zzc(var38_55.zza)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                }
                if (v5.zza((zzay)var26_18, var34_37, v6)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzw();
        }
        finally {
            this.zzf().zzu();
        }
        this.zzab();
        this.zzj().zzp().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zzh(zzn zzn2) {
        return !TextUtils.isEmpty((CharSequence)zzn2.zzb) || !TextUtils.isEmpty((CharSequence)zzn2.zzp);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @WorkerThread
    private final boolean zza(@Nullable String var1_1, long var2_2) {
        this.zzf().zzp();
        try {
            block159: {
                block163: {
                    block162: {
                        block157: {
                            var4_3 = new zza(null);
                            var34_4 = var4_3;
                            var32_6 = this.zzab;
                            var30_12 = var2_2;
                            var29_19 /* !! */  = null;
                            var28_20 = this.zzf();
                            Preconditions.checkNotNull((Object)var34_4);
                            var28_20.zzt();
                            var28_20.zzak();
                            var35_21 = null;
                            try {
                                var36_27 /* !! */  = var28_20.e_();
                                if (TextUtils.isEmpty(null)) {
                                    var38_33 = var32_6 != -1L ? new String[]{String.valueOf(var32_6), String.valueOf(var30_12)} : new String[]{String.valueOf(var30_12)};
                                    var47_35 = var32_6 != -1L ? "rowid <= ? and " : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select app_id, metadata_fingerprint from raw_events where " + var47_35 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block157;
                                    var29_19 /* !! */  = var35_21.getString(0);
                                    var37_36 = var35_21.getString(1);
                                    var35_21.close();
                                } else {
                                    var38_33 = var32_6 != -1L ? new String[]{null, String.valueOf(var32_6)} : new String[]{null};
                                    var47_35 = var32_6 != -1L ? " and rowid <= ?" : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + var47_35 + " order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block157;
                                    var37_36 = var35_21.getString(0);
                                    var35_21.close();
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{var29_19 /* !! */ , var37_36}, null, null, "rowid", "2");
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzg().zza("Raw event metadata record is missing. appId", zzgb.zza((String)var29_19 /* !! */ ));
                                    break block157;
                                }
                                var38_33 = var35_21.getBlob(0);
                                try {
                                    var39_37 /* !! */  = (zzfs.zzj)((zzju)zznt.zza(zzfs.zzj.zzv(), (byte[])var38_33).zzah());
                                }
                                catch (IOException var40_38) {
                                    var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzgb.zza((String)var29_19 /* !! */ ), (Object)var40_38);
                                    if (var35_21 != null) {
                                        var35_21.close();
                                    }
                                    break block157;
                                }
                                if (var35_21.moveToNext()) {
                                    var28_20.zzj().zzu().zza("Get multiple raw event metadata records, expected one. appId", zzgb.zza((String)var29_19 /* !! */ ));
                                }
                                var35_21.close();
                                var34_4.zza(var39_37 /* !! */ );
                                if (var32_6 != -1L) {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                                    var41_41 = new String[]{var29_19 /* !! */ , var37_36, String.valueOf(var32_6)};
                                } else {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ?";
                                    var41_41 = new String[]{var29_19 /* !! */ , var37_36};
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, var40_39, var41_41, null, null, "rowid", null);
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzu().zza("Raw event data disappeared while in transaction. appId", zzgb.zza((String)var29_19 /* !! */ ));
                                    break block157;
                                }
                                do {
                                    var42_42 = var35_21.getLong(0);
                                    var38_33 = var35_21.getBlob(3);
                                    try {
                                        var44_44 = zznt.zza(zzfs.zze.zze(), (byte[])var38_33);
                                    }
                                    catch (IOException var45_46) {
                                        var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzgb.zza((String)var29_19 /* !! */ ), (Object)var45_46);
                                        continue;
                                    }
                                    var44_44.zza(var35_21.getString(1)).zzb(var35_21.getLong(2));
                                    if (!var34_4.zza(var42_42, (zzfs.zze)((zzju)var44_44.zzah()))) break;
                                } while (var35_21.moveToNext());
                            }
                            catch (SQLiteException var36_28) {
                                var28_20.zzj().zzg().zza("Data loss. Error selecting raw event. appId", zzgb.zza(var29_19 /* !! */ ), (Object)var36_28);
                            }
                            finally {
                                if (var35_21 != null) {
                                    var35_21.close();
                                }
                            }
                        }
                        var28_20 = var4_3;
                        if (var28_20.zzc == null || var28_20.zzc.isEmpty() != false) break block159;
                        var5_49 = false;
                        var6_50 = ((zzfs.zzj.zza)var4_3.zza.zzca()).zzk();
                        var7_51 = 0;
                        var8_52 = 0L;
                        var10_53 = null;
                        var11_54 = -1;
                        var12_55 = null;
                        var13_56 = -1;
                        for (var14_57 = 0; var14_57 < var4_3.zzc.size(); ++var14_57) {
                            block161: {
                                block160: {
                                    var15_58 = var5_49;
                                    var16_61 = (zzfs.zze.zza)var4_3.zzc.get(var14_57).zzca();
                                    if (this.zzi().zzd(var4_3.zza.zzy(), var16_61.zze())) {
                                        this.zzj().zzu().zza("Dropping blocked raw event. appId", zzgb.zza((String)var4_3.zza.zzy()), (Object)this.zzm.zzk().zza(var16_61.zze()));
                                        if (this.zzi().zzm(var4_3.zza.zzy()) != false || this.zzi().zzo(var4_3.zza.zzy()) != false || "_err".equals(var16_61.zze())) continue;
                                        this.zzq();
                                        zznw.zza((zzny)this.zzah, (String)var4_3.zza.zzy(), (int)11, (String)"_ev", (String)var16_61.zze(), (int)0);
                                        continue;
                                    }
                                    if (var16_61.zze().equals(zziv.zza((String)"_ai"))) {
                                        var16_61.zza("_ai");
                                        this.zzj().zzp().zza("Renaming ad_impression to _ai");
                                        if (this.zzj().zza(5)) {
                                            for (var17_65 = 0; var17_65 < var16_61.zza(); ++var17_65) {
                                                if (!"ad_platform".equals(var16_61.zzb(var17_65).zzg()) || var16_61.zzb(var17_65).zzh().isEmpty() || !"admob".equalsIgnoreCase(var16_61.zzb(var17_65).zzh())) continue;
                                                this.zzj().zzv().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                            }
                                        }
                                    }
                                    if ((var17_65 = this.zzi().zzc(var4_3.zza.zzy(), var16_61.zze())) != 0) break block160;
                                    this.zzp();
                                    var28_20 = var16_61.zze();
                                    Preconditions.checkNotEmpty((String)var28_20);
                                    var30_13 = var28_20;
                                    var31_92 = -1;
                                    switch (var30_13.hashCode()) {
                                        case 95027: {
                                            if (!var30_13.equals("_ui")) break;
                                            var31_92 = 0;
                                        }
                                    }
                                    switch (var31_92) {
                                        case 0: {
                                            v0 = true;
                                            break;
                                        }
                                        default: {
                                            v0 = false;
                                        }
                                    }
                                    if (!v0) break block161;
                                }
                                var18_70 = 0;
                                var19_76 = 0;
                                for (var20_79 = 0; var20_79 < var16_61.zza(); ++var20_79) {
                                    if ("_c".equals(var16_61.zzb(var20_79).zzg())) {
                                        var21_82 = (zzfs.zzg)((zzju)((zzfs.zzg.zza)var16_61.zzb(var20_79).zzca()).zza(1L).zzah());
                                        var18_70 = 1;
                                        var16_61.zza(var20_79, (zzfs.zzg)var21_82);
                                        continue;
                                    }
                                    if (!"_r".equals(var16_61.zzb(var20_79).zzg())) continue;
                                    var21_82 = (zzfs.zzg)((zzju)((zzfs.zzg.zza)var16_61.zzb(var20_79).zzca()).zza(1L).zzah());
                                    var19_76 = 1;
                                    var16_61.zza(var20_79, (zzfs.zzg)var21_82);
                                }
                                if (var18_70 == 0 && var17_65 != 0) {
                                    this.zzj().zzp().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzfs.zzg.zze().zza("_c").zza(1L));
                                }
                                if (var19_76 == 0) {
                                    this.zzj().zzp().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzfs.zzg.zze().zza("_r").zza(1L));
                                }
                                var5_49 = true;
                                if (this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzy(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false).zze > (long)this.zze().zzc(var4_3.zza.zzy())) {
                                    zzng.zza((zzfs.zze.zza)var16_61, "_r");
                                    var5_49 = var15_58;
                                }
                                if (zznw.zzh((String)var16_61.zze()) && var17_65 != 0 && this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzy(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(var4_3.zza.zzy(), zzbh.zzn)) {
                                    this.zzj().zzu().zza("Too many conversions. Not logging as conversion. appId", zzgb.zza((String)var4_3.zza.zzy()));
                                    var22_83 = false;
                                    var23_87 = null;
                                    var24_88 = -1;
                                    for (var25_89 = 0; var25_89 < var16_61.zza(); ++var25_89) {
                                        var26_91 = var16_61.zzb(var25_89);
                                        if ("_c".equals(var26_91.zzg())) {
                                            var23_87 = (zzfs.zzg.zza)var26_91.zzca();
                                            var24_88 = var25_89;
                                            continue;
                                        }
                                        if (!"_err".equals(var26_91.zzg())) continue;
                                        var22_83 = true;
                                    }
                                    if (var22_83 && var23_87 != null) {
                                        var16_61.zza(var24_88);
                                    } else if (var23_87 != null) {
                                        var25_90 = (zzfs.zzg)((zzju)((zzfs.zzg.zza)((zzju.zza)var23_87.clone())).zza("_err").zza(10L).zzah());
                                        var16_61.zza(var24_88, var25_90);
                                    } else {
                                        this.zzj().zzg().zza("Did not find conversion parameter. appId", zzgb.zza((String)var4_3.zza.zzy()));
                                    }
                                }
                            }
                            if (var17_65 != 0) {
                                var29_19 /* !! */  = var16_61;
                                var28_20 = this;
                                var30_13 = new ArrayList<zzfs.zzg>(var29_19 /* !! */ .zzf());
                                var31_92 = -1;
                                var32_7 = -1;
                                for (var33_97 = 0; var33_97 < var30_13.size(); ++var33_97) {
                                    if ("value".equals(((zzfs.zzg)var30_13.get(var33_97)).zzg())) {
                                        var31_92 = var33_97;
                                        continue;
                                    }
                                    if (!"currency".equals(((zzfs.zzg)var30_13.get(var33_97)).zzg())) continue;
                                    var32_7 = var33_97;
                                }
                                if (var31_92 != -1) {
                                    if (!((zzfs.zzg)var30_13.get(var31_92)).zzl() && !((zzfs.zzg)var30_13.get(var31_92)).zzj()) {
                                        var28_20.zzj().zzv().zza("Value must be specified with a numeric type.");
                                        var29_19 /* !! */ .zza(var31_92);
                                        zzng.zza((zzfs.zze.zza)var29_19 /* !! */ , "_c");
                                        zzng.zza((zzfs.zze.zza)var29_19 /* !! */ , 18, "value");
                                    } else {
                                        var33_97 = 0;
                                        if (var32_7 == -1) {
                                            var33_97 = 1;
                                        } else {
                                            var34_4 = ((zzfs.zzg)var30_13.get(var32_7)).zzh();
                                            if (var34_4.length() != 3) {
                                                var33_97 = 1;
                                            } else {
                                                for (var35_22 = 0; var35_22 < var34_4.length(); var35_22 += Character.charCount(var36_29)) {
                                                    var36_29 = var34_4.codePointAt(var35_22);
                                                    if (Character.isLetter(var36_29)) continue;
                                                    var33_97 = 1;
                                                    break;
                                                }
                                            }
                                        }
                                        if (var33_97 != 0) {
                                            var28_20.zzj().zzv().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                            var29_19 /* !! */ .zza(var31_92);
                                            zzng.zza((zzfs.zze.zza)var29_19 /* !! */ , "_c");
                                            zzng.zza((zzfs.zze.zza)var29_19 /* !! */ , 19, "currency");
                                        }
                                    }
                                }
                            }
                            if ("_e".equals(var16_61.zze())) {
                                this.zzp();
                                if (zznt.zza((zzfs.zze)((zzju)var16_61.zzah()), "_fr") == null) {
                                    if (var12_55 != null && Math.abs(var12_55.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_71 = (zzfs.zze.zza)((zzju.zza)var12_55.clone());
                                        if (this.zza((zzfs.zze.zza)var16_61, var18_71)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var13_56, var18_71);
                                        } else {
                                            var10_53 = var16_61;
                                            var11_54 = var7_51;
                                        }
                                    } else {
                                        var10_53 = var16_61;
                                        var11_54 = var7_51;
                                    }
                                }
                            } else if ("_vs".equals(var16_61.zze())) {
                                this.zzp();
                                if (zznt.zza((zzfs.zze)((zzju)var16_61.zzah()), "_et") == null) {
                                    if (var10_53 != null && Math.abs(var10_53.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_72 = (zzfs.zze.zza)((zzju.zza)var10_53.clone());
                                        if (this.zza(var18_72, (zzfs.zze.zza)var16_61)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var11_54, var18_72);
                                        } else {
                                            var12_55 = var16_61;
                                            var13_56 = var7_51;
                                        }
                                    } else {
                                        var12_55 = var16_61;
                                        var13_56 = var7_51;
                                    }
                                }
                            }
                            if (zzpm.zza() && this.zze().zza(zzbh.zzcv) && var16_61.zza() != 0) {
                                this.zzp();
                                var18_73 = zznt.zza(var16_61.zzf());
                                for (var19_76 = 0; var19_76 < var16_61.zza(); ++var19_76) {
                                    var20_80 = var16_61.zzb(var19_76);
                                    if (var20_80.zzg().equals("items") && !var20_80.zzi().isEmpty()) {
                                        var32_8 = var18_73;
                                        var31_93 = var4_3.zza.zzy();
                                        var30_14 = var16_61;
                                        var29_19 /* !! */  = var20_80;
                                        var28_20 = this;
                                        var33_98 = var29_19 /* !! */ .zzi();
                                        var34_4 = new Bundle[var33_98.size()];
                                        for (var35_23 = 0; var35_23 < var33_98.size(); ++var35_23) {
                                            var36_30 = var33_98.get(var35_23);
                                            var28_20.zzp();
                                            var37_36 = zznt.zza(var36_30.zzi());
                                            for (zzfs.zzj var39_37 : var36_30.zzi()) {
                                                super.zza(var30_14.zze(), (zzfs.zzg.zza)var39_37 /* !! */ .zzca(), (Bundle)var37_36, var31_93);
                                            }
                                            var34_4[var35_23] = var37_36;
                                        }
                                        var32_8.putParcelableArray("items", (Parcelable[])var34_4);
                                        continue;
                                    }
                                    if (var20_80.zzg().equals("items")) continue;
                                    this.zza(var16_61.zze(), (zzfs.zzg.zza)var20_80.zzca(), var18_73, var4_3.zza.zzy());
                                }
                                var30_14 = var16_61;
                                var29_19 /* !! */  = var18_73;
                                var28_20 = this;
                                var30_14.zzd();
                                var34_4 = var29_19 /* !! */ ;
                                var33_99 = var28_20.zzp();
                                var35_24 = new ArrayList<zzfs.zzg>();
                                for (String var37_36 : var34_4.keySet()) {
                                    var38_33 = zzfs.zzg.zze().zza(var37_36);
                                    var39_37 /* !! */  = var34_4.get(var37_36);
                                    if (var39_37 /* !! */  == null) continue;
                                    var33_99.zza((zzfs.zzg.zza)var38_33, (Object)var39_37 /* !! */ );
                                    var35_24.add((zzfs.zzg)((zzju)var38_33.zzah()));
                                }
                                var51_101 = var35_24;
                                var52_102 = var51_101.size();
                                for (var53_103 = 0; var53_103 < var52_102; ++var53_103) {
                                    v1 = var51_101.get(var53_103);
                                    var32_9 = (zzfs.zzg)v1;
                                    var30_14.zza(var32_9);
                                }
                            }
                            var4_3.zzc.set(var14_57, (zzfs.zze)((zzju)var16_61.zzah()));
                            ++var7_51;
                            var6_50.zza((zzfs.zze.zza)var16_61);
                        }
                        for (var14_57 = 0; var14_57 < var7_51; ++var14_57) {
                            var15_59 = var6_50.zza(var14_57);
                            if ("_e".equals(var15_59.zzg())) {
                                this.zzp();
                                if (zznt.zza(var15_59, "_fr") != null) {
                                    var6_50.zzb(var14_57);
                                    --var7_51;
                                    --var14_57;
                                    continue;
                                }
                            }
                            this.zzp();
                            var16_61 = zznt.zza(var15_59, "_et");
                            if (var16_61 == null || (var17_67 = var16_61.zzl() != false ? Long.valueOf(var16_61.zzd()) : null) == null || var17_67 <= 0L) continue;
                            var8_52 += var17_67.longValue();
                        }
                        this.zza(var6_50, var8_52, false);
                        var14_57 = 0;
                        for (zzlj var16_61 : var6_50.zzaa()) {
                            if (!"_s".equals(var16_61.zzg())) continue;
                            var14_57 = 1;
                            break;
                        }
                        if (var14_57 != 0) {
                            this.zzf().zzh(var6_50.zzt(), "_se");
                        }
                        if (zznt.zza(var6_50, "_sid") >= 0) {
                            this.zza(var6_50, var8_52, true);
                        } else {
                            var16_62 = zznt.zza(var6_50, "_se");
                            if (var16_62 >= 0) {
                                var6_50.zzc(var16_62);
                                this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzgb.zza((String)var4_3.zza.zzy()));
                            }
                        }
                        this.zzp().zza(var6_50);
                        var30_15 = var6_50;
                        var29_19 /* !! */  = var4_3.zza.zzy();
                        var28_20 = this;
                        var28_20.zzl().zzt();
                        var28_20.zzs();
                        var31_94 /* !! */  = var28_20.zzf().zze(var29_19 /* !! */ );
                        if (var31_94 /* !! */  == null) {
                            var28_20.zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzgb.zza((String)var29_19 /* !! */ ));
                        } else {
                            var28_20.zza(var31_94 /* !! */ , var30_15);
                        }
                        var28_20 = var6_50;
                        var28_20.zzi(0x7FFFFFFFFFFFFFFFL).zze(-9223372036854775808L);
                        for (var30_16 = 0; var30_16 < var28_20.zzc(); ++var30_16) {
                            var31_94 /* !! */  = var28_20.zza(var30_16);
                            if (var31_94 /* !! */ .zzd() < var28_20.zzf()) {
                                var28_20.zzi(var31_94 /* !! */ .zzd());
                            }
                            if (var31_94 /* !! */ .zzd() <= var28_20.zze()) continue;
                            var28_20.zze(var31_94 /* !! */ .zzd());
                        }
                        var6_50.zzs();
                        if (zzod.zza() && this.zze().zza(zzbh.zzdg)) {
                            var28_20 = this;
                            var29_19 /* !! */  = var6_50;
                            if (!var28_20.zzb(var29_19 /* !! */ .zzt()).zzi()) {
                                var29_19 /* !! */ .zzq();
                                var29_19 /* !! */ .zzm();
                                var29_19 /* !! */ .zzj();
                            }
                            if (!var28_20.zzb(var29_19 /* !! */ .zzt()).zzj()) {
                                var29_19 /* !! */ .zzg();
                                var29_19 /* !! */ .zzr();
                            }
                        }
                        if (zzpz.zza() && this.zze().zze(var4_3.zza.zzy(), zzbh.zzcg)) {
                            this.zzq();
                            if (zznw.zzd((String)var4_3.zza.zzy()) && this.zzb(var4_3.zza.zzy()).zzi() && var4_3.zza.zzas()) {
                                var16_63 = this.zze().zze(var4_3.zza.zzy(), zzbh.zzcm);
                                var17_68 = var16_63 != false ? var6_50.zzc() : var4_3.zzc.size();
                                for (var18_70 = 0; var18_70 < var17_68; ++var18_70) {
                                    var19_78 = var16_63 != false ? (zzfs.zze.zza)var6_50.zza(var18_70).zzca() : (zzfs.zze.zza)var4_3.zzc.get(var18_70).zzca();
                                    var20_79 = 0;
                                    for (zzfs.zzg var22_85 : var19_78.zzf()) {
                                        if (!"_c".equals(var22_85.zzg())) continue;
                                        var20_79 = 1;
                                        break;
                                    }
                                    if (var20_79 == 0) continue;
                                    if (var4_3.zza.zza() >= this.zze().zzb(var4_3.zza.zzy(), zzbh.zzav)) {
                                        var21_82 = null;
                                        if (this.zze().zze(var4_3.zza.zzy(), zzbh.zzci)) {
                                            var21_82 = this.zzq().zzp();
                                            var22_85 = (zzfs.zzg)((zzju)zzfs.zzg.zze().zza("_tu").zzb((String)var21_82).zzah());
                                            var19_78.zza(var22_85);
                                        }
                                        var22_85 = (zzfs.zzg)((zzju)zzfs.zzg.zze().zza("_tr").zza(1L).zzah());
                                        var19_78.zza(var22_85);
                                        var23_87 = this.zze().zze(var4_3.zza.zzy(), zzbh.zzck) != false ? this.zzp().zza(var4_3.zza.zzy(), var6_50, var19_78, (String)var21_82) : this.zzp().zza(var4_3.zza.zzy(), var4_3.zza, var19_78, (String)var21_82);
                                        if (var23_87 != null) {
                                            this.zzj().zzp().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzy(), (Object)var23_87.zza);
                                            this.zzf().zza(var4_3.zza.zzy(), (zzmy)var23_87);
                                            this.zzr.add(var4_3.zza.zzy());
                                        }
                                    }
                                    var6_50.zza(var18_70, (zzfs.zze)((zzju)var19_78.zzah()));
                                }
                            }
                        }
                        var6_50.zzh().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze()));
                        if (this.zze().zzl(var4_3.zza.zzy())) {
                            var30_17 = var4_3;
                            var29_19 /* !! */  = var6_50;
                            var28_20 = this;
                            var31_94 /* !! */  = new HashMap<K, V>();
                            var32_10 = new ArrayList<zzfs.zze>();
                            var33_100 = var28_20.zzq().zzv();
                            for (var34_5 = 0; var34_5 < var29_19 /* !! */ .zzc(); ++var34_5) {
                                block158: {
                                    var35_25 = (zzfs.zze.zza)var29_19 /* !! */ .zza(var34_5).zzca();
                                    if (var35_25.zze().equals("_ep")) {
                                        var28_20.zzp();
                                        var36_27 /* !! */  = (String)zznt.zzb((zzfs.zze)((zzju)var35_25.zzah()), "_en");
                                        var37_36 = (zzbb)var31_94 /* !! */ .get(var36_27 /* !! */ );
                                        if (var37_36 == null && (var37_36 = var28_20.zzf().zzd(var30_17.zza.zzy(), (String)Preconditions.checkNotNull((Object)var36_27 /* !! */ ))) != null) {
                                            var31_94 /* !! */ .put(var36_27 /* !! */ , var37_36);
                                        }
                                        if (var37_36 != null && var37_36.zzi == null) {
                                            if (var37_36.zzj != null && var37_36.zzj > 1L) {
                                                var28_20.zzp();
                                                zznt.zza(var35_25, "_sr", var37_36.zzj);
                                            }
                                            if (var37_36.zzk != null && var37_36.zzk.booleanValue()) {
                                                var28_20.zzp();
                                                zznt.zza(var35_25, "_efs", 1L);
                                            }
                                            var32_10.add((zzfs.zze)((zzju)var35_25.zzah()));
                                        }
                                        var29_19 /* !! */ .zza(var34_5, var35_25);
                                        continue;
                                    }
                                    var36_32 = var28_20.zzi().zza(var30_17.zza.zzy());
                                    var28_20.zzq();
                                    var38_34 = zznw.zza((long)var35_25.zzc(), (long)var36_32);
                                    var40_40 = 1;
                                    var48_105 = 1L;
                                    var47_35 = "_dbg";
                                    var46_48 = (zzfs.zze)((zzju)var35_25.zzah());
                                    if (TextUtils.isEmpty((CharSequence)var47_35) || var48_105 == null) {
                                        v2 = false;
                                    } else {
                                        for (zzfs.zzg var50_107 : var46_48.zzh()) {
                                            if (!var47_35.equals(var50_107.zzg())) continue;
                                            v2 = var48_105 instanceof Long != false && var48_105.equals(var50_107.zzd()) != false || var48_105 instanceof String != false && var48_105.equals(var50_107.zzh()) != false || var48_105 instanceof Double && var48_105.equals(var50_107.zza());
                                            break block158;
                                        }
                                        v2 = false;
                                    }
                                }
                                if (!v2) {
                                    var40_40 = var28_20.zzi().zzb(var30_17.zza.zzy(), var35_25.zze());
                                }
                                if (var40_40 <= 0) {
                                    var28_20.zzj().zzu().zza("Sample rate must be positive. event, rate", (Object)var35_25.zze(), (Object)var40_40);
                                    var32_10.add((zzfs.zze)((zzju)var35_25.zzah()));
                                    var29_19 /* !! */ .zza(var34_5, var35_25);
                                    continue;
                                }
                                var41_41 = (String[])var31_94 /* !! */ .get(var35_25.zze());
                                if (var41_41 == null && (var41_41 = var28_20.zzf().zzd(var30_17.zza.zzy(), var35_25.zze())) == null) {
                                    var28_20.zzj().zzu().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)var30_17.zza.zzy(), (Object)var35_25.zze());
                                    var41_41 = new zzbb(var30_17.zza.zzy(), var35_25.zze(), 1L, 1L, 1L, var35_25.zzc(), 0L, null, null, null, null);
                                }
                                var28_20.zzp();
                                var42_43 = (Long)zznt.zzb((zzfs.zze)((zzju)var35_25.zzah()), "_eid");
                                var43_104 = var42_43 != null;
                                if (var40_40 == 1) {
                                    var32_10.add((zzfs.zze)((zzju)var35_25.zzah()));
                                    if (var43_104.booleanValue() && (var41_41.zzi != null || var41_41.zzj != null || var41_41.zzk != null)) {
                                        var41_41 = var41_41.zza(null, null, null);
                                        var31_94 /* !! */ .put(var35_25.zze(), var41_41);
                                    }
                                    var29_19 /* !! */ .zza(var34_5, var35_25);
                                    continue;
                                }
                                if (var33_100.nextInt(var40_40) == 0) {
                                    var28_20.zzp();
                                    zznt.zza(var35_25, "_sr", var40_40);
                                    var32_10.add((zzfs.zze)((zzju)var35_25.zzah()));
                                    if (var43_104.booleanValue()) {
                                        var41_41 = var41_41.zza(null, Long.valueOf(var40_40), null);
                                    }
                                    var31_94 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                } else {
                                    if (var41_41.zzh != null) {
                                        var44_45 = var41_41.zzh;
                                    } else {
                                        var28_20.zzq();
                                        var44_45 = zznw.zza((long)var35_25.zzb(), (long)var36_32);
                                    }
                                    if (var44_45 != var38_34) {
                                        var28_20.zzp();
                                        zznt.zza(var35_25, "_efs", 1L);
                                        var28_20.zzp();
                                        zznt.zza(var35_25, "_sr", var40_40);
                                        var32_10.add((zzfs.zze)((zzju)var35_25.zzah()));
                                        if (var43_104.booleanValue()) {
                                            var41_41 = var41_41.zza(null, Long.valueOf(var40_40), Boolean.valueOf(true));
                                        }
                                        var31_94 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                    } else if (var43_104.booleanValue()) {
                                        var31_94 /* !! */ .put(var35_25.zze(), var41_41.zza(var42_43, null, null));
                                    }
                                }
                                var29_19 /* !! */ .zza(var34_5, var35_25);
                            }
                            if (var32_10.size() < var29_19 /* !! */ .zzc()) {
                                var29_19 /* !! */ .zzk().zzb(var32_10);
                            }
                            for (Map.Entry var35_26 : var31_94 /* !! */ .entrySet()) {
                                var28_20.zzf().zza((zzbb)var35_26.getValue());
                            }
                        }
                        var16_64 = var4_3.zza.zzy();
                        var17_69 = this.zzf().zze(var16_64);
                        if (var17_69 != null) break block162;
                        this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzgb.zza((String)var4_3.zza.zzy()));
                        break block163;
                    }
                    if (var6_50.zzc() <= 0) break block163;
                    var18_74 = var17_69.zzs();
                    if (var18_74 != 0L) {
                        var6_50.zzg(var18_74);
                    } else {
                        var6_50.zzo();
                    }
                    var20_81 = var17_69.zzu();
                    if (var20_81 == 0L) {
                        var20_81 = var18_74;
                    }
                    if (var20_81 != 0L) {
                        var6_50.zzh(var20_81);
                    } else {
                        var6_50.zzp();
                    }
                    if (!zzqw.zza() || !this.zze().zza(zzbh.zzbt)) ** GOTO lbl-1000
                    this.zzq();
                    if (zznw.zzf((String)var17_69.zzac())) {
                        var17_69.zza((long)var6_50.zzc());
                        var6_50.zzg((int)var17_69.zzr());
                    } else lbl-1000:
                    // 2 sources

                    {
                        var17_69.zzap();
                    }
                    var6_50.zzf((int)var17_69.zzt());
                    var17_69.zzr(var6_50.zzf());
                    var17_69.zzp(var6_50.zze());
                    var22_86 = var17_69.zzab();
                    if (var22_86 != null) {
                        var6_50.zzn(var22_86);
                    } else {
                        var6_50.zzl();
                    }
                    this.zzf().zza(var17_69);
                }
                if (var6_50.zzc() > 0) {
                    var18_75 = this.zzi().zzc(var4_3.zza.zzy());
                    if (var18_75 == null || !var18_75.zzs()) {
                        if (var4_3.zza.zzai().isEmpty()) {
                            var6_50.zzb(-1L);
                        } else {
                            this.zzj().zzu().zza("Did not find measurement config or missing version info. appId", zzgb.zza((String)var4_3.zza.zzy()));
                        }
                    } else {
                        var6_50.zzb(var18_75.zzc());
                    }
                    this.zzf().zza((zzfs.zzj)((zzju)var6_50.zzah()), var5_49);
                }
                var29_19 /* !! */  = var4_3.zzb;
                var28_20 = this.zzf();
                Preconditions.checkNotNull((Object)var29_19 /* !! */ );
                var28_20.zzt();
                var28_20.zzak();
                var30_18 = new StringBuilder("rowid in (");
                for (var31_95 = 0; var31_95 < var29_19 /* !! */ .size(); ++var31_95) {
                    if (var31_95 != 0) {
                        var30_18.append(",");
                    }
                    var30_18.append((Long)var29_19 /* !! */ .get(var31_95));
                }
                var30_18.append(")");
                var32_11 = var28_20.e_().delete("raw_events", var30_18.toString(), null);
                if (var32_11 != var29_19 /* !! */ .size()) {
                    var28_20.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)var32_11, (Object)var29_19 /* !! */ .size());
                }
                var29_19 /* !! */  = var16_64;
                var28_20 = this.zzf();
                var30_18 = var28_20.e_();
                try {
                    var30_18.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{var29_19 /* !! */ , var29_19 /* !! */ });
                }
                catch (SQLiteException var31_96) {
                    var28_20.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzgb.zza((String)var29_19 /* !! */ ), (Object)var31_96);
                }
                this.zzf().zzw();
                return true;
            }
            this.zzf().zzw();
            return false;
        }
        finally {
            this.zzf().zzu();
        }
    }

    private final boolean zzac() {
        this.zzl().zzt();
        this.zzs();
        return this.zzf().zzx() || !TextUtils.isEmpty((CharSequence)this.zzf().f_());
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzad() {
        this.zzl().zzt();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzp().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(zzci.zza().zza(file, string));
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzp().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzu().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzfs.zze.zza zza2, zzfs.zze.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzfs.zzg zzg2 = zznt.zza((zzfs.zze)((zzju)zza2.zzah()), "_sc");
        String string = zzg2 == null ? null : zzg2.zzh();
        this.zzp();
        zzfs.zzg zzg3 = zznt.zza((zzfs.zze)((zzju)zza3.zzah()), "_pc");
        String string2 = zzg3 == null ? null : zzg3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzfs.zze.zza zza4 = zza3;
            zzfs.zze.zza zza5 = zza2;
            zzng zzng2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zzng2.zzp();
            zzfs.zzg zzg4 = zznt.zza((zzfs.zze)((zzju)zza5.zzah()), "_et");
            if (zzg4 != null && zzg4.zzl() && zzg4.zzd() > 0L) {
                long l = zzg4.zzd();
                zzng2.zzp();
                zzg4 = zznt.zza((zzfs.zze)((zzju)zza4.zzah()), "_et");
                if (zzg4 != null && zzg4.zzd() > 0L) {
                    l += zzg4.zzd();
                }
                zzng2.zzp();
                zznt.zza(zza4, "_et", l);
                zzng2.zzp();
                zznt.zza(zza5, "_fr", 1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    private final class zzb {
        final String zza;
        long zzb;

        private zzb(zzng zzng2) {
            this(zzng2, zzng2.zzq().zzp());
        }

        /* synthetic */ zzb(zzng zzng2, zznr zznr2) {
            this(zzng2);
        }

        private zzb(zzng zzng2, String string) {
            this.zza = string;
            this.zzb = zzng2.zzb().elapsedRealtime();
        }

        /* synthetic */ zzb(zzng zzng2, String string, zznr zznr2) {
            this(zzng2, string);
        }
    }

    private final class zza
    implements zzar {
        zzfs.zzj zza;
        List<Long> zzb;
        List<zzfs.zze> zzc;
        private long zzd;

        private static long zza(zzfs.zze zze2) {
            return zze2.zzd() / 1000L / 60L / 60L;
        }

        private zza() {
        }

        /* synthetic */ zza(zznp zznp2) {
            this();
        }

        @Override
        public final void zza(zzfs.zzj zzj2) {
            Preconditions.checkNotNull((Object)((Object)zzj2));
            this.zza = zzj2;
        }

        @Override
        public final boolean zza(long l, zzfs.zze zze2) {
            Preconditions.checkNotNull((Object)((Object)zze2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzfs.zze>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zzng$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzng$zza.zza(zze2)) {
                return false;
            }
            long l2 = this.zzd + (long)zze2.zzby();
            zzng.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbh.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zze2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zzng.this.zze();
            return n < Math.max(1, (Integer)zzbh.zzj.zza(null));
        }
    }
}

