/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzci;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzlk;
import com.google.android.gms.internal.measurement.zzoe;
import com.google.android.gms.internal.measurement.zzoj;
import com.google.android.gms.internal.measurement.zzoq;
import com.google.android.gms.internal.measurement.zzpc;
import com.google.android.gms.internal.measurement.zzph;
import com.google.android.gms.internal.measurement.zzpi;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.internal.measurement.zzpz;
import com.google.android.gms.internal.measurement.zzql;
import com.google.android.gms.internal.measurement.zzqr;
import com.google.android.gms.internal.measurement.zzqs;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zznc;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zznf;
import com.google.android.gms.measurement.internal.zzng;
import com.google.android.gms.measurement.internal.zznh;
import com.google.android.gms.measurement.internal.zznj;
import com.google.android.gms.measurement.internal.zznk;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zznm;
import com.google.android.gms.measurement.internal.zznp;
import com.google.android.gms.measurement.internal.zznq;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zzns;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zznx;
import com.google.android.gms.measurement.internal.zzny;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzu;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzni
implements zzio {
    private static volatile @Nullable zzni zza;
    private zzgz zzb;
    private zzgg zzc;
    private zzal zzd;
    private zzgj zze;
    private zznc zzf;
    private zzu zzg;
    private final zznr zzh;
    private zzkt zzi;
    private zzmi zzj;
    private final zzng zzk;
    private @MonotonicNonNull zzgt zzl;
    private final zzhm zzm;
    private boolean zzn = false;
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Set<String> zzr = new HashSet<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zziq> zzac;
    private final Map<String, zzav> zzad;
    private final Map<String, zzb> zzae;
    private @Nullable zzkv zzaf;
    private @Nullable String zzag;
    private final zznx zzah = new zznl(this);

    private final int zza(String string, zzah zzah2) {
        zzit zzit2;
        zzg zzg2;
        if (this.zzb.zzb(string) == null) {
            zzah2.zza(zziq.zza.zzd, zzak.zzj);
            return 1;
        }
        if (com.google.android.gms.internal.measurement.zzny.zza() && this.zze().zza(zzbf.zzcy) && (zzg2 = this.zzf().zze(string)) != null && zzgl.zza((String)zzg2.zzak()).zza() == zzit.zzb && (zzit2 = this.zzb.zza(string, zziq.zza.zzd)) != zzit.zza) {
            zzah2.zza(zziq.zza.zzd, zzak.zzi);
            if (zzit2 == zzit.zzd) {
                return 0;
            }
            return 1;
        }
        zzah2.zza(zziq.zza.zzd, zzak.zzb);
        if (this.zzb.zzc(string, zziq.zza.zzd)) {
            return 0;
        }
        return 1;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzu().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzx() {
        long l = this.zzb().currentTimeMillis();
        zzmi zzmi2 = this.zzj;
        zzmi2.zzak();
        zzmi2.zzt();
        long l2 = zzmi2.zze.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzmi2.zzq().zzv().nextInt(86400000);
            zzmi2.zze.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    @WorkerThread
    final @Nullable Bundle zza(String string) {
        zznv zznv2;
        this.zzl().zzt();
        this.zzs();
        if (this.zzi().zzb(string) == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        zziq zziq2 = this.zzb(string);
        bundle.putAll(zziq2.zzb());
        zzav zzav2 = this.zza(string, this.zzd(string), zziq2, new zzah());
        bundle.putAll(zzav2.zzb());
        int n = this.zzp().zzc(string) ? 1 : ((zznv2 = this.zzf().zze(string, "_npa")) != null ? (zznv2.zze.equals(1L) ? 1 : 0) : this.zza(string, new zzah()));
        bundle.putString("ad_personalization", n == 1 ? "denied" : "granted");
        return bundle;
    }

    public final Clock zzb(@UnknownInitialization zzni this) {
        return ((zzhm)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzg zza(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zzo2.zzu.isEmpty()) {
            this.zzae.put(zzo2.zza, new zzb(this, zzo2.zzu, null));
        }
        zzg zzg2 = this.zzf().zze(zzo2.zza);
        boolean bl = false;
        zziq zziq2 = this.zzb(zzo2.zza).zza(zziq.zzb((String)zzo2.zzt));
        String string = zziq2.zzi() ? this.zzj.zza(zzo2.zza, zzo2.zzn) : "";
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzm, zzo2.zza);
            if (zziq2.zzj()) {
                zzg2.zzb(this.zza(zziq2));
            }
            if (zziq2.zzi()) {
                zzg2.zzh(string);
            }
        } else if (zziq2.zzi() && string != null && !string.equals(zzg2.zzaj())) {
            boolean bl2 = TextUtils.isEmpty((CharSequence)zzg2.zzaj());
            zzg2.zzh(string);
            if (!(!zzo2.zzn || "00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzo2.zza, (zziq)zziq2).first) || this.zze().zza(zzbf.zzda) && bl2)) {
                if (zzoe.zza() && this.zze().zza(zzbf.zzdf) && !zziq2.zzj()) {
                    bl = true;
                } else {
                    zzg2.zzb(this.zza(zziq2));
                }
                if (this.zzf().zze(zzo2.zza, "_id") != null && this.zzf().zze(zzo2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zznv zznv2 = new zznv(zzo2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zznv2);
                }
            } else if (this.zze().zza(zzbf.zzda) && TextUtils.isEmpty((CharSequence)zzg2.zzad()) && zziq2.zzj()) {
                zzg2.zzb(this.zza(zziq2));
            }
        } else if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) && zziq2.zzj()) {
            zzg2.zzb(this.zza(zziq2));
        }
        zzg2.zzf(zzo2.zzb);
        zzg2.zza(zzo2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzk)) {
            zzg2.zze(zzo2.zzk);
        }
        if (zzo2.zze != 0L) {
            zzg2.zzn(zzo2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzc)) {
            zzg2.zzd(zzo2.zzc);
        }
        zzg2.zzb(zzo2.zzj);
        if (zzo2.zzd != null) {
            zzg2.zzc(zzo2.zzd);
        }
        zzg2.zzk(zzo2.zzf);
        zzg2.zzb(zzo2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzg)) {
            zzg2.zzg(zzo2.zzg);
        }
        zzg2.zza(zzo2.zzn);
        zzg2.zza(zzo2.zzq);
        zzg2.zzl(zzo2.zzr);
        if (zzql.zza() && (this.zze().zza(zzbf.zzbq) || this.zze().zze(zzo2.zza, zzbf.zzbs))) {
            zzg2.zzj(zzo2.zzv);
        }
        if (zzoq.zza() && this.zze().zza(zzbf.zzbp)) {
            zzg2.zza(zzo2.zzs);
        } else if (zzoq.zza() && this.zze().zza(zzbf.zzbo)) {
            zzg2.zza((List<String>)null);
        }
        if (zzqr.zza() && this.zze().zza(zzbf.zzbt)) {
            this.zzq();
            if (zzny.zzf((String)zzg2.zzac())) {
                zzg2.zzc(zzo2.zzw);
                if (this.zze().zza(zzbf.zzbu)) {
                    zzg2.zzk(zzo2.zzac);
                }
            }
        }
        if (zzpz.zza() && this.zze().zza(zzbf.zzce)) {
            zzg2.zza(zzo2.zzaa);
        }
        zzg2.zzt(zzo2.zzx);
        if (com.google.android.gms.internal.measurement.zzny.zza() && this.zze().zza(zzbf.zzcy)) {
            zzg2.zzi(zzo2.zzad);
        }
        if (zzoe.zza() && this.zze().zza(zzbf.zzdf)) {
            if (zzg2.zzas() || bl) {
                this.zzf().zza(zzg2, bl, false);
            }
        } else if (zzg2.zzas()) {
            this.zzf().zza(zzg2, false, false);
        }
        return zzg2;
    }

    @WorkerThread
    private final @Nullable zzo zzc(String string) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzfz.zza((String)string));
            return null;
        }
        return new zzo(string, zzg2.zzah(), zzg2.zzaf(), zzg2.zze(), zzg2.zzae(), zzg2.zzq(), zzg2.zzn(), null, zzg2.zzar(), false, zzg2.zzag(), zzg2.zzd(), 0L, 0, zzg2.zzaq(), false, zzg2.zzaa(), zzg2.zzx(), zzg2.zzo(), zzg2.zzan(), null, this.zzb(string).zzh(), "", null, zzg2.zzat(), zzg2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzg2.zza(), zzg2.zzf(), zzg2.zzam(), zzg2.zzak());
    }

    public final zzu zzc() {
        return (zzu)zzni.zza(this.zzg);
    }

    public final zzab zzd() {
        return this.zzm.zzd();
    }

    public final zzag zze(@UnknownInitialization zzni this) {
        return ((zzhm)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzal zzf(@UnknownInitialization zzni this) {
        return (zzal)zzni.zza(this.zzd);
    }

    @VisibleForTesting
    @WorkerThread
    private final zzav zza(String string, zzav zzav2, zziq zziq2, zzah zzah2) {
        int n;
        if (this.zzi().zzb(string) == null) {
            int n2;
            if (zzav2.zzc() == zzit.zzc) {
                n2 = zzav2.zza();
                zzah2.zza(zziq.zza.zzc, n2);
            } else {
                n2 = 90;
                zzah2.zza(zziq.zza.zzc, zzak.zzj);
            }
            return new zzav(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
        }
        zzit zzit2 = zzav2.zzc();
        if (zzit2 == zzit.zzd || zzit2 == zzit.zzc) {
            n = zzav2.zza();
            zzah2.zza(zziq.zza.zzc, n);
        } else {
            n = 90;
            if (com.google.android.gms.internal.measurement.zzny.zza() && this.zze().zza(zzbf.zzcy)) {
                zziq.zza zza2;
                zziq.zza zza3;
                zzah zzah3 = zzah2;
                zziq zziq3 = zziq2;
                zzit zzit3 = zzit2;
                String string2 = string;
                zzni zzni2 = this;
                if (zzit3 == zzit.zzb && (zza3 = zzni2.zzb.zza(string2, zziq.zza.zzc)) != zzit.zza) {
                    zzah3.zza(zziq.zza.zzc, zzak.zzi);
                    zza2 = zza3;
                } else {
                    boolean bl;
                    zza3 = zzni2.zzb.zzb(string2, zziq.zza.zzc);
                    zzit zzit4 = zziq3.zzc();
                    boolean bl2 = bl = zzit4 == zzit.zzd || zzit4 == zzit.zzc;
                    if (zza3 == zziq.zza.zza && bl) {
                        zzah3.zza(zziq.zza.zzc, zzak.zzc);
                        zza2 = zzit4;
                    } else {
                        zzah3.zza(zziq.zza.zzc, zzak.zzb);
                        zza2 = zzni2.zzb.zzc(string2, zziq.zza.zzc) ? zzit.zzd : zzit.zzc;
                    }
                }
                zzit2 = zza2;
            } else {
                zzah zzah4 = zzah2;
                zziq zziq4 = zziq2;
                zzit zzit5 = zzit2;
                String string3 = string;
                zzni zzni3 = this;
                Preconditions.checkArgument((zzit5 == zzit.zza || zzit5 == zzit.zzb ? 1 : 0) != 0);
                zzit zzit6 = zzit5;
                zziq.zza zza4 = zzni3.zzb.zzb(string3, zziq.zza.zzc);
                Boolean bl = zziq4.zze();
                if (zza4 == zziq.zza.zza && bl != null) {
                    zzit6 = bl != false ? zzit.zzd : zzit.zzc;
                    zzah4.zza(zziq.zza.zzc, zzak.zzc);
                }
                if (zzit6 == zzit.zza) {
                    zzit6 = zzni3.zzb.zzc(string3, zziq.zza.zzc) ? zzit.zzd : zzit.zzc;
                    zzah4.zza(zziq.zza.zzc, zzak.zzb);
                }
                zzit2 = zzit6;
            }
        }
        boolean bl = this.zzb.zzn(string);
        SortedSet<String> sortedSet = this.zzi().zzh(string);
        if (zzit2 == zzit.zzc || sortedSet.isEmpty()) {
            return new zzav(Boolean.valueOf(false), n, Boolean.valueOf(bl), "-");
        }
        return new zzav(Boolean.valueOf(true), n, Boolean.valueOf(bl), bl ? TextUtils.join((CharSequence)"", sortedSet) : "");
    }

    @WorkerThread
    private final zzav zzd(String string) {
        this.zzl().zzt();
        this.zzs();
        zzav zzav2 = this.zzad.get(string);
        if (zzav2 == null) {
            zzav2 = this.zzf().zzg(string);
            this.zzad.put(string, zzav2);
        }
        return zzav2;
    }

    public final zzfy zzg() {
        return this.zzm.zzk();
    }

    public final zzfz zzj(@UnknownInitialization zzni this) {
        return ((zzhm)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzgg zzh() {
        return (zzgg)zzni.zza(this.zzc);
    }

    private final zzgj zzy() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzgz zzi() {
        return (zzgz)zzni.zza(this.zzb);
    }

    public final zzhj zzl(@UnknownInitialization zzni this) {
        return ((zzhm)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzhm zza(zzni zzni2) {
        return zzni2.zzm;
    }

    final zzhm zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zziq zzb(String string) {
        this.zzl().zzt();
        this.zzs();
        zziq zziq2 = this.zzac.get(string);
        if (zziq2 == null) {
            zziq2 = this.zzf().zzi(string);
            if (zziq2 == null) {
                zziq2 = zziq.zza;
            }
            this.zza(string, zziq2);
        }
        return zziq2;
    }

    public final zzkt zzm() {
        return (zzkt)zzni.zza(this.zzi);
    }

    public final zzmi zzn() {
        return this.zzj;
    }

    private final zznc zzz() {
        return (zznc)zzni.zza(this.zzf);
    }

    private static zznd zza(@Nullable zznd zznd2) {
        if (zznd2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zznd2.zzam()) {
            String string = String.valueOf(((Object)((Object)zznd2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zznd2;
    }

    public final zzng zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzni zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzni> clazz = zzni.class;
        synchronized (zzni.class) {
            if (zza != null) return zza;
            zzns zzns2 = (zzns)Preconditions.checkNotNull((Object)new zzns(context));
            zza = new zzni(zzns2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zznr zzp() {
        return (zznr)zzni.zza(this.zzh);
    }

    public final zzny zzq(@UnknownInitialization zzni this) {
        return ((zzhm)Preconditions.checkNotNull((Object)this.zzm)).zzt();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzg zzg2) {
        try {
            if (zzg2.zze() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzac(), (int)0).versionCode;
                if (zzg2.zze() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzac(), (int)0).versionName;
                String string2 = zzg2.zzaf();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    private final @Nullable Boolean zzg(zzo zzo2) {
        Boolean bl = zzo2.zzq;
        if (com.google.android.gms.internal.measurement.zzny.zza() && this.zze().zza(zzbf.zzcy) && !TextUtils.isEmpty((CharSequence)zzo2.zzad)) {
            zzit zzit2 = zzgl.zza((String)zzo2.zzad).zza();
            switch (zzit2) {
                case zzd: {
                    bl = false;
                    break;
                }
                case zzc: {
                    bl = true;
                    break;
                }
                case zzb: 
                case zza: {
                    bl = null;
                }
            }
        }
        return bl;
    }

    @WorkerThread
    private final @Nullable String zza(zziq zziq2) {
        if (zziq2.zzj()) {
            zzni zzni2 = this;
            byte[] byArray = new byte[16];
            zzni2.zzq().zzv().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzo zzo2) {
        Future future = this.zzl().zza((Callable)new zznm(this, zzo2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzfz.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    static /* synthetic */ void zza(zzni zzni2, zzns zzns2) {
        zzni zzni3 = zzni2;
        zzni3.zzl().zzt();
        zzni zzni4 = zzni3;
        zzni3.zzl = new zzgt(zzni4);
        zzni4 = zzni3;
        zzal zzal2 = new zzal(zzni4);
        zzal2.zzal();
        zzni3.zzd = zzal2;
        zzni3.zze().zza((zzai)Preconditions.checkNotNull((Object)((Object)zzni3.zzb)));
        zzni4 = zzni3;
        zzmi zzmi2 = new zzmi(zzni4);
        zzmi2.zzal();
        zzni3.zzj = zzmi2;
        zzni4 = zzni3;
        zzu zzu2 = new zzu(zzni4);
        zzu2.zzal();
        zzni3.zzg = zzu2;
        zzni4 = zzni3;
        zzkt zzkt2 = new zzkt(zzni4);
        zzkt2.zzal();
        zzni3.zzi = zzkt2;
        zzni4 = zzni3;
        zznc zznc2 = new zznc(zzni4);
        zznc2.zzal();
        zzni3.zzf = zznc2;
        zzni4 = zzni3;
        zzni3.zze = new zzgj(zzni4);
        if (zzni3.zzs != zzni3.zzt) {
            zzni3.zzj().zzg().zza("Not all upload components initialized", (Object)zzni3.zzs, (Object)zzni3.zzt);
        }
        zzni3.zzn = true;
    }

    private zzni(zzns zzns2) {
        this(zzns2, null);
    }

    private zzni(zzns zzns2, @Nullable zzhm zzhm2) {
        Preconditions.checkNotNull((Object)zzns2);
        this.zzm = zzhm2 = zzhm.zza((Context)zzns2.zza, null, null);
        this.zzab = -1L;
        zzni zzni2 = this;
        this.zzk = new zzng(zzni2);
        zzni2 = this;
        zznr zznr2 = new zznr(zzni2);
        zznr2.zzal();
        this.zzh = zznr2;
        zzni2 = this;
        zzgg zzgg2 = new zzgg(zzni2);
        zzgg2.zzal();
        this.zzc = zzgg2;
        zzni2 = this;
        zzgz zzgz2 = new zzgz(zzni2);
        zzgz2.zzal();
        this.zzb = zzgz2;
        this.zzac = new HashMap<String, zziq>();
        this.zzad = new HashMap<String, zzav>();
        this.zzae = new HashMap<String, zzb>();
        this.zzl().zzb((Runnable)new zznh(this, zzns2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzt();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzr() {
        int n;
        this.zzl().zzt();
        this.zzs();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzad()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzab();
        int n4 = n2;
        zzni zzni2 = this;
        zzni2.zzl().zzt();
        if (n4 > n3) {
            zzni2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzni2.zza(n3, zzni2.zzy)) {
            zzni2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzni2.zzj().zzp().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzs() {
        if (!this.zzn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    @WorkerThread
    private final void zzaa() {
        this.zzl().zzt();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzp().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzp().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzfu.zzj.zza zza2) {
        int n;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzq(string)) {
            zza2.zzi();
        }
        if (this.zzi().zzt(string)) {
            if (this.zze().zze(string, zzbf.zzbw)) {
                int n2;
                String string2 = zza2.zzy();
                if (!TextUtils.isEmpty((CharSequence)string2) && (n2 = string2.indexOf(".")) != -1) {
                    string2 = string2.substring(0, n2);
                    zza2.zzo(string2);
                }
            } else {
                zza2.zzn();
            }
        }
        if (this.zzi().zzu(string) && (n = zznr.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzs(string)) {
            zza2.zzj();
        }
        if (this.zzi().zzp(string)) {
            zza2.zzg();
            if (!zzoe.zza() || !this.zze().zza(zzbf.zzdf) || this.zzb(string).zzj()) {
                zzb zzb2 = this.zzae.get(string);
                if (zzb2 == null || zzb2.zzb + this.zze().zzc(string, zzbf.zzau) < this.zzb().elapsedRealtime()) {
                    zzb2 = new zzb(this, null);
                    this.zzae.put(string, zzb2);
                }
                zza2.zzk(zzb2.zza);
            }
        }
        if (this.zzi().zzr(string)) {
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzl().zzt();
        if (TextUtils.isEmpty((CharSequence)zzg2.zzah()) && TextUtils.isEmpty((CharSequence)zzg2.zzaa())) {
            this.zza((String)Preconditions.checkNotNull((Object)zzg2.zzac()), 204, null, null, null);
            return;
        }
        Object object = zzg2;
        Object object2 = new Uri.Builder();
        String string = ((zzg)object).zzah();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = ((zzg)object).zzaa();
        }
        Object object3 = string;
        object2.scheme((String)zzbf.zze.zza(null)).encodedAuthority((String)zzbf.zzf.zza(null)).path("config/app/" + (String)object3).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "92000").appendQueryParameter("runtime_version", "0");
        String string2 = object2.build().toString();
        try {
            String string3 = (String)Preconditions.checkNotNull((Object)zzg2.zzac());
            URL uRL = new URL(string2);
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string3);
            zzfo.zzd zzd2 = this.zzi().zzc(string3);
            ArrayMap arrayMap = null;
            String string4 = this.zzi().zze(string3);
            if (zzd2 != null) {
                String string5;
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string4);
                }
                if (!TextUtils.isEmpty((CharSequence)(string5 = this.zzi().zzd(string3)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string5);
                }
            }
            this.zzu = true;
            object3 = new zznj(this);
            string = arrayMap;
            object2 = uRL;
            object = string3;
            zzgg zzgg2 = this.zzh();
            zzgg2.zzt();
            zzgg2.zzak();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)object3);
            zzgg2.zzl().zza((Runnable)new zzgk(zzgg2, (String)object, (URL)object2, null, (Map)((Object)string), (zzgf)object3));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzfz.zza((String)zzg2.zzac()), (Object)string2);
            return;
        }
    }

    @WorkerThread
    final void zza(zzg zzg2, zzfu.zzj.zza zza2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.zzl().zzt();
        this.zzs();
        zzah zzah2 = com.google.android.gms.measurement.internal.zzah.zza(zza2.zzv());
        if (com.google.android.gms.internal.measurement.zzny.zza() && this.zze().zza(zzbf.zzcy)) {
            object6 = zzah2;
            object5 = zzg2.zzac();
            object4 = this;
            ((zzni)object4).zzl().zzt();
            ((zzni)object4).zzs();
            object3 = ((zzni)object4).zzb((String)object5);
            switch (object3.zzc()) {
                case zzb: {
                    ((zzah)object6).zza(zziq.zza.zza, zzak.zzi);
                    break;
                }
                case zzd: 
                case zzc: {
                    ((zzah)object6).zza(zziq.zza.zza, object3.zza());
                    break;
                }
                default: {
                    ((zzah)object6).zza(zziq.zza.zza, zzak.zzj);
                }
            }
            switch (object3.zzd()) {
                case zzb: {
                    ((zzah)object6).zza(zziq.zza.zzb, zzak.zzi);
                    break;
                }
                case zzd: 
                case zzc: {
                    ((zzah)object6).zza(zziq.zza.zzb, object3.zza());
                    break;
                }
                default: {
                    ((zzah)object6).zza(zziq.zza.zzb, zzak.zzj);
                    break;
                }
            }
        } else {
            object3 = zzah2;
            object5 = zzg2.zzac();
            object4 = this;
            ((zzni)object4).zzl().zzt();
            ((zzni)object4).zzs();
            object2 = ((zzni)object4).zzb((String)object5);
            if (object2.zze() != null) {
                ((zzah)object3).zza(zziq.zza.zza, object2.zza());
            } else {
                ((zzah)object3).zza(zziq.zza.zza, zzak.zzj);
            }
            if (object2.zzf() != null) {
                ((zzah)object3).zza(zziq.zza.zzb, object2.zza());
            } else {
                ((zzah)object3).zza(zziq.zza.zzb, zzak.zzj);
            }
        }
        object3 = zzah2;
        object6 = zza2;
        object5 = zzg2.zzac();
        object4 = this;
        ((zzni)object4).zzl().zzt();
        ((zzni)object4).zzs();
        object2 = ((zzni)object4).zza((String)object5, ((zzni)object4).zzd((String)object5), ((zzni)object4).zzb((String)object5), (zzah)object3);
        ((zzfu.zzj.zza)((Object)object6)).zzb((Boolean)Preconditions.checkNotNull((Object)object2.zzd()));
        if (!TextUtils.isEmpty((CharSequence)object2.zze())) {
            ((zzfu.zzj.zza)((Object)object6)).zzh(object2.zze());
        }
        object3 = zzah2;
        object6 = zza2;
        object5 = zzg2;
        object4 = this;
        ((zzni)object4).zzl().zzt();
        ((zzni)object4).zzs();
        object2 = null;
        Object object7 = ((zzfu.zzj.zza)((Object)object6)).zzab().iterator();
        while (object7.hasNext()) {
            object = object7.next();
            if (!"_npa".equals(object.zzg())) continue;
            object2 = object;
            break;
        }
        if (object2 != null) {
            if (((zzah)object3).zza(zziq.zza.zzd) == zzak.zza) {
                if (zzqs.zza() && ((zzni)object4).zze().zza(zzbf.zzcx) && (object7 = ((zzni)object4).zzf().zze(((zzg)object5).zzac(), "_npa")) != null) {
                    if ("tcf".equals(((zznv)object7).zzb)) {
                        ((zzah)object3).zza(zziq.zza.zzd, zzak.zzh);
                    } else if ("app".equals(((zznv)object7).zzb)) {
                        ((zzah)object3).zza(zziq.zza.zzd, zzak.zzf);
                    } else {
                        ((zzah)object3).zza(zziq.zza.zzd, zzak.zzd);
                    }
                } else {
                    object7 = ((zzg)object5).zzx();
                    if (object7 == null || object7 == Boolean.TRUE && ((zzfu.zzn)((Object)object2)).zzc() != 1L || object7 == Boolean.FALSE && ((zzfu.zzn)((Object)object2)).zzc() != 0L) {
                        ((zzah)object3).zza(zziq.zza.zzd, zzak.zzf);
                    } else {
                        ((zzah)object3).zza(zziq.zza.zzd, zzak.zzd);
                    }
                }
            }
        } else {
            int n = ((zzni)object4).zza(((zzg)object5).zzac(), (zzah)object3);
            ((zzfu.zzj.zza)((Object)object6)).zza((zzfu.zzn)((zzjv)zzfu.zzn.zze().zza("_npa").zzb(((zzni)object4).zzb().currentTimeMillis()).zza(n).zzah()));
        }
        zza2.zzf(zzah2.toString());
        if (zzqs.zza() && this.zze().zza(zzbf.zzcx)) {
            boolean bl = this.zzb.zzn(zzg2.zzac());
            object4 = zza2;
            object3 = ((zzfu.zzj.zza)((Object)object4)).zzaa();
            for (int i = 0; i < object3.size(); ++i) {
                if (!"_tcf".equals(((zzfu.zze)((Object)object3.get(i))).zzg())) continue;
                zzfu.zze.zza zza3 = (zzfu.zze.zza)((zzfu.zze)((Object)object3.get(i))).zzca();
                object = zza3.zzf();
                for (int j = 0; j < object.size(); ++j) {
                    if (!"_tcfd".equals(((zzfu.zzg)((Object)object.get(j))).zzg())) continue;
                    String string = zzmy.zza((String)((zzfu.zzg)((Object)object.get(j))).zzh(), (boolean)bl);
                    zza3.zza(j, zzfu.zzg.zze().zza("_tcfd").zzb(string));
                    break;
                }
                ((zzfu.zzj.zza)((Object)object4)).zza(i, zza3);
                return;
            }
        }
    }

    @VisibleForTesting
    private static void zza(zzfu.zze.zza zza2, int n, String string) {
        List<zzfu.zzg> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzg())) continue;
            return;
        }
        zzfu.zzg zzg2 = (zzfu.zzg)((zzjv)zzfu.zzg.zze().zza("_err").zza(n).zzah());
        zzfu.zzg zzg3 = (zzfu.zzg)((zzjv)zzfu.zzg.zze().zza("_ev").zzb(string).zzah());
        zza2.zza(zzg2).zza(zzg3);
    }

    @WorkerThread
    final void zza(zzbd zzbd2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zzl().zzt();
        this.zzs();
        String string = zzo2.zza;
        long l = zzbd2.zzd;
        zzgd zzgd2 = zzgd.zza((zzbd)zzbd2);
        String string2 = string;
        zzio zzio2 = this;
        zzio2.zzl().zzt();
        zzny.zza(zzio2.zzaf == null || zzio2.zzag == null || !zzio2.zzag.equals(string2) ? null : zzio2.zzaf, (Bundle)zzgd2.zzb, (boolean)false);
        zzbd2 = zzgd2.zza();
        this.zzp();
        if (!zznr.zza(zzbd2, zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        if (zzo2.zzs != null) {
            if (zzo2.zzs.contains(zzbd2.zza)) {
                Bundle bundle = zzbd2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbd2 = new zzbd(zzbd2.zza, new zzbc(bundle), zzbd2.zzc, zzbd2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbd2.zza, (Object)zzbd2.zzc);
                return;
            }
        }
        this.zzf().zzp();
        try {
            zzae zzae2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            long l2 = l;
            string2 = string;
            zzio2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzio2.zzt();
            zzio2.zzak();
            if (l2 < 0L) {
                zzio2.zzj().zzu().zza("Invalid time querying timed out conditional properties", zzfz.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zzio2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzp().zza("User property timed out", (Object)((zzae)object22).zza, (Object)this.zzm.zzk().zzc(((zzae)object22).zzc.zza), ((zzae)object22).zzc.zza());
                if (((zzae)object22).zzg != null) {
                    this.zzc(new zzbd(((zzae)object22).zzg, l), zzo2);
                }
                this.zzf().zza(string, ((zzae)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zzio2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzio2.zzt();
            zzio2.zzak();
            if (l2 < 0L) {
                zzio2.zzj().zzu().zza("Invalid time querying expired conditional properties", zzfz.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zzio2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzae)object4.next();
                if (object == null) continue;
                this.zzj().zzp().zza("User property expired", (Object)((zzae)object).zza, (Object)this.zzm.zzk().zzc(((zzae)object).zzc.zza), ((zzae)object).zzc.zza());
                this.zzf().zzh(string, ((zzae)object).zzc.zza);
                if (((zzae)object).zzk != null) {
                    object22.add(((zzae)object).zzk);
                }
                this.zzf().zza(string, ((zzae)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbd)e;
                this.zzc(new zzbd((zzbd)object, l), zzo2);
            }
            long l3 = l;
            String string4 = zzbd2.zza;
            string2 = string;
            zzio2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zzio2.zzt();
            zzio2.zzak();
            if (l3 < 0L) {
                zzio2.zzj().zzu().zza("Invalid time querying triggered conditional properties", zzfz.zza((String)string2), (Object)zzio2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zzio2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzae2 = (zzae)iterator.next();
                if (zzae2 == null) continue;
                zznt zznt2 = zzae2.zzc;
                zznv zznv2 = new zznv((String)Preconditions.checkNotNull((Object)zzae2.zza), zzae2.zzb, zznt2.zza, l, Preconditions.checkNotNull((Object)zznt2.zza()));
                if (this.zzf().zza(zznv2)) {
                    this.zzj().zzp().zza("User property triggered", (Object)zzae2.zza, (Object)this.zzm.zzk().zzc(zznv2.zzc), zznv2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzfz.zza((String)zzae2.zza), (Object)this.zzm.zzk().zzc(zznv2.zzc), zznv2.zze);
                }
                if (zzae2.zzi != null) {
                    object.add(zzae2.zzi);
                }
                zzae2.zzc = new zznt(zznv2);
                zzae2.zze = true;
                this.zzf().zza(zzae2);
            }
            this.zzc(zzbd2, zzo2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzae2 = (zzbd)e;
                this.zzc(new zzbd((zzbd)zzae2, l), zzo2);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(zzbd zzbd2, String string) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzbd2.zza)) {
                this.zzj().zzu().zza("Could not find package. appId", zzfz.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzfz.zza((String)string));
            return;
        }
        zzo zzo2 = new zzo(string, zzg2.zzah(), zzg2.zzaf(), zzg2.zze(), zzg2.zzae(), zzg2.zzq(), zzg2.zzn(), null, zzg2.zzar(), false, zzg2.zzag(), zzg2.zzd(), 0L, 0, zzg2.zzaq(), false, zzg2.zzaa(), zzg2.zzx(), zzg2.zzo(), zzg2.zzan(), null, this.zzb(string).zzh(), "", null, zzg2.zzat(), zzg2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzg2.zza(), zzg2.zzf(), zzg2.zzam(), zzg2.zzak());
        this.zzb(zzbd2, zzo2);
    }

    @WorkerThread
    private final void zzb(zzbd zzbd2, zzo zzo2) {
        zznt zznt2;
        String string;
        Preconditions.checkNotEmpty((String)zzo2.zza);
        zzgd zzgd2 = zzgd.zza((zzbd)zzbd2);
        this.zzq().zza(zzgd2.zzb, this.zzf().zzd(zzo2.zza));
        this.zzq().zza(zzgd2, this.zze().zzb(zzo2.zza));
        zzbd2 = zzgd2.zza();
        zzo zzo3 = zzo2;
        zzbd zzbd3 = zzbd2;
        zzni zzni2 = this;
        if ("_cmp".equals(zzbd3.zza) && "referrer API v2".equals(zzbd3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbd3.zzb.zzd("gclid")))) {
            zznt2 = new zznt("_lgclid", zzbd3.zzd, (Object)string, "auto");
            zzni2.zza(zznt2, zzo3);
        }
        if (zzpc.zza() && zzpc.zzc()) {
            zzo3 = zzo2;
            zzbd3 = zzbd2;
            zzni2 = this;
            if ("_cmp".equals(zzbd3.zza) && "referrer API v2".equals(zzbd3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbd3.zzb.zzd("gbraid")))) {
                zznt2 = new zznt("_gbraid", zzbd3.zzd, (Object)string, "auto");
                zzni2.zza(zznt2, zzo3);
            }
        }
        this.zza(zzbd2, zzo2);
    }

    @VisibleForTesting
    private final void zza(zzfu.zzj.zza zza2, long l, boolean bl) {
        zznv zznv2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zznv2 = (zznv2 = this.zzf().zze(zza2.zzt(), string)) == null || zznv2.zze == null ? new zznv(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zznv(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zznv2.zze + l));
        zzfu.zzn zzn2 = (zzfu.zzn)((zzjv)zzfu.zzn.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza((Long)zznv2.zze).zzah());
        boolean bl2 = false;
        int n = zznr.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzn2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzn2);
        }
        if (l > 0L) {
            this.zzf().zza(zznv2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzp().zza("Updated engagement user property. scope, value", (Object)string2, zznv2.zze);
        }
    }

    final void zzt() {
        ++this.zzt;
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzp().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzp();
            try {
                boolean bl;
                zzg zzg2 = this.zzf().zze(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzj().zzu().zza("App does not exist in onConfigFetched. appId", zzfz.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = list != null && !list.isEmpty() ? list.get(0) : null;
                    List<String> list2 = map != null ? map.get("ETag") : null;
                    String string4 = string2 = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string3, string2)) {
                        return;
                    }
                    zzg2.zzd(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2, false, false);
                    if (n == 404) {
                        this.zzj().zzv().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzp().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab();
                    }
                } else {
                    zzg2.zzm(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2, false, false);
                    this.zzj().zzp().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzab();
                }
                this.zzf().zzw();
            }
            finally {
                this.zzf().zzu();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzaa();
        }
    }

    final void zza(boolean bl) {
        this.zzab();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string) {
        this.zzl().zzt();
        this.zzs();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (zzoj.zza() && this.zze().zza(zzbf.zzcr) && !bl || (n == 200 || n == 204) && throwable == null) {
                try {
                    if (!zzoj.zza() || !this.zze().zza(zzbf.zzcr) || bl) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zzd.zza(0L);
                    this.zzab();
                    if (!zzoj.zza() || !this.zze().zza(zzbf.zzcr) || bl) {
                        this.zzj().zzp().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else if (zzoj.zza() && this.zze().zza(zzbf.zzcr)) {
                        this.zzj().zzp().zza("Purged empty bundles");
                    }
                    this.zzf().zzp();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzal zzal2 = this.zzf();
                                zzal2.zzt();
                                zzal2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzal2.e_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzal2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzw();
                    }
                    finally {
                        this.zzf().zzu();
                    }
                    this.zzaa = null;
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab = -1L;
                        this.zzab();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzp().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                this.zzj().zzp().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list);
                this.zzab();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    final void zzc(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zzni.zzh(zzo2)) {
            return;
        }
        zzg zzg2 = this.zzf().zze(zzo2.zza);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.zzah()) && !TextUtils.isEmpty((CharSequence)zzo2.zzb)) {
            zzg2.zzd(0L);
            this.zzf().zza(zzg2, false, false);
            this.zzi().zzj(zzo2.zza);
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        long l = zzo2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzm();
        int n = zzo2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzu().zza("Incorrect app type, assuming installed app. appId, appType", zzfz.zza((String)zzo2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzp();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzal zzal2;
            String string2;
            zznt zznt2;
            zznv zznv2 = this.zzf().zze(zzo2.zza, "_npa");
            Boolean bl = this.zzg(zzo2);
            if (zznv2 == null || "auto".equals(zznv2.zzb)) {
                if (bl != null) {
                    zznt2 = new zznt("_npa", l, (Object)(bl != false ? 1L : 0L), "auto");
                    if (zznv2 == null || !zznv2.zze.equals(zznt2.zzc)) {
                        this.zza(zznt2, zzo2);
                    }
                } else if (zznv2 != null) {
                    this.zza("_npa", zzo2);
                }
            }
            long l2 = l;
            zzo zzo3 = zzo2;
            zzni zzni2 = this;
            Object object3 = zzni2.zzf().zze((String)Preconditions.checkNotNull((Object)zzo3.zza));
            if (object3 != null) {
                zzni2.zzq();
                if (zzny.zza((String)zzo3.zzb, (String)((zzg)object3).zzah(), (String)zzo3.zzp, (String)((zzg)object3).zzaa())) {
                    zzni2.zzj().zzu().zza("New GMP App Id passed in. Removing cached database data. appId", zzfz.zza((String)((zzg)object3).zzac()));
                    string2 = ((zzg)object3).zzac();
                    zzal2 = zzni2.zzf();
                    zzal2.zzak();
                    zzal2.zzt();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzal2.e_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzal2.zzj().zzp().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzal2.zzj().zzg().zza("Error deleting application data. appId, error", zzfz.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl2 = ((zzg)object3).zze() != Integer.MIN_VALUE && ((zzg)object3).zze() != zzo3.zzj;
                string = ((zzg)object3).zzaf();
                if (bl2 | (((zzg)object3).zze() == Integer.MIN_VALUE && string != null && !string.equals(zzo3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbd("_au", new zzbc(bundle), "auto", l2);
                    zzni2.zza((zzbd)object, zzo3);
                }
            }
            this.zza(zzo2);
            zznt2 = null;
            if (n == 0) {
                zznt2 = this.zzf().zzd(zzo2.zza, "_f");
            } else if (n == 1) {
                zznt2 = this.zzf().zzd(zzo2.zza, "_v");
            }
            if (zznt2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zznt zznt3 = new zznt("_fot", l, (Object)l3, "auto");
                    this.zza(zznt3, zzo2);
                    zzo3 = zzo2;
                    zzni2 = this;
                    zzni2.zzl().zzt();
                    String string3 = zzo3.zza;
                    zzgt zzgt2 = (zzgt)Preconditions.checkNotNull((Object)zzni2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzgt2.zza.zzj().zzw().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzgt2.zza.zzl().zzt();
                        if (!zzgt2.zza()) {
                            zzgt2.zza.zzj().zzn().zza("Install Referrer Reporter is not available");
                        } else {
                            zzgw zzgw2 = new zzgw(zzgt2, string3);
                            object3 = zzgt2;
                            ((zzgt)object3).zza.zzl().zzt();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzgt)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzgt)object3).zza.zzj().zzw().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzal2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzal2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzal2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzal2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzgt)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl3 = ConnectionTracker.getInstance().bindService(((zzgt)object3).zza.zza(), intent, (ServiceConnection)zzgw2, 1);
                                                ((zzgt)object3).zza.zzj().zzp().zza("Install Referrer Service is", (Object)(bl3 ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzgt)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzgt)object3).zza.zzj().zzu().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzgt)object3).zza.zzj().zzn().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzo3 = zzo2;
                    zzni2 = this;
                    zzni2.zzl().zzt();
                    zzni2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
                    object2 = string4;
                    zzal zzal3 = zzni2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzal3.zzt();
                    zzal3.zzak();
                    long l5 = zzal3.zzb((String)object2, "first_open_count");
                    if (zzni2.zzm.zza().getPackageManager() == null) {
                        zzni2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzfz.zza((String)string4));
                    } else {
                        zzal2 = null;
                        try {
                            zzal2 = Wrappers.packageManager((Context)zzni2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzni2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzfz.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzal2 != null && ((PackageInfo)zzal2).firstInstallTime != 0L) {
                            boolean bl4 = false;
                            if (((PackageInfo)zzal2).firstInstallTime != ((PackageInfo)zzal2).lastUpdateTime) {
                                if (zzni2.zze().zza(zzbf.zzbm)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl4 = true;
                            }
                            sQLiteDatabase = new zznt("_fi", l4, (Object)(bl4 ? 1L : 0L), "auto");
                            zzni2.zza((zznt)sQLiteDatabase, zzo3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzni2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzni2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzfz.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzal2 = new zzbd("_f", new zzbc((Bundle)object3), "auto", l4);
                    zzni2.zzb((zzbd)zzal2, zzo3);
                } else if (n == 1) {
                    zznt zznt4 = new zznt("_fvt", l, (Object)l3, "auto");
                    this.zza(zznt4, zzo2);
                    l2 = l;
                    zzo3 = zzo2;
                    zzni2 = this;
                    zzni2.zzl().zzt();
                    zzni2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbd zzbd2 = new zzbd("_v", new zzbc((Bundle)object3), "auto", l2);
                    zzni2.zzb(zzbd2, zzo3);
                }
            } else if (zzo2.zzi) {
                l2 = l;
                zzo3 = zzo2;
                zzni2 = this;
                object3 = new Bundle();
                zzbd zzbd3 = new zzbd("_cd", new zzbc((Bundle)object3), "auto", l2);
                zzni2.zzb(zzbd3, zzo3);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    final void zzu() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzae zzae2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzae2.zza));
        if (zzo2 != null) {
            this.zza(zzae2, zzo2);
        }
    }

    @WorkerThread
    final void zza(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zzni.zzh(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            String string = (String)Preconditions.checkNotNull((Object)zzae2.zza);
            zzae zzae3 = this.zzf().zzc(string, zzae2.zzc.zza);
            if (zzae3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzae2.zza, (Object)this.zzm.zzk().zzc(zzae2.zzc.zza));
                this.zzf().zza(string, zzae2.zzc.zza);
                if (zzae3.zze) {
                    this.zzf().zzh(string, zzae2.zzc.zza);
                }
                if (zzae2.zzk != null) {
                    Bundle bundle = null;
                    if (zzae2.zzk.zzb != null) {
                        bundle = zzae2.zzk.zzb.zzb();
                    }
                    zzbd zzbd2 = this.zzq().zza(string, ((zzbd)Preconditions.checkNotNull((Object)zzae2.zzk)).zza, bundle, zzae3.zzb, zzae2.zzk.zzd, true, true);
                    this.zzc((zzbd)Preconditions.checkNotNull((Object)zzbd2), zzo2);
                }
            } else {
                this.zzj().zzu().zza("Conditional user property doesn't exist", zzfz.zza((String)zzae2.zza), (Object)this.zzm.zzk().zzc(zzae2.zzc.zza));
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting
    private static void zza(zzfu.zze.zza zza2, @NonNull String string) {
        List<zzfu.zzg> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zzni.zzh(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        Boolean bl = this.zzg(zzo2);
        if ("_npa".equals(string) && bl != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zznt zznt2 = new zznt("_npa", this.zzb().currentTimeMillis(), (Object)(bl != false ? 1L : 0L), "auto");
            this.zza(zznt2, zzo2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), string);
            this.zzf().zzw();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zzd(zzo zzo2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzo2.zza);
        zzal zzal2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzal2.zzt();
        zzal2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzal2.e_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("events_snapshot", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray);
            if (n > 0) {
                zzal2.zzj().zzp().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzal2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzfz.zza((String)string), (Object)sQLiteException);
        }
        if (zzo2.zzh) {
            this.zzc(zzo2);
        }
    }

    @WorkerThread
    final void zze(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzo2.zza);
        zzav zzav2 = zzav.zza((String)zzo2.zzz);
        this.zzj().zzp().zza("Setting DMA consent. package, consent", (Object)zzo2.zza, (Object)zzav2);
        this.zza(zzo2.zza, zzav2);
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzkv zzkv2) {
        this.zzl().zzt();
        if (this.zzag == null || this.zzag.equals(string) || zzkv2 != null) {
            this.zzag = string;
            this.zzaf = zzkv2;
        }
    }

    @WorkerThread
    final void zzf(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzo2.zza);
        int n = zzo2.zzy;
        zziq zziq2 = zziq.zza((String)zzo2.zzt, (int)n);
        zziq zziq3 = this.zzb(zzo2.zza);
        this.zzj().zzp().zza("Setting storage consent, package, consent", (Object)zzo2.zza, (Object)zziq2);
        this.zza(zzo2.zza, zziq2);
        if (!(zzoe.zza() && this.zze().zza(zzbf.zzdf) || !zziq2.zzc(zziq3))) {
            this.zzd(zzo2);
        }
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzv() {
        this.zzl().zzt();
        this.zzf().zzv();
        if (this.zzj.zzc.zza() == 0L) {
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzab();
    }

    @WorkerThread
    final void zzb(zzae zzae2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzae2.zza));
        if (zzo2 != null) {
            this.zzb(zzae2, zzo2);
        }
    }

    @WorkerThread
    final void zzb(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        Preconditions.checkNotNull((Object)zzae2.zzb);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zzni.zzh(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        zzae zzae3 = new zzae(zzae2);
        new zzae(zzae2).zze = false;
        this.zzf().zzp();
        try {
            boolean bl = false;
            zzae zzae4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzae3.zza), zzae3.zzc.zza);
            if (zzae4 != null && !zzae4.zzb.equals(zzae3.zzb)) {
                this.zzj().zzu().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), (Object)zzae3.zzb, (Object)zzae4.zzb);
            }
            if (zzae4 != null && zzae4.zze) {
                zzae3.zzb = zzae4.zzb;
                zzae3.zzd = zzae4.zzd;
                zzae3.zzh = zzae4.zzh;
                zzae3.zzf = zzae4.zzf;
                zzae3.zzi = zzae4.zzi;
                zzae3.zze = zzae4.zze;
                zzae3.zzc = new zznt(zzae3.zzc.zza, zzae4.zzc.zzb, zzae3.zzc.zza(), zzae4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzae3.zzf)) {
                zzae3.zzc = new zznt(zzae3.zzc.zza, zzae3.zzd, zzae3.zzc.zza(), zzae3.zzc.zze);
                zzae3.zze = true;
                bl = true;
            }
            if (zzae3.zze) {
                zznt zznt2 = zzae3.zzc;
                zznv zznv2 = new zznv((String)Preconditions.checkNotNull((Object)zzae3.zza), zzae3.zzb, zznt2.zza, zznt2.zzb, Preconditions.checkNotNull((Object)zznt2.zza()));
                if (this.zzf().zza(zznv2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzae3.zza, (Object)this.zzm.zzk().zzc(zznv2.zzc), zznv2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzfz.zza((String)zzae3.zza), (Object)this.zzm.zzk().zzc(zznv2.zzc), zznv2.zze);
                }
                if (bl && zzae3.zzi != null) {
                    zzbd zzbd2 = new zzbd(zzae3.zzi, zzae3.zzd);
                    this.zzc(zzbd2, zzo2);
                }
            }
            if (this.zzf().zza(zzae3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzae3.zza, (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), zzae3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzfz.zza((String)zzae3.zza), (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), zzae3.zzc.zza());
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(String string, zzav zzav2) {
        boolean bl;
        zzit zzit2;
        this.zzl().zzt();
        this.zzs();
        zzit zzit3 = zzav.zza((Bundle)this.zza(string), (int)100).zzc();
        this.zzad.put(string, zzav2);
        this.zzf().zza(string, zzav2);
        zzit zzit4 = zzit2 = zzav.zza((Bundle)this.zza(string), (int)100).zzc();
        zzit zzit5 = zzit3;
        String string2 = string;
        zzni zzni2 = this;
        zzni2.zzl().zzt();
        zzni2.zzs();
        boolean bl2 = zzit5 == zzit.zzc && zzit4 == zzit.zzd;
        boolean bl3 = bl = zzit5 == zzit.zzd && zzit4 == zzit.zzc;
        boolean bl4 = zzni2.zze().zza(zzbf.zzcn) ? bl2 || bl : bl2;
        if (bl4) {
            zzni2.zzj().zzp().zza("Generated _dcu event for", (Object)string2);
            Bundle bundle = new Bundle();
            if (zzni2.zzf().zza((long)zzni2.zzx(), (String)string2, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzf < (long)zzni2.zze().zzb(string2, zzbf.zzaw)) {
                bundle.putLong("_r", 1L);
                zzaq zzaq2 = zzni2.zzf().zza(zzni2.zzx(), string2, false, false, false, false, false, true);
                zzni2.zzj().zzp().zza("_dcu realtime event count", (Object)string2, (Object)zzaq2.zzf);
            }
            zzni2.zzah.zza(string2, "_dcu", bundle);
        }
    }

    @WorkerThread
    private final void zzab() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzt();
            this.zzs();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzp().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzy().zzb();
                    this.zzz().zzu();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzaf() || !this.zzac()) {
                this.zzj().zzp().zza("Nothing to upload or uploading impossible");
                this.zzy().zzb();
                this.zzz().zzu();
                return;
            }
            zzni zzni2 = this;
            long l5 = zzni2.zzb().currentTimeMillis();
            zzni2.zze();
            long l6 = Math.max(0L, (Long)zzbf.zzaa.zza(null));
            boolean bl = zzni2.zzf().zzz() || zzni2.zzf().zzy();
            if (bl) {
                String string = zzni2.zze().zzn();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zzni2.zze();
                    l4 = Math.max(0L, (Long)zzbf.zzv.zza(null));
                } else {
                    zzni2.zze();
                    l4 = Math.max(0L, (Long)zzbf.zzu.zza(null));
                }
            } else {
                zzni2.zze();
                l4 = Math.max(0L, (Long)zzbf.zzt.zza(null));
            }
            long l7 = zzni2.zzj.zzc.zza();
            long l8 = zzni2.zzj.zzd.zza();
            long l9 = zzni2.zzf().c_();
            long l10 = zzni2.zzf().d_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zzni2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zzni2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbf.zzac.zza(null)))) break;
                        long l15 = 1L << n;
                        zzni2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbf.zzab.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzp().zza("Next upload time is 0");
            this.zzy().zzb();
            this.zzz().zzu();
            return;
        }
        if (!this.zzh().zzu()) {
            this.zzj().zzp().zza("No network");
            this.zzy().zza();
            this.zzz().zzu();
            return;
        }
        l2 = this.zzj.zzb.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbf.zzr.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzy().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbf.zzw.zza(null));
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzp().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzz().zza(l17);
    }

    @WorkerThread
    final void zza(String string, zziq zziq2) {
        this.zzl().zzt();
        this.zzs();
        this.zzac.put(string, zziq2);
        this.zzf().zzb(string, zziq2);
    }

    @WorkerThread
    private final void zza(String string, boolean bl, @Nullable Long l, @Nullable Long l2) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 != null) {
            zzg2.zzd(bl);
            zzg2.zza(l);
            zzg2.zzb(l2);
            if (zzg2.zzas()) {
                this.zzf().zza(zzg2, false, false);
            }
        }
    }

    @WorkerThread
    final void zza(zznt zznt2, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zzni.zzh(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        int n = this.zzq().zzb(zznt2.zza);
        if (n != 0) {
            this.zzq();
            String string = zznt2.zza;
            this.zze();
            String string2 = zzny.zza((String)string, (int)24, (boolean)true);
            int n2 = zznt2.zza != null ? zznt2.zza.length() : 0;
            this.zzq();
            zzny.zza((zznx)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zznt2.zza, zznt2.zza());
        if (n != 0) {
            this.zzq();
            String string = zznt2.zza;
            this.zze();
            String string3 = zzny.zza((String)string, (int)24, (boolean)true);
            Object object = zznt2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zzny.zza((zznx)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zznt2.zza, zznt2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zznt2.zza)) {
            zzaz zzaz2;
            zzo zzo3 = zzo2;
            String string = zznt2.zze;
            long l = zznt2.zzb;
            zzni zzni2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
            long l2 = 0L;
            zznv zznv2 = zzni2.zzf().zze(string4, "_sno");
            if (zznv2 != null && zznv2.zze instanceof Long) {
                l2 = (Long)zznv2.zze;
            } else {
                if (zznv2 != null) {
                    zzni2.zzj().zzu().zza("Retrieved last session number from database does not contain a valid (long) value", zznv2.zze);
                }
                if ((zzaz2 = zzni2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzaz2.zzc;
                    zzni2.zzj().zzp().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzaz2 = new zznt("_sno", l, (Object)(++l2), string);
            zzni2.zza((zznt)zzaz2, zzo3);
        }
        zznv zznv3 = new zznv((String)Preconditions.checkNotNull((Object)zzo2.zza), (String)Preconditions.checkNotNull((Object)zznt2.zze), zznt2.zza, zznt2.zzb, object);
        this.zzj().zzp().zza("Setting user property", (Object)this.zzm.zzk().zzc(zznv3.zzc), object, (Object)zznv3.zzb);
        this.zzf().zzp();
        try {
            zznv zznv4;
            if ("_id".equals(zznv3.zzc) && (zznv4 = this.zzf().zze(zzo2.zza, "_id")) != null && !zznv3.zze.equals(zznv4.zze)) {
                this.zzf().zzh(zzo2.zza, "_lair");
            }
            this.zza(zzo2);
            boolean bl = this.zzf().zza(zznv3);
            if ("_sid".equals(zznt2.zza)) {
                long l = this.zzp().zza(zzo2.zzv);
                zzg zzg2 = this.zzf().zze(zzo2.zza);
                if (zzg2 != null) {
                    zzg2.zzs(l);
                    if (zzg2.zzas()) {
                        this.zzf().zza(zzg2, false, false);
                    }
                }
            }
            this.zzf().zzw();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zznv3.zzc), zznv3.zze);
                this.zzq();
                zzny.zza((zznx)this.zzah, (String)zzo2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zzw() {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzr().zzab();
            if (bl == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzab();
                return;
            }
            zzio zzio2 = this;
            zzio2.zzl().zzt();
            if (zzio2.zzz != null) {
                this.zzj().zzp().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzab();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbf.zzas);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzag.zzh();
            for (int i = 0; i < n && this.zza(null, l2 = l4); ++i) {
            }
            if (zzpz.zza()) {
                zzio2 = this;
                zzio2.zzl().zzt();
                for (String object7 : zzio2.zzr) {
                    if (!zzpz.zza() || !zzio2.zze().zze(object7, zzbf.zzce)) continue;
                    zzio2.zzj().zzc().zza("Notifying app that trigger URIs are available. App ID", (Object)object7);
                    Intent intent = new Intent();
                    intent.setAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
                    intent.setPackage(object7);
                    zzio2.zzm.zza().sendBroadcast(intent);
                }
                zzio2.zzr.clear();
            }
            if ((l = this.zzj.zzc.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().f_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().b_();
                }
                int n2 = this.zze().zzb(string, zzbf.zzg);
                Object object = string;
                zzio2 = this.zze();
                int n3 = Math.max(0, zzio2.zzb((String)object, zzbf.zzh));
                List<Pair<zzfu.zzj, Long>> list = this.zzf().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    if (this.zzb(string).zzi()) {
                        object6 = null;
                        Iterator<Pair<zzfu.zzj, Long>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            zzfu.zzj zzj2 = (zzfu.zzj)((Object)iterator.next().first);
                            if (zzj2.zzam().isEmpty()) continue;
                            object6 = zzj2.zzam();
                            break;
                        }
                        if (object6 != null) {
                            for (int i = 0; i < list.size(); ++i) {
                                object5 = (zzfu.zzj)((Object)list.get((int)i).first);
                                if (((zzfu.zzj)((Object)object5)).zzam().isEmpty() || ((zzfu.zzj)((Object)object5)).zzam().equals(object6)) continue;
                                list = list.subList(0, i);
                                break;
                            }
                        }
                    }
                    object6 = zzfu.zzi.zzb();
                    int n4 = list.size();
                    object5 = new ArrayList(list.size());
                    boolean bl2 = this.zze().zzk(string) && this.zzb(string).zzi();
                    boolean bl3 = this.zzb(string).zzi();
                    boolean bl4 = this.zzb(string).zzj();
                    boolean bl5 = zzql.zza() && this.zze().zze(string, zzbf.zzbs);
                    Pair<zznf, Boolean> pair = this.zzk.zzb(string);
                    boolean bl6 = (Boolean)pair.second;
                    if (zzqr.zza() && this.zze().zza(zzbf.zzbt)) {
                        this.zzq();
                        if (zzny.zzf((String)string)) {
                            String string2 = this.zzi().zzf(string);
                            if (!bl6 && !TextUtils.isEmpty((CharSequence)string2)) {
                                ((zzfu.zzi.zzb)((Object)object6)).zza(string2);
                            }
                        }
                    }
                    for (int i = 0; i < n4; ++i) {
                        object4 = (zzfu.zzj.zza)((zzfu.zzj)((Object)list.get((int)i).first)).zzca();
                        object5.add((Long)list.get((int)i).second);
                        this.zze();
                        ((zzfu.zzj.zza)((Object)object4)).zzl(92000L).zzk(l3).zzd(false);
                        if (!bl2) {
                            ((zzfu.zzj.zza)((Object)object4)).zzj();
                        }
                        if (!bl3) {
                            ((zzfu.zzj.zza)((Object)object4)).zzq();
                            ((zzfu.zzj.zza)((Object)object4)).zzm();
                        }
                        if (!bl4) {
                            ((zzfu.zzj.zza)((Object)object4)).zzg();
                        }
                        this.zza(string, (zzfu.zzj.zza)((Object)object4));
                        if (!bl5) {
                            ((zzfu.zzj.zza)((Object)object4)).zzr();
                        }
                        if (zzoe.zza() && this.zze().zza(zzbf.zzdg) && !bl4) {
                            ((zzfu.zzj.zza)((Object)object4)).zzh();
                        }
                        if (zzoj.zza() && this.zze().zza(zzbf.zzcr)) {
                            object = object4;
                            zzio2 = this;
                            String string3 = ((zzfu.zzj.zza)((Object)object)).zzz();
                            boolean bl7 = false;
                            if (TextUtils.isEmpty((CharSequence)string3) || string3.equals("00000000-0000-0000-0000-000000000000")) {
                                object3 = new ArrayList<zzfu.zze>(((zzfu.zzj.zza)((Object)object)).zzaa());
                                boolean bl8 = false;
                                Iterator iterator = object3.iterator();
                                Long l5 = null;
                                Long l6 = null;
                                while (iterator.hasNext()) {
                                    zzfu.zze zze2 = (zzfu.zze)((Object)iterator.next());
                                    if ("_fx".equals(zze2.zzg())) {
                                        bl7 = true;
                                        iterator.remove();
                                        bl8 = true;
                                        continue;
                                    }
                                    if (!"_f".equals(zze2.zzg())) continue;
                                    bl7 = true;
                                    if (!zzio2.zze().zza(zzbf.zzdc)) continue;
                                    zzio2.zzp();
                                    zzfu.zzg zzg2 = zznr.zza(zze2, "_pfo");
                                    if (zzg2 != null) {
                                        l5 = zzg2.zzd();
                                    }
                                    zzio2.zzp();
                                    zzfu.zzg zzg3 = zznr.zza(zze2, "_uwa");
                                    if (zzg3 == null) continue;
                                    l6 = zzg3.zzd();
                                }
                                if (bl8) {
                                    ((zzfu.zzj.zza)((Object)object)).zzk();
                                    ((zzfu.zzj.zza)((Object)object)).zzb((Iterable<? extends zzfu.zze>)object3);
                                }
                                if (bl7) {
                                    super.zza(((zzfu.zzj.zza)((Object)object)).zzt(), true, l5, l6);
                                }
                            }
                            if (((zzfu.zzj.zza)((Object)object4)).zzc() == 0) continue;
                        }
                        if (this.zze().zze(string, zzbf.zzbg)) {
                            object2 = ((zzfu.zzj)((zzjv)object4.zzah())).zzbx();
                            ((zzfu.zzj.zza)((Object)object4)).zza(this.zzp().zza((byte[])object2));
                        }
                        if (zzqr.zza() && this.zze().zza(zzbf.zzbt)) {
                            this.zzq();
                            if (zzny.zzf((String)string) && !bl6) {
                                ((zzfu.zzj.zza)((Object)object4)).zzj();
                            }
                        }
                        ((zzfu.zzi.zzb)((Object)object6)).zza((zzfu.zzj.zza)((Object)object4));
                    }
                    if (zzoj.zza() && this.zze().zza(zzbf.zzcr) && ((zzfu.zzi.zzb)((Object)object6)).zza() == 0) {
                        this.zza((List<Long>)object5);
                        this.zza(false, 204, null, null, string);
                        return;
                    }
                    String string4 = null;
                    if (this.zzj().zza(2)) {
                        string4 = this.zzp().zza((zzfu.zzi)((zzjv)object6.zzah()));
                    }
                    this.zzp();
                    object4 = ((zzfu.zzi)((zzjv)object6.zzah())).zzbx();
                    try {
                        this.zza((List<Long>)object5);
                        this.zzj.zzd.zza(l3);
                        object2 = "?";
                        if (n4 > 0) {
                            object2 = ((zzfu.zzi.zzb)((Object)object6)).zza(0).zzy();
                        }
                        this.zzj().zzp().zza("Uploading data. app, uncompressed size, data", object2, (Object)((Object)object4).length, (Object)string4);
                        this.zzv = true;
                        zznk zznk2 = new zznk(this, string);
                        object3 = ((zznf)pair.first).zzb();
                        Object object7 = object4;
                        URL uRL = new URL(((zznf)pair.first).zza());
                        object = string;
                        zzio2 = this.zzh();
                        zzio2.zzt();
                        zzio2.zzak();
                        Preconditions.checkNotNull((Object)uRL);
                        Preconditions.checkNotNull((Object)object7);
                        Preconditions.checkNotNull((Object)zznk2);
                        zzio2.zzl().zza((Runnable)new zzgk((zzgg)zzio2, (String)object, uRL, (byte[])object7, (Map)object3, zznk2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj().zzg().zza("Failed to parse upload URL. Not uploading. appId", zzfz.zza((String)string), (Object)((zznf)pair.first).zza());
                    }
                }
            } else {
                zzg zzg4;
                this.zzab = -1L;
                zzal zzal2 = this.zzf();
                this.zze();
                String string5 = zzal2.zza(l3 - com.google.android.gms.measurement.internal.zzag.zzh());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzg4 = this.zzf().zze(string5)) != null) {
                    this.zzb(zzg4);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    @VisibleForTesting
    private final void zza(String string, zzfu.zzg.zza zza2, Bundle bundle, @Nullable String string2) {
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        long l = zzny.zzg((String)zza2.zzf()) || zzny.zzg((String)string) ? (long)this.zze().zzb(string2, true) : (long)this.zze().zza(string2, true);
        long l2 = zza2.zzg().codePointCount(0, zza2.zzg().length());
        this.zzq();
        String string3 = zza2.zzf();
        this.zze();
        String string4 = zzny.zza((String)string3, (int)40, (boolean)true);
        if (l2 > l && !list.contains(zza2.zzf())) {
            if ("_ev".equals(zza2.zzf())) {
                this.zzq();
                String string5 = zzny.zza((String)zza2.zzg(), (int)this.zze().zzb(string2, true), (boolean)true);
                bundle.putString("_ev", string5);
                return;
            }
            this.zzj().zzv().zza("Param value is too long; discarded. Name, value length", (Object)string4, (Object)l2);
            if (bundle.getLong("_err") == 0L) {
                bundle.putLong("_err", 4L);
                if (bundle.getString("_ev") == null) {
                    bundle.putString("_ev", string4);
                    bundle.putLong("_el", l2);
                }
            }
            bundle.remove(zza2.zzf());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbd var1_1, zzo var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzt();
        this.zzs();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zznr.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzu().zza("Dropping blocked event. appId", zzfz.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzm(var5_4) != false || this.zzi().zzo(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zzny.zza((zznx)this.zzah, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zze(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzp(), var7_7.zzg());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbf.zzz.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzgd.zza((zzbd)var1_1);
        this.zzq().zza(var6_6, this.zze().zzb(var5_4));
        var7_8 = zzpn.zza() != false && this.zze().zza(zzbf.zzcc) != false ? this.zze().zza(var5_4, zzbf.zzaq, 10, 35) : 0;
        for (String var10_12 : new TreeSet<E>(var6_6.zzb.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzb.getParcelableArray(var10_12), var7_8, zzpn.zza() != false && this.zze().zza(zzbf.zzcc) != false);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzp().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        if (zzph.zza()) {
            this.zze().zza(zzbf.zzbz);
        }
        this.zzf().zzp();
        try {
            block74: {
                block75: {
                    block77: {
                        block81: {
                            block80: {
                                block78: {
                                    block79: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block77;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block78;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block79;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block80;
                                    }
                                    var25_19.zzj().zzu().zza("Data lost. Currency value is too big. appId", zzfz.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block81;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + (String)var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbf.zzae) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzt();
                                    var41_32.zzak();
                                    try {
                                        var41_32.e_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_33) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzfz.zza((String)var42_31), (Object)var44_33);
                                    }
                                    var33_29 = new zznv(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_34 = (Long)var33_29.zze;
                                    var33_29 = new zznv(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_34 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zznv)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzfz.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zzny.zza((zznx)var25_19.zzah, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var11_38 = zzny.zzh((String)var1_1.zza);
                    var12_39 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_40 = 1L + zzny.zza((zzbc)var1_1.zzb);
                    var15_41 = this.zzf().zza(this.zzx(), var5_4, var13_40, true, var11_38, false, var12_39, false, false);
                    v2 = var15_41.zzb;
                    this.zze();
                    var16_42 = v2 - (long)((Integer)zzbf.zzk.zza(null)).intValue();
                    if (var16_42 > 0L) {
                        if (var16_42 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzfz.zza((String)var5_4), (Object)var15_41.zzb);
                        }
                        this.zzf().zzw();
                        return;
                    }
                    if (var11_38) {
                        v3 = var15_41.zza;
                        this.zze();
                        var16_42 = v3 - (long)((Integer)zzbf.zzm.zza(null)).intValue();
                        if (var16_42 > 0L) {
                            if (var16_42 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzfz.zza((String)var5_4), (Object)var15_41.zza);
                            }
                            this.zzq();
                            zzny.zza((zznx)this.zzah, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzw();
                            return;
                        }
                    }
                    if (var12_39) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbf.zzl);
                        var16_42 = var15_41.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_42 > 0L) {
                            if (var16_42 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzfz.zza((String)var5_4), (Object)var15_41.zzd);
                            }
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var18_43 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_43, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzd(var5_4, var2_2.zzac)) {
                        this.zzq().zza(var18_43, "_dbg", (Object)1L);
                        this.zzq().zza(var18_43, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_44 = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_44.zze instanceof Long) {
                        this.zzq().zza(var18_43, "_sno", var19_44.zze);
                    }
                    if ((var19_45 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzu().zza("Data lost. Too many events stored on disk, deleted. appId", zzfz.zza((String)var5_4), (Object)var19_45);
                    }
                    var21_46 = new zzba(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_43);
                    var22_47 = this.zzf().zzd(var5_4, var21_46.zzb);
                    if (var22_47 == null) {
                        if (this.zzf().zzc(var5_4) >= (long)this.zze().zza(var5_4) && var11_38) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzfz.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_46.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zzny.zza((zznx)this.zzah, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_48 = new zzaz(var5_4, var21_46.zzb, 0L, 0L, var21_46.zzc, 0L, null, null, null, null);
                    } else {
                        var21_46 = var21_46.zza(this.zzm, var22_47.zzf);
                        var23_48 = var22_47.zza(var21_46.zzc);
                    }
                    this.zzf().zza(var23_48);
                    var27_17 = var2_2;
                    var26_18 = var21_46;
                    var25_19 = this;
                    var25_19.zzl().zzt();
                    var25_19.zzs();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzfu.zzj.zzv().zzh(1).zzp("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (zzql.zza() && !TextUtils.isEmpty((CharSequence)var27_17.zzv) && (var25_19.zze().zza(zzbf.zzbq) || var25_19.zze().zze(var27_17.zza, zzbf.zzbs))) {
                        var28_14.zzr(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzf(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzm(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zziq.zzb((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zzg());
                    if (var28_14.zzx().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (zzpz.zza() && var25_19.zze().zze(var27_17.zza, zzbf.zzce)) {
                        var25_19.zzq();
                        if (zzny.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var29_20.zzi() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_49 = var30_25;
                                var40_51 /* !! */  = zzfu.zzb.zza();
                                var40_51 /* !! */ .zzc((var37_49 & 1L) != 0L);
                                var40_51 /* !! */ .zze((var37_49 & 2L) != 0L);
                                var40_51 /* !! */ .zzf((var37_49 & 4L) != 0L);
                                var40_51 /* !! */ .zzg((var37_49 & 8L) != 0L);
                                var40_51 /* !! */ .zzb((var37_49 & 16L) != 0L);
                                var40_51 /* !! */ .zza((var37_49 & 32L) != 0L);
                                var40_51 /* !! */ .zzd((var37_49 & 64L) != 0L);
                                var28_14.zza((zzfu.zzb)((zzjv)var40_51 /* !! */ .zzah()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzc(var27_17.zzf);
                    }
                    var28_14.zzd(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzu();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if ((var31_52 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zziq.zzb((String)var27_17.zzt))).zzi() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_52)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzq((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc((Boolean)var32_23.second);
                        }
                        if (zzoj.zza() && var25_19.zze().zza(zzbf.zzcr) && !var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zze(var27_17.zza)) != null && var33_29.zzau()) {
                            var25_19.zza(var27_17.zza, false, null, null);
                            var34_35 = new Bundle();
                            if (var25_19.zze().zza(zzbf.zzdc)) {
                                var35_53 = var33_29.zzy();
                                if (var35_53 != null) {
                                    var34_35.putLong("_pfo", Math.max(0L, var35_53.longValue()));
                                }
                                if ((var36_27 = var33_29.zzz()) != null) {
                                    var34_35.putLong("_uwa", var36_27.longValue());
                                }
                            } else if (var25_19.zze().zza(zzbf.zzdb)) {
                                var35_54 = var25_19.zzf().zzb(var27_17.zza) - 1L;
                                var34_35.putLong("_pfo", Math.max(0L, var35_54));
                            }
                            var34_35.putLong("_r", 1L);
                            var25_19.zzah.zza(var27_17.zza, "_fx", var34_35);
                        }
                    }
                    var25_19.zzm.zzg().zzac();
                    v4 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzac();
                    v4.zzo(Build.VERSION.RELEASE).zzj((int)var25_19.zzm.zzg().zzg()).zzs(var25_19.zzm.zzg().zzh());
                    var28_14.zzj(var27_17.zzx);
                    if (var25_19.zzm.zzac()) {
                        var28_14.zzt();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zze(var27_17.zza)) == null) {
                        var32_24 = new zzg(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_52));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_52.zzi()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzq(0L);
                        var32_24.zzr(0L);
                        var32_24.zzp(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zzb(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzn(var27_17.zze);
                        var32_24.zzk(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzl(var27_17.zzr);
                        var42_31 = var32_24;
                        var25_19.zzf().zza((zzg)var42_31, false, false);
                    }
                    if (var31_52.zzj() && !TextUtils.isEmpty((CharSequence)var32_24.zzad())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzad()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzag())) {
                        var28_14.zzl((String)Preconditions.checkNotNull((Object)var32_24.zzag()));
                    }
                    var33_29 = var25_19.zzf().zzk(var27_17.zza);
                    for (var34_36 = 0; var34_36 < var33_29.size(); ++var34_36) {
                        var35_53 = zzfu.zzn.zze().zza(((zznv)var33_29.get((int)var34_36)).zzc).zzb(((zznv)var33_29.get((int)var34_36)).zzd);
                        var25_19.zzp().zza((zzfu.zzn.zza)var35_53, ((zznv)var33_29.get((int)var34_36)).zze);
                        var28_14.zza((zzfu.zzn.zza)var35_53);
                        if (!"_sid".equals(((zznv)var33_29.get((int)var34_36)).zzc) || var32_24.zzv() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzv()) continue;
                        var28_14.zzr();
                    }
                    try {
                        var34_37 = var25_19.zzf().zza((zzfu.zzj)((zzjv)var28_14.zzah()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzfz.zza((String)var28_14.zzt()), (Object)var36_28);
                        break block74;
                    }
                    v5 = var25_19.zzf();
                    var38_55 = var26_18;
                    var37_50 = var25_19;
                    if (var38_55.zze == null) ** GOTO lbl-1000
                    for (zzfu.zzb.zza var40_51 : var38_55.zze) {
                        if (!"_r".equals((Object)var40_51 /* !! */ )) continue;
                        v6 = true;
                        break block75;
                    }
                    var39_57 = var37_50.zzi().zzc(var38_55.zza, var38_55.zzb);
                    var40_51 /* !! */  = var37_50.zzf().zza(var37_50.zzx(), var38_55.zza, false, false, false, false, false, false);
                    if (var39_57 && var40_51 /* !! */ .zze < (long)var37_50.zze().zzc(var38_55.zza)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                }
                if (v5.zza((zzba)var26_18, var34_37, v6)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzw();
        }
        finally {
            this.zzf().zzu();
        }
        this.zzab();
        this.zzj().zzp().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zzh(zzo zzo2) {
        return !TextUtils.isEmpty((CharSequence)zzo2.zzb) || !TextUtils.isEmpty((CharSequence)zzo2.zzp);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @WorkerThread
    private final boolean zza(@Nullable String var1_1, long var2_2) {
        this.zzf().zzp();
        try {
            block164: {
                block168: {
                    block167: {
                        block162: {
                            var4_3 = new zza(null);
                            var34_4 = var4_3;
                            var32_6 = this.zzab;
                            var30_12 = var2_2;
                            var29_19 = null;
                            var28_20 = this.zzf();
                            Preconditions.checkNotNull((Object)var34_4);
                            var28_20.zzt();
                            var28_20.zzak();
                            var35_21 = null;
                            try {
                                var36_27 /* !! */  = var28_20.e_();
                                if (TextUtils.isEmpty(null)) {
                                    var38_33 = var32_6 != -1L ? new String[]{String.valueOf(var32_6), String.valueOf(var30_12)} : new String[]{String.valueOf(var30_12)};
                                    var47_35 = var32_6 != -1L ? "rowid <= ? and " : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select app_id, metadata_fingerprint from raw_events where " + var47_35 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block162;
                                    var29_19 = var35_21.getString(0);
                                    var37_36 = var35_21.getString(1);
                                    var35_21.close();
                                } else {
                                    var38_33 = var32_6 != -1L ? new String[]{null, String.valueOf(var32_6)} : new String[]{null};
                                    var47_35 = var32_6 != -1L ? " and rowid <= ?" : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + var47_35 + " order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block162;
                                    var37_36 = var35_21.getString(0);
                                    var35_21.close();
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{var29_19, var37_36}, null, null, "rowid", "2");
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzg().zza("Raw event metadata record is missing. appId", zzfz.zza((String)var29_19));
                                    break block162;
                                }
                                var38_33 = var35_21.getBlob(0);
                                try {
                                    var39_37 /* !! */  = (zzfu.zzj)((zzjv)zznr.zza(zzfu.zzj.zzv(), (byte[])var38_33).zzah());
                                }
                                catch (IOException var40_38) {
                                    var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzfz.zza((String)var29_19), (Object)var40_38);
                                    if (var35_21 != null) {
                                        var35_21.close();
                                    }
                                    break block162;
                                }
                                if (var35_21.moveToNext()) {
                                    var28_20.zzj().zzu().zza("Get multiple raw event metadata records, expected one. appId", zzfz.zza((String)var29_19));
                                }
                                var35_21.close();
                                var34_4.zza(var39_37 /* !! */ );
                                if (var32_6 != -1L) {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                                    var41_41 = new String[]{var29_19, var37_36, String.valueOf(var32_6)};
                                } else {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ?";
                                    var41_41 = new String[]{var29_19, var37_36};
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, var40_39, var41_41, null, null, "rowid", null);
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzu().zza("Raw event data disappeared while in transaction. appId", zzfz.zza((String)var29_19));
                                    break block162;
                                }
                                do {
                                    var42_42 = var35_21.getLong(0);
                                    var38_33 = var35_21.getBlob(3);
                                    try {
                                        var44_44 = zznr.zza(zzfu.zze.zze(), (byte[])var38_33);
                                    }
                                    catch (IOException var45_46) {
                                        var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzfz.zza((String)var29_19), (Object)var45_46);
                                        continue;
                                    }
                                    var44_44.zza(var35_21.getString(1)).zzb(var35_21.getLong(2));
                                    if (!var34_4.zza(var42_42, (zzfu.zze)((zzjv)var44_44.zzah()))) break;
                                } while (var35_21.moveToNext());
                            }
                            catch (SQLiteException var36_28) {
                                var28_20.zzj().zzg().zza("Data loss. Error selecting raw event. appId", zzfz.zza(var29_19), (Object)var36_28);
                            }
                            finally {
                                if (var35_21 != null) {
                                    var35_21.close();
                                }
                            }
                        }
                        var28_20 = var4_3;
                        if (var28_20.zzc == null || var28_20.zzc.isEmpty() != false) break block164;
                        var5_49 = false;
                        var6_50 = ((zzfu.zzj.zza)var4_3.zza.zzca()).zzk();
                        var7_51 = 0;
                        var8_52 = 0L;
                        var10_53 = null;
                        var11_54 = -1;
                        var12_55 = null;
                        var13_56 = -1;
                        for (var14_57 = 0; var14_57 < var4_3.zzc.size(); ++var14_57) {
                            block166: {
                                block165: {
                                    var15_58 = var5_49;
                                    var16_61 = (zzfu.zze.zza)var4_3.zzc.get(var14_57).zzca();
                                    if (this.zzi().zzd(var4_3.zza.zzy(), var16_61.zze())) {
                                        this.zzj().zzu().zza("Dropping blocked raw event. appId", zzfz.zza((String)var4_3.zza.zzy()), (Object)this.zzm.zzk().zza(var16_61.zze()));
                                        if (this.zzi().zzm(var4_3.zza.zzy()) != false || this.zzi().zzo(var4_3.zza.zzy()) != false || "_err".equals(var16_61.zze())) continue;
                                        this.zzq();
                                        zzny.zza((zznx)this.zzah, (String)var4_3.zza.zzy(), (int)11, (String)"_ev", (String)var16_61.zze(), (int)0);
                                        continue;
                                    }
                                    if (var16_61.zze().equals(zziu.zza((String)"_ai"))) {
                                        var16_61.zza("_ai");
                                        this.zzj().zzp().zza("Renaming ad_impression to _ai");
                                        if (this.zzj().zza(5)) {
                                            for (var17_64 = 0; var17_64 < var16_61.zza(); ++var17_64) {
                                                if (!"ad_platform".equals(var16_61.zzb(var17_64).zzg()) || var16_61.zzb(var17_64).zzh().isEmpty() || !"admob".equalsIgnoreCase(var16_61.zzb(var17_64).zzh())) continue;
                                                this.zzj().zzv().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                            }
                                        }
                                    }
                                    if ((var17_64 = this.zzi().zzc(var4_3.zza.zzy(), var16_61.zze())) != 0) break block165;
                                    this.zzp();
                                    var28_20 = var16_61.zze();
                                    Preconditions.checkNotEmpty((String)var28_20);
                                    var30_13 = var28_20;
                                    var31_96 = -1;
                                    switch (var30_13.hashCode()) {
                                        case 95027: {
                                            if (!var30_13.equals("_ui")) break;
                                            var31_96 = 0;
                                        }
                                    }
                                    switch (var31_96) {
                                        case 0: {
                                            v0 = true;
                                            break;
                                        }
                                        default: {
                                            v0 = false;
                                        }
                                    }
                                    if (!v0) break block166;
                                }
                                var18_70 = 0;
                                var19_75 = 0;
                                for (var20_79 = 0; var20_79 < var16_61.zza(); ++var20_79) {
                                    if ("_c".equals(var16_61.zzb(var20_79).zzg())) {
                                        var21_82 = (zzfu.zzg)((zzjv)((zzfu.zzg.zza)var16_61.zzb(var20_79).zzca()).zza(1L).zzah());
                                        var18_70 = 1;
                                        var16_61.zza(var20_79, var21_82);
                                        continue;
                                    }
                                    if (!"_r".equals(var16_61.zzb(var20_79).zzg())) continue;
                                    var21_82 = (zzfu.zzg)((zzjv)((zzfu.zzg.zza)var16_61.zzb(var20_79).zzca()).zza(1L).zzah());
                                    var19_75 = 1;
                                    var16_61.zza(var20_79, var21_82);
                                }
                                if (var18_70 == 0 && var17_64 != 0) {
                                    this.zzj().zzp().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzfu.zzg.zze().zza("_c").zza(1L));
                                }
                                if (var19_75 == 0) {
                                    this.zzj().zzp().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzfu.zzg.zze().zza("_r").zza(1L));
                                }
                                var5_49 = true;
                                if (this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzy(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false).zze > (long)this.zze().zzc(var4_3.zza.zzy())) {
                                    zzni.zza((zzfu.zze.zza)var16_61, "_r");
                                    var5_49 = var15_58;
                                }
                                if (zzny.zzh((String)var16_61.zze()) && var17_64 != 0 && this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzy(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(var4_3.zza.zzy(), zzbf.zzn)) {
                                    this.zzj().zzu().zza("Too many conversions. Not logging as conversion. appId", zzfz.zza((String)var4_3.zza.zzy()));
                                    var22_86 = false;
                                    var23_89 /* !! */  = null;
                                    var24_90 = -1;
                                    for (var25_93 = 0; var25_93 < var16_61.zza(); ++var25_93) {
                                        var26_95 = var16_61.zzb(var25_93);
                                        if ("_c".equals(var26_95.zzg())) {
                                            var23_89 /* !! */  = (zzfu.zzg.zza)var26_95.zzca();
                                            var24_90 = var25_93;
                                            continue;
                                        }
                                        if (!"_err".equals(var26_95.zzg())) continue;
                                        var22_86 = true;
                                    }
                                    if (var22_86 && var23_89 /* !! */  != null) {
                                        var16_61.zza(var24_90);
                                    } else if (var23_89 /* !! */  != null) {
                                        var25_94 = (zzfu.zzg)((zzjv)((zzfu.zzg.zza)((zzjv.zza)var23_89 /* !! */ .clone())).zza("_err").zza(10L).zzah());
                                        var16_61.zza(var24_90, var25_94);
                                    } else {
                                        this.zzj().zzg().zza("Did not find conversion parameter. appId", zzfz.zza((String)var4_3.zza.zzy()));
                                    }
                                }
                            }
                            if (var17_64 != 0) {
                                var29_19 = var16_61;
                                var28_20 = this;
                                var30_13 = new ArrayList<zzfu.zzg>(var29_19.zzf());
                                var31_96 = -1;
                                var32_7 = -1;
                                for (var33_101 = 0; var33_101 < var30_13.size(); ++var33_101) {
                                    if ("value".equals(((zzfu.zzg)var30_13.get(var33_101)).zzg())) {
                                        var31_96 = var33_101;
                                        continue;
                                    }
                                    if (!"currency".equals(((zzfu.zzg)var30_13.get(var33_101)).zzg())) continue;
                                    var32_7 = var33_101;
                                }
                                if (var31_96 != -1) {
                                    if (!((zzfu.zzg)var30_13.get(var31_96)).zzl() && !((zzfu.zzg)var30_13.get(var31_96)).zzj()) {
                                        var28_20.zzj().zzv().zza("Value must be specified with a numeric type.");
                                        var29_19.zza(var31_96);
                                        zzni.zza((zzfu.zze.zza)var29_19, "_c");
                                        zzni.zza((zzfu.zze.zza)var29_19, 18, "value");
                                    } else {
                                        var33_101 = 0;
                                        if (var32_7 == -1) {
                                            var33_101 = 1;
                                        } else {
                                            var34_4 = ((zzfu.zzg)var30_13.get(var32_7)).zzh();
                                            if (var34_4.length() != 3) {
                                                var33_101 = 1;
                                            } else {
                                                for (var35_22 = 0; var35_22 < var34_4.length(); var35_22 += Character.charCount(var36_29)) {
                                                    var36_29 = var34_4.codePointAt(var35_22);
                                                    if (Character.isLetter(var36_29)) continue;
                                                    var33_101 = 1;
                                                    break;
                                                }
                                            }
                                        }
                                        if (var33_101 != 0) {
                                            var28_20.zzj().zzv().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                            var29_19.zza(var31_96);
                                            zzni.zza((zzfu.zze.zza)var29_19, "_c");
                                            zzni.zza((zzfu.zze.zza)var29_19, 19, "currency");
                                        }
                                    }
                                }
                            }
                            if ("_e".equals(var16_61.zze())) {
                                this.zzp();
                                if (zznr.zza((zzfu.zze)((zzjv)var16_61.zzah()), "_fr") == null) {
                                    if (var12_55 != null && Math.abs(var12_55.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_71 = (zzfu.zze.zza)((zzjv.zza)var12_55.clone());
                                        if (this.zza((zzfu.zze.zza)var16_61, var18_71)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var13_56, var18_71);
                                        } else {
                                            var10_53 = var16_61;
                                            var11_54 = var7_51;
                                        }
                                    } else {
                                        var10_53 = var16_61;
                                        var11_54 = var7_51;
                                    }
                                }
                            } else if ("_vs".equals(var16_61.zze())) {
                                this.zzp();
                                if (zznr.zza((zzfu.zze)((zzjv)var16_61.zzah()), "_et") == null) {
                                    if (var10_53 != null && Math.abs(var10_53.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_72 = (zzfu.zze.zza)((zzjv.zza)var10_53.clone());
                                        if (this.zza(var18_72, (zzfu.zze.zza)var16_61)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var11_54, var18_72);
                                        } else {
                                            var12_55 = var16_61;
                                            var13_56 = var7_51;
                                        }
                                    } else {
                                        var12_55 = var16_61;
                                        var13_56 = var7_51;
                                    }
                                }
                            }
                            if (zzpi.zza() && this.zze().zza(zzbf.zzcu) && var16_61.zza() != 0) {
                                this.zzp();
                                var18_73 = zznr.zza(var16_61.zzf());
                                for (var19_75 = 0; var19_75 < var16_61.zza(); ++var19_75) {
                                    var20_80 = var16_61.zzb(var19_75);
                                    if (var20_80.zzg().equals("items") && !var20_80.zzi().isEmpty()) {
                                        var32_8 = var18_73;
                                        var31_97 = var4_3.zza.zzy();
                                        var30_14 = var16_61;
                                        var29_19 = var20_80;
                                        var28_20 = this;
                                        var33_102 = var29_19.zzi();
                                        var34_4 = new Bundle[var33_102.size()];
                                        for (var35_23 = 0; var35_23 < var33_102.size(); ++var35_23) {
                                            var36_30 = var33_102.get(var35_23);
                                            var28_20.zzp();
                                            var37_36 = zznr.zza(var36_30.zzi());
                                            for (zzfu.zzj var39_37 : var36_30.zzi()) {
                                                super.zza(var30_14.zze(), (zzfu.zzg.zza)var39_37 /* !! */ .zzca(), (Bundle)var37_36, var31_97);
                                            }
                                            var34_4[var35_23] = var37_36;
                                        }
                                        var32_8.putParcelableArray("items", (Parcelable[])var34_4);
                                        continue;
                                    }
                                    if (var20_80.zzg().equals("items")) continue;
                                    this.zza(var16_61.zze(), (zzfu.zzg.zza)var20_80.zzca(), var18_73, var4_3.zza.zzy());
                                }
                                var30_14 = var16_61;
                                var29_19 = var18_73;
                                var28_20 = this;
                                var30_14.zzd();
                                var34_4 = var29_19;
                                var33_103 = var28_20.zzp();
                                var35_24 = new ArrayList<zzfu.zzg>();
                                for (String var37_36 : var34_4.keySet()) {
                                    var38_33 = zzfu.zzg.zze().zza(var37_36);
                                    var39_37 /* !! */  = var34_4.get(var37_36);
                                    if (var39_37 /* !! */  == null) continue;
                                    var33_103.zza((zzfu.zzg.zza)var38_33, (Object)var39_37 /* !! */ );
                                    var35_24.add((zzfu.zzg)((zzjv)var38_33.zzah()));
                                }
                                var51_105 = var35_24;
                                var52_106 = var51_105.size();
                                for (var53_107 = 0; var53_107 < var52_106; ++var53_107) {
                                    v1 = var51_105.get(var53_107);
                                    var32_9 = (zzfu.zzg)v1;
                                    var30_14.zza(var32_9);
                                }
                            }
                            var4_3.zzc.set(var14_57, (zzfu.zze)((zzjv)var16_61.zzah()));
                            ++var7_51;
                            var6_50.zza((zzfu.zze.zza)var16_61);
                        }
                        for (var14_57 = 0; var14_57 < var7_51; ++var14_57) {
                            var15_59 = var6_50.zza(var14_57);
                            if ("_e".equals(var15_59.zzg())) {
                                this.zzp();
                                if (zznr.zza(var15_59, "_fr") != null) {
                                    var6_50.zzb(var14_57);
                                    --var7_51;
                                    --var14_57;
                                    continue;
                                }
                            }
                            this.zzp();
                            var16_61 = zznr.zza(var15_59, "_et");
                            if (var16_61 == null || (var17_66 = var16_61.zzl() != false ? Long.valueOf(var16_61.zzd()) : null) == null || var17_66 <= 0L) continue;
                            var8_52 += var17_66.longValue();
                        }
                        this.zza(var6_50, var8_52, false);
                        var14_57 = 0;
                        for (zzlk var16_61 : var6_50.zzaa()) {
                            if (!"_s".equals(var16_61.zzg())) continue;
                            var14_57 = 1;
                            break;
                        }
                        if (var14_57 != 0) {
                            this.zzf().zzh(var6_50.zzt(), "_se");
                        }
                        if (zznr.zza(var6_50, "_sid") >= 0) {
                            this.zza(var6_50, var8_52, true);
                        } else {
                            var16_62 = zznr.zza(var6_50, "_se");
                            if (var16_62 >= 0) {
                                var6_50.zzc(var16_62);
                                this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzfz.zza((String)var4_3.zza.zzy()));
                            }
                        }
                        this.zzp().zza(var6_50);
                        var30_15 = var6_50;
                        var29_19 = var4_3.zza.zzy();
                        var28_20 = this;
                        var28_20.zzl().zzt();
                        var28_20.zzs();
                        var31_98 /* !! */  = var28_20.zzf().zze((String)var29_19);
                        if (var31_98 /* !! */  == null) {
                            var28_20.zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzfz.zza((String)var29_19));
                        } else {
                            var28_20.zza(var31_98 /* !! */ , var30_15);
                        }
                        var28_20 = var6_50;
                        var28_20.zzi(0x7FFFFFFFFFFFFFFFL).zze(-9223372036854775808L);
                        for (var30_16 = 0; var30_16 < var28_20.zzc(); ++var30_16) {
                            var31_98 /* !! */  = var28_20.zza(var30_16);
                            if (var31_98 /* !! */ .zzd() < var28_20.zzf()) {
                                var28_20.zzi(var31_98 /* !! */ .zzd());
                            }
                            if (var31_98 /* !! */ .zzd() <= var28_20.zze()) continue;
                            var28_20.zze(var31_98 /* !! */ .zzd());
                        }
                        var6_50.zzs();
                        var16_63 = zziq.zza;
                        if (zzoe.zza() && this.zze().zza(zzbf.zzdf)) {
                            var16_63 = this.zzb(var4_3.zza.zzy()).zza(zziq.zzb((String)var4_3.zza.zzad()));
                            var17_67 = this.zzf().zzh(var4_3.zza.zzy());
                            this.zzf().zza(var4_3.zza.zzy(), var16_63);
                            if (!var16_63.zzj() && var17_67.zzj()) {
                                this.zzf().zzo(var4_3.zza.zzy());
                            } else if (var16_63.zzj() && !var17_67.zzj()) {
                                this.zzf().zzp(var4_3.zza.zzy());
                            }
                            var29_19 = var16_63;
                            var28_20 = var6_50;
                            if (!var29_19.zzi()) {
                                var28_20.zzq();
                                var28_20.zzm();
                                var28_20.zzj();
                            }
                            if (!var29_19.zzj()) {
                                var28_20.zzg();
                                var28_20.zzr();
                            }
                        }
                        if (zzpz.zza() && this.zze().zze(var4_3.zza.zzy(), zzbf.zzce)) {
                            this.zzq();
                            if (zzny.zzd((String)var4_3.zza.zzy()) && this.zzb(var4_3.zza.zzy()).zzi() && var4_3.zza.zzas()) {
                                var17_68 = this.zze().zze(var4_3.zza.zzy(), zzbf.zzck);
                                var18_70 = var17_68 != false ? var6_50.zzc() : var4_3.zzc.size();
                                for (var19_75 = 0; var19_75 < var18_70; ++var19_75) {
                                    var20_81 = var17_68 != false ? (zzfu.zze.zza)var6_50.zza(var19_75).zzca() : (zzfu.zze.zza)var4_3.zzc.get(var19_75).zzca();
                                    var21_84 = false;
                                    for (zzlk var23_89 : var20_81.zzf()) {
                                        if (!"_c".equals(var23_89 /* !! */ .zzg())) continue;
                                        var21_84 = true;
                                        break;
                                    }
                                    if (!var21_84) continue;
                                    if (var4_3.zza.zza() >= this.zze().zzb(var4_3.zza.zzy(), zzbf.zzav)) {
                                        var22_88 = null;
                                        if (this.zze().zze(var4_3.zza.zzy(), zzbf.zzcg)) {
                                            var22_88 = this.zzq().zzp();
                                            var23_89 /* !! */  = (zzfu.zzg)((zzjv)zzfu.zzg.zze().zza("_tu").zzb((String)var22_88).zzah());
                                            var20_81.zza((zzfu.zzg)var23_89 /* !! */ );
                                        }
                                        var23_89 /* !! */  = (zzfu.zzg)((zzjv)zzfu.zzg.zze().zza("_tr").zza(1L).zzah());
                                        var20_81.zza((zzfu.zzg)var23_89 /* !! */ );
                                        var24_92 = this.zze().zze(var4_3.zza.zzy(), zzbf.zzci) != false ? this.zzp().zza(var4_3.zza.zzy(), var6_50, var20_81, (String)var22_88) : this.zzp().zza(var4_3.zza.zzy(), var4_3.zza, var20_81, (String)var22_88);
                                        if (var24_92 != null) {
                                            this.zzj().zzp().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzy(), (Object)var24_92.zza);
                                            this.zzf().zza(var4_3.zza.zzy(), var24_92);
                                            this.zzr.add(var4_3.zza.zzy());
                                        }
                                    }
                                    var6_50.zza(var19_75, (zzfu.zze)((zzjv)var20_81.zzah()));
                                }
                            }
                        }
                        if (zzoe.zza() && this.zze().zza(zzbf.zzdf)) {
                            var6_50.zzh().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze(), var16_63.zzj() == false));
                        } else {
                            var6_50.zzh().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze()));
                        }
                        if (this.zze().zzl(var4_3.zza.zzy())) {
                            var30_17 = var4_3;
                            var29_19 = var6_50;
                            var28_20 = this;
                            var31_98 /* !! */  = new HashMap<K, V>();
                            var32_10 = new ArrayList<zzfu.zze>();
                            var33_104 = var28_20.zzq().zzv();
                            for (var34_5 = 0; var34_5 < var29_19.zzc(); ++var34_5) {
                                block163: {
                                    var35_25 = (zzfu.zze.zza)var29_19.zza(var34_5).zzca();
                                    if (var35_25.zze().equals("_ep")) {
                                        var28_20.zzp();
                                        var36_27 /* !! */  = (String)zznr.zzb((zzfu.zze)((zzjv)var35_25.zzah()), "_en");
                                        var37_36 = (zzaz)var31_98 /* !! */ .get(var36_27 /* !! */ );
                                        if (var37_36 == null && (var37_36 = var28_20.zzf().zzd(var30_17.zza.zzy(), (String)Preconditions.checkNotNull((Object)var36_27 /* !! */ ))) != null) {
                                            var31_98 /* !! */ .put(var36_27 /* !! */ , var37_36);
                                        }
                                        if (var37_36 != null && var37_36.zzi == null) {
                                            if (var37_36.zzj != null && var37_36.zzj > 1L) {
                                                var28_20.zzp();
                                                zznr.zza(var35_25, "_sr", var37_36.zzj);
                                            }
                                            if (var37_36.zzk != null && var37_36.zzk.booleanValue()) {
                                                var28_20.zzp();
                                                zznr.zza(var35_25, "_efs", 1L);
                                            }
                                            var32_10.add((zzfu.zze)((zzjv)var35_25.zzah()));
                                        }
                                        var29_19.zza(var34_5, var35_25);
                                        continue;
                                    }
                                    var36_32 = var28_20.zzi().zza(var30_17.zza.zzy());
                                    var28_20.zzq();
                                    var38_34 = zzny.zza((long)var35_25.zzc(), (long)var36_32);
                                    var40_40 = 1;
                                    var48_109 = 1L;
                                    var47_35 = "_dbg";
                                    var46_48 = (zzfu.zze)((zzjv)var35_25.zzah());
                                    if (TextUtils.isEmpty((CharSequence)var47_35) || var48_109 == null) {
                                        v2 = false;
                                    } else {
                                        for (zzfu.zzg var50_111 : var46_48.zzh()) {
                                            if (!var47_35.equals(var50_111.zzg())) continue;
                                            v2 = var48_109 instanceof Long != false && var48_109.equals(var50_111.zzd()) != false || var48_109 instanceof String != false && var48_109.equals(var50_111.zzh()) != false || var48_109 instanceof Double && var48_109.equals(var50_111.zza());
                                            break block163;
                                        }
                                        v2 = false;
                                    }
                                }
                                if (!v2) {
                                    var40_40 = var28_20.zzi().zzb(var30_17.zza.zzy(), var35_25.zze());
                                }
                                if (var40_40 <= 0) {
                                    var28_20.zzj().zzu().zza("Sample rate must be positive. event, rate", (Object)var35_25.zze(), (Object)var40_40);
                                    var32_10.add((zzfu.zze)((zzjv)var35_25.zzah()));
                                    var29_19.zza(var34_5, var35_25);
                                    continue;
                                }
                                var41_41 = (String[])var31_98 /* !! */ .get(var35_25.zze());
                                if (var41_41 == null && (var41_41 = var28_20.zzf().zzd(var30_17.zza.zzy(), var35_25.zze())) == null) {
                                    var28_20.zzj().zzu().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)var30_17.zza.zzy(), (Object)var35_25.zze());
                                    var41_41 = new zzaz(var30_17.zza.zzy(), var35_25.zze(), 1L, 1L, 1L, var35_25.zzc(), 0L, null, null, null, null);
                                }
                                var28_20.zzp();
                                var42_43 = (Long)zznr.zzb((zzfu.zze)((zzjv)var35_25.zzah()), "_eid");
                                var43_108 = var42_43 != null;
                                if (var40_40 == 1) {
                                    var32_10.add((zzfu.zze)((zzjv)var35_25.zzah()));
                                    if (var43_108.booleanValue() && (var41_41.zzi != null || var41_41.zzj != null || var41_41.zzk != null)) {
                                        var41_41 = var41_41.zza(null, null, null);
                                        var31_98 /* !! */ .put(var35_25.zze(), var41_41);
                                    }
                                    var29_19.zza(var34_5, var35_25);
                                    continue;
                                }
                                if (var33_104.nextInt(var40_40) == 0) {
                                    var28_20.zzp();
                                    zznr.zza(var35_25, "_sr", var40_40);
                                    var32_10.add((zzfu.zze)((zzjv)var35_25.zzah()));
                                    if (var43_108.booleanValue()) {
                                        var41_41 = var41_41.zza(null, Long.valueOf(var40_40), null);
                                    }
                                    var31_98 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                } else {
                                    if (var41_41.zzh != null) {
                                        var44_45 = var41_41.zzh;
                                    } else {
                                        var28_20.zzq();
                                        var44_45 = zzny.zza((long)var35_25.zzb(), (long)var36_32);
                                    }
                                    if (var44_45 != var38_34) {
                                        var28_20.zzp();
                                        zznr.zza(var35_25, "_efs", 1L);
                                        var28_20.zzp();
                                        zznr.zza(var35_25, "_sr", var40_40);
                                        var32_10.add((zzfu.zze)((zzjv)var35_25.zzah()));
                                        if (var43_108.booleanValue()) {
                                            var41_41 = var41_41.zza(null, Long.valueOf(var40_40), Boolean.valueOf(true));
                                        }
                                        var31_98 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                    } else if (var43_108.booleanValue()) {
                                        var31_98 /* !! */ .put(var35_25.zze(), var41_41.zza(var42_43, null, null));
                                    }
                                }
                                var29_19.zza(var34_5, var35_25);
                            }
                            if (var32_10.size() < var29_19.zzc()) {
                                var29_19.zzk().zzb(var32_10);
                            }
                            for (Map.Entry var35_26 : var31_98 /* !! */ .entrySet()) {
                                var28_20.zzf().zza((zzaz)var35_26.getValue());
                            }
                        }
                        var17_69 = var4_3.zza.zzy();
                        var18_74 = this.zzf().zze(var17_69);
                        if (var18_74 != null) break block167;
                        this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzfz.zza((String)var4_3.zza.zzy()));
                        break block168;
                    }
                    if (var6_50.zzc() <= 0) break block168;
                    var19_76 = var18_74.zzs();
                    if (var19_76 != 0L) {
                        var6_50.zzg(var19_76);
                    } else {
                        var6_50.zzo();
                    }
                    var21_85 = var18_74.zzu();
                    if (var21_85 == 0L) {
                        var21_85 = var19_76;
                    }
                    if (var21_85 != 0L) {
                        var6_50.zzh(var21_85);
                    } else {
                        var6_50.zzp();
                    }
                    if (!zzqr.zza() || !this.zze().zza(zzbf.zzbt)) ** GOTO lbl-1000
                    this.zzq();
                    if (zzny.zzf((String)var18_74.zzac())) {
                        var18_74.zza((long)var6_50.zzc());
                        var6_50.zzg((int)var18_74.zzr());
                    } else lbl-1000:
                    // 2 sources

                    {
                        var18_74.zzap();
                    }
                    var6_50.zzf((int)var18_74.zzt());
                    var18_74.zzr(var6_50.zzf());
                    var18_74.zzp(var6_50.zze());
                    var23_89 /* !! */  = var18_74.zzab();
                    if (var23_89 /* !! */  != null) {
                        var6_50.zzn((String)var23_89 /* !! */ );
                    } else {
                        var6_50.zzl();
                    }
                    this.zzf().zza(var18_74, false, false);
                }
                if (var6_50.zzc() > 0) {
                    var19_78 = this.zzi().zzc(var4_3.zza.zzy());
                    if (var19_78 == null || !var19_78.zzs()) {
                        if (var4_3.zza.zzai().isEmpty()) {
                            var6_50.zzb(-1L);
                        } else {
                            this.zzj().zzu().zza("Did not find measurement config or missing version info. appId", zzfz.zza((String)var4_3.zza.zzy()));
                        }
                    } else {
                        var6_50.zzb(var19_78.zzc());
                    }
                    this.zzf().zza((zzfu.zzj)((zzjv)var6_50.zzah()), var5_49);
                }
                var29_19 = var4_3.zzb;
                var28_20 = this.zzf();
                Preconditions.checkNotNull((Object)var29_19);
                var28_20.zzt();
                var28_20.zzak();
                var30_18 = new StringBuilder("rowid in (");
                for (var31_99 = 0; var31_99 < var29_19.size(); ++var31_99) {
                    if (var31_99 != 0) {
                        var30_18.append(",");
                    }
                    var30_18.append((Long)var29_19.get(var31_99));
                }
                var30_18.append(")");
                var32_11 = var28_20.e_().delete("raw_events", var30_18.toString(), null);
                if (var32_11 != var29_19.size()) {
                    var28_20.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)var32_11, (Object)var29_19.size());
                }
                var29_19 = var17_69;
                var28_20 = this.zzf();
                var30_18 = var28_20.e_();
                try {
                    var30_18.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{var29_19, var29_19});
                }
                catch (SQLiteException var31_100) {
                    var28_20.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzfz.zza((String)var29_19), (Object)var31_100);
                }
                this.zzf().zzw();
                return true;
            }
            this.zzf().zzw();
            return false;
        }
        finally {
            this.zzf().zzu();
        }
    }

    private final boolean zzac() {
        this.zzl().zzt();
        this.zzs();
        return this.zzf().zzx() || !TextUtils.isEmpty((CharSequence)this.zzf().f_());
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzad() {
        this.zzl().zzt();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzp().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(zzci.zza().zza(file, string));
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzp().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzu().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzfu.zze.zza zza2, zzfu.zze.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzfu.zzg zzg2 = zznr.zza((zzfu.zze)((zzjv)zza2.zzah()), "_sc");
        String string = zzg2 == null ? null : zzg2.zzh();
        this.zzp();
        zzfu.zzg zzg3 = zznr.zza((zzfu.zze)((zzjv)zza3.zzah()), "_pc");
        String string2 = zzg3 == null ? null : zzg3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzfu.zze.zza zza4 = zza3;
            zzfu.zze.zza zza5 = zza2;
            zzni zzni2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zzni2.zzp();
            zzfu.zzg zzg4 = zznr.zza((zzfu.zze)((zzjv)zza5.zzah()), "_et");
            if (zzg4 != null && zzg4.zzl() && zzg4.zzd() > 0L) {
                long l = zzg4.zzd();
                zzni2.zzp();
                zzg4 = zznr.zza((zzfu.zze)((zzjv)zza4.zzah()), "_et");
                if (zzg4 != null && zzg4.zzd() > 0L) {
                    l += zzg4.zzd();
                }
                zzni2.zzp();
                zznr.zza(zza4, "_et", l);
                zzni2.zzp();
                zznr.zza(zza5, "_fr", 1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    private final class zzb {
        final String zza;
        long zzb;

        private zzb(zzni zzni2) {
            this(zzni2, zzni2.zzq().zzp());
        }

        /* synthetic */ zzb(zzni zzni2, zznq zznq2) {
            this(zzni2);
        }

        private zzb(zzni zzni2, String string) {
            this.zza = string;
            this.zzb = zzni2.zzb().elapsedRealtime();
        }

        /* synthetic */ zzb(zzni zzni2, String string, zznq zznq2) {
            this(zzni2, string);
        }
    }

    private final class zza
    implements zzap {
        zzfu.zzj zza;
        List<Long> zzb;
        List<zzfu.zze> zzc;
        private long zzd;

        private static long zza(zzfu.zze zze2) {
            return zze2.zzd() / 1000L / 60L / 60L;
        }

        private zza() {
        }

        /* synthetic */ zza(zznp zznp2) {
            this();
        }

        @Override
        public final void zza(zzfu.zzj zzj2) {
            Preconditions.checkNotNull((Object)((Object)zzj2));
            this.zza = zzj2;
        }

        @Override
        public final boolean zza(long l, zzfu.zze zze2) {
            Preconditions.checkNotNull((Object)((Object)zze2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzfu.zze>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zzni$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzni$zza.zza(zze2)) {
                return false;
            }
            long l2 = this.zzd + (long)zze2.zzby();
            zzni.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbf.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zze2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zzni.this.zze();
            return n < Math.max(1, (Integer)zzbf.zzj.zza(null));
        }
    }
}

