/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.internal.measurement.zzji;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.android.gms.internal.measurement.zzlh;
import com.google.android.gms.internal.measurement.zzok;
import com.google.android.gms.internal.measurement.zzpz;
import com.google.android.gms.internal.measurement.zzql;
import com.google.android.gms.internal.measurement.zzqr;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zzne;
import com.google.android.gms.measurement.internal.zzni;
import com.google.android.gms.measurement.internal.zznu;
import com.google.android.gms.measurement.internal.zzny;
import com.google.android.gms.measurement.internal.zzo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zznr
extends zznd {
    static int zza(zzfu.zzj.zza zza2, String string) {
        if (zza2 == null) {
            return -1;
        }
        for (int i = 0; i < zza2.zzd(); ++i) {
            if (!string.equals(zza2.zzk(i).zzg())) continue;
            return i;
        }
        return -1;
    }

    final long zza(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zza(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzq().zzt();
        MessageDigest messageDigest = zzny.zzu();
        if (messageDigest == null) {
            this.zzj().zzg().zza("Failed to get MD5");
            return 0L;
        }
        return zzny.zza((byte[])messageDigest.digest(byArray));
    }

    private static Bundle zzb(List<zzfu.zzg> list) {
        Bundle bundle = new Bundle();
        for (zzfu.zzg zzg2 : list) {
            String string = zzg2.zzg();
            if (zzg2.zzj()) {
                bundle.putString(string, String.valueOf(zzg2.zza()));
                continue;
            }
            if (zzg2.zzk()) {
                bundle.putString(string, String.valueOf(zzg2.zzb()));
                continue;
            }
            if (zzg2.zzn()) {
                bundle.putString(string, zzg2.zzh());
                continue;
            }
            if (!zzg2.zzl()) continue;
            bundle.putString(string, String.valueOf(zzg2.zzd()));
        }
        return bundle;
    }

    static Bundle zza(List<zzfu.zzg> list) {
        Bundle bundle = new Bundle();
        for (zzfu.zzg zzg2 : list) {
            String string = zzg2.zzg();
            if (zzg2.zzj()) {
                bundle.putDouble(string, zzg2.zza());
                continue;
            }
            if (zzg2.zzk()) {
                bundle.putFloat(string, zzg2.zzb());
                continue;
            }
            if (zzg2.zzn()) {
                bundle.putString(string, zzg2.zzh());
                continue;
            }
            if (!zzg2.zzl()) continue;
            bundle.putLong(string, zzg2.zzd());
        }
        return bundle;
    }

    private final Bundle zza(Map<String, Object> map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) {
                bundle.putString(string, null);
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)object;
                zznr zznr2 = this;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                ArrayList arrayList3 = arrayList;
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList3.get(i);
                    Map map2 = (Map)e;
                    Bundle bundle2 = zznr2.zza(map2, false);
                    arrayList2.add(bundle2);
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, object.toString());
        }
        return bundle;
    }

    private static Bundle zzc(List<zzfu.zzn> list) {
        Bundle bundle = new Bundle();
        for (zzfu.zzn zzn2 : list) {
            String string = zzn2.zzg();
            if (zzn2.zzi()) {
                bundle.putString(string, String.valueOf(zzn2.zza()));
                continue;
            }
            if (zzn2.zzj()) {
                bundle.putString(string, String.valueOf(zzn2.zzb()));
                continue;
            }
            if (zzn2.zzm()) {
                bundle.putString(string, zzn2.zzh());
                continue;
            }
            if (!zzn2.zzk()) continue;
            bundle.putString(string, String.valueOf(zzn2.zzc()));
        }
        return bundle;
    }

    final <T extends Parcelable> @Nullable T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzj().zzg().zza("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    final zzbd zza(zzad zzad2) {
        Object object;
        Bundle bundle = this.zza(zzad2.zzc(), true);
        String string = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            string = object.toString();
        }
        if ((object = zziu.zzb((String)zzad2.zzb())) == null) {
            object = zzad2.zzb();
        }
        return new zzbd((String)object, new zzbc(bundle), string, zzad2.zza());
    }

    @TargetApi(value=30)
    final @Nullable zzna zza(String string, zzfu.zzj.zza zza2, zzfu.zze.zza zza3, @Nullable String string2) {
        if (!zzpz.zza() || !this.zze().zze(string, zzbf.zzce)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Set set = zznu.zza(this.zze().zzd(string, zzbf.zzbe).split(","));
        Uri.Builder builder = ((zzne)this).zzo().zza(string);
        zznr.zza(builder, "gmp_app_id", zza2.zzx(), (Set<String>)set);
        zznr.zza(builder, "gmp_version", "92000", (Set<String>)set);
        String string3 = zza2.zzu();
        if (this.zze().zze(string, zzbf.zzch) && ((zzne)this).zzm().zzp(string)) {
            string3 = "";
        }
        zznr.zza(builder, "app_instance_id", string3, (Set<String>)set);
        zznr.zza(builder, "rdid", zza2.zzz(), (Set<String>)set);
        zznr.zza(builder, "bundle_id", zza2.zzt(), (Set<String>)set);
        String string4 = zza3.zze();
        String string5 = zziu.zza((String)string4);
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            string4 = string5;
        }
        zznr.zza(builder, "app_event_name", string4, (Set<String>)set);
        zznr.zza(builder, "app_version", String.valueOf(zza2.zzb()), (Set<String>)set);
        String string6 = zza2.zzy();
        if (this.zze().zze(string, zzbf.zzch) && ((zzne)this).zzm().zzt(string)) {
            if (this.zze().zze(string, zzbf.zzbw)) {
                int n;
                if (!TextUtils.isEmpty((CharSequence)string6) && (n = string6.indexOf(".")) != -1) {
                    string6 = string6.substring(0, n);
                }
            } else {
                string6 = "";
            }
        }
        zznr.zza(builder, "os_version", string6, (Set<String>)set);
        zznr.zza(builder, "timestamp", String.valueOf(zza3.zzc()), (Set<String>)set);
        if (zza2.zzad()) {
            zznr.zza(builder, "lat", "1", (Set<String>)set);
        }
        zznr.zza(builder, "privacy_sandbox_version", String.valueOf(zza2.zza()), (Set<String>)set);
        zznr.zza(builder, "trigger_uri_source", "1", (Set<String>)set);
        zznr.zza(builder, "trigger_uri_timestamp", String.valueOf(l), (Set<String>)set);
        zznr.zza(builder, "request_uuid", string2, (Set<String>)set);
        Bundle bundle = zznr.zzb(zza3.zzf());
        String[] stringArray = this.zze().zzd(string, zzbf.zzbd).split("\\|");
        zznr.zza(builder, stringArray, bundle, (Set<String>)set);
        Bundle bundle2 = zznr.zzc(zza2.zzab());
        String[] stringArray2 = this.zze().zzd(string, zzbf.zzbc).split("\\|");
        zznr.zza(builder, stringArray2, bundle2, (Set<String>)set);
        zznr.zza(builder, "dma", zza2.zzac() ? "1" : "0", (Set<String>)set);
        if (!zza2.zzw().isEmpty()) {
            zznr.zza(builder, "dma_cps", zza2.zzw(), (Set<String>)set);
        }
        return new zzna(builder.build().toString(), l, 1);
    }

    @TargetApi(value=30)
    final @Nullable zzna zza(String string, zzfu.zzj zzj2, zzfu.zze.zza zza2, @Nullable String string2) {
        if (!zzpz.zza() || !this.zze().zze(string, zzbf.zzce)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Set set = zznu.zza(this.zze().zzd(string, zzbf.zzbe).split(","));
        Uri.Builder builder = ((zzne)this).zzo().zza(string);
        zznr.zza(builder, "gmp_app_id", zzj2.zzai(), (Set<String>)set);
        zznr.zza(builder, "gmp_version", "92000", (Set<String>)set);
        String string3 = zzj2.zzz();
        if (this.zze().zze(string, zzbf.zzch) && ((zzne)this).zzm().zzp(string)) {
            string3 = "";
        }
        zznr.zza(builder, "app_instance_id", string3, (Set<String>)set);
        zznr.zza(builder, "rdid", zzj2.zzam(), (Set<String>)set);
        zznr.zza(builder, "bundle_id", zzj2.zzy(), (Set<String>)set);
        String string4 = zza2.zze();
        String string5 = zziu.zza((String)string4);
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            string4 = string5;
        }
        zznr.zza(builder, "app_event_name", string4, (Set<String>)set);
        zznr.zza(builder, "app_version", String.valueOf(zzj2.zzb()), (Set<String>)set);
        String string6 = zzj2.zzak();
        if (this.zze().zze(string, zzbf.zzch) && ((zzne)this).zzm().zzt(string)) {
            if (this.zze().zze(string, zzbf.zzbw)) {
                int n;
                if (!TextUtils.isEmpty((CharSequence)string6) && (n = string6.indexOf(".")) != -1) {
                    string6 = string6.substring(0, n);
                }
            } else {
                string6 = "";
            }
        }
        zznr.zza(builder, "os_version", string6, (Set<String>)set);
        zznr.zza(builder, "timestamp", String.valueOf(zza2.zzc()), (Set<String>)set);
        if (zzj2.zzau()) {
            zznr.zza(builder, "lat", "1", (Set<String>)set);
        }
        zznr.zza(builder, "privacy_sandbox_version", String.valueOf(zzj2.zza()), (Set<String>)set);
        zznr.zza(builder, "trigger_uri_source", "1", (Set<String>)set);
        zznr.zza(builder, "trigger_uri_timestamp", String.valueOf(l), (Set<String>)set);
        zznr.zza(builder, "request_uuid", string2, (Set<String>)set);
        Bundle bundle = zznr.zzb(zza2.zzf());
        String[] stringArray = this.zze().zzd(string, zzbf.zzbd).split("\\|");
        zznr.zza(builder, stringArray, bundle, (Set<String>)set);
        Bundle bundle2 = zznr.zzc(zzj2.zzar());
        String[] stringArray2 = this.zze().zzd(string, zzbf.zzbc).split("\\|");
        zznr.zza(builder, stringArray2, bundle2, (Set<String>)set);
        zznr.zza(builder, "dma", zzj2.zzat() ? "1" : "0", (Set<String>)set);
        if (!zzj2.zzae().isEmpty()) {
            zznr.zza(builder, "dma_cps", zzj2.zzae(), (Set<String>)set);
        }
        return new zzna(builder.build().toString(), l, 1);
    }

    final zzfu.zze zza(zzba zzba2) {
        zzfu.zze.zza zza2 = zzfu.zze.zze().zza(zzba2.zzd);
        for (String string : zzba2.zze) {
            zzfu.zzg.zza zza3 = zzfu.zzg.zze().zza(string);
            Object object = zzba2.zze.zzc(string);
            Preconditions.checkNotNull((Object)object);
            this.zza(zza3, object);
            zza2.zza(zza3);
        }
        return (zzfu.zze)((zzjv)zza2.zzah());
    }

    static @Nullable zzfu.zzg zza(zzfu.zze zze2, String string) {
        for (zzfu.zzg zzg2 : zze2.zzh()) {
            if (!zzg2.zzg().equals(string)) continue;
            return zzg2;
        }
        return null;
    }

    static <BuilderT extends zzlh> BuilderT zza(BuilderT BuilderT, byte[] byArray) throws zzkd {
        zzji zzji2 = zzji.zza();
        if (zzji2 != null) {
            return (BuilderT)BuilderT.zza(byArray, zzji2);
        }
        return (BuilderT)BuilderT.zza(byArray);
    }

    static @Nullable Object zzb(zzfu.zze zze2, String string) {
        zzfu.zzg zzg2 = zznr.zza(zze2, string);
        if (zzg2 != null) {
            if (zzg2.zzn()) {
                return zzg2.zzh();
            }
            if (zzg2.zzl()) {
                return zzg2.zzd();
            }
            if (zzg2.zzj()) {
                return zzg2.zza();
            }
            if (zzg2.zzc() > 0) {
                List<zzfu.zzg> list = zzg2.zzi();
                ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                for (zzfu.zzg zzg3 : list) {
                    if (zzg3 == null) continue;
                    Bundle bundle = new Bundle();
                    for (zzfu.zzg zzg4 : zzg3.zzi()) {
                        if (zzg4.zzn()) {
                            bundle.putString(zzg4.zzg(), zzg4.zzh());
                            continue;
                        }
                        if (zzg4.zzl()) {
                            bundle.putLong(zzg4.zzg(), zzg4.zzd());
                            continue;
                        }
                        if (!zzg4.zzj()) continue;
                        bundle.putDouble(zzg4.zzg(), zzg4.zza());
                    }
                    if (bundle.isEmpty()) continue;
                    arrayList.add(bundle);
                }
                return arrayList.toArray(new Bundle[arrayList.size()]);
            }
        }
        return null;
    }

    final String zza(zzfu.zzi zzi2) {
        if (zzi2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzqr.zza() && this.zze().zza(zzbf.zzbt) && zzi2.zza() > 0) {
            this.zzq();
            if (zzny.zzf((String)zzi2.zza(0).zzy()) && zzi2.zzf()) {
                zznr.zza(stringBuilder, 0, "UploadSubdomain", zzi2.zzd());
            }
        }
        Iterator<zzfu.zzj> iterator = zzi2.zze().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator<zzfu.zzn> iterator2;
            StringBuilder stringBuilder2;
            int n;
            Object object2;
            zzfu.zzj zzj2;
            zzfu.zzj zzj3 = zzj2 = iterator.next();
            StringBuilder stringBuilder3 = stringBuilder;
            zznr zznr2 = this;
            if (zzj3 == null) continue;
            zznr.zza(stringBuilder3, 1);
            stringBuilder3.append("bundle {\n");
            if (zzj3.zzbm()) {
                zznr.zza(stringBuilder3, 1, "protocol_version", zzj3.zzf());
            }
            if (zzql.zza() && zznr2.zze().zze(zzj3.zzy(), zzbf.zzbs) && zzj3.zzbp()) {
                zznr.zza(stringBuilder3, 1, "session_stitching_token", zzj3.zzan());
            }
            zznr.zza(stringBuilder3, 1, "platform", zzj3.zzal());
            if (zzj3.zzbh()) {
                zznr.zza(stringBuilder3, 1, "gmp_version", zzj3.zzn());
            }
            if (zzj3.zzbu()) {
                zznr.zza(stringBuilder3, 1, "uploading_gmp_version", zzj3.zzt());
            }
            if (zzj3.zzbf()) {
                zznr.zza(stringBuilder3, 1, "dynamite_version", zzj3.zzl());
            }
            if (zzj3.zzaz()) {
                zznr.zza(stringBuilder3, 1, "config_version", zzj3.zzj());
            }
            zznr.zza(stringBuilder3, 1, "gmp_app_id", zzj3.zzai());
            zznr.zza(stringBuilder3, 1, "admob_app_id", zzj3.zzx());
            zznr.zza(stringBuilder3, 1, "app_id", zzj3.zzy());
            zznr.zza(stringBuilder3, 1, "app_version", zzj3.zzab());
            if (zzj3.zzaw()) {
                zznr.zza(stringBuilder3, 1, "app_version_major", zzj3.zzb());
            }
            zznr.zza(stringBuilder3, 1, "firebase_instance_id", zzj3.zzah());
            if (zzj3.zzbe()) {
                zznr.zza(stringBuilder3, 1, "dev_cert_hash", zzj3.zzk());
            }
            zznr.zza(stringBuilder3, 1, "app_store", zzj3.zzaa());
            if (zzj3.zzbt()) {
                zznr.zza(stringBuilder3, 1, "upload_timestamp_millis", zzj3.zzs());
            }
            if (zzj3.zzbq()) {
                zznr.zza(stringBuilder3, 1, "start_timestamp_millis", zzj3.zzq());
            }
            if (zzj3.zzbg()) {
                zznr.zza(stringBuilder3, 1, "end_timestamp_millis", zzj3.zzm());
            }
            if (zzj3.zzbl()) {
                zznr.zza(stringBuilder3, 1, "previous_bundle_start_timestamp_millis", zzj3.zzp());
            }
            if (zzj3.zzbk()) {
                zznr.zza(stringBuilder3, 1, "previous_bundle_end_timestamp_millis", zzj3.zzo());
            }
            zznr.zza(stringBuilder3, 1, "app_instance_id", zzj3.zzz());
            zznr.zza(stringBuilder3, 1, "resettable_device_id", zzj3.zzam());
            zznr.zza(stringBuilder3, 1, "ds_id", zzj3.zzag());
            if (zzj3.zzbj()) {
                zznr.zza(stringBuilder3, 1, "limited_ad_tracking", zzj3.zzau());
            }
            zznr.zza(stringBuilder3, 1, "os_version", zzj3.zzak());
            zznr.zza(stringBuilder3, 1, "device_model", zzj3.zzaf());
            zznr.zza(stringBuilder3, 1, "user_default_language", zzj3.zzao());
            if (zzj3.zzbs()) {
                zznr.zza(stringBuilder3, 1, "time_zone_offset_minutes", zzj3.zzh());
            }
            if (zzj3.zzay()) {
                zznr.zza(stringBuilder3, 1, "bundle_sequential_index", zzj3.zzc());
            }
            if (zzqr.zza()) {
                zznr2.zzq();
                if (zzny.zzf((String)zzj3.zzy()) && zznr2.zze().zza(zzbf.zzbt) && zzj3.zzbd()) {
                    zznr.zza(stringBuilder3, 1, "delivery_index", zzj3.zzd());
                }
            }
            if (zzj3.zzbo()) {
                zznr.zza(stringBuilder3, 1, "service_upload", zzj3.zzav());
            }
            zznr.zza(stringBuilder3, 1, "health_monitor", zzj3.h_());
            if (zzj3.zzbn()) {
                zznr.zza(stringBuilder3, 1, "retry_counter", zzj3.zzg());
            }
            if (zzj3.zzbb()) {
                zznr.zza(stringBuilder3, 1, "consent_signals", zzj3.zzad());
            }
            if (zzj3.zzbi()) {
                zznr.zza(stringBuilder3, 1, "is_dma_region", zzj3.zzat());
            }
            if (zzj3.zzbc()) {
                zznr.zza(stringBuilder3, 1, "core_platform_services", zzj3.zzae());
            }
            if (zzj3.zzba()) {
                zznr.zza(stringBuilder3, 1, "consent_diagnostics", zzj3.zzac());
            }
            if (zzj3.zzbr()) {
                zznr.zza(stringBuilder3, 1, "target_os_version", zzj3.zzr());
            }
            if (zzpz.zza() && zznr2.zze().zze(zzj3.zzy(), zzbf.zzce)) {
                zznr.zza(stringBuilder3, 1, "ad_services_version", zzj3.zza());
                if (zzj3.zzax()) {
                    object2 = zzj3.zzu();
                    n = 1;
                    stringBuilder2 = stringBuilder3;
                    if (object2 != null) {
                        ++n;
                        zznr.zza(stringBuilder2, 2);
                        stringBuilder2.append("attribution_eligibility_status {\n");
                        zznr.zza(stringBuilder2, 2, "eligible", ((zzfu.zzb)((Object)object2)).zzf());
                        zznr.zza(stringBuilder2, 2, "no_access_adservices_attribution_permission", ((zzfu.zzb)((Object)object2)).zzh());
                        zznr.zza(stringBuilder2, 2, "pre_r", ((zzfu.zzb)((Object)object2)).zzi());
                        zznr.zza(stringBuilder2, 2, "r_extensions_too_old", ((zzfu.zzb)((Object)object2)).zzj());
                        zznr.zza(stringBuilder2, 2, "adservices_extension_too_old", ((zzfu.zzb)((Object)object2)).zze());
                        zznr.zza(stringBuilder2, 2, "ad_storage_not_allowed", ((zzfu.zzb)((Object)object2)).zzd());
                        zznr.zza(stringBuilder2, 2, "measurement_manager_disabled", ((zzfu.zzb)((Object)object2)).zzg());
                        zznr.zza(stringBuilder2, 2);
                        stringBuilder2.append("}\n");
                    }
                }
            }
            object2 = zzj3.zzar();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zznr zznr3 = zznr2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    if (object == null) continue;
                    zznr.zza(stringBuilder2, 2);
                    stringBuilder2.append("user_property {\n");
                    zznr.zza(stringBuilder2, 2, "set_timestamp_millis", object.zzl() ? Long.valueOf(object.zzd()) : null);
                    zznr.zza(stringBuilder2, 2, "name", zznr3.zzi().zzc(object.zzg()));
                    zznr.zza(stringBuilder2, 2, "string_value", object.zzh());
                    zznr.zza(stringBuilder2, 2, "int_value", object.zzk() ? Long.valueOf(object.zzc()) : null);
                    zznr.zza(stringBuilder2, 2, "double_value", object.zzi() ? Double.valueOf(object.zza()) : null);
                    zznr.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            List<zzfu.zzc> list = zzj3.zzap();
            zzj3.zzy();
            object2 = list;
            n = 1;
            stringBuilder2 = stringBuilder3;
            if (object2 != null) {
                ++n;
                object = object2.iterator();
                while (object.hasNext()) {
                    zzfu.zzc zzc2 = (zzfu.zzc)((Object)object.next());
                    if (zzc2 == null) continue;
                    zznr.zza(stringBuilder2, 2);
                    stringBuilder2.append("audience_membership {\n");
                    if (zzc2.zzg()) {
                        zznr.zza(stringBuilder2, 2, "audience_id", zzc2.zza());
                    }
                    if (zzc2.zzh()) {
                        zznr.zza(stringBuilder2, 2, "new_audience", zzc2.zzf());
                    }
                    zznr.zza(stringBuilder2, 2, "current_data", zzc2.zzd());
                    if (zzc2.zzi()) {
                        zznr.zza(stringBuilder2, 2, "previous_data", zzc2.zze());
                    }
                    zznr.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            object2 = zzj3.zzaq();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zznr3 = zznr2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzfu.zze)((Object)iterator2.next());
                    if (object == null) continue;
                    zznr.zza(stringBuilder2, 2);
                    stringBuilder2.append("event {\n");
                    zznr.zza(stringBuilder2, 2, "name", zznr3.zzi().zza(((zzfu.zze)((Object)object)).zzg()));
                    if (((zzfu.zze)((Object)object)).zzk()) {
                        zznr.zza(stringBuilder2, 2, "timestamp_millis", ((zzfu.zze)((Object)object)).zzd());
                    }
                    if (((zzfu.zze)((Object)object)).zzj()) {
                        zznr.zza(stringBuilder2, 2, "previous_timestamp_millis", ((zzfu.zze)((Object)object)).zzc());
                    }
                    if (((zzfu.zze)((Object)object)).zzi()) {
                        zznr.zza(stringBuilder2, 2, "count", ((zzfu.zze)((Object)object)).zza());
                    }
                    if (((zzfu.zze)((Object)object)).zzb() != 0) {
                        zznr3.zza(stringBuilder2, 2, ((zzfu.zze)((Object)object)).zzh());
                    }
                    zznr.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            zznr.zza(stringBuilder3, 1);
            stringBuilder3.append("}\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzfi.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zzb2.zzl()) {
            zznr.zza(stringBuilder, 0, "filter_id", zzb2.zzb());
        }
        zznr.zza(stringBuilder, 0, "event_name", this.zzi().zza(zzb2.zzf()));
        String string = zznr.zza(zzb2.zzh(), zzb2.zzi(), zzb2.zzj());
        if (!string.isEmpty()) {
            zznr.zza(stringBuilder, 0, "filter_type", string);
        }
        if (zzb2.zzk()) {
            zznr.zza(stringBuilder, 1, "event_count_filter", zzb2.zze());
        }
        if (zzb2.zza() > 0) {
            stringBuilder.append("  filters {\n");
            for (zzfi.zzc zzc2 : zzb2.zzg()) {
                this.zza(stringBuilder, 2, zzc2);
            }
        }
        zznr.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    final String zza(zzfi.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zze2.zzi()) {
            zznr.zza(stringBuilder, 0, "filter_id", zze2.zza());
        }
        zznr.zza(stringBuilder, 0, "property_name", this.zzi().zzc(zze2.zze()));
        String string = zznr.zza(zze2.zzf(), zze2.zzg(), zze2.zzh());
        if (!string.isEmpty()) {
            zznr.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zze2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzj().zzu().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzj().zzu().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final @Nullable List<Integer> zzu() {
        Map map = zzbf.zza((Context)this.zzf.zza());
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzbf.zzap.zza(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzj().zzu().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzu().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final Map<String, Object> zza(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : bundle.keySet()) {
            Object object;
            Object object2 = object = bundle.get(string);
            if (object instanceof Parcelable[] || object2 instanceof ArrayList || object2 instanceof Bundle) {
                if (!bl) continue;
                Object object3 = object;
                object2 = this;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                if (object3 instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object3) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(((zznr)((Object)object2)).zza((Bundle)parcelable, false));
                    }
                } else if (object3 instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object3;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        Object e2 = e;
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(((zznr)((Object)object2)).zza((Bundle)e2, false));
                    }
                } else if (object3 instanceof Bundle) {
                    arrayList.add(((zznr)((Object)object2)).zza((Bundle)object3, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zznr(zzni zzni2) {
        super(zzni2);
    }

    static void zza(zzfu.zze.zza zza2, String string, Object object) {
        List<zzfu.zzg> list = zza2.zzf();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            n = i;
            break;
        }
        zzfu.zzg.zza zza3 = zzfu.zzg.zze().zza(string);
        if (object instanceof Long) {
            zza3.zza((Long)object);
        } else if (object instanceof String) {
            zza3.zzb((String)object);
        } else if (object instanceof Double) {
            zza3.zza((Double)object);
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    private static void zza(Uri.Builder builder, String[] stringArray, Bundle bundle, Set<String> set) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            String string = stringArray2[0];
            String string2 = stringArray2[stringArray2.length - 1];
            String string3 = bundle.getString(string);
            if (string3 == null) continue;
            zznr.zza(builder, string2, string3, set);
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfu.zzl zzl2) {
        int n2;
        if (zzl2 == null) {
            return;
        }
        ++n;
        zznr.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzl2.zzb() != 0) {
            zznr.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long object : zzl2.zzi()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzl2.zzd() != 0) {
            zznr.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzl2.zzk()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzl2.zza() != 0) {
            zznr.zza(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            n2 = 0;
            for (zzfu.zzd zzd2 : zzl2.zzh()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzd2.zzf() ? Integer.valueOf(zzd2.zza()) : null).append(":").append(zzd2.zze() ? Long.valueOf(zzd2.zzb()) : null);
            }
            stringBuilder.append("}\n");
        }
        if (zzl2.zzc() != 0) {
            zznr.zza(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            n2 = 0;
            for (zzfu.zzm zzm2 : zzl2.zzj()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzm2.zzf() ? Integer.valueOf(zzm2.zzb()) : null).append(": [");
                int n3 = 0;
                for (long l : zzm2.zze()) {
                    if (n3++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                }
                stringBuilder.append("]");
            }
            stringBuilder.append("}\n");
        }
        zznr.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, List<zzfu.zzg> list) {
        if (list == null) {
            return;
        }
        ++n;
        for (zzfu.zzg zzg2 : list) {
            if (zzg2 == null) continue;
            zznr.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zznr.zza(stringBuilder, n, "name", zzg2.zzm() ? this.zzi().zzb(zzg2.zzg()) : null);
            zznr.zza(stringBuilder, n, "string_value", zzg2.zzn() ? zzg2.zzh() : null);
            zznr.zza(stringBuilder, n, "int_value", zzg2.zzl() ? Long.valueOf(zzg2.zzd()) : null);
            zznr.zza(stringBuilder, n, "double_value", zzg2.zzj() ? Double.valueOf(zzg2.zza()) : null);
            if (zzg2.zzc() > 0) {
                this.zza(stringBuilder, n, zzg2.zzi());
            }
            zznr.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfi.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zznr.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzc2.zzg()) {
            zznr.zza(stringBuilder, n, "complement", zzc2.zzf());
        }
        if (zzc2.zzi()) {
            zznr.zza(stringBuilder, n, "param_name", this.zzi().zzb(zzc2.zze()));
        }
        if (zzc2.zzj()) {
            zzfi.zzf zzf2 = zzc2.zzd();
            String string = "string_filter";
            int n2 = n + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            if (zzf2 != null) {
                zznr.zza(stringBuilder2, n2);
                stringBuilder2.append(string);
                stringBuilder2.append(" {\n");
                if (zzf2.zzj()) {
                    zznr.zza(stringBuilder2, n2, "match_type", zzf2.zzb().name());
                }
                if (zzf2.zzi()) {
                    zznr.zza(stringBuilder2, n2, "expression", zzf2.zze());
                }
                if (zzf2.zzh()) {
                    zznr.zza(stringBuilder2, n2, "case_sensitive", zzf2.zzg());
                }
                if (zzf2.zza() > 0) {
                    zznr.zza(stringBuilder2, n2 + 1);
                    stringBuilder2.append("expression_list {\n");
                    for (String string2 : zzf2.zzf()) {
                        zznr.zza(stringBuilder2, n2 + 2);
                        stringBuilder2.append(string2);
                        stringBuilder2.append("\n");
                    }
                    stringBuilder2.append("}\n");
                }
                zznr.zza(stringBuilder2, n2);
                stringBuilder2.append("}\n");
            }
        }
        if (zzc2.zzh()) {
            zznr.zza(stringBuilder, n + 1, "number_filter", zzc2.zzc());
        }
        zznr.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfi.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zznr.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzh()) {
            zznr.zza(stringBuilder, n, "comparison_type", zzd2.zza().name());
        }
        if (zzd2.zzj()) {
            zznr.zza(stringBuilder, n, "match_as_float", zzd2.zzg());
        }
        if (zzd2.zzi()) {
            zznr.zza(stringBuilder, n, "comparison_value", zzd2.zzd());
        }
        if (zzd2.zzl()) {
            zznr.zza(stringBuilder, n, "min_comparison_value", zzd2.zzf());
        }
        if (zzd2.zzk()) {
            zznr.zza(stringBuilder, n, "max_comparison_value", zzd2.zze());
        }
        zznr.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(Uri.Builder builder, String string, @Nullable String string2, Set<String> set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, @Nullable Object object) {
        if (object == null) {
            return;
        }
        zznr.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final void zza(zzfu.zzj.zza zza2) {
        this.zzj().zzp().zza("Checking account type status for ad personalization signals");
        if (this.zzc(zza2.zzt())) {
            this.zzj().zzc().zza("Turning off ad personalization due to account type");
            zzfu.zzn zzn2 = (zzfu.zzn)((zzjv)zzfu.zzn.zze().zza("_npa").zzb(this.zzf().zzc()).zza(1L).zzah());
            boolean bl = false;
            for (int i = 0; i < zza2.zzd(); ++i) {
                if (!"_npa".equals(zza2.zzk(i).zzg())) continue;
                zza2.zza(i, zzn2);
                bl = true;
                break;
            }
            if (!bl) {
                zza2.zza(zzn2);
            }
            zzah zzah2 = zzah.zza(zza2.zzv());
            zzah2.zza(zziq.zza.zzd, zzak.zzg);
            zza2.zzf(zzah2.toString());
        }
    }

    final void zza(zzfu.zzg.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zze().zzc().zzb().zzd();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        if (object instanceof Bundle[]) {
            Bundle[] bundleArray = (Bundle[])object;
            ArrayList<zzfu.zzg> arrayList = new ArrayList<zzfu.zzg>();
            Bundle[] bundleArray2 = bundleArray;
            int n = bundleArray.length;
            for (int i = 0; i < n; ++i) {
                Bundle bundle = bundleArray2[i];
                if (bundle == null) continue;
                zzfu.zzg.zza zza3 = zzfu.zzg.zze();
                for (String string : bundle.keySet()) {
                    zzfu.zzg.zza zza4 = zzfu.zzg.zze().zza(string);
                    Object object2 = bundle.get(string);
                    if (object2 instanceof Long) {
                        zza4.zza((Long)object2);
                    } else if (object2 instanceof String) {
                        zza4.zzb((String)object2);
                    } else {
                        if (!(object2 instanceof Double)) continue;
                        zza4.zza((Double)object2);
                    }
                    zza3.zza(zza4);
                }
                if (zza3.zza() <= 0) continue;
                arrayList.add((zzfu.zzg)((zzjv)zza3.zzah()));
            }
            zza2.zza(arrayList);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) event param value", object);
    }

    final void zza(zzfu.zzn.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzc().zzb().zza();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) user attribute value", object);
    }

    @WorkerThread
    static boolean zza(zzbd zzbd2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzbd2);
        Preconditions.checkNotNull((Object)zzo2);
        return !TextUtils.isEmpty((CharSequence)zzo2.zzb) || !TextUtils.isEmpty((CharSequence)zzo2.zzp);
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zza(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzb().currentTimeMillis() - l) > l2;
    }

    static boolean zzb(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzc(String string) {
        if (zzok.zza() && this.zze().zza(zzbf.zzcv)) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        zzg zzg2 = ((zzne)this).zzh().zze(string);
        if (zzg2 == null) {
            return false;
        }
        return this.zzf().zzn() && zzg2.zzaq() && ((zzne)this).zzm().zzk(string);
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }
}

